import{s as p_,n as c_,o as T_}from"../chunks/scheduler.0219f8bd.js";import{S as f_,i as h_,g as r,s as o,r as u,A as __,h as i,f as l,c as n,j as h,u as m,x as d,k as a,y as $_,a as s,v as p,d as c,t as T,w as f}from"../chunks/index.f61edf3b.js";import{C as En}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as b_}from"../chunks/EditOnGithub.48fa589f.js";function v_(jT){let $,In,Jn,qn,b,Kn,v,Bn,y,ET="Helper module for <code>Tensor</code> processing.",Nn,M,JT=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Qn,x,DT='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.rand"><code>.rand(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',Vn,Sn,On,C,Fn,H,Yn,L,IT='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Wn,w,qT='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li>',Gn,Xn,Zn,A,er,g,tr,z,KT="Create a new Tensor or copy an existing Tensor.",lr,P,BT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",sr,or,nr,R,rr,U,ir,k,NT="Dimensions of the tensor.",dr,j,QT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ar,ur,mr,E,pr,J,cr,D,VT="Type of the tensor.",Tr,I,ST='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',fr,hr,_r,q,$r,K,br,B,OT="The data stored in the tensor.",vr,N,FT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',yr,Mr,xr,Q,Cr,V,Hr,S,YT="The number of elements in the tensor.",Lr,O,WT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',wr,Ar,gr,F,zr,Y,Pr,W,GT="The location of the tensor data.",Rr,G,XT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ur,kr,jr,X,Er,Z,Jr,ee,ZT=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Dr,te,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Ir,qr,Kr,le,Br,se,Nr,oe,tf="Index into a Tensor object.",Qr,ne,lf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The data at the specified index.',Vr,re,sf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Sr,Or,Fr,ie,Yr,de,Wr,ae,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',Gr,ue,nf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",Xr,Zr,ei,me,ti,pe,li,ce,rf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',si,Te,df="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",oi,ni,ri,fe,ii,he,di,_e,af=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,ai,$e,uf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',ui,be,mf="<li><code>Error</code> If the tensor has more than one element.</li>",mi,pi,ci,ve,Ti,ye,fi,Me,pf="Convert tensor data to a n-dimensional JS list",hi,xe,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',_i,$i,bi,Ce,vi,He,yi,Le,Tf="Return a new Tensor with the sigmoid function applied to each element.",Mi,we,ff='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the sigmoid function applied.',xi,Ci,Hi,Ae,Li,ge,wi,ze,hf="Applies the sigmoid function to the tensor in place.",Ai,Pe,_f='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',gi,zi,Pi,Re,Ri,Ue,Ui,ke,$f="Return a new Tensor with a callback function applied to each element.",ki,je,bf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the callback function applied to each element.',ji,Ee,vf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Ei,Ji,Di,Je,Ii,De,qi,Ie,yf="Apply a callback function to each element of the tensor in place.",Ki,qe,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Bi,Ke,xf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Ni,Qi,Vi,Be,Si,Ne,Oi,Qe,Cf="Return a new Tensor with every element multiplied by a constant.",Fi,Ve,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Yi,Se,Lf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Wi,Gi,Xi,Oe,Zi,Fe,ed,Ye,wf="Multiply the tensor by a constant in place.",td,We,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',ld,Ge,gf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",sd,od,nd,Xe,rd,Ze,id,et,zf="Return a new Tensor with every element divided by a constant.",dd,tt,Pf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',ad,lt,Rf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",ud,md,pd,st,cd,ot,Td,nt,Uf="Divide the tensor by a constant in place.",fd,rt,kf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',hd,it,jf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",_d,$d,bd,dt,vd,at,yd,ut,Ef="Return a new Tensor with every element added by a constant.",Md,mt,Jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',xd,pt,Df="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Cd,Hd,Ld,ct,wd,Tt,Ad,ft,If="Add the tensor by a constant in place.",gd,ht,qf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',zd,_t,Kf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Pd,Rd,Ud,$t,kd,bt,jd,vt,Bf="Return a new Tensor with every element subtracted by a constant.",Ed,yt,Nf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Jd,Mt,Qf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Dd,Id,qd,xt,Kd,Ct,Bd,Ht,Vf="Subtract the tensor by a constant in place.",Nd,Lt,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Qd,wt,Of="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Vd,Sd,Od,At,Fd,gt,Yd,zt,Ff="Creates a deep copy of the current Tensor.",Wd,Pt,Yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the same type, data, and dimensions as the original.',Gd,Xd,Zd,Rt,ea,Ut,ta,kt,Wf="Performs a slice operation on the Tensor along specified dimensions.",la,jt,Gf="Consider a Tensor that has a dimension of [4, 7]:",sa,Et,oa,Jt,Xf=`We can slice against the two dims of row and column, for instance in this
case we can start at the second element, and return to the second last,
like this:`,na,Dt,ra,It,Zf="which would return:",ia,qt,da,Kt,eh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor containing the selected elements.<br/> <strong>Throws</strong>:',aa,Bt,th="<li><code>Error</code> If the slice input is invalid.</li>",ua,Nt,lh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...slices</td><td><code>number</code> | <code>Array&lt;number&gt;</code> | <code>null</code></td><td><p>The slice specifications for each dimension.</p> <ul><li>If a number is given, then a single element is selected.</li> <li>If an array of two numbers is given, then a range of elements [start, end (exclusive)] is selected.</li> <li>If null is given, then the entire dimension is selected.</li></ul></td></tr></tbody>",ma,pa,ca,Qt,Ta,Vt,fa,St,sh="Return a permuted version of this Tensor, according to the provided dimensions.",ha,Ot,oh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',_a,Ft,nh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",$a,ba,va,Yt,ya,Wt,Ma,Gt,rh="Returns the sum of each row of the input tensor in the given dimension dim.",xa,Xt,ih='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Ca,Zt,dh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Ha,La,wa,el,Aa,tl,ga,ll,ah="Returns the matrix norm or vector norm of a given tensor.",za,sl,uh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The norm of the tensor.',Pa,ol,mh=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Ra,Ua,ka,nl,ja,rl,Ea,il,ph="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Ja,dl,ch='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - <code>this</code> for operation chaining.',Da,al,Th="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Ia,qa,Ka,ul,Ba,ml,Na,pl,fh="Performs <code>L_p</code> normalization of inputs over specified dimension.",Qa,cl,hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',Va,Tl,_h="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Sa,Oa,Fa,fl,Ya,hl,Wa,_l,$h=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Ga,$l,bh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Xa,Za,eu,bl,tu,vl,lu,yl,vh="Returns a tensor with all specified dimensions of input of size 1 removed.",su,Ml,yh=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,ou,xl,Mh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The squeezed tensor',nu,Cl,xh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",ru,iu,du,Hl,au,Ll,uu,wl,Ch='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',mu,Al,Hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',pu,cu,Tu,gl,fu,zl,hu,Pl,Lh="Returns a new tensor with a dimension of size one inserted at the specified position.",_u,Rl,wh="NOTE: The returned tensor shares the same underlying data with this tensor.",$u,Ul,Ah='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The unsqueezed tensor',bu,kl,gh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",vu,yu,Mu,jl,xu,El,Cu,Jl,zh='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Hu,Dl,Ph='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Lu,wu,Au,Il,gu,ql,zu,Kl,Rh='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Pu,Bl,Uh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ru,Uu,ku,Nl,ju,Ql,Eu,Vl,kh=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Ju,Sl,jh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The flattened tensor.',Du,Ol,Eh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Iu,qu,Ku,Fl,Bu,Yl,Nu,Wl,Jh="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Qu,Gl,Dh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the same data but different shape',Vu,Xl,Ih="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Su,Ou,Fu,Zl,Yu,es,Wu,ts,qh='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Gu,ls,Kh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Xu,Zu,em,ss,tm,os,lm,ns,Bh="Clamps all elements in input into the range [ min, max ]",sm,rs,Nh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',om,is,Qh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",nm,rm,im,ds,dm,as,am,us,Vh='In-place version of @see <a href="Tensor.round">Tensor.round</a>',um,ms,Sh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',mm,pm,cm,ps,Tm,cs,fm,Ts,Oh="Rounds elements of input to the nearest integer.",hm,fs,Fh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',_m,$m,bm,hs,vm,_s,ym,$s,Yh="Performs Tensor dtype conversion.",Mm,bs,Wh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The converted tensor.',xm,vs,Gh='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',Cm,Hm,Lm,ys,wm,Ms,Am,xs,Xh="Permutes a tensor according to the provided axes.",gm,Cs,Zh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',zm,Hs,e1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Pm,Rm,Um,Ls,km,ws,jm,As,t1="Interpolates an Tensor to the given size.",Em,gs,l1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The interpolated tensor.',Jm,zs,s1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>',Dm,Im,qm,Ps,Km,Rs,Bm,Us,o1=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Nm,ks,n1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The interpolated tensor.',Qm,js,r1='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>',Vm,Sm,Om,Es,Fm,Js,Ym,Ds,i1=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,Wm,Is,d1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The matrix product of the two tensors.',Gm,qs,a1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>',Xm,Zm,ep,Ks,tp,Bs,lp,Ns,u1=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,sp,Qs,m1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - the output tensor.',op,Vs,p1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>',np,rp,ip,Ss,dp,Os,ap,Fs,c1=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,up,Ys,T1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',mp,Ws,f1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>',pp,cp,Tp,Gs,fp,Xs,hp,Zs,h1="Perform mean pooling of the last hidden state followed by a normalization step.",_p,eo,_1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns a new Tensor of shape [batchSize, embedDim].',$p,to,$1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>',bp,vp,yp,lo,Mp,so,xp,oo,b1="Apply Layer Normalization for last certain number of dimensions.",Cp,no,v1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',Hp,ro,y1='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>',Lp,wp,Ap,io,gp,ao,zp,uo,M1="Concatenates an array of tensors along a specified dimension.",Pp,mo,x1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The concatenated tensor.',Rp,po,C1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>',Up,kp,jp,co,Ep,To,Jp,fo,H1="Stack an array of tensors along a specified dimension.",Dp,ho,L1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The stacked tensor.',Ip,_o,w1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>',qp,Kp,Bp,$o,Np,bo,Qp,vo,A1="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",Vp,yo,g1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a> - A tuple of (std, mean) tensors.',Sp,Mo,z1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',Op,Fp,Yp,xo,Wp,Co,Gp,Ho,P1="Returns the mean value of each row of the input tensor in the given dimension dim.",Xp,Lo,R1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new tensor with means taken along the specified dimension.',Zp,wo,U1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',ec,tc,lc,Ao,sc,go,oc,zo,k1="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",nc,Po,j1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The filled tensor.',rc,Ro,E1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code> | <code>boolean</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",ic,dc,ac,Uo,uc,ko,mc,jo,J1="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",pc,Eo,D1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',cc,Jo,I1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Tc,fc,hc,Do,_c,Io,$c,qo,q1="Returns a tensor filled with the scalar value 1, with the same size as input.",bc,Ko,K1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',vc,Bo,B1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',yc,Mc,xc,No,Cc,Qo,Hc,Vo,N1="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",Lc,So,Q1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',wc,Oo,V1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Ac,gc,zc,Fo,Pc,Yo,Rc,Wo,S1="Returns a tensor filled with the scalar value 0, with the same size as input.",Uc,Go,O1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',kc,Xo,F1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',jc,Ec,Jc,Zo,Dc,en,Ic,tn,Y1="Returns a tensor filled with random numbers from a uniform distribution on the interval [0, 1)",qc,ln,W1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The random tensor.',Kc,sn,G1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Bc,Nc,Qc,on,Vc,nn,Sc,rn,X1="Quantizes the embeddings tensor to binary or unsigned binary precision.",Oc,dn,Z1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The quantized tensor.',Fc,an,e_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>',Yc,Wc,Gc,un,Xc,mn,Zc,pn,t_='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',eT,tT,lT,cn,sT,Tn,oT,fn,l_="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",nT,hn,s_='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',rT,_n,o_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",iT,$n,n_="<strong>Example</strong>",dT,bn,aT,uT,mT,vn,pT,yn,cT,Mn,r_='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',TT,fT,hT,xn,_T,Cn,$T,Hn,i_='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',bT,vT,yT,Ln,MT,wn,xT,An,d_="This creates a nested array of a given type and depth (see examples).",CT,gn,a_='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',HT,zn,LT,Pn,u_="<strong>Example</strong>",wT,Rn,AT,Un,m_="<strong>Example</strong>",gT,kn,zT,PT,RT,jn,UT,Dn,kT;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),U=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),se=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Ue=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ot=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.clone() ⇒ <code> Tensor </code>",local:"tensorclone--code-tensor-code",headingTag:"h3"}}),Ut=new _({props:{title:"tensor.slice(...slices) ⇒ <code> Tensor </code>",local:"tensorsliceslices--code-tensor-code",headingTag:"h3"}}),Et=new En({props:{code:"JTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjAzJTJDJTIwJTIwNCUyQyUyMCUyMDUlMkMlMjAlMjA2JTJDJTIwJTIwNyU1RCUwQSU1QiUyMDglMkMlMjAlMjA5JTJDJTIwMTAlMkMlMjAxMSUyQyUyMDEyJTJDJTIwMTMlMkMlMjAxNCU1RCUwQSU1QjE1JTJDJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTVEJTBBJTVCMjIlMkMlMjAyMyUyQyUyMDI0JTJDJTIwMjUlMkMlMjAyNiUyQyUyMDI3JTJDJTIwMjglNUQ=",highlighted:`<span class="hljs-string">[ 1,  2,  3,  4,  5,  6,  7]</span>
<span class="hljs-string">[ 8,  9, 10, 11, 12, 13, 14]</span>
<span class="hljs-string">[15, 16, 17, 18, 19, 20, 21]</span>
<span class="hljs-string">[22, 23, 24, 25, 26, 27, 28]</span>`,wrap:!1}}),Dt=new En({props:{code:"dGVuc29yLnNsaWNlKCU1QjElMkMlMjAtMSU1RCUyQyUyMCU1QjElMkMlMjAtMSU1RCklM0I=",highlighted:'<span class="hljs-attribute">tensor</span>.slice([<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>],<span class="hljs-meta"> [1, -1]);</span>',wrap:!1}}),qt=new En({props:{code:"JTVCJTIwJTIwOSUyQyUyMDEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTIwJTVEJTBBJTVCJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyMCU1RA==",highlighted:`<span class="hljs-string">[  9, 10, 11, 12, 13 ]</span>
<span class="hljs-string">[ 16, 17, 18, 19, 20 ]</span>`,wrap:!1}}),Vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),tl=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),rl=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ml=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),hl=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),vl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),zl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),El=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),ql=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),Yl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),es=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),os=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),as=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),cs=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),_s=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ms=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Rs=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),Js=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),Bs=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Os=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),Xs=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),so=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),ao=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),To=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),bo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Co=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),go=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),ko=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),Io=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),Qo=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),Yo=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),en=new _({props:{title:"utils/tensor.rand(size) ⇒ <code> Tensor </code>",local:"utilstensorrandsize--code-tensor-code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),mn=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),Tn=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),bn=new En({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),yn=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Cn=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),wn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),zn=new En({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Rn=new En({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),kn=new En({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),jn=new b_({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=r("meta"),In=o(),Jn=r("p"),qn=o(),b=r("a"),Kn=o(),u(v.$$.fragment),Bn=o(),y=r("p"),y.innerHTML=ET,Nn=o(),M=r("p"),M.textContent=JT,Qn=o(),x=r("ul"),x.innerHTML=DT,Vn=o(),Sn=r("hr"),On=o(),C=r("a"),Fn=o(),u(H.$$.fragment),Yn=o(),L=r("p"),L.innerHTML=IT,Wn=o(),w=r("ul"),w.innerHTML=qT,Gn=o(),Xn=r("hr"),Zn=o(),A=r("a"),er=o(),u(g.$$.fragment),tr=o(),z=r("p"),z.textContent=KT,lr=o(),P=r("table"),P.innerHTML=BT,sr=o(),or=r("hr"),nr=o(),R=r("a"),rr=o(),u(U.$$.fragment),ir=o(),k=r("p"),k.textContent=NT,dr=o(),j=r("p"),j.innerHTML=QT,ar=o(),ur=r("hr"),mr=o(),E=r("a"),pr=o(),u(J.$$.fragment),cr=o(),D=r("p"),D.textContent=VT,Tr=o(),I=r("p"),I.innerHTML=ST,fr=o(),hr=r("hr"),_r=o(),q=r("a"),$r=o(),u(K.$$.fragment),br=o(),B=r("p"),B.textContent=OT,vr=o(),N=r("p"),N.innerHTML=FT,yr=o(),Mr=r("hr"),xr=o(),Q=r("a"),Cr=o(),u(V.$$.fragment),Hr=o(),S=r("p"),S.textContent=YT,Lr=o(),O=r("p"),O.innerHTML=WT,wr=o(),Ar=r("hr"),gr=o(),F=r("a"),zr=o(),u(Y.$$.fragment),Pr=o(),W=r("p"),W.textContent=GT,Rr=o(),G=r("p"),G.innerHTML=XT,Ur=o(),kr=r("hr"),jr=o(),X=r("a"),Er=o(),u(Z.$$.fragment),Jr=o(),ee=r("p"),ee.textContent=ZT,Dr=o(),te=r("p"),te.innerHTML=ef,Ir=o(),qr=r("hr"),Kr=o(),le=r("a"),Br=o(),u(se.$$.fragment),Nr=o(),oe=r("p"),oe.textContent=tf,Qr=o(),ne=r("p"),ne.innerHTML=lf,Vr=o(),re=r("table"),re.innerHTML=sf,Sr=o(),Or=r("hr"),Fr=o(),ie=r("a"),Yr=o(),u(de.$$.fragment),Wr=o(),ae=r("p"),ae.innerHTML=of,Gr=o(),ue=r("table"),ue.innerHTML=nf,Xr=o(),Zr=r("hr"),ei=o(),me=r("a"),ti=o(),u(pe.$$.fragment),li=o(),ce=r("p"),ce.innerHTML=rf,si=o(),Te=r("table"),Te.innerHTML=df,oi=o(),ni=r("hr"),ri=o(),fe=r("a"),ii=o(),u(he.$$.fragment),di=o(),_e=r("p"),_e.innerHTML=af,ai=o(),$e=r("p"),$e.innerHTML=uf,ui=o(),be=r("ul"),be.innerHTML=mf,mi=o(),pi=r("hr"),ci=o(),ve=r("a"),Ti=o(),u(ye.$$.fragment),fi=o(),Me=r("p"),Me.textContent=pf,hi=o(),xe=r("p"),xe.innerHTML=cf,_i=o(),$i=r("hr"),bi=o(),Ce=r("a"),vi=o(),u(He.$$.fragment),yi=o(),Le=r("p"),Le.textContent=Tf,Mi=o(),we=r("p"),we.innerHTML=ff,xi=o(),Ci=r("hr"),Hi=o(),Ae=r("a"),Li=o(),u(ge.$$.fragment),wi=o(),ze=r("p"),ze.textContent=hf,Ai=o(),Pe=r("p"),Pe.innerHTML=_f,gi=o(),zi=r("hr"),Pi=o(),Re=r("a"),Ri=o(),u(Ue.$$.fragment),Ui=o(),ke=r("p"),ke.textContent=$f,ki=o(),je=r("p"),je.innerHTML=bf,ji=o(),Ee=r("table"),Ee.innerHTML=vf,Ei=o(),Ji=r("hr"),Di=o(),Je=r("a"),Ii=o(),u(De.$$.fragment),qi=o(),Ie=r("p"),Ie.textContent=yf,Ki=o(),qe=r("p"),qe.innerHTML=Mf,Bi=o(),Ke=r("table"),Ke.innerHTML=xf,Ni=o(),Qi=r("hr"),Vi=o(),Be=r("a"),Si=o(),u(Ne.$$.fragment),Oi=o(),Qe=r("p"),Qe.textContent=Cf,Fi=o(),Ve=r("p"),Ve.innerHTML=Hf,Yi=o(),Se=r("table"),Se.innerHTML=Lf,Wi=o(),Gi=r("hr"),Xi=o(),Oe=r("a"),Zi=o(),u(Fe.$$.fragment),ed=o(),Ye=r("p"),Ye.textContent=wf,td=o(),We=r("p"),We.innerHTML=Af,ld=o(),Ge=r("table"),Ge.innerHTML=gf,sd=o(),od=r("hr"),nd=o(),Xe=r("a"),rd=o(),u(Ze.$$.fragment),id=o(),et=r("p"),et.textContent=zf,dd=o(),tt=r("p"),tt.innerHTML=Pf,ad=o(),lt=r("table"),lt.innerHTML=Rf,ud=o(),md=r("hr"),pd=o(),st=r("a"),cd=o(),u(ot.$$.fragment),Td=o(),nt=r("p"),nt.textContent=Uf,fd=o(),rt=r("p"),rt.innerHTML=kf,hd=o(),it=r("table"),it.innerHTML=jf,_d=o(),$d=r("hr"),bd=o(),dt=r("a"),vd=o(),u(at.$$.fragment),yd=o(),ut=r("p"),ut.textContent=Ef,Md=o(),mt=r("p"),mt.innerHTML=Jf,xd=o(),pt=r("table"),pt.innerHTML=Df,Cd=o(),Hd=r("hr"),Ld=o(),ct=r("a"),wd=o(),u(Tt.$$.fragment),Ad=o(),ft=r("p"),ft.textContent=If,gd=o(),ht=r("p"),ht.innerHTML=qf,zd=o(),_t=r("table"),_t.innerHTML=Kf,Pd=o(),Rd=r("hr"),Ud=o(),$t=r("a"),kd=o(),u(bt.$$.fragment),jd=o(),vt=r("p"),vt.textContent=Bf,Ed=o(),yt=r("p"),yt.innerHTML=Nf,Jd=o(),Mt=r("table"),Mt.innerHTML=Qf,Dd=o(),Id=r("hr"),qd=o(),xt=r("a"),Kd=o(),u(Ct.$$.fragment),Bd=o(),Ht=r("p"),Ht.textContent=Vf,Nd=o(),Lt=r("p"),Lt.innerHTML=Sf,Qd=o(),wt=r("table"),wt.innerHTML=Of,Vd=o(),Sd=r("hr"),Od=o(),At=r("a"),Fd=o(),u(gt.$$.fragment),Yd=o(),zt=r("p"),zt.textContent=Ff,Wd=o(),Pt=r("p"),Pt.innerHTML=Yf,Gd=o(),Xd=r("hr"),Zd=o(),Rt=r("a"),ea=o(),u(Ut.$$.fragment),ta=o(),kt=r("p"),kt.textContent=Wf,la=o(),jt=r("p"),jt.textContent=Gf,sa=o(),u(Et.$$.fragment),oa=o(),Jt=r("p"),Jt.textContent=Xf,na=o(),u(Dt.$$.fragment),ra=o(),It=r("p"),It.textContent=Zf,ia=o(),u(qt.$$.fragment),da=o(),Kt=r("p"),Kt.innerHTML=eh,aa=o(),Bt=r("ul"),Bt.innerHTML=th,ua=o(),Nt=r("table"),Nt.innerHTML=lh,ma=o(),pa=r("hr"),ca=o(),Qt=r("a"),Ta=o(),u(Vt.$$.fragment),fa=o(),St=r("p"),St.textContent=sh,ha=o(),Ot=r("p"),Ot.innerHTML=oh,_a=o(),Ft=r("table"),Ft.innerHTML=nh,$a=o(),ba=r("hr"),va=o(),Yt=r("a"),ya=o(),u(Wt.$$.fragment),Ma=o(),Gt=r("p"),Gt.textContent=rh,xa=o(),Xt=r("p"),Xt.innerHTML=ih,Ca=o(),Zt=r("table"),Zt.innerHTML=dh,Ha=o(),La=r("hr"),wa=o(),el=r("a"),Aa=o(),u(tl.$$.fragment),ga=o(),ll=r("p"),ll.textContent=ah,za=o(),sl=r("p"),sl.innerHTML=uh,Pa=o(),ol=r("table"),ol.innerHTML=mh,Ra=o(),Ua=r("hr"),ka=o(),nl=r("a"),ja=o(),u(rl.$$.fragment),Ea=o(),il=r("p"),il.innerHTML=ph,Ja=o(),dl=r("p"),dl.innerHTML=ch,Da=o(),al=r("table"),al.innerHTML=Th,Ia=o(),qa=r("hr"),Ka=o(),ul=r("a"),Ba=o(),u(ml.$$.fragment),Na=o(),pl=r("p"),pl.innerHTML=fh,Qa=o(),cl=r("p"),cl.innerHTML=hh,Va=o(),Tl=r("table"),Tl.innerHTML=_h,Sa=o(),Oa=r("hr"),Fa=o(),fl=r("a"),Ya=o(),u(hl.$$.fragment),Wa=o(),_l=r("p"),_l.textContent=$h,Ga=o(),$l=r("p"),$l.innerHTML=bh,Xa=o(),Za=r("hr"),eu=o(),bl=r("a"),tu=o(),u(vl.$$.fragment),lu=o(),yl=r("p"),yl.textContent=vh,su=o(),Ml=r("p"),Ml.innerHTML=yh,ou=o(),xl=r("p"),xl.innerHTML=Mh,nu=o(),Cl=r("table"),Cl.innerHTML=xh,ru=o(),iu=r("hr"),du=o(),Hl=r("a"),au=o(),u(Ll.$$.fragment),uu=o(),wl=r("p"),wl.innerHTML=Ch,mu=o(),Al=r("p"),Al.innerHTML=Hh,pu=o(),cu=r("hr"),Tu=o(),gl=r("a"),fu=o(),u(zl.$$.fragment),hu=o(),Pl=r("p"),Pl.textContent=Lh,_u=o(),Rl=r("p"),Rl.textContent=wh,$u=o(),Ul=r("p"),Ul.innerHTML=Ah,bu=o(),kl=r("table"),kl.innerHTML=gh,vu=o(),yu=r("hr"),Mu=o(),jl=r("a"),xu=o(),u(El.$$.fragment),Cu=o(),Jl=r("p"),Jl.innerHTML=zh,Hu=o(),Dl=r("p"),Dl.innerHTML=Ph,Lu=o(),wu=r("hr"),Au=o(),Il=r("a"),gu=o(),u(ql.$$.fragment),zu=o(),Kl=r("p"),Kl.innerHTML=Rh,Pu=o(),Bl=r("p"),Bl.innerHTML=Uh,Ru=o(),Uu=r("hr"),ku=o(),Nl=r("a"),ju=o(),u(Ql.$$.fragment),Eu=o(),Vl=r("p"),Vl.innerHTML=kh,Ju=o(),Sl=r("p"),Sl.innerHTML=jh,Du=o(),Ol=r("table"),Ol.innerHTML=Eh,Iu=o(),qu=r("hr"),Ku=o(),Fl=r("a"),Bu=o(),u(Yl.$$.fragment),Nu=o(),Wl=r("p"),Wl.innerHTML=Jh,Qu=o(),Gl=r("p"),Gl.innerHTML=Dh,Vu=o(),Xl=r("table"),Xl.innerHTML=Ih,Su=o(),Ou=r("hr"),Fu=o(),Zl=r("a"),Yu=o(),u(es.$$.fragment),Wu=o(),ts=r("p"),ts.innerHTML=qh,Gu=o(),ls=r("p"),ls.innerHTML=Kh,Xu=o(),Zu=r("hr"),em=o(),ss=r("a"),tm=o(),u(os.$$.fragment),lm=o(),ns=r("p"),ns.textContent=Bh,sm=o(),rs=r("p"),rs.innerHTML=Nh,om=o(),is=r("table"),is.innerHTML=Qh,nm=o(),rm=r("hr"),im=o(),ds=r("a"),dm=o(),u(as.$$.fragment),am=o(),us=r("p"),us.innerHTML=Vh,um=o(),ms=r("p"),ms.innerHTML=Sh,mm=o(),pm=r("hr"),cm=o(),ps=r("a"),Tm=o(),u(cs.$$.fragment),fm=o(),Ts=r("p"),Ts.textContent=Oh,hm=o(),fs=r("p"),fs.innerHTML=Fh,_m=o(),$m=r("hr"),bm=o(),hs=r("a"),vm=o(),u(_s.$$.fragment),ym=o(),$s=r("p"),$s.textContent=Yh,Mm=o(),bs=r("p"),bs.innerHTML=Wh,xm=o(),vs=r("table"),vs.innerHTML=Gh,Cm=o(),Hm=r("hr"),Lm=o(),ys=r("a"),wm=o(),u(Ms.$$.fragment),Am=o(),xs=r("p"),xs.textContent=Xh,gm=o(),Cs=r("p"),Cs.innerHTML=Zh,zm=o(),Hs=r("table"),Hs.innerHTML=e1,Pm=o(),Rm=r("hr"),Um=o(),Ls=r("a"),km=o(),u(ws.$$.fragment),jm=o(),As=r("p"),As.textContent=t1,Em=o(),gs=r("p"),gs.innerHTML=l1,Jm=o(),zs=r("table"),zs.innerHTML=s1,Dm=o(),Im=r("hr"),qm=o(),Ps=r("a"),Km=o(),u(Rs.$$.fragment),Bm=o(),Us=r("p"),Us.innerHTML=o1,Nm=o(),ks=r("p"),ks.innerHTML=n1,Qm=o(),js=r("table"),js.innerHTML=r1,Vm=o(),Sm=r("hr"),Om=o(),Es=r("a"),Fm=o(),u(Js.$$.fragment),Ym=o(),Ds=r("p"),Ds.innerHTML=i1,Wm=o(),Is=r("p"),Is.innerHTML=d1,Gm=o(),qs=r("table"),qs.innerHTML=a1,Xm=o(),Zm=r("hr"),ep=o(),Ks=r("a"),tp=o(),u(Bs.$$.fragment),lp=o(),Ns=r("p"),Ns.innerHTML=u1,sp=o(),Qs=r("p"),Qs.innerHTML=m1,op=o(),Vs=r("table"),Vs.innerHTML=p1,np=o(),rp=r("hr"),ip=o(),Ss=r("a"),dp=o(),u(Os.$$.fragment),ap=o(),Fs=r("p"),Fs.innerHTML=c1,up=o(),Ys=r("p"),Ys.innerHTML=T1,mp=o(),Ws=r("table"),Ws.innerHTML=f1,pp=o(),cp=r("hr"),Tp=o(),Gs=r("a"),fp=o(),u(Xs.$$.fragment),hp=o(),Zs=r("p"),Zs.textContent=h1,_p=o(),eo=r("p"),eo.innerHTML=_1,$p=o(),to=r("table"),to.innerHTML=$1,bp=o(),vp=r("hr"),yp=o(),lo=r("a"),Mp=o(),u(so.$$.fragment),xp=o(),oo=r("p"),oo.textContent=b1,Cp=o(),no=r("p"),no.innerHTML=v1,Hp=o(),ro=r("table"),ro.innerHTML=y1,Lp=o(),wp=r("hr"),Ap=o(),io=r("a"),gp=o(),u(ao.$$.fragment),zp=o(),uo=r("p"),uo.textContent=M1,Pp=o(),mo=r("p"),mo.innerHTML=x1,Rp=o(),po=r("table"),po.innerHTML=C1,Up=o(),kp=r("hr"),jp=o(),co=r("a"),Ep=o(),u(To.$$.fragment),Jp=o(),fo=r("p"),fo.textContent=H1,Dp=o(),ho=r("p"),ho.innerHTML=L1,Ip=o(),_o=r("table"),_o.innerHTML=w1,qp=o(),Kp=r("hr"),Bp=o(),$o=r("a"),Np=o(),u(bo.$$.fragment),Qp=o(),vo=r("p"),vo.innerHTML=A1,Vp=o(),yo=r("p"),yo.innerHTML=g1,Sp=o(),Mo=r("table"),Mo.innerHTML=z1,Op=o(),Fp=r("hr"),Yp=o(),xo=r("a"),Wp=o(),u(Co.$$.fragment),Gp=o(),Ho=r("p"),Ho.textContent=P1,Xp=o(),Lo=r("p"),Lo.innerHTML=R1,Zp=o(),wo=r("table"),wo.innerHTML=U1,ec=o(),tc=r("hr"),lc=o(),Ao=r("a"),sc=o(),u(go.$$.fragment),oc=o(),zo=r("p"),zo.textContent=k1,nc=o(),Po=r("p"),Po.innerHTML=j1,rc=o(),Ro=r("table"),Ro.innerHTML=E1,ic=o(),dc=r("hr"),ac=o(),Uo=r("a"),uc=o(),u(ko.$$.fragment),mc=o(),jo=r("p"),jo.textContent=J1,pc=o(),Eo=r("p"),Eo.innerHTML=D1,cc=o(),Jo=r("table"),Jo.innerHTML=I1,Tc=o(),fc=r("hr"),hc=o(),Do=r("a"),_c=o(),u(Io.$$.fragment),$c=o(),qo=r("p"),qo.textContent=q1,bc=o(),Ko=r("p"),Ko.innerHTML=K1,vc=o(),Bo=r("table"),Bo.innerHTML=B1,yc=o(),Mc=r("hr"),xc=o(),No=r("a"),Cc=o(),u(Qo.$$.fragment),Hc=o(),Vo=r("p"),Vo.textContent=N1,Lc=o(),So=r("p"),So.innerHTML=Q1,wc=o(),Oo=r("table"),Oo.innerHTML=V1,Ac=o(),gc=r("hr"),zc=o(),Fo=r("a"),Pc=o(),u(Yo.$$.fragment),Rc=o(),Wo=r("p"),Wo.textContent=S1,Uc=o(),Go=r("p"),Go.innerHTML=O1,kc=o(),Xo=r("table"),Xo.innerHTML=F1,jc=o(),Ec=r("hr"),Jc=o(),Zo=r("a"),Dc=o(),u(en.$$.fragment),Ic=o(),tn=r("p"),tn.textContent=Y1,qc=o(),ln=r("p"),ln.innerHTML=W1,Kc=o(),sn=r("table"),sn.innerHTML=G1,Bc=o(),Nc=r("hr"),Qc=o(),on=r("a"),Vc=o(),u(nn.$$.fragment),Sc=o(),rn=r("p"),rn.textContent=X1,Oc=o(),dn=r("p"),dn.innerHTML=Z1,Fc=o(),an=r("table"),an.innerHTML=e_,Yc=o(),Wc=r("hr"),Gc=o(),un=r("a"),Xc=o(),u(mn.$$.fragment),Zc=o(),pn=r("p"),pn.innerHTML=t_,eT=o(),tT=r("hr"),lT=o(),cn=r("a"),sT=o(),u(Tn.$$.fragment),oT=o(),fn=r("p"),fn.textContent=l_,nT=o(),hn=r("p"),hn.innerHTML=s_,rT=o(),_n=r("table"),_n.innerHTML=o_,iT=o(),$n=r("p"),$n.innerHTML=n_,dT=o(),u(bn.$$.fragment),aT=o(),uT=r("hr"),mT=o(),vn=r("a"),pT=o(),u(yn.$$.fragment),cT=o(),Mn=r("p"),Mn.innerHTML=r_,TT=o(),fT=r("hr"),hT=o(),xn=r("a"),_T=o(),u(Cn.$$.fragment),$T=o(),Hn=r("p"),Hn.innerHTML=i_,bT=o(),vT=r("hr"),yT=o(),Ln=r("a"),MT=o(),u(wn.$$.fragment),xT=o(),An=r("p"),An.textContent=d_,CT=o(),gn=r("p"),gn.innerHTML=a_,HT=o(),u(zn.$$.fragment),LT=o(),Pn=r("p"),Pn.innerHTML=u_,wT=o(),u(Rn.$$.fragment),AT=o(),Un=r("p"),Un.innerHTML=m_,gT=o(),u(kn.$$.fragment),zT=o(),PT=r("hr"),RT=o(),u(jn.$$.fragment),UT=o(),Dn=r("p"),this.h()},l(e){const t=__("svelte-u9bgzb",document.head);$=i(t,"META",{name:!0,content:!0}),t.forEach(l),In=n(e),Jn=i(e,"P",{}),h(Jn).forEach(l),qn=n(e),b=i(e,"A",{id:!0,class:!0}),h(b).forEach(l),Kn=n(e),m(v.$$.fragment,e),Bn=n(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-uw4y1m"&&(y.innerHTML=ET),Nn=n(e),M=i(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=JT),Qn=n(e),x=i(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-8w8no7"&&(x.innerHTML=DT),Vn=n(e),Sn=i(e,"HR",{}),On=n(e),C=i(e,"A",{id:!0,class:!0}),h(C).forEach(l),Fn=n(e),m(H.$$.fragment,e),Yn=n(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=IT),Wn=n(e),w=i(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-msj2om"&&(w.innerHTML=qT),Gn=n(e),Xn=i(e,"HR",{}),Zn=n(e),A=i(e,"A",{id:!0,class:!0}),h(A).forEach(l),er=n(e),m(g.$$.fragment,e),tr=n(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-55wecd"&&(z.textContent=KT),lr=n(e),P=i(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=BT),sr=n(e),or=i(e,"HR",{}),nr=n(e),R=i(e,"A",{id:!0,class:!0}),h(R).forEach(l),rr=n(e),m(U.$$.fragment,e),ir=n(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1gc2rt4"&&(k.textContent=NT),dr=n(e),j=i(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=QT),ar=n(e),ur=i(e,"HR",{}),mr=n(e),E=i(e,"A",{id:!0,class:!0}),h(E).forEach(l),pr=n(e),m(J.$$.fragment,e),cr=n(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=VT),Tr=n(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=ST),fr=n(e),hr=i(e,"HR",{}),_r=n(e),q=i(e,"A",{id:!0,class:!0}),h(q).forEach(l),$r=n(e),m(K.$$.fragment,e),br=n(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=OT),vr=n(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=FT),yr=n(e),Mr=i(e,"HR",{}),xr=n(e),Q=i(e,"A",{id:!0,class:!0}),h(Q).forEach(l),Cr=n(e),m(V.$$.fragment,e),Hr=n(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=YT),Lr=n(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=WT),wr=n(e),Ar=i(e,"HR",{}),gr=n(e),F=i(e,"A",{id:!0,class:!0}),h(F).forEach(l),zr=n(e),m(Y.$$.fragment,e),Pr=n(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1iaptgl"&&(W.textContent=GT),Rr=n(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=XT),Ur=n(e),kr=i(e,"HR",{}),jr=n(e),X=i(e,"A",{id:!0,class:!0}),h(X).forEach(l),Er=n(e),m(Z.$$.fragment,e),Jr=n(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=ZT),Dr=n(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=ef),Ir=n(e),qr=i(e,"HR",{}),Kr=n(e),le=i(e,"A",{id:!0,class:!0}),h(le).forEach(l),Br=n(e),m(se.$$.fragment,e),Nr=n(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1u97xg1"&&(oe.textContent=tf),Qr=n(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1fs0j1e"&&(ne.innerHTML=lf),Vr=n(e),re=i(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-1kq04ga"&&(re.innerHTML=sf),Sr=n(e),Or=i(e,"HR",{}),Fr=n(e),ie=i(e,"A",{id:!0,class:!0}),h(ie).forEach(l),Yr=n(e),m(de.$$.fragment,e),Wr=n(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1cg22af"&&(ae.innerHTML=of),Gr=n(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-1hful42"&&(ue.innerHTML=nf),Xr=n(e),Zr=i(e,"HR",{}),ei=n(e),me=i(e,"A",{id:!0,class:!0}),h(me).forEach(l),ti=n(e),m(pe.$$.fragment,e),li=n(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=rf),si=n(e),Te=i(e,"TABLE",{"data-svelte-h":!0}),d(Te)!=="svelte-153ftfy"&&(Te.innerHTML=df),oi=n(e),ni=i(e,"HR",{}),ri=n(e),fe=i(e,"A",{id:!0,class:!0}),h(fe).forEach(l),ii=n(e),m(he.$$.fragment,e),di=n(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=af),ai=n(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=uf),ui=n(e),be=i(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-5t2sg3"&&(be.innerHTML=mf),mi=n(e),pi=i(e,"HR",{}),ci=n(e),ve=i(e,"A",{id:!0,class:!0}),h(ve).forEach(l),Ti=n(e),m(ye.$$.fragment,e),fi=n(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=pf),hi=n(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=cf),_i=n(e),$i=i(e,"HR",{}),bi=n(e),Ce=i(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),vi=n(e),m(He.$$.fragment,e),yi=n(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=Tf),Mi=n(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1y8z3p1"&&(we.innerHTML=ff),xi=n(e),Ci=i(e,"HR",{}),Hi=n(e),Ae=i(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Li=n(e),m(ge.$$.fragment,e),wi=n(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1edu6c8"&&(ze.textContent=hf),Ai=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1t595qz"&&(Pe.innerHTML=_f),gi=n(e),zi=i(e,"HR",{}),Pi=n(e),Re=i(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Ri=n(e),m(Ue.$$.fragment,e),Ui=n(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-az0crx"&&(ke.textContent=$f),ki=n(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-w5myiy"&&(je.innerHTML=bf),ji=n(e),Ee=i(e,"TABLE",{"data-svelte-h":!0}),d(Ee)!=="svelte-1ok4yhn"&&(Ee.innerHTML=vf),Ei=n(e),Ji=i(e,"HR",{}),Di=n(e),Je=i(e,"A",{id:!0,class:!0}),h(Je).forEach(l),Ii=n(e),m(De.$$.fragment,e),qi=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jlfq15"&&(Ie.textContent=yf),Ki=n(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1t595qz"&&(qe.innerHTML=Mf),Bi=n(e),Ke=i(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=xf),Ni=n(e),Qi=i(e,"HR",{}),Vi=n(e),Be=i(e,"A",{id:!0,class:!0}),h(Be).forEach(l),Si=n(e),m(Ne.$$.fragment,e),Oi=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-xg80lg"&&(Qe.textContent=Cf),Fi=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-9qu32j"&&(Ve.innerHTML=Hf),Yi=n(e),Se=i(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=Lf),Wi=n(e),Gi=i(e,"HR",{}),Xi=n(e),Oe=i(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),Zi=n(e),m(Fe.$$.fragment,e),ed=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=wf),td=n(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1t595qz"&&(We.innerHTML=Af),ld=n(e),Ge=i(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=gf),sd=n(e),od=i(e,"HR",{}),nd=n(e),Xe=i(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),rd=n(e),m(Ze.$$.fragment,e),id=n(e),et=i(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-45kvaw"&&(et.textContent=zf),dd=n(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-9qu32j"&&(tt.innerHTML=Pf),ad=n(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-46t58i"&&(lt.innerHTML=Rf),ud=n(e),md=i(e,"HR",{}),pd=n(e),st=i(e,"A",{id:!0,class:!0}),h(st).forEach(l),cd=n(e),m(ot.$$.fragment,e),Td=n(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-6s524n"&&(nt.textContent=Uf),fd=n(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t595qz"&&(rt.innerHTML=kf),hd=n(e),it=i(e,"TABLE",{"data-svelte-h":!0}),d(it)!=="svelte-46t58i"&&(it.innerHTML=jf),_d=n(e),$d=i(e,"HR",{}),bd=n(e),dt=i(e,"A",{id:!0,class:!0}),h(dt).forEach(l),vd=n(e),m(at.$$.fragment,e),yd=n(e),ut=i(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1hl64jn"&&(ut.textContent=Ef),Md=n(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-9qu32j"&&(mt.innerHTML=Jf),xd=n(e),pt=i(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p5444"&&(pt.innerHTML=Df),Cd=n(e),Hd=i(e,"HR",{}),Ld=n(e),ct=i(e,"A",{id:!0,class:!0}),h(ct).forEach(l),wd=n(e),m(Tt.$$.fragment,e),Ad=n(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-bbf4x3"&&(ft.textContent=If),gd=n(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1t595qz"&&(ht.innerHTML=qf),zd=n(e),_t=i(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-1p5444"&&(_t.innerHTML=Kf),Pd=n(e),Rd=i(e,"HR",{}),Ud=n(e),$t=i(e,"A",{id:!0,class:!0}),h($t).forEach(l),kd=n(e),m(bt.$$.fragment,e),jd=n(e),vt=i(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-wbrx6g"&&(vt.textContent=Bf),Ed=n(e),yt=i(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-9qu32j"&&(yt.innerHTML=Nf),Jd=n(e),Mt=i(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=Qf),Dd=n(e),Id=i(e,"HR",{}),qd=n(e),xt=i(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Kd=n(e),m(Ct.$$.fragment,e),Bd=n(e),Ht=i(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-wqxtec"&&(Ht.textContent=Vf),Nd=n(e),Lt=i(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1t595qz"&&(Lt.innerHTML=Sf),Qd=n(e),wt=i(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-flm2g1"&&(wt.innerHTML=Of),Vd=n(e),Sd=i(e,"HR",{}),Od=n(e),At=i(e,"A",{id:!0,class:!0}),h(At).forEach(l),Fd=n(e),m(gt.$$.fragment,e),Yd=n(e),zt=i(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-zftqbb"&&(zt.textContent=Ff),Wd=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1mgj1au"&&(Pt.innerHTML=Yf),Gd=n(e),Xd=i(e,"HR",{}),Zd=n(e),Rt=i(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),ea=n(e),m(Ut.$$.fragment,e),ta=n(e),kt=i(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-yalim1"&&(kt.textContent=Wf),la=n(e),jt=i(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-v4sb1d"&&(jt.textContent=Gf),sa=n(e),m(Et.$$.fragment,e),oa=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1qggjsc"&&(Jt.textContent=Xf),na=n(e),m(Dt.$$.fragment,e),ra=n(e),It=i(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-gtrr4w"&&(It.textContent=Zf),ia=n(e),m(qt.$$.fragment,e),da=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-15hbb4u"&&(Kt.innerHTML=eh),aa=n(e),Bt=i(e,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-2ixnrf"&&(Bt.innerHTML=th),ua=n(e),Nt=i(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-xutatr"&&(Nt.innerHTML=lh),ma=n(e),pa=i(e,"HR",{}),ca=n(e),Qt=i(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),Ta=n(e),m(Vt.$$.fragment,e),fa=n(e),St=i(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1g8ouql"&&(St.textContent=sh),ha=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-19cc47x"&&(Ot.innerHTML=oh),_a=n(e),Ft=i(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1p49qvp"&&(Ft.innerHTML=nh),$a=n(e),ba=i(e,"HR",{}),va=n(e),Yt=i(e,"A",{id:!0,class:!0}),h(Yt).forEach(l),ya=n(e),m(Wt.$$.fragment,e),Ma=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-yjryb1"&&(Gt.textContent=rh),xa=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-xtr8tc"&&(Xt.innerHTML=ih),Ca=n(e),Zt=i(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-6xvdso"&&(Zt.innerHTML=dh),Ha=n(e),La=i(e,"HR",{}),wa=n(e),el=i(e,"A",{id:!0,class:!0}),h(el).forEach(l),Aa=n(e),m(tl.$$.fragment,e),ga=n(e),ll=i(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1okfsqx"&&(ll.textContent=ah),za=n(e),sl=i(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-bqi4bh"&&(sl.innerHTML=uh),Pa=n(e),ol=i(e,"TABLE",{"data-svelte-h":!0}),d(ol)!=="svelte-13m2wni"&&(ol.innerHTML=mh),Ra=n(e),Ua=i(e,"HR",{}),ka=n(e),nl=i(e,"A",{id:!0,class:!0}),h(nl).forEach(l),ja=n(e),m(rl.$$.fragment,e),Ea=n(e),il=i(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1htpbrk"&&(il.innerHTML=ph),Ja=n(e),dl=i(e,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-13o8e7b"&&(dl.innerHTML=ch),Da=n(e),al=i(e,"TABLE",{"data-svelte-h":!0}),d(al)!=="svelte-1qi99pl"&&(al.innerHTML=Th),Ia=n(e),qa=i(e,"HR",{}),Ka=n(e),ul=i(e,"A",{id:!0,class:!0}),h(ul).forEach(l),Ba=n(e),m(ml.$$.fragment,e),Na=n(e),pl=i(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ztgqp"&&(pl.innerHTML=fh),Qa=n(e),cl=i(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-oa1qug"&&(cl.innerHTML=hh),Va=n(e),Tl=i(e,"TABLE",{"data-svelte-h":!0}),d(Tl)!=="svelte-1qi99pl"&&(Tl.innerHTML=_h),Sa=n(e),Oa=i(e,"HR",{}),Fa=n(e),fl=i(e,"A",{id:!0,class:!0}),h(fl).forEach(l),Ya=n(e),m(hl.$$.fragment,e),Wa=n(e),_l=i(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1a7u185"&&(_l.textContent=$h),Ga=n(e),$l=i(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-1eu3doh"&&($l.innerHTML=bh),Xa=n(e),Za=i(e,"HR",{}),eu=n(e),bl=i(e,"A",{id:!0,class:!0}),h(bl).forEach(l),tu=n(e),m(vl.$$.fragment,e),lu=n(e),yl=i(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-qls17b"&&(yl.textContent=vh),su=n(e),Ml=i(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-5nabmy"&&(Ml.innerHTML=yh),ou=n(e),xl=i(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1fl56ed"&&(xl.innerHTML=Mh),nu=n(e),Cl=i(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-52pnzr"&&(Cl.innerHTML=xh),ru=n(e),iu=i(e,"HR",{}),du=n(e),Hl=i(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),au=n(e),m(Ll.$$.fragment,e),uu=n(e),wl=i(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-19w0pic"&&(wl.innerHTML=Ch),mu=n(e),Al=i(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1mr58c3"&&(Al.innerHTML=Hh),pu=n(e),cu=i(e,"HR",{}),Tu=n(e),gl=i(e,"A",{id:!0,class:!0}),h(gl).forEach(l),fu=n(e),m(zl.$$.fragment,e),hu=n(e),Pl=i(e,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-18ws76n"&&(Pl.textContent=Lh),_u=n(e),Rl=i(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1tnr5gm"&&(Rl.textContent=wh),$u=n(e),Ul=i(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-13m9nag"&&(Ul.innerHTML=Ah),bu=n(e),kl=i(e,"TABLE",{"data-svelte-h":!0}),d(kl)!=="svelte-1u9lyxp"&&(kl.innerHTML=gh),vu=n(e),yu=i(e,"HR",{}),Mu=n(e),jl=i(e,"A",{id:!0,class:!0}),h(jl).forEach(l),xu=n(e),m(El.$$.fragment,e),Cu=n(e),Jl=i(e,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1b9ygao"&&(Jl.innerHTML=zh),Hu=n(e),Dl=i(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1mr58c3"&&(Dl.innerHTML=Ph),Lu=n(e),wu=i(e,"HR",{}),Au=n(e),Il=i(e,"A",{id:!0,class:!0}),h(Il).forEach(l),gu=n(e),m(ql.$$.fragment,e),zu=n(e),Kl=i(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1vkr5xo"&&(Kl.innerHTML=Rh),Pu=n(e),Bl=i(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1mr58c3"&&(Bl.innerHTML=Uh),Ru=n(e),Uu=i(e,"HR",{}),ku=n(e),Nl=i(e,"A",{id:!0,class:!0}),h(Nl).forEach(l),ju=n(e),m(Ql.$$.fragment,e),Eu=n(e),Vl=i(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1gguudf"&&(Vl.innerHTML=kh),Ju=n(e),Sl=i(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1vf2xxu"&&(Sl.innerHTML=jh),Du=n(e),Ol=i(e,"TABLE",{"data-svelte-h":!0}),d(Ol)!=="svelte-z6whez"&&(Ol.innerHTML=Eh),Iu=n(e),qu=i(e,"HR",{}),Ku=n(e),Fl=i(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),Bu=n(e),m(Yl.$$.fragment,e),Nu=n(e),Wl=i(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-d6gvut"&&(Wl.innerHTML=Jh),Qu=n(e),Gl=i(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1ueenyl"&&(Gl.innerHTML=Dh),Vu=n(e),Xl=i(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-jj58dd"&&(Xl.innerHTML=Ih),Su=n(e),Ou=i(e,"HR",{}),Fu=n(e),Zl=i(e,"A",{id:!0,class:!0}),h(Zl).forEach(l),Yu=n(e),m(es.$$.fragment,e),Wu=n(e),ts=i(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1adolpg"&&(ts.innerHTML=qh),Gu=n(e),ls=i(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1mr58c3"&&(ls.innerHTML=Kh),Xu=n(e),Zu=i(e,"HR",{}),em=n(e),ss=i(e,"A",{id:!0,class:!0}),h(ss).forEach(l),tm=n(e),m(os.$$.fragment,e),lm=n(e),ns=i(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1hm8vtj"&&(ns.textContent=Bh),sm=n(e),rs=i(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-1mnx14"&&(rs.innerHTML=Nh),om=n(e),is=i(e,"TABLE",{"data-svelte-h":!0}),d(is)!=="svelte-9ff0sy"&&(is.innerHTML=Qh),nm=n(e),rm=i(e,"HR",{}),im=n(e),ds=i(e,"A",{id:!0,class:!0}),h(ds).forEach(l),dm=n(e),m(as.$$.fragment,e),am=n(e),us=i(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1e6kzks"&&(us.innerHTML=Vh),um=n(e),ms=i(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1mr58c3"&&(ms.innerHTML=Sh),mm=n(e),pm=i(e,"HR",{}),cm=n(e),ps=i(e,"A",{id:!0,class:!0}),h(ps).forEach(l),Tm=n(e),m(cs.$$.fragment,e),fm=n(e),Ts=i(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-t5k6jp"&&(Ts.textContent=Oh),hm=n(e),fs=i(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-1mnx14"&&(fs.innerHTML=Fh),_m=n(e),$m=i(e,"HR",{}),bm=n(e),hs=i(e,"A",{id:!0,class:!0}),h(hs).forEach(l),vm=n(e),m(_s.$$.fragment,e),ym=n(e),$s=i(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-avw2a1"&&($s.textContent=Yh),Mm=n(e),bs=i(e,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-3w87vv"&&(bs.innerHTML=Wh),xm=n(e),vs=i(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-jj5vaa"&&(vs.innerHTML=Gh),Cm=n(e),Hm=i(e,"HR",{}),Lm=n(e),ys=i(e,"A",{id:!0,class:!0}),h(ys).forEach(l),wm=n(e),m(Ms.$$.fragment,e),Am=n(e),xs=i(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-167n5bd"&&(xs.textContent=Xh),gm=n(e),Cs=i(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-74oixn"&&(Cs.innerHTML=Zh),zm=n(e),Hs=i(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1oyadc3"&&(Hs.innerHTML=e1),Pm=n(e),Rm=i(e,"HR",{}),Um=n(e),Ls=i(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),km=n(e),m(ws.$$.fragment,e),jm=n(e),As=i(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-fju8tm"&&(As.textContent=t1),Em=n(e),gs=i(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-16503uw"&&(gs.innerHTML=l1),Jm=n(e),zs=i(e,"TABLE",{"data-svelte-h":!0}),d(zs)!=="svelte-1no2z7v"&&(zs.innerHTML=s1),Dm=n(e),Im=i(e,"HR",{}),qm=n(e),Ps=i(e,"A",{id:!0,class:!0}),h(Ps).forEach(l),Km=n(e),m(Rs.$$.fragment,e),Bm=n(e),Us=i(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-18v04la"&&(Us.innerHTML=o1),Nm=n(e),ks=i(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-14kv4rj"&&(ks.innerHTML=n1),Qm=n(e),js=i(e,"TABLE",{"data-svelte-h":!0}),d(js)!=="svelte-1caupec"&&(js.innerHTML=r1),Vm=n(e),Sm=i(e,"HR",{}),Om=n(e),Es=i(e,"A",{id:!0,class:!0}),h(Es).forEach(l),Fm=n(e),m(Js.$$.fragment,e),Ym=n(e),Ds=i(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1yvow13"&&(Ds.innerHTML=i1),Wm=n(e),Is=i(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-fexugp"&&(Is.innerHTML=d1),Gm=n(e),qs=i(e,"TABLE",{"data-svelte-h":!0}),d(qs)!=="svelte-1t0kp7i"&&(qs.innerHTML=a1),Xm=n(e),Zm=i(e,"HR",{}),ep=n(e),Ks=i(e,"A",{id:!0,class:!0}),h(Ks).forEach(l),tp=n(e),m(Bs.$$.fragment,e),lp=n(e),Ns=i(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-19dtamh"&&(Ns.innerHTML=u1),sp=n(e),Qs=i(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1q9jl83"&&(Qs.innerHTML=m1),op=n(e),Vs=i(e,"TABLE",{"data-svelte-h":!0}),d(Vs)!=="svelte-po861j"&&(Vs.innerHTML=p1),np=n(e),rp=i(e,"HR",{}),ip=n(e),Ss=i(e,"A",{id:!0,class:!0}),h(Ss).forEach(l),dp=n(e),m(Os.$$.fragment,e),ap=n(e),Fs=i(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-bd7moq"&&(Fs.innerHTML=c1),up=n(e),Ys=i(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-jyg3bg"&&(Ys.innerHTML=T1),mp=n(e),Ws=i(e,"TABLE",{"data-svelte-h":!0}),d(Ws)!=="svelte-gsjwyf"&&(Ws.innerHTML=f1),pp=n(e),cp=i(e,"HR",{}),Tp=n(e),Gs=i(e,"A",{id:!0,class:!0}),h(Gs).forEach(l),fp=n(e),m(Xs.$$.fragment,e),hp=n(e),Zs=i(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-11ei68w"&&(Zs.textContent=h1),_p=n(e),eo=i(e,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-f0cseu"&&(eo.innerHTML=_1),$p=n(e),to=i(e,"TABLE",{"data-svelte-h":!0}),d(to)!=="svelte-1lgev2y"&&(to.innerHTML=$1),bp=n(e),vp=i(e,"HR",{}),yp=n(e),lo=i(e,"A",{id:!0,class:!0}),h(lo).forEach(l),Mp=n(e),m(so.$$.fragment,e),xp=n(e),oo=i(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-7ivim4"&&(oo.textContent=b1),Cp=n(e),no=i(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1t7ypd0"&&(no.innerHTML=v1),Hp=n(e),ro=i(e,"TABLE",{"data-svelte-h":!0}),d(ro)!=="svelte-1lmecr"&&(ro.innerHTML=y1),Lp=n(e),wp=i(e,"HR",{}),Ap=n(e),io=i(e,"A",{id:!0,class:!0}),h(io).forEach(l),gp=n(e),m(ao.$$.fragment,e),zp=n(e),uo=i(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-k6p1db"&&(uo.textContent=M1),Pp=n(e),mo=i(e,"P",{"data-svelte-h":!0}),d(mo)!=="svelte-6qi3ne"&&(mo.innerHTML=x1),Rp=n(e),po=i(e,"TABLE",{"data-svelte-h":!0}),d(po)!=="svelte-2flruf"&&(po.innerHTML=C1),Up=n(e),kp=i(e,"HR",{}),jp=n(e),co=i(e,"A",{id:!0,class:!0}),h(co).forEach(l),Ep=n(e),m(To.$$.fragment,e),Jp=n(e),fo=i(e,"P",{"data-svelte-h":!0}),d(fo)!=="svelte-8afo9v"&&(fo.textContent=H1),Dp=n(e),ho=i(e,"P",{"data-svelte-h":!0}),d(ho)!=="svelte-fnpm0s"&&(ho.innerHTML=L1),Ip=n(e),_o=i(e,"TABLE",{"data-svelte-h":!0}),d(_o)!=="svelte-1m3fin1"&&(_o.innerHTML=w1),qp=n(e),Kp=i(e,"HR",{}),Bp=n(e),$o=i(e,"A",{id:!0,class:!0}),h($o).forEach(l),Np=n(e),m(bo.$$.fragment,e),Qp=n(e),vo=i(e,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-11plveb"&&(vo.innerHTML=A1),Vp=n(e),yo=i(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-1k0sd0r"&&(yo.innerHTML=g1),Sp=n(e),Mo=i(e,"TABLE",{"data-svelte-h":!0}),d(Mo)!=="svelte-xda5g6"&&(Mo.innerHTML=z1),Op=n(e),Fp=i(e,"HR",{}),Yp=n(e),xo=i(e,"A",{id:!0,class:!0}),h(xo).forEach(l),Wp=n(e),m(Co.$$.fragment,e),Gp=n(e),Ho=i(e,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-17f4oxi"&&(Ho.textContent=P1),Xp=n(e),Lo=i(e,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-j8mnym"&&(Lo.innerHTML=R1),Zp=n(e),wo=i(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-8q2rcx"&&(wo.innerHTML=U1),ec=n(e),tc=i(e,"HR",{}),lc=n(e),Ao=i(e,"A",{id:!0,class:!0}),h(Ao).forEach(l),sc=n(e),m(go.$$.fragment,e),oc=n(e),zo=i(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-10qu7f7"&&(zo.textContent=k1),nc=n(e),Po=i(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-18rka45"&&(Po.innerHTML=j1),rc=n(e),Ro=i(e,"TABLE",{"data-svelte-h":!0}),d(Ro)!=="svelte-1xtb381"&&(Ro.innerHTML=E1),ic=n(e),dc=i(e,"HR",{}),ac=n(e),Uo=i(e,"A",{id:!0,class:!0}),h(Uo).forEach(l),uc=n(e),m(ko.$$.fragment,e),mc=n(e),jo=i(e,"P",{"data-svelte-h":!0}),d(jo)!=="svelte-1ayje0f"&&(jo.textContent=J1),pc=n(e),Eo=i(e,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-154ckak"&&(Eo.innerHTML=D1),cc=n(e),Jo=i(e,"TABLE",{"data-svelte-h":!0}),d(Jo)!=="svelte-gyxne1"&&(Jo.innerHTML=I1),Tc=n(e),fc=i(e,"HR",{}),hc=n(e),Do=i(e,"A",{id:!0,class:!0}),h(Do).forEach(l),_c=n(e),m(Io.$$.fragment,e),$c=n(e),qo=i(e,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1wvb8sq"&&(qo.textContent=q1),bc=n(e),Ko=i(e,"P",{"data-svelte-h":!0}),d(Ko)!=="svelte-154ckak"&&(Ko.innerHTML=K1),vc=n(e),Bo=i(e,"TABLE",{"data-svelte-h":!0}),d(Bo)!=="svelte-esxgyf"&&(Bo.innerHTML=B1),yc=n(e),Mc=i(e,"HR",{}),xc=n(e),No=i(e,"A",{id:!0,class:!0}),h(No).forEach(l),Cc=n(e),m(Qo.$$.fragment,e),Hc=n(e),Vo=i(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-1798kaw"&&(Vo.textContent=N1),Lc=n(e),So=i(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-ue1j5m"&&(So.innerHTML=Q1),wc=n(e),Oo=i(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-gyxne1"&&(Oo.innerHTML=V1),Ac=n(e),gc=i(e,"HR",{}),zc=n(e),Fo=i(e,"A",{id:!0,class:!0}),h(Fo).forEach(l),Pc=n(e),m(Yo.$$.fragment,e),Rc=n(e),Wo=i(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-9nnpip"&&(Wo.textContent=S1),Uc=n(e),Go=i(e,"P",{"data-svelte-h":!0}),d(Go)!=="svelte-ue1j5m"&&(Go.innerHTML=O1),kc=n(e),Xo=i(e,"TABLE",{"data-svelte-h":!0}),d(Xo)!=="svelte-esxgyf"&&(Xo.innerHTML=F1),jc=n(e),Ec=i(e,"HR",{}),Jc=n(e),Zo=i(e,"A",{id:!0,class:!0}),h(Zo).forEach(l),Dc=n(e),m(en.$$.fragment,e),Ic=n(e),tn=i(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-106iz9p"&&(tn.textContent=Y1),qc=n(e),ln=i(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-1uu5d6"&&(ln.innerHTML=W1),Kc=n(e),sn=i(e,"TABLE",{"data-svelte-h":!0}),d(sn)!=="svelte-gyxne1"&&(sn.innerHTML=G1),Bc=n(e),Nc=i(e,"HR",{}),Qc=n(e),on=i(e,"A",{id:!0,class:!0}),h(on).forEach(l),Vc=n(e),m(nn.$$.fragment,e),Sc=n(e),rn=i(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-185sm1b"&&(rn.textContent=X1),Oc=n(e),dn=i(e,"P",{"data-svelte-h":!0}),d(dn)!=="svelte-1a5fo0"&&(dn.innerHTML=Z1),Fc=n(e),an=i(e,"TABLE",{"data-svelte-h":!0}),d(an)!=="svelte-rf6ukr"&&(an.innerHTML=e_),Yc=n(e),Wc=i(e,"HR",{}),Gc=n(e),un=i(e,"A",{id:!0,class:!0}),h(un).forEach(l),Xc=n(e),m(mn.$$.fragment,e),Zc=n(e),pn=i(e,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-12loz97"&&(pn.innerHTML=t_),eT=n(e),tT=i(e,"HR",{}),lT=n(e),cn=i(e,"A",{id:!0,class:!0}),h(cn).forEach(l),sT=n(e),m(Tn.$$.fragment,e),oT=n(e),fn=i(e,"P",{"data-svelte-h":!0}),d(fn)!=="svelte-40isdg"&&(fn.textContent=l_),nT=n(e),hn=i(e,"P",{"data-svelte-h":!0}),d(hn)!=="svelte-tlsa2h"&&(hn.innerHTML=s_),rT=n(e),_n=i(e,"TABLE",{"data-svelte-h":!0}),d(_n)!=="svelte-17343p6"&&(_n.innerHTML=o_),iT=n(e),$n=i(e,"P",{"data-svelte-h":!0}),d($n)!=="svelte-1aswmub"&&($n.innerHTML=n_),dT=n(e),m(bn.$$.fragment,e),aT=n(e),uT=i(e,"HR",{}),mT=n(e),vn=i(e,"A",{id:!0,class:!0}),h(vn).forEach(l),pT=n(e),m(yn.$$.fragment,e),cT=n(e),Mn=i(e,"P",{"data-svelte-h":!0}),d(Mn)!=="svelte-kp31r8"&&(Mn.innerHTML=r_),TT=n(e),fT=i(e,"HR",{}),hT=n(e),xn=i(e,"A",{id:!0,class:!0}),h(xn).forEach(l),_T=n(e),m(Cn.$$.fragment,e),$T=n(e),Hn=i(e,"P",{"data-svelte-h":!0}),d(Hn)!=="svelte-1fs9no9"&&(Hn.innerHTML=i_),bT=n(e),vT=i(e,"HR",{}),yT=n(e),Ln=i(e,"A",{id:!0,class:!0}),h(Ln).forEach(l),MT=n(e),m(wn.$$.fragment,e),xT=n(e),An=i(e,"P",{"data-svelte-h":!0}),d(An)!=="svelte-2mif9c"&&(An.textContent=d_),CT=n(e),gn=i(e,"P",{"data-svelte-h":!0}),d(gn)!=="svelte-1jas2kw"&&(gn.innerHTML=a_),HT=n(e),m(zn.$$.fragment,e),LT=n(e),Pn=i(e,"P",{"data-svelte-h":!0}),d(Pn)!=="svelte-1aswmub"&&(Pn.innerHTML=u_),wT=n(e),m(Rn.$$.fragment,e),AT=n(e),Un=i(e,"P",{"data-svelte-h":!0}),d(Un)!=="svelte-1aswmub"&&(Un.innerHTML=m_),gT=n(e),m(kn.$$.fragment,e),zT=n(e),PT=i(e,"HR",{}),RT=n(e),m(jn.$$.fragment,e),UT=n(e),Dn=i(e,"P",{}),h(Dn).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",y_),a(b,"id","module_utils/tensor"),a(b,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(R,"id","module_utils/tensor.Tensor+dims"),a(R,"class","group"),a(E,"id","module_utils/tensor.Tensor+type"),a(E,"class","group"),a(q,"id","module_utils/tensor.Tensor+data"),a(q,"class","group"),a(Q,"id","module_utils/tensor.Tensor+size"),a(Q,"class","group"),a(F,"id","module_utils/tensor.Tensor+location"),a(F,"class","group"),a(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(X,"class","group"),a(le,"id","module_utils/tensor.Tensor+_getitem"),a(le,"class","group"),a(ie,"id","module_utils/tensor.Tensor+indexOf"),a(ie,"class","group"),a(me,"id","module_utils/tensor.Tensor+_subarray"),a(me,"class","group"),a(fe,"id","module_utils/tensor.Tensor+item"),a(fe,"class","group"),a(ve,"id","module_utils/tensor.Tensor+tolist"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ae,"class","group"),a(Re,"id","module_utils/tensor.Tensor+map"),a(Re,"class","group"),a(Je,"id","module_utils/tensor.Tensor+map_"),a(Je,"class","group"),a(Be,"id","module_utils/tensor.Tensor+mul"),a(Be,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+mul_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+div"),a(Xe,"class","group"),a(st,"id","module_utils/tensor.Tensor+div_"),a(st,"class","group"),a(dt,"id","module_utils/tensor.Tensor+add"),a(dt,"class","group"),a(ct,"id","module_utils/tensor.Tensor+add_"),a(ct,"class","group"),a($t,"id","module_utils/tensor.Tensor+sub"),a($t,"class","group"),a(xt,"id","module_utils/tensor.Tensor+sub_"),a(xt,"class","group"),a(At,"id","module_utils/tensor.Tensor+clone"),a(At,"class","group"),a(Rt,"id","module_utils/tensor.Tensor+slice"),a(Rt,"class","group"),a(Qt,"id","module_utils/tensor.Tensor+permute"),a(Qt,"class","group"),a(Yt,"id","module_utils/tensor.Tensor+sum"),a(Yt,"class","group"),a(el,"id","module_utils/tensor.Tensor+norm"),a(el,"class","group"),a(nl,"id","module_utils/tensor.Tensor+normalize_"),a(nl,"class","group"),a(ul,"id","module_utils/tensor.Tensor+normalize"),a(ul,"class","group"),a(fl,"id","module_utils/tensor.Tensor+stride"),a(fl,"class","group"),a(bl,"id","module_utils/tensor.Tensor+squeeze"),a(bl,"class","group"),a(Hl,"id","module_utils/tensor.Tensor+squeeze_"),a(Hl,"class","group"),a(gl,"id","module_utils/tensor.Tensor+unsqueeze"),a(gl,"class","group"),a(jl,"id","module_utils/tensor.Tensor+unsqueeze_"),a(jl,"class","group"),a(Il,"id","module_utils/tensor.Tensor+flatten_"),a(Il,"class","group"),a(Nl,"id","module_utils/tensor.Tensor+flatten"),a(Nl,"class","group"),a(Fl,"id","module_utils/tensor.Tensor+view"),a(Fl,"class","group"),a(Zl,"id","module_utils/tensor.Tensor+clamp_"),a(Zl,"class","group"),a(ss,"id","module_utils/tensor.Tensor+clamp"),a(ss,"class","group"),a(ds,"id","module_utils/tensor.Tensor+round_"),a(ds,"class","group"),a(ps,"id","module_utils/tensor.Tensor+round"),a(ps,"class","group"),a(hs,"id","module_utils/tensor.Tensor+to"),a(hs,"class","group"),a(ys,"id","module_utils/tensor.permute"),a(ys,"class","group"),a(Ls,"id","module_utils/tensor.interpolate"),a(Ls,"class","group"),a(Ps,"id","module_utils/tensor.interpolate_4d"),a(Ps,"class","group"),a(Es,"id","module_utils/tensor.matmul"),a(Es,"class","group"),a(Ks,"id","module_utils/tensor.rfft"),a(Ks,"class","group"),a(Ss,"id","module_utils/tensor.topk"),a(Ss,"class","group"),a(Gs,"id","module_utils/tensor.mean_pooling"),a(Gs,"class","group"),a(lo,"id","module_utils/tensor.layer_norm"),a(lo,"class","group"),a(io,"id","module_utils/tensor.cat"),a(io,"class","group"),a(co,"id","module_utils/tensor.stack"),a(co,"class","group"),a($o,"id","module_utils/tensor.std_mean"),a($o,"class","group"),a(xo,"id","module_utils/tensor.mean"),a(xo,"class","group"),a(Ao,"id","module_utils/tensor.full"),a(Ao,"class","group"),a(Uo,"id","module_utils/tensor.ones"),a(Uo,"class","group"),a(Do,"id","module_utils/tensor.ones_like"),a(Do,"class","group"),a(No,"id","module_utils/tensor.zeros"),a(No,"class","group"),a(Fo,"id","module_utils/tensor.zeros_like"),a(Fo,"class","group"),a(Zo,"id","module_utils/tensor.rand"),a(Zo,"class","group"),a(on,"id","module_utils/tensor.quantize_embeddings"),a(on,"class","group"),a(un,"id","module_utils/tensor..args[0]"),a(un,"class","group"),a(cn,"id","module_utils/tensor..reshape"),a(cn,"class","group"),a(vn,"id","module_utils/tensor..reshape..reshapedArray"),a(vn,"class","group"),a(xn,"id","module_utils/tensor..DataArray"),a(xn,"class","group"),a(Ln,"id","module_utils/tensor..NestArray"),a(Ln,"class","group")},m(e,t){$_(document.head,$),s(e,In,t),s(e,Jn,t),s(e,qn,t),s(e,b,t),s(e,Kn,t),p(v,e,t),s(e,Bn,t),s(e,y,t),s(e,Nn,t),s(e,M,t),s(e,Qn,t),s(e,x,t),s(e,Vn,t),s(e,Sn,t),s(e,On,t),s(e,C,t),s(e,Fn,t),p(H,e,t),s(e,Yn,t),s(e,L,t),s(e,Wn,t),s(e,w,t),s(e,Gn,t),s(e,Xn,t),s(e,Zn,t),s(e,A,t),s(e,er,t),p(g,e,t),s(e,tr,t),s(e,z,t),s(e,lr,t),s(e,P,t),s(e,sr,t),s(e,or,t),s(e,nr,t),s(e,R,t),s(e,rr,t),p(U,e,t),s(e,ir,t),s(e,k,t),s(e,dr,t),s(e,j,t),s(e,ar,t),s(e,ur,t),s(e,mr,t),s(e,E,t),s(e,pr,t),p(J,e,t),s(e,cr,t),s(e,D,t),s(e,Tr,t),s(e,I,t),s(e,fr,t),s(e,hr,t),s(e,_r,t),s(e,q,t),s(e,$r,t),p(K,e,t),s(e,br,t),s(e,B,t),s(e,vr,t),s(e,N,t),s(e,yr,t),s(e,Mr,t),s(e,xr,t),s(e,Q,t),s(e,Cr,t),p(V,e,t),s(e,Hr,t),s(e,S,t),s(e,Lr,t),s(e,O,t),s(e,wr,t),s(e,Ar,t),s(e,gr,t),s(e,F,t),s(e,zr,t),p(Y,e,t),s(e,Pr,t),s(e,W,t),s(e,Rr,t),s(e,G,t),s(e,Ur,t),s(e,kr,t),s(e,jr,t),s(e,X,t),s(e,Er,t),p(Z,e,t),s(e,Jr,t),s(e,ee,t),s(e,Dr,t),s(e,te,t),s(e,Ir,t),s(e,qr,t),s(e,Kr,t),s(e,le,t),s(e,Br,t),p(se,e,t),s(e,Nr,t),s(e,oe,t),s(e,Qr,t),s(e,ne,t),s(e,Vr,t),s(e,re,t),s(e,Sr,t),s(e,Or,t),s(e,Fr,t),s(e,ie,t),s(e,Yr,t),p(de,e,t),s(e,Wr,t),s(e,ae,t),s(e,Gr,t),s(e,ue,t),s(e,Xr,t),s(e,Zr,t),s(e,ei,t),s(e,me,t),s(e,ti,t),p(pe,e,t),s(e,li,t),s(e,ce,t),s(e,si,t),s(e,Te,t),s(e,oi,t),s(e,ni,t),s(e,ri,t),s(e,fe,t),s(e,ii,t),p(he,e,t),s(e,di,t),s(e,_e,t),s(e,ai,t),s(e,$e,t),s(e,ui,t),s(e,be,t),s(e,mi,t),s(e,pi,t),s(e,ci,t),s(e,ve,t),s(e,Ti,t),p(ye,e,t),s(e,fi,t),s(e,Me,t),s(e,hi,t),s(e,xe,t),s(e,_i,t),s(e,$i,t),s(e,bi,t),s(e,Ce,t),s(e,vi,t),p(He,e,t),s(e,yi,t),s(e,Le,t),s(e,Mi,t),s(e,we,t),s(e,xi,t),s(e,Ci,t),s(e,Hi,t),s(e,Ae,t),s(e,Li,t),p(ge,e,t),s(e,wi,t),s(e,ze,t),s(e,Ai,t),s(e,Pe,t),s(e,gi,t),s(e,zi,t),s(e,Pi,t),s(e,Re,t),s(e,Ri,t),p(Ue,e,t),s(e,Ui,t),s(e,ke,t),s(e,ki,t),s(e,je,t),s(e,ji,t),s(e,Ee,t),s(e,Ei,t),s(e,Ji,t),s(e,Di,t),s(e,Je,t),s(e,Ii,t),p(De,e,t),s(e,qi,t),s(e,Ie,t),s(e,Ki,t),s(e,qe,t),s(e,Bi,t),s(e,Ke,t),s(e,Ni,t),s(e,Qi,t),s(e,Vi,t),s(e,Be,t),s(e,Si,t),p(Ne,e,t),s(e,Oi,t),s(e,Qe,t),s(e,Fi,t),s(e,Ve,t),s(e,Yi,t),s(e,Se,t),s(e,Wi,t),s(e,Gi,t),s(e,Xi,t),s(e,Oe,t),s(e,Zi,t),p(Fe,e,t),s(e,ed,t),s(e,Ye,t),s(e,td,t),s(e,We,t),s(e,ld,t),s(e,Ge,t),s(e,sd,t),s(e,od,t),s(e,nd,t),s(e,Xe,t),s(e,rd,t),p(Ze,e,t),s(e,id,t),s(e,et,t),s(e,dd,t),s(e,tt,t),s(e,ad,t),s(e,lt,t),s(e,ud,t),s(e,md,t),s(e,pd,t),s(e,st,t),s(e,cd,t),p(ot,e,t),s(e,Td,t),s(e,nt,t),s(e,fd,t),s(e,rt,t),s(e,hd,t),s(e,it,t),s(e,_d,t),s(e,$d,t),s(e,bd,t),s(e,dt,t),s(e,vd,t),p(at,e,t),s(e,yd,t),s(e,ut,t),s(e,Md,t),s(e,mt,t),s(e,xd,t),s(e,pt,t),s(e,Cd,t),s(e,Hd,t),s(e,Ld,t),s(e,ct,t),s(e,wd,t),p(Tt,e,t),s(e,Ad,t),s(e,ft,t),s(e,gd,t),s(e,ht,t),s(e,zd,t),s(e,_t,t),s(e,Pd,t),s(e,Rd,t),s(e,Ud,t),s(e,$t,t),s(e,kd,t),p(bt,e,t),s(e,jd,t),s(e,vt,t),s(e,Ed,t),s(e,yt,t),s(e,Jd,t),s(e,Mt,t),s(e,Dd,t),s(e,Id,t),s(e,qd,t),s(e,xt,t),s(e,Kd,t),p(Ct,e,t),s(e,Bd,t),s(e,Ht,t),s(e,Nd,t),s(e,Lt,t),s(e,Qd,t),s(e,wt,t),s(e,Vd,t),s(e,Sd,t),s(e,Od,t),s(e,At,t),s(e,Fd,t),p(gt,e,t),s(e,Yd,t),s(e,zt,t),s(e,Wd,t),s(e,Pt,t),s(e,Gd,t),s(e,Xd,t),s(e,Zd,t),s(e,Rt,t),s(e,ea,t),p(Ut,e,t),s(e,ta,t),s(e,kt,t),s(e,la,t),s(e,jt,t),s(e,sa,t),p(Et,e,t),s(e,oa,t),s(e,Jt,t),s(e,na,t),p(Dt,e,t),s(e,ra,t),s(e,It,t),s(e,ia,t),p(qt,e,t),s(e,da,t),s(e,Kt,t),s(e,aa,t),s(e,Bt,t),s(e,ua,t),s(e,Nt,t),s(e,ma,t),s(e,pa,t),s(e,ca,t),s(e,Qt,t),s(e,Ta,t),p(Vt,e,t),s(e,fa,t),s(e,St,t),s(e,ha,t),s(e,Ot,t),s(e,_a,t),s(e,Ft,t),s(e,$a,t),s(e,ba,t),s(e,va,t),s(e,Yt,t),s(e,ya,t),p(Wt,e,t),s(e,Ma,t),s(e,Gt,t),s(e,xa,t),s(e,Xt,t),s(e,Ca,t),s(e,Zt,t),s(e,Ha,t),s(e,La,t),s(e,wa,t),s(e,el,t),s(e,Aa,t),p(tl,e,t),s(e,ga,t),s(e,ll,t),s(e,za,t),s(e,sl,t),s(e,Pa,t),s(e,ol,t),s(e,Ra,t),s(e,Ua,t),s(e,ka,t),s(e,nl,t),s(e,ja,t),p(rl,e,t),s(e,Ea,t),s(e,il,t),s(e,Ja,t),s(e,dl,t),s(e,Da,t),s(e,al,t),s(e,Ia,t),s(e,qa,t),s(e,Ka,t),s(e,ul,t),s(e,Ba,t),p(ml,e,t),s(e,Na,t),s(e,pl,t),s(e,Qa,t),s(e,cl,t),s(e,Va,t),s(e,Tl,t),s(e,Sa,t),s(e,Oa,t),s(e,Fa,t),s(e,fl,t),s(e,Ya,t),p(hl,e,t),s(e,Wa,t),s(e,_l,t),s(e,Ga,t),s(e,$l,t),s(e,Xa,t),s(e,Za,t),s(e,eu,t),s(e,bl,t),s(e,tu,t),p(vl,e,t),s(e,lu,t),s(e,yl,t),s(e,su,t),s(e,Ml,t),s(e,ou,t),s(e,xl,t),s(e,nu,t),s(e,Cl,t),s(e,ru,t),s(e,iu,t),s(e,du,t),s(e,Hl,t),s(e,au,t),p(Ll,e,t),s(e,uu,t),s(e,wl,t),s(e,mu,t),s(e,Al,t),s(e,pu,t),s(e,cu,t),s(e,Tu,t),s(e,gl,t),s(e,fu,t),p(zl,e,t),s(e,hu,t),s(e,Pl,t),s(e,_u,t),s(e,Rl,t),s(e,$u,t),s(e,Ul,t),s(e,bu,t),s(e,kl,t),s(e,vu,t),s(e,yu,t),s(e,Mu,t),s(e,jl,t),s(e,xu,t),p(El,e,t),s(e,Cu,t),s(e,Jl,t),s(e,Hu,t),s(e,Dl,t),s(e,Lu,t),s(e,wu,t),s(e,Au,t),s(e,Il,t),s(e,gu,t),p(ql,e,t),s(e,zu,t),s(e,Kl,t),s(e,Pu,t),s(e,Bl,t),s(e,Ru,t),s(e,Uu,t),s(e,ku,t),s(e,Nl,t),s(e,ju,t),p(Ql,e,t),s(e,Eu,t),s(e,Vl,t),s(e,Ju,t),s(e,Sl,t),s(e,Du,t),s(e,Ol,t),s(e,Iu,t),s(e,qu,t),s(e,Ku,t),s(e,Fl,t),s(e,Bu,t),p(Yl,e,t),s(e,Nu,t),s(e,Wl,t),s(e,Qu,t),s(e,Gl,t),s(e,Vu,t),s(e,Xl,t),s(e,Su,t),s(e,Ou,t),s(e,Fu,t),s(e,Zl,t),s(e,Yu,t),p(es,e,t),s(e,Wu,t),s(e,ts,t),s(e,Gu,t),s(e,ls,t),s(e,Xu,t),s(e,Zu,t),s(e,em,t),s(e,ss,t),s(e,tm,t),p(os,e,t),s(e,lm,t),s(e,ns,t),s(e,sm,t),s(e,rs,t),s(e,om,t),s(e,is,t),s(e,nm,t),s(e,rm,t),s(e,im,t),s(e,ds,t),s(e,dm,t),p(as,e,t),s(e,am,t),s(e,us,t),s(e,um,t),s(e,ms,t),s(e,mm,t),s(e,pm,t),s(e,cm,t),s(e,ps,t),s(e,Tm,t),p(cs,e,t),s(e,fm,t),s(e,Ts,t),s(e,hm,t),s(e,fs,t),s(e,_m,t),s(e,$m,t),s(e,bm,t),s(e,hs,t),s(e,vm,t),p(_s,e,t),s(e,ym,t),s(e,$s,t),s(e,Mm,t),s(e,bs,t),s(e,xm,t),s(e,vs,t),s(e,Cm,t),s(e,Hm,t),s(e,Lm,t),s(e,ys,t),s(e,wm,t),p(Ms,e,t),s(e,Am,t),s(e,xs,t),s(e,gm,t),s(e,Cs,t),s(e,zm,t),s(e,Hs,t),s(e,Pm,t),s(e,Rm,t),s(e,Um,t),s(e,Ls,t),s(e,km,t),p(ws,e,t),s(e,jm,t),s(e,As,t),s(e,Em,t),s(e,gs,t),s(e,Jm,t),s(e,zs,t),s(e,Dm,t),s(e,Im,t),s(e,qm,t),s(e,Ps,t),s(e,Km,t),p(Rs,e,t),s(e,Bm,t),s(e,Us,t),s(e,Nm,t),s(e,ks,t),s(e,Qm,t),s(e,js,t),s(e,Vm,t),s(e,Sm,t),s(e,Om,t),s(e,Es,t),s(e,Fm,t),p(Js,e,t),s(e,Ym,t),s(e,Ds,t),s(e,Wm,t),s(e,Is,t),s(e,Gm,t),s(e,qs,t),s(e,Xm,t),s(e,Zm,t),s(e,ep,t),s(e,Ks,t),s(e,tp,t),p(Bs,e,t),s(e,lp,t),s(e,Ns,t),s(e,sp,t),s(e,Qs,t),s(e,op,t),s(e,Vs,t),s(e,np,t),s(e,rp,t),s(e,ip,t),s(e,Ss,t),s(e,dp,t),p(Os,e,t),s(e,ap,t),s(e,Fs,t),s(e,up,t),s(e,Ys,t),s(e,mp,t),s(e,Ws,t),s(e,pp,t),s(e,cp,t),s(e,Tp,t),s(e,Gs,t),s(e,fp,t),p(Xs,e,t),s(e,hp,t),s(e,Zs,t),s(e,_p,t),s(e,eo,t),s(e,$p,t),s(e,to,t),s(e,bp,t),s(e,vp,t),s(e,yp,t),s(e,lo,t),s(e,Mp,t),p(so,e,t),s(e,xp,t),s(e,oo,t),s(e,Cp,t),s(e,no,t),s(e,Hp,t),s(e,ro,t),s(e,Lp,t),s(e,wp,t),s(e,Ap,t),s(e,io,t),s(e,gp,t),p(ao,e,t),s(e,zp,t),s(e,uo,t),s(e,Pp,t),s(e,mo,t),s(e,Rp,t),s(e,po,t),s(e,Up,t),s(e,kp,t),s(e,jp,t),s(e,co,t),s(e,Ep,t),p(To,e,t),s(e,Jp,t),s(e,fo,t),s(e,Dp,t),s(e,ho,t),s(e,Ip,t),s(e,_o,t),s(e,qp,t),s(e,Kp,t),s(e,Bp,t),s(e,$o,t),s(e,Np,t),p(bo,e,t),s(e,Qp,t),s(e,vo,t),s(e,Vp,t),s(e,yo,t),s(e,Sp,t),s(e,Mo,t),s(e,Op,t),s(e,Fp,t),s(e,Yp,t),s(e,xo,t),s(e,Wp,t),p(Co,e,t),s(e,Gp,t),s(e,Ho,t),s(e,Xp,t),s(e,Lo,t),s(e,Zp,t),s(e,wo,t),s(e,ec,t),s(e,tc,t),s(e,lc,t),s(e,Ao,t),s(e,sc,t),p(go,e,t),s(e,oc,t),s(e,zo,t),s(e,nc,t),s(e,Po,t),s(e,rc,t),s(e,Ro,t),s(e,ic,t),s(e,dc,t),s(e,ac,t),s(e,Uo,t),s(e,uc,t),p(ko,e,t),s(e,mc,t),s(e,jo,t),s(e,pc,t),s(e,Eo,t),s(e,cc,t),s(e,Jo,t),s(e,Tc,t),s(e,fc,t),s(e,hc,t),s(e,Do,t),s(e,_c,t),p(Io,e,t),s(e,$c,t),s(e,qo,t),s(e,bc,t),s(e,Ko,t),s(e,vc,t),s(e,Bo,t),s(e,yc,t),s(e,Mc,t),s(e,xc,t),s(e,No,t),s(e,Cc,t),p(Qo,e,t),s(e,Hc,t),s(e,Vo,t),s(e,Lc,t),s(e,So,t),s(e,wc,t),s(e,Oo,t),s(e,Ac,t),s(e,gc,t),s(e,zc,t),s(e,Fo,t),s(e,Pc,t),p(Yo,e,t),s(e,Rc,t),s(e,Wo,t),s(e,Uc,t),s(e,Go,t),s(e,kc,t),s(e,Xo,t),s(e,jc,t),s(e,Ec,t),s(e,Jc,t),s(e,Zo,t),s(e,Dc,t),p(en,e,t),s(e,Ic,t),s(e,tn,t),s(e,qc,t),s(e,ln,t),s(e,Kc,t),s(e,sn,t),s(e,Bc,t),s(e,Nc,t),s(e,Qc,t),s(e,on,t),s(e,Vc,t),p(nn,e,t),s(e,Sc,t),s(e,rn,t),s(e,Oc,t),s(e,dn,t),s(e,Fc,t),s(e,an,t),s(e,Yc,t),s(e,Wc,t),s(e,Gc,t),s(e,un,t),s(e,Xc,t),p(mn,e,t),s(e,Zc,t),s(e,pn,t),s(e,eT,t),s(e,tT,t),s(e,lT,t),s(e,cn,t),s(e,sT,t),p(Tn,e,t),s(e,oT,t),s(e,fn,t),s(e,nT,t),s(e,hn,t),s(e,rT,t),s(e,_n,t),s(e,iT,t),s(e,$n,t),s(e,dT,t),p(bn,e,t),s(e,aT,t),s(e,uT,t),s(e,mT,t),s(e,vn,t),s(e,pT,t),p(yn,e,t),s(e,cT,t),s(e,Mn,t),s(e,TT,t),s(e,fT,t),s(e,hT,t),s(e,xn,t),s(e,_T,t),p(Cn,e,t),s(e,$T,t),s(e,Hn,t),s(e,bT,t),s(e,vT,t),s(e,yT,t),s(e,Ln,t),s(e,MT,t),p(wn,e,t),s(e,xT,t),s(e,An,t),s(e,CT,t),s(e,gn,t),s(e,HT,t),p(zn,e,t),s(e,LT,t),s(e,Pn,t),s(e,wT,t),p(Rn,e,t),s(e,AT,t),s(e,Un,t),s(e,gT,t),p(kn,e,t),s(e,zT,t),s(e,PT,t),s(e,RT,t),p(jn,e,t),s(e,UT,t),s(e,Dn,t),kT=!0},p:c_,i(e){kT||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Ue.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(Tt.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(Ut.$$.fragment,e),c(Et.$$.fragment,e),c(Dt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(tl.$$.fragment,e),c(rl.$$.fragment,e),c(ml.$$.fragment,e),c(hl.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(zl.$$.fragment,e),c(El.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(es.$$.fragment,e),c(os.$$.fragment,e),c(as.$$.fragment,e),c(cs.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Rs.$$.fragment,e),c(Js.$$.fragment,e),c(Bs.$$.fragment,e),c(Os.$$.fragment,e),c(Xs.$$.fragment,e),c(so.$$.fragment,e),c(ao.$$.fragment,e),c(To.$$.fragment,e),c(bo.$$.fragment,e),c(Co.$$.fragment,e),c(go.$$.fragment,e),c(ko.$$.fragment,e),c(Io.$$.fragment,e),c(Qo.$$.fragment,e),c(Yo.$$.fragment,e),c(en.$$.fragment,e),c(nn.$$.fragment,e),c(mn.$$.fragment,e),c(Tn.$$.fragment,e),c(bn.$$.fragment,e),c(yn.$$.fragment,e),c(Cn.$$.fragment,e),c(wn.$$.fragment,e),c(zn.$$.fragment,e),c(Rn.$$.fragment,e),c(kn.$$.fragment,e),c(jn.$$.fragment,e),kT=!0)},o(e){T(v.$$.fragment,e),T(H.$$.fragment,e),T(g.$$.fragment,e),T(U.$$.fragment,e),T(J.$$.fragment,e),T(K.$$.fragment,e),T(V.$$.fragment,e),T(Y.$$.fragment,e),T(Z.$$.fragment,e),T(se.$$.fragment,e),T(de.$$.fragment,e),T(pe.$$.fragment,e),T(he.$$.fragment,e),T(ye.$$.fragment,e),T(He.$$.fragment,e),T(ge.$$.fragment,e),T(Ue.$$.fragment,e),T(De.$$.fragment,e),T(Ne.$$.fragment,e),T(Fe.$$.fragment,e),T(Ze.$$.fragment,e),T(ot.$$.fragment,e),T(at.$$.fragment,e),T(Tt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(gt.$$.fragment,e),T(Ut.$$.fragment,e),T(Et.$$.fragment,e),T(Dt.$$.fragment,e),T(qt.$$.fragment,e),T(Vt.$$.fragment,e),T(Wt.$$.fragment,e),T(tl.$$.fragment,e),T(rl.$$.fragment,e),T(ml.$$.fragment,e),T(hl.$$.fragment,e),T(vl.$$.fragment,e),T(Ll.$$.fragment,e),T(zl.$$.fragment,e),T(El.$$.fragment,e),T(ql.$$.fragment,e),T(Ql.$$.fragment,e),T(Yl.$$.fragment,e),T(es.$$.fragment,e),T(os.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(_s.$$.fragment,e),T(Ms.$$.fragment,e),T(ws.$$.fragment,e),T(Rs.$$.fragment,e),T(Js.$$.fragment,e),T(Bs.$$.fragment,e),T(Os.$$.fragment,e),T(Xs.$$.fragment,e),T(so.$$.fragment,e),T(ao.$$.fragment,e),T(To.$$.fragment,e),T(bo.$$.fragment,e),T(Co.$$.fragment,e),T(go.$$.fragment,e),T(ko.$$.fragment,e),T(Io.$$.fragment,e),T(Qo.$$.fragment,e),T(Yo.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(mn.$$.fragment,e),T(Tn.$$.fragment,e),T(bn.$$.fragment,e),T(yn.$$.fragment,e),T(Cn.$$.fragment,e),T(wn.$$.fragment,e),T(zn.$$.fragment,e),T(Rn.$$.fragment,e),T(kn.$$.fragment,e),T(jn.$$.fragment,e),kT=!1},d(e){e&&(l(In),l(Jn),l(qn),l(b),l(Kn),l(Bn),l(y),l(Nn),l(M),l(Qn),l(x),l(Vn),l(Sn),l(On),l(C),l(Fn),l(Yn),l(L),l(Wn),l(w),l(Gn),l(Xn),l(Zn),l(A),l(er),l(tr),l(z),l(lr),l(P),l(sr),l(or),l(nr),l(R),l(rr),l(ir),l(k),l(dr),l(j),l(ar),l(ur),l(mr),l(E),l(pr),l(cr),l(D),l(Tr),l(I),l(fr),l(hr),l(_r),l(q),l($r),l(br),l(B),l(vr),l(N),l(yr),l(Mr),l(xr),l(Q),l(Cr),l(Hr),l(S),l(Lr),l(O),l(wr),l(Ar),l(gr),l(F),l(zr),l(Pr),l(W),l(Rr),l(G),l(Ur),l(kr),l(jr),l(X),l(Er),l(Jr),l(ee),l(Dr),l(te),l(Ir),l(qr),l(Kr),l(le),l(Br),l(Nr),l(oe),l(Qr),l(ne),l(Vr),l(re),l(Sr),l(Or),l(Fr),l(ie),l(Yr),l(Wr),l(ae),l(Gr),l(ue),l(Xr),l(Zr),l(ei),l(me),l(ti),l(li),l(ce),l(si),l(Te),l(oi),l(ni),l(ri),l(fe),l(ii),l(di),l(_e),l(ai),l($e),l(ui),l(be),l(mi),l(pi),l(ci),l(ve),l(Ti),l(fi),l(Me),l(hi),l(xe),l(_i),l($i),l(bi),l(Ce),l(vi),l(yi),l(Le),l(Mi),l(we),l(xi),l(Ci),l(Hi),l(Ae),l(Li),l(wi),l(ze),l(Ai),l(Pe),l(gi),l(zi),l(Pi),l(Re),l(Ri),l(Ui),l(ke),l(ki),l(je),l(ji),l(Ee),l(Ei),l(Ji),l(Di),l(Je),l(Ii),l(qi),l(Ie),l(Ki),l(qe),l(Bi),l(Ke),l(Ni),l(Qi),l(Vi),l(Be),l(Si),l(Oi),l(Qe),l(Fi),l(Ve),l(Yi),l(Se),l(Wi),l(Gi),l(Xi),l(Oe),l(Zi),l(ed),l(Ye),l(td),l(We),l(ld),l(Ge),l(sd),l(od),l(nd),l(Xe),l(rd),l(id),l(et),l(dd),l(tt),l(ad),l(lt),l(ud),l(md),l(pd),l(st),l(cd),l(Td),l(nt),l(fd),l(rt),l(hd),l(it),l(_d),l($d),l(bd),l(dt),l(vd),l(yd),l(ut),l(Md),l(mt),l(xd),l(pt),l(Cd),l(Hd),l(Ld),l(ct),l(wd),l(Ad),l(ft),l(gd),l(ht),l(zd),l(_t),l(Pd),l(Rd),l(Ud),l($t),l(kd),l(jd),l(vt),l(Ed),l(yt),l(Jd),l(Mt),l(Dd),l(Id),l(qd),l(xt),l(Kd),l(Bd),l(Ht),l(Nd),l(Lt),l(Qd),l(wt),l(Vd),l(Sd),l(Od),l(At),l(Fd),l(Yd),l(zt),l(Wd),l(Pt),l(Gd),l(Xd),l(Zd),l(Rt),l(ea),l(ta),l(kt),l(la),l(jt),l(sa),l(oa),l(Jt),l(na),l(ra),l(It),l(ia),l(da),l(Kt),l(aa),l(Bt),l(ua),l(Nt),l(ma),l(pa),l(ca),l(Qt),l(Ta),l(fa),l(St),l(ha),l(Ot),l(_a),l(Ft),l($a),l(ba),l(va),l(Yt),l(ya),l(Ma),l(Gt),l(xa),l(Xt),l(Ca),l(Zt),l(Ha),l(La),l(wa),l(el),l(Aa),l(ga),l(ll),l(za),l(sl),l(Pa),l(ol),l(Ra),l(Ua),l(ka),l(nl),l(ja),l(Ea),l(il),l(Ja),l(dl),l(Da),l(al),l(Ia),l(qa),l(Ka),l(ul),l(Ba),l(Na),l(pl),l(Qa),l(cl),l(Va),l(Tl),l(Sa),l(Oa),l(Fa),l(fl),l(Ya),l(Wa),l(_l),l(Ga),l($l),l(Xa),l(Za),l(eu),l(bl),l(tu),l(lu),l(yl),l(su),l(Ml),l(ou),l(xl),l(nu),l(Cl),l(ru),l(iu),l(du),l(Hl),l(au),l(uu),l(wl),l(mu),l(Al),l(pu),l(cu),l(Tu),l(gl),l(fu),l(hu),l(Pl),l(_u),l(Rl),l($u),l(Ul),l(bu),l(kl),l(vu),l(yu),l(Mu),l(jl),l(xu),l(Cu),l(Jl),l(Hu),l(Dl),l(Lu),l(wu),l(Au),l(Il),l(gu),l(zu),l(Kl),l(Pu),l(Bl),l(Ru),l(Uu),l(ku),l(Nl),l(ju),l(Eu),l(Vl),l(Ju),l(Sl),l(Du),l(Ol),l(Iu),l(qu),l(Ku),l(Fl),l(Bu),l(Nu),l(Wl),l(Qu),l(Gl),l(Vu),l(Xl),l(Su),l(Ou),l(Fu),l(Zl),l(Yu),l(Wu),l(ts),l(Gu),l(ls),l(Xu),l(Zu),l(em),l(ss),l(tm),l(lm),l(ns),l(sm),l(rs),l(om),l(is),l(nm),l(rm),l(im),l(ds),l(dm),l(am),l(us),l(um),l(ms),l(mm),l(pm),l(cm),l(ps),l(Tm),l(fm),l(Ts),l(hm),l(fs),l(_m),l($m),l(bm),l(hs),l(vm),l(ym),l($s),l(Mm),l(bs),l(xm),l(vs),l(Cm),l(Hm),l(Lm),l(ys),l(wm),l(Am),l(xs),l(gm),l(Cs),l(zm),l(Hs),l(Pm),l(Rm),l(Um),l(Ls),l(km),l(jm),l(As),l(Em),l(gs),l(Jm),l(zs),l(Dm),l(Im),l(qm),l(Ps),l(Km),l(Bm),l(Us),l(Nm),l(ks),l(Qm),l(js),l(Vm),l(Sm),l(Om),l(Es),l(Fm),l(Ym),l(Ds),l(Wm),l(Is),l(Gm),l(qs),l(Xm),l(Zm),l(ep),l(Ks),l(tp),l(lp),l(Ns),l(sp),l(Qs),l(op),l(Vs),l(np),l(rp),l(ip),l(Ss),l(dp),l(ap),l(Fs),l(up),l(Ys),l(mp),l(Ws),l(pp),l(cp),l(Tp),l(Gs),l(fp),l(hp),l(Zs),l(_p),l(eo),l($p),l(to),l(bp),l(vp),l(yp),l(lo),l(Mp),l(xp),l(oo),l(Cp),l(no),l(Hp),l(ro),l(Lp),l(wp),l(Ap),l(io),l(gp),l(zp),l(uo),l(Pp),l(mo),l(Rp),l(po),l(Up),l(kp),l(jp),l(co),l(Ep),l(Jp),l(fo),l(Dp),l(ho),l(Ip),l(_o),l(qp),l(Kp),l(Bp),l($o),l(Np),l(Qp),l(vo),l(Vp),l(yo),l(Sp),l(Mo),l(Op),l(Fp),l(Yp),l(xo),l(Wp),l(Gp),l(Ho),l(Xp),l(Lo),l(Zp),l(wo),l(ec),l(tc),l(lc),l(Ao),l(sc),l(oc),l(zo),l(nc),l(Po),l(rc),l(Ro),l(ic),l(dc),l(ac),l(Uo),l(uc),l(mc),l(jo),l(pc),l(Eo),l(cc),l(Jo),l(Tc),l(fc),l(hc),l(Do),l(_c),l($c),l(qo),l(bc),l(Ko),l(vc),l(Bo),l(yc),l(Mc),l(xc),l(No),l(Cc),l(Hc),l(Vo),l(Lc),l(So),l(wc),l(Oo),l(Ac),l(gc),l(zc),l(Fo),l(Pc),l(Rc),l(Wo),l(Uc),l(Go),l(kc),l(Xo),l(jc),l(Ec),l(Jc),l(Zo),l(Dc),l(Ic),l(tn),l(qc),l(ln),l(Kc),l(sn),l(Bc),l(Nc),l(Qc),l(on),l(Vc),l(Sc),l(rn),l(Oc),l(dn),l(Fc),l(an),l(Yc),l(Wc),l(Gc),l(un),l(Xc),l(Zc),l(pn),l(eT),l(tT),l(lT),l(cn),l(sT),l(oT),l(fn),l(nT),l(hn),l(rT),l(_n),l(iT),l($n),l(dT),l(aT),l(uT),l(mT),l(vn),l(pT),l(cT),l(Mn),l(TT),l(fT),l(hT),l(xn),l(_T),l($T),l(Hn),l(bT),l(vT),l(yT),l(Ln),l(MT),l(xT),l(An),l(CT),l(gn),l(HT),l(LT),l(Pn),l(wT),l(AT),l(Un),l(gT),l(zT),l(PT),l(RT),l(UT),l(Dn)),l($),f(v,e),f(H,e),f(g,e),f(U,e),f(J,e),f(K,e),f(V,e),f(Y,e),f(Z,e),f(se,e),f(de,e),f(pe,e),f(he,e),f(ye,e),f(He,e),f(ge,e),f(Ue,e),f(De,e),f(Ne,e),f(Fe,e),f(Ze,e),f(ot,e),f(at,e),f(Tt,e),f(bt,e),f(Ct,e),f(gt,e),f(Ut,e),f(Et,e),f(Dt,e),f(qt,e),f(Vt,e),f(Wt,e),f(tl,e),f(rl,e),f(ml,e),f(hl,e),f(vl,e),f(Ll,e),f(zl,e),f(El,e),f(ql,e),f(Ql,e),f(Yl,e),f(es,e),f(os,e),f(as,e),f(cs,e),f(_s,e),f(Ms,e),f(ws,e),f(Rs,e),f(Js,e),f(Bs,e),f(Os,e),f(Xs,e),f(so,e),f(ao,e),f(To,e),f(bo,e),f(Co,e),f(go,e),f(ko,e),f(Io,e),f(Qo,e),f(Yo,e),f(en,e),f(nn,e),f(mn,e),f(Tn,e),f(bn,e),f(yn,e),f(Cn,e),f(wn,e),f(zn,e),f(Rn,e),f(kn,e),f(jn,e)}}}const y_='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clone() ⇒ <code> Tensor </code>","local":"tensorclone--code-tensor-code","sections":[],"depth":3},{"title":"tensor.slice(...slices) ⇒ <code> Tensor </code>","local":"tensorsliceslices--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.rand(size) ⇒ <code> Tensor </code>","local":"utilstensorrandsize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function M_(jT){return T_(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class w_ extends f_{constructor($){super(),h_(this,$,M_,v_,p_,{})}}export{w_ as component};
