import{s as sn,n as ln,o as on}from"../chunks/scheduler.37c15a92.js";import{S as rn,i as pn,g as l,s,r as p,A as mn,h as o,f as n,c as i,j as an,u as m,x as r,k as fe,y as cn,a,v as c,d,t as u,w as h}from"../chunks/index.7cb9c9b8.js";import{C as be}from"../chunks/CodeBlock.a6d3f852.js";import{H as b,E as dn}from"../chunks/EditOnGithub.858acfec.js";function un(vt){let f,ye,ge,ve,w,we,T,Te,J,Je,j,wt="DIAMBRA Arena Environments usage follows the standard RL interaction framework: the agent sends an action to the environment, which process it and performs a transition accordingly, from the starting state to the new state, returning the observation and the reward to the agent to close the interaction loop. The figure below shows this typical interaction scheme and data flow.",je,g,Tt='<img src="https://raw.githubusercontent.com/diambra/arena/main/img/basicUsage.png" alt="diambraArena" style="width:600px; height:auto;"/>',$e,$,Jt="The shortest snippet for a complete basic execution of an environment consists of just a few lines of code, and is presented in the code block below:",Be,B,Ce,C,Ue,U,jt="DIAMBRA Arena comes with a very handy tool: the DIAMBRA Command Line Interface (DIAMBRA CLI). It provides different useful commands, with related options, that contribute to make running DIAMBRA Arena environments super easy.",_e,_,$t="To run a python script using the CLI, one can just execute the following command:",We,W,Ie,I,Bt='More information on the CLI can be found in the official documentation on <a href="https://docs.diambra.ai/gettingstarted/#diambra-command-line-interface-cli" rel="nofollow">this page</a>.',xe,x,Ze,Z,Ct="All environments have different options that can be specified using a dedicated <code>EnvironmentSettings</code> class. They are nested as follows:",Re,R,Ut="<li><strong>Environment settings</strong>: defined only when the environment is instantiated, they never change throughout the agent-environment interaction (e.g. the action space or the frame size)<ul><li><strong>Episode settings</strong>: defined first when the environment is instantiated, they can be changed each time a new episode starts, i.e. at every environment <code>reset</code> call, passing a dictionary containing the key-value pairs for the settings of interest through the <code>options</code> keyword argument. These settings are further divided in:<ul><li><strong>Game settings</strong>: they specify features of the game (e.g. difficulty level)</li> <li><strong>Player settings</strong>: they specify player-related aspects (e.g. selected character and its outfits)</li></ul></li></ul></li>",ke,k,_t="Settings specification when instantiating the environment is done by passing the <code>EnvironmentSettings</code> class, properly filled, to the environment <code>make</code> call as follows:",He,H,Xe,X,Wt="The first argument is the <code>game_id</code> string, it specifies the game to execute among those available. Episode settings specification at reset is done by passing the <code>episode_settings</code> dictionary to the environment <code>reset</code> call as follows:",Ee,E,Ae,A,It='Some of them are shared among all environments while others are specific to the selected game. The detailed settings description can be found in the official documentation at <a href="https://docs.diambra.ai/envs/#settings" rel="nofollow">this page</a> for the shared settings, and at <a href="https://docs.diambra.ai/envs/games/sfiii3n/#game-settings" rel="nofollow">this page</a> for the Street Fighter specific ones.',ze,z,Ge,G,xt='Actions of the interfaced games can be grouped in two categories: move actions (Up, Left, etc.) and attack ones (Punch, Kick, etc.). DIAMBRA Arena provides two different action spaces: <a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/discrete.py" rel="nofollow">Discrete</a> and <a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/multi_discrete.py" rel="nofollow">MultiDiscrete</a>. The former is a single list composed by the union of move and attack actions (of type <code>gymnasium.spaces.Discrete</code>), while the latter consists of two sets combined, for move and attack actions respectively (of type <code>gymnasium.spaces.MultiDiscrete</code>). The complete visual description of available action spaces is shown in the figure below, where both choices are presented via the correspondent gamepad buttons configuration for Dead Or Alive ++.',Fe,M,Zt='<img src="https://docs.diambra.ai/images/envs/actionSpaces.png" alt="Description" style="width:500px; height:auto; background-color:#d0d0d5 !important;"/>',Le,F,Rt="Each game has specific action spaces since attack buttons (and their combinations) are, in general, game-dependent.",Ye,L,kt='In <a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/discrete.py" rel="nofollow">Discrete</a> action spaces:',Se,Y,Ht="<li>There is only one ”no-op” action, that covers both the ”no-move” and ”no-attack” actions.</li> <li>The total number of actions available is N<sub>m</sub> + N<sub>a</sub> − 1 where N<sub>m</sub> is the number of move actions (no-move included) and N<sub>a</sub> is the number of attack actions (no-attack included).</li> <li>Only one action, either move or attack, can be sent for each environment step.</li>",Ne,S,Xt='In <a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/multi_discrete.py" rel="nofollow">MultiDiscrete</a> action spaces:',Ve,N,Et="<li>There is only one ”no-op” action, that covers both the ”no-move” and ”no-attack” actions.</li> <li>The total number of actions available is N<sub>m</sub> × N<sub>a</sub>.</li> <li>Both move and attack actions can be sent at the same time for each environment step.</li>",Qe,V,At="For Street Fighter III 3rd Strike, the available actions spaces are:",Pe,Q,zt='<li><a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/discrete.py" rel="nofollow">Discrete</a>: 9 (moves) + 10 (attacks) - 1 (no-op counted twice) = 18</li> <li><a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/multi_discrete.py" rel="nofollow">MultiDiscrete</a>: 9 (moves) X 10 (attacks) = 90</li>',De,P,qe,D,Gt='Environment observations are composed by two main elements: a visual one (the game frame) and an aggregation of numerical values called RAM states (stage number, health values, etc.). Both of them are exposed through an observation space of type <a href="https://github.com/Farama-Foundation/Gymnasium/blob/main/gymnasium/spaces/dict.py" rel="nofollow"><code>gym.spaces.Dict</code></a>. It consists of global elements and player-specific ones, that also vary depending on the specific game selected. The following images show the Street Fighter III specific ones, where RAM States are highlighted, superimposed on the game frame.',Oe,q,Ft='The detailed observation space description can be found in the official documentation at <a href="https://docs.diambra.ai/envs/#observation-space" rel="nofollow">this page</a> for the shared observations, and at <a href="https://docs.diambra.ai/envs/games/sfiii3n/#observation-space" rel="nofollow">this page</a> for the Street Fighter specific ones.',Ke,y,Lt='<img src="https://docs.diambra.ai/images/envs/sfiii3nData.png" alt="diambraArena"/>',et,v,Yt='<img src="https://docs.diambra.ai/images/envs/sfiii3nData2.png" alt="diambraArena"/>',tt,O,nt,K,St="The default reward is defined as a function of characters health values so that, qualitatively, damage suffered by the agent corresponds to a negative reward, and damage inflicted to the opponent corresponds to a positive reward. The quantitative, general and formal reward function definition is as follows:",at,ee,Nt="R_t = \\sum_i^{0,N_c}\\left(\\bar{H_i}^{t^-} - \\bar{H_i}^{t} - \\left(\\hat{H_i}^{t^-} - \\hat{H_i}^{t}\\right)\\right)",st,te,Vt="Where:",it,ne,Qt="<li>\\bar{H} and \\hat{H} are health values for opponent’s character(s) and agent’s one(s) respectively;</li> <li>t^- and t are used to indicate conditions at ”state-time” and at ”new state-time” (i.e. before and after environment step);</li> <li>N_c is the number of characters taking part in a round. Usually is N_c = 1 but there are some games where multiple characters are used, with the additional possible option of alternating them during gameplay, like Tekken Tag Tournament where 2 characters have to be selected and two opponents are faced every round (thus N_c = 2);</li>",lt,ae,Pt='Additional details (e.g. lower and upper bounds for the total cumulative reward in both 1 and 2 player modes) can be found on the official documentation <a href="https://docs.diambra.ai/envs/#reward-function" rel="nofollow">dedicated section</a>.',ot,se,rt,ie,Dt="DIAMBRA Arena comes with a large number of ready-to-use wrappers and examples showing how to apply them. They cover a wide spectrum of use cases, and also provide reference templates to develop custom ones.",pt,le,qt="Environmet wrappers are widely used to tweak the observation and action spaces. In order to activate them, one needs to properly set the <code>WrapperSettings</code> class attributes and provide them as input to the environment creation method, as shown in the next code block.",mt,oe,ct,re,Ot="For the purpose of this tutorial, we will experiment with a lot of them:",dt,pe,Kt="<li><strong>No Attack Buttons Combinations</strong>: restricts the number of attack actions to single buttons, removing attack buttons combinations</li> <li><strong>Stack Frames With Optional Dilation</strong>: Stacks latest <em>N</em> frames together along the third dimension</li> <li><strong>Add Last Action to Observation</strong>: Adds latest action to the observation space dictionary, under the key <code>action</code></li> <li><strong>Stack Actions</strong>: Stacks latest <em>N</em> actions together</li> <li><strong>Scale Observation</strong>: Activates observation scaling, optionally preventing scaling to be applied on the game frame and on discrete binary observations</li> <li><strong>Role-relative Observation</strong>: Renames observation depending on the role played by the agent</li> <li><strong>Flatten and Filter Observation</strong>: Activates observation dictionary flattening, removing nested dictionaries and creating new keys joining original ones using ”<code>_</code>” across nesting levels and defines the list of RAM states to keep in the observation space</li> <li><strong>Normalize Reward</strong>: Activates reward normalization and defines the normalization factor multiplying the delta between maximum and minium health bar value for the given game</li>",ut,me,en="To activate them you would use the following code:",ht,ce,ft,de,tn='Additional details and wrappers can be found on the official documentation, at <a href="https://docs.diambra.ai/wrappers/" rel="nofollow">this page</a>.',bt,ue,nn="Having properly defined all environment and wrappers settings, the environment is now ready to be use for training a Deep Learning model using Reinforcement Learning.",gt,he,Mt,Me,yt;return w=new b({props:{title:"Environment and Wrappers",local:"environment-and-wrappers",headingTag:"h1"}}),T=new b({props:{title:"Environment",local:"environment",headingTag:"h2"}}),J=new b({props:{title:"Interaction Basics",local:"interaction-basics",headingTag:"h3"}}),B=new be({props:{code:"aW1wb3J0JTIwZGlhbWJyYS5hcmVuYSUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwY3JlYXRpb24lMEFlbnYlMjAlM0QlMjBkaWFtYnJhLmFyZW5hLm1ha2UoJTIyc2ZpaWkzbiUyMiUyQyUyMHJlbmRlcl9tb2RlJTNEJTIyaHVtYW4lMjIpJTBBJTBBJTIzJTIwRW52aXJvbm1lbnQlMjByZXNldCUwQW9ic2VydmF0aW9uJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5yZXNldChzZWVkJTNENDIpJTBBJTBBJTIzJTIwQWdlbnQtRW52aXJvbm1lbnQlMjBpbnRlcmFjdGlvbiUyMGxvb3AlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAoT3B0aW9uYWwpJTIwRW52aXJvbm1lbnQlMjByZW5kZXJpbmclMEElMjAlMjAlMjAlMjBlbnYucmVuZGVyKCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBY3Rpb24lMjByYW5kb20lMjBzYW1wbGluZyUwQSUyMCUyMCUyMCUyMGFjdGlvbnMlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLnNhbXBsZSgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRW52aXJvbm1lbnQlMjBzdGVwcGluZyUwQSUyMCUyMCUyMCUyMG9ic2VydmF0aW9uJTJDJTIwcmV3YXJkJTJDJTIwdGVybWluYXRlZCUyQyUyMHRydW5jYXRlZCUyQyUyMGluZm8lMjAlM0QlMjBlbnYuc3RlcChhY3Rpb25zKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEVwaXNvZGUlMjBlbmQlMjAoRG9uZSUyMGNvbmRpdGlvbiklMjBjaGVjayUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb24lMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwc2h1dGRvd24lMEFlbnYuY2xvc2UoKQ==",highlighted:`<span class="hljs-keyword">import</span> diambra.arena

<span class="hljs-comment"># Environment creation</span>
env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, render_mode=<span class="hljs-string">&quot;human&quot;</span>)

<span class="hljs-comment"># Environment reset</span>
observation, info = env.reset(seed=<span class="hljs-number">42</span>)

<span class="hljs-comment"># Agent-Environment interaction loop</span>
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-comment"># (Optional) Environment rendering</span>
    env.render()

    <span class="hljs-comment"># Action random sampling</span>
    actions = env.action_space.sample()

    <span class="hljs-comment"># Environment stepping</span>
    observation, reward, terminated, truncated, info = env.step(actions)

    <span class="hljs-comment"># Episode end (Done condition) check</span>
    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        observation, info = env.reset()
        <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Environment shutdown</span>
env.close()`,wrap:!1}}),C=new b({props:{title:"DIAMBRA Command Line Interface (CLI)",local:"diambra-command-line-interface-cli",headingTag:"h4"}}),W=new be({props:{code:"ZGlhbWJyYSUyMHJ1biUyMC1yJTIwJTJGYWJzb2x1dGUlMkZwYXRoJTJGdG8lMkZyb21zJTJGZm9sZGVyJTJGJTIwcHl0aG9uJTIwZGlhbWJyYV9hcmVuYV9naXN0LnB5",highlighted:"diambra run -r /absolute/path/to/roms/folder/ python diambra_arena_gist.py",wrap:!1}}),x=new b({props:{title:"Settings",local:"settings",headingTag:"h3"}}),H=new be({props:{code:"ZnJvbSUyMGRpYW1icmEuYXJlbmElMjBpbXBvcnQlMjBFbnZpcm9ubWVudFNldHRpbmdzJTBBJTBBJTIzJTIwU2V0dGluZ3MlMjBzcGVjaWZpY2F0aW9uJTBBc2V0dGluZ3MlMjAlM0QlMjBFbnZpcm9ubWVudFNldHRpbmdzKCklMEFzZXR0aW5ncy5zZXR0aW5nXzElMjAlM0QlMjB2YWx1ZV8xJTBBc2V0dGluZ3Muc2V0dGluZ18yJTIwJTNEJTIwdmFsdWVfMiUwQSUwQWVudiUyMCUzRCUyMGRpYW1icmEuYXJlbmEubWFrZSglMjJzZmlpaTNuJTIyJTJDJTIwc2V0dGluZ3Mp",highlighted:`<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> EnvironmentSettings

<span class="hljs-comment"># Settings specification</span>
settings = EnvironmentSettings()
settings.setting_1 = value_1
settings.setting_2 = value_2

env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings)`,wrap:!1}}),E=new be({props:{code:"JTIzJTIwRXBpc29kZSUyMHNldHRpbmdzJTBBZXBpc29kZV9zZXR0aW5ncyUyMCUzRCUyMCU3QiUwQSUyMCUyMHNldHRpbmdfMSUzQSUyMHZhbHVlXzElMkMlMEElMjAlMjBzZXR0aW5nXzIlM0ElMjB2YWx1ZV8yJTJDJTBBJTdEJTBBJTBBZW52LnJlc2V0KG9wdGlvbnMlM0RlcGlzb2RlX3NldHRpbmdzKQ==",highlighted:`<span class="hljs-comment"># Episode settings</span>
episode_settings = {
  setting_1: value_1,
  setting_2: value_2,
}

env.reset(options=episode_settings)`,wrap:!1}}),z=new b({props:{title:"Action Space(s)",local:"action-spaces",headingTag:"h3"}}),P=new b({props:{title:"Observation Space",local:"observation-space",headingTag:"h3"}}),O=new b({props:{title:"Reward Function",local:"reward-function",headingTag:"h3"}}),se=new b({props:{title:"Wrappers",local:"wrappers",headingTag:"h2"}}),oe=new be({props:{code:"ZnJvbSUyMGRpYW1icmEuYXJlbmElMjBpbXBvcnQlMjBFbnZpcm9ubWVudFNldHRpbmdzJTJDJTIwV3JhcHBlclNldHRpbmdzJTBBJTBBJTIzJTIwU2V0dGluZ3MlMjBzcGVjaWZpY2F0aW9uJTBBc2V0dGluZ3MlMjAlM0QlMjBFbnZpcm9ubWVudFNldHRpbmdzKCklMEElMEElMjMlMjBXcmFwcGVyJTIwc2V0dGluZ3MlMjBzcGVjaWZpY2F0aW9uJTBBd3JhcHBlcl9zZXR0aW5ncyUyMCUzRCUyMFdyYXBwZXJTZXR0aW5ncygpJTBBd3JhcHBlcl9zZXR0aW5ncy5zZXR0aW5nXzElMjAlM0QlMjB2YWx1ZV8xJTBBd3JhcHBlcl9zZXR0aW5ncy5zZXR0aW5nXzIlMjAlM0QlMjB2YWx1ZV8yJTBBJTBBZW52JTIwJTNEJTIwZGlhbWJyYS5hcmVuYS5tYWtlKCUyMnNmaWlpM24lMjIlMkMlMjBzZXR0aW5ncyUyQyUyMHdyYXBwZXJfc2V0dGluZ3Mp",highlighted:`<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> EnvironmentSettings, WrapperSettings

<span class="hljs-comment"># Settings specification</span>
settings = EnvironmentSettings()

<span class="hljs-comment"># Wrapper settings specification</span>
wrapper_settings = WrapperSettings()
wrapper_settings.setting_1 = value_1
wrapper_settings.setting_2 = value_2

env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings, wrapper_settings)`,wrap:!1}}),ce=new be({props:{code:"d3JhcHBlcl9zZXR0aW5ncyUyMCUzRCUyMFdyYXBwZXJTZXR0aW5ncygpJTBBJTBBd3JhcHBlcnNfc2V0dGluZ3Mubm9fYXR0YWNrX2J1dHRvbnNfY29tYmluYXRpb25zJTIwJTNEJTIwVHJ1ZSUwQXdyYXBwZXJzX3NldHRpbmdzLnN0YWNrX2ZyYW1lJTIwJTNEJTIwNCUwQXdyYXBwZXJzX3NldHRpbmdzLmRpbGF0aW9uJTIwJTNEJTIwMSUwQXdyYXBwZXJzX3NldHRpbmdzLmFkZF9sYXN0X2FjdGlvbiUyMCUzRCUyMFRydWUlMEF3cmFwcGVyc19zZXR0aW5ncy5zdGFja19hY3Rpb25zJTIwJTNEJTIwMTIlMEF3cmFwcGVyc19zZXR0aW5ncy5zY2FsZSUyMCUzRCUyMFRydWUlMEF3cmFwcGVyc19zZXR0aW5ncy5leGNsdWRlX2ltYWdlX3NjYWxpbmclMjAlM0QlMjBUcnVlJTBBd3JhcHBlcnNfc2V0dGluZ3Mucm9sZV9yZWxhdGl2ZSUyMCUzRCUyMFRydWUlMEF3cmFwcGVyc19zZXR0aW5ncy5mbGF0dGVuJTIwJTNEJTIwVHJ1ZSUwQXdyYXBwZXJzX3NldHRpbmdzLmZpbHRlcl9rZXlzJTIwJTNEJTIwJTVCJTIyYWN0aW9uJTIyJTJDJTIwJTIyb3duX2hlYWx0aCUyMiUyQyUyMCUyMm9wcF9oZWFsdGglMjIlMkMlMjAlMjJvd25fc2lkZSUyMiUyQyUyMCUyMm9wcF9zaWRlJTIyJTJDJTIwJTIyb3BwX2NoYXJhY3RlciUyMiUyQyUyMCUyMnN0YWdlJTIyJTVEJTBBd3JhcHBlcnNfc2V0dGluZ3Mubm9ybWFsaXplX3Jld2FyZCUyMCUzRCUyMFRydWU=",highlighted:`wrapper_settings = WrapperSettings()

wrappers_settings.no_attack_buttons_combinations = <span class="hljs-literal">True</span>
wrappers_settings.stack_frame = <span class="hljs-number">4</span>
wrappers_settings.dilation = <span class="hljs-number">1</span>
wrappers_settings.add_last_action = <span class="hljs-literal">True</span>
wrappers_settings.stack_actions = <span class="hljs-number">12</span>
wrappers_settings.scale = <span class="hljs-literal">True</span>
wrappers_settings.exclude_image_scaling = <span class="hljs-literal">True</span>
wrappers_settings.role_relative = <span class="hljs-literal">True</span>
wrappers_settings.flatten = <span class="hljs-literal">True</span>
wrappers_settings.filter_keys = [<span class="hljs-string">&quot;action&quot;</span>, <span class="hljs-string">&quot;own_health&quot;</span>, <span class="hljs-string">&quot;opp_health&quot;</span>, <span class="hljs-string">&quot;own_side&quot;</span>, <span class="hljs-string">&quot;opp_side&quot;</span>, <span class="hljs-string">&quot;opp_character&quot;</span>, <span class="hljs-string">&quot;stage&quot;</span>]
wrappers_settings.normalize_reward = <span class="hljs-literal">True</span>`,wrap:!1}}),he=new dn({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus3/environment.mdx"}}),{c(){f=l("meta"),ye=s(),ge=l("p"),ve=s(),p(w.$$.fragment),we=s(),p(T.$$.fragment),Te=s(),p(J.$$.fragment),Je=s(),j=l("p"),j.textContent=wt,je=s(),g=l("p"),g.innerHTML=Tt,$e=s(),$=l("p"),$.textContent=Jt,Be=s(),p(B.$$.fragment),Ce=s(),p(C.$$.fragment),Ue=s(),U=l("p"),U.textContent=jt,_e=s(),_=l("p"),_.textContent=$t,We=s(),p(W.$$.fragment),Ie=s(),I=l("p"),I.innerHTML=Bt,xe=s(),p(x.$$.fragment),Ze=s(),Z=l("p"),Z.innerHTML=Ct,Re=s(),R=l("ul"),R.innerHTML=Ut,ke=s(),k=l("p"),k.innerHTML=_t,He=s(),p(H.$$.fragment),Xe=s(),X=l("p"),X.innerHTML=Wt,Ee=s(),p(E.$$.fragment),Ae=s(),A=l("p"),A.innerHTML=It,ze=s(),p(z.$$.fragment),Ge=s(),G=l("p"),G.innerHTML=xt,Fe=s(),M=l("p"),M.innerHTML=Zt,Le=s(),F=l("p"),F.textContent=Rt,Ye=s(),L=l("p"),L.innerHTML=kt,Se=s(),Y=l("ul"),Y.innerHTML=Ht,Ne=s(),S=l("p"),S.innerHTML=Xt,Ve=s(),N=l("ul"),N.innerHTML=Et,Qe=s(),V=l("p"),V.textContent=At,Pe=s(),Q=l("ul"),Q.innerHTML=zt,De=s(),p(P.$$.fragment),qe=s(),D=l("p"),D.innerHTML=Gt,Oe=s(),q=l("p"),q.innerHTML=Ft,Ke=s(),y=l("p"),y.innerHTML=Lt,et=s(),v=l("p"),v.innerHTML=Yt,tt=s(),p(O.$$.fragment),nt=s(),K=l("p"),K.textContent=St,at=s(),ee=l("p"),ee.textContent=Nt,st=s(),te=l("p"),te.textContent=Vt,it=s(),ne=l("ul"),ne.innerHTML=Qt,lt=s(),ae=l("p"),ae.innerHTML=Pt,ot=s(),p(se.$$.fragment),rt=s(),ie=l("p"),ie.textContent=Dt,pt=s(),le=l("p"),le.innerHTML=qt,mt=s(),p(oe.$$.fragment),ct=s(),re=l("p"),re.textContent=Ot,dt=s(),pe=l("ul"),pe.innerHTML=Kt,ut=s(),me=l("p"),me.textContent=en,ht=s(),p(ce.$$.fragment),ft=s(),de=l("p"),de.innerHTML=tn,bt=s(),ue=l("p"),ue.textContent=nn,gt=s(),p(he.$$.fragment),Mt=s(),Me=l("p"),this.h()},l(e){const t=mn("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(n),ye=i(e),ge=o(e,"P",{}),an(ge).forEach(n),ve=i(e),m(w.$$.fragment,e),we=i(e),m(T.$$.fragment,e),Te=i(e),m(J.$$.fragment,e),Je=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1npkpkg"&&(j.textContent=wt),je=i(e),g=o(e,"P",{align:!0,"data-svelte-h":!0}),r(g)!=="svelte-17akgjr"&&(g.innerHTML=Tt),$e=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1utc7mh"&&($.textContent=Jt),Be=i(e),m(B.$$.fragment,e),Ce=i(e),m(C.$$.fragment,e),Ue=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-e42838"&&(U.textContent=jt),_e=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-8xtxfd"&&(_.textContent=$t),We=i(e),m(W.$$.fragment,e),Ie=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-89c8t0"&&(I.innerHTML=Bt),xe=i(e),m(x.$$.fragment,e),Ze=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1sztsyc"&&(Z.innerHTML=Ct),Re=i(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-ff749a"&&(R.innerHTML=Ut),ke=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9kv7c"&&(k.innerHTML=_t),He=i(e),m(H.$$.fragment,e),Xe=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hlx5ql"&&(X.innerHTML=Wt),Ee=i(e),m(E.$$.fragment,e),Ae=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1kag8tx"&&(A.innerHTML=It),ze=i(e),m(z.$$.fragment,e),Ge=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1feramc"&&(G.innerHTML=xt),Fe=i(e),M=o(e,"P",{align:!0,"data-svelte-h":!0}),r(M)!=="svelte-18r4fjt"&&(M.innerHTML=Zt),Le=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1q9w436"&&(F.textContent=Rt),Ye=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-mc73x3"&&(L.innerHTML=kt),Se=i(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1c6ntqu"&&(Y.innerHTML=Ht),Ne=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-pwucdm"&&(S.innerHTML=Xt),Ve=i(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-18o95cf"&&(N.innerHTML=Et),Qe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wid18z"&&(V.textContent=At),Pe=i(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1hl7326"&&(Q.innerHTML=zt),De=i(e),m(P.$$.fragment,e),qe=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ysc8ti"&&(D.innerHTML=Gt),Oe=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-3ujzdp"&&(q.innerHTML=Ft),Ke=i(e),y=o(e,"P",{align:!0,"data-svelte-h":!0}),r(y)!=="svelte-8votlf"&&(y.innerHTML=Lt),et=i(e),v=o(e,"P",{align:!0,"data-svelte-h":!0}),r(v)!=="svelte-xpxifl"&&(v.innerHTML=Yt),tt=i(e),m(O.$$.fragment,e),nt=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1gh9v0q"&&(K.textContent=St),at=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-70ql2n"&&(ee.textContent=Nt),st=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-ubj59h"&&(te.textContent=Vt),it=i(e),ne=o(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1bfkpvo"&&(ne.innerHTML=Qt),lt=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-q0kse"&&(ae.innerHTML=Pt),ot=i(e),m(se.$$.fragment,e),rt=i(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-c16hj9"&&(ie.textContent=Dt),pt=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1jrggbc"&&(le.innerHTML=qt),mt=i(e),m(oe.$$.fragment,e),ct=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1t0ncxx"&&(re.textContent=Ot),dt=i(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-cgye3w"&&(pe.innerHTML=Kt),ut=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1l6spx0"&&(me.textContent=en),ht=i(e),m(ce.$$.fragment,e),ft=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1weuj5p"&&(de.innerHTML=tn),bt=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1io1lux"&&(ue.textContent=nn),gt=i(e),m(he.$$.fragment,e),Mt=i(e),Me=o(e,"P",{}),an(Me).forEach(n),this.h()},h(){fe(f,"name","hf:doc:metadata"),fe(f,"content",hn),fe(g,"align","center"),fe(M,"align","center"),fe(y,"align","center"),fe(v,"align","center")},m(e,t){cn(document.head,f),a(e,ye,t),a(e,ge,t),a(e,ve,t),c(w,e,t),a(e,we,t),c(T,e,t),a(e,Te,t),c(J,e,t),a(e,Je,t),a(e,j,t),a(e,je,t),a(e,g,t),a(e,$e,t),a(e,$,t),a(e,Be,t),c(B,e,t),a(e,Ce,t),c(C,e,t),a(e,Ue,t),a(e,U,t),a(e,_e,t),a(e,_,t),a(e,We,t),c(W,e,t),a(e,Ie,t),a(e,I,t),a(e,xe,t),c(x,e,t),a(e,Ze,t),a(e,Z,t),a(e,Re,t),a(e,R,t),a(e,ke,t),a(e,k,t),a(e,He,t),c(H,e,t),a(e,Xe,t),a(e,X,t),a(e,Ee,t),c(E,e,t),a(e,Ae,t),a(e,A,t),a(e,ze,t),c(z,e,t),a(e,Ge,t),a(e,G,t),a(e,Fe,t),a(e,M,t),a(e,Le,t),a(e,F,t),a(e,Ye,t),a(e,L,t),a(e,Se,t),a(e,Y,t),a(e,Ne,t),a(e,S,t),a(e,Ve,t),a(e,N,t),a(e,Qe,t),a(e,V,t),a(e,Pe,t),a(e,Q,t),a(e,De,t),c(P,e,t),a(e,qe,t),a(e,D,t),a(e,Oe,t),a(e,q,t),a(e,Ke,t),a(e,y,t),a(e,et,t),a(e,v,t),a(e,tt,t),c(O,e,t),a(e,nt,t),a(e,K,t),a(e,at,t),a(e,ee,t),a(e,st,t),a(e,te,t),a(e,it,t),a(e,ne,t),a(e,lt,t),a(e,ae,t),a(e,ot,t),c(se,e,t),a(e,rt,t),a(e,ie,t),a(e,pt,t),a(e,le,t),a(e,mt,t),c(oe,e,t),a(e,ct,t),a(e,re,t),a(e,dt,t),a(e,pe,t),a(e,ut,t),a(e,me,t),a(e,ht,t),c(ce,e,t),a(e,ft,t),a(e,de,t),a(e,bt,t),a(e,ue,t),a(e,gt,t),c(he,e,t),a(e,Mt,t),a(e,Me,t),yt=!0},p:ln,i(e){yt||(d(w.$$.fragment,e),d(T.$$.fragment,e),d(J.$$.fragment,e),d(B.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),yt=!0)},o(e){u(w.$$.fragment,e),u(T.$$.fragment,e),u(J.$$.fragment,e),u(B.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),yt=!1},d(e){e&&(n(ye),n(ge),n(ve),n(we),n(Te),n(Je),n(j),n(je),n(g),n($e),n($),n(Be),n(Ce),n(Ue),n(U),n(_e),n(_),n(We),n(Ie),n(I),n(xe),n(Ze),n(Z),n(Re),n(R),n(ke),n(k),n(He),n(Xe),n(X),n(Ee),n(Ae),n(A),n(ze),n(Ge),n(G),n(Fe),n(M),n(Le),n(F),n(Ye),n(L),n(Se),n(Y),n(Ne),n(S),n(Ve),n(N),n(Qe),n(V),n(Pe),n(Q),n(De),n(qe),n(D),n(Oe),n(q),n(Ke),n(y),n(et),n(v),n(tt),n(nt),n(K),n(at),n(ee),n(st),n(te),n(it),n(ne),n(lt),n(ae),n(ot),n(rt),n(ie),n(pt),n(le),n(mt),n(ct),n(re),n(dt),n(pe),n(ut),n(me),n(ht),n(ft),n(de),n(bt),n(ue),n(gt),n(Mt),n(Me)),n(f),h(w,e),h(T,e),h(J,e),h(B,e),h(C,e),h(W,e),h(x,e),h(H,e),h(E,e),h(z,e),h(P,e),h(O,e),h(se,e),h(oe,e),h(ce,e),h(he,e)}}}const hn='{"title":"Environment and Wrappers","local":"environment-and-wrappers","sections":[{"title":"Environment","local":"environment","sections":[{"title":"Interaction Basics","local":"interaction-basics","sections":[{"title":"DIAMBRA Command Line Interface (CLI)","local":"diambra-command-line-interface-cli","sections":[],"depth":4}],"depth":3},{"title":"Settings","local":"settings","sections":[],"depth":3},{"title":"Action Space(s)","local":"action-spaces","sections":[],"depth":3},{"title":"Observation Space","local":"observation-space","sections":[],"depth":3},{"title":"Reward Function","local":"reward-function","sections":[],"depth":3}],"depth":2},{"title":"Wrappers","local":"wrappers","sections":[],"depth":2}],"depth":1}';function fn(vt){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends rn{constructor(f){super(),pn(this,f,fn,un,sn,{})}}export{vn as component};
