import{s as OM,n as lt,o as et}from"../chunks/scheduler.39a43cde.js";import{S as Mt,i as tt,g as n,s,r as J,A as st,h as y,f as M,c as a,j as PM,u as T,x as U,k as KM,y as at,a as t,v as p,d as j,t as i,w}from"../chunks/index.23ec2204.js";import{D as nt,C as o}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Vl,E as yt}from"../chunks/EditOnGithub.f2d09226.js";function Ut(aM){let m,Fl,gl,Wl,r,Sl,I,Nl,d,nM='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Yl,c,yM="Publicly available code LLMs such as Codex, StarCoder, and Code Llama are great at generating code that adheres to general programming principles and syntax, but they may not align with an organization’s internal conventions, or be aware of proprietary libraries.",vl,C,UM="In this notebook, we’ll see show how you can fine-tune a code LLM on private code bases to enhance its contextual awareness and improve a model’s usefulness to your organization’s needs. Since the code LLMs are quite large, fine-tuning them in a traditional manner can be resource-draining. Worry not! We will show how you can optimize fine-tuning to fit on a single GPU.",xl,h,Hl,A,JM='For this example, we picked the top 10 Hugging Face public repositories on GitHub. We have excluded non-code files from the data, such as images, audio files, presentations, and so on. For Jupyter notebooks, we’ve kept only cells containing code. The resulting code is stored as a dataset that you can find on the Hugging Face Hub under <a href="https://huggingface.co/datasets/smangrul/hf-stack-v1" rel="nofollow"><code>smangrul/hf-stack-v1</code></a>. It contains repo id, file path, and file content.',zl,u,$l,f,TM='We’ll finetune <a href="https://huggingface.co/bigcode/starcoderbase-1b" rel="nofollow"><code>bigcode/starcoderbase-1b</code></a>, which is a 1B parameter model trained on 80+ programming languages. This is a gated model, so if you plan to run this notebook with this exact model, you’ll need to gain access to it on the model’s page. Log in to your Hugging Face account to do so:',Ll,b,ql,Z,pM="To get started, let’s install all the necessary libraries. As you can see, in addition to <code>transformers</code> and <code>datasets</code>, we’ll be using <code>peft</code>, <code>bitsandbytes</code>, and <code>flash-attn</code> to optimize the training.",Dl,B,jM="By employing parameter-efficient training techniques, we can run this notebook on a single A100 High-RAM GPU.",Pl,_,Kl,G,iM="Let’s define some variables now. Feel free to play with these.",Ol,R,le,E,ee,k,Me,X,wM="Begin by loading the data. As the dataset is likely to be quite large, make sure to enable the streaming mode. Streaming allows us to load the data progressively as we iterate over the dataset instead of downloading the whole dataset at once.",te,V,oM="We’ll reserve the first 4000 examples as the validation set, and everything else will be the training data.",se,g,ae,Q,mM="At this step, the dataset still contains raw data with code of arbitraty length. For training, we need inputs of fixed length. Let’s create an Iterable dataset that would return constant-length chunks of tokens from a stream of text files.",ne,F,rM="First, let’s estimate the average number of characters per token in the dataset, which will help us later estimate the number of tokens in the text buffer later. By default, we’ll only take 400 examples (<code>nb_examples</code>) from the dataset. Using only a subset of the entire dataset will reduce computational cost while still providing a reasonable estimate of the overall character-to-token ratio.",ye,W,Ue,S,IM=`The character to token ratio of the dataset is: 2.43
`,Je,N,dM="The character-to-token ratio can also be used as an indicator of the quality of text tokenization. For instance, a character-to-token ratio of 1.0 would mean that each character is represented with a token, which is not very meaningful. This would indicate poor tokenization. In standard English text, one token is typically equivalent to approximately four characters, meaning the character-to-token ratio is around 4.0. We can expect a lower ratio in the code dataset, but generally speaking, a number between 2.0 and 3.5 can be considered good enough.",Te,Y,cM="<strong>Optional FIM transformations</strong>",pe,v,CM=`Autoregressive language models typically generate sequences from left to right. By applying the FIM transformations, the model can also learn to infill text.  Check out <a href="https://arxiv.org/pdf/2207.14255.pdf" rel="nofollow">“Efficient Training of Language Models to Fill in the Middle” paper</a> to learn more about the technique.
We’ll define the FIM transformations here and will use them when creating the Iterable Dataset. However, if you want to omit transformations, feel free to set <code>fim_rate</code> to 0.`,je,x,ie,H,hM="Let’s define the <code>ConstantLengthDataset</code>, an Iterable dataset that will return constant-length chunks of tokens. To do so, we’ll read a buffer of text from the original dataset until we hit the size limits and then apply tokenizer to convert the raw text into tokenized inputs. Optionally, we’ll perform FIM transformations on some sequences (the proportion of sequences affected is controlled by <code>fim_rate</code>).",we,z,AM="Once defined, we can create instances of the <code>ConstantLengthDataset</code> from both training and validation data.",oe,$,me,L,re,q,uM="Now that the data is prepared, it’s time to load the model! We’re going to load the quantized version of the model.",Ie,D,fM="This will allow us to reduce memory usage, as quantization represents data with fewer bits. We’ll use the <code>bitsandbytes</code> library to quantize the model, as it has a nice integration with <code>transformers</code>. All we need to do is define a <code>bitsandbytes</code> config, and then use it when loading the model.",de,P,bM="There are different variants of 4bit quantization, but generally, we recommend using NF4 quantization for better performance (<code>bnb_4bit_quant_type=&quot;nf4&quot;</code>).",ce,K,ZM="The <code>bnb_4bit_use_double_quant</code> option adds a second quantization after the first one to save an additional 0.4 bits per parameter.",Ce,O,BM='To learn more about quantization, check out the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">“Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA” blog post</a>.',he,ll,_M="Once defined, pass the config to the <code>from_pretrained</code> method to load the quantized version of the model.",Ae,el,ue,Ml,GM="When using a quantized model for training, you need to call the <code>prepare_model_for_kbit_training()</code> function to preprocess the quantized model for training.",fe,tl,be,sl,RM="Now that the quantized model is ready, we can set up a LoRA configuration. LoRA makes fine-tuning more efficient by drastically reducing the number of trainable parameters.",Ze,al,EM="To train a model using LoRA technique, we need to wrap the base model as a <code>PeftModel</code>. This involves definign LoRA configuration with <code>LoraConfig</code>, and wrapping the original model with <code>get_peft_model()</code> using the <code>LoraConfig</code>.",Be,nl,kM='To learn more about LoRA and its parameters, refer to <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">PEFT documentation</a>.',_e,yl,Ge,Ul,XM=`trainable params: 5,554,176 || all params: 1,142,761,472 || trainable%: 0.4860310866343243
`,Re,Jl,VM="As you can see, by applying LoRA technique we will now need to train less than 1% of the parameters.",Ee,Tl,ke,pl,gM="Now that we have prepared the data, and optimized the model, we are ready to bring everything together to start the training.",Xe,jl,QM="To instantiate a <code>Trainer</code>, you need to define the training configuration. The most important is the <code>TrainingArguments</code>, which is a class that contains all the attributes to configure the training.",Ve,il,FM="These are similar to any other kind of model training you may run, so we won’t go into detail here.",ge,wl,Qe,ol,WM="As a final step, instantiate the <code>Trainer</code> and call the <code>train</code> method.",Fe,ml,We,rl,SM=`Training...
`,Se,Il,NM="Finally, you can push the fine-tuned model to your Hub repository to share with your team.",Ne,dl,Ye,cl,ve,Cl,YM="Once the model is uploaded to Hub, we can use it for inference. To do so we first initialize the original base model and its tokenizer. Next, we need to merge the fine-duned weights with the base model.",xe,hl,He,Al,vM="Now we can use the merged model for inference. For convenience, we’ll define a <code>get_code_completion</code> - feel free to experiment with text generation parameters!",ze,ul,$e,fl,xM="Now all we need to do to get code completion is call the <code>get_code_complete</code> function and pass the first few lines that we want to be completed as a prefix, and an empty string as a suffix.",Le,bl,qe,Zl,HM=`from peft import LoraConfig, TaskType, get_peft_model
from transformers import AutoModelForCausalLM
peft_config = LoraConfig(
    task_type=TaskType.CAUSAL_LM,
    r=8,
    lora_alpha=32,
    target_modules=["q_proj", "v_proj"],
    lora_dropout=0.1,
    bias="none",
    modules_to_save=["q_proj", "v_proj"],
    inference_mode=False,
)
model = AutoModelForCausalLM.from_pretrained("gpt2")
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
`,De,Bl,zM="As someone who has just used the PEFT library earlier in this notebook, you can see that the generated result for creating a <code>LoraConfig</code> is rather good!",Pe,_l,$M="If you go back to the cell where we instantiate the model for inference, and comment out the lines where we merge the fine-tuned weights, you can see what the original model would’ve generated for the exact same prefix:",Ke,Gl,Oe,Rl,LM=`from peft import LoraConfig, TaskType, get_peft_model
from transformers import AutoModelForCausalLM
peft_config = LoraConfig(
    model_name_or_path="facebook/wav2vec2-base-960h",
    num_labels=1,
    num_features=1,
    num_hidden_layers=1,
    num_attention_heads=1,
    num_hidden_layers_per_attention_head=1,
    num_attention_heads_per_hidden_layer=1,
    hidden_size=1024,
    hidden_dropout_prob=0.1,
    hidden_act="gelu",
    hidden_act_dropout_prob=0.1,
    hidden
`,lM,El,qM="While it is Python syntax, you can see that the original model has no understanding of what a <code>LoraConfig</code> should be doing.",eM,kl,DM='To learn how this kind of fine-tuning compares to full fine-tuning, and how to use a model like this as your copilot in VS Code via Inference Endpoints, or locally, check out the <a href="https://huggingface.co/blog/personal-copilot" rel="nofollow">“Personal Copilot: Train Your Own Coding Assistant” blog post</a>. This notebook complements the original blog post.',MM,Xl,tM,Ql,sM;return r=new nt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/updated_notebook_dependencies/notebooks/en/fine_tuning_code_llm_on_single_gpu.ipynb"}]}}),I=new Vl({props:{title:"Fine-tuning a Code LLM on Custom Code on a single GPU",local:"fine-tuning-a-code-llm-on-custom-code-on-a-single-gpu",headingTag:"h1"}}),h=new Vl({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),u=new Vl({props:{title:"Model",local:"model",headingTag:"h2"}}),b=new o({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new o({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwcGVmdCUyMGJpdHNhbmRieXRlcyUyMGZsYXNoLWF0dG4=",highlighted:"!pip install -q transformers datasets peft bitsandbytes flash-attn",wrap:!1}}),R=new o({props:{code:"TU9ERUwlMjAlM0QlMjAlMjJiaWdjb2RlJTJGc3RhcmNvZGVyYmFzZS0xYiUyMiUyMCUyMCUyMyUyME1vZGVsJTIwY2hlY2twb2ludCUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMEFEQVRBU0VUJTIwJTNEJTIwJTIyc21hbmdydWwlMkZoZi1zdGFjay12MSUyMiUyMCUyMCUyMyUyMERhdGFzZXQlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBREFUQV9DT0xVTU4lMjAlM0QlMjAlMjJjb250ZW50JTIyJTIwJTIwJTIzJTIwQ29sdW1uJTIwbmFtZSUyMGNvbnRhaW5pbmclMjB0aGUlMjBjb2RlJTIwY29udGVudCUwQSUwQVNFUV9MRU5HVEglMjAlM0QlMjAyMDQ4JTIwJTIwJTIzJTIwU2VxdWVuY2UlMjBsZW5ndGglMEElMEElMjMlMjBUcmFpbmluZyUyMGFyZ3VtZW50cyUwQU1BWF9TVEVQUyUyMCUzRCUyMDIwMDAlMjAlMjAlMjMlMjBtYXhfc3RlcHMlMEFCQVRDSF9TSVpFJTIwJTNEJTIwMTYlMjAlMjAlMjMlMjBiYXRjaF9zaXplJTBBR1JfQUNDX1NURVBTJTIwJTNEJTIwMSUyMCUyMCUyMyUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQUxSJTIwJTNEJTIwNWUtNCUyMCUyMCUyMyUyMGxlYXJuaW5nX3JhdGUlMEFMUl9TQ0hFRFVMRVJfVFlQRSUyMCUzRCUyMCUyMmNvc2luZSUyMiUyMCUyMCUyMyUyMGxyX3NjaGVkdWxlcl90eXBlJTBBV0VJR0hUX0RFQ0FZJTIwJTNEJTIwMC4wMSUyMCUyMCUyMyUyMHdlaWdodF9kZWNheSUwQU5VTV9XQVJNVVBfU1RFUFMlMjAlM0QlMjAzMCUyMCUyMCUyMyUyMG51bV93YXJtdXBfc3RlcHMlMEFFVkFMX0ZSRVElMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBldmFsX2ZyZXElMEFTQVZFX0ZSRVElMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBzYXZlX2ZyZXElMEFMT0dfRlJFUSUyMCUzRCUyMDI1JTIwJTIwJTIzJTIwbG9nX2ZyZXElMEFPVVRQVVRfRElSJTIwJTNEJTIwJTIycGVmdC1zdGFyY29kZXItbG9yYS1hMTAwJTIyJTIwJTIwJTIzJTIwb3V0cHV0X2RpciUwQUJGMTYlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwYmYxNiUwQUZQMTYlMjAlM0QlMjBGYWxzZSUyMCUyMCUyMyUyMG5vX2ZwMTYlMEElMEElMjMlMjBGSU0lMjB0cmFzZm9ybWF0aW9ucyUyMGFyZ3VtZW50cyUwQUZJTV9SQVRFJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwZmltX3JhdGUlMEFGSU1fU1BNX1JBVEUlMjAlM0QlMjAwLjUlMjAlMjAlMjMlMjBmaW1fc3BtX3JhdGUlMEElMEElMjMlMjBMT1JBJTBBTE9SQV9SJTIwJTNEJTIwOCUyMCUyMCUyMyUyMGxvcmFfciUwQUxPUkFfQUxQSEElMjAlM0QlMjAzMiUyMCUyMCUyMyUyMGxvcmFfYWxwaGElMEFMT1JBX0RST1BPVVQlMjAlM0QlMjAwLjAlMjAlMjAlMjMlMjBsb3JhX2Ryb3BvdXQlMEFMT1JBX1RBUkdFVF9NT0RVTEVTJTIwJTNEJTIwJTIyY19wcm9qJTJDY19hdHRuJTJDcV9hdHRuJTJDY19mYyUyQ2NfcHJvaiUyMiUyMCUyMCUyMyUyMGxvcmFfdGFyZ2V0X21vZHVsZXMlMEElMEElMjMlMjBiaXRzYW5kYnl0ZXMlMjBjb25maWclMEFVU0VfTkVTVEVEX1FVQU5UJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHVzZV9uZXN0ZWRfcXVhbnQlMEFCTkJfNEJJVF9DT01QVVRFX0RUWVBFJTIwJTNEJTIwJTIyYmZsb2F0MTYlMjIlMjAlMjAlMjMlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTBBJTBBU0VFRCUyMCUzRCUyMDA=",highlighted:`MODEL = <span class="hljs-string">&quot;bigcode/starcoderbase-1b&quot;</span>  <span class="hljs-comment"># Model checkpoint on the Hugging Face Hub</span>
DATASET = <span class="hljs-string">&quot;smangrul/hf-stack-v1&quot;</span>  <span class="hljs-comment"># Dataset on the Hugging Face Hub</span>
DATA_COLUMN = <span class="hljs-string">&quot;content&quot;</span>  <span class="hljs-comment"># Column name containing the code content</span>

SEQ_LENGTH = <span class="hljs-number">2048</span>  <span class="hljs-comment"># Sequence length</span>

<span class="hljs-comment"># Training arguments</span>
MAX_STEPS = <span class="hljs-number">2000</span>  <span class="hljs-comment"># max_steps</span>
BATCH_SIZE = <span class="hljs-number">16</span>  <span class="hljs-comment"># batch_size</span>
GR_ACC_STEPS = <span class="hljs-number">1</span>  <span class="hljs-comment"># gradient_accumulation_steps</span>
LR = <span class="hljs-number">5e-4</span>  <span class="hljs-comment"># learning_rate</span>
LR_SCHEDULER_TYPE = <span class="hljs-string">&quot;cosine&quot;</span>  <span class="hljs-comment"># lr_scheduler_type</span>
WEIGHT_DECAY = <span class="hljs-number">0.01</span>  <span class="hljs-comment"># weight_decay</span>
NUM_WARMUP_STEPS = <span class="hljs-number">30</span>  <span class="hljs-comment"># num_warmup_steps</span>
EVAL_FREQ = <span class="hljs-number">100</span>  <span class="hljs-comment"># eval_freq</span>
SAVE_FREQ = <span class="hljs-number">100</span>  <span class="hljs-comment"># save_freq</span>
LOG_FREQ = <span class="hljs-number">25</span>  <span class="hljs-comment"># log_freq</span>
OUTPUT_DIR = <span class="hljs-string">&quot;peft-starcoder-lora-a100&quot;</span>  <span class="hljs-comment"># output_dir</span>
BF16 = <span class="hljs-literal">True</span>  <span class="hljs-comment"># bf16</span>
FP16 = <span class="hljs-literal">False</span>  <span class="hljs-comment"># no_fp16</span>

<span class="hljs-comment"># FIM trasformations arguments</span>
FIM_RATE = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># fim_rate</span>
FIM_SPM_RATE = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># fim_spm_rate</span>

<span class="hljs-comment"># LORA</span>
LORA_R = <span class="hljs-number">8</span>  <span class="hljs-comment"># lora_r</span>
LORA_ALPHA = <span class="hljs-number">32</span>  <span class="hljs-comment"># lora_alpha</span>
LORA_DROPOUT = <span class="hljs-number">0.0</span>  <span class="hljs-comment"># lora_dropout</span>
LORA_TARGET_MODULES = <span class="hljs-string">&quot;c_proj,c_attn,q_attn,c_fc,c_proj&quot;</span>  <span class="hljs-comment"># lora_target_modules</span>

<span class="hljs-comment"># bitsandbytes config</span>
USE_NESTED_QUANT = <span class="hljs-literal">True</span>  <span class="hljs-comment"># use_nested_quant</span>
BNB_4BIT_COMPUTE_DTYPE = <span class="hljs-string">&quot;bfloat16&quot;</span>  <span class="hljs-comment"># bnb_4bit_compute_dtype</span>

SEED = <span class="hljs-number">0</span>`,wrap:!1}}),E=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUwQSUyMCUyMCUyMCUyMEF1dG9Ub2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBUcmFpbmVyJTJDJTBBJTIwJTIwJTIwJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nJTJDJTBBJTIwJTIwJTIwJTIwc2V0X3NlZWQlMkMlMEElMjAlMjAlMjAlMjBCaXRzQW5kQnl0ZXNDb25maWclMkMlMEEpJTBBJTBBc2V0X3NlZWQoU0VFRCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoTokenizer,
    Trainer,
    TrainingArguments,
    logging,
    set_seed,
    BitsAndBytesConfig,
)

set_seed(SEED)`,wrap:!1}}),k=new Vl({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),g=new o({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHFkbSUyMGltcG9ydCUyMHRxZG0lMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMERBVEFTRVQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2RpciUzRCUyMmRhdGElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUwQSklMEElMEF2YWxpZF9kYXRhJTIwJTNEJTIwZGF0YXNldC50YWtlKDQwMDApJTBBdHJhaW5fZGF0YSUyMCUzRCUyMGRhdGFzZXQuc2tpcCg0MDAwKSUwQXRyYWluX2RhdGElMjAlM0QlMjB0cmFpbl9kYXRhLnNodWZmbGUoYnVmZmVyX3NpemUlM0Q1MDAwJTJDJTIwc2VlZCUzRFNFRUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm


dataset = load_dataset(
    DATASET,
    data_dir=<span class="hljs-string">&quot;data&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)

valid_data = dataset.take(<span class="hljs-number">4000</span>)
train_data = dataset.skip(<span class="hljs-number">4000</span>)
train_data = train_data.shuffle(buffer_size=<span class="hljs-number">5000</span>, seed=SEED)`,wrap:!1}}),W=new o({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoTU9ERUwlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBJTBBZGVmJTIwY2hhcnNfdG9rZW5fcmF0aW8oZGF0YXNldCUyQyUyMHRva2VuaXplciUyQyUyMGRhdGFfY29sdW1uJTJDJTIwbmJfZXhhbXBsZXMlM0Q0MDApJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwRXN0aW1hdGUlMjB0aGUlMjBhdmVyYWdlJTIwbnVtYmVyJTIwb2YlMjBjaGFyYWN0ZXJzJTIwcGVyJTIwdG9rZW4lMjBpbiUyMHRoZSUyMGRhdGFzZXQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwdG90YWxfY2hhcmFjdGVycyUyQyUyMHRvdGFsX3Rva2VucyUyMCUzRCUyMDAlMkMlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwXyUyQyUyMGV4YW1wbGUlMjBpbiUyMHRxZG0oemlwKHJhbmdlKG5iX2V4YW1wbGVzKSUyQyUyMGl0ZXIoZGF0YXNldCkpJTJDJTIwdG90YWwlM0RuYl9leGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3RhbF9jaGFyYWN0ZXJzJTIwJTJCJTNEJTIwbGVuKGV4YW1wbGUlNUJkYXRhX2NvbHVtbiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3RhbF90b2tlbnMlMjAlMkIlM0QlMjBsZW4odG9rZW5pemVyKGV4YW1wbGUlNUJkYXRhX2NvbHVtbiU1RCkudG9rZW5zKCkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG90YWxfY2hhcmFjdGVycyUyMCUyRiUyMHRvdGFsX3Rva2VucyUwQSUwQSUwQWNoYXJzX3Blcl90b2tlbiUyMCUzRCUyMGNoYXJzX3Rva2VuX3JhdGlvKHRyYWluX2RhdGElMkMlMjB0b2tlbml6ZXIlMkMlMjBEQVRBX0NPTFVNTiklMEFwcmludChmJTIyVGhlJTIwY2hhcmFjdGVyJTIwdG8lMjB0b2tlbiUyMHJhdGlvJTIwb2YlMjB0aGUlMjBkYXRhc2V0JTIwaXMlM0ElMjAlN0JjaGFyc19wZXJfdG9rZW4lM0EuMmYlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(MODEL, trust_remote_code=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">chars_token_ratio</span>(<span class="hljs-params">dataset, tokenizer, data_column, nb_examples=<span class="hljs-number">400</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Estimate the average number of characters per token in the dataset.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>

<span class="hljs-meta">... </span>    total_characters, total_tokens = <span class="hljs-number">0</span>, <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> _, example <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">zip</span>(<span class="hljs-built_in">range</span>(nb_examples), <span class="hljs-built_in">iter</span>(dataset)), total=nb_examples):
<span class="hljs-meta">... </span>        total_characters += <span class="hljs-built_in">len</span>(example[data_column])
<span class="hljs-meta">... </span>        total_tokens += <span class="hljs-built_in">len</span>(tokenizer(example[data_column]).tokens())

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> total_characters / total_tokens


<span class="hljs-meta">&gt;&gt;&gt; </span>chars_per_token = chars_token_ratio(train_data, tokenizer, DATA_COLUMN)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The character to token ratio of the dataset is: <span class="hljs-subst">{chars_per_token:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),x=new o({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> functools
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-comment"># Helper function to get token ids of the special tokens for prefix, suffix and middle for FIM transformations.</span>
<span class="hljs-meta">@functools.lru_cache(<span class="hljs-params">maxsize=<span class="hljs-literal">None</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_fim_token_ids</span>(<span class="hljs-params">tokenizer</span>):
    <span class="hljs-keyword">try</span>:
        FIM_PREFIX, FIM_MIDDLE, FIM_SUFFIX, FIM_PAD = tokenizer.special_tokens_map[<span class="hljs-string">&quot;additional_special_tokens&quot;</span>][<span class="hljs-number">1</span>:<span class="hljs-number">5</span>]
        suffix_tok_id, prefix_tok_id, middle_tok_id, pad_tok_id = (
            tokenizer.vocab[tok] <span class="hljs-keyword">for</span> tok <span class="hljs-keyword">in</span> [FIM_SUFFIX, FIM_PREFIX, FIM_MIDDLE, FIM_PAD]
        )
    <span class="hljs-keyword">except</span> KeyError:
        suffix_tok_id, prefix_tok_id, middle_tok_id, pad_tok_id = <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>
    <span class="hljs-keyword">return</span> suffix_tok_id, prefix_tok_id, middle_tok_id, pad_tok_id


<span class="hljs-comment">## Adapted from https://github.com/bigcode-project/Megatron-LM/blob/6c4bf908df8fd86b4977f54bf5b8bd4b521003d1/megatron/data/gpt_dataset.py</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">permute</span>(<span class="hljs-params">
    sample,
    np_rng,
    suffix_tok_id,
    prefix_tok_id,
    middle_tok_id,
    pad_tok_id,
    fim_rate=<span class="hljs-number">0.5</span>,
    fim_spm_rate=<span class="hljs-number">0.5</span>,
    truncate_or_pad=<span class="hljs-literal">False</span>,
</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Take in a sample (list of tokens) and perform a FIM transformation on it with a probability of fim_rate, using two FIM modes:
    PSM and SPM (with a probability of fim_spm_rate).
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># The if condition will trigger with the probability of fim_rate</span>
    <span class="hljs-comment"># This means FIM transformations will apply to samples with a probability of fim_rate</span>
    <span class="hljs-keyword">if</span> np_rng.binomial(<span class="hljs-number">1</span>, fim_rate):

        <span class="hljs-comment"># Split the sample into prefix, middle, and suffix, based on randomly generated indices stored in the boundaries list.</span>
        boundaries = <span class="hljs-built_in">list</span>(np_rng.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-built_in">len</span>(sample) + <span class="hljs-number">1</span>, size=<span class="hljs-number">2</span>))
        boundaries.sort()

        prefix = np.array(sample[: boundaries[<span class="hljs-number">0</span>]], dtype=np.int64)
        middle = np.array(sample[boundaries[<span class="hljs-number">0</span>] : boundaries[<span class="hljs-number">1</span>]], dtype=np.int64)
        suffix = np.array(sample[boundaries[<span class="hljs-number">1</span>] :], dtype=np.int64)

        <span class="hljs-keyword">if</span> truncate_or_pad:
            <span class="hljs-comment"># calculate the new total length of the sample, taking into account tokens indicating prefix, middle, and suffix</span>
            new_length = suffix.shape[<span class="hljs-number">0</span>] + prefix.shape[<span class="hljs-number">0</span>] + middle.shape[<span class="hljs-number">0</span>] + <span class="hljs-number">3</span>
            diff = new_length - <span class="hljs-built_in">len</span>(sample)

            <span class="hljs-comment"># trancate or pad if there&#x27;s a difference in length between the new length and the original</span>
            <span class="hljs-keyword">if</span> diff &gt; <span class="hljs-number">0</span>:
                <span class="hljs-keyword">if</span> suffix.shape[<span class="hljs-number">0</span>] &lt;= diff:
                    <span class="hljs-keyword">return</span> sample, np_rng
                suffix = suffix[: suffix.shape[<span class="hljs-number">0</span>] - diff]
            <span class="hljs-keyword">elif</span> diff &lt; <span class="hljs-number">0</span>:
                suffix = np.concatenate([suffix, np.full((-<span class="hljs-number">1</span> * diff), pad_tok_id)])

        <span class="hljs-comment"># With the probability of fim_spm_rateapply SPM variant of FIM transformations</span>
        <span class="hljs-comment"># SPM: suffix, prefix, middle</span>
        <span class="hljs-keyword">if</span> np_rng.binomial(<span class="hljs-number">1</span>, fim_spm_rate):
            new_sample = np.concatenate(
                [
                    [prefix_tok_id, suffix_tok_id],
                    suffix,
                    [middle_tok_id],
                    prefix,
                    middle,
                ]
            )
        <span class="hljs-comment"># Otherwise, apply the PSM variant of FIM transformations</span>
        <span class="hljs-comment"># PSM: prefix, suffix, middle</span>
        <span class="hljs-keyword">else</span>:

            new_sample = np.concatenate(
                [
                    [prefix_tok_id],
                    prefix,
                    [suffix_tok_id],
                    suffix,
                    [middle_tok_id],
                    middle,
                ]
            )
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># don&#x27;t apply FIM transformations</span>
        new_sample = sample

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(new_sample), np_rng`,wrap:!1}}),$=new o({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> IterableDataset
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">import</span> random

<span class="hljs-comment"># Create an Iterable dataset that returns constant-length chunks of tokens from a stream of text files.</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConstantLengthDataset</span>(<span class="hljs-title class_ inherited__">IterableDataset</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Iterable dataset that returns constant length chunks of tokens from stream of text files.
        Args:
            tokenizer (Tokenizer): The processor used for proccessing the data.
            dataset (dataset.Dataset): Dataset with text files.
            infinite (bool): If True the iterator is reset after dataset reaches end else stops.
            seq_length (int): Length of token sequences to return.
            num_of_sequences (int): Number of token sequences to keep in buffer.
            chars_per_token (int): Number of characters per token used to estimate number of tokens in text buffer.
            fim_rate (float): Rate (0.0 to 1.0) that sample will be permuted with FIM.
            fim_spm_rate (float): Rate (0.0 to 1.0) of FIM permuations that will use SPM.
            seed (int): Seed for random number generator.
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        tokenizer,
        dataset,
        infinite=<span class="hljs-literal">False</span>,
        seq_length=<span class="hljs-number">1024</span>,
        num_of_sequences=<span class="hljs-number">1024</span>,
        chars_per_token=<span class="hljs-number">3.6</span>,
        content_field=<span class="hljs-string">&quot;content&quot;</span>,
        fim_rate=<span class="hljs-number">0.5</span>,
        fim_spm_rate=<span class="hljs-number">0.5</span>,
        seed=<span class="hljs-number">0</span>,
    </span>):
        self.tokenizer = tokenizer
        self.concat_token_id = tokenizer.eos_token_id
        self.dataset = dataset
        self.seq_length = seq_length
        self.infinite = infinite
        self.current_size = <span class="hljs-number">0</span>
        self.max_buffer_size = seq_length * chars_per_token * num_of_sequences
        self.content_field = content_field
        self.fim_rate = fim_rate
        self.fim_spm_rate = fim_spm_rate
        self.seed = seed

        (
            self.suffix_tok_id,
            self.prefix_tok_id,
            self.middle_tok_id,
            self.pad_tok_id,
        ) = get_fim_token_ids(self.tokenizer)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.suffix_tok_id <span class="hljs-keyword">and</span> self.fim_rate &gt; <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;FIM is not supported by tokenizer, disabling FIM&quot;</span>)
            self.fim_rate = <span class="hljs-number">0</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__iter__</span>(<span class="hljs-params">self</span>):
        iterator = <span class="hljs-built_in">iter</span>(self.dataset)
        more_examples = <span class="hljs-literal">True</span>
        np_rng = np.random.RandomState(seed=self.seed)
        <span class="hljs-keyword">while</span> more_examples:
            buffer, buffer_len = [], <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
                <span class="hljs-keyword">if</span> buffer_len &gt;= self.max_buffer_size:
                    <span class="hljs-keyword">break</span>
                <span class="hljs-keyword">try</span>:
                    buffer.append(<span class="hljs-built_in">next</span>(iterator)[self.content_field])
                    buffer_len += <span class="hljs-built_in">len</span>(buffer[-<span class="hljs-number">1</span>])
                <span class="hljs-keyword">except</span> StopIteration:
                    <span class="hljs-keyword">if</span> self.infinite:
                        iterator = <span class="hljs-built_in">iter</span>(self.dataset)
                    <span class="hljs-keyword">else</span>:
                        more_examples = <span class="hljs-literal">False</span>
                        <span class="hljs-keyword">break</span>
            tokenized_inputs = self.tokenizer(buffer, truncation=<span class="hljs-literal">False</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
            all_token_ids = []

            <span class="hljs-keyword">for</span> tokenized_input <span class="hljs-keyword">in</span> tokenized_inputs:
                <span class="hljs-comment"># optionally do FIM permutations</span>
                <span class="hljs-keyword">if</span> self.fim_rate &gt; <span class="hljs-number">0</span>:
                    tokenized_input, np_rng = permute(
                        tokenized_input,
                        np_rng,
                        self.suffix_tok_id,
                        self.prefix_tok_id,
                        self.middle_tok_id,
                        self.pad_tok_id,
                        fim_rate=self.fim_rate,
                        fim_spm_rate=self.fim_spm_rate,
                        truncate_or_pad=<span class="hljs-literal">False</span>,
                    )

                all_token_ids.extend(tokenized_input + [self.concat_token_id])
            examples = []
            <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(all_token_ids), self.seq_length):
                input_ids = all_token_ids[i : i + self.seq_length]
                <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(input_ids) == self.seq_length:
                    examples.append(input_ids)
            random.shuffle(examples)
            <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples:
                self.current_size += <span class="hljs-number">1</span>
                <span class="hljs-keyword">yield</span> {
                    <span class="hljs-string">&quot;input_ids&quot;</span>: torch.LongTensor(example),
                    <span class="hljs-string">&quot;labels&quot;</span>: torch.LongTensor(example),
                }


train_dataset = ConstantLengthDataset(
    tokenizer,
    train_data,
    infinite=<span class="hljs-literal">True</span>,
    seq_length=SEQ_LENGTH,
    chars_per_token=chars_per_token,
    content_field=DATA_COLUMN,
    fim_rate=FIM_RATE,
    fim_spm_rate=FIM_SPM_RATE,
    seed=SEED,
)
eval_dataset = ConstantLengthDataset(
    tokenizer,
    valid_data,
    infinite=<span class="hljs-literal">False</span>,
    seq_length=SEQ_LENGTH,
    chars_per_token=chars_per_token,
    content_field=DATA_COLUMN,
    fim_rate=FIM_RATE,
    fim_spm_rate=FIM_SPM_RATE,
    seed=SEED,
)`,wrap:!1}}),L=new Vl({props:{title:"Prepare the model",local:"prepare-the-model",headingTag:"h2"}}),el=new o({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBZnJvbSUyMHBlZnQudHVuZXJzLmxvcmElMjBpbXBvcnQlMjBMb3JhTGF5ZXIlMEElMEFsb2FkX2luXzhiaXQlMjAlM0QlMjBGYWxzZSUwQSUwQSUyMyUyMDQtYml0JTIwcXVhbnRpemF0aW9uJTBBY29tcHV0ZV9kdHlwZSUyMCUzRCUyMGdldGF0dHIodG9yY2glMkMlMjBCTkJfNEJJVF9DT01QVVRFX0RUWVBFKSUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEY29tcHV0ZV9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RVU0VfTkVTVEVEX1FVQU5UJTJDJTBBKSUwQSUwQWRldmljZV9tYXAlMjAlM0QlMjAlN0IlMjIlMjIlM0ElMjAwJTdEJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwTU9ERUwlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0Rsb2FkX2luXzhiaXQlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMkMlMjAlMjAlMjMlMjBXZSUyMHdpbGwlMjBiZSUyMHVzaW5nJTIwZ3JhZGllbnQlMjBjaGVja3BvaW50aW5nJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model, prepare_model_for_kbit_training
<span class="hljs-keyword">from</span> peft.tuners.lora <span class="hljs-keyword">import</span> LoraLayer

load_in_8bit = <span class="hljs-literal">False</span>

<span class="hljs-comment"># 4-bit quantization</span>
compute_dtype = <span class="hljs-built_in">getattr</span>(torch, BNB_4BIT_COMPUTE_DTYPE)

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=compute_dtype,
    bnb_4bit_use_double_quant=USE_NESTED_QUANT,
)

device_map = {<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>}

model = AutoModelForCausalLM.from_pretrained(
    MODEL,
    load_in_8bit=load_in_8bit,
    quantization_config=bnb_config,
    device_map=device_map,
    use_cache=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># We will be using gradient checkpointing</span>
    trust_remote_code=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),tl=new o({props:{code:"bW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:"model = prepare_model_for_kbit_training(model)",wrap:!1}}),yl=new o({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBsb3JhJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0RMT1JBX0FMUEhBJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNETE9SQV9EUk9QT1VUJTJDJTBBJTIwJTIwJTIwJTIwciUzRExPUkFfUiUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0RMT1JBX1RBUkdFVF9NT0RVTEVTLnNwbGl0KCUyMiUyQyUyMiklMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up lora</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>peft_config = LoraConfig(
<span class="hljs-meta">... </span>    lora_alpha=LORA_ALPHA,
<span class="hljs-meta">... </span>    lora_dropout=LORA_DROPOUT,
<span class="hljs-meta">... </span>    r=LORA_R,
<span class="hljs-meta">... </span>    bias=<span class="hljs-string">&quot;none&quot;</span>,
<span class="hljs-meta">... </span>    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
<span class="hljs-meta">... </span>    target_modules=LORA_TARGET_MODULES.split(<span class="hljs-string">&quot;,&quot;</span>),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, peft_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.print_trainable_parameters()`,wrap:!1}}),Tl=new Vl({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),wl=new o({props:{code:"dHJhaW5fZGF0YS5zdGFydF9pdGVyYXRpb24lMjAlM0QlMjAwJTBBJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RmJTIyWW91cl9IRl91c2VybmFtZSUyRiU3Qk9VVFBVVF9ESVIlN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhbG9hZGVyX2Ryb3BfbGFzdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0RNQVhfU1RFUFMlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNERVZBTF9GUkVRJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzRFNBVkVfRlJFUSUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0RMT0dfRlJFUSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzREJBVENIX1NJWkUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzREJBVENIX1NJWkUlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNETFIlMkMlMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXJfdHlwZSUzRExSX1NDSEVEVUxFUl9UWVBFJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNETlVNX1dBUk1VUF9TVEVQUyUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzREdSX0FDQ19TVEVQUyUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzREZQMTYlMkMlMEElMjAlMjAlMjAlMjBiZjE2JTNEQkYxNiUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRFdFSUdIVF9ERUNBWSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGluY2x1ZGVfdG9rZW5zX3Blcl9zZWNvbmQlM0RUcnVlJTJDJTBBKQ==",highlighted:`train_data.start_iteration = <span class="hljs-number">0</span>


training_args = TrainingArguments(
    output_dir=<span class="hljs-string">f&quot;Your_HF_username/<span class="hljs-subst">{OUTPUT_DIR}</span>&quot;</span>,
    dataloader_drop_last=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    max_steps=MAX_STEPS,
    eval_steps=EVAL_FREQ,
    save_steps=SAVE_FREQ,
    logging_steps=LOG_FREQ,
    per_device_train_batch_size=BATCH_SIZE,
    per_device_eval_batch_size=BATCH_SIZE,
    learning_rate=LR,
    lr_scheduler_type=LR_SCHEDULER_TYPE,
    warmup_steps=NUM_WARMUP_STEPS,
    gradient_accumulation_steps=GR_ACC_STEPS,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=FP16,
    bf16=BF16,
    weight_decay=WEIGHT_DECAY,
    push_to_hub=<span class="hljs-literal">True</span>,
    include_tokens_per_second=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ml=new o({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQpJTBBJTBBcHJpbnQoJTIyVHJhaW5pbmcuLi4lMjIpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(model=model, args=training_args, train_dataset=train_dataset, eval_dataset=eval_dataset)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Training...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),dl=new o({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),cl=new Vl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),hl=new o({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMGxvYWQlMjB0aGUlMjBvcmlnaW5hbCUyMG1vZGVsJTIwZmlyc3QlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChNT0RFTCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyME1PREVMJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpLmN1ZGEoKSUwQSUwQSUyMyUyMG1lcmdlJTIwZmluZS10dW5lZCUyMHdlaWdodHMlMjB3aXRoJTIwdGhlJTIwYmFzZSUyMG1vZGVsJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjJZb3VyX0hGX3VzZXJuYW1lJTJGJTdCT1VUUFVUX0RJUiU3RCUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCklMEFtb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load the original model first</span>
tokenizer = AutoTokenizer.from_pretrained(MODEL, trust_remote_code=<span class="hljs-literal">True</span>)
base_model = AutoModelForCausalLM.from_pretrained(
    MODEL,
    quantization_config=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-literal">None</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
    torch_dtype=torch.bfloat16,
).cuda()

<span class="hljs-comment"># merge fine-tuned weights with the base model</span>
peft_model_id = <span class="hljs-string">f&quot;Your_HF_username/<span class="hljs-subst">{OUTPUT_DIR}</span>&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),ul=new o({props:{code:"ZGVmJTIwZ2V0X2NvZGVfY29tcGxldGlvbihwcmVmaXglMkMlMjBzdWZmaXgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjIlM0NmaW1fcHJlZml4JTNFJTdCcHJlZml4JTdEJTNDZmltX3N1ZmZpeCUzRSU3QnN1ZmZpeCU3RCUzQ2ZpbV9taWRkbGUlM0UlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBtb2RlbC5ldmFsKCklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMuY3VkYSgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_code_completion</span>(<span class="hljs-params">prefix, suffix</span>):
    text = prompt = <span class="hljs-string">f&quot;&quot;&quot;&lt;fim_prefix&gt;<span class="hljs-subst">{prefix}</span>&lt;fim_suffix&gt;<span class="hljs-subst">{suffix}</span>&lt;fim_middle&gt;&quot;&quot;&quot;</span>
    model.<span class="hljs-built_in">eval</span>()
    outputs = model.generate(
        input_ids=tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.cuda(),
        max_new_tokens=<span class="hljs-number">128</span>,
        temperature=<span class="hljs-number">0.2</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.95</span>,
        do_sample=<span class="hljs-literal">True</span>,
        repetition_penalty=<span class="hljs-number">1.0</span>,
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),bl=new o({props:{code:"cHJlZml4JTIwJTNEJTIwJTIyJTIyJTIyZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMkMlMjBnZXRfcGVmdF9tb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjIlMjIlMjIlMEFzdWZmaXglMjAlM0QlMjAlMjIlMjIlMjIlMjIlMjIlMjIlMEElMEFwcmludChnZXRfY29kZV9jb21wbGV0aW9uKHByZWZpeCUyQyUyMHN1ZmZpeCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prefix = <span class="hljs-string">&quot;&quot;&quot;from peft import LoraConfig, TaskType, get_peft_model
<span class="hljs-meta">... </span>from transformers import AutoModelForCausalLM
<span class="hljs-meta">... </span>peft_config = LoraConfig(
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>suffix = <span class="hljs-string">&quot;&quot;&quot;&quot;&quot;&quot;</span>

<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(get_code_completion(prefix, suffix))`,wrap:!1}}),Gl=new o({props:{code:"cHJlZml4JTIwJTNEJTIwJTIyJTIyJTIyZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMkMlMjBnZXRfcGVmdF9tb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjIlMjIlMjIlMEFzdWZmaXglMjAlM0QlMjAlMjIlMjIlMjIlMjIlMjIlMjIlMEElMEFwcmludChnZXRfY29kZV9jb21wbGV0aW9uKHByZWZpeCUyQyUyMHN1ZmZpeCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prefix = <span class="hljs-string">&quot;&quot;&quot;from peft import LoraConfig, TaskType, get_peft_model
<span class="hljs-meta">... </span>from transformers import AutoModelForCausalLM
<span class="hljs-meta">... </span>peft_config = LoraConfig(
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>suffix = <span class="hljs-string">&quot;&quot;&quot;&quot;&quot;&quot;</span>

<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(get_code_completion(prefix, suffix))`,wrap:!1}}),Xl=new yt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_code_llm_on_single_gpu.md"}}),{c(){m=n("meta"),Fl=s(),gl=n("p"),Wl=s(),J(r.$$.fragment),Sl=s(),J(I.$$.fragment),Nl=s(),d=n("p"),d.innerHTML=nM,Yl=s(),c=n("p"),c.textContent=yM,vl=s(),C=n("p"),C.textContent=UM,xl=s(),J(h.$$.fragment),Hl=s(),A=n("p"),A.innerHTML=JM,zl=s(),J(u.$$.fragment),$l=s(),f=n("p"),f.innerHTML=TM,Ll=s(),J(b.$$.fragment),ql=s(),Z=n("p"),Z.innerHTML=pM,Dl=s(),B=n("p"),B.textContent=jM,Pl=s(),J(_.$$.fragment),Kl=s(),G=n("p"),G.textContent=iM,Ol=s(),J(R.$$.fragment),le=s(),J(E.$$.fragment),ee=s(),J(k.$$.fragment),Me=s(),X=n("p"),X.textContent=wM,te=s(),V=n("p"),V.textContent=oM,se=s(),J(g.$$.fragment),ae=s(),Q=n("p"),Q.textContent=mM,ne=s(),F=n("p"),F.innerHTML=rM,ye=s(),J(W.$$.fragment),Ue=s(),S=n("pre"),S.textContent=IM,Je=s(),N=n("p"),N.textContent=dM,Te=s(),Y=n("p"),Y.innerHTML=cM,pe=s(),v=n("p"),v.innerHTML=CM,je=s(),J(x.$$.fragment),ie=s(),H=n("p"),H.innerHTML=hM,we=s(),z=n("p"),z.innerHTML=AM,oe=s(),J($.$$.fragment),me=s(),J(L.$$.fragment),re=s(),q=n("p"),q.textContent=uM,Ie=s(),D=n("p"),D.innerHTML=fM,de=s(),P=n("p"),P.innerHTML=bM,ce=s(),K=n("p"),K.innerHTML=ZM,Ce=s(),O=n("p"),O.innerHTML=BM,he=s(),ll=n("p"),ll.innerHTML=_M,Ae=s(),J(el.$$.fragment),ue=s(),Ml=n("p"),Ml.innerHTML=GM,fe=s(),J(tl.$$.fragment),be=s(),sl=n("p"),sl.textContent=RM,Ze=s(),al=n("p"),al.innerHTML=EM,Be=s(),nl=n("p"),nl.innerHTML=kM,_e=s(),J(yl.$$.fragment),Ge=s(),Ul=n("pre"),Ul.textContent=XM,Re=s(),Jl=n("p"),Jl.textContent=VM,Ee=s(),J(Tl.$$.fragment),ke=s(),pl=n("p"),pl.textContent=gM,Xe=s(),jl=n("p"),jl.innerHTML=QM,Ve=s(),il=n("p"),il.textContent=FM,ge=s(),J(wl.$$.fragment),Qe=s(),ol=n("p"),ol.innerHTML=WM,Fe=s(),J(ml.$$.fragment),We=s(),rl=n("pre"),rl.textContent=SM,Se=s(),Il=n("p"),Il.textContent=NM,Ne=s(),J(dl.$$.fragment),Ye=s(),J(cl.$$.fragment),ve=s(),Cl=n("p"),Cl.textContent=YM,xe=s(),J(hl.$$.fragment),He=s(),Al=n("p"),Al.innerHTML=vM,ze=s(),J(ul.$$.fragment),$e=s(),fl=n("p"),fl.innerHTML=xM,Le=s(),J(bl.$$.fragment),qe=s(),Zl=n("pre"),Zl.textContent=HM,De=s(),Bl=n("p"),Bl.innerHTML=zM,Pe=s(),_l=n("p"),_l.textContent=$M,Ke=s(),J(Gl.$$.fragment),Oe=s(),Rl=n("pre"),Rl.textContent=LM,lM=s(),El=n("p"),El.innerHTML=qM,eM=s(),kl=n("p"),kl.innerHTML=DM,MM=s(),J(Xl.$$.fragment),tM=s(),Ql=n("p"),this.h()},l(l){const e=st("svelte-u9bgzb",document.head);m=y(e,"META",{name:!0,content:!0}),e.forEach(M),Fl=a(l),gl=y(l,"P",{}),PM(gl).forEach(M),Wl=a(l),T(r.$$.fragment,l),Sl=a(l),T(I.$$.fragment,l),Nl=a(l),d=y(l,"P",{"data-svelte-h":!0}),U(d)!=="svelte-26mfp8"&&(d.innerHTML=nM),Yl=a(l),c=y(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-1jkdfbx"&&(c.textContent=yM),vl=a(l),C=y(l,"P",{"data-svelte-h":!0}),U(C)!=="svelte-twmb21"&&(C.textContent=UM),xl=a(l),T(h.$$.fragment,l),Hl=a(l),A=y(l,"P",{"data-svelte-h":!0}),U(A)!=="svelte-lcmz04"&&(A.innerHTML=JM),zl=a(l),T(u.$$.fragment,l),$l=a(l),f=y(l,"P",{"data-svelte-h":!0}),U(f)!=="svelte-1wkzu9g"&&(f.innerHTML=TM),Ll=a(l),T(b.$$.fragment,l),ql=a(l),Z=y(l,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-pqckta"&&(Z.innerHTML=pM),Dl=a(l),B=y(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-1bfizik"&&(B.textContent=jM),Pl=a(l),T(_.$$.fragment,l),Kl=a(l),G=y(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1n5u6bj"&&(G.textContent=iM),Ol=a(l),T(R.$$.fragment,l),le=a(l),T(E.$$.fragment,l),ee=a(l),T(k.$$.fragment,l),Me=a(l),X=y(l,"P",{"data-svelte-h":!0}),U(X)!=="svelte-p22occ"&&(X.textContent=wM),te=a(l),V=y(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-nud4q8"&&(V.textContent=oM),se=a(l),T(g.$$.fragment,l),ae=a(l),Q=y(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-169rcmc"&&(Q.textContent=mM),ne=a(l),F=y(l,"P",{"data-svelte-h":!0}),U(F)!=="svelte-1n3y7wl"&&(F.innerHTML=rM),ye=a(l),T(W.$$.fragment,l),Ue=a(l),S=y(l,"PRE",{"data-svelte-h":!0}),U(S)!=="svelte-ko6dme"&&(S.textContent=IM),Je=a(l),N=y(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-4527xa"&&(N.textContent=dM),Te=a(l),Y=y(l,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1lk8r3"&&(Y.innerHTML=cM),pe=a(l),v=y(l,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1l3szds"&&(v.innerHTML=CM),je=a(l),T(x.$$.fragment,l),ie=a(l),H=y(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-2233ic"&&(H.innerHTML=hM),we=a(l),z=y(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-155t8oo"&&(z.innerHTML=AM),oe=a(l),T($.$$.fragment,l),me=a(l),T(L.$$.fragment,l),re=a(l),q=y(l,"P",{"data-svelte-h":!0}),U(q)!=="svelte-9bd9cz"&&(q.textContent=uM),Ie=a(l),D=y(l,"P",{"data-svelte-h":!0}),U(D)!=="svelte-1uhrhyi"&&(D.innerHTML=fM),de=a(l),P=y(l,"P",{"data-svelte-h":!0}),U(P)!=="svelte-2m06yu"&&(P.innerHTML=bM),ce=a(l),K=y(l,"P",{"data-svelte-h":!0}),U(K)!=="svelte-lrsdq"&&(K.innerHTML=ZM),Ce=a(l),O=y(l,"P",{"data-svelte-h":!0}),U(O)!=="svelte-1s6fz64"&&(O.innerHTML=BM),he=a(l),ll=y(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-1uji32v"&&(ll.innerHTML=_M),Ae=a(l),T(el.$$.fragment,l),ue=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-1h52q0h"&&(Ml.innerHTML=GM),fe=a(l),T(tl.$$.fragment,l),be=a(l),sl=y(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-1oeq64f"&&(sl.textContent=RM),Ze=a(l),al=y(l,"P",{"data-svelte-h":!0}),U(al)!=="svelte-6kkm2s"&&(al.innerHTML=EM),Be=a(l),nl=y(l,"P",{"data-svelte-h":!0}),U(nl)!=="svelte-1ygxagi"&&(nl.innerHTML=kM),_e=a(l),T(yl.$$.fragment,l),Ge=a(l),Ul=y(l,"PRE",{"data-svelte-h":!0}),U(Ul)!=="svelte-hpf32x"&&(Ul.textContent=XM),Re=a(l),Jl=y(l,"P",{"data-svelte-h":!0}),U(Jl)!=="svelte-g92wi0"&&(Jl.textContent=VM),Ee=a(l),T(Tl.$$.fragment,l),ke=a(l),pl=y(l,"P",{"data-svelte-h":!0}),U(pl)!=="svelte-nh2kp6"&&(pl.textContent=gM),Xe=a(l),jl=y(l,"P",{"data-svelte-h":!0}),U(jl)!=="svelte-rhwpb7"&&(jl.innerHTML=QM),Ve=a(l),il=y(l,"P",{"data-svelte-h":!0}),U(il)!=="svelte-6zfky8"&&(il.textContent=FM),ge=a(l),T(wl.$$.fragment,l),Qe=a(l),ol=y(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-1yquuuu"&&(ol.innerHTML=WM),Fe=a(l),T(ml.$$.fragment,l),We=a(l),rl=y(l,"PRE",{"data-svelte-h":!0}),U(rl)!=="svelte-9xzew6"&&(rl.textContent=SM),Se=a(l),Il=y(l,"P",{"data-svelte-h":!0}),U(Il)!=="svelte-p9ps3w"&&(Il.textContent=NM),Ne=a(l),T(dl.$$.fragment,l),Ye=a(l),T(cl.$$.fragment,l),ve=a(l),Cl=y(l,"P",{"data-svelte-h":!0}),U(Cl)!=="svelte-lw3peh"&&(Cl.textContent=YM),xe=a(l),T(hl.$$.fragment,l),He=a(l),Al=y(l,"P",{"data-svelte-h":!0}),U(Al)!=="svelte-1xk304l"&&(Al.innerHTML=vM),ze=a(l),T(ul.$$.fragment,l),$e=a(l),fl=y(l,"P",{"data-svelte-h":!0}),U(fl)!=="svelte-1nsj0eg"&&(fl.innerHTML=xM),Le=a(l),T(bl.$$.fragment,l),qe=a(l),Zl=y(l,"PRE",{"data-svelte-h":!0}),U(Zl)!=="svelte-11ixuz2"&&(Zl.textContent=HM),De=a(l),Bl=y(l,"P",{"data-svelte-h":!0}),U(Bl)!=="svelte-tkz9oe"&&(Bl.innerHTML=zM),Pe=a(l),_l=y(l,"P",{"data-svelte-h":!0}),U(_l)!=="svelte-1wna85g"&&(_l.textContent=$M),Ke=a(l),T(Gl.$$.fragment,l),Oe=a(l),Rl=y(l,"PRE",{"data-svelte-h":!0}),U(Rl)!=="svelte-1ud779o"&&(Rl.textContent=LM),lM=a(l),El=y(l,"P",{"data-svelte-h":!0}),U(El)!=="svelte-1dhv5aw"&&(El.innerHTML=qM),eM=a(l),kl=y(l,"P",{"data-svelte-h":!0}),U(kl)!=="svelte-zjkw3y"&&(kl.innerHTML=DM),MM=a(l),T(Xl.$$.fragment,l),tM=a(l),Ql=y(l,"P",{}),PM(Ql).forEach(M),this.h()},h(){KM(m,"name","hf:doc:metadata"),KM(m,"content",Jt)},m(l,e){at(document.head,m),t(l,Fl,e),t(l,gl,e),t(l,Wl,e),p(r,l,e),t(l,Sl,e),p(I,l,e),t(l,Nl,e),t(l,d,e),t(l,Yl,e),t(l,c,e),t(l,vl,e),t(l,C,e),t(l,xl,e),p(h,l,e),t(l,Hl,e),t(l,A,e),t(l,zl,e),p(u,l,e),t(l,$l,e),t(l,f,e),t(l,Ll,e),p(b,l,e),t(l,ql,e),t(l,Z,e),t(l,Dl,e),t(l,B,e),t(l,Pl,e),p(_,l,e),t(l,Kl,e),t(l,G,e),t(l,Ol,e),p(R,l,e),t(l,le,e),p(E,l,e),t(l,ee,e),p(k,l,e),t(l,Me,e),t(l,X,e),t(l,te,e),t(l,V,e),t(l,se,e),p(g,l,e),t(l,ae,e),t(l,Q,e),t(l,ne,e),t(l,F,e),t(l,ye,e),p(W,l,e),t(l,Ue,e),t(l,S,e),t(l,Je,e),t(l,N,e),t(l,Te,e),t(l,Y,e),t(l,pe,e),t(l,v,e),t(l,je,e),p(x,l,e),t(l,ie,e),t(l,H,e),t(l,we,e),t(l,z,e),t(l,oe,e),p($,l,e),t(l,me,e),p(L,l,e),t(l,re,e),t(l,q,e),t(l,Ie,e),t(l,D,e),t(l,de,e),t(l,P,e),t(l,ce,e),t(l,K,e),t(l,Ce,e),t(l,O,e),t(l,he,e),t(l,ll,e),t(l,Ae,e),p(el,l,e),t(l,ue,e),t(l,Ml,e),t(l,fe,e),p(tl,l,e),t(l,be,e),t(l,sl,e),t(l,Ze,e),t(l,al,e),t(l,Be,e),t(l,nl,e),t(l,_e,e),p(yl,l,e),t(l,Ge,e),t(l,Ul,e),t(l,Re,e),t(l,Jl,e),t(l,Ee,e),p(Tl,l,e),t(l,ke,e),t(l,pl,e),t(l,Xe,e),t(l,jl,e),t(l,Ve,e),t(l,il,e),t(l,ge,e),p(wl,l,e),t(l,Qe,e),t(l,ol,e),t(l,Fe,e),p(ml,l,e),t(l,We,e),t(l,rl,e),t(l,Se,e),t(l,Il,e),t(l,Ne,e),p(dl,l,e),t(l,Ye,e),p(cl,l,e),t(l,ve,e),t(l,Cl,e),t(l,xe,e),p(hl,l,e),t(l,He,e),t(l,Al,e),t(l,ze,e),p(ul,l,e),t(l,$e,e),t(l,fl,e),t(l,Le,e),p(bl,l,e),t(l,qe,e),t(l,Zl,e),t(l,De,e),t(l,Bl,e),t(l,Pe,e),t(l,_l,e),t(l,Ke,e),p(Gl,l,e),t(l,Oe,e),t(l,Rl,e),t(l,lM,e),t(l,El,e),t(l,eM,e),t(l,kl,e),t(l,MM,e),p(Xl,l,e),t(l,tM,e),t(l,Ql,e),sM=!0},p:lt,i(l){sM||(j(r.$$.fragment,l),j(I.$$.fragment,l),j(h.$$.fragment,l),j(u.$$.fragment,l),j(b.$$.fragment,l),j(_.$$.fragment,l),j(R.$$.fragment,l),j(E.$$.fragment,l),j(k.$$.fragment,l),j(g.$$.fragment,l),j(W.$$.fragment,l),j(x.$$.fragment,l),j($.$$.fragment,l),j(L.$$.fragment,l),j(el.$$.fragment,l),j(tl.$$.fragment,l),j(yl.$$.fragment,l),j(Tl.$$.fragment,l),j(wl.$$.fragment,l),j(ml.$$.fragment,l),j(dl.$$.fragment,l),j(cl.$$.fragment,l),j(hl.$$.fragment,l),j(ul.$$.fragment,l),j(bl.$$.fragment,l),j(Gl.$$.fragment,l),j(Xl.$$.fragment,l),sM=!0)},o(l){i(r.$$.fragment,l),i(I.$$.fragment,l),i(h.$$.fragment,l),i(u.$$.fragment,l),i(b.$$.fragment,l),i(_.$$.fragment,l),i(R.$$.fragment,l),i(E.$$.fragment,l),i(k.$$.fragment,l),i(g.$$.fragment,l),i(W.$$.fragment,l),i(x.$$.fragment,l),i($.$$.fragment,l),i(L.$$.fragment,l),i(el.$$.fragment,l),i(tl.$$.fragment,l),i(yl.$$.fragment,l),i(Tl.$$.fragment,l),i(wl.$$.fragment,l),i(ml.$$.fragment,l),i(dl.$$.fragment,l),i(cl.$$.fragment,l),i(hl.$$.fragment,l),i(ul.$$.fragment,l),i(bl.$$.fragment,l),i(Gl.$$.fragment,l),i(Xl.$$.fragment,l),sM=!1},d(l){l&&(M(Fl),M(gl),M(Wl),M(Sl),M(Nl),M(d),M(Yl),M(c),M(vl),M(C),M(xl),M(Hl),M(A),M(zl),M($l),M(f),M(Ll),M(ql),M(Z),M(Dl),M(B),M(Pl),M(Kl),M(G),M(Ol),M(le),M(ee),M(Me),M(X),M(te),M(V),M(se),M(ae),M(Q),M(ne),M(F),M(ye),M(Ue),M(S),M(Je),M(N),M(Te),M(Y),M(pe),M(v),M(je),M(ie),M(H),M(we),M(z),M(oe),M(me),M(re),M(q),M(Ie),M(D),M(de),M(P),M(ce),M(K),M(Ce),M(O),M(he),M(ll),M(Ae),M(ue),M(Ml),M(fe),M(be),M(sl),M(Ze),M(al),M(Be),M(nl),M(_e),M(Ge),M(Ul),M(Re),M(Jl),M(Ee),M(ke),M(pl),M(Xe),M(jl),M(Ve),M(il),M(ge),M(Qe),M(ol),M(Fe),M(We),M(rl),M(Se),M(Il),M(Ne),M(Ye),M(ve),M(Cl),M(xe),M(He),M(Al),M(ze),M($e),M(fl),M(Le),M(qe),M(Zl),M(De),M(Bl),M(Pe),M(_l),M(Ke),M(Oe),M(Rl),M(lM),M(El),M(eM),M(kl),M(MM),M(tM),M(Ql)),M(m),w(r,l),w(I,l),w(h,l),w(u,l),w(b,l),w(_,l),w(R,l),w(E,l),w(k,l),w(g,l),w(W,l),w(x,l),w($,l),w(L,l),w(el,l),w(tl,l),w(yl,l),w(Tl,l),w(wl,l),w(ml,l),w(dl,l),w(cl,l),w(hl,l),w(ul,l),w(bl,l),w(Gl,l),w(Xl,l)}}}const Jt='{"title":"Fine-tuning a Code LLM on Custom Code on a single GPU","local":"fine-tuning-a-code-llm-on-custom-code-on-a-single-gpu","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[],"depth":2},{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Prepare the model","local":"prepare-the-model","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Tt(aM){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends Mt{constructor(m){super(),tt(this,m,Tt,Ut,OM,{})}}export{ot as component};
