import{s as Nl,f as Zl,n as Dl,o as Vl}from"../chunks/scheduler.65852ee5.js";import{S as Ll,i as zl,g as i,s as o,r as p,A as Yl,h as n,f as A,c as a,j as ql,u as U,x as s,k as SA,y as El,a as l,v as r,d as M,t as y,w as u}from"../chunks/index.aa74147d.js";import{D as Ol,C as F}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as c,E as $l}from"../chunks/EditOnGithub.4eda6a96.js";function _l(qA){let w,Ae,te,le,j,oe,d,ae,f,NA='<em>Authored by: <a href="https://github.com/anakin87" rel="nofollow">Stefano Fiorucci</a></em>',ie,m,ZA="In this notebook, we will see how to automate Information Extraction from textual data using Language Models.",ne,R,DA="🎯 Goal: create an application to extract specific information from a given text or URL, following a user-defined structure.",se,K,VA="🧰 <strong>Stack</strong>",pe,J,LA='<li><p><a href="https://haystack.deepset.ai?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">Haystack 🏗️</a>: a customizable orchestration framework for building LLM applications. We will use Haystack to build the Information Extraction Pipeline.</p></li> <li><p><a href="https://huggingface.co/numind/NuExtract" rel="nofollow">NuExtract</a>: a small Language Model, specifically fine-tuned for structured data extraction.</p></li>',Ue,b,re,T,Me,h,ye,B,zA='Haystack has two main concepts: <a href="https://docs.haystack.deepset.ai/docs/components_overview?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">Components and Pipelines</a>.',ue,g,YA="🧩 <strong>Components</strong> are building blocks that perform a single task: file conversion, text generation, embedding creation…",Fe,v,EA="➿ <strong>Pipelines</strong> allow you to define the flow of data through your LLM application, by combining Components in a directed (cyclic) graph.",ce,C,OA="<em>We will now introduce the various components of our Information Extraction application. Afterwards, we will integrate them into a Pipeline.</em>",we,G,je,k,$A="In our experiment, we will extract data from startup funding announcements found on the web.",de,W,_A="To download web pages and extract text, we use two components:",fe,P,tl='<li><a href="https://docs.haystack.deepset.ai/docs/linkcontentfetcher?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>LinkContentFetcher</code></a>: fetches the content of some URLs and returns a list of content streams (as <a href="https://docs.haystack.deepset.ai/docs/data-classes#bytestream?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>ByteStream</code> objects</a>).</li> <li><a href="https://docs.haystack.deepset.ai/docs/htmltodocument?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>HTMLToDocument</code></a>: converts HTML sources into textual <a href="https://docs.haystack.deepset.ai/docs/data-classes#document?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>Documents</code></a>.</li>',me,I,Re,H,el=`&#123;'documents': [Document(id=65bb1ce4b6db2f154d3acfa145fa03363ef93f751fb8599dcec3aaf75aa325b9, content: 'This domain is for use in illustrative examples in documents. You may use this domain in literature ...', meta: &#123;'content_type': 'text/html', 'url': 'https://example.com/'})]}
`,Ke,Q,Je,X,Al='We use the <a href="https://docs.haystack.deepset.ai/docs/huggingfacelocalgenerator?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>HuggingFaceLocalGenerator</code></a>, a text generation component that allows loading a model hosted on Hugging Face using the Transformers library.',be,x,ll='Haystack supports many other <a href="https://docs.haystack.deepset.ai/docs/generators?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">Generators</a>, including <a href="https://docs.haystack.deepset.ai/docs/huggingfaceapigenerator?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>HuggingFaceAPIGenerator</code></a> (compatible with Hugging Face APIs and TGI).',Te,S,ol='We load <a href="https://huggingface.co/numind/NuExtract" rel="nofollow">NuExtract</a>, a model fine-tuned from <code>microsoft/Phi-3-mini-4k-instruct</code> to perform structured data extraction from text. The model size is 3.8B parameters. Other variants are also available: <code>NuExtract-tiny</code> (0.5B) and <code>NuExtract-large</code> (7B).',he,q,al="The model is loaded with <code>bfloat16</code> precision to fit in Colab with negligible performance loss compared to FP32, as suggested in the model card.",Be,N,ge,Z,il="At inference time, you will probably see a warning saying: “You are not running the flash-attention implementation”.",ve,D,nl="GPUs available on free environments like Colab or Kaggle do not support it, so we decided to not use it in this notebook.",Ce,V,sl='In case your GPU architecture supports it (<a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">details</a>), you can install it and get a speed-up as follows:',Ge,L,ke,z,pl="Then add <code>&quot;attn_implementation&quot;: &quot;flash_attention_2&quot;</code> to <code>model_kwargs</code>.",We,Y,Pe,E,Ul="The model supports a specific prompt structure, as can be inferred from the model card.",Ie,O,rl="Let’s manually create a prompt to try the model. Later, we will see how to dynamically create the prompt based on different inputs.",He,$,Qe,_,Ml="Nice ✅",Xe,tt,xe,et,yl='The <a href="https://docs.haystack.deepset.ai/docs/promptbuilder?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>PromptBuilder</code></a> is initialized with a Jinja2 prompt template and renders it by filling in parameters passed through keyword arguments.',Se,At,ul='Our prompt template reproduces the structure shown in <a href="https://huggingface.co/numind/NuExtract" rel="nofollow">model card</a>.',qe,lt,Fl="During our experiments, we discovered that indenting the schema is particularly important to ensure good results. This probably stems from how the model was trained.",Ne,ot,Ze,at,De,it,cl="Works well ✅",Ve,nt,Le,st,wl="You may have noticed that the result of the extraction is the first element of the <code>replies</code> list and consists of a JSON string.",ze,pt,jl=`We would like to have a dictionary for each source document.
To perform this transformation in a pipeline, we can use the <a href="https://docs.haystack.deepset.ai/docs/outputadapter?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow"><code>OutputAdapter</code></a>.`,Ye,Ut,Ee,rt,Oe,Mt,$e,yt,dl='We can now <a href="https://docs.haystack.deepset.ai/docs/creating-pipelines?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">create our Pipeline</a> by adding and connecting the individual components.',_e,ut,tA,Ft,eA,ct,fl="Let’s review our pipeline setup:",AA,wt,lA,_t,ml,oA,jt,aA,dt,Rl="We select a list of URLs related to recent startup funding announcements.",iA,ft,Kl="Additionally, we define a schema for the structured information we aim to extract.",nA,mt,sA,Rt,pA,Kt,Jl="We pass the required data to each component.",UA,Jt,bl="Note that most of them receive data from previously executed components.",rA,bt,MA,Tt,Tl="Let’s inspect some of the extracted data",yA,ht,uA,Bt,FA,gt,hl="Let’s explore the extracted data to assess its correctness and gain insights.",cA,vt,wA,Ct,Bl="We start by creating a Pandas Dataframe. For simplicity, we flatten the extracted data.",jA,Gt,dA,kt,fA,Wt,mA,Pt,gl="Apart from some errors in “Company - Country”, the extracted data looks good.",RA,It,KA,Ht,vl="To understand the relationships between companies and investors, we construct a graph and visualize it.",JA,Qt,Cl="First, we build a graph using NetworkX.",bA,Xt,Gl='<a href="https://networkx.org/" rel="nofollow">NetworkX</a> is a Python package that allows to create and manipulate networks/graphs in a simple way.',TA,xt,kl="Our simple graph will have companies and investors as nodes. We will connect investors to companies if they are mentioned in the same document.",hA,St,BA,qt,Wl="Next, we use Pyvis to visualize the graph.",gA,Nt,Pl='<a href="https://pyvis.readthedocs.io/en/latest/" rel="nofollow">Pyvis</a> is a Python package for interactive visualization of networks/graphs. It integrates nicely with NetworkX.',vA,Zt,CA,Dt,Il=`simple_graph.html
`,GA,Vt,Hl="Looks like Andreessen Horowitz is quite present in the selected funding announcements 😊",kA,Lt,WA,zt,Ql="In this notebook, we demonstrated how to set up an information extraction system using a small language model (NuExtract) and Haystack, a customizable orchestration framework for LLM applications.",PA,Yt,Xl="How can we use the extracted data?",IA,Et,xl="Some ideas:",HA,Ot,Sl='<li>The extracted data can be added to the original documents stored in a <a href="https://docs.haystack.deepset.ai/docs/document-store?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">Document Store</a>. This allows for advanced search capabilities with <a href="https://docs.haystack.deepset.ai/docs/metadata-filtering?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">metadata filtering</a>.</li> <li>Expanding on the previous idea, you can do RAG (Retrieval Agumented Extraction) with metadata extraction from the query, as explained in <a href="https://haystack.deepset.ai/blog/extracting-metadata-filter?utm_campaign=developer-relations&amp;utm_source=hf-cookbook" rel="nofollow">this blog post</a>.</li> <li>Store the documents and extracted data in a Knowledge Graph and perform Graph RAG (<a href="https://prosto.github.io/neo4j-haystack" rel="nofollow">Neo4j-Haystack integration</a>).</li>',QA,$t,XA,ee,xA;return j=new Ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/information_extraction_haystack_nuextract.ipynb"}]}}),d=new c({props:{title:"Information Extraction with Haystack and NuExtract",local:"information-extraction-with-haystack-and-nuextract",headingTag:"h1"}}),b=new c({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),T=new F({props:{code:"ISUyMHBpcCUyMGluc3RhbGwlMjBoYXlzdGFjay1haSUyMHRyYWZpbGF0dXJhJTIwdHJhbnNmb3JtZXJzJTIwcHl2aXM=",highlighted:"! pip install haystack-ai trafilatura transformers pyvis",wrap:!1}}),h=new c({props:{title:"Components",local:"components",headingTag:"h2"}}),G=new c({props:{title:"LinkContentFetcher and HTMLToDocument : extract text from web pages",local:"linkcontentfetcher-and-htmltodocument--extract-text-from-web-pages",headingTag:"h3"}}),I=new F({props:{code:"ZnJvbSUyMGhheXN0YWNrLmNvbXBvbmVudHMuZmV0Y2hlcnMlMjBpbXBvcnQlMjBMaW5rQ29udGVudEZldGNoZXIlMEFmcm9tJTIwaGF5c3RhY2suY29tcG9uZW50cy5jb252ZXJ0ZXJzJTIwaW1wb3J0JTIwSFRNTFRvRG9jdW1lbnQlMEElMEElMEFmZXRjaGVyJTIwJTNEJTIwTGlua0NvbnRlbnRGZXRjaGVyKCklMEElMEFzdHJlYW1zJTIwJTNEJTIwZmV0Y2hlci5ydW4odXJscyUzRCU1QiUyMmh0dHBzJTNBJTJGJTJGZXhhbXBsZS5jb20lMkYlMjIlNUQpJTVCJTIyc3RyZWFtcyUyMiU1RCUwQSUwQWNvbnZlcnRlciUyMCUzRCUyMEhUTUxUb0RvY3VtZW50KCklMEFkb2NzJTIwJTNEJTIwY29udmVydGVyLnJ1bihzb3VyY2VzJTNEc3RyZWFtcyklMEElMEFwcmludChkb2NzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> haystack.components.fetchers <span class="hljs-keyword">import</span> LinkContentFetcher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> haystack.components.converters <span class="hljs-keyword">import</span> HTMLToDocument


<span class="hljs-meta">&gt;&gt;&gt; </span>fetcher = LinkContentFetcher()

<span class="hljs-meta">&gt;&gt;&gt; </span>streams = fetcher.run(urls=[<span class="hljs-string">&quot;https://example.com/&quot;</span>])[<span class="hljs-string">&quot;streams&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>converter = HTMLToDocument()
<span class="hljs-meta">&gt;&gt;&gt; </span>docs = converter.run(sources=streams)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(docs)`,wrap:!1}}),Q=new c({props:{title:"HuggingFaceLocalGenerator : load and try the model",local:"huggingfacelocalgenerator--load-and-try-the-model",headingTag:"h3"}}),N=new c({props:{title:"Notes on Flash Attention",local:"notes-on-flash-attention",headingTag:"h4"}}),L=new F({props:{code:"cGlwJTIwaW5zdGFsbCUyMGZsYXNoLWF0dG4lMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:"pip install flash-attn --no-build-isolation",wrap:!1}}),Y=new F({props:{code:"ZnJvbSUyMGhheXN0YWNrLmNvbXBvbmVudHMuZ2VuZXJhdG9ycyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTG9jYWxHZW5lcmF0b3IlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlTG9jYWxHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJudW1pbmQlMkZOdUV4dHJhY3QlMjIlMkMlMjBodWdnaW5nZmFjZV9waXBlbGluZV9rd2FyZ3MlM0QlN0IlMjJtb2RlbF9rd2FyZ3MlMjIlM0ElMjAlN0IlMjJ0b3JjaF9kdHlwZSUyMiUzQSUyMHRvcmNoLmJmbG9hdDE2JTdEJTdEJTBBKSUwQSUwQSUyMyUyMGVmZmVjdGl2ZWx5JTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwKHdhcm1fdXAlMjBpcyUyMGF1dG9tYXRpY2FsbHklMjBpbnZva2VkJTIwd2hlbiUyMHRoZSUyMGdlbmVyYXRvciUyMGlzJTIwcGFydCUyMG9mJTIwYSUyMFBpcGVsaW5lKSUwQWdlbmVyYXRvci53YXJtX3VwKCk=",highlighted:`<span class="hljs-keyword">from</span> haystack.components.generators <span class="hljs-keyword">import</span> HuggingFaceLocalGenerator
<span class="hljs-keyword">import</span> torch

generator = HuggingFaceLocalGenerator(
    model=<span class="hljs-string">&quot;numind/NuExtract&quot;</span>, huggingface_pipeline_kwargs={<span class="hljs-string">&quot;model_kwargs&quot;</span>: {<span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16}}
)

<span class="hljs-comment"># effectively load the model (warm_up is automatically invoked when the generator is part of a Pipeline)</span>
generator.warm_up()`,wrap:!1}}),$=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> rich <span class="hljs-keyword">import</span> <span class="hljs-built_in">print</span>

prompt = <span class="hljs-string">&quot;&quot;&quot;&lt;|input|&gt;\\n### Template:
{
    &quot;Car&quot;: {
        &quot;Name&quot;: &quot;&quot;,
        &quot;Manufacturer&quot;: &quot;&quot;,
        &quot;Designers&quot;: [],
        &quot;Number of units produced&quot;: &quot;&quot;,
    }
}
### Text:
The Fiat Panda is a city car manufactured and marketed by Fiat since 1980, currently in its third generation. The first generation Panda, introduced in 1980, was a two-box, three-door hatchback designed by Giorgetto Giugiaro and Aldo Mantovani of Italdesign and was manufactured through 2003 — receiving an all-wheel drive variant in 1983. SEAT of Spain marketed a variation of the first generation Panda under license to Fiat, initially as the Panda and subsequently as the Marbella (1986–1998).

The second-generation Panda, launched in 2003 as a 5-door hatchback, was designed by Giuliano Biasio of Bertone, and won the European Car of the Year in 2004. The third-generation Panda debuted at the Frankfurt Motor Show in September 2011, was designed at Fiat Centro Stilo under the direction of Roberto Giolito and remains in production in Italy at Pomigliano d&#x27;Arco.[1] The fourth-generation Panda is marketed as Grande Panda, to differentiate it with the third-generation that is sold alongside it. Developed under Stellantis, the Grande Panda is produced in Serbia.

In 40 years, Panda production has reached over 7.8 million,[2] of those, approximately 4.5 million were the first generation.[3] In early 2020, its 23-year production was counted as the twenty-ninth most long-lived single generation car in history by Autocar.[4] During its initial design phase, Italdesign referred to the car as il Zero. Fiat later proposed the name Rustica. Ultimately, the Panda was named after Empanda, the Roman goddess and patroness of travelers.
&lt;|output|&gt;
&quot;&quot;&quot;</span>

result = generator.run(prompt=prompt)
<span class="hljs-built_in">print</span>(result)`,wrap:!1}}),tt=new c({props:{title:"PromptBuilder : dynamically create prompts",local:"promptbuilder--dynamically-create-prompts",headingTag:"h3"}}),ot=new F({props:{code:"ZnJvbSUyMGhheXN0YWNrLmNvbXBvbmVudHMuYnVpbGRlcnMlMjBpbXBvcnQlMjBQcm9tcHRCdWlsZGVyJTBBZnJvbSUyMGhheXN0YWNrJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEFwcm9tcHRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjIlMjIlM0MlN0NpbnB1dCU3QyUzRSUwQSUyMyUyMyUyMyUyMFRlbXBsYXRlJTNBJTBBJTdCJTdCJTIwc2NoZW1hJTIwJTdDJTIwdG9qc29uKGluZGVudCUzRDQpJTIwJTdEJTdEJTBBJTdCJTI1JTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlMjAlMjUlN0QlMEElMjMlMjMlMjMlMjBFeGFtcGxlJTNBJTBBJTdCJTdCJTIwZXhhbXBsZSUyMCU3QyUyMHRvanNvbihpbmRlbnQlM0Q0KSUyMCU3RCU3RCU1Q24lMEElN0IlMjUlMjBlbmRmb3IlMjAlMjUlN0QlMEElMjMlMjMlMjMlMjBUZXh0JTBBJTdCJTdCZG9jdW1lbnRzJTVCMCU1RC5jb250ZW50JTdEJTdEJTBBJTNDJTdDb3V0cHV0JTdDJTNFJTBBJTIyJTIyJTIyJTBBJTBBcHJvbXB0X2J1aWxkZXIlMjAlM0QlMjBQcm9tcHRCdWlsZGVyKHRlbXBsYXRlJTNEcHJvbXB0X3RlbXBsYXRlKQ==",highlighted:`<span class="hljs-keyword">from</span> haystack.components.builders <span class="hljs-keyword">import</span> PromptBuilder
<span class="hljs-keyword">from</span> haystack <span class="hljs-keyword">import</span> Document

prompt_template = <span class="hljs-string">&quot;&quot;&quot;&lt;|input|&gt;
### Template:
{{ schema | tojson(indent=4) }}
{% for example in examples %}
### Example:
{{ example | tojson(indent=4) }}\\n
{% endfor %}
### Text
{{documents[0].content}}
&lt;|output|&gt;
&quot;&quot;&quot;</span>

prompt_builder = PromptBuilder(template=prompt_template)`,wrap:!1}}),at=new F({props:{code:"ZXhhbXBsZV9kb2N1bWVudCUyMCUzRCUyMERvY3VtZW50KGNvbnRlbnQlM0QlMjJUaGUlMjBGaWF0JTIwUGFuZGElMjBpcyUyMGElMjBjaXR5JTIwY2FyLi4uJTIyKSUwQSUwQWV4YW1wbGVfc2NoZW1hJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQ2FyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTmFtZSUyMiUzQSUyMCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1hbnVmYWN0dXJlciUyMiUzQSUyMCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2lnbmVycyUyMiUzQSUyMCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwdW5pdHMlMjBwcm9kdWNlZCUyMiUzQSUyMCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQSUwQXByb21wdCUyMCUzRCUyMHByb21wdF9idWlsZGVyLnJ1bihkb2N1bWVudHMlM0QlNUJleGFtcGxlX2RvY3VtZW50JTVEJTJDJTIwc2NoZW1hJTNEZXhhbXBsZV9zY2hlbWEpJTVCJTIycHJvbXB0JTIyJTVEJTBBJTBBcHJpbnQocHJvbXB0KQ==",highlighted:`example_document = Document(content=<span class="hljs-string">&quot;The Fiat Panda is a city car...&quot;</span>)

example_schema = {
    <span class="hljs-string">&quot;Car&quot;</span>: {
        <span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
        <span class="hljs-string">&quot;Manufacturer&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
        <span class="hljs-string">&quot;Designers&quot;</span>: [],
        <span class="hljs-string">&quot;Number of units produced&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
    }
}

prompt = prompt_builder.run(documents=[example_document], schema=example_schema)[<span class="hljs-string">&quot;prompt&quot;</span>]

<span class="hljs-built_in">print</span>(prompt)`,wrap:!1}}),nt=new c({props:{title:"OutputAdapter",local:"outputadapter",headingTag:"h3"}}),Ut=new F({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBoYXlzdGFjay5jb21wb25lbnRzLmNvbnZlcnRlcnMlMjBpbXBvcnQlMjBPdXRwdXRBZGFwdGVyJTBBJTBBJTBBYWRhcHRlciUyMCUzRCUyME91dHB1dEFkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0QlMjIlMjIlMjIlN0IlN0IlMjByZXBsaWVzJTVCMCU1RCU3QyUyMHJlcGxhY2UoJTIyJyUyMiUyQyclMjInKSUyMCU3QyUyMGpzb25fbG9hZHMlN0QlN0QlMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRGRpY3QlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fZmlsdGVycyUzRCU3QiUyMmpzb25fbG9hZHMlMjIlM0ElMjBqc29uLmxvYWRzJTdEJTJDJTBBKSUwQSUwQXByaW50KGFkYXB0ZXIucnVuKCoqcmVzdWx0KSk=",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> haystack.components.converters <span class="hljs-keyword">import</span> OutputAdapter


adapter = OutputAdapter(
    template=<span class="hljs-string">&quot;&quot;&quot;{{ replies[0]| replace(&quot;&#x27;&quot;,&#x27;&quot;&#x27;) | json_loads}}&quot;&quot;&quot;</span>,
    output_type=<span class="hljs-built_in">dict</span>,
    custom_filters={<span class="hljs-string">&quot;json_loads&quot;</span>: json.loads},
)

<span class="hljs-built_in">print</span>(adapter.run(**result))`,wrap:!1}}),rt=new c({props:{title:"Information Extraction Pipeline",local:"information-extraction-pipeline",headingTag:"h2"}}),Mt=new c({props:{title:"Build the Pipeline",local:"build-the-pipeline",headingTag:"h3"}}),ut=new F({props:{code:"ZnJvbSUyMGhheXN0YWNrJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEElMEFpZV9waXBlJTIwJTNEJTIwUGlwZWxpbmUoKSUwQWllX3BpcGUuYWRkX2NvbXBvbmVudCglMjJmZXRjaGVyJTIyJTJDJTIwZmV0Y2hlciklMEFpZV9waXBlLmFkZF9jb21wb25lbnQoJTIyY29udmVydGVyJTIyJTJDJTIwY29udmVydGVyKSUwQWllX3BpcGUuYWRkX2NvbXBvbmVudCglMjJwcm9tcHRfYnVpbGRlciUyMiUyQyUyMHByb21wdF9idWlsZGVyKSUwQWllX3BpcGUuYWRkX2NvbXBvbmVudCglMjJnZW5lcmF0b3IlMjIlMkMlMjBnZW5lcmF0b3IpJTBBaWVfcGlwZS5hZGRfY29tcG9uZW50KCUyMmFkYXB0ZXIlMjIlMkMlMjBhZGFwdGVyKSUwQSUwQWllX3BpcGUuY29ubmVjdCglMjJmZXRjaGVyJTIyJTJDJTIwJTIyY29udmVydGVyJTIyKSUwQWllX3BpcGUuY29ubmVjdCglMjJjb252ZXJ0ZXIlMjIlMkMlMjAlMjJwcm9tcHRfYnVpbGRlciUyMiklMEFpZV9waXBlLmNvbm5lY3QoJTIycHJvbXB0X2J1aWxkZXIlMjIlMkMlMjAlMjJnZW5lcmF0b3IlMjIpJTBBaWVfcGlwZS5jb25uZWN0KCUyMmdlbmVyYXRvciUyMiUyQyUyMCUyMmFkYXB0ZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> haystack <span class="hljs-keyword">import</span> Pipeline

ie_pipe = Pipeline()
ie_pipe.add_component(<span class="hljs-string">&quot;fetcher&quot;</span>, fetcher)
ie_pipe.add_component(<span class="hljs-string">&quot;converter&quot;</span>, converter)
ie_pipe.add_component(<span class="hljs-string">&quot;prompt_builder&quot;</span>, prompt_builder)
ie_pipe.add_component(<span class="hljs-string">&quot;generator&quot;</span>, generator)
ie_pipe.add_component(<span class="hljs-string">&quot;adapter&quot;</span>, adapter)

ie_pipe.connect(<span class="hljs-string">&quot;fetcher&quot;</span>, <span class="hljs-string">&quot;converter&quot;</span>)
ie_pipe.connect(<span class="hljs-string">&quot;converter&quot;</span>, <span class="hljs-string">&quot;prompt_builder&quot;</span>)
ie_pipe.connect(<span class="hljs-string">&quot;prompt_builder&quot;</span>, <span class="hljs-string">&quot;generator&quot;</span>)
ie_pipe.connect(<span class="hljs-string">&quot;generator&quot;</span>, <span class="hljs-string">&quot;adapter&quot;</span>)`,wrap:!1}}),Ft=new F({props:{code:"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",highlighted:`<span class="hljs-comment"># IN CASE YOU NEED TO RECREATE THE PIPELINE FROM SCRATCH, YOU CAN UNCOMMENT THIS CELL</span>

<span class="hljs-comment"># ie_pipe = Pipeline()</span>
<span class="hljs-comment"># ie_pipe.add_component(&quot;fetcher&quot;, LinkContentFetcher())</span>
<span class="hljs-comment"># ie_pipe.add_component(&quot;converter&quot;, HTMLToDocument())</span>
<span class="hljs-comment"># ie_pipe.add_component(&quot;prompt_builder&quot;, PromptBuilder(template=prompt_template))</span>
<span class="hljs-comment"># ie_pipe.add_component(&quot;generator&quot;, HuggingFaceLocalGenerator(model=&quot;numind/NuExtract&quot;,</span>
<span class="hljs-comment">#                                       huggingface_pipeline_kwargs={&quot;model_kwargs&quot;: {&quot;torch_dtype&quot;:torch.bfloat16}})</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># ie_pipe.add_component(&quot;adapter&quot;, OutputAdapter(template=&quot;&quot;&quot;{{ replies[0]| replace(&quot;&#x27;&quot;,&#x27;&quot;&#x27;) | json_loads}}&quot;&quot;&quot;,</span>
<span class="hljs-comment">#                                          output_type=dict,</span>
<span class="hljs-comment">#                                          custom_filters={&quot;json_loads&quot;: json.loads}))</span>

<span class="hljs-comment"># ie_pipe.connect(&quot;fetcher&quot;, &quot;converter&quot;)</span>
<span class="hljs-comment"># ie_pipe.connect(&quot;converter&quot;, &quot;prompt_builder&quot;)</span>
<span class="hljs-comment"># ie_pipe.connect(&quot;prompt_builder&quot;, &quot;generator&quot;)</span>
<span class="hljs-comment"># ie_pipe.connect(&quot;generator&quot;, &quot;adapter&quot;)</span>`,wrap:!1}}),wt=new F({props:{code:"aWVfcGlwZS5zaG93KCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ie_pipe.show()',wrap:!1}}),jt=new c({props:{title:"Define the sources and the extraction schema",local:"define-the-sources-and-the-extraction-schema",headingTag:"h3"}}),mt=new F({props:{code:"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",highlighted:`urls = [
    <span class="hljs-string">&quot;https://techcrunch.com/2023/04/27/pinecone-drops-100m-investment-on-750m-valuation-as-vector-database-demand-grows/&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2023/04/27/replit-funding-100m-generative-ai/&quot;</span>,
    <span class="hljs-string">&quot;https://www.cnbc.com/2024/06/12/mistral-ai-raises-645-million-at-a-6-billion-valuation.html&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2024/01/23/qdrant-open-source-vector-database/&quot;</span>,
    <span class="hljs-string">&quot;https://www.intelcapital.com/anyscale-secures-100m-series-c-at-1b-valuation-to-radically-simplify-scaling-and-productionizing-ai-applications/&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2023/04/28/openai-funding-valuation-chatgpt/&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2024/03/27/amazon-doubles-down-on-anthropic-completing-its-planned-4b-investment/&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2024/01/22/voice-cloning-startup-elevenlabs-lands-80m-achieves-unicorn-status/&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2023/08/24/hugging-face-raises-235m-from-investors-including-salesforce-and-nvidia&quot;</span>,
    <span class="hljs-string">&quot;https://www.prnewswire.com/news-releases/ai21-completes-208-million-oversubscribed-series-c-round-301994393.html&quot;</span>,
    <span class="hljs-string">&quot;https://techcrunch.com/2023/03/15/adept-a-startup-training-ai-to-use-existing-software-and-apis-raises-350m/&quot;</span>,
    <span class="hljs-string">&quot;https://www.cnbc.com/2023/03/23/characterai-valued-at-1-billion-after-150-million-round-from-a16z.html&quot;</span>,
]


schema = {
    <span class="hljs-string">&quot;Funding&quot;</span>: {
        <span class="hljs-string">&quot;New funding&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
        <span class="hljs-string">&quot;Investors&quot;</span>: [],
    },
    <span class="hljs-string">&quot;Company&quot;</span>: {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;Activity&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;Country&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;Total valuation&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;Total funding&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
}`,wrap:!1}}),Rt=new c({props:{title:"Run the Pipeline!",local:"run-the-pipeline",headingTag:"h3"}}),bt=new F({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZXh0cmFjdGVkX2RhdGElMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB1cmwlMjBpbiUyMHRxZG0odXJscyklM0ElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBpZV9waXBlLnJ1biglN0IlMjJmZXRjaGVyJTIyJTNBJTIwJTdCJTIydXJscyUyMiUzQSUyMCU1QnVybCU1RCU3RCUyQyUyMCUyMnByb21wdF9idWlsZGVyJTIyJTNBJTIwJTdCJTIyc2NoZW1hJTIyJTNBJTIwc2NoZW1hJTdEJTdEKSUwQSUwQSUyMCUyMCUyMCUyMGV4dHJhY3RlZF9kYXRhLmFwcGVuZChyZXN1bHQlNUIlMjJhZGFwdGVyJTIyJTVEJTVCJTIyb3V0cHV0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

extracted_data = []

<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> tqdm(urls):
    result = ie_pipe.run({<span class="hljs-string">&quot;fetcher&quot;</span>: {<span class="hljs-string">&quot;urls&quot;</span>: [url]}, <span class="hljs-string">&quot;prompt_builder&quot;</span>: {<span class="hljs-string">&quot;schema&quot;</span>: schema}})

    extracted_data.append(result[<span class="hljs-string">&quot;adapter&quot;</span>][<span class="hljs-string">&quot;output&quot;</span>])`,wrap:!1}}),ht=new F({props:{code:"ZXh0cmFjdGVkX2RhdGElNUIlM0EyJTVE",highlighted:'extracted_data[:<span class="hljs-number">2</span>]',wrap:!1}}),Bt=new c({props:{title:"Data exploration and visualization",local:"data-exploration-and-visualization",headingTag:"h2"}}),vt=new c({props:{title:"Dataframe",local:"dataframe",headingTag:"h3"}}),Gt=new F({props:{code:"ZGVmJTIwZmxhdHRlbl9kaWN0KGQlMkMlMjBwYXJlbnRfa2V5JTNEJTIyJTIyKSUzQSUwQSUyMCUyMCUyMCUyMGl0ZW1zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGQuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5ld19rZXklMjAlM0QlMjBmJTIyJTdCcGFyZW50X2tleSU3RCUyMC0lMjAlN0JrJTdEJTIyJTIwaWYlMjBwYXJlbnRfa2V5JTIwZWxzZSUyMGslMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2UodiUyQyUyMGRpY3QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaXRlbXMuZXh0ZW5kKGZsYXR0ZW5fZGljdCh2JTJDJTIwbmV3X2tleSkuaXRlbXMoKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZSh2JTJDJTIwbGlzdCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpdGVtcy5hcHBlbmQoKG5ld19rZXklMkMlMjAlMjIlMkMlMjAlMjIuam9pbih2KSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGl0ZW1zLmFwcGVuZCgobmV3X2tleSUyQyUyMHYpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGRpY3QoaXRlbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">flatten_dict</span>(<span class="hljs-params">d, parent_key=<span class="hljs-string">&quot;&quot;</span></span>):
    items = []
    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> d.items():
        new_key = <span class="hljs-string">f&quot;<span class="hljs-subst">{parent_key}</span> - <span class="hljs-subst">{k}</span>&quot;</span> <span class="hljs-keyword">if</span> parent_key <span class="hljs-keyword">else</span> k
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(v, <span class="hljs-built_in">dict</span>):
            items.extend(flatten_dict(v, new_key).items())
        <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(v, <span class="hljs-built_in">list</span>):
            items.append((new_key, <span class="hljs-string">&quot;, &quot;</span>.join(v)))
        <span class="hljs-keyword">else</span>:
            items.append((new_key, v))
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">dict</span>(items)`,wrap:!1}}),kt=new F({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKCU1QmZsYXR0ZW5fZGljdChlbCklMjBmb3IlMjBlbCUyMGluJTIwZXh0cmFjdGVkX2RhdGElNUQpJTBBZGYlMjAlM0QlMjBkZi5zb3J0X3ZhbHVlcyhieSUzRCUyMkNvbXBhbnklMjAtJTIwTmFtZSUyMik=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame([flatten_dict(el) <span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> extracted_data])
df = df.sort_values(by=<span class="hljs-string">&quot;Company - Name&quot;</span>)`,wrap:!1}}),Wt=new F({props:{code:"ZGY=",highlighted:"df",wrap:!1}}),It=new c({props:{title:"Build a simple graph",local:"build-a-simple-graph",headingTag:"h3"}}),St=new F({props:{code:"aW1wb3J0JTIwbmV0d29ya3glMjBhcyUyMG54JTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMG5ldyUyMGdyYXBoJTBBRyUyMCUzRCUyMG54LkdyYXBoKCklMEElMEElMjMlMjBBZGQlMjBub2RlcyUyMGFuZCUyMGVkZ2VzJTBBZm9yJTIwZWwlMjBpbiUyMGV4dHJhY3RlZF9kYXRhJTNBJTBBJTIwJTIwJTIwJTIwY29tcGFueV9uYW1lJTIwJTNEJTIwZWwlNUIlMjJDb21wYW55JTIyJTVEJTVCJTIyTmFtZSUyMiU1RCUwQSUyMCUyMCUyMCUyMEcuYWRkX25vZGUoY29tcGFueV9uYW1lJTJDJTIwbGFiZWwlM0Rjb21wYW55X25hbWUlMkMlMjB0aXRsZSUzRCUyMkNvbXBhbnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwaW52ZXN0b3JzJTIwJTNEJTIwZWwlNUIlMjJGdW5kaW5nJTIyJTVEJTVCJTIySW52ZXN0b3JzJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW52ZXN0b3IlMjBpbiUyMGludmVzdG9ycyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwRy5oYXNfbm9kZShpbnZlc3RvciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBHLmFkZF9ub2RlKGludmVzdG9yJTJDJTIwbGFiZWwlM0RpbnZlc3RvciUyQyUyMHRpdGxlJTNEJTIySW52ZXN0b3IlMjIlMkMlMjBjb2xvciUzRCUyMnJlZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBHLmFkZF9lZGdlKGNvbXBhbnlfbmFtZSUyQyUyMGludmVzdG9yKQ==",highlighted:`<span class="hljs-keyword">import</span> networkx <span class="hljs-keyword">as</span> nx

<span class="hljs-comment"># Create a new graph</span>
G = nx.Graph()

<span class="hljs-comment"># Add nodes and edges</span>
<span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> extracted_data:
    company_name = el[<span class="hljs-string">&quot;Company&quot;</span>][<span class="hljs-string">&quot;Name&quot;</span>]
    G.add_node(company_name, label=company_name, title=<span class="hljs-string">&quot;Company&quot;</span>)

    investors = el[<span class="hljs-string">&quot;Funding&quot;</span>][<span class="hljs-string">&quot;Investors&quot;</span>]
    <span class="hljs-keyword">for</span> investor <span class="hljs-keyword">in</span> investors:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> G.has_node(investor):
            G.add_node(investor, label=investor, title=<span class="hljs-string">&quot;Investor&quot;</span>, color=<span class="hljs-string">&quot;red&quot;</span>)
        G.add_edge(company_name, investor)`,wrap:!1}}),Zt=new F({props:{code:"ZnJvbSUyMHB5dmlzLm5ldHdvcmslMjBpbXBvcnQlMjBOZXR3b3JrJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMGRpc3BsYXklMkMlMjBIVE1MJTBBJTBBJTBBbmV0JTIwJTNEJTIwTmV0d29yayhub3RlYm9vayUzRFRydWUlMkMlMjBjZG5fcmVzb3VyY2VzJTNEJTIyaW5fbGluZSUyMiklMEFuZXQuZnJvbV9ueChHKSUwQSUwQW5ldC5zaG93KCUyMnNpbXBsZV9ncmFwaC5odG1sJTIyKSUwQWRpc3BsYXkoSFRNTCglMjJzaW1wbGVfZ3JhcGguaHRtbCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pyvis.network <span class="hljs-keyword">import</span> Network
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display, HTML


<span class="hljs-meta">&gt;&gt;&gt; </span>net = Network(notebook=<span class="hljs-literal">True</span>, cdn_resources=<span class="hljs-string">&quot;in_line&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>net.from_nx(G)

<span class="hljs-meta">&gt;&gt;&gt; </span>net.show(<span class="hljs-string">&quot;simple_graph.html&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(HTML(<span class="hljs-string">&quot;simple_graph.html&quot;</span>))`,wrap:!1}}),Lt=new c({props:{title:"Conclusion and ideas",local:"conclusion-and-ideas",headingTag:"h2"}}),$t=new $l({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/information_extraction_haystack_nuextract.md"}}),{c(){w=i("meta"),Ae=o(),te=i("p"),le=o(),p(j.$$.fragment),oe=o(),p(d.$$.fragment),ae=o(),f=i("p"),f.innerHTML=NA,ie=o(),m=i("p"),m.textContent=ZA,ne=o(),R=i("p"),R.textContent=DA,se=o(),K=i("p"),K.innerHTML=VA,pe=o(),J=i("ul"),J.innerHTML=LA,Ue=o(),p(b.$$.fragment),re=o(),p(T.$$.fragment),Me=o(),p(h.$$.fragment),ye=o(),B=i("p"),B.innerHTML=zA,ue=o(),g=i("p"),g.innerHTML=YA,Fe=o(),v=i("p"),v.innerHTML=EA,ce=o(),C=i("p"),C.innerHTML=OA,we=o(),p(G.$$.fragment),je=o(),k=i("p"),k.textContent=$A,de=o(),W=i("p"),W.textContent=_A,fe=o(),P=i("ul"),P.innerHTML=tl,me=o(),p(I.$$.fragment),Re=o(),H=i("pre"),H.textContent=el,Ke=o(),p(Q.$$.fragment),Je=o(),X=i("p"),X.innerHTML=Al,be=o(),x=i("p"),x.innerHTML=ll,Te=o(),S=i("p"),S.innerHTML=ol,he=o(),q=i("p"),q.innerHTML=al,Be=o(),p(N.$$.fragment),ge=o(),Z=i("p"),Z.textContent=il,ve=o(),D=i("p"),D.textContent=nl,Ce=o(),V=i("p"),V.innerHTML=sl,Ge=o(),p(L.$$.fragment),ke=o(),z=i("p"),z.innerHTML=pl,We=o(),p(Y.$$.fragment),Pe=o(),E=i("p"),E.textContent=Ul,Ie=o(),O=i("p"),O.textContent=rl,He=o(),p($.$$.fragment),Qe=o(),_=i("p"),_.textContent=Ml,Xe=o(),p(tt.$$.fragment),xe=o(),et=i("p"),et.innerHTML=yl,Se=o(),At=i("p"),At.innerHTML=ul,qe=o(),lt=i("p"),lt.textContent=Fl,Ne=o(),p(ot.$$.fragment),Ze=o(),p(at.$$.fragment),De=o(),it=i("p"),it.textContent=cl,Ve=o(),p(nt.$$.fragment),Le=o(),st=i("p"),st.innerHTML=wl,ze=o(),pt=i("p"),pt.innerHTML=jl,Ye=o(),p(Ut.$$.fragment),Ee=o(),p(rt.$$.fragment),Oe=o(),p(Mt.$$.fragment),$e=o(),yt=i("p"),yt.innerHTML=dl,_e=o(),p(ut.$$.fragment),tA=o(),p(Ft.$$.fragment),eA=o(),ct=i("p"),ct.textContent=fl,AA=o(),p(wt.$$.fragment),lA=o(),_t=i("img"),oA=o(),p(jt.$$.fragment),aA=o(),dt=i("p"),dt.textContent=Rl,iA=o(),ft=i("p"),ft.textContent=Kl,nA=o(),p(mt.$$.fragment),sA=o(),p(Rt.$$.fragment),pA=o(),Kt=i("p"),Kt.textContent=Jl,UA=o(),Jt=i("p"),Jt.textContent=bl,rA=o(),p(bt.$$.fragment),MA=o(),Tt=i("p"),Tt.textContent=Tl,yA=o(),p(ht.$$.fragment),uA=o(),p(Bt.$$.fragment),FA=o(),gt=i("p"),gt.textContent=hl,cA=o(),p(vt.$$.fragment),wA=o(),Ct=i("p"),Ct.textContent=Bl,jA=o(),p(Gt.$$.fragment),dA=o(),p(kt.$$.fragment),fA=o(),p(Wt.$$.fragment),mA=o(),Pt=i("p"),Pt.textContent=gl,RA=o(),p(It.$$.fragment),KA=o(),Ht=i("p"),Ht.textContent=vl,JA=o(),Qt=i("p"),Qt.textContent=Cl,bA=o(),Xt=i("p"),Xt.innerHTML=Gl,TA=o(),xt=i("p"),xt.textContent=kl,hA=o(),p(St.$$.fragment),BA=o(),qt=i("p"),qt.textContent=Wl,gA=o(),Nt=i("p"),Nt.innerHTML=Pl,vA=o(),p(Zt.$$.fragment),CA=o(),Dt=i("pre"),Dt.textContent=Il,GA=o(),Vt=i("p"),Vt.textContent=Hl,kA=o(),p(Lt.$$.fragment),WA=o(),zt=i("p"),zt.textContent=Ql,PA=o(),Yt=i("p"),Yt.textContent=Xl,IA=o(),Et=i("p"),Et.textContent=xl,HA=o(),Ot=i("ul"),Ot.innerHTML=Sl,QA=o(),p($t.$$.fragment),XA=o(),ee=i("p"),this.h()},l(t){const e=Yl("svelte-u9bgzb",document.head);w=n(e,"META",{name:!0,content:!0}),e.forEach(A),Ae=a(t),te=n(t,"P",{}),ql(te).forEach(A),le=a(t),U(j.$$.fragment,t),oe=a(t),U(d.$$.fragment,t),ae=a(t),f=n(t,"P",{"data-svelte-h":!0}),s(f)!=="svelte-rkb7ro"&&(f.innerHTML=NA),ie=a(t),m=n(t,"P",{"data-svelte-h":!0}),s(m)!=="svelte-104h6o6"&&(m.textContent=ZA),ne=a(t),R=n(t,"P",{"data-svelte-h":!0}),s(R)!=="svelte-oe15xo"&&(R.textContent=DA),se=a(t),K=n(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-6mdv8h"&&(K.innerHTML=VA),pe=a(t),J=n(t,"UL",{"data-svelte-h":!0}),s(J)!=="svelte-17btve3"&&(J.innerHTML=LA),Ue=a(t),U(b.$$.fragment,t),re=a(t),U(T.$$.fragment,t),Me=a(t),U(h.$$.fragment,t),ye=a(t),B=n(t,"P",{"data-svelte-h":!0}),s(B)!=="svelte-1vopozu"&&(B.innerHTML=zA),ue=a(t),g=n(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-gdgnsl"&&(g.innerHTML=YA),Fe=a(t),v=n(t,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1xpf1o9"&&(v.innerHTML=EA),ce=a(t),C=n(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-8ewd03"&&(C.innerHTML=OA),we=a(t),U(G.$$.fragment,t),je=a(t),k=n(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1uowp1d"&&(k.textContent=$A),de=a(t),W=n(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1vdo8il"&&(W.textContent=_A),fe=a(t),P=n(t,"UL",{"data-svelte-h":!0}),s(P)!=="svelte-1s9hsvv"&&(P.innerHTML=tl),me=a(t),U(I.$$.fragment,t),Re=a(t),H=n(t,"PRE",{"data-svelte-h":!0}),s(H)!=="svelte-k03ckz"&&(H.textContent=el),Ke=a(t),U(Q.$$.fragment,t),Je=a(t),X=n(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-1i3hvwr"&&(X.innerHTML=Al),be=a(t),x=n(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-reuftc"&&(x.innerHTML=ll),Te=a(t),S=n(t,"P",{"data-svelte-h":!0}),s(S)!=="svelte-31med3"&&(S.innerHTML=ol),he=a(t),q=n(t,"P",{"data-svelte-h":!0}),s(q)!=="svelte-omf6q3"&&(q.innerHTML=al),Be=a(t),U(N.$$.fragment,t),ge=a(t),Z=n(t,"P",{"data-svelte-h":!0}),s(Z)!=="svelte-14yr3cm"&&(Z.textContent=il),ve=a(t),D=n(t,"P",{"data-svelte-h":!0}),s(D)!=="svelte-16u8dhj"&&(D.textContent=nl),Ce=a(t),V=n(t,"P",{"data-svelte-h":!0}),s(V)!=="svelte-bs7dzw"&&(V.innerHTML=sl),Ge=a(t),U(L.$$.fragment,t),ke=a(t),z=n(t,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1uramho"&&(z.innerHTML=pl),We=a(t),U(Y.$$.fragment,t),Pe=a(t),E=n(t,"P",{"data-svelte-h":!0}),s(E)!=="svelte-1l2ntjq"&&(E.textContent=Ul),Ie=a(t),O=n(t,"P",{"data-svelte-h":!0}),s(O)!=="svelte-7hrtkf"&&(O.textContent=rl),He=a(t),U($.$$.fragment,t),Qe=a(t),_=n(t,"P",{"data-svelte-h":!0}),s(_)!=="svelte-p43l1y"&&(_.textContent=Ml),Xe=a(t),U(tt.$$.fragment,t),xe=a(t),et=n(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-g9okh1"&&(et.innerHTML=yl),Se=a(t),At=n(t,"P",{"data-svelte-h":!0}),s(At)!=="svelte-14eqp9s"&&(At.innerHTML=ul),qe=a(t),lt=n(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-s2v4vp"&&(lt.textContent=Fl),Ne=a(t),U(ot.$$.fragment,t),Ze=a(t),U(at.$$.fragment,t),De=a(t),it=n(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-jlrrrr"&&(it.textContent=cl),Ve=a(t),U(nt.$$.fragment,t),Le=a(t),st=n(t,"P",{"data-svelte-h":!0}),s(st)!=="svelte-1jqdrzm"&&(st.innerHTML=wl),ze=a(t),pt=n(t,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-19ficfy"&&(pt.innerHTML=jl),Ye=a(t),U(Ut.$$.fragment,t),Ee=a(t),U(rt.$$.fragment,t),Oe=a(t),U(Mt.$$.fragment,t),$e=a(t),yt=n(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9r88s4"&&(yt.innerHTML=dl),_e=a(t),U(ut.$$.fragment,t),tA=a(t),U(Ft.$$.fragment,t),eA=a(t),ct=n(t,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-1k707m6"&&(ct.textContent=fl),AA=a(t),U(wt.$$.fragment,t),lA=a(t),_t=n(t,"IMG",{src:!0}),oA=a(t),U(jt.$$.fragment,t),aA=a(t),dt=n(t,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-1afh9r"&&(dt.textContent=Rl),iA=a(t),ft=n(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-37es2j"&&(ft.textContent=Kl),nA=a(t),U(mt.$$.fragment,t),sA=a(t),U(Rt.$$.fragment,t),pA=a(t),Kt=n(t,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-edorr6"&&(Kt.textContent=Jl),UA=a(t),Jt=n(t,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-gvee3z"&&(Jt.textContent=bl),rA=a(t),U(bt.$$.fragment,t),MA=a(t),Tt=n(t,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-qeorgn"&&(Tt.textContent=Tl),yA=a(t),U(ht.$$.fragment,t),uA=a(t),U(Bt.$$.fragment,t),FA=a(t),gt=n(t,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-dgdmgy"&&(gt.textContent=hl),cA=a(t),U(vt.$$.fragment,t),wA=a(t),Ct=n(t,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-1p0vl1g"&&(Ct.textContent=Bl),jA=a(t),U(Gt.$$.fragment,t),dA=a(t),U(kt.$$.fragment,t),fA=a(t),U(Wt.$$.fragment,t),mA=a(t),Pt=n(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1wtey9"&&(Pt.textContent=gl),RA=a(t),U(It.$$.fragment,t),KA=a(t),Ht=n(t,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-jkza22"&&(Ht.textContent=vl),JA=a(t),Qt=n(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-v0objp"&&(Qt.textContent=Cl),bA=a(t),Xt=n(t,"P",{"data-svelte-h":!0}),s(Xt)!=="svelte-j3yza3"&&(Xt.innerHTML=Gl),TA=a(t),xt=n(t,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-1enu4ba"&&(xt.textContent=kl),hA=a(t),U(St.$$.fragment,t),BA=a(t),qt=n(t,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-91i8zd"&&(qt.textContent=Wl),gA=a(t),Nt=n(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1qj01og"&&(Nt.innerHTML=Pl),vA=a(t),U(Zt.$$.fragment,t),CA=a(t),Dt=n(t,"PRE",{"data-svelte-h":!0}),s(Dt)!=="svelte-1ak7h0u"&&(Dt.textContent=Il),GA=a(t),Vt=n(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-15k62qv"&&(Vt.textContent=Hl),kA=a(t),U(Lt.$$.fragment,t),WA=a(t),zt=n(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-1b9o2wt"&&(zt.textContent=Ql),PA=a(t),Yt=n(t,"P",{"data-svelte-h":!0}),s(Yt)!=="svelte-1thq36n"&&(Yt.textContent=Xl),IA=a(t),Et=n(t,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-g53aii"&&(Et.textContent=xl),HA=a(t),Ot=n(t,"UL",{"data-svelte-h":!0}),s(Ot)!=="svelte-xq94wl"&&(Ot.innerHTML=Sl),QA=a(t),U($t.$$.fragment,t),XA=a(t),ee=n(t,"P",{}),ql(ee).forEach(A),this.h()},h(){SA(w,"name","hf:doc:metadata"),SA(w,"content",to),Zl(_t.src,ml="data:image/jpeg;base64,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")||SA(_t,"src",ml)},m(t,e){El(document.head,w),l(t,Ae,e),l(t,te,e),l(t,le,e),r(j,t,e),l(t,oe,e),r(d,t,e),l(t,ae,e),l(t,f,e),l(t,ie,e),l(t,m,e),l(t,ne,e),l(t,R,e),l(t,se,e),l(t,K,e),l(t,pe,e),l(t,J,e),l(t,Ue,e),r(b,t,e),l(t,re,e),r(T,t,e),l(t,Me,e),r(h,t,e),l(t,ye,e),l(t,B,e),l(t,ue,e),l(t,g,e),l(t,Fe,e),l(t,v,e),l(t,ce,e),l(t,C,e),l(t,we,e),r(G,t,e),l(t,je,e),l(t,k,e),l(t,de,e),l(t,W,e),l(t,fe,e),l(t,P,e),l(t,me,e),r(I,t,e),l(t,Re,e),l(t,H,e),l(t,Ke,e),r(Q,t,e),l(t,Je,e),l(t,X,e),l(t,be,e),l(t,x,e),l(t,Te,e),l(t,S,e),l(t,he,e),l(t,q,e),l(t,Be,e),r(N,t,e),l(t,ge,e),l(t,Z,e),l(t,ve,e),l(t,D,e),l(t,Ce,e),l(t,V,e),l(t,Ge,e),r(L,t,e),l(t,ke,e),l(t,z,e),l(t,We,e),r(Y,t,e),l(t,Pe,e),l(t,E,e),l(t,Ie,e),l(t,O,e),l(t,He,e),r($,t,e),l(t,Qe,e),l(t,_,e),l(t,Xe,e),r(tt,t,e),l(t,xe,e),l(t,et,e),l(t,Se,e),l(t,At,e),l(t,qe,e),l(t,lt,e),l(t,Ne,e),r(ot,t,e),l(t,Ze,e),r(at,t,e),l(t,De,e),l(t,it,e),l(t,Ve,e),r(nt,t,e),l(t,Le,e),l(t,st,e),l(t,ze,e),l(t,pt,e),l(t,Ye,e),r(Ut,t,e),l(t,Ee,e),r(rt,t,e),l(t,Oe,e),r(Mt,t,e),l(t,$e,e),l(t,yt,e),l(t,_e,e),r(ut,t,e),l(t,tA,e),r(Ft,t,e),l(t,eA,e),l(t,ct,e),l(t,AA,e),r(wt,t,e),l(t,lA,e),l(t,_t,e),l(t,oA,e),r(jt,t,e),l(t,aA,e),l(t,dt,e),l(t,iA,e),l(t,ft,e),l(t,nA,e),r(mt,t,e),l(t,sA,e),r(Rt,t,e),l(t,pA,e),l(t,Kt,e),l(t,UA,e),l(t,Jt,e),l(t,rA,e),r(bt,t,e),l(t,MA,e),l(t,Tt,e),l(t,yA,e),r(ht,t,e),l(t,uA,e),r(Bt,t,e),l(t,FA,e),l(t,gt,e),l(t,cA,e),r(vt,t,e),l(t,wA,e),l(t,Ct,e),l(t,jA,e),r(Gt,t,e),l(t,dA,e),r(kt,t,e),l(t,fA,e),r(Wt,t,e),l(t,mA,e),l(t,Pt,e),l(t,RA,e),r(It,t,e),l(t,KA,e),l(t,Ht,e),l(t,JA,e),l(t,Qt,e),l(t,bA,e),l(t,Xt,e),l(t,TA,e),l(t,xt,e),l(t,hA,e),r(St,t,e),l(t,BA,e),l(t,qt,e),l(t,gA,e),l(t,Nt,e),l(t,vA,e),r(Zt,t,e),l(t,CA,e),l(t,Dt,e),l(t,GA,e),l(t,Vt,e),l(t,kA,e),r(Lt,t,e),l(t,WA,e),l(t,zt,e),l(t,PA,e),l(t,Yt,e),l(t,IA,e),l(t,Et,e),l(t,HA,e),l(t,Ot,e),l(t,QA,e),r($t,t,e),l(t,XA,e),l(t,ee,e),xA=!0},p:Dl,i(t){xA||(M(j.$$.fragment,t),M(d.$$.fragment,t),M(b.$$.fragment,t),M(T.$$.fragment,t),M(h.$$.fragment,t),M(G.$$.fragment,t),M(I.$$.fragment,t),M(Q.$$.fragment,t),M(N.$$.fragment,t),M(L.$$.fragment,t),M(Y.$$.fragment,t),M($.$$.fragment,t),M(tt.$$.fragment,t),M(ot.$$.fragment,t),M(at.$$.fragment,t),M(nt.$$.fragment,t),M(Ut.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(ut.$$.fragment,t),M(Ft.$$.fragment,t),M(wt.$$.fragment,t),M(jt.$$.fragment,t),M(mt.$$.fragment,t),M(Rt.$$.fragment,t),M(bt.$$.fragment,t),M(ht.$$.fragment,t),M(Bt.$$.fragment,t),M(vt.$$.fragment,t),M(Gt.$$.fragment,t),M(kt.$$.fragment,t),M(Wt.$$.fragment,t),M(It.$$.fragment,t),M(St.$$.fragment,t),M(Zt.$$.fragment,t),M(Lt.$$.fragment,t),M($t.$$.fragment,t),xA=!0)},o(t){y(j.$$.fragment,t),y(d.$$.fragment,t),y(b.$$.fragment,t),y(T.$$.fragment,t),y(h.$$.fragment,t),y(G.$$.fragment,t),y(I.$$.fragment,t),y(Q.$$.fragment,t),y(N.$$.fragment,t),y(L.$$.fragment,t),y(Y.$$.fragment,t),y($.$$.fragment,t),y(tt.$$.fragment,t),y(ot.$$.fragment,t),y(at.$$.fragment,t),y(nt.$$.fragment,t),y(Ut.$$.fragment,t),y(rt.$$.fragment,t),y(Mt.$$.fragment,t),y(ut.$$.fragment,t),y(Ft.$$.fragment,t),y(wt.$$.fragment,t),y(jt.$$.fragment,t),y(mt.$$.fragment,t),y(Rt.$$.fragment,t),y(bt.$$.fragment,t),y(ht.$$.fragment,t),y(Bt.$$.fragment,t),y(vt.$$.fragment,t),y(Gt.$$.fragment,t),y(kt.$$.fragment,t),y(Wt.$$.fragment,t),y(It.$$.fragment,t),y(St.$$.fragment,t),y(Zt.$$.fragment,t),y(Lt.$$.fragment,t),y($t.$$.fragment,t),xA=!1},d(t){t&&(A(Ae),A(te),A(le),A(oe),A(ae),A(f),A(ie),A(m),A(ne),A(R),A(se),A(K),A(pe),A(J),A(Ue),A(re),A(Me),A(ye),A(B),A(ue),A(g),A(Fe),A(v),A(ce),A(C),A(we),A(je),A(k),A(de),A(W),A(fe),A(P),A(me),A(Re),A(H),A(Ke),A(Je),A(X),A(be),A(x),A(Te),A(S),A(he),A(q),A(Be),A(ge),A(Z),A(ve),A(D),A(Ce),A(V),A(Ge),A(ke),A(z),A(We),A(Pe),A(E),A(Ie),A(O),A(He),A(Qe),A(_),A(Xe),A(xe),A(et),A(Se),A(At),A(qe),A(lt),A(Ne),A(Ze),A(De),A(it),A(Ve),A(Le),A(st),A(ze),A(pt),A(Ye),A(Ee),A(Oe),A($e),A(yt),A(_e),A(tA),A(eA),A(ct),A(AA),A(lA),A(_t),A(oA),A(aA),A(dt),A(iA),A(ft),A(nA),A(sA),A(pA),A(Kt),A(UA),A(Jt),A(rA),A(MA),A(Tt),A(yA),A(uA),A(FA),A(gt),A(cA),A(wA),A(Ct),A(jA),A(dA),A(fA),A(mA),A(Pt),A(RA),A(KA),A(Ht),A(JA),A(Qt),A(bA),A(Xt),A(TA),A(xt),A(hA),A(BA),A(qt),A(gA),A(Nt),A(vA),A(CA),A(Dt),A(GA),A(Vt),A(kA),A(WA),A(zt),A(PA),A(Yt),A(IA),A(Et),A(HA),A(Ot),A(QA),A(XA),A(ee)),A(w),u(j,t),u(d,t),u(b,t),u(T,t),u(h,t),u(G,t),u(I,t),u(Q,t),u(N,t),u(L,t),u(Y,t),u($,t),u(tt,t),u(ot,t),u(at,t),u(nt,t),u(Ut,t),u(rt,t),u(Mt,t),u(ut,t),u(Ft,t),u(wt,t),u(jt,t),u(mt,t),u(Rt,t),u(bt,t),u(ht,t),u(Bt,t),u(vt,t),u(Gt,t),u(kt,t),u(Wt,t),u(It,t),u(St,t),u(Zt,t),u(Lt,t),u($t,t)}}}const to='{"title":"Information Extraction with Haystack and NuExtract","local":"information-extraction-with-haystack-and-nuextract","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Components","local":"components","sections":[{"title":"LinkContentFetcher and HTMLToDocument : extract text from web pages","local":"linkcontentfetcher-and-htmltodocument--extract-text-from-web-pages","sections":[],"depth":3},{"title":"HuggingFaceLocalGenerator : load and try the model","local":"huggingfacelocalgenerator--load-and-try-the-model","sections":[{"title":"Notes on Flash Attention","local":"notes-on-flash-attention","sections":[],"depth":4}],"depth":3},{"title":"PromptBuilder : dynamically create prompts","local":"promptbuilder--dynamically-create-prompts","sections":[],"depth":3},{"title":"OutputAdapter","local":"outputadapter","sections":[],"depth":3}],"depth":2},{"title":"Information Extraction Pipeline","local":"information-extraction-pipeline","sections":[{"title":"Build the Pipeline","local":"build-the-pipeline","sections":[],"depth":3},{"title":"Define the sources and the extraction schema","local":"define-the-sources-and-the-extraction-schema","sections":[],"depth":3},{"title":"Run the Pipeline!","local":"run-the-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Data exploration and visualization","local":"data-exploration-and-visualization","sections":[{"title":"Dataframe","local":"dataframe","sections":[],"depth":3},{"title":"Build a simple graph","local":"build-a-simple-graph","sections":[],"depth":3}],"depth":2},{"title":"Conclusion and ideas","local":"conclusion-and-ideas","sections":[],"depth":2}],"depth":1}';function eo(qA){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class io extends Ll{constructor(w){super(),zl(this,w,eo,_l,Nl,{})}}export{io as component};
