import{s as $i,n as ki,o as Ji}from"../chunks/scheduler.65852ee5.js";import{S as xi,i as Ui,g as n,s as i,r as m,A as _i,h as o,f as s,c as a,j as rl,u as p,x as r,k as ht,l as al,y as ft,a as l,v as u,d as h,t as f,w as c}from"../chunks/index.aa74147d.js";import{D as Ii,C as d}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as M,E as Wi}from"../chunks/EditOnGithub.4eda6a96.js";function Zi(ml){let y,ct,pt,dt,j,gt,T,yt,C,pl='<em>Authored by: <a href="https://huggingface.co/jamarks" rel="nofollow">Jacob Marks</a></em>',Mt,$,ul='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_cover_image.jpg" alt="Art Analysis Cover Image"/>',bt,k,hl="Visual data like images is incredibly information-rich, but the unstructured nature of that data makes it difficult to analyze.",wt,J,fl='In this notebook, we’ll explore how to use multimodal embeddings and computed attributes to analyze artistic styles in images. We’ll use the <a href="https://huggingface.co/datasets/huggan/wikiart" rel="nofollow">WikiArt dataset</a> from 🤗 Hub, which we will load into FiftyOne for data analysis and visualization. We’ll dive into the data in a variety of ways:',vt,x,cl='<li><p><strong>Image Similarity Search and Semantic Search</strong>: We’ll generate multimodal embeddings for the images in the dataset using a pre-trained <a href="https://huggingface.co/openai/clip-vit-base-patch32" rel="nofollow">CLIP</a> model from 🤗 Transformers and index the data to allow for unstructured searches.</p></li> <li><p><strong>Clustering and Visualization</strong>: We’ll cluster the images based on their artistic style using the embeddings and visualize the results using UMAP dimensionality reduction.</p></li> <li><p><strong>Uniqueness Analysis</strong>: We’ll use our embeddings to assign a uniqueness score to each image based on how similar it is to other images in the dataset.</p></li> <li><p><strong>Image Quality Analysis</strong>: We’ll compute image quality metrics like brightness, contrast, and saturation for each image and see how these metrics correlate with the artistic style of the images.</p></li>',jt,U,Tt,_,dl="To run this notebook, you’ll need to install the following libraries:",Ct,I,$t,W,gl='To make downloads lightning-fast, install <a href="https://pypi.org/project/hf-transfer/" rel="nofollow">HF Transfer</a>:',kt,Z,Jt,z,yl="And enable by setting the environment variable <code>HF_HUB_ENABLE_HF_TRANSFER</code>:",xt,H,Ut,b,Ml="<b>Note:</b> This notebook was tested with <code>transformers==4.40.0</code>, <code>huggingface_hub==0.22.2</code>, and <code>fiftyone==0.23.8</code>.",_t,q,bl="Now let’s import the modules that we’ll need for this notebook:",It,G,Wt,L,wl='We’ll start by loading the WikiArt dataset from 🤗 Hub into FiftyOne. This dataset can also be loaded through Hugging Face’s <code>datasets</code> library, but we’ll use <a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne’s 🤗 Hub integration</a> to get the data directly from the Datasets server. To make the computations fast, we’ll just download the first $1,000$ samples.',Zt,F,zt,X,vl="Print out a summary of the dataset to see what it contains:",Ht,R,qt,B,jl=`Name:        wikiart
Media type:  image
Num samples: 1000
Persistent:  False
Tags:        []
Sample fields:
    id:       fiftyone.core.fields.ObjectIdField
    filepath: fiftyone.core.fields.StringField
    tags:     fiftyone.core.fields.ListField(fiftyone.core.fields.StringField)
    metadata: fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.metadata.ImageMetadata)
    artist:   fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    style:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    genre:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    row_idx:  fiftyone.core.fields.IntField
`,Gt,V,Tl='Visualize the dataset in the <a href="https://docs.voxel51.com/user_guide/app.html" rel="nofollow">FiftyOne App</a>:',Lt,A,Ft,P,Cl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_wikiart_dataset.jpg" alt="WikiArt Dataset"/>',Xt,N,$l="Let’s list out the names of the artists whose styles we’ll be analyzing:",Rt,Y,Bt,E,kl=`['Unknown Artist', 'albrecht-durer', 'boris-kustodiev', 'camille-pissarro', 'childe-hassam', 'claude-monet', 'edgar-degas', 'eugene-boudin', 'gustave-dore', 'ilya-repin', 'ivan-aivazovsky', 'ivan-shishkin', 'john-singer-sargent', 'marc-chagall', 'martiros-saryan', 'nicholas-roerich', 'pablo-picasso', 'paul-cezanne', 'pierre-auguste-renoir', 'pyotr-konchalovsky', 'raphael-kirchner', 'rembrandt', 'salvador-dali', 'vincent-van-gogh']
`,Vt,S,At,Q,Jl="When you find a piece of art that you like, it’s natural to want to find similar pieces. We can do this with vector embeddings! What’s more, by using multimodal embeddings, we will unlock the ability to find paintings that closely resemble a given text query, which could be a description of a painting or even a poem.",Pt,O,xl='Let’s generate multimodal embeddings for the images using a pre-trained CLIP Vision Transformer (ViT) model from 🤗 Transformers. Running <code>compute_similarity()</code> from the <a href="https://docs.voxel51.com/user_guide/brain.html" rel="nofollow">FiftyOne Brain</a> will compute these embeddings and use them to generate a similarity index on the dataset.',Nt,D,Yt,K,Ul=`Computing embeddings...
 100% |███████████████| 1000/1000 [5.0m elapsed, 0s remaining, 3.3 samples/s]
`,Et,g,ot,_l="Alternatively, you could load the model directly from the 🤗 Transformers library and pass the model in directly:",nl,ee,ol,rt,Il='For a comprehensive guide to this and more, check out <a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library">FiftyOne’s 🤗 Transformers integration</a>.',St,te,Wl="Refresh the FiftyOne App, select the checkbox for an image in the sample grid, and click the photo icon to see the most similar images in the dataset. On the backend, clicking this button triggers a query to the similarity index to find the most similar images to the selected image, based on the pre-computed embeddings, and displays them in the App.",Qt,se,Zl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_image_search.gif" alt="Image Similarity Search"/>',Ot,le,zl="We can use this to see what art pieces are most similar to a given art piece. This can be useful for finding similar art pieces (to recommend to users or add to a collection) or getting inspiration for a new piece.",Dt,ie,Hl="But there’s more! Because CLIP is multimodal, we can also use it to perform semantic searches. This means we can search for images based on text queries. For example, we can search for “pastel trees” and see all the images in the dataset that are similar to that query. To do this, click on the search icon in the FiftyOne App and enter a text query:",Kt,ae,ql='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_semantic_search.gif" alt="Semantic Search"/>',es,ne,Gl="Behind the scenes, the text is tokenized, embedded with CLIP’s text encoder, and then used to query the similarity index to find the most similar images in the dataset. This is a powerful way to search for images based on text queries and can be useful for finding images that match a particular theme or style. And this is not limited to CLIP; you can use any CLIP-like model from 🤗 Transformers that can generate embeddings for images and text!",ts,w,Ll='💡 For efficient vector search and indexing over large datasets, FiftyOne has native <a href="https://voxel51.com/vector-search">integrations with open source vector databases</a>.',ss,oe,ls,re,Fl="By performing similarity and semantic searches, we can begin to interact with the data more effectively. But we can also take this a step further and add some unsupervised learning into the mix. This will help us identify artistic patterns in the WikiArt dataset, from stylistic, to topical, and even motifs that are hard to put into words.",is,me,Xl="We will do this in two ways:",as,pe,Rl="<li><strong>Dimensionality Reduction</strong>: We’ll use UMAP to reduce the dimensionality of the embeddings to 2D and visualize the data in a scatter plot. This will allow us to see how the images cluster based on their style, genre, and artist.</li> <li><strong>Clustering</strong>: We’ll use K-Means clustering to cluster the images based on their embeddings and see what groups emerge.</li>",ns,ue,Bl="For dimensionality reduction, we will run <code>compute_visualization()</code> from the FiftyOne Brain, passing in the previously computed embeddings. We specify <code>method=&quot;umap&quot;</code> to use UMAP for dimensionality reduction, but we could also use PCA or t-SNE:",os,he,rs,fe,Vl=`Generating visualization...
`,ms,ce,Al="Now we can open a panel in the FiftyOne App, where we will see one 2D point for each image in the dataset. We can color the points by any field in the dataset, such as the artist or genre, to see how strongly these attributes are captured by our image features:",ps,de,Pl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_visualize_embeddings.gif" alt="UMAP Visualization"/>',us,ge,Nl='We can also run clustering on the embeddings to group similar images together — perhaps the dominant features of these works of art are not captured by the existing labels, or maybe there are distinct sub-genres that we want to identify. To cluster our data, we will need to download the <a href="https://github.com/jacobmarks/clustering-plugin" rel="nofollow">FiftyOne Clustering Plugin</a>:',hs,ye,fs,Me,Yl="Refreshing the app again, we can then access the clustering functionality via an operator in the app. Hit the backtick key to open the operator list, type “cluster” and select the operator from the dropdown. This will open an interactive panel where we can specify the clustering algorithm, hyperparameters, and the field to cluster on. To keep it simple, we’ll use K-Means clustering with $10$ clusters.",cs,be,El="We can then visualize the clusters in the app and see how the images group together based on their embeddings:",ds,we,Sl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_clustering.gif" alt="K-means Clustering"/>',gs,ve,Ql="We can see that some of the clusters select for artist; others select for genre or style. Others are more abstract and may represent sub-genres or other groupings that are not immediately obvious from the data.",ys,je,Ms,Te,Ol="One interesting question we can ask about our dataset is how <em>unique</em> each image is. This question is important for many applications, such as recommending similar images, detecting duplicates, or identifying outliers. In the context of art, how unique a painting is could be an important factor in determining its value.",bs,Ce,Dl="While there are a million ways to characterize uniqueness, our image embeddings allow us to quantitatively assign each sample a uniqueness score based on how similar it is to other samples in the dataset. Explicitly, the FiftyOne Brain’s <code>compute_uniqueness()</code> function looks at the distance between each sample’s embedding and its nearest neighbors, and computes a score between $0$ and $1$ based on this distance. A score of $0$ means the sample is nondescript or very similar to others, while a score of $1$ means the sample is very unique.",ws,$e,vs,ke,Kl=`Computing uniqueness...
Uniqueness computation complete
`,js,Je,ei="We can then color by this in the embeddings panel, filter by uniqueness score, or even sort by it to see the most unique images in the dataset:",Ts,xe,Cs,Ue,ti='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_most_unique.jpg" alt="Most Unique Images"/>',$s,_e,ks,Ie,si='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_least_unique.jpg" alt="Least Unique Images"/>',Js,We,li="Going a step further, we can also answer the question of which artist tends to produce the most unique works. We can compute the average uniqueness score for each artist across all of their works of art:",xs,Ze,Us,ze,ii=`Unknown Artist: 0.7932221632002723
boris-kustodiev: 0.7480731948424676
salvador-dali: 0.7368807620414014
raphael-kirchner: 0.7315448102204755
ilya-repin: 0.7204744626806383
marc-chagall: 0.7169373812321908
rembrandt: 0.715205220292227
martiros-saryan: 0.708560775790436
childe-hassam: 0.7018343391132756
edgar-degas: 0.699912746806587
albrecht-durer: 0.6969358680800216
john-singer-sargent: 0.6839955708720844
pablo-picasso: 0.6835137858302969
pyotr-konchalovsky: 0.6780653000855895
nicholas-roerich: 0.6676504687452387
ivan-aivazovsky: 0.6484361530090199
vincent-van-gogh: 0.6472004520699081
gustave-dore: 0.6307283287457358
pierre-auguste-renoir: 0.6271467146993583
paul-cezanne: 0.6251076007168186
eugene-boudin: 0.6103397516167454
camille-pissarro: 0.6046182609119615
claude-monet: 0.5998234558947573
ivan-shishkin: 0.589796389836674
`,_s,He,ai="It would seem that the artist with the most unique works in our dataset is Boris Kustodiev! Let’s take a look at some of his works:",Is,qe,Ws,Ge,ni='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_kustodiev_view.jpg" alt="Boris Kustodiev Artwork"/>',Zs,Le,zs,Fe,oi="To round things out, let’s go back to the basics and analyze some core qualities of the images in our dataset. We’ll compute standard metrics like brightness, contrast, and saturation for each image and see how these metrics correlate with the artistic style and genre of the art pieces.",Hs,Xe,ri='To run these analyses, we will need to download the <a href="https://github.com/jacobmarks/image-quality-issues" rel="nofollow">FiftyOne Image Quality Plugin</a>:',qs,Re,Gs,Be,mi="Refresh the app and open the operators list again. This time type <code>compute</code> and select one of the image quality operators. We’ll start with brightness:",Ls,Ve,pi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_compute_brightness.gif" alt="Compute Brightness"/>',Fs,Ae,ui="When the operator finishes running, we will have a new field in our dataset that contains the brightness score for each image. We can then visualize this data in the app:",Xs,Pe,hi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_brightness.gif" alt="Brightness"/>',Rs,Ne,fi="We can also color by brightness, and even see how it correlates with other fields in the dataset like style:",Bs,Ye,ci='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_style_by_brightness.gif" alt="Style by Brightness"/>',Vs,Ee,di="Now do the same for contrast and saturation. Here are the results for saturation:",As,Se,gi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_filter_by_saturation.jpg" alt="Filter by Saturation"/>',Ps,Qe,yi="Hopefully this illustrates how not everything boils down to applying deep neural networks to your data. Sometimes, simple metrics can be just as informative and can provide a different perspective on your data 🤓!",Ns,v,Mi='📚 For larger datasets, you may want to <a href="https://docs.voxel51.com/plugins/using_plugins.html#delegated-operations">delegate the operations</a> for later execution.',Ys,Oe,Es,De,bi='In this notebook, we’ve explored how to use multimodal embeddings, unsupervised learning, and traditional image processing techniques to analyze artistic styles in images. We’ve seen how to perform image similarity and semantic searches, cluster images based on their style, analyze the uniqueness of images, and compute image quality metrics. These techniques can be applied to a wide range of visual datasets, from art collections to medical images to satellite imagery. Try <a href="https://docs.voxel51.com/integrations/huggingface.html#loading-datasets-from-the-hub" rel="nofollow">loading a different dataset from the Hugging Face Hub</a> and see what insights you can uncover!',Ss,Ke,wi="If you want to go even further, here are some additional analyses you could try:",Qs,et,vi='<li><strong>Zero-Shot Classification</strong>: Use a pre-trained vision-language model from 🤗 Transformers to categorize images in the dataset by topic or subject, without any training data. Check out this <a href="https://docs.voxel51.com/tutorials/zero_shot_classification.html" rel="nofollow">Zero-Shot Classification tutorial</a> for more info.</li> <li><strong>Image Captioning</strong>: Use a pre-trained vision-language model from 🤗 Transformers to generate captions for the images in the dataset. Then use this for topic modeling or cluster artwork based on embeddings for these captions. Check out FiftyOne’s <a href="https://github.com/jacobmarks/fiftyone-image-captioning-plugin" rel="nofollow">Image Captioning Plugin</a> for more info.</li>',Os,tt,Ds,st,ji='<li><a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne 🤝 🤗 Hub Integration</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library" rel="nofollow">FiftyOne 🤝 🤗 Transformers Integration</a></li> <li><a href="https://voxel51.com/vector-search/" rel="nofollow">FiftyOne Vector Search Integrations</a></li> <li><a href="https://docs.voxel51.com/tutorials/dimension_reduction.html" rel="nofollow">Visualizing Data with Dimensionality Reduction Techniques</a></li> <li><a href="https://docs.voxel51.com/tutorials/clustering.html" rel="nofollow">Clustering Images with Embeddings</a></li> <li><a href="https://docs.voxel51.com/tutorials/uniqueness.html" rel="nofollow">Exploring Image Uniqueness with FiftyOne</a></li>',Ks,lt,el,it,Ti='<a href="https://github.com/voxel51/fiftyone/" rel="nofollow">FiftyOne</a> is the leading open source toolkit for building high-quality datasets and computer vision models. With over 2M downloads, FiftyOne is trusted by developers and researchers across the globe.',tl,at,Ci='💪 The FiftyOne team welcomes contributions from the open source community! If you’re interested in contributing to FiftyOne, check out the <a href="https://github.com/voxel51/fiftyone/blob/develop/CONTRIBUTING.md" rel="nofollow">contributing guide</a>.',sl,nt,ll,ut,il;return j=new Ii({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/small-typo/notebooks/en/analyzing_art_with_hf_and_fiftyone.ipynb"}]}}),T=new M({props:{title:"Analyzing Artistic Styles with Multimodal Embeddings",local:"analyzing-artistic-styles-with-multimodal-embeddings",headingTag:"h1"}}),U=new M({props:{title:"Let’s get started! 🚀",local:"lets-get-started-",headingTag:"h2"}}),I=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMHRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGZpZnR5b25lJTIwdW1hcC1sZWFybg==",highlighted:"!pip install -U transformers huggingface_hub fiftyone umap-learn",wrap:!1}}),Z=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGhmLXRyYW5zZmVy",highlighted:"pip install hf-transfer",wrap:!1}}),H=new d({props:{code:"aW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIySEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUyMiU1RCUyMCUzRCUyMCUyMjElMjI=",highlighted:`import os
os.environ[<span class="hljs-string">&quot;HF_HUB_ENABLE_HF_TRANSFER&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>`,wrap:!1}}),G=new d({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTIwJTIwJTIzJTIwYmFzZSUyMGxpYnJhcnklMjBhbmQlMjBhcHAlMEFpbXBvcnQlMjBmaWZ0eW9uZS56b28lMjBhcyUyMGZveiUyMCUyMCUyMyUyMHpvbyUyMGRhdGFzZXRzJTIwYW5kJTIwbW9kZWxzJTBBaW1wb3J0JTIwZmlmdHlvbmUuYnJhaW4lMjBhcyUyMGZvYiUyMCUyMCUyMyUyME1MJTIwcm91dGluZXMlMEFmcm9tJTIwZmlmdHlvbmUlMjBpbXBvcnQlMjBWaWV3RmllbGQlMjBhcyUyMEYlMjAlMjAlMjMlMjBmb3IlMjBkZWZpbmluZyUyMGN1c3RvbSUyMHZpZXdzJTBBaW1wb3J0JTIwZmlmdHlvbmUudXRpbHMuaHVnZ2luZ2ZhY2UlMjBhcyUyMGZvdWglMjAlMjAlMjMlMjBmb3IlMjBsb2FkaW5nJTIwZGF0YXNldHMlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2U=",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo  <span class="hljs-comment"># base library and app</span>
<span class="hljs-keyword">import</span> fiftyone.zoo <span class="hljs-keyword">as</span> foz  <span class="hljs-comment"># zoo datasets and models</span>
<span class="hljs-keyword">import</span> fiftyone.brain <span class="hljs-keyword">as</span> fob  <span class="hljs-comment"># ML routines</span>
<span class="hljs-keyword">from</span> fiftyone <span class="hljs-keyword">import</span> ViewField <span class="hljs-keyword">as</span> F  <span class="hljs-comment"># for defining custom views</span>
<span class="hljs-keyword">import</span> fiftyone.utils.huggingface <span class="hljs-keyword">as</span> fouh  <span class="hljs-comment"># for loading datasets from Hugging Face</span>`,wrap:!1}}),F=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGZvdWgubG9hZF9mcm9tX2h1YiglMEElMjAlMjAlMjAlMjAlMjJodWdnYW4lMkZ3aWtpYXJ0JTIyJTJDJTIwJTIwJTIzJTIzJTIwcmVwb19pZCUwQSUyMCUyMCUyMCUyMGZvcm1hdCUzRCUyMnBhcnF1ZXQlMjIlMkMlMjAlMjAlMjMlMjMlMjBmb3IlMjBQYXJxdWV0JTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwY2xhc3NpZmljYXRpb25fZmllbGRzJTNEJTVCJTIyYXJ0aXN0JTIyJTJDJTIwJTIyc3R5bGUlMjIlMkMlMjAlMjJnZW5yZSUyMiU1RCUyQyUyMCUyMCUyMyUyMGNvbHVtbnMlMjB0byUyMHN0b3JlJTIwYXMlMjBjbGFzc2lmaWNhdGlvbiUyMGZpZWxkcyUwQSUyMCUyMCUyMCUyMG1heF9zYW1wbGVzJTNEMTAwMCUyQyUyMCUyMCUyMyUyMG51bWJlciUyMG9mJTIwc2FtcGxlcyUyMHRvJTIwbG9hZCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ3aWtpYXJ0JTIyJTJDJTIwJTIwJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGF0YXNldCUyMGluJTIwRmlmdHlPbmUlMEEp",highlighted:`dataset = fouh.load_from_hub(
    <span class="hljs-string">&quot;huggan/wikiart&quot;</span>,  <span class="hljs-comment">## repo_id</span>
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;parquet&quot;</span>,  <span class="hljs-comment">## for Parquet format</span>
    classification_fields=[<span class="hljs-string">&quot;artist&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>],  <span class="hljs-comment"># columns to store as classification fields</span>
    max_samples=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># number of samples to load</span>
    name=<span class="hljs-string">&quot;wikiart&quot;</span>,  <span class="hljs-comment"># name of the dataset in FiftyOne</span>
)`,wrap:!1}}),R=new d({props:{code:"cHJpbnQoZGF0YXNldCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)',wrap:!1}}),A=new d({props:{code:"c2Vzc2lvbiUyMCUzRCUyMGZvLmxhdW5jaF9hcHAoZGF0YXNldCk=",highlighted:"session = fo.launch_app(dataset)",wrap:!1}}),Y=new d({props:{code:"YXJ0aXN0cyUyMCUzRCUyMGRhdGFzZXQuZGlzdGluY3QoJTIyYXJ0aXN0LmxhYmVsJTIyKSUwQXByaW50KGFydGlzdHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artists = dataset.distinct(<span class="hljs-string">&quot;artist.label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(artists)`,wrap:!1}}),S=new M({props:{title:"Finding Similar Artwork",local:"finding-similar-artwork",headingTag:"h2"}}),D=new d({props:{code:"Zm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24tdHJhbnNmb3JtZXItdG9yY2glMjIlMkMlMjAlMjAlMjMlMjMlMjB0eXBlJTIwb2YlMjBtb2RlbCUyMHRvJTIwbG9hZCUyMGZyb20lMjBtb2RlbCUyMHpvbyUwQSUyMCUyMCUyMCUyMG5hbWVfb3JfcGF0aCUzRCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gzMiUyMiUyQyUyMCUyMCUyMyUyMyUyMHJlcG9faWQlMjBvZiUyMGNoZWNrcG9pbnQlMEElMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTNEJTIyY2xpcF9lbWJlZGRpbmdzJTIyJTJDJTIwJTIwJTIzJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZmllbGQlMjB0byUyMHN0b3JlJTIwZW1iZWRkaW5ncyUwQSUyMCUyMCUyMCUyMGJyYWluX2tleSUzRCUyMmNsaXBfc2ltJTIyJTJDJTIwJTIwJTIzJTIzJTIwa2V5JTIwdG8lMjBzdG9yZSUyMHNpbWlsYXJpdHklMjBpbmRleCUyMGluZm8lMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjAlMjAlMjMlMjMlMjBiYXRjaCUyMHNpemUlMjBmb3IlMjBpbmZlcmVuY2UlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_similarity(
<span class="hljs-meta">... </span>    dataset,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;zero-shot-classification-transformer-torch&quot;</span>,  <span class="hljs-comment">## type of model to load from model zoo</span>
<span class="hljs-meta">... </span>    name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>,  <span class="hljs-comment">## repo_id of checkpoint</span>
<span class="hljs-meta">... </span>    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>,  <span class="hljs-comment">## name of the field to store embeddings</span>
<span class="hljs-meta">... </span>    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span>,  <span class="hljs-comment">## key to store similarity index info</span>
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">32</span>,  <span class="hljs-comment">## batch size for inference</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ee=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBNb2RlbCUwQW1vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzIlMjIpJTBBZm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlM0QlMjJjbGlwX2VtYmVkZGluZ3MlMjIlMkMlMjAlMjMlMjMlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaWVsZCUyMHRvJTIwc3RvcmUlMjBlbWJlZGRpbmdzJTBBJTIwJTIwJTIwJTIwYnJhaW5fa2V5JTNEJTIyY2xpcF9zaW0lMjIlMjAlMjMlMjMlMjBrZXklMjB0byUyMHN0b3JlJTIwc2ltaWxhcml0eSUyMGluZGV4JTIwaW5mbyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPModel
model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)
fob.compute_similarity(
    dataset, 
    model=model,
    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, <span class="hljs-comment">## name of the field to store embeddings</span>
    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span> <span class="hljs-comment">## key to store similarity index info</span>
)`,wrap:!1}}),oe=new M({props:{title:"Uncovering Artistic Motifs with Clustering and Visualization",local:"uncovering-artistic-motifs-with-clustering-and-visualization",headingTag:"h2"}}),he=new d({props:{code:"Zm9iLmNvbXB1dGVfdmlzdWFsaXphdGlvbihkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiUyQyUyMG1ldGhvZCUzRCUyMnVtYXAlMjIlMkMlMjBicmFpbl9rZXklM0QlMjJjbGlwX3ZpcyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_visualization(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, method=<span class="hljs-string">&quot;umap&quot;</span>, brain_key=<span class="hljs-string">&quot;clip_vis&quot;</span>)',wrap:!1}}),ye=new d({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmNsdXN0ZXJpbmctcGx1Z2lu",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/clustering-plugin",wrap:!1}}),je=new M({props:{title:"Identifying the Most Unique Works of Art",local:"identifying-the-most-unique-works-of-art",headingTag:"h2"}}),$e=new d({props:{code:"Zm9iLmNvbXB1dGVfdW5pcXVlbmVzcyhkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiklMjAlMjAlMjMlMjBjb21wdXRlJTIwdW5pcXVlbmVzcyUyMHVzaW5nJTIwQ0xJUCUyMGVtYmVkZGluZ3M=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_uniqueness(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>)  <span class="hljs-comment"># compute uniqueness using CLIP embeddings</span>',wrap:!1}}),xe=new d({props:{code:"bW9zdF91bmlxdWVfdmlldyUyMCUzRCUyMGRhdGFzZXQuc29ydF9ieSglMjJ1bmlxdWVuZXNzJTIyJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc2Vzc2lvbi52aWV3JTIwJTNEJTIwbW9zdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjAlMjMlMjBNb3N0JTIwdW5pcXVlJTIwaW1hZ2Vz",highlighted:`most_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">True</span>)
session.view = most_unique_view.view()  <span class="hljs-comment"># Most unique images</span>`,wrap:!1}}),_e=new d({props:{code:"bGVhc3RfdW5pcXVlX3ZpZXclMjAlM0QlMjBkYXRhc2V0LnNvcnRfYnkoJTIydW5pcXVlbmVzcyUyMiUyQyUyMHJldmVyc2UlM0RGYWxzZSklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBsZWFzdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjAlMjMlMjBMZWFzdCUyMHVuaXF1ZSUyMGltYWdlcw==",highlighted:`least_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">False</span>)
session.view = least_unique_view.view()  <span class="hljs-comment"># Least unique images</span>`,wrap:!1}}),Ze=new d({props:{code:"YXJ0aXN0X3VuaXF1ZV9zY29yZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBhcnRpc3QlM0ElMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMGFydGlzdCkubWVhbiglMjJ1bmlxdWVuZXNzJTIyKSUyMGZvciUyMGFydGlzdCUyMGluJTIwYXJ0aXN0cyUwQSU3RCUwQSUwQXNvcnRlZF9hcnRpc3RzJTIwJTNEJTIwc29ydGVkKGFydGlzdF91bmlxdWVfc2NvcmVzJTJDJTIwa2V5JTNEYXJ0aXN0X3VuaXF1ZV9zY29yZXMuZ2V0JTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBJTBBZm9yJTIwYXJ0aXN0JTIwaW4lMjBzb3J0ZWRfYXJ0aXN0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JhcnRpc3QlN0QlM0ElMjAlN0JhcnRpc3RfdW5pcXVlX3Njb3JlcyU1QmFydGlzdCU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artist_unique_scores = {
<span class="hljs-meta">... </span>    artist: dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == artist).mean(<span class="hljs-string">&quot;uniqueness&quot;</span>) <span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> artists
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_artists = <span class="hljs-built_in">sorted</span>(artist_unique_scores, key=artist_unique_scores.get, reverse=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> sorted_artists:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{artist}</span>: <span class="hljs-subst">{artist_unique_scores[artist]}</span>&quot;</span>)`,wrap:!1}}),qe=new d({props:{code:"a3VzdG9kaWV2X3ZpZXclMjAlM0QlMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMCUyMmJvcmlzLWt1c3RvZGlldiUyMiklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBrdXN0b2RpZXZfdmlldy52aWV3KCk=",highlighted:`kustodiev_view = dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == <span class="hljs-string">&quot;boris-kustodiev&quot;</span>)
session.view = kustodiev_view.view()`,wrap:!1}}),Le=new M({props:{title:"Characterizing Art with Visual Qualities",local:"characterizing-art-with-visual-qualities",headingTag:"h2"}}),Re=new d({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmltYWdlLXF1YWxpdHktaXNzdWVzJTJG",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/image-quality-issues/",wrap:!1}}),Oe=new M({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),tt=new M({props:{title:"📚 Resources",local:"-resources",headingTag:"h3"}}),lt=new M({props:{title:"FiftyOne Open Source Project",local:"fiftyone-open-source-project",headingTag:"h2"}}),nt=new Wi({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/analyzing_art_with_hf_and_fiftyone.md"}}),{c(){y=n("meta"),ct=i(),pt=n("p"),dt=i(),m(j.$$.fragment),gt=i(),m(T.$$.fragment),yt=i(),C=n("p"),C.innerHTML=pl,Mt=i(),$=n("p"),$.innerHTML=ul,bt=i(),k=n("p"),k.textContent=hl,wt=i(),J=n("p"),J.innerHTML=fl,vt=i(),x=n("ul"),x.innerHTML=cl,jt=i(),m(U.$$.fragment),Tt=i(),_=n("p"),_.textContent=dl,Ct=i(),m(I.$$.fragment),$t=i(),W=n("p"),W.innerHTML=gl,kt=i(),m(Z.$$.fragment),Jt=i(),z=n("p"),z.innerHTML=yl,xt=i(),m(H.$$.fragment),Ut=i(),b=n("div"),b.innerHTML=Ml,_t=i(),q=n("p"),q.textContent=bl,It=i(),m(G.$$.fragment),Wt=i(),L=n("p"),L.innerHTML=wl,Zt=i(),m(F.$$.fragment),zt=i(),X=n("p"),X.textContent=vl,Ht=i(),m(R.$$.fragment),qt=i(),B=n("pre"),B.textContent=jl,Gt=i(),V=n("p"),V.innerHTML=Tl,Lt=i(),m(A.$$.fragment),Ft=i(),P=n("p"),P.innerHTML=Cl,Xt=i(),N=n("p"),N.textContent=$l,Rt=i(),m(Y.$$.fragment),Bt=i(),E=n("pre"),E.textContent=kl,Vt=i(),m(S.$$.fragment),At=i(),Q=n("p"),Q.textContent=Jl,Pt=i(),O=n("p"),O.innerHTML=xl,Nt=i(),m(D.$$.fragment),Yt=i(),K=n("pre"),K.textContent=Ul,Et=i(),g=n("div"),ot=n("p"),ot.textContent=_l,nl=i(),m(ee.$$.fragment),ol=i(),rt=n("p"),rt.innerHTML=Il,St=i(),te=n("p"),te.textContent=Wl,Qt=i(),se=n("p"),se.innerHTML=Zl,Ot=i(),le=n("p"),le.textContent=zl,Dt=i(),ie=n("p"),ie.textContent=Hl,Kt=i(),ae=n("p"),ae.innerHTML=ql,es=i(),ne=n("p"),ne.textContent=Gl,ts=i(),w=n("div"),w.innerHTML=Ll,ss=i(),m(oe.$$.fragment),ls=i(),re=n("p"),re.textContent=Fl,is=i(),me=n("p"),me.textContent=Xl,as=i(),pe=n("ol"),pe.innerHTML=Rl,ns=i(),ue=n("p"),ue.innerHTML=Bl,os=i(),m(he.$$.fragment),rs=i(),fe=n("pre"),fe.textContent=Vl,ms=i(),ce=n("p"),ce.textContent=Al,ps=i(),de=n("p"),de.innerHTML=Pl,us=i(),ge=n("p"),ge.innerHTML=Nl,hs=i(),m(ye.$$.fragment),fs=i(),Me=n("p"),Me.textContent=Yl,cs=i(),be=n("p"),be.textContent=El,ds=i(),we=n("p"),we.innerHTML=Sl,gs=i(),ve=n("p"),ve.textContent=Ql,ys=i(),m(je.$$.fragment),Ms=i(),Te=n("p"),Te.innerHTML=Ol,bs=i(),Ce=n("p"),Ce.innerHTML=Dl,ws=i(),m($e.$$.fragment),vs=i(),ke=n("pre"),ke.textContent=Kl,js=i(),Je=n("p"),Je.textContent=ei,Ts=i(),m(xe.$$.fragment),Cs=i(),Ue=n("p"),Ue.innerHTML=ti,$s=i(),m(_e.$$.fragment),ks=i(),Ie=n("p"),Ie.innerHTML=si,Js=i(),We=n("p"),We.textContent=li,xs=i(),m(Ze.$$.fragment),Us=i(),ze=n("pre"),ze.textContent=ii,_s=i(),He=n("p"),He.textContent=ai,Is=i(),m(qe.$$.fragment),Ws=i(),Ge=n("p"),Ge.innerHTML=ni,Zs=i(),m(Le.$$.fragment),zs=i(),Fe=n("p"),Fe.textContent=oi,Hs=i(),Xe=n("p"),Xe.innerHTML=ri,qs=i(),m(Re.$$.fragment),Gs=i(),Be=n("p"),Be.innerHTML=mi,Ls=i(),Ve=n("p"),Ve.innerHTML=pi,Fs=i(),Ae=n("p"),Ae.textContent=ui,Xs=i(),Pe=n("p"),Pe.innerHTML=hi,Rs=i(),Ne=n("p"),Ne.textContent=fi,Bs=i(),Ye=n("p"),Ye.innerHTML=ci,Vs=i(),Ee=n("p"),Ee.textContent=di,As=i(),Se=n("p"),Se.innerHTML=gi,Ps=i(),Qe=n("p"),Qe.textContent=yi,Ns=i(),v=n("div"),v.innerHTML=Mi,Ys=i(),m(Oe.$$.fragment),Es=i(),De=n("p"),De.innerHTML=bi,Ss=i(),Ke=n("p"),Ke.textContent=wi,Qs=i(),et=n("ul"),et.innerHTML=vi,Os=i(),m(tt.$$.fragment),Ds=i(),st=n("ul"),st.innerHTML=ji,Ks=i(),m(lt.$$.fragment),el=i(),it=n("p"),it.innerHTML=Ti,tl=i(),at=n("p"),at.innerHTML=Ci,sl=i(),m(nt.$$.fragment),ll=i(),ut=n("p"),this.h()},l(e){const t=_i("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),ct=a(e),pt=o(e,"P",{}),rl(pt).forEach(s),dt=a(e),p(j.$$.fragment,e),gt=a(e),p(T.$$.fragment,e),yt=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-c0uagn"&&(C.innerHTML=pl),Mt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1xzj7ip"&&($.innerHTML=ul),bt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1e7ek37"&&(k.textContent=hl),wt=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1iyj6t"&&(J.innerHTML=fl),vt=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1ag4oir"&&(x.innerHTML=cl),jt=a(e),p(U.$$.fragment,e),Tt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1qmzeog"&&(_.textContent=dl),Ct=a(e),p(I.$$.fragment,e),$t=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-x4dwdl"&&(W.innerHTML=gl),kt=a(e),p(Z.$$.fragment,e),Jt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-m5ur8v"&&(z.innerHTML=yl),xt=a(e),p(H.$$.fragment,e),Ut=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-plk5pn"&&(b.innerHTML=Ml),_t=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1o6b4mq"&&(q.textContent=bl),It=a(e),p(G.$$.fragment,e),Wt=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-12g0lsk"&&(L.innerHTML=wl),Zt=a(e),p(F.$$.fragment,e),zt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-127sumy"&&(X.textContent=vl),Ht=a(e),p(R.$$.fragment,e),qt=a(e),B=o(e,"PRE",{"data-svelte-h":!0}),r(B)!=="svelte-1odavx8"&&(B.textContent=jl),Gt=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vuii1o"&&(V.innerHTML=Tl),Lt=a(e),p(A.$$.fragment,e),Ft=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1cy8zue"&&(P.innerHTML=Cl),Xt=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1g82nj1"&&(N.textContent=$l),Rt=a(e),p(Y.$$.fragment,e),Bt=a(e),E=o(e,"PRE",{"data-svelte-h":!0}),r(E)!=="svelte-rh6f0n"&&(E.textContent=kl),Vt=a(e),p(S.$$.fragment,e),At=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-n0vei3"&&(Q.textContent=Jl),Pt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-suzdib"&&(O.innerHTML=xl),Nt=a(e),p(D.$$.fragment,e),Yt=a(e),K=o(e,"PRE",{"data-svelte-h":!0}),r(K)!=="svelte-mmre29"&&(K.textContent=Ul),Et=a(e),g=o(e,"DIV",{style:!0});var mt=rl(g);ot=o(mt,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1wi6mic"&&(ot.textContent=_l),nl=a(mt),p(ee.$$.fragment,mt),ol=a(mt),rt=o(mt,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-17feko9"&&(rt.innerHTML=Il),mt.forEach(s),St=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1tpltlf"&&(te.textContent=Wl),Qt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-w8rr2"&&(se.innerHTML=Zl),Ot=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-13ty9jr"&&(le.textContent=zl),Dt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1no06fa"&&(ie.textContent=Hl),Kt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-8ah19l"&&(ae.innerHTML=ql),es=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-5h5wzx"&&(ne.textContent=Gl),ts=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-18x11l8"&&(w.innerHTML=Ll),ss=a(e),p(oe.$$.fragment,e),ls=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1r77spf"&&(re.textContent=Fl),is=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1qcvkae"&&(me.textContent=Xl),as=a(e),pe=o(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-5zfsmn"&&(pe.innerHTML=Rl),ns=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-8r9m0o"&&(ue.innerHTML=Bl),os=a(e),p(he.$$.fragment,e),rs=a(e),fe=o(e,"PRE",{"data-svelte-h":!0}),r(fe)!=="svelte-bhg5yk"&&(fe.textContent=Vl),ms=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-87sjkb"&&(ce.textContent=Al),ps=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-guqvsc"&&(de.innerHTML=Pl),us=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-zs2wz8"&&(ge.innerHTML=Nl),hs=a(e),p(ye.$$.fragment,e),fs=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-s01bpa"&&(Me.textContent=Yl),cs=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-18xo104"&&(be.textContent=El),ds=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1ccs8bm"&&(we.innerHTML=Sl),gs=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-li7lmx"&&(ve.textContent=Ql),ys=a(e),p(je.$$.fragment,e),Ms=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-128i6zr"&&(Te.innerHTML=Ol),bs=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1k8dn9i"&&(Ce.innerHTML=Dl),ws=a(e),p($e.$$.fragment,e),vs=a(e),ke=o(e,"PRE",{"data-svelte-h":!0}),r(ke)!=="svelte-326il2"&&(ke.textContent=Kl),js=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1v04iac"&&(Je.textContent=ei),Ts=a(e),p(xe.$$.fragment,e),Cs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1tb2ntu"&&(Ue.innerHTML=ti),$s=a(e),p(_e.$$.fragment,e),ks=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1vqafg6"&&(Ie.innerHTML=si),Js=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wxy7d9"&&(We.textContent=li),xs=a(e),p(Ze.$$.fragment,e),Us=a(e),ze=o(e,"PRE",{"data-svelte-h":!0}),r(ze)!=="svelte-1n3row5"&&(ze.textContent=ii),_s=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1e52zeb"&&(He.textContent=ai),Is=a(e),p(qe.$$.fragment,e),Ws=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-13rc4gu"&&(Ge.innerHTML=ni),Zs=a(e),p(Le.$$.fragment,e),zs=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-9plt2b"&&(Fe.textContent=oi),Hs=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-43mgrp"&&(Xe.innerHTML=ri),qs=a(e),p(Re.$$.fragment,e),Gs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-11qfm07"&&(Be.innerHTML=mi),Ls=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ojjfuj"&&(Ve.innerHTML=pi),Fs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-10dfbs0"&&(Ae.textContent=ui),Xs=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1tiw0lq"&&(Pe.innerHTML=hi),Rs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-euuo6"&&(Ne.textContent=fi),Bs=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-b6ayaa"&&(Ye.innerHTML=ci),Vs=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1wg7oa8"&&(Ee.textContent=di),As=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1aj2nhz"&&(Se.innerHTML=gi),Ps=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1f4cd5i"&&(Qe.textContent=yi),Ns=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-126gsaj"&&(v.innerHTML=Mi),Ys=a(e),p(Oe.$$.fragment,e),Es=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ov7mgi"&&(De.innerHTML=bi),Ss=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-c0pn89"&&(Ke.textContent=wi),Qs=a(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-ryyicq"&&(et.innerHTML=vi),Os=a(e),p(tt.$$.fragment,e),Ds=a(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-752r11"&&(st.innerHTML=ji),Ks=a(e),p(lt.$$.fragment,e),el=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-mmnfnj"&&(it.innerHTML=Ti),tl=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1n8g4zz"&&(at.innerHTML=Ci),sl=a(e),p(nt.$$.fragment,e),ll=a(e),ut=o(e,"P",{}),rl(ut).forEach(s),this.h()},h(){ht(y,"name","hf:doc:metadata"),ht(y,"content",zi),ht(b,"class","alert alert-block alert-info"),al(g,"padding","10px"),al(g,"border-left","5px solid #0078d4"),al(g,"font-family","Arial, sans-serif"),al(g,"margin","10px 0"),ht(w,"class","alert alert-block alert-info"),ht(v,"class","alert alert-block alert-info")},m(e,t){ft(document.head,y),l(e,ct,t),l(e,pt,t),l(e,dt,t),u(j,e,t),l(e,gt,t),u(T,e,t),l(e,yt,t),l(e,C,t),l(e,Mt,t),l(e,$,t),l(e,bt,t),l(e,k,t),l(e,wt,t),l(e,J,t),l(e,vt,t),l(e,x,t),l(e,jt,t),u(U,e,t),l(e,Tt,t),l(e,_,t),l(e,Ct,t),u(I,e,t),l(e,$t,t),l(e,W,t),l(e,kt,t),u(Z,e,t),l(e,Jt,t),l(e,z,t),l(e,xt,t),u(H,e,t),l(e,Ut,t),l(e,b,t),l(e,_t,t),l(e,q,t),l(e,It,t),u(G,e,t),l(e,Wt,t),l(e,L,t),l(e,Zt,t),u(F,e,t),l(e,zt,t),l(e,X,t),l(e,Ht,t),u(R,e,t),l(e,qt,t),l(e,B,t),l(e,Gt,t),l(e,V,t),l(e,Lt,t),u(A,e,t),l(e,Ft,t),l(e,P,t),l(e,Xt,t),l(e,N,t),l(e,Rt,t),u(Y,e,t),l(e,Bt,t),l(e,E,t),l(e,Vt,t),u(S,e,t),l(e,At,t),l(e,Q,t),l(e,Pt,t),l(e,O,t),l(e,Nt,t),u(D,e,t),l(e,Yt,t),l(e,K,t),l(e,Et,t),l(e,g,t),ft(g,ot),ft(g,nl),u(ee,g,null),ft(g,ol),ft(g,rt),l(e,St,t),l(e,te,t),l(e,Qt,t),l(e,se,t),l(e,Ot,t),l(e,le,t),l(e,Dt,t),l(e,ie,t),l(e,Kt,t),l(e,ae,t),l(e,es,t),l(e,ne,t),l(e,ts,t),l(e,w,t),l(e,ss,t),u(oe,e,t),l(e,ls,t),l(e,re,t),l(e,is,t),l(e,me,t),l(e,as,t),l(e,pe,t),l(e,ns,t),l(e,ue,t),l(e,os,t),u(he,e,t),l(e,rs,t),l(e,fe,t),l(e,ms,t),l(e,ce,t),l(e,ps,t),l(e,de,t),l(e,us,t),l(e,ge,t),l(e,hs,t),u(ye,e,t),l(e,fs,t),l(e,Me,t),l(e,cs,t),l(e,be,t),l(e,ds,t),l(e,we,t),l(e,gs,t),l(e,ve,t),l(e,ys,t),u(je,e,t),l(e,Ms,t),l(e,Te,t),l(e,bs,t),l(e,Ce,t),l(e,ws,t),u($e,e,t),l(e,vs,t),l(e,ke,t),l(e,js,t),l(e,Je,t),l(e,Ts,t),u(xe,e,t),l(e,Cs,t),l(e,Ue,t),l(e,$s,t),u(_e,e,t),l(e,ks,t),l(e,Ie,t),l(e,Js,t),l(e,We,t),l(e,xs,t),u(Ze,e,t),l(e,Us,t),l(e,ze,t),l(e,_s,t),l(e,He,t),l(e,Is,t),u(qe,e,t),l(e,Ws,t),l(e,Ge,t),l(e,Zs,t),u(Le,e,t),l(e,zs,t),l(e,Fe,t),l(e,Hs,t),l(e,Xe,t),l(e,qs,t),u(Re,e,t),l(e,Gs,t),l(e,Be,t),l(e,Ls,t),l(e,Ve,t),l(e,Fs,t),l(e,Ae,t),l(e,Xs,t),l(e,Pe,t),l(e,Rs,t),l(e,Ne,t),l(e,Bs,t),l(e,Ye,t),l(e,Vs,t),l(e,Ee,t),l(e,As,t),l(e,Se,t),l(e,Ps,t),l(e,Qe,t),l(e,Ns,t),l(e,v,t),l(e,Ys,t),u(Oe,e,t),l(e,Es,t),l(e,De,t),l(e,Ss,t),l(e,Ke,t),l(e,Qs,t),l(e,et,t),l(e,Os,t),u(tt,e,t),l(e,Ds,t),l(e,st,t),l(e,Ks,t),u(lt,e,t),l(e,el,t),l(e,it,t),l(e,tl,t),l(e,at,t),l(e,sl,t),u(nt,e,t),l(e,ll,t),l(e,ut,t),il=!0},p:ki,i(e){il||(h(j.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(Z.$$.fragment,e),h(H.$$.fragment,e),h(G.$$.fragment,e),h(F.$$.fragment,e),h(R.$$.fragment,e),h(A.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(xe.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(Re.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(nt.$$.fragment,e),il=!0)},o(e){f(j.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(Z.$$.fragment,e),f(H.$$.fragment,e),f(G.$$.fragment,e),f(F.$$.fragment,e),f(R.$$.fragment,e),f(A.$$.fragment,e),f(Y.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(_e.$$.fragment,e),f(Ze.$$.fragment,e),f(qe.$$.fragment,e),f(Le.$$.fragment,e),f(Re.$$.fragment,e),f(Oe.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(nt.$$.fragment,e),il=!1},d(e){e&&(s(ct),s(pt),s(dt),s(gt),s(yt),s(C),s(Mt),s($),s(bt),s(k),s(wt),s(J),s(vt),s(x),s(jt),s(Tt),s(_),s(Ct),s($t),s(W),s(kt),s(Jt),s(z),s(xt),s(Ut),s(b),s(_t),s(q),s(It),s(Wt),s(L),s(Zt),s(zt),s(X),s(Ht),s(qt),s(B),s(Gt),s(V),s(Lt),s(Ft),s(P),s(Xt),s(N),s(Rt),s(Bt),s(E),s(Vt),s(At),s(Q),s(Pt),s(O),s(Nt),s(Yt),s(K),s(Et),s(g),s(St),s(te),s(Qt),s(se),s(Ot),s(le),s(Dt),s(ie),s(Kt),s(ae),s(es),s(ne),s(ts),s(w),s(ss),s(ls),s(re),s(is),s(me),s(as),s(pe),s(ns),s(ue),s(os),s(rs),s(fe),s(ms),s(ce),s(ps),s(de),s(us),s(ge),s(hs),s(fs),s(Me),s(cs),s(be),s(ds),s(we),s(gs),s(ve),s(ys),s(Ms),s(Te),s(bs),s(Ce),s(ws),s(vs),s(ke),s(js),s(Je),s(Ts),s(Cs),s(Ue),s($s),s(ks),s(Ie),s(Js),s(We),s(xs),s(Us),s(ze),s(_s),s(He),s(Is),s(Ws),s(Ge),s(Zs),s(zs),s(Fe),s(Hs),s(Xe),s(qs),s(Gs),s(Be),s(Ls),s(Ve),s(Fs),s(Ae),s(Xs),s(Pe),s(Rs),s(Ne),s(Bs),s(Ye),s(Vs),s(Ee),s(As),s(Se),s(Ps),s(Qe),s(Ns),s(v),s(Ys),s(Es),s(De),s(Ss),s(Ke),s(Qs),s(et),s(Os),s(Ds),s(st),s(Ks),s(el),s(it),s(tl),s(at),s(sl),s(ll),s(ut)),s(y),c(j,e),c(T,e),c(U,e),c(I,e),c(Z,e),c(H,e),c(G,e),c(F,e),c(R,e),c(A,e),c(Y,e),c(S,e),c(D,e),c(ee),c(oe,e),c(he,e),c(ye,e),c(je,e),c($e,e),c(xe,e),c(_e,e),c(Ze,e),c(qe,e),c(Le,e),c(Re,e),c(Oe,e),c(tt,e),c(lt,e),c(nt,e)}}}const zi='{"title":"Analyzing Artistic Styles with Multimodal Embeddings","local":"analyzing-artistic-styles-with-multimodal-embeddings","sections":[{"title":"Let’s get started! 🚀","local":"lets-get-started-","sections":[],"depth":2},{"title":"Finding Similar Artwork","local":"finding-similar-artwork","sections":[],"depth":2},{"title":"Uncovering Artistic Motifs with Clustering and Visualization","local":"uncovering-artistic-motifs-with-clustering-and-visualization","sections":[],"depth":2},{"title":"Identifying the Most Unique Works of Art","local":"identifying-the-most-unique-works-of-art","sections":[],"depth":2},{"title":"Characterizing Art with Visual Qualities","local":"characterizing-art-with-visual-qualities","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[{"title":"📚 Resources","local":"-resources","sections":[],"depth":3}],"depth":2},{"title":"FiftyOne Open Source Project","local":"fiftyone-open-source-project","sections":[],"depth":2}],"depth":1}';function Hi(ml){return Ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xi extends xi{constructor(y){super(),Ui(this,y,Hi,Zi,$i,{})}}export{Xi as component};
