import{s as us,n as ms,o as fs}from"../chunks/scheduler.0219f8bd.js";import{S as ps,i as hs,g as i,s as a,r as m,A as cs,h as o,f as l,c as d,j as u,u as f,x as s,k as n,y as Ts,a as r,v as p,d as h,t as c,w as T}from"../chunks/index.f61edf3b.js";import{H as y,E as ys}from"../chunks/EditOnGithub.48fa589f.js";function vs(xi){let v,Tl,hl,yl,_,vl,F,_l,b,$i="Helper module for mathematical processing.",Fl,x,Ai=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,bl,$,Pi='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.permute_data"><code>.permute_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.bankers_round"><code>.bankers_round(x)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.dynamic_time_warping"><code>.dynamic_time_warping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',xl,$l,Al,A,Pl,P,Cl,C,Ci='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Hl,H,Hi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Ll,Ml,wl,L,gl,M,El,w,Li="Helper method to permute a <code>AnyTypedArray</code> directly",Rl,g,Mi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The permuted array and the new shape.',zl,E,wi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",kl,Kl,Ol,R,jl,z,Bl,k,gi="Compute the softmax of an array of numbers.",Dl,K,Ei='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Ul,O,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Il,ql,Nl,j,Sl,B,Gl,D,zi="Calculates the logarithm of the softmax function for the input array.",Jl,U,ki='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Ql,I,Ki="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Vl,Wl,Xl,q,Yl,N,Zl,S,Oi="Calculates the dot product of two arrays.",tr,G,ji='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',er,J,Bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",lr,rr,ar,Q,dr,V,ir,W,Di="Computes the cosine similarity between two arrays.",or,X,Ui='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',sr,Y,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",nr,ur,mr,Z,fr,tt,pr,et,qi="Calculates the magnitude of a given array.",hr,lt,Ni='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',cr,rt,Si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",Tr,yr,vr,at,_r,dt,Fr,it,Gi="Returns the value and index of the minimum element in an array.",br,ot,Ji='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',xr,st,Qi="<li><code>Error</code> If array is empty.</li>",$r,nt,Vi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Ar,Pr,Cr,ut,Hr,mt,Lr,ft,Wi="Returns the value and index of the maximum element in an array.",Mr,pt,Xi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',wr,ht,Yi="<li><code>Error</code> If array is empty.</li>",gr,ct,Zi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Er,Rr,zr,Tt,kr,yt,Kr,vt,to="Performs median filter on the provided data. Padding is done by mirroring the data.",Or,_t,eo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',jr,Ft,lo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Br,Dr,Ur,bt,Ir,xt,qr,$t,ro="Helper function to round a number to a given number of decimals",Nr,At,ao='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Sr,Pt,io="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Gr,Jr,Qr,Ct,Vr,Ht,Wr,Lt,oo=`Helper function to round a number to the nearest integer, with ties rounded to the nearest even number.
Also known as “bankers’ rounding”. This is the default rounding mode in python. For example:
1.5 rounds to 2 and 2.5 rounds to 2.`,Xr,Mt,so='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Yr,wt,no="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>number</code></td><td><p>The number to round</p></td></tr></tbody>",Zr,ta,ea,gt,la,Et,ra,Rt,uo=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,aa,zt,mo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',da,kt,fo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td></tr></tbody>",ia,oa,sa,Kt,na,Ot,ua,jt,po="Implementation of Radix-4 FFT.",ma,Bt,ho=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,fa,Dt,co='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',pa,Ut,To='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',ha,ca,Ta,It,ya,qt,va,Nt,yo="<strong>Throws</strong>:",_a,St,vo="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",Fa,Gt,_o="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",ba,xa,$a,Jt,Aa,Qt,Pa,Vt,Fo="Create a complex number array with size <code>2 * size</code>",Ca,Wt,bo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Ha,La,Ma,Xt,wa,Yt,ga,Zt,xo="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Ea,te,$o='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Ra,ee,Ao="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",za,ka,Ka,le,Oa,re,ja,ae,Po="Convert a real-valued input array to a complex-valued output array.",Ba,de,Co='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Da,ie,Ho="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Ua,Ia,qa,oe,Na,se,Sa,ne,Lo="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",Ga,ue,Mo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Ja,me,wo="<li><code>Error</code> Input and output buffers must be different.</li>",Qa,fe,go="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Va,Wa,Xa,pe,Ya,he,Za,ce,Eo=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,td,Te,Ro='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ed,ye,zo="<li><code>Error</code> If the input and output buffers are the same.</li>",ld,ve,ko="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",rd,ad,dd,_e,id,Fe,od,be,Ko=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,sd,xe,Oo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',nd,$e,jo="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",ud,Ae,Bo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",md,fd,pd,Pe,hd,Ce,cd,He,Do="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",Td,Le,Uo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',yd,Me,Io="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",vd,_d,Fd,we,bd,ge,xd,Ee,qo="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",$d,Re,No='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ad,ze,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Pd,Cd,Hd,ke,Ld,Ke,Md,Oe,Go="Performs radix-4 transformation on input data of length 8",wd,je,Jo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',gd,Be,Qo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",Ed,Rd,zd,De,kd,Ue,Kd,Ie,Vo="Real input radix-4 implementation",Od,qe,Wo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',jd,Ne,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Bd,Dd,Ud,Se,Id,Ge,qd,Je,Yo="Performs a single real input radix-2 transformation on the provided data",Nd,Qe,Zo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Sd,Ve,ts="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",Gd,Jd,Qd,We,Vd,Xe,Wd,Ye,es=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Xd,Ze,ls='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Yd,tl,rs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Zd,ti,ei,el,li,ll,ri,rl,as=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,ai,al,ds='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',di,dl,is='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',ii,oi,si,il,ni,ol,ui,sl,os="Constructs a new NP2FFT object.",mi,nl,ss="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",fi,pi,hi,ul,ci,ml,Ti,fl,ns='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',yi,vi,_i,pl,Fi,cl,bi;return F=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),P=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathspermutedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),B=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),N=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),dt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),mt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),yt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.bankers_round(x) ⇒ <code> number </code>",local:"utilsmathsbankersroundx--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths.dynamic_time_warping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilsmathsdynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),Ot=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),qt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),Qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),re=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),he=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),Fe=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Ue=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),ll=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),ol=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),ml=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),pl=new ys({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/maths.md"}}),{c(){v=i("meta"),Tl=a(),hl=i("p"),yl=a(),_=i("a"),vl=a(),m(F.$$.fragment),_l=a(),b=i("p"),b.textContent=$i,Fl=a(),x=i("p"),x.textContent=Ai,bl=a(),$=i("ul"),$.innerHTML=Pi,xl=a(),$l=i("hr"),Al=a(),A=i("a"),Pl=a(),m(P.$$.fragment),Cl=a(),C=i("p"),C.innerHTML=Ci,Hl=a(),H=i("table"),H.innerHTML=Hi,Ll=a(),Ml=i("hr"),wl=a(),L=i("a"),gl=a(),m(M.$$.fragment),El=a(),w=i("p"),w.innerHTML=Li,Rl=a(),g=i("p"),g.innerHTML=Mi,zl=a(),E=i("table"),E.innerHTML=wi,kl=a(),Kl=i("hr"),Ol=a(),R=i("a"),jl=a(),m(z.$$.fragment),Bl=a(),k=i("p"),k.textContent=gi,Dl=a(),K=i("p"),K.innerHTML=Ei,Ul=a(),O=i("table"),O.innerHTML=Ri,Il=a(),ql=i("hr"),Nl=a(),j=i("a"),Sl=a(),m(B.$$.fragment),Gl=a(),D=i("p"),D.textContent=zi,Jl=a(),U=i("p"),U.innerHTML=ki,Ql=a(),I=i("table"),I.innerHTML=Ki,Vl=a(),Wl=i("hr"),Xl=a(),q=i("a"),Yl=a(),m(N.$$.fragment),Zl=a(),S=i("p"),S.textContent=Oi,tr=a(),G=i("p"),G.innerHTML=ji,er=a(),J=i("table"),J.innerHTML=Bi,lr=a(),rr=i("hr"),ar=a(),Q=i("a"),dr=a(),m(V.$$.fragment),ir=a(),W=i("p"),W.textContent=Di,or=a(),X=i("p"),X.innerHTML=Ui,sr=a(),Y=i("table"),Y.innerHTML=Ii,nr=a(),ur=i("hr"),mr=a(),Z=i("a"),fr=a(),m(tt.$$.fragment),pr=a(),et=i("p"),et.textContent=qi,hr=a(),lt=i("p"),lt.innerHTML=Ni,cr=a(),rt=i("table"),rt.innerHTML=Si,Tr=a(),yr=i("hr"),vr=a(),at=i("a"),_r=a(),m(dt.$$.fragment),Fr=a(),it=i("p"),it.textContent=Gi,br=a(),ot=i("p"),ot.innerHTML=Ji,xr=a(),st=i("ul"),st.innerHTML=Qi,$r=a(),nt=i("table"),nt.innerHTML=Vi,Ar=a(),Pr=i("hr"),Cr=a(),ut=i("a"),Hr=a(),m(mt.$$.fragment),Lr=a(),ft=i("p"),ft.textContent=Wi,Mr=a(),pt=i("p"),pt.innerHTML=Xi,wr=a(),ht=i("ul"),ht.innerHTML=Yi,gr=a(),ct=i("table"),ct.innerHTML=Zi,Er=a(),Rr=i("hr"),zr=a(),Tt=i("a"),kr=a(),m(yt.$$.fragment),Kr=a(),vt=i("p"),vt.textContent=to,Or=a(),_t=i("p"),_t.innerHTML=eo,jr=a(),Ft=i("table"),Ft.innerHTML=lo,Br=a(),Dr=i("hr"),Ur=a(),bt=i("a"),Ir=a(),m(xt.$$.fragment),qr=a(),$t=i("p"),$t.textContent=ro,Nr=a(),At=i("p"),At.innerHTML=ao,Sr=a(),Pt=i("table"),Pt.innerHTML=io,Gr=a(),Jr=i("hr"),Qr=a(),Ct=i("a"),Vr=a(),m(Ht.$$.fragment),Wr=a(),Lt=i("p"),Lt.textContent=oo,Xr=a(),Mt=i("p"),Mt.innerHTML=so,Yr=a(),wt=i("table"),wt.innerHTML=no,Zr=a(),ta=i("hr"),ea=a(),gt=i("a"),la=a(),m(Et.$$.fragment),ra=a(),Rt=i("p"),Rt.textContent=uo,aa=a(),zt=i("p"),zt.innerHTML=mo,da=a(),kt=i("table"),kt.innerHTML=fo,ia=a(),oa=i("hr"),sa=a(),Kt=i("a"),na=a(),m(Ot.$$.fragment),ua=a(),jt=i("p"),jt.textContent=po,ma=a(),Bt=i("p"),Bt.innerHTML=ho,fa=a(),Dt=i("p"),Dt.innerHTML=co,pa=a(),Ut=i("ul"),Ut.innerHTML=To,ha=a(),ca=i("hr"),Ta=a(),It=i("a"),ya=a(),m(qt.$$.fragment),va=a(),Nt=i("p"),Nt.innerHTML=yo,_a=a(),St=i("ul"),St.innerHTML=vo,Fa=a(),Gt=i("table"),Gt.innerHTML=_o,ba=a(),xa=i("hr"),$a=a(),Jt=i("a"),Aa=a(),m(Qt.$$.fragment),Pa=a(),Vt=i("p"),Vt.innerHTML=Fo,Ca=a(),Wt=i("p"),Wt.innerHTML=bo,Ha=a(),La=i("hr"),Ma=a(),Xt=i("a"),wa=a(),m(Yt.$$.fragment),ga=a(),Zt=i("p"),Zt.textContent=xo,Ea=a(),te=i("p"),te.innerHTML=$o,Ra=a(),ee=i("table"),ee.innerHTML=Ao,za=a(),ka=i("hr"),Ka=a(),le=i("a"),Oa=a(),m(re.$$.fragment),ja=a(),ae=i("p"),ae.textContent=Po,Ba=a(),de=i("p"),de.innerHTML=Co,Da=a(),ie=i("table"),ie.innerHTML=Ho,Ua=a(),Ia=i("hr"),qa=a(),oe=i("a"),Na=a(),m(se.$$.fragment),Sa=a(),ne=i("p"),ne.textContent=Lo,Ga=a(),ue=i("p"),ue.innerHTML=Mo,Ja=a(),me=i("ul"),me.innerHTML=wo,Qa=a(),fe=i("table"),fe.innerHTML=go,Va=a(),Wa=i("hr"),Xa=a(),pe=i("a"),Ya=a(),m(he.$$.fragment),Za=a(),ce=i("p"),ce.textContent=Eo,td=a(),Te=i("p"),Te.innerHTML=Ro,ed=a(),ye=i("ul"),ye.innerHTML=zo,ld=a(),ve=i("table"),ve.innerHTML=ko,rd=a(),ad=i("hr"),dd=a(),_e=i("a"),id=a(),m(Fe.$$.fragment),od=a(),be=i("p"),be.innerHTML=Ko,sd=a(),xe=i("p"),xe.innerHTML=Oo,nd=a(),$e=i("ul"),$e.innerHTML=jo,ud=a(),Ae=i("table"),Ae.innerHTML=Bo,md=a(),fd=i("hr"),pd=a(),Pe=i("a"),hd=a(),m(Ce.$$.fragment),cd=a(),He=i("p"),He.textContent=Do,Td=a(),Le=i("p"),Le.innerHTML=Uo,yd=a(),Me=i("table"),Me.innerHTML=Io,vd=a(),_d=i("hr"),Fd=a(),we=i("a"),bd=a(),m(ge.$$.fragment),xd=a(),Ee=i("p"),Ee.textContent=qo,$d=a(),Re=i("p"),Re.innerHTML=No,Ad=a(),ze=i("table"),ze.innerHTML=So,Pd=a(),Cd=i("hr"),Hd=a(),ke=i("a"),Ld=a(),m(Ke.$$.fragment),Md=a(),Oe=i("p"),Oe.textContent=Go,wd=a(),je=i("p"),je.innerHTML=Jo,gd=a(),Be=i("table"),Be.innerHTML=Qo,Ed=a(),Rd=i("hr"),zd=a(),De=i("a"),kd=a(),m(Ue.$$.fragment),Kd=a(),Ie=i("p"),Ie.textContent=Vo,Od=a(),qe=i("p"),qe.innerHTML=Wo,jd=a(),Ne=i("table"),Ne.innerHTML=Xo,Bd=a(),Dd=i("hr"),Ud=a(),Se=i("a"),Id=a(),m(Ge.$$.fragment),qd=a(),Je=i("p"),Je.textContent=Yo,Nd=a(),Qe=i("p"),Qe.innerHTML=Zo,Sd=a(),Ve=i("table"),Ve.innerHTML=ts,Gd=a(),Jd=i("hr"),Qd=a(),We=i("a"),Vd=a(),m(Xe.$$.fragment),Wd=a(),Ye=i("p"),Ye.textContent=es,Xd=a(),Ze=i("p"),Ze.innerHTML=ls,Yd=a(),tl=i("table"),tl.innerHTML=rs,Zd=a(),ti=i("hr"),ei=a(),el=i("a"),li=a(),m(ll.$$.fragment),ri=a(),rl=i("p"),rl.textContent=as,ai=a(),al=i("p"),al.innerHTML=ds,di=a(),dl=i("p"),dl.innerHTML=is,ii=a(),oi=i("hr"),si=a(),il=i("a"),ni=a(),m(ol.$$.fragment),ui=a(),sl=i("p"),sl.textContent=os,mi=a(),nl=i("table"),nl.innerHTML=ss,fi=a(),pi=i("hr"),hi=a(),ul=i("a"),ci=a(),m(ml.$$.fragment),Ti=a(),fl=i("p"),fl.innerHTML=ns,yi=a(),vi=i("hr"),_i=a(),m(pl.$$.fragment),Fi=a(),cl=i("p"),this.h()},l(t){const e=cs("svelte-u9bgzb",document.head);v=o(e,"META",{name:!0,content:!0}),e.forEach(l),Tl=d(t),hl=o(t,"P",{}),u(hl).forEach(l),yl=d(t),_=o(t,"A",{id:!0,class:!0}),u(_).forEach(l),vl=d(t),f(F.$$.fragment,t),_l=d(t),b=o(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=$i),Fl=d(t),x=o(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=Ai),bl=d(t),$=o(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-c7mf1w"&&($.innerHTML=Pi),xl=d(t),$l=o(t,"HR",{}),Al=d(t),A=o(t,"A",{id:!0,class:!0}),u(A).forEach(l),Pl=d(t),f(P.$$.fragment,t),Cl=d(t),C=o(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=Ci),Hl=d(t),H=o(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Hi),Ll=d(t),Ml=o(t,"HR",{}),wl=d(t),L=o(t,"A",{id:!0,class:!0}),u(L).forEach(l),gl=d(t),f(M.$$.fragment,t),El=d(t),w=o(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-1b1asvx"&&(w.innerHTML=Li),Rl=d(t),g=o(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-pth1sg"&&(g.innerHTML=Mi),zl=d(t),E=o(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=wi),kl=d(t),Kl=o(t,"HR",{}),Ol=d(t),R=o(t,"A",{id:!0,class:!0}),u(R).forEach(l),jl=d(t),f(z.$$.fragment,t),Bl=d(t),k=o(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=gi),Dl=d(t),K=o(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=Ei),Ul=d(t),O=o(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-adoxzf"&&(O.innerHTML=Ri),Il=d(t),ql=o(t,"HR",{}),Nl=d(t),j=o(t,"A",{id:!0,class:!0}),u(j).forEach(l),Sl=d(t),f(B.$$.fragment,t),Gl=d(t),D=o(t,"P",{"data-svelte-h":!0}),s(D)!=="svelte-5479oq"&&(D.textContent=zi),Jl=d(t),U=o(t,"P",{"data-svelte-h":!0}),s(U)!=="svelte-m9boyl"&&(U.innerHTML=ki),Ql=d(t),I=o(t,"TABLE",{"data-svelte-h":!0}),s(I)!=="svelte-5wetzk"&&(I.innerHTML=Ki),Vl=d(t),Wl=o(t,"HR",{}),Xl=d(t),q=o(t,"A",{id:!0,class:!0}),u(q).forEach(l),Yl=d(t),f(N.$$.fragment,t),Zl=d(t),S=o(t,"P",{"data-svelte-h":!0}),s(S)!=="svelte-1kaf4lx"&&(S.textContent=Oi),tr=d(t),G=o(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=ji),er=d(t),J=o(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Bi),lr=d(t),rr=o(t,"HR",{}),ar=d(t),Q=o(t,"A",{id:!0,class:!0}),u(Q).forEach(l),dr=d(t),f(V.$$.fragment,t),ir=d(t),W=o(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-6quqqj"&&(W.textContent=Di),or=d(t),X=o(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-1y45k06"&&(X.innerHTML=Ui),sr=d(t),Y=o(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-nyqk4k"&&(Y.innerHTML=Ii),nr=d(t),ur=o(t,"HR",{}),mr=d(t),Z=o(t,"A",{id:!0,class:!0}),u(Z).forEach(l),fr=d(t),f(tt.$$.fragment,t),pr=d(t),et=o(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-132v21g"&&(et.textContent=qi),hr=d(t),lt=o(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-odriss"&&(lt.innerHTML=Ni),cr=d(t),rt=o(t,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-nbo00i"&&(rt.innerHTML=Si),Tr=d(t),yr=o(t,"HR",{}),vr=d(t),at=o(t,"A",{id:!0,class:!0}),u(at).forEach(l),_r=d(t),f(dt.$$.fragment,t),Fr=d(t),it=o(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-67h0u1"&&(it.textContent=Gi),br=d(t),ot=o(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-cs0f6n"&&(ot.innerHTML=Ji),xr=d(t),st=o(t,"UL",{"data-svelte-h":!0}),s(st)!=="svelte-jusv8t"&&(st.innerHTML=Qi),$r=d(t),nt=o(t,"TABLE",{"data-svelte-h":!0}),s(nt)!=="svelte-mtkj0x"&&(nt.innerHTML=Vi),Ar=d(t),Pr=o(t,"HR",{}),Cr=d(t),ut=o(t,"A",{id:!0,class:!0}),u(ut).forEach(l),Hr=d(t),f(mt.$$.fragment,t),Lr=d(t),ft=o(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-9vv4b"&&(ft.textContent=Wi),Mr=d(t),pt=o(t,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-1ixuuwb"&&(pt.innerHTML=Xi),wr=d(t),ht=o(t,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-jusv8t"&&(ht.innerHTML=Yi),gr=d(t),ct=o(t,"TABLE",{"data-svelte-h":!0}),s(ct)!=="svelte-oriydz"&&(ct.innerHTML=Zi),Er=d(t),Rr=o(t,"HR",{}),zr=d(t),Tt=o(t,"A",{id:!0,class:!0}),u(Tt).forEach(l),kr=d(t),f(yt.$$.fragment,t),Kr=d(t),vt=o(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-xb1vdd"&&(vt.textContent=to),Or=d(t),_t=o(t,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-z8esp"&&(_t.innerHTML=eo),jr=d(t),Ft=o(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-pk7ooi"&&(Ft.innerHTML=lo),Br=d(t),Dr=o(t,"HR",{}),Ur=d(t),bt=o(t,"A",{id:!0,class:!0}),u(bt).forEach(l),Ir=d(t),f(xt.$$.fragment,t),qr=d(t),$t=o(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-11aka64"&&($t.textContent=ro),Nr=d(t),At=o(t,"P",{"data-svelte-h":!0}),s(At)!=="svelte-jttckh"&&(At.innerHTML=ao),Sr=d(t),Pt=o(t,"TABLE",{"data-svelte-h":!0}),s(Pt)!=="svelte-c6gnt1"&&(Pt.innerHTML=io),Gr=d(t),Jr=o(t,"HR",{}),Qr=d(t),Ct=o(t,"A",{id:!0,class:!0}),u(Ct).forEach(l),Vr=d(t),f(Ht.$$.fragment,t),Wr=d(t),Lt=o(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1xjiy33"&&(Lt.textContent=oo),Xr=d(t),Mt=o(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=so),Yr=d(t),wt=o(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-1uj9e15"&&(wt.innerHTML=no),Zr=d(t),ta=o(t,"HR",{}),ea=d(t),gt=o(t,"A",{id:!0,class:!0}),u(gt).forEach(l),la=d(t),f(Et.$$.fragment,t),ra=d(t),Rt=o(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-kcewlk"&&(Rt.textContent=uo),aa=d(t),zt=o(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-z8esp"&&(zt.innerHTML=mo),da=d(t),kt=o(t,"TABLE",{"data-svelte-h":!0}),s(kt)!=="svelte-1ivru5g"&&(kt.innerHTML=fo),ia=d(t),oa=o(t,"HR",{}),sa=d(t),Kt=o(t,"A",{id:!0,class:!0}),u(Kt).forEach(l),na=d(t),f(Ot.$$.fragment,t),ua=d(t),jt=o(t,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-16m1u76"&&(jt.textContent=po),ma=d(t),Bt=o(t,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-698ey0"&&(Bt.innerHTML=ho),fa=d(t),Dt=o(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-tjke50"&&(Dt.innerHTML=co),pa=d(t),Ut=o(t,"UL",{"data-svelte-h":!0}),s(Ut)!=="svelte-19h6qj3"&&(Ut.innerHTML=To),ha=d(t),ca=o(t,"HR",{}),Ta=d(t),It=o(t,"A",{id:!0,class:!0}),u(It).forEach(l),ya=d(t),f(qt.$$.fragment,t),va=d(t),Nt=o(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1fz4yns"&&(Nt.innerHTML=yo),_a=d(t),St=o(t,"UL",{"data-svelte-h":!0}),s(St)!=="svelte-ph0ovr"&&(St.innerHTML=vo),Fa=d(t),Gt=o(t,"TABLE",{"data-svelte-h":!0}),s(Gt)!=="svelte-a5vdxc"&&(Gt.innerHTML=_o),ba=d(t),xa=o(t,"HR",{}),$a=d(t),Jt=o(t,"A",{id:!0,class:!0}),u(Jt).forEach(l),Aa=d(t),f(Qt.$$.fragment,t),Pa=d(t),Vt=o(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1rrw4ya"&&(Vt.innerHTML=Fo),Ca=d(t),Wt=o(t,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1gdnoew"&&(Wt.innerHTML=bo),Ha=d(t),La=o(t,"HR",{}),Ma=d(t),Xt=o(t,"A",{id:!0,class:!0}),u(Xt).forEach(l),wa=d(t),f(Yt.$$.fragment,t),ga=d(t),Zt=o(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1693r4v"&&(Zt.textContent=xo),Ea=d(t),te=o(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-33y4ax"&&(te.innerHTML=$o),Ra=d(t),ee=o(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1td0xj2"&&(ee.innerHTML=Ao),za=d(t),ka=o(t,"HR",{}),Ka=d(t),le=o(t,"A",{id:!0,class:!0}),u(le).forEach(l),Oa=d(t),f(re.$$.fragment,t),ja=d(t),ae=o(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-rsnsrd"&&(ae.textContent=Po),Ba=d(t),de=o(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1xayhm7"&&(de.innerHTML=Co),Da=d(t),ie=o(t,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-1up5toh"&&(ie.innerHTML=Ho),Ua=d(t),Ia=o(t,"HR",{}),qa=d(t),oe=o(t,"A",{id:!0,class:!0}),u(oe).forEach(l),Na=d(t),f(se.$$.fragment,t),Sa=d(t),ne=o(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-846pp1"&&(ne.textContent=Lo),Ga=d(t),ue=o(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1t2xajz"&&(ue.innerHTML=Mo),Ja=d(t),me=o(t,"UL",{"data-svelte-h":!0}),s(me)!=="svelte-173tqd8"&&(me.innerHTML=wo),Qa=d(t),fe=o(t,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-1buvx7j"&&(fe.innerHTML=go),Va=d(t),Wa=o(t,"HR",{}),Xa=d(t),pe=o(t,"A",{id:!0,class:!0}),u(pe).forEach(l),Ya=d(t),f(he.$$.fragment,t),Za=d(t),ce=o(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-ozshoc"&&(ce.textContent=Eo),td=d(t),Te=o(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1t2xajz"&&(Te.innerHTML=Ro),ed=d(t),ye=o(t,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-1ap3720"&&(ye.innerHTML=zo),ld=d(t),ve=o(t,"TABLE",{"data-svelte-h":!0}),s(ve)!=="svelte-lghmn6"&&(ve.innerHTML=ko),rd=d(t),ad=o(t,"HR",{}),dd=d(t),_e=o(t,"A",{id:!0,class:!0}),u(_e).forEach(l),id=d(t),f(Fe.$$.fragment,t),od=d(t),be=o(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-ijignt"&&(be.innerHTML=Ko),sd=d(t),xe=o(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1t2xajz"&&(xe.innerHTML=Oo),nd=d(t),$e=o(t,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-1bp21xg"&&($e.innerHTML=jo),ud=d(t),Ae=o(t,"TABLE",{"data-svelte-h":!0}),s(Ae)!=="svelte-edt5vq"&&(Ae.innerHTML=Bo),md=d(t),fd=o(t,"HR",{}),pd=d(t),Pe=o(t,"A",{id:!0,class:!0}),u(Pe).forEach(l),hd=d(t),f(Ce.$$.fragment,t),cd=d(t),He=o(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-3r4wxn"&&(He.textContent=Do),Td=d(t),Le=o(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Uo),yd=d(t),Me=o(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-15z8087"&&(Me.innerHTML=Io),vd=d(t),_d=o(t,"HR",{}),Fd=d(t),we=o(t,"A",{id:!0,class:!0}),u(we).forEach(l),bd=d(t),f(ge.$$.fragment,t),xd=d(t),Ee=o(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1jz5wqp"&&(Ee.textContent=qo),$d=d(t),Re=o(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=No),Ad=d(t),ze=o(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-fx5ob"&&(ze.innerHTML=So),Pd=d(t),Cd=o(t,"HR",{}),Hd=d(t),ke=o(t,"A",{id:!0,class:!0}),u(ke).forEach(l),Ld=d(t),f(Ke.$$.fragment,t),Md=d(t),Oe=o(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1baynqa"&&(Oe.textContent=Go),wd=d(t),je=o(t,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1dkdszr"&&(je.innerHTML=Jo),gd=d(t),Be=o(t,"TABLE",{"data-svelte-h":!0}),s(Be)!=="svelte-szv30n"&&(Be.innerHTML=Qo),Ed=d(t),Rd=o(t,"HR",{}),zd=d(t),De=o(t,"A",{id:!0,class:!0}),u(De).forEach(l),kd=d(t),f(Ue.$$.fragment,t),Kd=d(t),Ie=o(t,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-1gll44b"&&(Ie.textContent=Vo),Od=d(t),qe=o(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=Wo),jd=d(t),Ne=o(t,"TABLE",{"data-svelte-h":!0}),s(Ne)!=="svelte-159qhrx"&&(Ne.innerHTML=Xo),Bd=d(t),Dd=o(t,"HR",{}),Ud=d(t),Se=o(t,"A",{id:!0,class:!0}),u(Se).forEach(l),Id=d(t),f(Ge.$$.fragment,t),qd=d(t),Je=o(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1upf1p8"&&(Je.textContent=Yo),Nd=d(t),Qe=o(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Zo),Sd=d(t),Ve=o(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-18nciet"&&(Ve.innerHTML=ts),Gd=d(t),Jd=o(t,"HR",{}),Qd=d(t),We=o(t,"A",{id:!0,class:!0}),u(We).forEach(l),Vd=d(t),f(Xe.$$.fragment,t),Wd=d(t),Ye=o(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-8fqhv2"&&(Ye.textContent=es),Xd=d(t),Ze=o(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=ls),Yd=d(t),tl=o(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-pf887e"&&(tl.innerHTML=rs),Zd=d(t),ti=o(t,"HR",{}),ei=d(t),el=o(t,"A",{id:!0,class:!0}),u(el).forEach(l),li=d(t),f(ll.$$.fragment,t),ri=d(t),rl=o(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-yw51a0"&&(rl.textContent=as),ai=d(t),al=o(t,"P",{"data-svelte-h":!0}),s(al)!=="svelte-1gw6hta"&&(al.innerHTML=ds),di=d(t),dl=o(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-tjke50"&&(dl.innerHTML=is),ii=d(t),oi=o(t,"HR",{}),si=d(t),il=o(t,"A",{id:!0,class:!0}),u(il).forEach(l),ni=d(t),f(ol.$$.fragment,t),ui=d(t),sl=o(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-lvoqsi"&&(sl.textContent=os),mi=d(t),nl=o(t,"TABLE",{"data-svelte-h":!0}),s(nl)!=="svelte-1gtay08"&&(nl.innerHTML=ss),fi=d(t),pi=o(t,"HR",{}),hi=d(t),ul=o(t,"A",{id:!0,class:!0}),u(ul).forEach(l),ci=d(t),f(ml.$$.fragment,t),Ti=d(t),fl=o(t,"P",{"data-svelte-h":!0}),s(fl)!=="svelte-9rr3v5"&&(fl.innerHTML=ns),yi=d(t),vi=o(t,"HR",{}),_i=d(t),f(pl.$$.fragment,t),Fi=d(t),cl=o(t,"P",{}),u(cl).forEach(l),this.h()},h(){n(v,"name","hf:doc:metadata"),n(v,"content",_s),n(_,"id","module_utils/maths"),n(_,"class","group"),n(A,"id","module_utils/maths.interpolate_data"),n(A,"class","group"),n(L,"id","module_utils/maths.permute_data"),n(L,"class","group"),n(R,"id","module_utils/maths.softmax"),n(R,"class","group"),n(j,"id","module_utils/maths.log_softmax"),n(j,"class","group"),n(q,"id","module_utils/maths.dot"),n(q,"class","group"),n(Q,"id","module_utils/maths.cos_sim"),n(Q,"class","group"),n(Z,"id","module_utils/maths.magnitude"),n(Z,"class","group"),n(at,"id","module_utils/maths.min"),n(at,"class","group"),n(ut,"id","module_utils/maths.max"),n(ut,"class","group"),n(Tt,"id","module_utils/maths.medianFilter"),n(Tt,"class","group"),n(bt,"id","module_utils/maths.round"),n(bt,"class","group"),n(Ct,"id","module_utils/maths.bankers_round"),n(Ct,"class","group"),n(gt,"id","module_utils/maths.dynamic_time_warping"),n(gt,"class","group"),n(Kt,"id","module_utils/maths..P2FFT"),n(Kt,"class","group"),n(It,"id","new_module_utils/maths..P2FFT_new"),n(It,"class","group"),n(Jt,"id","module_utils/maths..P2FFT+createComplexArray"),n(Jt,"class","group"),n(Xt,"id","module_utils/maths..P2FFT+fromComplexArray"),n(Xt,"class","group"),n(le,"id","module_utils/maths..P2FFT+toComplexArray"),n(le,"class","group"),n(oe,"id","module_utils/maths..P2FFT+transform"),n(oe,"class","group"),n(pe,"id","module_utils/maths..P2FFT+realTransform"),n(pe,"class","group"),n(_e,"id","module_utils/maths..P2FFT+inverseTransform"),n(_e,"class","group"),n(Pe,"id","module_utils/maths..P2FFT+_transform4"),n(Pe,"class","group"),n(we,"id","module_utils/maths..P2FFT+_singleTransform2"),n(we,"class","group"),n(ke,"id","module_utils/maths..P2FFT+_singleTransform4"),n(ke,"class","group"),n(De,"id","module_utils/maths..P2FFT+_realTransform4"),n(De,"class","group"),n(Se,"id","module_utils/maths..P2FFT+_singleRealTransform2"),n(Se,"class","group"),n(We,"id","module_utils/maths..P2FFT+_singleRealTransform4"),n(We,"class","group"),n(el,"id","module_utils/maths..NP2FFT"),n(el,"class","group"),n(il,"id","new_module_utils/maths..NP2FFT_new"),n(il,"class","group"),n(ul,"id","module_utils/maths..AnyTypedArray"),n(ul,"class","group")},m(t,e){Ts(document.head,v),r(t,Tl,e),r(t,hl,e),r(t,yl,e),r(t,_,e),r(t,vl,e),p(F,t,e),r(t,_l,e),r(t,b,e),r(t,Fl,e),r(t,x,e),r(t,bl,e),r(t,$,e),r(t,xl,e),r(t,$l,e),r(t,Al,e),r(t,A,e),r(t,Pl,e),p(P,t,e),r(t,Cl,e),r(t,C,e),r(t,Hl,e),r(t,H,e),r(t,Ll,e),r(t,Ml,e),r(t,wl,e),r(t,L,e),r(t,gl,e),p(M,t,e),r(t,El,e),r(t,w,e),r(t,Rl,e),r(t,g,e),r(t,zl,e),r(t,E,e),r(t,kl,e),r(t,Kl,e),r(t,Ol,e),r(t,R,e),r(t,jl,e),p(z,t,e),r(t,Bl,e),r(t,k,e),r(t,Dl,e),r(t,K,e),r(t,Ul,e),r(t,O,e),r(t,Il,e),r(t,ql,e),r(t,Nl,e),r(t,j,e),r(t,Sl,e),p(B,t,e),r(t,Gl,e),r(t,D,e),r(t,Jl,e),r(t,U,e),r(t,Ql,e),r(t,I,e),r(t,Vl,e),r(t,Wl,e),r(t,Xl,e),r(t,q,e),r(t,Yl,e),p(N,t,e),r(t,Zl,e),r(t,S,e),r(t,tr,e),r(t,G,e),r(t,er,e),r(t,J,e),r(t,lr,e),r(t,rr,e),r(t,ar,e),r(t,Q,e),r(t,dr,e),p(V,t,e),r(t,ir,e),r(t,W,e),r(t,or,e),r(t,X,e),r(t,sr,e),r(t,Y,e),r(t,nr,e),r(t,ur,e),r(t,mr,e),r(t,Z,e),r(t,fr,e),p(tt,t,e),r(t,pr,e),r(t,et,e),r(t,hr,e),r(t,lt,e),r(t,cr,e),r(t,rt,e),r(t,Tr,e),r(t,yr,e),r(t,vr,e),r(t,at,e),r(t,_r,e),p(dt,t,e),r(t,Fr,e),r(t,it,e),r(t,br,e),r(t,ot,e),r(t,xr,e),r(t,st,e),r(t,$r,e),r(t,nt,e),r(t,Ar,e),r(t,Pr,e),r(t,Cr,e),r(t,ut,e),r(t,Hr,e),p(mt,t,e),r(t,Lr,e),r(t,ft,e),r(t,Mr,e),r(t,pt,e),r(t,wr,e),r(t,ht,e),r(t,gr,e),r(t,ct,e),r(t,Er,e),r(t,Rr,e),r(t,zr,e),r(t,Tt,e),r(t,kr,e),p(yt,t,e),r(t,Kr,e),r(t,vt,e),r(t,Or,e),r(t,_t,e),r(t,jr,e),r(t,Ft,e),r(t,Br,e),r(t,Dr,e),r(t,Ur,e),r(t,bt,e),r(t,Ir,e),p(xt,t,e),r(t,qr,e),r(t,$t,e),r(t,Nr,e),r(t,At,e),r(t,Sr,e),r(t,Pt,e),r(t,Gr,e),r(t,Jr,e),r(t,Qr,e),r(t,Ct,e),r(t,Vr,e),p(Ht,t,e),r(t,Wr,e),r(t,Lt,e),r(t,Xr,e),r(t,Mt,e),r(t,Yr,e),r(t,wt,e),r(t,Zr,e),r(t,ta,e),r(t,ea,e),r(t,gt,e),r(t,la,e),p(Et,t,e),r(t,ra,e),r(t,Rt,e),r(t,aa,e),r(t,zt,e),r(t,da,e),r(t,kt,e),r(t,ia,e),r(t,oa,e),r(t,sa,e),r(t,Kt,e),r(t,na,e),p(Ot,t,e),r(t,ua,e),r(t,jt,e),r(t,ma,e),r(t,Bt,e),r(t,fa,e),r(t,Dt,e),r(t,pa,e),r(t,Ut,e),r(t,ha,e),r(t,ca,e),r(t,Ta,e),r(t,It,e),r(t,ya,e),p(qt,t,e),r(t,va,e),r(t,Nt,e),r(t,_a,e),r(t,St,e),r(t,Fa,e),r(t,Gt,e),r(t,ba,e),r(t,xa,e),r(t,$a,e),r(t,Jt,e),r(t,Aa,e),p(Qt,t,e),r(t,Pa,e),r(t,Vt,e),r(t,Ca,e),r(t,Wt,e),r(t,Ha,e),r(t,La,e),r(t,Ma,e),r(t,Xt,e),r(t,wa,e),p(Yt,t,e),r(t,ga,e),r(t,Zt,e),r(t,Ea,e),r(t,te,e),r(t,Ra,e),r(t,ee,e),r(t,za,e),r(t,ka,e),r(t,Ka,e),r(t,le,e),r(t,Oa,e),p(re,t,e),r(t,ja,e),r(t,ae,e),r(t,Ba,e),r(t,de,e),r(t,Da,e),r(t,ie,e),r(t,Ua,e),r(t,Ia,e),r(t,qa,e),r(t,oe,e),r(t,Na,e),p(se,t,e),r(t,Sa,e),r(t,ne,e),r(t,Ga,e),r(t,ue,e),r(t,Ja,e),r(t,me,e),r(t,Qa,e),r(t,fe,e),r(t,Va,e),r(t,Wa,e),r(t,Xa,e),r(t,pe,e),r(t,Ya,e),p(he,t,e),r(t,Za,e),r(t,ce,e),r(t,td,e),r(t,Te,e),r(t,ed,e),r(t,ye,e),r(t,ld,e),r(t,ve,e),r(t,rd,e),r(t,ad,e),r(t,dd,e),r(t,_e,e),r(t,id,e),p(Fe,t,e),r(t,od,e),r(t,be,e),r(t,sd,e),r(t,xe,e),r(t,nd,e),r(t,$e,e),r(t,ud,e),r(t,Ae,e),r(t,md,e),r(t,fd,e),r(t,pd,e),r(t,Pe,e),r(t,hd,e),p(Ce,t,e),r(t,cd,e),r(t,He,e),r(t,Td,e),r(t,Le,e),r(t,yd,e),r(t,Me,e),r(t,vd,e),r(t,_d,e),r(t,Fd,e),r(t,we,e),r(t,bd,e),p(ge,t,e),r(t,xd,e),r(t,Ee,e),r(t,$d,e),r(t,Re,e),r(t,Ad,e),r(t,ze,e),r(t,Pd,e),r(t,Cd,e),r(t,Hd,e),r(t,ke,e),r(t,Ld,e),p(Ke,t,e),r(t,Md,e),r(t,Oe,e),r(t,wd,e),r(t,je,e),r(t,gd,e),r(t,Be,e),r(t,Ed,e),r(t,Rd,e),r(t,zd,e),r(t,De,e),r(t,kd,e),p(Ue,t,e),r(t,Kd,e),r(t,Ie,e),r(t,Od,e),r(t,qe,e),r(t,jd,e),r(t,Ne,e),r(t,Bd,e),r(t,Dd,e),r(t,Ud,e),r(t,Se,e),r(t,Id,e),p(Ge,t,e),r(t,qd,e),r(t,Je,e),r(t,Nd,e),r(t,Qe,e),r(t,Sd,e),r(t,Ve,e),r(t,Gd,e),r(t,Jd,e),r(t,Qd,e),r(t,We,e),r(t,Vd,e),p(Xe,t,e),r(t,Wd,e),r(t,Ye,e),r(t,Xd,e),r(t,Ze,e),r(t,Yd,e),r(t,tl,e),r(t,Zd,e),r(t,ti,e),r(t,ei,e),r(t,el,e),r(t,li,e),p(ll,t,e),r(t,ri,e),r(t,rl,e),r(t,ai,e),r(t,al,e),r(t,di,e),r(t,dl,e),r(t,ii,e),r(t,oi,e),r(t,si,e),r(t,il,e),r(t,ni,e),p(ol,t,e),r(t,ui,e),r(t,sl,e),r(t,mi,e),r(t,nl,e),r(t,fi,e),r(t,pi,e),r(t,hi,e),r(t,ul,e),r(t,ci,e),p(ml,t,e),r(t,Ti,e),r(t,fl,e),r(t,yi,e),r(t,vi,e),r(t,_i,e),p(pl,t,e),r(t,Fi,e),r(t,cl,e),bi=!0},p:ms,i(t){bi||(h(F.$$.fragment,t),h(P.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(B.$$.fragment,t),h(N.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(dt.$$.fragment,t),h(mt.$$.fragment,t),h(yt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Ot.$$.fragment,t),h(qt.$$.fragment,t),h(Qt.$$.fragment,t),h(Yt.$$.fragment,t),h(re.$$.fragment,t),h(se.$$.fragment,t),h(he.$$.fragment,t),h(Fe.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(Ue.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(ol.$$.fragment,t),h(ml.$$.fragment,t),h(pl.$$.fragment,t),bi=!0)},o(t){c(F.$$.fragment,t),c(P.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(B.$$.fragment,t),c(N.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(dt.$$.fragment,t),c(mt.$$.fragment,t),c(yt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Ot.$$.fragment,t),c(qt.$$.fragment,t),c(Qt.$$.fragment,t),c(Yt.$$.fragment,t),c(re.$$.fragment,t),c(se.$$.fragment,t),c(he.$$.fragment,t),c(Fe.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(Ue.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(ol.$$.fragment,t),c(ml.$$.fragment,t),c(pl.$$.fragment,t),bi=!1},d(t){t&&(l(Tl),l(hl),l(yl),l(_),l(vl),l(_l),l(b),l(Fl),l(x),l(bl),l($),l(xl),l($l),l(Al),l(A),l(Pl),l(Cl),l(C),l(Hl),l(H),l(Ll),l(Ml),l(wl),l(L),l(gl),l(El),l(w),l(Rl),l(g),l(zl),l(E),l(kl),l(Kl),l(Ol),l(R),l(jl),l(Bl),l(k),l(Dl),l(K),l(Ul),l(O),l(Il),l(ql),l(Nl),l(j),l(Sl),l(Gl),l(D),l(Jl),l(U),l(Ql),l(I),l(Vl),l(Wl),l(Xl),l(q),l(Yl),l(Zl),l(S),l(tr),l(G),l(er),l(J),l(lr),l(rr),l(ar),l(Q),l(dr),l(ir),l(W),l(or),l(X),l(sr),l(Y),l(nr),l(ur),l(mr),l(Z),l(fr),l(pr),l(et),l(hr),l(lt),l(cr),l(rt),l(Tr),l(yr),l(vr),l(at),l(_r),l(Fr),l(it),l(br),l(ot),l(xr),l(st),l($r),l(nt),l(Ar),l(Pr),l(Cr),l(ut),l(Hr),l(Lr),l(ft),l(Mr),l(pt),l(wr),l(ht),l(gr),l(ct),l(Er),l(Rr),l(zr),l(Tt),l(kr),l(Kr),l(vt),l(Or),l(_t),l(jr),l(Ft),l(Br),l(Dr),l(Ur),l(bt),l(Ir),l(qr),l($t),l(Nr),l(At),l(Sr),l(Pt),l(Gr),l(Jr),l(Qr),l(Ct),l(Vr),l(Wr),l(Lt),l(Xr),l(Mt),l(Yr),l(wt),l(Zr),l(ta),l(ea),l(gt),l(la),l(ra),l(Rt),l(aa),l(zt),l(da),l(kt),l(ia),l(oa),l(sa),l(Kt),l(na),l(ua),l(jt),l(ma),l(Bt),l(fa),l(Dt),l(pa),l(Ut),l(ha),l(ca),l(Ta),l(It),l(ya),l(va),l(Nt),l(_a),l(St),l(Fa),l(Gt),l(ba),l(xa),l($a),l(Jt),l(Aa),l(Pa),l(Vt),l(Ca),l(Wt),l(Ha),l(La),l(Ma),l(Xt),l(wa),l(ga),l(Zt),l(Ea),l(te),l(Ra),l(ee),l(za),l(ka),l(Ka),l(le),l(Oa),l(ja),l(ae),l(Ba),l(de),l(Da),l(ie),l(Ua),l(Ia),l(qa),l(oe),l(Na),l(Sa),l(ne),l(Ga),l(ue),l(Ja),l(me),l(Qa),l(fe),l(Va),l(Wa),l(Xa),l(pe),l(Ya),l(Za),l(ce),l(td),l(Te),l(ed),l(ye),l(ld),l(ve),l(rd),l(ad),l(dd),l(_e),l(id),l(od),l(be),l(sd),l(xe),l(nd),l($e),l(ud),l(Ae),l(md),l(fd),l(pd),l(Pe),l(hd),l(cd),l(He),l(Td),l(Le),l(yd),l(Me),l(vd),l(_d),l(Fd),l(we),l(bd),l(xd),l(Ee),l($d),l(Re),l(Ad),l(ze),l(Pd),l(Cd),l(Hd),l(ke),l(Ld),l(Md),l(Oe),l(wd),l(je),l(gd),l(Be),l(Ed),l(Rd),l(zd),l(De),l(kd),l(Kd),l(Ie),l(Od),l(qe),l(jd),l(Ne),l(Bd),l(Dd),l(Ud),l(Se),l(Id),l(qd),l(Je),l(Nd),l(Qe),l(Sd),l(Ve),l(Gd),l(Jd),l(Qd),l(We),l(Vd),l(Wd),l(Ye),l(Xd),l(Ze),l(Yd),l(tl),l(Zd),l(ti),l(ei),l(el),l(li),l(ri),l(rl),l(ai),l(al),l(di),l(dl),l(ii),l(oi),l(si),l(il),l(ni),l(ui),l(sl),l(mi),l(nl),l(fi),l(pi),l(hi),l(ul),l(ci),l(Ti),l(fl),l(yi),l(vi),l(_i),l(Fi),l(cl)),l(v),T(F,t),T(P,t),T(M,t),T(z,t),T(B,t),T(N,t),T(V,t),T(tt,t),T(dt,t),T(mt,t),T(yt,t),T(xt,t),T(Ht,t),T(Et,t),T(Ot,t),T(qt,t),T(Qt,t),T(Yt,t),T(re,t),T(se,t),T(he,t),T(Fe,t),T(Ce,t),T(ge,t),T(Ke,t),T(Ue,t),T(Ge,t),T(Xe,t),T(ll,t),T(ol,t),T(ml,t),T(pl,t)}}}const _s='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathspermutedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths.bankers_round(x) ⇒ <code> number </code>","local":"utilsmathsbankersroundx--code-number-code","sections":[],"depth":2},{"title":"utils/maths.dynamic_time_warping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilsmathsdynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function Fs(xi){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends ps{constructor(v){super(),hs(this,v,Fs,vs,us,{})}}export{As as component};
