import{s as Si,n as qi,o as Ki}from"../chunks/scheduler.0219f8bd.js";import{S as Oi,i as ec,g as a,s,r as p,A as tc,h as d,f as r,c as l,j as _,u as m,x as i,k as c,y as rc,a as o,v as n,d as u,t as h,w as f}from"../chunks/index.f61edf3b.js";import{C as ld}from"../chunks/CodeBlock.38e566ae.js";import{H as g,E as oc}from"../chunks/EditOnGithub.48fa589f.js";function sc(ad){let x,Jr,Pr,Ir,T,kr,b,Fr,v,dd="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Lr,y,id="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",jr,$,zr,M,cd='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Ar,Rr,Dr,w,Ur,E,Br,C,pd="Base class for feature extractors.",Wr,P,md='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Nr,H,nd='<li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li>',Gr,Yr,Zr,J,Qr,I,Xr,k,ud="Constructs a new FeatureExtractor instance.",Vr,F,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Sr,qr,Kr,L,Or,j,eo,z,fd=`This method should be implemented in subclasses to provide the
functionality of the callable object.`,to,A,_d='<strong>Kind</strong>: instance method of <a href="#module_processors.FeatureExtractor"><code>FeatureExtractor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Throws</strong>:',ro,R,gd="<li><code>Error</code> If the subclass does not implement the `_call` method.</li>",oo,D,xd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>Array.&lt;any&gt;</code></td></tr></tbody>",so,lo,ao,U,io,B,co,W,Td="Feature extractor for image models.",po,N,bd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',mo,G,vd='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',no,uo,ho,Y,fo,Z,_o,Q,yd="Constructs a new ImageFeatureExtractor instance.",go,X,$d=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td></td><td><p>The size to resize the image to.</p></td> </tr><tr><td>[config.do_flip_channel_order]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to flip the color channels from RGB to BGR.
Can be overridden by the <code>do_flip_channel_order</code> parameter in the <code>preprocess</code> method.</p></td></tr></tbody>`,xo,To,bo,V,vo,S,yo,q,Md=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,$o,K,wd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Mo,O,Ed="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",wo,Eo,Co,ee,Po,te,Ho,re,Cd="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",Jo,oe,Pd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',Io,se,Hd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",ko,Fo,Lo,le,jo,ae,zo,de,Jd="Pad the image by a certain amount.",Ao,ie,Id='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',Ro,ce,kd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image (height, width, channels).</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",Do,Uo,Bo,pe,Wo,me,No,ne,Fd="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",Go,ue,Ld='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',Yo,he,jd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Zo,Qo,Xo,fe,Vo,_e,So,ge,zd=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,qo,xe,Ad='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',Ko,Te,Rd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",Oo,es,ts,be,rs,ve,os,ye,Dd="Resizes the image.",ss,$e,Ud='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',ls,Me,Bd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",as,ds,is,we,cs,Ee,ps,Ce,Wd="Preprocesses the given image.",ms,Pe,Nd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',ns,He,Gd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",us,hs,fs,Je,_s,Ie,gs,ke,Yd=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,xs,Fe,Zd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',Ts,Le,Qd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",bs,vs,ys,je,$s,ze,Ms,Ae,Xd="Detr Feature Extractor.",ws,Re,Vd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',Es,De,Sd='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',Cs,Ps,Hs,Ue,Js,Be,Is,We,qd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,ks,Ne,Kd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',Fs,Ge,Od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",Ls,js,zs,Ye,As,Ze,Rs,Qe,ei='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Ds,Us,Bs,Xe,Ws,Ve,Ns,Se,ti="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Gs,qe,ri='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Ys,Ke,oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Zs,Qs,Xs,Oe,Vs,et,Ss,tt,si="Checks whether the segment is valid or not.",qs,rt,li='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',Ks,ot,ai="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Os,el,tl,st,rl,lt,ol,at,di="Computes the segments.",sl,dt,ii='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',ll,it,ci="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",al,dl,il,ct,cl,pt,pl,mt,pi="Post-process the model output to generate the final panoptic segmentation.",ml,nt,mi='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',nl,ut,ni="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",ul,hl,fl,ht,_l,ft,gl,_t,ui="Represents a Processor that extracts features from an input.",xl,gt,hi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Tl,xt,fi='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',bl,vl,yl,Tt,$l,bt,Ml,vt,_i="Creates a new Processor with the given feature extractor.",wl,yt,gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",El,Cl,Pl,$t,Hl,Mt,Jl,wt,xi="Calls the feature_extractor function with the given input.",Il,Et,Ti='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',kl,Ct,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Fl,Ll,jl,Pt,zl,Ht,Al,Jt,vi="Represents a WhisperProcessor that extracts features from an audio input.",Rl,It,yi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',Dl,Ul,Bl,kt,Wl,Ft,Nl,Lt,$i="Calls the feature_extractor function with the given audio input.",Gl,jt,Mi='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Yl,zt,wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Zl,Ql,Xl,At,Vl,Rt,Sl,Dt,Ei=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,ql,Ut,Ci="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",Kl,Bt,Ol,Wt,Pi="<strong>Example:</strong> Run an image through a processor.",ea,Nt,ta,Gt,Hi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',ra,oa,sa,Yt,la,Zt,aa,Qt,Ji="Instantiate one of the processor classes of the library from a pretrained model.",da,Xt,Ii=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,ia,Vt,ki='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',ca,St,Fi=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,pa,ma,na,qt,ua,Kt,ha,Ot,Li="Converts bounding boxes from center format to corners format.",fa,er,ji='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',_a,tr,zi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",ga,xa,Ta,rr,ba,or,va,sr,Ai="Rounds the height and width down to the closest multiple of size_divisibility",ya,lr,Ri='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',$a,ar,Di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",Ma,wa,Ea,dr,Ca,ir,Pa,cr,Ui=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,Ha,pr,Bi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Ja,Ia,ka,mr,Fa,nr,La,ur,Wi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ja,hr,Ni="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",za,Aa,Ra,fr,Da,_r,Ua,gr,Gi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ba,xr,Yi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",Wa,Na,Ga,Tr,Ya,br,Za,vr,Zi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Qa,yr,Qi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Xa,Va,Sa,$r,qa,Mr,Ka,wr,Xi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Oa,Er,Vi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td> </tr><tr><td>[input_boxes]</td><td><code>Tensor</code></td></tr></tbody>",ed,td,rd,Cr,od,Hr,sd;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new ld({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWxldCUyMHByb2Nlc3NvciUyMCUzRCUyMGF3YWl0JTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJ29wZW5haSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBbGV0JTIwYXVkaW8lMjAlM0QlMjBhd2FpdCUyMHJlYWRfYXVkaW8oJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMnJTJDJTIwMTYwMDApJTNCJTBBbGV0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),I=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"featureExtractor._call(...args)",local:"featureextractorcallargs",headingTag:"h3"}}),B=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),Z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),S=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),te=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),ae=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),me=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),_e=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),ve=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Ee=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),Ie=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),ze=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),Be=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Ze=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),Ve=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),et=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),lt=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),pt=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),ft=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),bt=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),Mt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),Ht=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),Ft=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),Rt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),Bt=new ld({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),Nt=new ld({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Zt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Kt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),or=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),ir=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),nr=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),_r=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),br=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),Mr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),Cr=new oc({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){x=a("meta"),Jr=s(),Pr=a("p"),Ir=s(),T=a("a"),kr=s(),p(b.$$.fragment),Fr=s(),v=a("p"),v.textContent=dd,Lr=s(),y=a("p"),y.innerHTML=id,jr=s(),p($.$$.fragment),zr=s(),M=a("ul"),M.innerHTML=cd,Ar=s(),Rr=a("hr"),Dr=s(),w=a("a"),Ur=s(),p(E.$$.fragment),Br=s(),C=a("p"),C.textContent=pd,Wr=s(),P=a("p"),P.innerHTML=md,Nr=s(),H=a("ul"),H.innerHTML=nd,Gr=s(),Yr=a("hr"),Zr=s(),J=a("a"),Qr=s(),p(I.$$.fragment),Xr=s(),k=a("p"),k.textContent=ud,Vr=s(),F=a("table"),F.innerHTML=hd,Sr=s(),qr=a("hr"),Kr=s(),L=a("a"),Or=s(),p(j.$$.fragment),eo=s(),z=a("p"),z.textContent=fd,to=s(),A=a("p"),A.innerHTML=_d,ro=s(),R=a("ul"),R.innerHTML=gd,oo=s(),D=a("table"),D.innerHTML=xd,so=s(),lo=a("hr"),ao=s(),U=a("a"),io=s(),p(B.$$.fragment),co=s(),W=a("p"),W.textContent=Td,po=s(),N=a("p"),N.innerHTML=bd,mo=s(),G=a("ul"),G.innerHTML=vd,no=s(),uo=a("hr"),ho=s(),Y=a("a"),fo=s(),p(Z.$$.fragment),_o=s(),Q=a("p"),Q.textContent=yd,go=s(),X=a("table"),X.innerHTML=$d,xo=s(),To=a("hr"),bo=s(),V=a("a"),vo=s(),p(S.$$.fragment),yo=s(),q=a("p"),q.textContent=Md,$o=s(),K=a("p"),K.innerHTML=wd,Mo=s(),O=a("table"),O.innerHTML=Ed,wo=s(),Eo=a("hr"),Co=s(),ee=a("a"),Po=s(),p(te.$$.fragment),Ho=s(),re=a("p"),re.textContent=Cd,Jo=s(),oe=a("p"),oe.innerHTML=Pd,Io=s(),se=a("table"),se.innerHTML=Hd,ko=s(),Fo=a("hr"),Lo=s(),le=a("a"),jo=s(),p(ae.$$.fragment),zo=s(),de=a("p"),de.textContent=Jd,Ao=s(),ie=a("p"),ie.innerHTML=Id,Ro=s(),ce=a("table"),ce.innerHTML=kd,Do=s(),Uo=a("hr"),Bo=s(),pe=a("a"),Wo=s(),p(me.$$.fragment),No=s(),ne=a("p"),ne.innerHTML=Fd,Go=s(),ue=a("p"),ue.innerHTML=Ld,Yo=s(),he=a("table"),he.innerHTML=jd,Zo=s(),Qo=a("hr"),Xo=s(),fe=a("a"),Vo=s(),p(_e.$$.fragment),So=s(),ge=a("p"),ge.textContent=zd,qo=s(),xe=a("p"),xe.innerHTML=Ad,Ko=s(),Te=a("table"),Te.innerHTML=Rd,Oo=s(),es=a("hr"),ts=s(),be=a("a"),rs=s(),p(ve.$$.fragment),os=s(),ye=a("p"),ye.textContent=Dd,ss=s(),$e=a("p"),$e.innerHTML=Ud,ls=s(),Me=a("table"),Me.innerHTML=Bd,as=s(),ds=a("hr"),is=s(),we=a("a"),cs=s(),p(Ee.$$.fragment),ps=s(),Ce=a("p"),Ce.textContent=Wd,ms=s(),Pe=a("p"),Pe.innerHTML=Nd,ns=s(),He=a("table"),He.innerHTML=Gd,us=s(),hs=a("hr"),fs=s(),Je=a("a"),_s=s(),p(Ie.$$.fragment),gs=s(),ke=a("p"),ke.textContent=Yd,xs=s(),Fe=a("p"),Fe.innerHTML=Zd,Ts=s(),Le=a("table"),Le.innerHTML=Qd,bs=s(),vs=a("hr"),ys=s(),je=a("a"),$s=s(),p(ze.$$.fragment),Ms=s(),Ae=a("p"),Ae.textContent=Xd,ws=s(),Re=a("p"),Re.innerHTML=Vd,Es=s(),De=a("ul"),De.innerHTML=Sd,Cs=s(),Ps=a("hr"),Hs=s(),Ue=a("a"),Js=s(),p(Be.$$.fragment),Is=s(),We=a("p"),We.textContent=qd,ks=s(),Ne=a("p"),Ne.innerHTML=Kd,Fs=s(),Ge=a("table"),Ge.innerHTML=Od,Ls=s(),js=a("hr"),zs=s(),Ye=a("a"),As=s(),p(Ze.$$.fragment),Rs=s(),Qe=a("p"),Qe.innerHTML=ei,Ds=s(),Us=a("hr"),Bs=s(),Xe=a("a"),Ws=s(),p(Ve.$$.fragment),Ns=s(),Se=a("p"),Se.innerHTML=ti,Gs=s(),qe=a("p"),qe.innerHTML=ri,Ys=s(),Ke=a("table"),Ke.innerHTML=oi,Zs=s(),Qs=a("hr"),Xs=s(),Oe=a("a"),Vs=s(),p(et.$$.fragment),Ss=s(),tt=a("p"),tt.textContent=si,qs=s(),rt=a("p"),rt.innerHTML=li,Ks=s(),ot=a("table"),ot.innerHTML=ai,Os=s(),el=a("hr"),tl=s(),st=a("a"),rl=s(),p(lt.$$.fragment),ol=s(),at=a("p"),at.textContent=di,sl=s(),dt=a("p"),dt.innerHTML=ii,ll=s(),it=a("table"),it.innerHTML=ci,al=s(),dl=a("hr"),il=s(),ct=a("a"),cl=s(),p(pt.$$.fragment),pl=s(),mt=a("p"),mt.textContent=pi,ml=s(),nt=a("p"),nt.innerHTML=mi,nl=s(),ut=a("table"),ut.innerHTML=ni,ul=s(),hl=a("hr"),fl=s(),ht=a("a"),_l=s(),p(ft.$$.fragment),gl=s(),_t=a("p"),_t.textContent=ui,xl=s(),gt=a("p"),gt.innerHTML=hi,Tl=s(),xt=a("ul"),xt.innerHTML=fi,bl=s(),vl=a("hr"),yl=s(),Tt=a("a"),$l=s(),p(bt.$$.fragment),Ml=s(),vt=a("p"),vt.textContent=_i,wl=s(),yt=a("table"),yt.innerHTML=gi,El=s(),Cl=a("hr"),Pl=s(),$t=a("a"),Hl=s(),p(Mt.$$.fragment),Jl=s(),wt=a("p"),wt.textContent=xi,Il=s(),Et=a("p"),Et.innerHTML=Ti,kl=s(),Ct=a("table"),Ct.innerHTML=bi,Fl=s(),Ll=a("hr"),jl=s(),Pt=a("a"),zl=s(),p(Ht.$$.fragment),Al=s(),Jt=a("p"),Jt.textContent=vi,Rl=s(),It=a("p"),It.innerHTML=yi,Dl=s(),Ul=a("hr"),Bl=s(),kt=a("a"),Wl=s(),p(Ft.$$.fragment),Nl=s(),Lt=a("p"),Lt.textContent=$i,Gl=s(),jt=a("p"),jt.innerHTML=Mi,Yl=s(),zt=a("table"),zt.innerHTML=wi,Zl=s(),Ql=a("hr"),Xl=s(),At=a("a"),Vl=s(),p(Rt.$$.fragment),Sl=s(),Dt=a("p"),Dt.innerHTML=Ei,ql=s(),Ut=a("p"),Ut.innerHTML=Ci,Kl=s(),p(Bt.$$.fragment),Ol=s(),Wt=a("p"),Wt.innerHTML=Pi,ea=s(),p(Nt.$$.fragment),ta=s(),Gt=a("p"),Gt.innerHTML=Hi,ra=s(),oa=a("hr"),sa=s(),Yt=a("a"),la=s(),p(Zt.$$.fragment),aa=s(),Qt=a("p"),Qt.textContent=Ji,da=s(),Xt=a("p"),Xt.innerHTML=Ii,ia=s(),Vt=a("p"),Vt.innerHTML=ki,ca=s(),St=a("table"),St.innerHTML=Fi,pa=s(),ma=a("hr"),na=s(),qt=a("a"),ua=s(),p(Kt.$$.fragment),ha=s(),Ot=a("p"),Ot.textContent=Li,fa=s(),er=a("p"),er.innerHTML=ji,_a=s(),tr=a("table"),tr.innerHTML=zi,ga=s(),xa=a("hr"),Ta=s(),rr=a("a"),ba=s(),p(or.$$.fragment),va=s(),sr=a("p"),sr.textContent=Ai,ya=s(),lr=a("p"),lr.innerHTML=Ri,$a=s(),ar=a("table"),ar.innerHTML=Di,Ma=s(),wa=a("hr"),Ea=s(),dr=a("a"),Ca=s(),p(ir.$$.fragment),Pa=s(),cr=a("p"),cr.textContent=Ui,Ha=s(),pr=a("p"),pr.innerHTML=Bi,Ja=s(),Ia=a("hr"),ka=s(),mr=a("a"),Fa=s(),p(nr.$$.fragment),La=s(),ur=a("p"),ur.innerHTML=Wi,ja=s(),hr=a("table"),hr.innerHTML=Ni,za=s(),Aa=a("hr"),Ra=s(),fr=a("a"),Da=s(),p(_r.$$.fragment),Ua=s(),gr=a("p"),gr.innerHTML=Gi,Ba=s(),xr=a("table"),xr.innerHTML=Yi,Wa=s(),Na=a("hr"),Ga=s(),Tr=a("a"),Ya=s(),p(br.$$.fragment),Za=s(),vr=a("p"),vr.innerHTML=Zi,Qa=s(),yr=a("table"),yr.innerHTML=Qi,Xa=s(),Va=a("hr"),Sa=s(),$r=a("a"),qa=s(),p(Mr.$$.fragment),Ka=s(),wr=a("p"),wr.innerHTML=Xi,Oa=s(),Er=a("table"),Er.innerHTML=Vi,ed=s(),td=a("hr"),rd=s(),p(Cr.$$.fragment),od=s(),Hr=a("p"),this.h()},l(e){const t=tc("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),Jr=l(e),Pr=d(e,"P",{}),_(Pr).forEach(r),Ir=l(e),T=d(e,"A",{id:!0,class:!0}),_(T).forEach(r),kr=l(e),m(b.$$.fragment,e),Fr=l(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-w0rx8m"&&(v.textContent=dd),Lr=l(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1olsie5"&&(y.innerHTML=id),jr=l(e),m($.$$.fragment,e),zr=l(e),M=d(e,"UL",{"data-svelte-h":!0}),i(M)!=="svelte-wm6ck5"&&(M.innerHTML=cd),Ar=l(e),Rr=d(e,"HR",{}),Dr=l(e),w=d(e,"A",{id:!0,class:!0}),_(w).forEach(r),Ur=l(e),m(E.$$.fragment,e),Br=l(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=pd),Wr=l(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13iv745"&&(P.innerHTML=md),Nr=l(e),H=d(e,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-16exrlt"&&(H.innerHTML=nd),Gr=l(e),Yr=d(e,"HR",{}),Zr=l(e),J=d(e,"A",{id:!0,class:!0}),_(J).forEach(r),Qr=l(e),m(I.$$.fragment,e),Xr=l(e),k=d(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-k3m2wg"&&(k.textContent=ud),Vr=l(e),F=d(e,"TABLE",{"data-svelte-h":!0}),i(F)!=="svelte-rd7ds7"&&(F.innerHTML=hd),Sr=l(e),qr=d(e,"HR",{}),Kr=l(e),L=d(e,"A",{id:!0,class:!0}),_(L).forEach(r),Or=l(e),m(j.$$.fragment,e),eo=l(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-8c74gj"&&(z.textContent=fd),to=l(e),A=d(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-syym47"&&(A.innerHTML=_d),ro=l(e),R=d(e,"UL",{"data-svelte-h":!0}),i(R)!=="svelte-7c1v8c"&&(R.innerHTML=gd),oo=l(e),D=d(e,"TABLE",{"data-svelte-h":!0}),i(D)!=="svelte-1v34kj"&&(D.innerHTML=xd),so=l(e),lo=d(e,"HR",{}),ao=l(e),U=d(e,"A",{id:!0,class:!0}),_(U).forEach(r),io=l(e),m(B.$$.fragment,e),co=l(e),W=d(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-8k8cys"&&(W.textContent=Td),po=l(e),N=d(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-18p52n5"&&(N.innerHTML=bd),mo=l(e),G=d(e,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-1ne2ywl"&&(G.innerHTML=vd),no=l(e),uo=d(e,"HR",{}),ho=l(e),Y=d(e,"A",{id:!0,class:!0}),_(Y).forEach(r),fo=l(e),m(Z.$$.fragment,e),_o=l(e),Q=d(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1mp2vol"&&(Q.textContent=yd),go=l(e),X=d(e,"TABLE",{"data-svelte-h":!0}),i(X)!=="svelte-1131cyk"&&(X.innerHTML=$d),xo=l(e),To=d(e,"HR",{}),bo=l(e),V=d(e,"A",{id:!0,class:!0}),_(V).forEach(r),vo=l(e),m(S.$$.fragment,e),yo=l(e),q=d(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1q6eyx4"&&(q.textContent=Md),$o=l(e),K=d(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-ar7q77"&&(K.innerHTML=wd),Mo=l(e),O=d(e,"TABLE",{"data-svelte-h":!0}),i(O)!=="svelte-klyf4z"&&(O.innerHTML=Ed),wo=l(e),Eo=d(e,"HR",{}),Co=l(e),ee=d(e,"A",{id:!0,class:!0}),_(ee).forEach(r),Po=l(e),m(te.$$.fragment,e),Ho=l(e),re=d(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-7fx89a"&&(re.textContent=Cd),Jo=l(e),oe=d(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-65os4c"&&(oe.innerHTML=Pd),Io=l(e),se=d(e,"TABLE",{"data-svelte-h":!0}),i(se)!=="svelte-1dnvwno"&&(se.innerHTML=Hd),ko=l(e),Fo=d(e,"HR",{}),Lo=l(e),le=d(e,"A",{id:!0,class:!0}),_(le).forEach(r),jo=l(e),m(ae.$$.fragment,e),zo=l(e),de=d(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1mmkb9p"&&(de.textContent=Jd),Ao=l(e),ie=d(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-110o3sn"&&(ie.innerHTML=Id),Ro=l(e),ce=d(e,"TABLE",{"data-svelte-h":!0}),i(ce)!=="svelte-mhh1xm"&&(ce.innerHTML=kd),Do=l(e),Uo=d(e,"HR",{}),Bo=l(e),pe=d(e,"A",{id:!0,class:!0}),_(pe).forEach(r),Wo=l(e),m(me.$$.fragment,e),No=l(e),ne=d(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-pyd72v"&&(ne.innerHTML=Fd),Go=l(e),ue=d(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1isxmg1"&&(ue.innerHTML=Ld),Yo=l(e),he=d(e,"TABLE",{"data-svelte-h":!0}),i(he)!=="svelte-1e1ka8e"&&(he.innerHTML=jd),Zo=l(e),Qo=d(e,"HR",{}),Xo=l(e),fe=d(e,"A",{id:!0,class:!0}),_(fe).forEach(r),Vo=l(e),m(_e.$$.fragment,e),So=l(e),ge=d(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-8leww2"&&(ge.textContent=zd),qo=l(e),xe=d(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-eqxqo6"&&(xe.innerHTML=Ad),Ko=l(e),Te=d(e,"TABLE",{"data-svelte-h":!0}),i(Te)!=="svelte-1n361ub"&&(Te.innerHTML=Rd),Oo=l(e),es=d(e,"HR",{}),ts=l(e),be=d(e,"A",{id:!0,class:!0}),_(be).forEach(r),rs=l(e),m(ve.$$.fragment,e),os=l(e),ye=d(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-5iny39"&&(ye.textContent=Dd),ss=l(e),$e=d(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-ar7q77"&&($e.innerHTML=Ud),ls=l(e),Me=d(e,"TABLE",{"data-svelte-h":!0}),i(Me)!=="svelte-d8vk38"&&(Me.innerHTML=Bd),as=l(e),ds=d(e,"HR",{}),is=l(e),we=d(e,"A",{id:!0,class:!0}),_(we).forEach(r),cs=l(e),m(Ee.$$.fragment,e),ps=l(e),Ce=d(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-10g8wi9"&&(Ce.textContent=Wd),ms=l(e),Pe=d(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-cd20o3"&&(Pe.innerHTML=Nd),ns=l(e),He=d(e,"TABLE",{"data-svelte-h":!0}),i(He)!=="svelte-1773mps"&&(He.innerHTML=Gd),us=l(e),hs=d(e,"HR",{}),fs=l(e),Je=d(e,"A",{id:!0,class:!0}),_(Je).forEach(r),_s=l(e),m(Ie.$$.fragment,e),gs=l(e),ke=d(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1uytqp8"&&(ke.textContent=Yd),xs=l(e),Fe=d(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1pa0uk8"&&(Fe.innerHTML=Zd),Ts=l(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),i(Le)!=="svelte-hch5rz"&&(Le.innerHTML=Qd),bs=l(e),vs=d(e,"HR",{}),ys=l(e),je=d(e,"A",{id:!0,class:!0}),_(je).forEach(r),$s=l(e),m(ze.$$.fragment,e),Ms=l(e),Ae=d(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-y1gxwn"&&(Ae.textContent=Xd),ws=l(e),Re=d(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1xz91ac"&&(Re.innerHTML=Vd),Es=l(e),De=d(e,"UL",{"data-svelte-h":!0}),i(De)!=="svelte-1obx36y"&&(De.innerHTML=Sd),Cs=l(e),Ps=d(e,"HR",{}),Hs=l(e),Ue=d(e,"A",{id:!0,class:!0}),_(Ue).forEach(r),Js=l(e),m(Be.$$.fragment,e),Is=l(e),We=d(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1ec3vsm"&&(We.textContent=qd),ks=l(e),Ne=d(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-6tjpr7"&&(Ne.innerHTML=Kd),Fs=l(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),i(Ge)!=="svelte-1px7bnv"&&(Ge.innerHTML=Od),Ls=l(e),js=d(e,"HR",{}),zs=l(e),Ye=d(e,"A",{id:!0,class:!0}),_(Ye).forEach(r),As=l(e),m(Ze.$$.fragment,e),Rs=l(e),Qe=d(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-j2v54d"&&(Qe.innerHTML=ei),Ds=l(e),Us=d(e,"HR",{}),Bs=l(e),Xe=d(e,"A",{id:!0,class:!0}),_(Xe).forEach(r),Ws=l(e),m(Ve.$$.fragment,e),Ns=l(e),Se=d(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-75c7d5"&&(Se.innerHTML=ti),Gs=l(e),qe=d(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-o8p6wm"&&(qe.innerHTML=ri),Ys=l(e),Ke=d(e,"TABLE",{"data-svelte-h":!0}),i(Ke)!=="svelte-yqya7v"&&(Ke.innerHTML=oi),Zs=l(e),Qs=d(e,"HR",{}),Xs=l(e),Oe=d(e,"A",{id:!0,class:!0}),_(Oe).forEach(r),Vs=l(e),m(et.$$.fragment,e),Ss=l(e),tt=d(e,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-gl8gb6"&&(tt.textContent=si),qs=l(e),rt=d(e,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1qxvzd2"&&(rt.innerHTML=li),Ks=l(e),ot=d(e,"TABLE",{"data-svelte-h":!0}),i(ot)!=="svelte-1f7z42u"&&(ot.innerHTML=ai),Os=l(e),el=d(e,"HR",{}),tl=l(e),st=d(e,"A",{id:!0,class:!0}),_(st).forEach(r),rl=l(e),m(lt.$$.fragment,e),ol=l(e),at=d(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-7vs1p7"&&(at.textContent=di),sl=l(e),dt=d(e,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-15rcpil"&&(dt.innerHTML=ii),ll=l(e),it=d(e,"TABLE",{"data-svelte-h":!0}),i(it)!=="svelte-3xdz32"&&(it.innerHTML=ci),al=l(e),dl=d(e,"HR",{}),il=l(e),ct=d(e,"A",{id:!0,class:!0}),_(ct).forEach(r),cl=l(e),m(pt.$$.fragment,e),pl=l(e),mt=d(e,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-frdp8m"&&(mt.textContent=pi),ml=l(e),nt=d(e,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-j2v54d"&&(nt.innerHTML=mi),nl=l(e),ut=d(e,"TABLE",{"data-svelte-h":!0}),i(ut)!=="svelte-11rkhka"&&(ut.innerHTML=ni),ul=l(e),hl=d(e,"HR",{}),fl=l(e),ht=d(e,"A",{id:!0,class:!0}),_(ht).forEach(r),_l=l(e),m(ft.$$.fragment,e),gl=l(e),_t=d(e,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-o9f953"&&(_t.textContent=ui),xl=l(e),gt=d(e,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-13iv745"&&(gt.innerHTML=hi),Tl=l(e),xt=d(e,"UL",{"data-svelte-h":!0}),i(xt)!=="svelte-ceq7pc"&&(xt.innerHTML=fi),bl=l(e),vl=d(e,"HR",{}),yl=l(e),Tt=d(e,"A",{id:!0,class:!0}),_(Tt).forEach(r),$l=l(e),m(bt.$$.fragment,e),Ml=l(e),vt=d(e,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-1naom0u"&&(vt.textContent=_i),wl=l(e),yt=d(e,"TABLE",{"data-svelte-h":!0}),i(yt)!=="svelte-ilxs6c"&&(yt.innerHTML=gi),El=l(e),Cl=d(e,"HR",{}),Pl=l(e),$t=d(e,"A",{id:!0,class:!0}),_($t).forEach(r),Hl=l(e),m(Mt.$$.fragment,e),Jl=l(e),wt=d(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-zbbm3j"&&(wt.textContent=xi),Il=l(e),Et=d(e,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-1hik6yq"&&(Et.innerHTML=Ti),kl=l(e),Ct=d(e,"TABLE",{"data-svelte-h":!0}),i(Ct)!=="svelte-pm1u9z"&&(Ct.innerHTML=bi),Fl=l(e),Ll=d(e,"HR",{}),jl=l(e),Pt=d(e,"A",{id:!0,class:!0}),_(Pt).forEach(r),zl=l(e),m(Ht.$$.fragment,e),Al=l(e),Jt=d(e,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-17pib55"&&(Jt.textContent=vi),Rl=l(e),It=d(e,"P",{"data-svelte-h":!0}),i(It)!=="svelte-1ljhyyr"&&(It.innerHTML=yi),Dl=l(e),Ul=d(e,"HR",{}),Bl=l(e),kt=d(e,"A",{id:!0,class:!0}),_(kt).forEach(r),Wl=l(e),m(Ft.$$.fragment,e),Nl=l(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-r5x3fh"&&(Lt.textContent=$i),Gl=l(e),jt=d(e,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1vpvonk"&&(jt.innerHTML=Mi),Yl=l(e),zt=d(e,"TABLE",{"data-svelte-h":!0}),i(zt)!=="svelte-nv3lon"&&(zt.innerHTML=wi),Zl=l(e),Ql=d(e,"HR",{}),Xl=l(e),At=d(e,"A",{id:!0,class:!0}),_(At).forEach(r),Vl=l(e),m(Rt.$$.fragment,e),Sl=l(e),Dt=d(e,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-62dsf9"&&(Dt.innerHTML=Ei),ql=l(e),Ut=d(e,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-11vd43e"&&(Ut.innerHTML=Ci),Kl=l(e),m(Bt.$$.fragment,e),Ol=l(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-c0cgha"&&(Wt.innerHTML=Pi),ea=l(e),m(Nt.$$.fragment,e),ta=l(e),Gt=d(e,"P",{"data-svelte-h":!0}),i(Gt)!=="svelte-wmyz1o"&&(Gt.innerHTML=Hi),ra=l(e),oa=d(e,"HR",{}),sa=l(e),Yt=d(e,"A",{id:!0,class:!0}),_(Yt).forEach(r),la=l(e),m(Zt.$$.fragment,e),aa=l(e),Qt=d(e,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-jwfdp9"&&(Qt.textContent=Ji),da=l(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-t85gxq"&&(Xt.innerHTML=Ii),ia=l(e),Vt=d(e,"P",{"data-svelte-h":!0}),i(Vt)!=="svelte-y7m8db"&&(Vt.innerHTML=ki),ca=l(e),St=d(e,"TABLE",{"data-svelte-h":!0}),i(St)!=="svelte-1oj79mt"&&(St.innerHTML=Fi),pa=l(e),ma=d(e,"HR",{}),na=l(e),qt=d(e,"A",{id:!0,class:!0}),_(qt).forEach(r),ua=l(e),m(Kt.$$.fragment,e),ha=l(e),Ot=d(e,"P",{"data-svelte-h":!0}),i(Ot)!=="svelte-kjzox5"&&(Ot.textContent=Li),fa=l(e),er=d(e,"P",{"data-svelte-h":!0}),i(er)!=="svelte-19qboln"&&(er.innerHTML=ji),_a=l(e),tr=d(e,"TABLE",{"data-svelte-h":!0}),i(tr)!=="svelte-1bv5sxq"&&(tr.innerHTML=zi),ga=l(e),xa=d(e,"HR",{}),Ta=l(e),rr=d(e,"A",{id:!0,class:!0}),_(rr).forEach(r),ba=l(e),m(or.$$.fragment,e),va=l(e),sr=d(e,"P",{"data-svelte-h":!0}),i(sr)!=="svelte-vlkbp"&&(sr.textContent=Ai),ya=l(e),lr=d(e,"P",{"data-svelte-h":!0}),i(lr)!=="svelte-vmdbik"&&(lr.innerHTML=Ri),$a=l(e),ar=d(e,"TABLE",{"data-svelte-h":!0}),i(ar)!=="svelte-4ldb45"&&(ar.innerHTML=Di),Ma=l(e),wa=d(e,"HR",{}),Ea=l(e),dr=d(e,"A",{id:!0,class:!0}),_(dr).forEach(r),Ca=l(e),m(ir.$$.fragment,e),Pa=l(e),cr=d(e,"P",{"data-svelte-h":!0}),i(cr)!=="svelte-2u8xbp"&&(cr.textContent=Ui),Ha=l(e),pr=d(e,"P",{"data-svelte-h":!0}),i(pr)!=="svelte-3xndnt"&&(pr.innerHTML=Bi),Ja=l(e),Ia=d(e,"HR",{}),ka=l(e),mr=d(e,"A",{id:!0,class:!0}),_(mr).forEach(r),Fa=l(e),m(nr.$$.fragment,e),La=l(e),ur=d(e,"P",{"data-svelte-h":!0}),i(ur)!=="svelte-cy5pwv"&&(ur.innerHTML=Wi),ja=l(e),hr=d(e,"TABLE",{"data-svelte-h":!0}),i(hr)!=="svelte-1dyar84"&&(hr.innerHTML=Ni),za=l(e),Aa=d(e,"HR",{}),Ra=l(e),fr=d(e,"A",{id:!0,class:!0}),_(fr).forEach(r),Da=l(e),m(_r.$$.fragment,e),Ua=l(e),gr=d(e,"P",{"data-svelte-h":!0}),i(gr)!=="svelte-cy5pwv"&&(gr.innerHTML=Gi),Ba=l(e),xr=d(e,"TABLE",{"data-svelte-h":!0}),i(xr)!=="svelte-1cnys15"&&(xr.innerHTML=Yi),Wa=l(e),Na=d(e,"HR",{}),Ga=l(e),Tr=d(e,"A",{id:!0,class:!0}),_(Tr).forEach(r),Ya=l(e),m(br.$$.fragment,e),Za=l(e),vr=d(e,"P",{"data-svelte-h":!0}),i(vr)!=="svelte-cy5pwv"&&(vr.innerHTML=Zi),Qa=l(e),yr=d(e,"TABLE",{"data-svelte-h":!0}),i(yr)!=="svelte-179cln2"&&(yr.innerHTML=Qi),Xa=l(e),Va=d(e,"HR",{}),Sa=l(e),$r=d(e,"A",{id:!0,class:!0}),_($r).forEach(r),qa=l(e),m(Mr.$$.fragment,e),Ka=l(e),wr=d(e,"P",{"data-svelte-h":!0}),i(wr)!=="svelte-cy5pwv"&&(wr.innerHTML=Xi),Oa=l(e),Er=d(e,"TABLE",{"data-svelte-h":!0}),i(Er)!=="svelte-1nrm9i3"&&(Er.innerHTML=Vi),ed=l(e),td=d(e,"HR",{}),rd=l(e),m(Cr.$$.fragment,e),od=l(e),Hr=d(e,"P",{}),_(Hr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",lc),c(T,"id","module_processors"),c(T,"class","group"),c(w,"id","module_processors.FeatureExtractor"),c(w,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(L,"id","Callable+_call"),c(L,"class","group"),c(U,"id","module_processors.ImageFeatureExtractor"),c(U,"class","group"),c(Y,"id","new_module_processors.ImageFeatureExtractor_new"),c(Y,"class","group"),c(V,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(V,"class","group"),c(ee,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(ee,"class","group"),c(le,"id","module_processors.ImageFeatureExtractor+pad_image"),c(le,"class","group"),c(pe,"id","module_processors.ImageFeatureExtractor+rescale"),c(pe,"class","group"),c(fe,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(fe,"class","group"),c(be,"id","module_processors.ImageFeatureExtractor+resize"),c(be,"class","group"),c(we,"id","module_processors.ImageFeatureExtractor+preprocess"),c(we,"class","group"),c(Je,"id","module_processors.ImageFeatureExtractor+_call"),c(Je,"class","group"),c(je,"id","module_processors.DetrFeatureExtractor"),c(je,"class","group"),c(Ue,"id","module_processors.DetrFeatureExtractor+_call"),c(Ue,"class","group"),c(Ye,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Ye,"class","group"),c(Xe,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Xe,"class","group"),c(Oe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Oe,"class","group"),c(st,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(st,"class","group"),c(ct,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(ct,"class","group"),c(ht,"id","module_processors.Processor"),c(ht,"class","group"),c(Tt,"id","new_module_processors.Processor_new"),c(Tt,"class","group"),c($t,"id","module_processors.Processor+_call"),c($t,"class","group"),c(Pt,"id","module_processors.WhisperProcessor"),c(Pt,"class","group"),c(kt,"id","module_processors.WhisperProcessor+_call"),c(kt,"class","group"),c(At,"id","module_processors.AutoProcessor"),c(At,"class","group"),c(Yt,"id","module_processors.AutoProcessor.from_pretrained"),c(Yt,"class","group"),c(qt,"id","module_processors..center_to_corners_format"),c(qt,"class","group"),c(rr,"id","module_processors..enforce_size_divisibility"),c(rr,"class","group"),c(dr,"id","module_processors..HeightWidth"),c(dr,"class","group"),c(mr,"id","module_processors..ImageFeatureExtractorResult"),c(mr,"class","group"),c(fr,"id","module_processors..PreprocessedImage"),c(fr,"class","group"),c(Tr,"id","module_processors..DetrFeatureExtractorResult"),c(Tr,"class","group"),c($r,"id","module_processors..SamImageProcessorResult"),c($r,"class","group")},m(e,t){rc(document.head,x),o(e,Jr,t),o(e,Pr,t),o(e,Ir,t),o(e,T,t),o(e,kr,t),n(b,e,t),o(e,Fr,t),o(e,v,t),o(e,Lr,t),o(e,y,t),o(e,jr,t),n($,e,t),o(e,zr,t),o(e,M,t),o(e,Ar,t),o(e,Rr,t),o(e,Dr,t),o(e,w,t),o(e,Ur,t),n(E,e,t),o(e,Br,t),o(e,C,t),o(e,Wr,t),o(e,P,t),o(e,Nr,t),o(e,H,t),o(e,Gr,t),o(e,Yr,t),o(e,Zr,t),o(e,J,t),o(e,Qr,t),n(I,e,t),o(e,Xr,t),o(e,k,t),o(e,Vr,t),o(e,F,t),o(e,Sr,t),o(e,qr,t),o(e,Kr,t),o(e,L,t),o(e,Or,t),n(j,e,t),o(e,eo,t),o(e,z,t),o(e,to,t),o(e,A,t),o(e,ro,t),o(e,R,t),o(e,oo,t),o(e,D,t),o(e,so,t),o(e,lo,t),o(e,ao,t),o(e,U,t),o(e,io,t),n(B,e,t),o(e,co,t),o(e,W,t),o(e,po,t),o(e,N,t),o(e,mo,t),o(e,G,t),o(e,no,t),o(e,uo,t),o(e,ho,t),o(e,Y,t),o(e,fo,t),n(Z,e,t),o(e,_o,t),o(e,Q,t),o(e,go,t),o(e,X,t),o(e,xo,t),o(e,To,t),o(e,bo,t),o(e,V,t),o(e,vo,t),n(S,e,t),o(e,yo,t),o(e,q,t),o(e,$o,t),o(e,K,t),o(e,Mo,t),o(e,O,t),o(e,wo,t),o(e,Eo,t),o(e,Co,t),o(e,ee,t),o(e,Po,t),n(te,e,t),o(e,Ho,t),o(e,re,t),o(e,Jo,t),o(e,oe,t),o(e,Io,t),o(e,se,t),o(e,ko,t),o(e,Fo,t),o(e,Lo,t),o(e,le,t),o(e,jo,t),n(ae,e,t),o(e,zo,t),o(e,de,t),o(e,Ao,t),o(e,ie,t),o(e,Ro,t),o(e,ce,t),o(e,Do,t),o(e,Uo,t),o(e,Bo,t),o(e,pe,t),o(e,Wo,t),n(me,e,t),o(e,No,t),o(e,ne,t),o(e,Go,t),o(e,ue,t),o(e,Yo,t),o(e,he,t),o(e,Zo,t),o(e,Qo,t),o(e,Xo,t),o(e,fe,t),o(e,Vo,t),n(_e,e,t),o(e,So,t),o(e,ge,t),o(e,qo,t),o(e,xe,t),o(e,Ko,t),o(e,Te,t),o(e,Oo,t),o(e,es,t),o(e,ts,t),o(e,be,t),o(e,rs,t),n(ve,e,t),o(e,os,t),o(e,ye,t),o(e,ss,t),o(e,$e,t),o(e,ls,t),o(e,Me,t),o(e,as,t),o(e,ds,t),o(e,is,t),o(e,we,t),o(e,cs,t),n(Ee,e,t),o(e,ps,t),o(e,Ce,t),o(e,ms,t),o(e,Pe,t),o(e,ns,t),o(e,He,t),o(e,us,t),o(e,hs,t),o(e,fs,t),o(e,Je,t),o(e,_s,t),n(Ie,e,t),o(e,gs,t),o(e,ke,t),o(e,xs,t),o(e,Fe,t),o(e,Ts,t),o(e,Le,t),o(e,bs,t),o(e,vs,t),o(e,ys,t),o(e,je,t),o(e,$s,t),n(ze,e,t),o(e,Ms,t),o(e,Ae,t),o(e,ws,t),o(e,Re,t),o(e,Es,t),o(e,De,t),o(e,Cs,t),o(e,Ps,t),o(e,Hs,t),o(e,Ue,t),o(e,Js,t),n(Be,e,t),o(e,Is,t),o(e,We,t),o(e,ks,t),o(e,Ne,t),o(e,Fs,t),o(e,Ge,t),o(e,Ls,t),o(e,js,t),o(e,zs,t),o(e,Ye,t),o(e,As,t),n(Ze,e,t),o(e,Rs,t),o(e,Qe,t),o(e,Ds,t),o(e,Us,t),o(e,Bs,t),o(e,Xe,t),o(e,Ws,t),n(Ve,e,t),o(e,Ns,t),o(e,Se,t),o(e,Gs,t),o(e,qe,t),o(e,Ys,t),o(e,Ke,t),o(e,Zs,t),o(e,Qs,t),o(e,Xs,t),o(e,Oe,t),o(e,Vs,t),n(et,e,t),o(e,Ss,t),o(e,tt,t),o(e,qs,t),o(e,rt,t),o(e,Ks,t),o(e,ot,t),o(e,Os,t),o(e,el,t),o(e,tl,t),o(e,st,t),o(e,rl,t),n(lt,e,t),o(e,ol,t),o(e,at,t),o(e,sl,t),o(e,dt,t),o(e,ll,t),o(e,it,t),o(e,al,t),o(e,dl,t),o(e,il,t),o(e,ct,t),o(e,cl,t),n(pt,e,t),o(e,pl,t),o(e,mt,t),o(e,ml,t),o(e,nt,t),o(e,nl,t),o(e,ut,t),o(e,ul,t),o(e,hl,t),o(e,fl,t),o(e,ht,t),o(e,_l,t),n(ft,e,t),o(e,gl,t),o(e,_t,t),o(e,xl,t),o(e,gt,t),o(e,Tl,t),o(e,xt,t),o(e,bl,t),o(e,vl,t),o(e,yl,t),o(e,Tt,t),o(e,$l,t),n(bt,e,t),o(e,Ml,t),o(e,vt,t),o(e,wl,t),o(e,yt,t),o(e,El,t),o(e,Cl,t),o(e,Pl,t),o(e,$t,t),o(e,Hl,t),n(Mt,e,t),o(e,Jl,t),o(e,wt,t),o(e,Il,t),o(e,Et,t),o(e,kl,t),o(e,Ct,t),o(e,Fl,t),o(e,Ll,t),o(e,jl,t),o(e,Pt,t),o(e,zl,t),n(Ht,e,t),o(e,Al,t),o(e,Jt,t),o(e,Rl,t),o(e,It,t),o(e,Dl,t),o(e,Ul,t),o(e,Bl,t),o(e,kt,t),o(e,Wl,t),n(Ft,e,t),o(e,Nl,t),o(e,Lt,t),o(e,Gl,t),o(e,jt,t),o(e,Yl,t),o(e,zt,t),o(e,Zl,t),o(e,Ql,t),o(e,Xl,t),o(e,At,t),o(e,Vl,t),n(Rt,e,t),o(e,Sl,t),o(e,Dt,t),o(e,ql,t),o(e,Ut,t),o(e,Kl,t),n(Bt,e,t),o(e,Ol,t),o(e,Wt,t),o(e,ea,t),n(Nt,e,t),o(e,ta,t),o(e,Gt,t),o(e,ra,t),o(e,oa,t),o(e,sa,t),o(e,Yt,t),o(e,la,t),n(Zt,e,t),o(e,aa,t),o(e,Qt,t),o(e,da,t),o(e,Xt,t),o(e,ia,t),o(e,Vt,t),o(e,ca,t),o(e,St,t),o(e,pa,t),o(e,ma,t),o(e,na,t),o(e,qt,t),o(e,ua,t),n(Kt,e,t),o(e,ha,t),o(e,Ot,t),o(e,fa,t),o(e,er,t),o(e,_a,t),o(e,tr,t),o(e,ga,t),o(e,xa,t),o(e,Ta,t),o(e,rr,t),o(e,ba,t),n(or,e,t),o(e,va,t),o(e,sr,t),o(e,ya,t),o(e,lr,t),o(e,$a,t),o(e,ar,t),o(e,Ma,t),o(e,wa,t),o(e,Ea,t),o(e,dr,t),o(e,Ca,t),n(ir,e,t),o(e,Pa,t),o(e,cr,t),o(e,Ha,t),o(e,pr,t),o(e,Ja,t),o(e,Ia,t),o(e,ka,t),o(e,mr,t),o(e,Fa,t),n(nr,e,t),o(e,La,t),o(e,ur,t),o(e,ja,t),o(e,hr,t),o(e,za,t),o(e,Aa,t),o(e,Ra,t),o(e,fr,t),o(e,Da,t),n(_r,e,t),o(e,Ua,t),o(e,gr,t),o(e,Ba,t),o(e,xr,t),o(e,Wa,t),o(e,Na,t),o(e,Ga,t),o(e,Tr,t),o(e,Ya,t),n(br,e,t),o(e,Za,t),o(e,vr,t),o(e,Qa,t),o(e,yr,t),o(e,Xa,t),o(e,Va,t),o(e,Sa,t),o(e,$r,t),o(e,qa,t),n(Mr,e,t),o(e,Ka,t),o(e,wr,t),o(e,Oa,t),o(e,Er,t),o(e,ed,t),o(e,td,t),o(e,rd,t),n(Cr,e,t),o(e,od,t),o(e,Hr,t),sd=!0},p:qi,i(e){sd||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(S.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(me.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(Ee.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Be.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(ft.$$.fragment,e),u(bt.$$.fragment,e),u(Mt.$$.fragment,e),u(Ht.$$.fragment,e),u(Ft.$$.fragment,e),u(Rt.$$.fragment,e),u(Bt.$$.fragment,e),u(Nt.$$.fragment,e),u(Zt.$$.fragment,e),u(Kt.$$.fragment,e),u(or.$$.fragment,e),u(ir.$$.fragment,e),u(nr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(Mr.$$.fragment,e),u(Cr.$$.fragment,e),sd=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(S.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(me.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Ee.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(Ve.$$.fragment,e),h(et.$$.fragment,e),h(lt.$$.fragment,e),h(pt.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(Mt.$$.fragment,e),h(Ht.$$.fragment,e),h(Ft.$$.fragment,e),h(Rt.$$.fragment,e),h(Bt.$$.fragment,e),h(Nt.$$.fragment,e),h(Zt.$$.fragment,e),h(Kt.$$.fragment,e),h(or.$$.fragment,e),h(ir.$$.fragment,e),h(nr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(Mr.$$.fragment,e),h(Cr.$$.fragment,e),sd=!1},d(e){e&&(r(Jr),r(Pr),r(Ir),r(T),r(kr),r(Fr),r(v),r(Lr),r(y),r(jr),r(zr),r(M),r(Ar),r(Rr),r(Dr),r(w),r(Ur),r(Br),r(C),r(Wr),r(P),r(Nr),r(H),r(Gr),r(Yr),r(Zr),r(J),r(Qr),r(Xr),r(k),r(Vr),r(F),r(Sr),r(qr),r(Kr),r(L),r(Or),r(eo),r(z),r(to),r(A),r(ro),r(R),r(oo),r(D),r(so),r(lo),r(ao),r(U),r(io),r(co),r(W),r(po),r(N),r(mo),r(G),r(no),r(uo),r(ho),r(Y),r(fo),r(_o),r(Q),r(go),r(X),r(xo),r(To),r(bo),r(V),r(vo),r(yo),r(q),r($o),r(K),r(Mo),r(O),r(wo),r(Eo),r(Co),r(ee),r(Po),r(Ho),r(re),r(Jo),r(oe),r(Io),r(se),r(ko),r(Fo),r(Lo),r(le),r(jo),r(zo),r(de),r(Ao),r(ie),r(Ro),r(ce),r(Do),r(Uo),r(Bo),r(pe),r(Wo),r(No),r(ne),r(Go),r(ue),r(Yo),r(he),r(Zo),r(Qo),r(Xo),r(fe),r(Vo),r(So),r(ge),r(qo),r(xe),r(Ko),r(Te),r(Oo),r(es),r(ts),r(be),r(rs),r(os),r(ye),r(ss),r($e),r(ls),r(Me),r(as),r(ds),r(is),r(we),r(cs),r(ps),r(Ce),r(ms),r(Pe),r(ns),r(He),r(us),r(hs),r(fs),r(Je),r(_s),r(gs),r(ke),r(xs),r(Fe),r(Ts),r(Le),r(bs),r(vs),r(ys),r(je),r($s),r(Ms),r(Ae),r(ws),r(Re),r(Es),r(De),r(Cs),r(Ps),r(Hs),r(Ue),r(Js),r(Is),r(We),r(ks),r(Ne),r(Fs),r(Ge),r(Ls),r(js),r(zs),r(Ye),r(As),r(Rs),r(Qe),r(Ds),r(Us),r(Bs),r(Xe),r(Ws),r(Ns),r(Se),r(Gs),r(qe),r(Ys),r(Ke),r(Zs),r(Qs),r(Xs),r(Oe),r(Vs),r(Ss),r(tt),r(qs),r(rt),r(Ks),r(ot),r(Os),r(el),r(tl),r(st),r(rl),r(ol),r(at),r(sl),r(dt),r(ll),r(it),r(al),r(dl),r(il),r(ct),r(cl),r(pl),r(mt),r(ml),r(nt),r(nl),r(ut),r(ul),r(hl),r(fl),r(ht),r(_l),r(gl),r(_t),r(xl),r(gt),r(Tl),r(xt),r(bl),r(vl),r(yl),r(Tt),r($l),r(Ml),r(vt),r(wl),r(yt),r(El),r(Cl),r(Pl),r($t),r(Hl),r(Jl),r(wt),r(Il),r(Et),r(kl),r(Ct),r(Fl),r(Ll),r(jl),r(Pt),r(zl),r(Al),r(Jt),r(Rl),r(It),r(Dl),r(Ul),r(Bl),r(kt),r(Wl),r(Nl),r(Lt),r(Gl),r(jt),r(Yl),r(zt),r(Zl),r(Ql),r(Xl),r(At),r(Vl),r(Sl),r(Dt),r(ql),r(Ut),r(Kl),r(Ol),r(Wt),r(ea),r(ta),r(Gt),r(ra),r(oa),r(sa),r(Yt),r(la),r(aa),r(Qt),r(da),r(Xt),r(ia),r(Vt),r(ca),r(St),r(pa),r(ma),r(na),r(qt),r(ua),r(ha),r(Ot),r(fa),r(er),r(_a),r(tr),r(ga),r(xa),r(Ta),r(rr),r(ba),r(va),r(sr),r(ya),r(lr),r($a),r(ar),r(Ma),r(wa),r(Ea),r(dr),r(Ca),r(Pa),r(cr),r(Ha),r(pr),r(Ja),r(Ia),r(ka),r(mr),r(Fa),r(La),r(ur),r(ja),r(hr),r(za),r(Aa),r(Ra),r(fr),r(Da),r(Ua),r(gr),r(Ba),r(xr),r(Wa),r(Na),r(Ga),r(Tr),r(Ya),r(Za),r(vr),r(Qa),r(yr),r(Xa),r(Va),r(Sa),r($r),r(qa),r(Ka),r(wr),r(Oa),r(Er),r(ed),r(td),r(rd),r(od),r(Hr)),r(x),f(b,e),f($,e),f(E,e),f(I,e),f(j,e),f(B,e),f(Z,e),f(S,e),f(te,e),f(ae,e),f(me,e),f(_e,e),f(ve,e),f(Ee,e),f(Ie,e),f(ze,e),f(Be,e),f(Ze,e),f(Ve,e),f(et,e),f(lt,e),f(pt,e),f(ft,e),f(bt,e),f(Mt,e),f(Ht,e),f(Ft,e),f(Rt,e),f(Bt,e),f(Nt,e),f(Zt,e),f(Kt,e),f(or,e),f(ir,e),f(nr,e),f(_r,e),f(br,e),f(Mr,e),f(Cr,e)}}}const lc='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3},{"title":"featureExtractor._call(...args)","local":"featureextractorcallargs","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function ac(ad){return Ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mc extends Oi{constructor(x){super(),ec(this,x,ac,sc,Si,{})}}export{mc as component};
