import{s as bn,n as Cn,o as Wn}from"../chunks/scheduler.389d799c.js";import{S as En,i as Gn,g as T,s as l,r as i,A as qn,h as c,f as a,c as e,j as Un,u as p,x as J,k as Bn,y as An,a as n,v as r,d as o,t as u,w as M}from"../chunks/index.8f81d18f.js";import{C as d}from"../chunks/CodeBlock.3845caa1.js";import{H as j,E as kn}from"../chunks/EditOnGithub.33306dfe.js";function Vn(xa){let m,ns,ss,ls,h,es,y,Ya=`Inference Endpoints offers out-of-the-box support for Machine Learning tasks from the Transformers, Sentence-Transformers and Diffusers libraries. Below is a table of Hugging Face managed supported tasks for Inference Endpoint. These tasks don’t require any form of code or <a href="/docs/inference-endpoints/guides/docs/guides/custom_container">“custom container”</a> to deploy an Endpoint.
If you want to customize any of the tasks below, or want to write your own custom task, check out the <a href="/docs/inference-endpoints/guides/custom_handler">“Create your own inference handler”</a> section for more information.`,is,w,Sa='Most of the tasks below uses the <code>pipeline</code> object, and more information about what additional parameters can be sent to the endpoint is available <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.',ps,f,La="<thead><tr><th>Task</th> <th>Framework</th> <th>Out of the box Support</th></tr></thead> <tbody><tr><td>Text To Image</td> <td>Diffusers</td> <td>✅</td></tr> <tr><td>Text Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Zero Shot Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Token Classifiation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Question Answering</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Fill Mask</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Summarization</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Translation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Text to Text Generation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Text Generation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Feature Extraction</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Sentence Embeddings</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Sentence Similarity</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Ranking</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Image Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Automatic Speech Recognition</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Audio Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Object Detection</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Image Segmentation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Table Question Answering</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Conversational</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Custom</td> <td>Custom</td> <td>✅</td></tr> <tr><td>Visual Question Answering</td> <td>Transformers</td> <td>❌</td></tr> <tr><td>Zero Shot Image Classification</td> <td>Transformers</td> <td>❌</td></tr></tbody>",rs,I,os,$,za="See the following request examples for some of the tasks:",us,g,Ms,U,Ts,B,cs,b,Fa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TextClassificationPipeline" rel="nofollow">reference</a>.',Js,C,ds,W,js,E,ms,G,hs,q,ys,A,_a='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ZeroShotClassificationPipeline" rel="nofollow">reference</a>.',ws,k,fs,V,Is,N,Pa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TokenClassificationPipeline" rel="nofollow">reference</a>.',$s,Z,gs,Q,Us,v,Da='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.QuestionAnsweringPipeline" rel="nofollow">reference</a>.',Bs,H,bs,R,Cs,X,Oa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.FillMaskPipeline" rel="nofollow">reference</a>.',Ws,x,Es,Y,Gs,S,Ka='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.SummarizationPipeline" rel="nofollow">reference</a>.',qs,L,As,z,ks,F,tn='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TranslationPipeline" rel="nofollow">reference</a>.',Vs,_,Ns,P,Zs,D,sn='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.Text2TextGenerationPipeline" rel="nofollow">reference</a>.',Qs,O,vs,K,Hs,tt,an='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TextGenerationPipeline" rel="nofollow">reference</a>.',Rs,st,Xs,at,xs,nt,nn='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.FeatureExtractionPipeline" rel="nofollow">reference</a>.',Ys,lt,Ss,et,Ls,it,ln='If using a <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">TEI container</a>, see <a href="https://huggingface.github.io/text-embeddings-inference/" rel="nofollow">this reference</a> for additional parameters.',zs,pt,Fs,rt,_s,ot,Ps,ut,Ds,Mt,Os,Tt,Ks,ct,en="Image Classification can receive <code>json</code> payloads or binary data from a <code>image</code> directly.",ta,Jt,pn="<strong>JSON</strong>",sa,dt,aa,jt,rn="<strong>Binary</strong>",na,mt,la,ht,ea,yt,on='Automatic Speech Recognition can receive <code>json</code> payloads or binary data from a <code>audio</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline" rel="nofollow">reference</a>.',ia,wt,un="<strong>JSON</strong>",pa,ft,ra,It,Mn="<strong>Binary</strong>",oa,$t,ua,gt,Ma,Ut,Tn='Audio Classification can receive <code>json</code> payloads or binary data from a <code>audio</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.AudioClassificationPipeline" rel="nofollow">reference</a>.',Ta,Bt,cn="<strong>JSON</strong>",ca,bt,Ja,Ct,Jn="<strong>Binary</strong>",da,Wt,ja,Et,ma,Gt,dn='Object Detection can receive <code>json</code> payloads or binary data from a <code>image</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ObjectDetectionPipeline" rel="nofollow">reference</a>.',ha,qt,jn="<strong>JSON</strong>",ya,At,wa,kt,mn="<strong>Binary</strong>",fa,Vt,Ia,Nt,$a,Zt,hn='Image Segmentation can receive <code>json</code> payloads or binary data from a <code>image</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ImageSegmentationPipeline" rel="nofollow">reference</a>.',ga,Qt,yn="<strong>JSON</strong>",Ua,vt,Ba,Ht,wn="<strong>Binary</strong>",ba,Rt,Ca,Xt,Wa,xt,fn='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TableQuestionAnsweringPipeline" rel="nofollow">reference</a>.',Ea,Yt,Ga,St,qa,Lt,In='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.Conversation" rel="nofollow">reference</a>.',Aa,zt,ka,Ft,Va,_t,Na,Pt,Za,Dt,$n="You can add additional parameters, which are supported by the <code>pipelines</code> api from transformers.",Qa,Ot,gn="For Example if you have a <code>text-generation</code> pipeline you can provide <code>generation_kwargs</code> for <code>repetition_penalty</code> or <code>max_length</code>",va,Kt,Ha,ts,Ra,as,Xa;return h=new j({props:{title:"Supported Transformers & Diffusers Tasks",local:"supported-transformers--diffusers-tasks",headingTag:"h1"}}),I=new j({props:{title:"Example Request payloads",local:"example-request-payloads",headingTag:"h2"}}),g=new j({props:{title:"Custom Handler",local:"custom-handler",headingTag:"h3"}}),U=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMGlzJTIwYSUyMHNhbXBsZSUyMGlucHV0JTIyJTJDJTBBJTIwJTIwJTIybW9yZURhdGElMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIyY3VzdG9tVGFzayUyMiUzQSUyMHRydWUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This is a sample input&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;moreData&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;customTask&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),B=new j({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),C=new j({props:{title:"Classifying a single text",local:"classifying-a-single-text",headingTag:"h4"}}),W=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),E=new j({props:{title:"Classifying a text pair",local:"classifying-a-text-pair",headingTag:"h4"}}),G=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMlRoaXMlMjBzb3VuZCUyMHRyYWNrJTIwd2FzJTIwYmVhdXRpZnVsISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRfcGFpciUyMiUzQSUyMCUyMkl0JTIwcGFpbnRzJTIwdGhlJTIwc2NlbmVyeSUyMGluJTIweW91ciUyMG1pbmQlMjBzbyUyMHdlbGwlMjBJJTIwd291bGQlMjByZWNvbWVuZCUyMGl0JTIwZXZlbiUyMHRvJTIwcGVvcGxlJTIwd2hvJTIwaGF0ZSUyMHZpZC4lMjBnYW1lJTIwbXVzaWMhJTIyJTBBJTIwJTIwJTdEJTIwJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text_pair&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>
  <span class="hljs-punctuation">}</span> 
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new j({props:{title:"Zero Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),k=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTIwJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;candidate_labels&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;refund&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;legal&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;faq&quot;</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),V=new j({props:{title:"Token Classifiation",local:"token-classifiation",headingTag:"h3"}}),Z=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Q=new j({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),H=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB1c2VkJTIwZm9yJTIwaW5mZXJlbmNlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwTmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjB1c2VkJTIwd2l0aCUyMHNhZ2VtYWtlciUyMGZvciUyMGluZmVyZW5jZS4lMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is used for inference?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new j({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),x=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjAlM0NtYXNrJTNFISUyMEl0JTIwcGFpbnRzJTIwdGhlJTIwc2NlbmVyeSUyMGluJTIweW91ciUyMG1pbmQlMjBzbyUyMHdlbGwlMjBJJTIwd291bGQlMjByZWNvbWVuZCUyMGl0JTBBJTIwJTIwZXZlbiUyMHRvJTIwcGVvcGxlJTIwd2hvJTIwaGF0ZSUyMHZpZC4lMjBnYW1lJTIwbXVzaWMhJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was &lt;mask&gt;! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new j({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),L=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new j({props:{title:"Translation",local:"translation",headingTag:"h3"}}),_=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),P=new j({props:{title:"Text to Text Generation",local:"text-to-text-generation",headingTag:"h3"}}),O=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new j({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),st=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),at=new j({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),lt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),et=new j({props:{title:"Sentence Embeddings",local:"sentence-embeddings",headingTag:"h3"}}),pt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),rt=new j({props:{title:"Sentence similarity",local:"sentence-similarity",headingTag:"h3"}}),ot=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VudGVuY2VzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNvdXJjZV9zZW50ZW5jZSUyMiUzQSUyMCUyMldoYXQlMjBhJTIwd29uZGVyZnVsJTIwZGF5JTIwdG8lMjBsaXN0ZW4lMjB0byUyMG11c2ljJTIyJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;sentences&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;source_sentence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What a wonderful day to listen to music&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new j({props:{title:"Ranking",local:"ranking",headingTag:"h3"}}),Mt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMiU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well&quot;</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Tt=new j({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),dt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),mt=new d({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),ht=new j({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),ft=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$t=new d({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),gt=new j({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),bt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Wt=new d({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),Et=new j({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),At=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Vt=new d({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),Nt=new j({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),vt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Rt=new d({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),Xt=new j({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),Yt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWJsZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJDb250cmlidXRvcnMlMjIlM0ElMjAlNUIlMjI2NTElMjIlMkMlMjAlMjI3NyUyMiUyQyUyMCUyMjM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMiUzQSUyMCU1QiUyMlB5dGhvbiUyMiUyQyUyMCUyMlB5dGhvbiUyMiUyQyUyMCUyMlJ1c3QlMkMlMjBQeXRob24lMjBhbmQlMjBOb2RlSlMlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;query&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;table&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;Repository&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Transformers&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Datasets&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Tokenizers&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Stars&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;36542&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;4512&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;3934&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Contributors&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;651&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;77&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;34&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Programming language&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),St=new j({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),zt=new d({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBtb3ZpZSUyMGlzJTIwdGhlJTIwYmVzdCUyMCUzRiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQncyUyMERpZSUyMEhhcmQlMjBmb3IlMjBzdXJlLiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGV4cGxhaW4lMjB3aHklM0YlMjIlMEElMjAlMjAlN0QlMEElNUQlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Which movie is the best ?&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;It&#x27;s Die Hard for sure.&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Can you explain why?&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),Ft=new j({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),_t=new d({props:{code:"JTdCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIycmVhbGlzdGljJTIwcmVuZGVyJTIwcG9ydHJhaXQlMjByZWFsaXN0aWMlMjByZW5kZXIlMjBwb3J0cmFpdCUyMG9mJTIwZ3JvdXAlMjBvZiUyMGZseWluZyUyMGJsdWUlMjB3aGFsZXMlMjB0b3dhcmRzJTIwdGhlJTIwbW9vbiUyQyUyMGludHJpY2F0ZSUyQyUyMHRveSUyQyUyMHNjaSUyMC0lMjBmaSUyQyUyMGV4dHJlbWVseSUyMGRldGFpbGVkJTJDJTIwZGlnaXRhbCUyMHBhaW50aW5nJTJDJTIwc2N1bHB0ZWQlMjBpbiUyMHpicnVzaCUyQyUyMGFydHN0YXRpb24lMkMlMjBjb25jZXB0JTIwYXJ0JTJDJTIwc21vb3RoJTJDJTIwc2hhcnAlMjBmb2N1cyUyQyUyMGlsbHVzdHJhdGlvbiUyQyUyMGNoaWFyb3NjdXJvJTIwbGlnaHRpbmclMkMlMjBnb2xkZW4lMjByYXRpbyUyQyUyMGluY3JlZGlibGUlMjBhcnQlMjBieSUyMGFydGdlcm0lMjBhbmQlMjBncmVnJTIwcnV0a293c2tpJTIwYW5kJTIwYWxwaG9uc2UlMjBtdWNoYSUyMGFuZCUyMHNpbW9uJTIwc3RhbGVuaGFnJTIyJTJDJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>        
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;realistic render portrait realistic render portrait of group of flying blue whales towards the moon, intricate, toy, sci - fi, extremely detailed, digital painting, sculpted in zbrush, artstation, concept art, smooth, sharp focus, illustration, chiaroscuro lighting, golden ratio, incredible art by artgerm and greg rutkowski and alphonse mucha and simon stalenhag&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Pt=new j({props:{title:"Additional parameters",local:"additional-parameters",headingTag:"h3"}}),Kt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySHVnZ2luZyUyMEZhY2UlMkMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMFZlbnR1cmVCZWF0JUUyJTgwJTk5cyUyMElubm92YXRpb24lMjBpbiUyME5hdHVyYWwlMjBMYW5ndWFnZSUyMFByb2Nlc3MlMkZVbmRlcnN0YW5kaW5nJTIwQXdhcmQlMjBmb3IlMjAyMDIxJTJDJTIwaXMlMjBsb29raW5nJTIwdG8lMjBsZXZlbCUyMHRoZSUyMHBsYXlpbmclMjBmaWVsZC4lMjBUaGUlMjB0ZWFtJTJDJTIwbGF1bmNoZWQlMjBieSUyMENsJUMzJUE5bWVudCUyMERlbGFuZ3VlJTIwYW5kJTIwSnVsaWVuJTIwQ2hhdW1vbmQlMjBpbiUyMDIwMTYlMkMlMjB3YXMlMjByZWNvZ25pemVkJTIwZm9yJTIwaXRzJTIwd29yayUyMGluJTIwZGVtb2NyYXRpemluZyUyME5MUCUyQyUyMHRoZSUyMGdsb2JhbCUyMG1hcmtldCUyMHZhbHVlJTIwZm9yJTIwd2hpY2glMjBpcyUyMGV4cGVjdGVkJTIwdG8lMjBoaXQlMjAlMjQzNS4xJTIwYmlsbGlvbiUyMGJ5JTIwMjAyNi4lMjBUaGlzJTIwd2VlayUyQyUyMEdvb2dsZSVFMiU4MCU5OXMlMjBmb3JtZXIlMjBoZWFkJTIwb2YlMjBFdGhpY2FsJTIwQUklMjBNYXJnYXJldCUyME1pdGNoZWxsJTIwam9pbmVkJTIwdGhlJTIwdGVhbS4lMjIlMkMlMEElMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVwZXRpdGlvbl9wZW5hbHR5JTIyJTNBJTIwNC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X2xlbmd0aCUyMiUzQSUyMDEyOCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hugging Face, the winner of VentureBeat’s Innovation in Natural Language Process/Understanding Award for 2021, is looking to level the playing field. The team, launched by Clément Delangue and Julien Chaumond in 2016, was recognized for its work in democratizing NLP, the global market value for which is expected to hit $35.1 billion by 2026. This week, Google’s former head of Ethical AI Margaret Mitchell joined the team.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_length&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ts=new kn({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/supported_tasks.mdx"}}),{c(){m=T("meta"),ns=l(),ss=T("p"),ls=l(),i(h.$$.fragment),es=l(),y=T("p"),y.innerHTML=Ya,is=l(),w=T("p"),w.innerHTML=Sa,ps=l(),f=T("table"),f.innerHTML=La,rs=l(),i(I.$$.fragment),os=l(),$=T("p"),$.textContent=za,us=l(),i(g.$$.fragment),Ms=l(),i(U.$$.fragment),Ts=l(),i(B.$$.fragment),cs=l(),b=T("p"),b.innerHTML=Fa,Js=l(),i(C.$$.fragment),ds=l(),i(W.$$.fragment),js=l(),i(E.$$.fragment),ms=l(),i(G.$$.fragment),hs=l(),i(q.$$.fragment),ys=l(),A=T("p"),A.innerHTML=_a,ws=l(),i(k.$$.fragment),fs=l(),i(V.$$.fragment),Is=l(),N=T("p"),N.innerHTML=Pa,$s=l(),i(Z.$$.fragment),gs=l(),i(Q.$$.fragment),Us=l(),v=T("p"),v.innerHTML=Da,Bs=l(),i(H.$$.fragment),bs=l(),i(R.$$.fragment),Cs=l(),X=T("p"),X.innerHTML=Oa,Ws=l(),i(x.$$.fragment),Es=l(),i(Y.$$.fragment),Gs=l(),S=T("p"),S.innerHTML=Ka,qs=l(),i(L.$$.fragment),As=l(),i(z.$$.fragment),ks=l(),F=T("p"),F.innerHTML=tn,Vs=l(),i(_.$$.fragment),Ns=l(),i(P.$$.fragment),Zs=l(),D=T("p"),D.innerHTML=sn,Qs=l(),i(O.$$.fragment),vs=l(),i(K.$$.fragment),Hs=l(),tt=T("p"),tt.innerHTML=an,Rs=l(),i(st.$$.fragment),Xs=l(),i(at.$$.fragment),xs=l(),nt=T("p"),nt.innerHTML=nn,Ys=l(),i(lt.$$.fragment),Ss=l(),i(et.$$.fragment),Ls=l(),it=T("p"),it.innerHTML=ln,zs=l(),i(pt.$$.fragment),Fs=l(),i(rt.$$.fragment),_s=l(),i(ot.$$.fragment),Ps=l(),i(ut.$$.fragment),Ds=l(),i(Mt.$$.fragment),Os=l(),i(Tt.$$.fragment),Ks=l(),ct=T("p"),ct.innerHTML=en,ta=l(),Jt=T("p"),Jt.innerHTML=pn,sa=l(),i(dt.$$.fragment),aa=l(),jt=T("p"),jt.innerHTML=rn,na=l(),i(mt.$$.fragment),la=l(),i(ht.$$.fragment),ea=l(),yt=T("p"),yt.innerHTML=on,ia=l(),wt=T("p"),wt.innerHTML=un,pa=l(),i(ft.$$.fragment),ra=l(),It=T("p"),It.innerHTML=Mn,oa=l(),i($t.$$.fragment),ua=l(),i(gt.$$.fragment),Ma=l(),Ut=T("p"),Ut.innerHTML=Tn,Ta=l(),Bt=T("p"),Bt.innerHTML=cn,ca=l(),i(bt.$$.fragment),Ja=l(),Ct=T("p"),Ct.innerHTML=Jn,da=l(),i(Wt.$$.fragment),ja=l(),i(Et.$$.fragment),ma=l(),Gt=T("p"),Gt.innerHTML=dn,ha=l(),qt=T("p"),qt.innerHTML=jn,ya=l(),i(At.$$.fragment),wa=l(),kt=T("p"),kt.innerHTML=mn,fa=l(),i(Vt.$$.fragment),Ia=l(),i(Nt.$$.fragment),$a=l(),Zt=T("p"),Zt.innerHTML=hn,ga=l(),Qt=T("p"),Qt.innerHTML=yn,Ua=l(),i(vt.$$.fragment),Ba=l(),Ht=T("p"),Ht.innerHTML=wn,ba=l(),i(Rt.$$.fragment),Ca=l(),i(Xt.$$.fragment),Wa=l(),xt=T("p"),xt.innerHTML=fn,Ea=l(),i(Yt.$$.fragment),Ga=l(),i(St.$$.fragment),qa=l(),Lt=T("p"),Lt.innerHTML=In,Aa=l(),i(zt.$$.fragment),ka=l(),i(Ft.$$.fragment),Va=l(),i(_t.$$.fragment),Na=l(),i(Pt.$$.fragment),Za=l(),Dt=T("p"),Dt.innerHTML=$n,Qa=l(),Ot=T("p"),Ot.innerHTML=gn,va=l(),i(Kt.$$.fragment),Ha=l(),i(ts.$$.fragment),Ra=l(),as=T("p"),this.h()},l(t){const s=qn("svelte-u9bgzb",document.head);m=c(s,"META",{name:!0,content:!0}),s.forEach(a),ns=e(t),ss=c(t,"P",{}),Un(ss).forEach(a),ls=e(t),p(h.$$.fragment,t),es=e(t),y=c(t,"P",{"data-svelte-h":!0}),J(y)!=="svelte-6490uv"&&(y.innerHTML=Ya),is=e(t),w=c(t,"P",{"data-svelte-h":!0}),J(w)!=="svelte-1nzpej2"&&(w.innerHTML=Sa),ps=e(t),f=c(t,"TABLE",{"data-svelte-h":!0}),J(f)!=="svelte-1ngj8rf"&&(f.innerHTML=La),rs=e(t),p(I.$$.fragment,t),os=e(t),$=c(t,"P",{"data-svelte-h":!0}),J($)!=="svelte-fqnqo8"&&($.textContent=za),us=e(t),p(g.$$.fragment,t),Ms=e(t),p(U.$$.fragment,t),Ts=e(t),p(B.$$.fragment,t),cs=e(t),b=c(t,"P",{"data-svelte-h":!0}),J(b)!=="svelte-9sp7eq"&&(b.innerHTML=Fa),Js=e(t),p(C.$$.fragment,t),ds=e(t),p(W.$$.fragment,t),js=e(t),p(E.$$.fragment,t),ms=e(t),p(G.$$.fragment,t),hs=e(t),p(q.$$.fragment,t),ys=e(t),A=c(t,"P",{"data-svelte-h":!0}),J(A)!=="svelte-u2w3l1"&&(A.innerHTML=_a),ws=e(t),p(k.$$.fragment,t),fs=e(t),p(V.$$.fragment,t),Is=e(t),N=c(t,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1rbty0k"&&(N.innerHTML=Pa),$s=e(t),p(Z.$$.fragment,t),gs=e(t),p(Q.$$.fragment,t),Us=e(t),v=c(t,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1v0yek7"&&(v.innerHTML=Da),Bs=e(t),p(H.$$.fragment,t),bs=e(t),p(R.$$.fragment,t),Cs=e(t),X=c(t,"P",{"data-svelte-h":!0}),J(X)!=="svelte-1wr63ok"&&(X.innerHTML=Oa),Ws=e(t),p(x.$$.fragment,t),Es=e(t),p(Y.$$.fragment,t),Gs=e(t),S=c(t,"P",{"data-svelte-h":!0}),J(S)!=="svelte-15ubz5e"&&(S.innerHTML=Ka),qs=e(t),p(L.$$.fragment,t),As=e(t),p(z.$$.fragment,t),ks=e(t),F=c(t,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1k7ecmm"&&(F.innerHTML=tn),Vs=e(t),p(_.$$.fragment,t),Ns=e(t),p(P.$$.fragment,t),Zs=e(t),D=c(t,"P",{"data-svelte-h":!0}),J(D)!=="svelte-1hndwmf"&&(D.innerHTML=sn),Qs=e(t),p(O.$$.fragment,t),vs=e(t),p(K.$$.fragment,t),Hs=e(t),tt=c(t,"P",{"data-svelte-h":!0}),J(tt)!=="svelte-1y4efjg"&&(tt.innerHTML=an),Rs=e(t),p(st.$$.fragment,t),Xs=e(t),p(at.$$.fragment,t),xs=e(t),nt=c(t,"P",{"data-svelte-h":!0}),J(nt)!=="svelte-d8cr1i"&&(nt.innerHTML=nn),Ys=e(t),p(lt.$$.fragment,t),Ss=e(t),p(et.$$.fragment,t),Ls=e(t),it=c(t,"P",{"data-svelte-h":!0}),J(it)!=="svelte-plw9oc"&&(it.innerHTML=ln),zs=e(t),p(pt.$$.fragment,t),Fs=e(t),p(rt.$$.fragment,t),_s=e(t),p(ot.$$.fragment,t),Ps=e(t),p(ut.$$.fragment,t),Ds=e(t),p(Mt.$$.fragment,t),Os=e(t),p(Tt.$$.fragment,t),Ks=e(t),ct=c(t,"P",{"data-svelte-h":!0}),J(ct)!=="svelte-14yog2z"&&(ct.innerHTML=en),ta=e(t),Jt=c(t,"P",{"data-svelte-h":!0}),J(Jt)!=="svelte-1r1eo5z"&&(Jt.innerHTML=pn),sa=e(t),p(dt.$$.fragment,t),aa=e(t),jt=c(t,"P",{"data-svelte-h":!0}),J(jt)!=="svelte-1n8meou"&&(jt.innerHTML=rn),na=e(t),p(mt.$$.fragment,t),la=e(t),p(ht.$$.fragment,t),ea=e(t),yt=c(t,"P",{"data-svelte-h":!0}),J(yt)!=="svelte-ms9w0s"&&(yt.innerHTML=on),ia=e(t),wt=c(t,"P",{"data-svelte-h":!0}),J(wt)!=="svelte-1r1eo5z"&&(wt.innerHTML=un),pa=e(t),p(ft.$$.fragment,t),ra=e(t),It=c(t,"P",{"data-svelte-h":!0}),J(It)!=="svelte-1n8meou"&&(It.innerHTML=Mn),oa=e(t),p($t.$$.fragment,t),ua=e(t),p(gt.$$.fragment,t),Ma=e(t),Ut=c(t,"P",{"data-svelte-h":!0}),J(Ut)!=="svelte-1ne6rja"&&(Ut.innerHTML=Tn),Ta=e(t),Bt=c(t,"P",{"data-svelte-h":!0}),J(Bt)!=="svelte-1r1eo5z"&&(Bt.innerHTML=cn),ca=e(t),p(bt.$$.fragment,t),Ja=e(t),Ct=c(t,"P",{"data-svelte-h":!0}),J(Ct)!=="svelte-1n8meou"&&(Ct.innerHTML=Jn),da=e(t),p(Wt.$$.fragment,t),ja=e(t),p(Et.$$.fragment,t),ma=e(t),Gt=c(t,"P",{"data-svelte-h":!0}),J(Gt)!=="svelte-6930iz"&&(Gt.innerHTML=dn),ha=e(t),qt=c(t,"P",{"data-svelte-h":!0}),J(qt)!=="svelte-1r1eo5z"&&(qt.innerHTML=jn),ya=e(t),p(At.$$.fragment,t),wa=e(t),kt=c(t,"P",{"data-svelte-h":!0}),J(kt)!=="svelte-1n8meou"&&(kt.innerHTML=mn),fa=e(t),p(Vt.$$.fragment,t),Ia=e(t),p(Nt.$$.fragment,t),$a=e(t),Zt=c(t,"P",{"data-svelte-h":!0}),J(Zt)!=="svelte-o0xk5f"&&(Zt.innerHTML=hn),ga=e(t),Qt=c(t,"P",{"data-svelte-h":!0}),J(Qt)!=="svelte-1r1eo5z"&&(Qt.innerHTML=yn),Ua=e(t),p(vt.$$.fragment,t),Ba=e(t),Ht=c(t,"P",{"data-svelte-h":!0}),J(Ht)!=="svelte-1n8meou"&&(Ht.innerHTML=wn),ba=e(t),p(Rt.$$.fragment,t),Ca=e(t),p(Xt.$$.fragment,t),Wa=e(t),xt=c(t,"P",{"data-svelte-h":!0}),J(xt)!=="svelte-1yzaph"&&(xt.innerHTML=fn),Ea=e(t),p(Yt.$$.fragment,t),Ga=e(t),p(St.$$.fragment,t),qa=e(t),Lt=c(t,"P",{"data-svelte-h":!0}),J(Lt)!=="svelte-1d2fgl4"&&(Lt.innerHTML=In),Aa=e(t),p(zt.$$.fragment,t),ka=e(t),p(Ft.$$.fragment,t),Va=e(t),p(_t.$$.fragment,t),Na=e(t),p(Pt.$$.fragment,t),Za=e(t),Dt=c(t,"P",{"data-svelte-h":!0}),J(Dt)!=="svelte-rzvc6s"&&(Dt.innerHTML=$n),Qa=e(t),Ot=c(t,"P",{"data-svelte-h":!0}),J(Ot)!=="svelte-194vab0"&&(Ot.innerHTML=gn),va=e(t),p(Kt.$$.fragment,t),Ha=e(t),p(ts.$$.fragment,t),Ra=e(t),as=c(t,"P",{}),Un(as).forEach(a),this.h()},h(){Bn(m,"name","hf:doc:metadata"),Bn(m,"content",Nn)},m(t,s){An(document.head,m),n(t,ns,s),n(t,ss,s),n(t,ls,s),r(h,t,s),n(t,es,s),n(t,y,s),n(t,is,s),n(t,w,s),n(t,ps,s),n(t,f,s),n(t,rs,s),r(I,t,s),n(t,os,s),n(t,$,s),n(t,us,s),r(g,t,s),n(t,Ms,s),r(U,t,s),n(t,Ts,s),r(B,t,s),n(t,cs,s),n(t,b,s),n(t,Js,s),r(C,t,s),n(t,ds,s),r(W,t,s),n(t,js,s),r(E,t,s),n(t,ms,s),r(G,t,s),n(t,hs,s),r(q,t,s),n(t,ys,s),n(t,A,s),n(t,ws,s),r(k,t,s),n(t,fs,s),r(V,t,s),n(t,Is,s),n(t,N,s),n(t,$s,s),r(Z,t,s),n(t,gs,s),r(Q,t,s),n(t,Us,s),n(t,v,s),n(t,Bs,s),r(H,t,s),n(t,bs,s),r(R,t,s),n(t,Cs,s),n(t,X,s),n(t,Ws,s),r(x,t,s),n(t,Es,s),r(Y,t,s),n(t,Gs,s),n(t,S,s),n(t,qs,s),r(L,t,s),n(t,As,s),r(z,t,s),n(t,ks,s),n(t,F,s),n(t,Vs,s),r(_,t,s),n(t,Ns,s),r(P,t,s),n(t,Zs,s),n(t,D,s),n(t,Qs,s),r(O,t,s),n(t,vs,s),r(K,t,s),n(t,Hs,s),n(t,tt,s),n(t,Rs,s),r(st,t,s),n(t,Xs,s),r(at,t,s),n(t,xs,s),n(t,nt,s),n(t,Ys,s),r(lt,t,s),n(t,Ss,s),r(et,t,s),n(t,Ls,s),n(t,it,s),n(t,zs,s),r(pt,t,s),n(t,Fs,s),r(rt,t,s),n(t,_s,s),r(ot,t,s),n(t,Ps,s),r(ut,t,s),n(t,Ds,s),r(Mt,t,s),n(t,Os,s),r(Tt,t,s),n(t,Ks,s),n(t,ct,s),n(t,ta,s),n(t,Jt,s),n(t,sa,s),r(dt,t,s),n(t,aa,s),n(t,jt,s),n(t,na,s),r(mt,t,s),n(t,la,s),r(ht,t,s),n(t,ea,s),n(t,yt,s),n(t,ia,s),n(t,wt,s),n(t,pa,s),r(ft,t,s),n(t,ra,s),n(t,It,s),n(t,oa,s),r($t,t,s),n(t,ua,s),r(gt,t,s),n(t,Ma,s),n(t,Ut,s),n(t,Ta,s),n(t,Bt,s),n(t,ca,s),r(bt,t,s),n(t,Ja,s),n(t,Ct,s),n(t,da,s),r(Wt,t,s),n(t,ja,s),r(Et,t,s),n(t,ma,s),n(t,Gt,s),n(t,ha,s),n(t,qt,s),n(t,ya,s),r(At,t,s),n(t,wa,s),n(t,kt,s),n(t,fa,s),r(Vt,t,s),n(t,Ia,s),r(Nt,t,s),n(t,$a,s),n(t,Zt,s),n(t,ga,s),n(t,Qt,s),n(t,Ua,s),r(vt,t,s),n(t,Ba,s),n(t,Ht,s),n(t,ba,s),r(Rt,t,s),n(t,Ca,s),r(Xt,t,s),n(t,Wa,s),n(t,xt,s),n(t,Ea,s),r(Yt,t,s),n(t,Ga,s),r(St,t,s),n(t,qa,s),n(t,Lt,s),n(t,Aa,s),r(zt,t,s),n(t,ka,s),r(Ft,t,s),n(t,Va,s),r(_t,t,s),n(t,Na,s),r(Pt,t,s),n(t,Za,s),n(t,Dt,s),n(t,Qa,s),n(t,Ot,s),n(t,va,s),r(Kt,t,s),n(t,Ha,s),r(ts,t,s),n(t,Ra,s),n(t,as,s),Xa=!0},p:Cn,i(t){Xa||(o(h.$$.fragment,t),o(I.$$.fragment,t),o(g.$$.fragment,t),o(U.$$.fragment,t),o(B.$$.fragment,t),o(C.$$.fragment,t),o(W.$$.fragment,t),o(E.$$.fragment,t),o(G.$$.fragment,t),o(q.$$.fragment,t),o(k.$$.fragment,t),o(V.$$.fragment,t),o(Z.$$.fragment,t),o(Q.$$.fragment,t),o(H.$$.fragment,t),o(R.$$.fragment,t),o(x.$$.fragment,t),o(Y.$$.fragment,t),o(L.$$.fragment,t),o(z.$$.fragment,t),o(_.$$.fragment,t),o(P.$$.fragment,t),o(O.$$.fragment,t),o(K.$$.fragment,t),o(st.$$.fragment,t),o(at.$$.fragment,t),o(lt.$$.fragment,t),o(et.$$.fragment,t),o(pt.$$.fragment,t),o(rt.$$.fragment,t),o(ot.$$.fragment,t),o(ut.$$.fragment,t),o(Mt.$$.fragment,t),o(Tt.$$.fragment,t),o(dt.$$.fragment,t),o(mt.$$.fragment,t),o(ht.$$.fragment,t),o(ft.$$.fragment,t),o($t.$$.fragment,t),o(gt.$$.fragment,t),o(bt.$$.fragment,t),o(Wt.$$.fragment,t),o(Et.$$.fragment,t),o(At.$$.fragment,t),o(Vt.$$.fragment,t),o(Nt.$$.fragment,t),o(vt.$$.fragment,t),o(Rt.$$.fragment,t),o(Xt.$$.fragment,t),o(Yt.$$.fragment,t),o(St.$$.fragment,t),o(zt.$$.fragment,t),o(Ft.$$.fragment,t),o(_t.$$.fragment,t),o(Pt.$$.fragment,t),o(Kt.$$.fragment,t),o(ts.$$.fragment,t),Xa=!0)},o(t){u(h.$$.fragment,t),u(I.$$.fragment,t),u(g.$$.fragment,t),u(U.$$.fragment,t),u(B.$$.fragment,t),u(C.$$.fragment,t),u(W.$$.fragment,t),u(E.$$.fragment,t),u(G.$$.fragment,t),u(q.$$.fragment,t),u(k.$$.fragment,t),u(V.$$.fragment,t),u(Z.$$.fragment,t),u(Q.$$.fragment,t),u(H.$$.fragment,t),u(R.$$.fragment,t),u(x.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(z.$$.fragment,t),u(_.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(K.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(lt.$$.fragment,t),u(et.$$.fragment,t),u(pt.$$.fragment,t),u(rt.$$.fragment,t),u(ot.$$.fragment,t),u(ut.$$.fragment,t),u(Mt.$$.fragment,t),u(Tt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u($t.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(Wt.$$.fragment,t),u(Et.$$.fragment,t),u(At.$$.fragment,t),u(Vt.$$.fragment,t),u(Nt.$$.fragment,t),u(vt.$$.fragment,t),u(Rt.$$.fragment,t),u(Xt.$$.fragment,t),u(Yt.$$.fragment,t),u(St.$$.fragment,t),u(zt.$$.fragment,t),u(Ft.$$.fragment,t),u(_t.$$.fragment,t),u(Pt.$$.fragment,t),u(Kt.$$.fragment,t),u(ts.$$.fragment,t),Xa=!1},d(t){t&&(a(ns),a(ss),a(ls),a(es),a(y),a(is),a(w),a(ps),a(f),a(rs),a(os),a($),a(us),a(Ms),a(Ts),a(cs),a(b),a(Js),a(ds),a(js),a(ms),a(hs),a(ys),a(A),a(ws),a(fs),a(Is),a(N),a($s),a(gs),a(Us),a(v),a(Bs),a(bs),a(Cs),a(X),a(Ws),a(Es),a(Gs),a(S),a(qs),a(As),a(ks),a(F),a(Vs),a(Ns),a(Zs),a(D),a(Qs),a(vs),a(Hs),a(tt),a(Rs),a(Xs),a(xs),a(nt),a(Ys),a(Ss),a(Ls),a(it),a(zs),a(Fs),a(_s),a(Ps),a(Ds),a(Os),a(Ks),a(ct),a(ta),a(Jt),a(sa),a(aa),a(jt),a(na),a(la),a(ea),a(yt),a(ia),a(wt),a(pa),a(ra),a(It),a(oa),a(ua),a(Ma),a(Ut),a(Ta),a(Bt),a(ca),a(Ja),a(Ct),a(da),a(ja),a(ma),a(Gt),a(ha),a(qt),a(ya),a(wa),a(kt),a(fa),a(Ia),a($a),a(Zt),a(ga),a(Qt),a(Ua),a(Ba),a(Ht),a(ba),a(Ca),a(Wa),a(xt),a(Ea),a(Ga),a(qa),a(Lt),a(Aa),a(ka),a(Va),a(Na),a(Za),a(Dt),a(Qa),a(Ot),a(va),a(Ha),a(Ra),a(as)),a(m),M(h,t),M(I,t),M(g,t),M(U,t),M(B,t),M(C,t),M(W,t),M(E,t),M(G,t),M(q,t),M(k,t),M(V,t),M(Z,t),M(Q,t),M(H,t),M(R,t),M(x,t),M(Y,t),M(L,t),M(z,t),M(_,t),M(P,t),M(O,t),M(K,t),M(st,t),M(at,t),M(lt,t),M(et,t),M(pt,t),M(rt,t),M(ot,t),M(ut,t),M(Mt,t),M(Tt,t),M(dt,t),M(mt,t),M(ht,t),M(ft,t),M($t,t),M(gt,t),M(bt,t),M(Wt,t),M(Et,t),M(At,t),M(Vt,t),M(Nt,t),M(vt,t),M(Rt,t),M(Xt,t),M(Yt,t),M(St,t),M(zt,t),M(Ft,t),M(_t,t),M(Pt,t),M(Kt,t),M(ts,t)}}}const Nn='{"title":"Supported Transformers & Diffusers Tasks","local":"supported-transformers--diffusers-tasks","sections":[{"title":"Example Request payloads","local":"example-request-payloads","sections":[{"title":"Custom Handler","local":"custom-handler","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[{"title":"Classifying a single text","local":"classifying-a-single-text","sections":[],"depth":4},{"title":"Classifying a text pair","local":"classifying-a-text-pair","sections":[],"depth":4}],"depth":3},{"title":"Zero Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Token Classifiation","local":"token-classifiation","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Text to Text Generation","local":"text-to-text-generation","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Sentence Embeddings","local":"sentence-embeddings","sections":[],"depth":3},{"title":"Sentence similarity","local":"sentence-similarity","sections":[],"depth":3},{"title":"Ranking","local":"ranking","sections":[],"depth":3},{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Additional parameters","local":"additional-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zn(xa){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends En{constructor(m){super(),Gn(this,m,Zn,Vn,bn,{})}}export{Xn as component};
