import{s as Fl,o as Ll,n as Dl}from"../chunks/scheduler.65852ee5.js";import{S as Pl,i as Kl,g as o,s,r as i,A as Ol,h as m,f as l,c as a,j as zl,u as p,x as j,k as Xl,y as tn,a as n,v as d,d as r,t as M,w as c}from"../chunks/index.aa74147d.js";import{T as en}from"../chunks/Tip.bb8ccac8.js";import{D as ln,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as h,E as nn}from"../chunks/EditOnGithub.4eda6a96.js";function sn(xt){let g,T="You may need to email us for access to some architectures.";return{c(){g=o("p"),g.textContent=T},l(y){g=m(y,"P",{"data-svelte-h":!0}),j(g)!=="svelte-1bp4u19"&&(g.textContent=T)},m(y,_t){n(y,g,_t)},p:Dl,d(y){y&&l(g)}}}function an(xt){let g,T,y,_t,U,Ht,f,qt,b,Ml='<em>Authored by: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',Yt,J,zt,I,cl="I have a dataset I want to embed for semantic search (or QA, or RAG), I want the easiest way to do embed this and put it in a new dataset.",Xt,$,Ft,A,ol='I’m using a dataset from my favorite subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a>. Because it has long entries, I will use the new <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> since it has an 8k context length. I will deploy this using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a> to save time and money. To follow this tutorial, you will need to <strong>have already added a payment method</strong>. If you haven’t, you can add one here in <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">billing</a>. To make it even easier, I’ll make this fully API based.',Lt,C,ml='To make this MUCH faster I will use the <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> image. This has many benefits like:',Dt,B,jl="<li>No model graph compilation step</li> <li>Small docker images and fast boot times. Get ready for true serverless!</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",Pt,k,ul='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Kt,G,Ot,W,te,Z,ee,R,le,E,ne,v,gl=`<code>DATASET_IN</code> is where your text data is
<code>DATASET_OUT</code> is where your embeddings will be stored`,se,N,hl="Note I used 5 for the <code>MAX_WORKERS</code> since <code>jina-embeddings-v2</code> are quite memory hungry.",ae,Q,ie,V,yl='Inference Endpoints offers a number of GPUs that you can choose from. Check the <a href="https://huggingface.co/docs/inference-endpoints/en/pricing#gpu-instances" rel="nofollow">documentation</a> for GPU and alternative accelerators for information.',pe,w,de,_,wl='<thead><tr><th align="center">Provider</th> <th align="center">Instance Type</th> <th align="center">Instance Size</th> <th align="center">Hourly rate</th> <th align="center">GPUs</th> <th align="center">Memory</th> <th align="center">Architecture</th></tr></thead> <tbody><tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x1</td> <td align="center">\\$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">\\$0.5</td> <td align="center">1</td> <td align="center">14GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x4</td> <td align="center">\\$3</td> <td align="center">4</td> <td align="center">56GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">\\$0.8</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">\\$3.8</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">\\$4</td> <td align="center">1</td> <td align="center">80GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x4</td> <td align="center">\\$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">\\$8</td> <td align="center">2</td> <td align="center">160GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">\\$16</td> <td align="center">4</td> <td align="center">320GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">\\$32</td> <td align="center">8</td> <td align="center">640GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">\\$0.5</td> <td align="center">1</td> <td align="center">16GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">\\$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">\\$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">\\$6</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">\\$12</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">\\$24</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">\\$48</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x1</td> <td align="center">\\$12.5</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x2</td> <td align="center">\\$25</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x4</td> <td align="center">\\$50</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x8</td> <td align="center">\\$100</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x1</td> <td align="center">\\$0.75</td> <td align="center">1</td> <td align="center">32GB</td> <td align="center">AWS Inferentia2</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x12</td> <td align="center">\\$12</td> <td align="center">12</td> <td align="center">384GB</td> <td align="center">AWS Inferentia2</td></tr></tbody>',re,S,Me,x,ce,H,Tl="Some users might have payment registered in an organization. This allows you to connect to an organization (that you are a member of) with a payment method.",oe,q,Ul="Leave it blank is you want to use your username.",me,Y,je,z,fl=`What is your Hugging Face 🤗 username or organization? (with an added payment method) ········
`,ue,X,ge,F,he,L,ye,D,we,P,Te,K,bl='We are going to use the <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> to create an <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a>. This should provide a few main benefits:',Ue,O,Jl="<li>It’s convenient (No clicking)</li> <li>It’s repeatable (We have the code to run it easily)</li> <li>It’s cheaper (No time spent waiting for it to load, and automatically shut it down)</li>",fe,tt,be,et,Il="There are a few design choices here:",Je,lt,$l='<li>As discussed before we are using <code>jinaai/jina-embeddings-v2-base-en</code> as our model. <ul><li>For reproducibility we are pinning it to a specific revision.</li></ul></li> <li>If you are interested in more models, check out the supported list <a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">here</a>. <ul><li>Note that most embedding models are based on the BERT architecture.</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> is chosen based on our number of workers and the context window of our embedding model.</li> <li><code>type=&quot;protected&quot;</code> utilized the security from Inference Endpoints detailed here.</li> <li>I’m using <strong>1x Nvidia A10</strong> since <code>jina-embeddings-v2</code> is memory hungry (remember the 8k context length).</li> <li>You should consider further tuning <code>MAX_BATCH_TOKENS</code> and <code>MAX_CONCURRENT_REQUESTS</code> if you have high workloads</li>',Ie,nt,$e,st,Ae,at,Al=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,Ce,it,Cl="When we use <code>endpoint.client.post</code> we get a bytes string back. This is a little tedious because we need to convert this to an <code>np.array</code>, but it’s just a couple quick lines in python.",Be,pt,ke,dt,Bl="You may have inputs that exceed the context. In such scenarios, it’s up to you to handle them. In my case, I’d like to truncate rather than have an error. Let’s test that it works.",Ge,rt,We,Mt,kl=`The length of the embedding_input is: 300000
`,Ze,ct,Re,ot,Gl="Here I send a document, update it with the embedding, and return it. This happens in parallel with <code>MAX_WORKERS</code>.",Ee,mt,ve,jt,Ne,ut,Wl=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Qe,gt,Ve,ht,Zl="Now that we have finished, let’s pause the endpoint so we don’t incur any extra charges, this will also allow us to analyze the cost.",_e,yt,Se,wt,Rl=`Endpoint Status: paused
`,xe,Tt,He,Ut,El="We now have our documents updated with the embeddings we wanted. First we need to convert it back to a <code>Dataset</code> format. I find it easiest to go from list of dicts -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code>",qe,ft,Ye,bt,vl="I’m uploading it to the user’s account by default (as opposed to uploading to an organization) but feel free to push to wherever you want by setting the user in the <code>repo_id</code> or in the config by setting <code>DATASET_OUT</code>",ze,Jt,Xe,It,Fe,$t,Nl=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,Le,At,De,Ct,Ql="<li>Go to your <code>dashboard_url</code> printed below</li> <li>Click on the Usage &amp; Cost tab</li> <li>See how much you have spent</li>",Pe,Bt,Ke,kt,Vl=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,Oe,Gt,tl,Wt,_l=`Hit enter to continue with the notebook
`,el,Zt,Sl="We can see that it only took <code>$0.04</code> to pay for this!",ll,Rt,nl,Et,xl="Now that we are done, we don’t need our endpoint anymore. We can delete our endpoint programmatically.",sl,vt,Hl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',al,Nt,il,Qt,ql=`Endpoint deleted successfully
`,pl,Vt,dl,St,rl;return U=new ln({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/multiagent_assist_improvements/notebooks/en/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),f=new h({props:{title:"How to use Inference Endpoints to Embed Documents",local:"how-to-use-inference-endpoints-to-embed-documents",headingTag:"h1"}}),J=new h({props:{title:"Goal",local:"goal",headingTag:"h2"}}),$=new h({props:{title:"Approach",local:"approach",headingTag:"h2"}}),G=new h({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),W=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),Z=new h({props:{title:"Imports",local:"imports",headingTag:"h2"}}),R=new u({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),E=new h({props:{title:"Config",local:"config",headingTag:"h2"}}),Q=new u({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCUyMmRlcmVrLXRob21hcyUyRmRhdGFzZXQtY3JlYXRvci1yZWRkaXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBREFUQVNFVF9PVVQlMjAlM0QlMjAlMjJwcm9jZXNzZWQtc3Vic2V0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyUyMiUwQUVORFBPSU5UX05BTUUlMjAlM0QlMjAlMjJib3J1LWppbmEtZW1iZWRkaW5ncy1kZW1vLWllJTIyJTBBJTBBTUFYX1dPUktFUlMlMjAlM0QlMjA1JTIwJTIwJTIzJTIwVGhpcyUyMGlzJTIwZm9yJTIwaG93JTIwbWFueSUyMGFzeW5jJTIwd29ya2VycyUyMHlvdSUyMHdhbnQuJTIwQ2hvb3NlJTIwYmFzZWQlMjBvbiUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwaGFyZHdhcmUlMEFST1dfQ09VTlQlMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBDaG9vc2UlMjBOb25lJTIwdG8lMjB1c2UlMjBhbGwlMjByb3dzJTJDJTIwSW0lMjB1c2luZyUyMDEwMCUyMGp1c3QlMjBmb3IlMjBhJTIwZGVtbw==",highlighted:`DATASET_IN = <span class="hljs-string">&quot;derek-thomas/dataset-creator-reddit-bestofredditorupdates&quot;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware</span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),w=new en({props:{warning:!1,$$slots:{default:[sn]},$$scope:{ctx:xt}}}),S=new u({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTIwJTNEJTIwJTIyYXdzJTIyJTBBUkVHSU9OJTIwJTNEJTIwJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUyMCUzRCUyMCUyMngxJTIyJTBBSU5TVEFOQ0VfVFlQRSUyMCUzRCUyMCUyMm52aWRpYS1hMTBnJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR = <span class="hljs-string">&quot;aws&quot;</span>
REGION = <span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE = <span class="hljs-string">&quot;x1&quot;</span>
INSTANCE_TYPE = <span class="hljs-string">&quot;nvidia-a10g&quot;</span>`,wrap:!1}}),x=new u({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),Y=new u({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiUwQSklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiUyMm5hbWUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>who = whoami()
<span class="hljs-meta">&gt;&gt;&gt; </span>organization = getpass(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&quot;name&quot;</span>]`,wrap:!1}}),X=new h({props:{title:"Get Dataset",local:"get-dataset",headingTag:"h2"}}),F=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RA==",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),L=new u({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRvX3BhbmRhcygpLnRvX2RpY3QoJTIycmVjb3JkcyUyMiklNUIlM0FST1dfQ09VTlQlNUQlMEFsZW4oZG9jdW1lbnRzKSUyQyUyMGRvY3VtZW50cyU1QjAlNUQ=",highlighted:`documents = dataset[<span class="hljs-string">&quot;train&quot;</span>].to_pandas().to_dict(<span class="hljs-string">&quot;records&quot;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new h({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),P=new h({props:{title:"Create Inference Endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),tt=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loaded endpoint&quot;</span>)`,wrap:!1}}),nt=new h({props:{title:"Wait until it’s running",local:"wait-until-its-running",headingTag:"h2"}}),st=new u({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),pt=new u({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjBqc29uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMEEpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`response = endpoint.client.post(
    json={
        <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>,
        <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>,
    },
    task=<span class="hljs-string">&quot;feature-extraction&quot;</span>,
)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),rt=new u({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJTIyVGhpcyUyMGlucHV0JTIwd2lsbCUyMGdldCUyMG11bHRpcGxpZWQlMjIlMjAqJTIwMTAwMDAlMEFwcmludChmJTIyVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGVtYmVkZGluZ19pbnB1dCUyQyUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&quot;This input will get multiplied&quot;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),ct=new h({props:{title:"Get Embeddings",local:"get-embeddings",headingTag:"h1"}}),mt=new u({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUIlMjJjb250ZW50JTIyJTVEJTJDJTIwJTIydHJ1bmNhdGUlMjIlM0ElMjBUcnVlJTdEJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3VsdC5kZWNvZGUoKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(
            json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>
        )
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&quot;embedding&quot;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]

    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),jt=new u({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyZW1iZWRkaW5nJTIyJTIwaW4lMjBkb2N1bWVudC5rZXlzKCklMjBhbmQlMjBsZW4oZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQpJTIwJTNEJTNEJTIwNzY4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY291bnQlMjAlMkIlM0QlMjAxJTBBcHJpbnQoZiUyMkVtYmVkZGluZ3MlMjAlM0QlMjAlN0Jjb3VudCU3RCUyMGRvY3VtZW50cyUyMCUzRCUyMCU3Qmxlbihkb2N1bWVudHMpJTdEJTIyKSUwQSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;embedding&quot;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&quot;embedding&quot;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),gt=new h({props:{title:"Pause Inference Endpoint",local:"pause-inference-endpoint",headingTag:"h2"}}),yt=new u({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),Tt=new h({props:{title:"Push updated dataset to Hub",local:"push-updated-dataset-to-hub",headingTag:"h1"}}),ft=new u({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTIydHJhaW4lMjIlM0ElMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSU3RCk=",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&quot;train&quot;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),Jt=new u({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),It=new u({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),At=new h({props:{title:"Analyze Usage",local:"analyze-usage",headingTag:"h1"}}),Bt=new u({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRnVpLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbyUyRiU3Qm5hbWVzcGFjZSU3RCUyRmVuZHBvaW50cyUyRiU3QkVORFBPSU5UX05BTUUlN0QlMjIlMEFwcmludChkYXNoYm9hcmRfdXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&quot;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),Gt=new u({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),Rt=new h({props:{title:"Delete Endpoint",local:"delete-endpoint",headingTag:"h1"}}),Nt=new u({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmRwb2ludCUyMGRlbGV0ZWQlMjBzdWNjZXNzZnVsbHklMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkRlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint deleted successfully&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Delete Endpoint in manually&quot;</span>)`,wrap:!1}}),Vt=new nn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.md"}}),{c(){g=o("meta"),T=s(),y=o("p"),_t=s(),i(U.$$.fragment),Ht=s(),i(f.$$.fragment),qt=s(),b=o("p"),b.innerHTML=Ml,Yt=s(),i(J.$$.fragment),zt=s(),I=o("p"),I.textContent=cl,Xt=s(),i($.$$.fragment),Ft=s(),A=o("p"),A.innerHTML=ol,Lt=s(),C=o("p"),C.innerHTML=ml,Dt=s(),B=o("ul"),B.innerHTML=jl,Pt=s(),k=o("p"),k.innerHTML=ul,Kt=s(),i(G.$$.fragment),Ot=s(),i(W.$$.fragment),te=s(),i(Z.$$.fragment),ee=s(),i(R.$$.fragment),le=s(),i(E.$$.fragment),ne=s(),v=o("p"),v.innerHTML=gl,se=s(),N=o("p"),N.innerHTML=hl,ae=s(),i(Q.$$.fragment),ie=s(),V=o("p"),V.innerHTML=yl,pe=s(),i(w.$$.fragment),de=s(),_=o("table"),_.innerHTML=wl,re=s(),i(S.$$.fragment),Me=s(),i(x.$$.fragment),ce=s(),H=o("p"),H.textContent=Tl,oe=s(),q=o("p"),q.textContent=Ul,me=s(),i(Y.$$.fragment),je=s(),z=o("pre"),z.textContent=fl,ue=s(),i(X.$$.fragment),ge=s(),i(F.$$.fragment),he=s(),i(L.$$.fragment),ye=s(),i(D.$$.fragment),we=s(),i(P.$$.fragment),Te=s(),K=o("p"),K.innerHTML=bl,Ue=s(),O=o("ul"),O.innerHTML=Jl,fe=s(),i(tt.$$.fragment),be=s(),et=o("p"),et.textContent=Il,Je=s(),lt=o("ul"),lt.innerHTML=$l,Ie=s(),i(nt.$$.fragment),$e=s(),i(st.$$.fragment),Ae=s(),at=o("pre"),at.textContent=Al,Ce=s(),it=o("p"),it.innerHTML=Cl,Be=s(),i(pt.$$.fragment),ke=s(),dt=o("p"),dt.textContent=Bl,Ge=s(),i(rt.$$.fragment),We=s(),Mt=o("pre"),Mt.textContent=kl,Ze=s(),i(ct.$$.fragment),Re=s(),ot=o("p"),ot.innerHTML=Gl,Ee=s(),i(mt.$$.fragment),ve=s(),i(jt.$$.fragment),Ne=s(),ut=o("pre"),ut.textContent=Wl,Qe=s(),i(gt.$$.fragment),Ve=s(),ht=o("p"),ht.textContent=Zl,_e=s(),i(yt.$$.fragment),Se=s(),wt=o("pre"),wt.textContent=Rl,xe=s(),i(Tt.$$.fragment),He=s(),Ut=o("p"),Ut.innerHTML=El,qe=s(),i(ft.$$.fragment),Ye=s(),bt=o("p"),bt.innerHTML=vl,ze=s(),i(Jt.$$.fragment),Xe=s(),i(It.$$.fragment),Fe=s(),$t=o("pre"),$t.textContent=Nl,Le=s(),i(At.$$.fragment),De=s(),Ct=o("ol"),Ct.innerHTML=Ql,Pe=s(),i(Bt.$$.fragment),Ke=s(),kt=o("pre"),kt.textContent=Vl,Oe=s(),i(Gt.$$.fragment),tl=s(),Wt=o("pre"),Wt.textContent=_l,el=s(),Zt=o("p"),Zt.innerHTML=Sl,ll=s(),i(Rt.$$.fragment),nl=s(),Et=o("p"),Et.textContent=xl,sl=s(),vt=o("p"),vt.innerHTML=Hl,al=s(),i(Nt.$$.fragment),il=s(),Qt=o("pre"),Qt.textContent=ql,pl=s(),i(Vt.$$.fragment),dl=s(),St=o("p"),this.h()},l(t){const e=Ol("svelte-u9bgzb",document.head);g=m(e,"META",{name:!0,content:!0}),e.forEach(l),T=a(t),y=m(t,"P",{}),zl(y).forEach(l),_t=a(t),p(U.$$.fragment,t),Ht=a(t),p(f.$$.fragment,t),qt=a(t),b=m(t,"P",{"data-svelte-h":!0}),j(b)!=="svelte-kkdsiw"&&(b.innerHTML=Ml),Yt=a(t),p(J.$$.fragment,t),zt=a(t),I=m(t,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1qwdsg4"&&(I.textContent=cl),Xt=a(t),p($.$$.fragment,t),Ft=a(t),A=m(t,"P",{"data-svelte-h":!0}),j(A)!=="svelte-cznpu6"&&(A.innerHTML=ol),Lt=a(t),C=m(t,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1bpd7g5"&&(C.innerHTML=ml),Dt=a(t),B=m(t,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-amjqu"&&(B.innerHTML=jl),Pt=a(t),k=m(t,"P",{"data-svelte-h":!0}),j(k)!=="svelte-12ly3c2"&&(k.innerHTML=ul),Kt=a(t),p(G.$$.fragment,t),Ot=a(t),p(W.$$.fragment,t),te=a(t),p(Z.$$.fragment,t),ee=a(t),p(R.$$.fragment,t),le=a(t),p(E.$$.fragment,t),ne=a(t),v=m(t,"P",{"data-svelte-h":!0}),j(v)!=="svelte-roo1xs"&&(v.innerHTML=gl),se=a(t),N=m(t,"P",{"data-svelte-h":!0}),j(N)!=="svelte-10xqojr"&&(N.innerHTML=hl),ae=a(t),p(Q.$$.fragment,t),ie=a(t),V=m(t,"P",{"data-svelte-h":!0}),j(V)!=="svelte-i0fwvi"&&(V.innerHTML=yl),pe=a(t),p(w.$$.fragment,t),de=a(t),_=m(t,"TABLE",{"data-svelte-h":!0}),j(_)!=="svelte-7ezz4v"&&(_.innerHTML=wl),re=a(t),p(S.$$.fragment,t),Me=a(t),p(x.$$.fragment,t),ce=a(t),H=m(t,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1oubx8o"&&(H.textContent=Tl),oe=a(t),q=m(t,"P",{"data-svelte-h":!0}),j(q)!=="svelte-13so4pe"&&(q.textContent=Ul),me=a(t),p(Y.$$.fragment,t),je=a(t),z=m(t,"PRE",{"data-svelte-h":!0}),j(z)!=="svelte-19lh5zm"&&(z.textContent=fl),ue=a(t),p(X.$$.fragment,t),ge=a(t),p(F.$$.fragment,t),he=a(t),p(L.$$.fragment,t),ye=a(t),p(D.$$.fragment,t),we=a(t),p(P.$$.fragment,t),Te=a(t),K=m(t,"P",{"data-svelte-h":!0}),j(K)!=="svelte-8d5fhe"&&(K.innerHTML=bl),Ue=a(t),O=m(t,"UL",{"data-svelte-h":!0}),j(O)!=="svelte-16ejamp"&&(O.innerHTML=Jl),fe=a(t),p(tt.$$.fragment,t),be=a(t),et=m(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-1whwkpr"&&(et.textContent=Il),Je=a(t),lt=m(t,"UL",{"data-svelte-h":!0}),j(lt)!=="svelte-9i31ws"&&(lt.innerHTML=$l),Ie=a(t),p(nt.$$.fragment,t),$e=a(t),p(st.$$.fragment,t),Ae=a(t),at=m(t,"PRE",{"data-svelte-h":!0}),j(at)!=="svelte-19liytu"&&(at.textContent=Al),Ce=a(t),it=m(t,"P",{"data-svelte-h":!0}),j(it)!=="svelte-il5t0k"&&(it.innerHTML=Cl),Be=a(t),p(pt.$$.fragment,t),ke=a(t),dt=m(t,"P",{"data-svelte-h":!0}),j(dt)!=="svelte-16s019k"&&(dt.textContent=Bl),Ge=a(t),p(rt.$$.fragment,t),We=a(t),Mt=m(t,"PRE",{"data-svelte-h":!0}),j(Mt)!=="svelte-11ebe9s"&&(Mt.textContent=kl),Ze=a(t),p(ct.$$.fragment,t),Re=a(t),ot=m(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-iwjedl"&&(ot.innerHTML=Gl),Ee=a(t),p(mt.$$.fragment,t),ve=a(t),p(jt.$$.fragment,t),Ne=a(t),ut=m(t,"PRE",{"data-svelte-h":!0}),j(ut)!=="svelte-ff4u6w"&&(ut.textContent=Wl),Qe=a(t),p(gt.$$.fragment,t),Ve=a(t),ht=m(t,"P",{"data-svelte-h":!0}),j(ht)!=="svelte-80w8ff"&&(ht.textContent=Zl),_e=a(t),p(yt.$$.fragment,t),Se=a(t),wt=m(t,"PRE",{"data-svelte-h":!0}),j(wt)!=="svelte-v5xolv"&&(wt.textContent=Rl),xe=a(t),p(Tt.$$.fragment,t),He=a(t),Ut=m(t,"P",{"data-svelte-h":!0}),j(Ut)!=="svelte-13ozgsg"&&(Ut.innerHTML=El),qe=a(t),p(ft.$$.fragment,t),Ye=a(t),bt=m(t,"P",{"data-svelte-h":!0}),j(bt)!=="svelte-1t2e8el"&&(bt.innerHTML=vl),ze=a(t),p(Jt.$$.fragment,t),Xe=a(t),p(It.$$.fragment,t),Fe=a(t),$t=m(t,"PRE",{"data-svelte-h":!0}),j($t)!=="svelte-dj57zs"&&($t.textContent=Nl),Le=a(t),p(At.$$.fragment,t),De=a(t),Ct=m(t,"OL",{"data-svelte-h":!0}),j(Ct)!=="svelte-seqler"&&(Ct.innerHTML=Ql),Pe=a(t),p(Bt.$$.fragment,t),Ke=a(t),kt=m(t,"PRE",{"data-svelte-h":!0}),j(kt)!=="svelte-109618w"&&(kt.textContent=Vl),Oe=a(t),p(Gt.$$.fragment,t),tl=a(t),Wt=m(t,"PRE",{"data-svelte-h":!0}),j(Wt)!=="svelte-1gk9phr"&&(Wt.textContent=_l),el=a(t),Zt=m(t,"P",{"data-svelte-h":!0}),j(Zt)!=="svelte-1ga4kzi"&&(Zt.innerHTML=Sl),ll=a(t),p(Rt.$$.fragment,t),nl=a(t),Et=m(t,"P",{"data-svelte-h":!0}),j(Et)!=="svelte-3kjw6t"&&(Et.textContent=xl),sl=a(t),vt=m(t,"P",{"data-svelte-h":!0}),j(vt)!=="svelte-1124toy"&&(vt.innerHTML=Hl),al=a(t),p(Nt.$$.fragment,t),il=a(t),Qt=m(t,"PRE",{"data-svelte-h":!0}),j(Qt)!=="svelte-ulyp9n"&&(Qt.textContent=ql),pl=a(t),p(Vt.$$.fragment,t),dl=a(t),St=m(t,"P",{}),zl(St).forEach(l),this.h()},h(){Xl(g,"name","hf:doc:metadata"),Xl(g,"content",pn)},m(t,e){tn(document.head,g),n(t,T,e),n(t,y,e),n(t,_t,e),d(U,t,e),n(t,Ht,e),d(f,t,e),n(t,qt,e),n(t,b,e),n(t,Yt,e),d(J,t,e),n(t,zt,e),n(t,I,e),n(t,Xt,e),d($,t,e),n(t,Ft,e),n(t,A,e),n(t,Lt,e),n(t,C,e),n(t,Dt,e),n(t,B,e),n(t,Pt,e),n(t,k,e),n(t,Kt,e),d(G,t,e),n(t,Ot,e),d(W,t,e),n(t,te,e),d(Z,t,e),n(t,ee,e),d(R,t,e),n(t,le,e),d(E,t,e),n(t,ne,e),n(t,v,e),n(t,se,e),n(t,N,e),n(t,ae,e),d(Q,t,e),n(t,ie,e),n(t,V,e),n(t,pe,e),d(w,t,e),n(t,de,e),n(t,_,e),n(t,re,e),d(S,t,e),n(t,Me,e),d(x,t,e),n(t,ce,e),n(t,H,e),n(t,oe,e),n(t,q,e),n(t,me,e),d(Y,t,e),n(t,je,e),n(t,z,e),n(t,ue,e),d(X,t,e),n(t,ge,e),d(F,t,e),n(t,he,e),d(L,t,e),n(t,ye,e),d(D,t,e),n(t,we,e),d(P,t,e),n(t,Te,e),n(t,K,e),n(t,Ue,e),n(t,O,e),n(t,fe,e),d(tt,t,e),n(t,be,e),n(t,et,e),n(t,Je,e),n(t,lt,e),n(t,Ie,e),d(nt,t,e),n(t,$e,e),d(st,t,e),n(t,Ae,e),n(t,at,e),n(t,Ce,e),n(t,it,e),n(t,Be,e),d(pt,t,e),n(t,ke,e),n(t,dt,e),n(t,Ge,e),d(rt,t,e),n(t,We,e),n(t,Mt,e),n(t,Ze,e),d(ct,t,e),n(t,Re,e),n(t,ot,e),n(t,Ee,e),d(mt,t,e),n(t,ve,e),d(jt,t,e),n(t,Ne,e),n(t,ut,e),n(t,Qe,e),d(gt,t,e),n(t,Ve,e),n(t,ht,e),n(t,_e,e),d(yt,t,e),n(t,Se,e),n(t,wt,e),n(t,xe,e),d(Tt,t,e),n(t,He,e),n(t,Ut,e),n(t,qe,e),d(ft,t,e),n(t,Ye,e),n(t,bt,e),n(t,ze,e),d(Jt,t,e),n(t,Xe,e),d(It,t,e),n(t,Fe,e),n(t,$t,e),n(t,Le,e),d(At,t,e),n(t,De,e),n(t,Ct,e),n(t,Pe,e),d(Bt,t,e),n(t,Ke,e),n(t,kt,e),n(t,Oe,e),d(Gt,t,e),n(t,tl,e),n(t,Wt,e),n(t,el,e),n(t,Zt,e),n(t,ll,e),d(Rt,t,e),n(t,nl,e),n(t,Et,e),n(t,sl,e),n(t,vt,e),n(t,al,e),d(Nt,t,e),n(t,il,e),n(t,Qt,e),n(t,pl,e),d(Vt,t,e),n(t,dl,e),n(t,St,e),rl=!0},p(t,[e]){const Yl={};e&2&&(Yl.$$scope={dirty:e,ctx:t}),w.$set(Yl)},i(t){rl||(r(U.$$.fragment,t),r(f.$$.fragment,t),r(J.$$.fragment,t),r($.$$.fragment,t),r(G.$$.fragment,t),r(W.$$.fragment,t),r(Z.$$.fragment,t),r(R.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),r(w.$$.fragment,t),r(S.$$.fragment,t),r(x.$$.fragment,t),r(Y.$$.fragment,t),r(X.$$.fragment,t),r(F.$$.fragment,t),r(L.$$.fragment,t),r(D.$$.fragment,t),r(P.$$.fragment,t),r(tt.$$.fragment,t),r(nt.$$.fragment,t),r(st.$$.fragment,t),r(pt.$$.fragment,t),r(rt.$$.fragment,t),r(ct.$$.fragment,t),r(mt.$$.fragment,t),r(jt.$$.fragment,t),r(gt.$$.fragment,t),r(yt.$$.fragment,t),r(Tt.$$.fragment,t),r(ft.$$.fragment,t),r(Jt.$$.fragment,t),r(It.$$.fragment,t),r(At.$$.fragment,t),r(Bt.$$.fragment,t),r(Gt.$$.fragment,t),r(Rt.$$.fragment,t),r(Nt.$$.fragment,t),r(Vt.$$.fragment,t),rl=!0)},o(t){M(U.$$.fragment,t),M(f.$$.fragment,t),M(J.$$.fragment,t),M($.$$.fragment,t),M(G.$$.fragment,t),M(W.$$.fragment,t),M(Z.$$.fragment,t),M(R.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),M(w.$$.fragment,t),M(S.$$.fragment,t),M(x.$$.fragment,t),M(Y.$$.fragment,t),M(X.$$.fragment,t),M(F.$$.fragment,t),M(L.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(st.$$.fragment,t),M(pt.$$.fragment,t),M(rt.$$.fragment,t),M(ct.$$.fragment,t),M(mt.$$.fragment,t),M(jt.$$.fragment,t),M(gt.$$.fragment,t),M(yt.$$.fragment,t),M(Tt.$$.fragment,t),M(ft.$$.fragment,t),M(Jt.$$.fragment,t),M(It.$$.fragment,t),M(At.$$.fragment,t),M(Bt.$$.fragment,t),M(Gt.$$.fragment,t),M(Rt.$$.fragment,t),M(Nt.$$.fragment,t),M(Vt.$$.fragment,t),rl=!1},d(t){t&&(l(T),l(y),l(_t),l(Ht),l(qt),l(b),l(Yt),l(zt),l(I),l(Xt),l(Ft),l(A),l(Lt),l(C),l(Dt),l(B),l(Pt),l(k),l(Kt),l(Ot),l(te),l(ee),l(le),l(ne),l(v),l(se),l(N),l(ae),l(ie),l(V),l(pe),l(de),l(_),l(re),l(Me),l(ce),l(H),l(oe),l(q),l(me),l(je),l(z),l(ue),l(ge),l(he),l(ye),l(we),l(Te),l(K),l(Ue),l(O),l(fe),l(be),l(et),l(Je),l(lt),l(Ie),l($e),l(Ae),l(at),l(Ce),l(it),l(Be),l(ke),l(dt),l(Ge),l(We),l(Mt),l(Ze),l(Re),l(ot),l(Ee),l(ve),l(Ne),l(ut),l(Qe),l(Ve),l(ht),l(_e),l(Se),l(wt),l(xe),l(He),l(Ut),l(qe),l(Ye),l(bt),l(ze),l(Xe),l(Fe),l($t),l(Le),l(De),l(Ct),l(Pe),l(Ke),l(kt),l(Oe),l(tl),l(Wt),l(el),l(Zt),l(ll),l(nl),l(Et),l(sl),l(vt),l(al),l(il),l(Qt),l(pl),l(dl),l(St)),l(g),c(U,t),c(f,t),c(J,t),c($,t),c(G,t),c(W,t),c(Z,t),c(R,t),c(E,t),c(Q,t),c(w,t),c(S,t),c(x,t),c(Y,t),c(X,t),c(F,t),c(L,t),c(D,t),c(P,t),c(tt,t),c(nt,t),c(st,t),c(pt,t),c(rt,t),c(ct,t),c(mt,t),c(jt,t),c(gt,t),c(yt,t),c(Tt,t),c(ft,t),c(Jt,t),c(It,t),c(At,t),c(Bt,t),c(Gt,t),c(Rt,t),c(Nt,t),c(Vt,t)}}}const pn='{"title":"How to use Inference Endpoints to Embed Documents","local":"how-to-use-inference-endpoints-to-embed-documents","sections":[{"title":"Goal","local":"goal","sections":[],"depth":2},{"title":"Approach","local":"approach","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Imports","local":"imports","sections":[],"depth":2},{"title":"Config","local":"config","sections":[],"depth":2},{"title":"Get Dataset","local":"get-dataset","sections":[],"depth":2}],"depth":1}';function dn(xt){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jn extends Pl{constructor(g){super(),Kl(this,g,dn,an,Fl,{})}}export{jn as component};
