import{s as Zt,o as Qt,n as St}from"../chunks/scheduler.f7e1785c.js";import{S as kt,i as Rt,g as J,s as p,r as j,A as xt,h as c,f as s,c as M,j as Et,u as I,x as w,k as Gt,y as Vt,a as n,v as y,d,t as m,w as h}from"../chunks/index.d8354395.js";import{Y as _t}from"../chunks/Youtube.90a37f73.js";import{C as It}from"../chunks/CodeBlock.191e5103.js";import{H as z,E as Xt}from"../chunks/getInferenceSnippets.7dc21f71.js";import{H as Yt,a as Nt}from"../chunks/HfOption.05895b59.js";function Wt(U){let a,i,o,T;return a=new _t({props:{id:"exzrb5QNUis"}}),o=new It({props:{code:"ZnJvbSUyMG1jcC5zZXJ2ZXIuZmFzdG1jcCUyMGltcG9ydCUyMEZhc3RNQ1AlMEElMEElMjMlMjBDcmVhdGUlMjBhbiUyME1DUCUyMHNlcnZlciUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBJTIzJTIwVG9vbCUyMGltcGxlbWVudGF0aW9uJTBBJTQwbWNwLnRvb2woKSUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB0aGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGZvciUyMGElMjBzcGVjaWZpZWQlMjBsb2NhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyV2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlM0ElMjBTdW5ueSUyQyUyMDcyJUMyJUIwRiUyMiUwQSUwQSUyMyUyMFJlc291cmNlJTIwaW1wbGVtZW50YXRpb24lMEElNDBtY3AucmVzb3VyY2UoJTIyd2VhdGhlciUzQSUyRiUyRiU3QmxvY2F0aW9uJTdEJTIyKSUwQWRlZiUyMHdlYXRoZXJfcmVzb3VyY2UobG9jYXRpb24lM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlByb3ZpZGUlMjB3ZWF0aGVyJTIwZGF0YSUyMGFzJTIwYSUyMHJlc291cmNlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJXZWF0aGVyJTIwZGF0YSUyMGZvciUyMCU3QmxvY2F0aW9uJTdEJTNBJTIwU3VubnklMkMlMjA3MiVDMiVCMEYlMjIlMEElMEElMjMlMjBQcm9tcHQlMjBpbXBsZW1lbnRhdGlvbiUwQSU0MG1jcC5wcm9tcHQoKSUwQWRlZiUyMHdlYXRoZXJfcmVwb3J0KGxvY2F0aW9uJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDcmVhdGUlMjBhJTIwd2VhdGhlciUyMHJlcG9ydCUyMHByb21wdC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyJTIyJTIyWW91JTIwYXJlJTIwYSUyMHdlYXRoZXIlMjByZXBvcnRlci4lMjBXZWF0aGVyJTIwcmVwb3J0JTIwZm9yJTIwJTdCbG9jYXRpb24lN0QlM0YlMjIlMjIlMjIlMEElMEElMEElMjMlMjBSdW4lMjB0aGUlMjBzZXJ2ZXIlMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtY3AucnVuKCklMEE=",highlighted:`<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

<span class="hljs-comment"># Create an MCP server</span>
mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)

<span class="hljs-comment"># Tool implementation</span>
<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Get the current weather for a specified location.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather in <span class="hljs-subst">{location}</span>: Sunny, 72°F&quot;</span>

<span class="hljs-comment"># Resource implementation</span>
<span class="hljs-meta">@mcp.resource(<span class="hljs-params"><span class="hljs-string">&quot;weather://{location}&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">weather_resource</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Provide weather data as a resource.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather data for <span class="hljs-subst">{location}</span>: Sunny, 72°F&quot;</span>

<span class="hljs-comment"># Prompt implementation</span>
<span class="hljs-meta">@mcp.prompt()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">weather_report</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Create a weather report prompt.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;&quot;&quot;You are a weather reporter. Weather report for <span class="hljs-subst">{location}</span>?&quot;&quot;&quot;</span>


<span class="hljs-comment"># Run the server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    mcp.run()
`,wrap:!1}}),{c(){j(a.$$.fragment),i=p(),j(o.$$.fragment)},l(e){I(a.$$.fragment,e),i=M(e),I(o.$$.fragment,e)},m(e,r){y(a,e,r),n(e,i,r),y(o,e,r),T=!0},p:St,i(e){T||(d(a.$$.fragment,e),d(o.$$.fragment,e),T=!0)},o(e){m(a.$$.fragment,e),m(o.$$.fragment,e),T=!1},d(e){e&&s(i),h(a,e),h(o,e)}}}function qt(U){let a,i;return a=new It({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">McpServer</span>, <span class="hljs-title class_">ResourceTemplate</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@modelcontextprotocol/sdk/server/mcp.js&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">StdioServerTransport</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@modelcontextprotocol/sdk/server/stdio.js&quot;</span>;
<span class="hljs-keyword">import</span> { z } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;zod&quot;</span>;

<span class="hljs-comment">// Create an MCP server</span>
<span class="hljs-keyword">const</span> server = <span class="hljs-keyword">new</span> <span class="hljs-title class_">McpServer</span>({
    <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;Weather Service&quot;</span>,
    <span class="hljs-attr">version</span>: <span class="hljs-string">&quot;1.0.0&quot;</span>
});

<span class="hljs-comment">// Tool implementation</span>
server.<span class="hljs-title function_">tool</span>(<span class="hljs-string">&quot;get_weather&quot;</span>,
    { <span class="hljs-attr">location</span>: z.<span class="hljs-title function_">string</span>() },
    <span class="hljs-keyword">async</span> ({ location }) =&gt; ({
        <span class="hljs-attr">content</span>: [{
            <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather in <span class="hljs-subst">\${location}</span>: Sunny, 72°F\`</span>
        }]
    })
);

<span class="hljs-comment">// Resource implementation</span>
server.<span class="hljs-title function_">resource</span>(
    <span class="hljs-string">&quot;weather&quot;</span>,
    <span class="hljs-keyword">new</span> <span class="hljs-title class_">ResourceTemplate</span>(<span class="hljs-string">&quot;weather://{location}&quot;</span>, { <span class="hljs-attr">list</span>: <span class="hljs-literal">undefined</span> }),
    <span class="hljs-keyword">async</span> (uri, { location }) =&gt; ({
        <span class="hljs-attr">contents</span>: [{
            <span class="hljs-attr">uri</span>: uri.<span class="hljs-property">href</span>,
            <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather data for <span class="hljs-subst">\${location}</span>: Sunny, 72°F\`</span>
        }]
    })
);

<span class="hljs-comment">// Prompt implementation</span>
server.<span class="hljs-title function_">prompt</span>(
    <span class="hljs-string">&quot;weather_report&quot;</span>,
    { <span class="hljs-attr">location</span>: z.<span class="hljs-title function_">string</span>() },
    <span class="hljs-keyword">async</span> ({ location }) =&gt; ({
        <span class="hljs-attr">messages</span>: [
            {
                <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-attr">content</span>: {
                    <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-attr">text</span>: <span class="hljs-string">&quot;You are a weather reporter.&quot;</span>
                }
            },
            {
                <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-attr">content</span>: {
                    <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather report for <span class="hljs-subst">\${location}</span>?\`</span>
                }
            }
        ]
    })
);

<span class="hljs-comment">// Run the server</span>
<span class="hljs-keyword">const</span> transport = <span class="hljs-keyword">new</span> <span class="hljs-title class_">StdioServerTransport</span>();
<span class="hljs-keyword">await</span> server.<span class="hljs-title function_">connect</span>(transport);`,wrap:!1}}),{c(){j(a.$$.fragment)},l(o){I(a.$$.fragment,o)},m(o,T){y(a,o,T),i=!0},p:St,i(o){i||(d(a.$$.fragment,o),i=!0)},o(o){m(a.$$.fragment,o),i=!1},d(o){h(a,o)}}}function zt(U){let a,i,o,T;return a=new Nt({props:{id:"server-implementation",option:"python",$$slots:{default:[Wt]},$$scope:{ctx:U}}}),o=new Nt({props:{id:"server-implementation",option:"javascript",$$slots:{default:[qt]},$$scope:{ctx:U}}}),{c(){j(a.$$.fragment),i=p(),j(o.$$.fragment)},l(e){I(a.$$.fragment,e),i=M(e),I(o.$$.fragment,e)},m(e,r){y(a,e,r),n(e,i,r),y(o,e,r),T=!0},p(e,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:e}),a.$set(u);const W={};r&2&&(W.$$scope={dirty:r,ctx:e}),o.$set(W)},i(e){T||(d(a.$$.fragment,e),d(o.$$.fragment,e),T=!0)},o(e){m(a.$$.fragment,e),m(o.$$.fragment,e),T=!1},d(e){e&&s(i),h(a,e),h(o,e)}}}function Ft(U){let a,i,o,T,e,r,u,W="The Model Context Protocol provides official SDKs for both JavaScript, Python and other languages. This makes it easy to implement MCP clients and servers in your applications. These SDKs handle the low-level protocol details, allowing you to focus on building your application’s capabilities.",F,f,H,b,yt="Both SDKs provide similar core functionality, following the MCP protocol specification we discussed earlier. They handle:",P,B,dt="<li>Protocol-level communication</li> <li>Capability registration and discovery</li> <li>Message serialization/deserialization</li> <li>Connection management</li> <li>Error handling</li>",D,v,K,A,mt="Let’s explore how to implement each of the core primitives (Tools, Resources, and Prompts) using both SDKs.",L,C,O,$,ht="Once you have your server implemented, you can start it by running the server script.",tt,g,lt,E,ut="This will initialize a development server running the file <code>server.py</code>. And log the following output:",st,G,et,N,Ut='You can then open the MCP Inspector at <a href="http://127.0.0.1:6274" rel="nofollow">http://127.0.0.1:6274</a> to see the server’s capabilities and interact with them.',nt,S,Ct="You’ll see the server’s capabilities and the ability to call them via the UI.",at,Z,ft='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit1/6.png" alt="MCP Inspector"/>',ot,Q,pt,k,bt="MCP is designed to be language-agnostic, and there are official SDKs available for several popular programming languages:",Mt,R,Bt='<thead><tr><th>Language</th> <th>Repository</th> <th>Maintainer(s)</th> <th>Status</th></tr></thead> <tbody><tr><td>TypeScript</td> <td><a href="https://github.com/modelcontextprotocol/typescript-sdk" rel="nofollow">github.com/modelcontextprotocol/typescript-sdk</a></td> <td>Anthropic</td> <td>Active</td></tr> <tr><td>Python</td> <td><a href="https://github.com/modelcontextprotocol/python-sdk" rel="nofollow">github.com/modelcontextprotocol/python-sdk</a></td> <td>Anthropic</td> <td>Active</td></tr> <tr><td>Java</td> <td><a href="https://github.com/modelcontextprotocol/java-sdk" rel="nofollow">github.com/modelcontextprotocol/java-sdk</a></td> <td>Spring AI (VMware)</td> <td>Active</td></tr> <tr><td>Kotlin</td> <td><a href="https://github.com/modelcontextprotocol/kotlin-sdk" rel="nofollow">github.com/modelcontextprotocol/kotlin-sdk</a></td> <td>JetBrains</td> <td>Active</td></tr> <tr><td>C#</td> <td><a href="https://github.com/modelcontextprotocol/csharp-sdk" rel="nofollow">github.com/modelcontextprotocol/csharp-sdk</a></td> <td>Microsoft</td> <td>Active (Preview)</td></tr> <tr><td>Swift</td> <td><a href="https://github.com/modelcontextprotocol/swift-sdk" rel="nofollow">github.com/modelcontextprotocol/swift-sdk</a></td> <td>loopwork-ai</td> <td>Active</td></tr> <tr><td>Rust</td> <td><a href="https://github.com/modelcontextprotocol/rust-sdk" rel="nofollow">github.com/modelcontextprotocol/rust-sdk</a></td> <td>Anthropic/Community</td> <td>Active</td></tr> <tr><td>Dart</td> <td><a href="https://github.com/leehack/mcp_dart" rel="nofollow">https://github.com/leehack/mcp_dart</a></td> <td>Flutter Community</td> <td>Active</td></tr></tbody>',it,x,vt="These SDKs provide language-specific abstractions that simplify working with the MCP protocol, allowing you to focus on implementing the core logic of your servers or clients rather than dealing with low-level protocol details.",rt,V,Jt,_,At="We’ve only scratched the surface of what you can do with the MCP but you’ve already got a basic server running. In fact, you’ve also connected to it using the MCP Client in the browser.",ct,X,$t="In the next section, we’ll look at how to connect to your server from an LLM.",Tt,Y,wt,q,jt;return e=new z({props:{title:"MCP SDK",local:"mcp-sdk",headingTag:"h1"}}),f=new z({props:{title:"SDK Overview",local:"sdk-overview",headingTag:"h2"}}),v=new z({props:{title:"Core Primitives Implementation",local:"core-primitives-implementation",headingTag:"h2"}}),C=new Yt({props:{id:"server-implementation",options:["python","javascript"],$$slots:{default:[zt]},$$scope:{ctx:U}}}),g=new It({props:{code:"bWNwJTIwZGV2JTIwc2VydmVyLnB5",highlighted:"mcp dev server.py",wrap:!1}}),G=new It({props:{code:"U3RhcnRpbmclMjBNQ1AlMjBpbnNwZWN0b3IuLi4lMEElRTIlOUElOTklRUYlQjglOEYlMjBQcm94eSUyMHNlcnZlciUyMGxpc3RlbmluZyUyMG9uJTIwcG9ydCUyMDYyNzclMEFTcGF3bmVkJTIwc3RkaW8lMjB0cmFuc3BvcnQlMEFDb25uZWN0ZWQlMjBNQ1AlMjBjbGllbnQlMjB0byUyMGJhY2tpbmclMjBzZXJ2ZXIlMjB0cmFuc3BvcnQlMEFDcmVhdGVkJTIwd2ViJTIwYXBwJTIwdHJhbnNwb3J0JTBBU2V0JTIwdXAlMjBNQ1AlMjBwcm94eSUwQSVGMCU5RiU5NCU4RCUyME1DUCUyMEluc3BlY3RvciUyMGlzJTIwdXAlMjBhbmQlMjBydW5uaW5nJTIwYXQlMjBodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBNjI3NCUyMCVGMCU5RiU5QSU4MA==",highlighted:`Starting MCP inspector...
⚙️ Proxy server listening on port 6277
Spawned stdio transport
Connected MCP client to backing server transport
Created web app transport
Set up MCP proxy
🔍 MCP Inspector is up and running at http://127.0.0.1:6274 🚀`,wrap:!1}}),Q=new z({props:{title:"MCP SDKs",local:"mcp-sdks",headingTag:"h2"}}),V=new z({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Y=new Xt({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/sdk.mdx"}}),{c(){a=J("meta"),i=p(),o=J("p"),T=p(),j(e.$$.fragment),r=p(),u=J("p"),u.textContent=W,F=p(),j(f.$$.fragment),H=p(),b=J("p"),b.textContent=yt,P=p(),B=J("ul"),B.innerHTML=dt,D=p(),j(v.$$.fragment),K=p(),A=J("p"),A.textContent=mt,L=p(),j(C.$$.fragment),O=p(),$=J("p"),$.textContent=ht,tt=p(),j(g.$$.fragment),lt=p(),E=J("p"),E.innerHTML=ut,st=p(),j(G.$$.fragment),et=p(),N=J("p"),N.innerHTML=Ut,nt=p(),S=J("p"),S.textContent=Ct,at=p(),Z=J("p"),Z.innerHTML=ft,ot=p(),j(Q.$$.fragment),pt=p(),k=J("p"),k.textContent=bt,Mt=p(),R=J("table"),R.innerHTML=Bt,it=p(),x=J("p"),x.textContent=vt,rt=p(),j(V.$$.fragment),Jt=p(),_=J("p"),_.textContent=At,ct=p(),X=J("p"),X.textContent=$t,Tt=p(),j(Y.$$.fragment),wt=p(),q=J("p"),this.h()},l(t){const l=xt("svelte-u9bgzb",document.head);a=c(l,"META",{name:!0,content:!0}),l.forEach(s),i=M(t),o=c(t,"P",{}),Et(o).forEach(s),T=M(t),I(e.$$.fragment,t),r=M(t),u=c(t,"P",{"data-svelte-h":!0}),w(u)!=="svelte-d74ti7"&&(u.textContent=W),F=M(t),I(f.$$.fragment,t),H=M(t),b=c(t,"P",{"data-svelte-h":!0}),w(b)!=="svelte-13pn39g"&&(b.textContent=yt),P=M(t),B=c(t,"UL",{"data-svelte-h":!0}),w(B)!=="svelte-68l2gn"&&(B.innerHTML=dt),D=M(t),I(v.$$.fragment,t),K=M(t),A=c(t,"P",{"data-svelte-h":!0}),w(A)!=="svelte-ttdup7"&&(A.textContent=mt),L=M(t),I(C.$$.fragment,t),O=M(t),$=c(t,"P",{"data-svelte-h":!0}),w($)!=="svelte-o6gns3"&&($.textContent=ht),tt=M(t),I(g.$$.fragment,t),lt=M(t),E=c(t,"P",{"data-svelte-h":!0}),w(E)!=="svelte-o7d2nm"&&(E.innerHTML=ut),st=M(t),I(G.$$.fragment,t),et=M(t),N=c(t,"P",{"data-svelte-h":!0}),w(N)!=="svelte-1t493b1"&&(N.innerHTML=Ut),nt=M(t),S=c(t,"P",{"data-svelte-h":!0}),w(S)!=="svelte-14xr1ub"&&(S.textContent=Ct),at=M(t),Z=c(t,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-1pax2up"&&(Z.innerHTML=ft),ot=M(t),I(Q.$$.fragment,t),pt=M(t),k=c(t,"P",{"data-svelte-h":!0}),w(k)!=="svelte-1jgjuju"&&(k.textContent=bt),Mt=M(t),R=c(t,"TABLE",{"data-svelte-h":!0}),w(R)!=="svelte-hr2s98"&&(R.innerHTML=Bt),it=M(t),x=c(t,"P",{"data-svelte-h":!0}),w(x)!=="svelte-1b923fr"&&(x.textContent=vt),rt=M(t),I(V.$$.fragment,t),Jt=M(t),_=c(t,"P",{"data-svelte-h":!0}),w(_)!=="svelte-1mzm78"&&(_.textContent=At),ct=M(t),X=c(t,"P",{"data-svelte-h":!0}),w(X)!=="svelte-v6yatx"&&(X.textContent=$t),Tt=M(t),I(Y.$$.fragment,t),wt=M(t),q=c(t,"P",{}),Et(q).forEach(s),this.h()},h(){Gt(a,"name","hf:doc:metadata"),Gt(a,"content",Ht)},m(t,l){Vt(document.head,a),n(t,i,l),n(t,o,l),n(t,T,l),y(e,t,l),n(t,r,l),n(t,u,l),n(t,F,l),y(f,t,l),n(t,H,l),n(t,b,l),n(t,P,l),n(t,B,l),n(t,D,l),y(v,t,l),n(t,K,l),n(t,A,l),n(t,L,l),y(C,t,l),n(t,O,l),n(t,$,l),n(t,tt,l),y(g,t,l),n(t,lt,l),n(t,E,l),n(t,st,l),y(G,t,l),n(t,et,l),n(t,N,l),n(t,nt,l),n(t,S,l),n(t,at,l),n(t,Z,l),n(t,ot,l),y(Q,t,l),n(t,pt,l),n(t,k,l),n(t,Mt,l),n(t,R,l),n(t,it,l),n(t,x,l),n(t,rt,l),y(V,t,l),n(t,Jt,l),n(t,_,l),n(t,ct,l),n(t,X,l),n(t,Tt,l),y(Y,t,l),n(t,wt,l),n(t,q,l),jt=!0},p(t,[l]){const gt={};l&2&&(gt.$$scope={dirty:l,ctx:t}),C.$set(gt)},i(t){jt||(d(e.$$.fragment,t),d(f.$$.fragment,t),d(v.$$.fragment,t),d(C.$$.fragment,t),d(g.$$.fragment,t),d(G.$$.fragment,t),d(Q.$$.fragment,t),d(V.$$.fragment,t),d(Y.$$.fragment,t),jt=!0)},o(t){m(e.$$.fragment,t),m(f.$$.fragment,t),m(v.$$.fragment,t),m(C.$$.fragment,t),m(g.$$.fragment,t),m(G.$$.fragment,t),m(Q.$$.fragment,t),m(V.$$.fragment,t),m(Y.$$.fragment,t),jt=!1},d(t){t&&(s(i),s(o),s(T),s(r),s(u),s(F),s(H),s(b),s(P),s(B),s(D),s(K),s(A),s(L),s(O),s($),s(tt),s(lt),s(E),s(st),s(et),s(N),s(nt),s(S),s(at),s(Z),s(ot),s(pt),s(k),s(Mt),s(R),s(it),s(x),s(rt),s(Jt),s(_),s(ct),s(X),s(Tt),s(wt),s(q)),s(a),h(e,t),h(f,t),h(v,t),h(C,t),h(g,t),h(G,t),h(Q,t),h(V,t),h(Y,t)}}}const Ht='{"title":"MCP SDK","local":"mcp-sdk","sections":[{"title":"SDK Overview","local":"sdk-overview","sections":[],"depth":2},{"title":"Core Primitives Implementation","local":"core-primitives-implementation","sections":[],"depth":2},{"title":"MCP SDKs","local":"mcp-sdks","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pt(U){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends kt{constructor(a){super(),Rt(this,a,Pt,Ft,Zt,{})}}export{sl as component};
