import{s as Qt,o as Yt,n as kt}from"../chunks/scheduler.8c3d61f6.js";import{S as Kt,i as en,g as a,s as i,r as _,A as tn,h as r,f as n,c as s,j as S,u as h,x as f,k as T,y as t,a as l,v as b,d as P,t as v,w,m as nn,n as on}from"../chunks/index.589a98e8.js";import{T as At}from"../chunks/Tip.42aa8582.js";import{D as E}from"../chunks/Docstring.27406313.js";import{C as Ht}from"../chunks/CodeBlock.36627b28.js";import{E as Ft}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as Ye,E as sn}from"../chunks/EditOnGithub.e5a8d9cb.js";function an(M){let d,L='You can find additional information about LEDITS++ on the <a href="https://leditsplusplus-project.static.hf.space/index.html" rel="nofollow">project page</a> and try it out in a <a href="https://huggingface.co/spaces/editing-images/leditsplusplus" rel="nofollow">demo</a>.';return{c(){d=a("p"),d.innerHTML=L},l(m){d=r(m,"P",{"data-svelte-h":!0}),f(d)!=="svelte-rdvyhm"&&(d.innerHTML=L)},m(m,u){l(m,d,u)},p:kt,d(m){m&&n(d)}}}function rn(M){let d;return{c(){d=nn(`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},l(L){d=on(L,`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},m(L,m){l(L,d,m)},d(L){L&&n(d)}}}function dn(M){let d,L="Examples:",m,u,x;return u=new Ht({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvbiUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMExFZGl0c1BQUGlwZWxpbmVTdGFibGVEaWZmdXNpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGd3d3LmFpbWwuaW5mb3JtYXRpay50dS1kYXJtc3RhZHQuZGUlMkZwZW9wbGUlMkZtYnJhY2slMkZjaGVycnlfYmxvc3NvbS5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBXyUyMCUzRCUyMHBpcGUuaW52ZXJ0KGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW52ZXJzaW9uX3N0ZXBzJTNENTAlMkMlMjBza2lwJTNEMC4xKSUwQSUwQWVkaXRlZF9pbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZWRpdGluZ19wcm9tcHQlM0QlNUIlMjJjaGVycnklMjBibG9zc29tJTIyJTVEJTJDJTIwZWRpdF9ndWlkYW5jZV9zY2FsZSUzRDEwLjAlMkMlMjBlZGl0X3RocmVzaG9sZCUzRDAuNzUlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusion
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusion.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/cherry_blossom.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;cherry blossom&quot;</span>], edit_guidance_scale=<span class="hljs-number">10.0</span>, edit_threshold=<span class="hljs-number">0.75</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=a("p"),d.textContent=L,m=i(),_(u.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=L),m=s(p),h(u.$$.fragment,p)},m(p,k){l(p,d,k),l(p,m,k),b(u,p,k),x=!0},p:kt,i(p){x||(P(u.$$.fragment,p),x=!0)},o(p){v(u.$$.fragment,p),x=!1},d(p){p&&(n(d),n(m)),w(u,p)}}}function ln(M){let d,L="Examples:",m,u,x;return u=new Ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBQSUwlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvblhMJTBBJTBBcGlwZSUyMCUzRCUyMExFZGl0c1BQUGlwZWxpbmVTdGFibGVEaWZmdXNpb25YTC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuYWltbC5pbmZvcm1hdGlrLnR1LWRhcm1zdGFkdC5kZSUyRnBlb3BsZSUyRm1icmFjayUyRnRlbm5pcy5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpJTBBJTBBXyUyMCUzRCUyMHBpcGUuaW52ZXJ0KGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW52ZXJzaW9uX3N0ZXBzJTNENTAlMkMlMjBza2lwJTNEMC4yKSUwQSUwQWVkaXRlZF9pbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZWRpdGluZ19wcm9tcHQlM0QlNUIlMjJ0ZW5uaXMlMjBiYWxsJTIyJTJDJTIwJTIydG9tYXRvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV2ZXJzZV9lZGl0aW5nX2RpcmVjdGlvbiUzRCU1QlRydWUlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMGVkaXRfZ3VpZGFuY2Vfc2NhbGUlM0QlNUI1LjAlMkMlMjAxMC4wJTVEJTJDJTBBJTIwJTIwJTIwJTIwZWRpdF90aHJlc2hvbGQlM0QlNUIwLjklMkMlMjAwLjg1JTVEJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusionXL

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusionXL.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/tennis.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url)

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;tennis ball&quot;</span>, <span class="hljs-string">&quot;tomato&quot;</span>],
<span class="hljs-meta">... </span>    reverse_editing_direction=[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>],
<span class="hljs-meta">... </span>    edit_guidance_scale=[<span class="hljs-number">5.0</span>, <span class="hljs-number">10.0</span>],
<span class="hljs-meta">... </span>    edit_threshold=[<span class="hljs-number">0.9</span>, <span class="hljs-number">0.85</span>],
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=a("p"),d.textContent=L,m=i(),_(u.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=L),m=s(p),h(u.$$.fragment,p)},m(p,k){l(p,d,k),l(p,m,k),b(u,p,k),x=!0},p:kt,i(p){x||(P(u.$$.fragment,p),x=!0)},o(p){v(u.$$.fragment,p),x=!1},d(p){p&&(n(d),n(m)),w(u,p)}}}function pn(M){let d,L,m,u,x,p,k,yt='LEDITS++ was proposed in <a href="https://huggingface.co/papers/2311.16711" rel="nofollow">LEDITS++: Limitless Image Editing using Text-to-Image Models</a> by Manuel Brack, Felix Friedrich, Katharina Kornmeier, Linoy Tsaban, Patrick Schramowski, Kristian Kersting, Apolinário Passos.',Ie,R,St="The abstract from the paper is:",$e,q,Tt='<em>Text-to-image diffusion models have recently received increasing interest for their astonishing ability to produce high-fidelity images from solely text inputs. Subsequent research efforts aim to exploit and apply their capabilities to real image editing. However, existing image-to-image methods are often inefficient, imprecise, and of limited versatility. They either require time-consuming fine-tuning, deviate unnecessarily strongly from the input image, and/or lack support for multiple, simultaneous edits. To address these issues, we introduce LEDITS++, an efficient yet versatile and precise textual image manipulation technique. LEDITS++‘s novel inversion approach requires no tuning nor optimization and produces high-fidelity results with a few diffusion steps. Second, our methodology supports multiple simultaneous edits and is architecture-agnostic. Third, we use a novel implicit masking technique that limits changes to relevant image regions. We propose the novel TEdBench++ benchmark as part of our exhaustive evaluation. Our results demonstrate the capabilities of LEDITS++ and its improvements over previous methods. The project page is available at <a href="https://leditsplusplus-project.static.hf.space" rel="nofollow">https://leditsplusplus-project.static.hf.space</a> .</em>',Ce,J,je,X,Ue,V,Et="We provide two distinct pipelines based on different pre-trained models.",Je,A,Xe,D,F,Ke,fe,Mt="Pipeline for textual image editing using LEDits++ with Stable Diffusion.",et,me,It=`This model inherits from <a href="/docs/diffusers/pr_7685/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_7685/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Check the superclass
documentation for the generic methods implemented for all pipelines (downloading, saving, running on a particular
device, etc.).`,tt,I,H,nt,ue,$t=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusion.invert">invert()</a> method has to be called beforehand. Edits will
always be performed for the last inverted image(s).`,ot,N,it,z,Q,st,ge,Ct=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,at,B,Y,rt,_e,jt="Encodes the prompt into text encoder hidden states.",Ne,K,Ut="## LEditsPPPipelineStableDiffusionXL[[diffusers.LEditsPPPipelineStableDiffusionXL]]",ze,c,ee,dt,he,Jt="Pipeline for textual image editing using LEDits++ with Stable Diffusion XL.",lt,be,Xt=`This model inherits from <a href="/docs/diffusers/pr_7685/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_7685/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>. Check the
superclass documentation for the generic methods implemented for all pipelines (downloading, saving, running on a
particular device, etc.).`,pt,Pe,Nt="In addition the pipeline inherits the following loading methods:",ct,ve,zt='<li><em>LoRA</em>: <a href="/docs/diffusers/pr_7685/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">LEditsPPPipelineStableDiffusionXL.load_lora_weights()</a></li> <li><em>Ckpt</em>: <a href="/docs/diffusers/pr_7685/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a></li>',ft,we,Bt="as well as the following saving methods:",mt,Le,Gt="<li><em>LoRA</em>: <code>loaders.StableDiffusionXLPipeline.save_lora_weights</code></li>",ut,$,te,gt,xe,Wt=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusionXL.invert">invert()</a> method has to be called beforehand. Edits
will always be performed for the last inverted image(s).`,_t,G,ht,W,ne,bt,De,Zt=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,Pt,Z,oe,vt,ke,Ot="Encodes the prompt into text encoder hidden states.",wt,O,ie,Lt,ye,Rt='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Be,se,Ge,C,ae,xt,Se,qt="Output class for LEdits++ Diffusion pipelines.",We,re,Ze,j,de,Dt,Te,Vt="Output class for LEdits++ Diffusion pipelines.",Oe,le,Re,Me,qe;return x=new Ye({props:{title:"LEDITS++",local:"ledits",headingTag:"h1"}}),J=new At({props:{$$slots:{default:[an]},$$scope:{ctx:M}}}),X=new At({props:{warning:!0,$$slots:{default:[rn]},$$scope:{ctx:M}}}),A=new Ye({props:{title:"LEditsPPPipelineStableDiffusion",local:"diffusers.LEditsPPPipelineStableDiffusion",headingTag:"h2"}}),F=new E({props:{name:"class diffusers.LEditsPPPipelineStableDiffusion",anchor:"diffusers.LEditsPPPipelineStableDiffusion",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7685/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7685/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please, refer to the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">model card</a> for details.`,name:"safety_checker"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L250"}}),H=new E({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__",parameters:[{name:"negative_prompt",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"editing_prompt",val:": Union = None"},{name:"editing_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"reverse_editing_direction",val:": Union = False"},{name:"edit_guidance_scale",val:": Union = 5"},{name:"edit_warmup_steps",val:": Union = 0"},{name:"edit_cooldown_steps",val:": Union = None"},{name:"edit_threshold",val:": Union = 0.9"},{name:"user_mask",val:": Optional = None"},{name:"sem_guidance",val:": Optional = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = True"},{name:"attn_store_steps",val:": Optional = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput">LEditsPPDiffusionPipelineOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor&gt;</code>, <em>optional</em>) &#x2014;
Pre-computed embeddings to use for guiding the image generation. Guidance direction of embedding should
be specified via <code>reverse_editing_direction</code>.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance will not be applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance will no longer be applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.user_mask",description:`<strong>user_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.`,name:"user_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_cross_attn_mask",description:`<strong>use_cross_attn_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.`,name:"use_cross_attn_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_intersect_mask",description:`<strong>use_intersect_mask</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.`,name:"use_intersect_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.attn_store_steps",description:`<strong>attn_store_steps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.`,name:"attn_store_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.store_averaged_over_steps",description:`<strong>store_averaged_over_steps</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"store_averaged_over_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L697",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),N=new Ft({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.example",$$slots:{default:[dn]},$$scope:{ctx:M}}}),Q=new E({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert",parameters:[{name:"image",val:": Union"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:": float = 3.5"},{name:"num_inversion_steps",val:": int = 30"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": Optional = None"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"resize_mode",val:": Optional = 'default'"},{name:"crops_coords",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The height in preprocessed image. If <code>None</code>, will use the <code>get_default_height_width()</code> to get default
height.`,name:"height"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.width",description:"<strong>width</strong> (<code>int</code>, <em>optional</em><code>, defaults to </code>None<code>) -- The width in preprocessed. If </code>None<code>, will use get_default_height_width()</code> to get the default width.",name:"width"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit within
the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>, will
resize the image to fit within the specified width and height, maintaining the aspect ratio, and then
center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize the
image to fit within the specified width and height, maintaining the aspect ratio, and then center the
image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.crops_coords",description:`<strong>crops_coords</strong> (<code>List[Tuple[int, int, int, int]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The crop coordinates for each image in the batch. If <code>None</code>, will not crop the image.`,name:"crops_coords"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L1198",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),Y=new E({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt",parameters:[{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"enable_edit_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"editing_prompt",val:" = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"editing_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
whether to perform any editing or reconstruct the input image instead`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined, one has to pass <code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L498"}}),ee=new E({props:{name:"class diffusers.LEditsPPPipelineStableDiffusionXL",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7685/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7685/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_7685/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L281"}}),te=new E({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__",parameters:[{name:"denoising_end",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Optional = None"},{name:"editing_prompt",val:": Union = None"},{name:"editing_prompt_embeddings",val:": Optional = None"},{name:"editing_pooled_prompt_embeds",val:": Optional = None"},{name:"reverse_editing_direction",val:": Union = False"},{name:"edit_guidance_scale",val:": Union = 5"},{name:"edit_warmup_steps",val:": Union = 0"},{name:"edit_cooldown_steps",val:": Union = None"},{name:"edit_threshold",val:": Union = 0.9"},{name:"sem_guidance",val:": Optional = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = False"},{name:"user_mask",val:": Optional = None"},{name:"attn_store_steps",val:": Optional = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in [**Refining the Image`,name:"denoising_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt_embeddings",description:`<strong>editing_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input argument.`,name:"editing_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_pooled_prompt_embeddings",description:`<strong>editing_pooled_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input
argument.`,name:"editing_pooled_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance is not applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance is no longer applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.
use_cross_attn_mask &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.
use_intersect_mask &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.
user_mask &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.
attn_store_steps &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.
store_averaged_over_steps &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L796",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a \`tuple. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Ft({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.example",$$slots:{default:[ln]},$$scope:{ctx:M}}}),ne=new E({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert",parameters:[{name:"image",val:": Union"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:" = 3.5"},{name:"negative_prompt",val:": str = None"},{name:"negative_prompt_2",val:": str = None"},{name:"num_inversion_steps",val:": int = 50"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"num_zero_noise_steps",val:": int = 3"},{name:"cross_attention_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_zero_noise_steps",description:`<strong>num_zero_noise_steps</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
Number of final diffusion steps that will not renoise the current image. If no steps are set to zero
SD-XL in combination with <a href="/docs/diffusers/pr_7685/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> will produce noise artifacts.`,name:"num_zero_noise_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L1428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7685/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),oe=new E({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt",parameters:[{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"enable_edit_guidance",val:": bool = True"},{name:"editing_prompt",val:": Optional = None"},{name:"editing_prompt_embeds",val:": Optional = None"},{name:"editing_pooled_prompt_embeds",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead.`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
Whether to guide towards an editing prompt or not.`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined and &#x2018;enable_edit_guidance&#x2019; is True, one has to pass
<code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided and &#x2018;enable_edit_guidance&#x2019; is True, editing_prompt_embeds will be generated from
<code>editing_prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_pooled_prompt_embeds",description:`<strong>editing_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled editing_pooled_prompt_embeds will be generated from <code>editing_prompt</code>
input argument.`,name:"editing_pooled_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L404"}}),ie=new E({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L710",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),se=new Ye({props:{title:"LEditsPPDiffusionPipelineOutput",local:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",headingTag:"h2"}}),ae=new E({props:{name:"class diffusers.pipelines.LEditsPPDiffusionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L10"}}),re=new Ye({props:{title:"LEditsPPInversionPipelineOutput",local:"diffusers.pipelines.LEditsPPInversionPipelineOutput",headingTag:"h2"}}),de=new E({props:{name:"class diffusers.pipelines.LEditsPPInversionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"vae_reconstruction_images",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.input_images",description:`<strong>input_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of the cropped and resized input images as PIL images of length <code>batch_size</code> or NumPy array of shape <code> (batch_size, height, width, num_channels)</code>.`,name:"input_images"},{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.vae_reconstruction_images",description:`<strong>vae_reconstruction_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of VAE reconstruction of all input images as PIL images of length <code>batch_size</code> or NumPy array of shape
<code> (batch_size, height, width, num_channels)</code>.`,name:"vae_reconstruction_images"}],source:"https://github.com/huggingface/diffusers/blob/vr_7685/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L28"}}),le=new sn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ledits_pp.md"}}),{c(){d=a("meta"),L=i(),m=a("p"),u=i(),_(x.$$.fragment),p=i(),k=a("p"),k.innerHTML=yt,Ie=i(),R=a("p"),R.textContent=St,$e=i(),q=a("p"),q.innerHTML=Tt,Ce=i(),_(J.$$.fragment),je=i(),_(X.$$.fragment),Ue=i(),V=a("p"),V.textContent=Et,Je=i(),_(A.$$.fragment),Xe=i(),D=a("div"),_(F.$$.fragment),Ke=i(),fe=a("p"),fe.textContent=Mt,et=i(),me=a("p"),me.innerHTML=It,tt=i(),I=a("div"),_(H.$$.fragment),nt=i(),ue=a("p"),ue.innerHTML=$t,ot=i(),_(N.$$.fragment),it=i(),z=a("div"),_(Q.$$.fragment),st=i(),ge=a("p"),ge.innerHTML=Ct,at=i(),B=a("div"),_(Y.$$.fragment),rt=i(),_e=a("p"),_e.textContent=jt,Ne=i(),K=a("p"),K.textContent=Ut,ze=i(),c=a("div"),_(ee.$$.fragment),dt=i(),he=a("p"),he.textContent=Jt,lt=i(),be=a("p"),be.innerHTML=Xt,pt=i(),Pe=a("p"),Pe.textContent=Nt,ct=i(),ve=a("ul"),ve.innerHTML=zt,ft=i(),we=a("p"),we.textContent=Bt,mt=i(),Le=a("ul"),Le.innerHTML=Gt,ut=i(),$=a("div"),_(te.$$.fragment),gt=i(),xe=a("p"),xe.innerHTML=Wt,_t=i(),_(G.$$.fragment),ht=i(),W=a("div"),_(ne.$$.fragment),bt=i(),De=a("p"),De.innerHTML=Zt,Pt=i(),Z=a("div"),_(oe.$$.fragment),vt=i(),ke=a("p"),ke.textContent=Ot,wt=i(),O=a("div"),_(ie.$$.fragment),Lt=i(),ye=a("p"),ye.innerHTML=Rt,Be=i(),_(se.$$.fragment),Ge=i(),C=a("div"),_(ae.$$.fragment),xt=i(),Se=a("p"),Se.textContent=qt,We=i(),_(re.$$.fragment),Ze=i(),j=a("div"),_(de.$$.fragment),Dt=i(),Te=a("p"),Te.textContent=Vt,Oe=i(),_(le.$$.fragment),Re=i(),Me=a("p"),this.h()},l(e){const o=tn("svelte-u9bgzb",document.head);d=r(o,"META",{name:!0,content:!0}),o.forEach(n),L=s(e),m=r(e,"P",{}),S(m).forEach(n),u=s(e),h(x.$$.fragment,e),p=s(e),k=r(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-ke65yv"&&(k.innerHTML=yt),Ie=s(e),R=r(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1cwsb16"&&(R.textContent=St),$e=s(e),q=r(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-1jncrmh"&&(q.innerHTML=Tt),Ce=s(e),h(J.$$.fragment,e),je=s(e),h(X.$$.fragment,e),Ue=s(e),V=r(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1qwf4p0"&&(V.textContent=Et),Je=s(e),h(A.$$.fragment,e),Xe=s(e),D=r(e,"DIV",{class:!0});var y=S(D);h(F.$$.fragment,y),Ke=s(y),fe=r(y,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-i87xsw"&&(fe.textContent=Mt),et=s(y),me=r(y,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1baa1vr"&&(me.innerHTML=It),tt=s(y),I=r(y,"DIV",{class:!0});var U=S(I);h(H.$$.fragment,U),nt=s(U),ue=r(U,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1cjkr85"&&(ue.innerHTML=$t),ot=s(U),h(N.$$.fragment,U),U.forEach(n),it=s(y),z=r(y,"DIV",{class:!0});var pe=S(z);h(Q.$$.fragment,pe),st=s(pe),ge=r(pe,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-17grtah"&&(ge.innerHTML=Ct),pe.forEach(n),at=s(y),B=r(y,"DIV",{class:!0});var ce=S(B);h(Y.$$.fragment,ce),rt=s(ce),_e=r(ce,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-16q0ax1"&&(_e.textContent=jt),ce.forEach(n),y.forEach(n),Ne=s(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-qs6nwn"&&(K.textContent=Ut),ze=s(e),c=r(e,"DIV",{class:!0});var g=S(c);h(ee.$$.fragment,g),dt=s(g),he=r(g,"P",{"data-svelte-h":!0}),f(he)!=="svelte-ojahy4"&&(he.textContent=Jt),lt=s(g),be=r(g,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1poptn7"&&(be.innerHTML=Xt),pt=s(g),Pe=r(g,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-984r3o"&&(Pe.textContent=Nt),ct=s(g),ve=r(g,"UL",{"data-svelte-h":!0}),f(ve)!=="svelte-1mlh3hg"&&(ve.innerHTML=zt),ft=s(g),we=r(g,"P",{"data-svelte-h":!0}),f(we)!=="svelte-19qtqre"&&(we.textContent=Bt),mt=s(g),Le=r(g,"UL",{"data-svelte-h":!0}),f(Le)!=="svelte-1tez18v"&&(Le.innerHTML=Gt),ut=s(g),$=r(g,"DIV",{class:!0});var Ee=S($);h(te.$$.fragment,Ee),gt=s(Ee),xe=r(Ee,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1yarzvv"&&(xe.innerHTML=Wt),_t=s(Ee),h(G.$$.fragment,Ee),Ee.forEach(n),ht=s(g),W=r(g,"DIV",{class:!0});var Ve=S(W);h(ne.$$.fragment,Ve),bt=s(Ve),De=r(Ve,"P",{"data-svelte-h":!0}),f(De)!=="svelte-tob1r7"&&(De.innerHTML=Zt),Ve.forEach(n),Pt=s(g),Z=r(g,"DIV",{class:!0});var Ae=S(Z);h(oe.$$.fragment,Ae),vt=s(Ae),ke=r(Ae,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-16q0ax1"&&(ke.textContent=Ot),Ae.forEach(n),wt=s(g),O=r(g,"DIV",{class:!0});var Fe=S(O);h(ie.$$.fragment,Fe),Lt=s(Fe),ye=r(Fe,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-vo59ec"&&(ye.innerHTML=Rt),Fe.forEach(n),g.forEach(n),Be=s(e),h(se.$$.fragment,e),Ge=s(e),C=r(e,"DIV",{class:!0});var He=S(C);h(ae.$$.fragment,He),xt=s(He),Se=r(He,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-hu8uib"&&(Se.textContent=qt),He.forEach(n),We=s(e),h(re.$$.fragment,e),Ze=s(e),j=r(e,"DIV",{class:!0});var Qe=S(j);h(de.$$.fragment,Qe),Dt=s(Qe),Te=r(Qe,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-hu8uib"&&(Te.textContent=Vt),Qe.forEach(n),Oe=s(e),h(le.$$.fragment,e),Re=s(e),Me=r(e,"P",{}),S(Me).forEach(n),this.h()},h(){T(d,"name","hf:doc:metadata"),T(d,"content",cn),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,d),l(e,L,o),l(e,m,o),l(e,u,o),b(x,e,o),l(e,p,o),l(e,k,o),l(e,Ie,o),l(e,R,o),l(e,$e,o),l(e,q,o),l(e,Ce,o),b(J,e,o),l(e,je,o),b(X,e,o),l(e,Ue,o),l(e,V,o),l(e,Je,o),b(A,e,o),l(e,Xe,o),l(e,D,o),b(F,D,null),t(D,Ke),t(D,fe),t(D,et),t(D,me),t(D,tt),t(D,I),b(H,I,null),t(I,nt),t(I,ue),t(I,ot),b(N,I,null),t(D,it),t(D,z),b(Q,z,null),t(z,st),t(z,ge),t(D,at),t(D,B),b(Y,B,null),t(B,rt),t(B,_e),l(e,Ne,o),l(e,K,o),l(e,ze,o),l(e,c,o),b(ee,c,null),t(c,dt),t(c,he),t(c,lt),t(c,be),t(c,pt),t(c,Pe),t(c,ct),t(c,ve),t(c,ft),t(c,we),t(c,mt),t(c,Le),t(c,ut),t(c,$),b(te,$,null),t($,gt),t($,xe),t($,_t),b(G,$,null),t(c,ht),t(c,W),b(ne,W,null),t(W,bt),t(W,De),t(c,Pt),t(c,Z),b(oe,Z,null),t(Z,vt),t(Z,ke),t(c,wt),t(c,O),b(ie,O,null),t(O,Lt),t(O,ye),l(e,Be,o),b(se,e,o),l(e,Ge,o),l(e,C,o),b(ae,C,null),t(C,xt),t(C,Se),l(e,We,o),b(re,e,o),l(e,Ze,o),l(e,j,o),b(de,j,null),t(j,Dt),t(j,Te),l(e,Oe,o),b(le,e,o),l(e,Re,o),l(e,Me,o),qe=!0},p(e,[o]){const y={};o&2&&(y.$$scope={dirty:o,ctx:e}),J.$set(y);const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),X.$set(U);const pe={};o&2&&(pe.$$scope={dirty:o,ctx:e}),N.$set(pe);const ce={};o&2&&(ce.$$scope={dirty:o,ctx:e}),G.$set(ce)},i(e){qe||(P(x.$$.fragment,e),P(J.$$.fragment,e),P(X.$$.fragment,e),P(A.$$.fragment,e),P(F.$$.fragment,e),P(H.$$.fragment,e),P(N.$$.fragment,e),P(Q.$$.fragment,e),P(Y.$$.fragment,e),P(ee.$$.fragment,e),P(te.$$.fragment,e),P(G.$$.fragment,e),P(ne.$$.fragment,e),P(oe.$$.fragment,e),P(ie.$$.fragment,e),P(se.$$.fragment,e),P(ae.$$.fragment,e),P(re.$$.fragment,e),P(de.$$.fragment,e),P(le.$$.fragment,e),qe=!0)},o(e){v(x.$$.fragment,e),v(J.$$.fragment,e),v(X.$$.fragment,e),v(A.$$.fragment,e),v(F.$$.fragment,e),v(H.$$.fragment,e),v(N.$$.fragment,e),v(Q.$$.fragment,e),v(Y.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(G.$$.fragment,e),v(ne.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(de.$$.fragment,e),v(le.$$.fragment,e),qe=!1},d(e){e&&(n(L),n(m),n(u),n(p),n(k),n(Ie),n(R),n($e),n(q),n(Ce),n(je),n(Ue),n(V),n(Je),n(Xe),n(D),n(Ne),n(K),n(ze),n(c),n(Be),n(Ge),n(C),n(We),n(Ze),n(j),n(Oe),n(Re),n(Me)),n(d),w(x,e),w(J,e),w(X,e),w(A,e),w(F),w(H),w(N),w(Q),w(Y),w(ee),w(te),w(G),w(ne),w(oe),w(ie),w(se,e),w(ae),w(re,e),w(de),w(le,e)}}}const cn='{"title":"LEDITS++","local":"ledits","sections":[{"title":"LEditsPPPipelineStableDiffusion","local":"diffusers.LEditsPPPipelineStableDiffusion","sections":[],"depth":2},{"title":"LEditsPPDiffusionPipelineOutput","local":"diffusers.pipelines.LEditsPPDiffusionPipelineOutput","sections":[],"depth":2},{"title":"LEditsPPInversionPipelineOutput","local":"diffusers.pipelines.LEditsPPInversionPipelineOutput","sections":[],"depth":2}],"depth":1}';function fn(M){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends Kt{constructor(d){super(),en(this,d,fn,pn,Qt,{})}}export{vn as component};
