import{s as ys,n as us,o as ws}from"../chunks/scheduler.39a43cde.js";import{S as gs,i as js,g as i,s as n,r as p,A as Js,h as o,f as s,c as a,j as ds,u as c,x as r,k as hs,y as Ts,a as l,v as m,d as M,t as d,w as h}from"../chunks/index.23ec2204.js";import{D as bs,C as y}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as u,E as Us}from"../chunks/EditOnGithub.f2d09226.js";function fs(kt){let w,Ie,Ue,Ce,g,Ze,j,ve,J,$t='Authored By: <a href="https://huggingface.co/RichmondMongo" rel="nofollow">Richmond Alake</a>',Be,T,Ge,b,Rt="The shell command sequence below installs libraries for leveraging open-source large language models (LLMs), embedding models, and database interaction functionalities. These libraries simplify the development of a RAG system, reducing the complexity to a small amount of code:",Ae,U,Vt="<li>PyMongo: A Python library for interacting with MongoDB that enables functionalities to connect to a cluster and query data stored in collections and documents.</li> <li>Pandas: Provides a data structure for efficient data processing and analysis using Python</li> <li>Hugging Face datasets: Holds audio, vision, and text datasets</li> <li>Hugging Face Accelerate: Abstracts the complexity of writing code that leverages hardware accelerators such as GPUs. Accelerate is leveraged in the implementation to utilise the Gemma model on GPU resources.</li> <li>Hugging Face Transformers: Access to a vast collection of pre-trained models</li> <li>Hugging Face Sentence Transformers: Provides access to sentence, text, and image embeddings.</li>",We,f,ke,I,$e,C,Qt=`The data utilised in this tutorial is sourced from Hugging Face datasets, specifically the
<a href="https://huggingface.co/datasets/AIatMongoDB/embedded_movies" rel="nofollow">AIatMongoDB/embedded_movies dataset</a>.`,Re,Z,Ve,v,_t="The operations within the following code snippet below focus on enforcing data integrity and quality.",Qe,B,St="<li>The first process ensures that each data point’s <code>fullplot</code> attribute is not empty, as this is the primary data we utilise in the embedding process.</li> <li>This step also ensures we remove the <code>plot_embedding</code> attribute from all data points as this will be replaced by new embeddings created with a different embedding model, the <code>gte-large</code>.</li>",_e,G,Se,A,qt=`Number of missing values in each column after removal:
num_mflix_comments      0
genres                  0
countries               0
directors              12
fullplot                0
writers                13
awards                  0
runtime                14
type                    0
rated                 279
metacritic            893
poster                 78
languages               1
imdb                    0
plot                    0
cast                    1
plot_embedding          1
title                   0
dtype: int64
`,qe,W,xe,k,xt="<strong>The steps in the code snippets are as follows:</strong>",Ee,$,Et="<li>Import the <code>SentenceTransformer</code> class to access the embedding models.</li> <li>Load the embedding model using the <code>SentenceTransformer</code> constructor to instantiate the <code>gte-large</code> embedding model.</li> <li>Define the <code>get_embedding</code> function, which takes a text string as input and returns a list of floats representing the embedding. The function first checks if the input text is not empty (after stripping whitespace). If the text is empty, it returns an empty list. Otherwise, it generates an embedding using the loaded model.</li> <li>Generate embeddings by applying the <code>get_embedding</code> function to the “fullplot” column of the <code>dataset_df</code> DataFrame, generating embeddings for each movie’s plot. The resulting list of embeddings is assigned to a new column named embedding.</li>",Ne,R,Nt="<em>Note: It’s not necessary to chunk the text in the full plot, as we can ensure that the text length remains within a manageable range.</em>",Xe,V,He,Q,Fe,_,Xt="MongoDB acts as both an operational and a vector database. It offers a database solution that efficiently stores, queries and retrieves vector embeddings—the advantages of this lie in the simplicity of database maintenance, management and cost.",Ye,S,Ht="<strong>To create a new MongoDB database, set up a database cluster:</strong>",ze,q,Ft='<li><p>Head over to MongoDB official site and register for a <a href="https://www.mongodb.com/cloud/atlas/register?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alake" rel="nofollow">free MongoDB Atlas account</a>, or for existing users, <a href="https://account.mongodb.com/account/login?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alakee" rel="nofollow">sign into MongoDB Atlas</a>.</p></li> <li><p>Select the ‘Database’ option on the left-hand pane, which will navigate to the Database Deployment page, where there is a deployment specification of any existing cluster. Create a new database cluster by clicking on the “+Create” button.</p></li> <li><p>Select all the applicable configurations for the database cluster. Once all the configuration options are selected, click the “Create Cluster” button to deploy the newly created cluster. MongoDB also enables the creation of free clusters on the “Shared Tab”.</p> <p><em>Note: Don’t forget to whitelist the IP for the Python host or 0.0.0.0/0 for any IP when creating proof of concepts.</em></p></li> <li><p>After successfully creating and deploying the cluster, the cluster becomes accessible on the ‘Database Deployment’ page.</p></li> <li><p>Click on the “Connect” button of the cluster to view the option to set up a connection to the cluster via various language drivers.</p></li> <li><p>This tutorial only requires the cluster’s URI(unique resource identifier). Grab the URI and copy it into the Google Colabs Secrets environment in a variable named <code>MONGO_URI</code> or place it in a .env file or equivalent.</p></li>',Pe,x,De,E,Yt="Before moving forward, ensure the following prerequisites are met",Le,N,zt="<li>Database cluster set up on MongoDB Atlas</li> <li>Obtained the URI to your cluster</li>",Ke,X,Pt='For assistance with database cluster setup and obtaining the URI, refer to our guide for <a href="https://www.mongodb.com/docs/guides/atlas/cluster/" rel="nofollow">setting up a MongoDB cluster</a> and <a href="https://www.mongodb.com/docs/guides/atlas/connection-string/" rel="nofollow">getting your connection string</a>',Oe,H,Dt="Once you have created a cluster, create the database and collection within the MongoDB Atlas cluster by clicking + Create Database in the cluster overview page.",et,F,Lt='Here is a guide for <a href="https://www.mongodb.com/basics/create-database" rel="nofollow">creating a database and collection</a>',tt,Y,Kt="<strong>The database will be named <code>movies</code>.</strong>",st,z,Ot="<strong>The collection will be named <code>movie_collection_2</code>.</strong>",lt,P,nt,D,es="At this point make sure that your vector index is created via MongoDB Atlas.",at,L,ts="This next step is mandatory for conducting efficient and accurate vector-based searches based on the vector embeddings stored within the documents in the <code>movie_collection_2</code> collection.",it,K,ss="Creating a Vector Search Index enables the ability to traverse the documents efficiently to retrieve documents with embeddings that match the query embedding based on vector similarity.",ot,O,ls='Go here to read more about <a href="https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/" rel="nofollow">MongoDB Vector Search Index</a>.',rt,ee,pt,te,ns="The <code>1024</code> value of the numDimension field corresponds to the dimension of the vector generated by the gte-large embedding model. If you use the <code>gte-base</code> or <code>gte-small</code> embedding models, the numDimension value in the vector search index must be set to 768 and 384, respectively.",ct,se,mt,le,as="The code snippet below also utilises PyMongo to create a MongoDB client object, representing the connection to the cluster and enabling access to its databases and collections.",Mt,ne,dt,ae,is=`Connection to MongoDB successful
`,ht,ie,yt,oe,os="Ingesting data into a MongoDB collection from a pandas DataFrame is a straightforward process that can be efficiently accomplished by converting the DataFrame into dictionaries and then utilising the <code>insert_many</code> method on the collection to pass the converted dataset records.",ut,re,wt,pe,rs=`Data ingestion into MongoDB completed
`,gt,ce,jt,me,ps="The following step implements a function that returns a vector search result by generating a query embedding and defining a MongoDB aggregation pipeline.",Jt,Me,cs="The pipeline, consisting of the <code>$vectorSearch</code> and <code>$project</code> stages, executes queries using the generated vector and formats the results to include only the required information, such as plot, title, and genres while incorporating a search score for each result.",Tt,de,bt,he,Ut,ye,ft,ue,It,we,ms=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as "Pearl Harbor."
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo & Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.
`,Ct,ge,Zt,je,vt,Je,Ms=`<bos>Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara&#39;s uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as &quot;Pearl Harbor.&quot;
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship&#39;s maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne&#39;er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo &amp; Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.

Based on the search results, the best romantic movie to watch is **Shut Up and Kiss Me!** because it is a romantic comedy that explores the complexities of love and relationships. The movie is funny, heartwarming, and thought-provoking.<eos>
</eos></bos>`,Bt,Te,Gt,be,At,fe,Wt;return g=new bs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/toctree-order/notebooks/en/rag_with_hugging_face_gemma_mongodb.ipynb"}]}}),j=new u({props:{title:"Building A RAG System with Gemma, MongoDB and Open Source Models",local:"building-a-rag-system-with-gemma-mongodb-and-open-source-models",headingTag:"h1"}}),T=new u({props:{title:"Step 1: Installing Libraries",local:"step-1-installing-libraries",headingTag:"h2"}}),f=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHB5bW9uZ28lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMEEhcGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwSW5zdGFsbCUyMGJlbG93JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:`!pip install datasets pandas pymongo sentence_transformers
!pip install -U transformers
<span class="hljs-comment"># Install below if using GPU</span>
!pip install accelerate`,wrap:!1}}),I=new u({props:{title:"Step 2: Data sourcing and preparation",local:"step-2-data-sourcing-and-preparation",headingTag:"h2"}}),Z=new y({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGQUlhdE1vbmdvREIlMkZlbWJlZGRlZF9tb3ZpZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFJYXRNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0aGUlMjBkYXRhc2V0JTIwdG8lMjBhJTIwcGFuZGFzJTIwZGF0YWZyYW1lJTBBZGF0YXNldF9kZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBZGF0YXNldF9kZi5oZWFkKDUp",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># https://huggingface.co/datasets/AIatMongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;AIatMongoDB/embedded_movies&quot;</span>)

<span class="hljs-comment"># Convert the dataset to a pandas dataframe</span>
dataset_df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),G=new y({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3BuYShzdWJzZXQlM0QlNUIlMjJmdWxscGxvdCUyMiU1RCklMEFwcmludCglMjIlNUNuTnVtYmVyJTIwb2YlMjBtaXNzaW5nJTIwdmFsdWVzJTIwaW4lMjBlYWNoJTIwY29sdW1uJTIwYWZ0ZXIlMjByZW1vdmFsJTNBJTIyKSUwQXByaW50KGRhdGFzZXRfZGYuaXNudWxsKCkuc3VtKCkpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwcGxvdF9lbWJlZGRpbmclMjBmcm9tJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMGluJTIwdGhlJTIwZGF0YXNldCUyMGFzJTIwd2UlMjBhcmUlMjBnb2luZyUyMHRvJTIwY3JlYXRlJTIwbmV3JTIwZW1iZWRkaW5ncyUyMHdpdGglMjBhbiUyMG9wZW4lMjBzb3VyY2UlMjBlbWJlZGRpbmclMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3AoY29sdW1ucyUzRCU1QiUyMnBsb3RfZW1iZWRkaW5nJTIyJTVEKSUwQWRhdGFzZXRfZGYuaGVhZCg1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Data Preparation</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.dropna(subset=[<span class="hljs-string">&quot;fullplot&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nNumber of missing values in each column after removal:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset_df.isnull().<span class="hljs-built_in">sum</span>())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.drop(columns=[<span class="hljs-string">&quot;plot_embedding&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),W=new u({props:{title:"Step 3: Generating embeddings",local:"step-3-generating-embeddings",headingTag:"h2"}}),V=new y({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGhlbmxwZXIlMkZndGUtbGFyZ2UlMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMnRoZW5scGVyJTJGZ3RlLWxhcmdlJTIyKSUwQSUwQSUwQWRlZiUyMGdldF9lbWJlZGRpbmcodGV4dCUzQSUyMHN0ciklMjAtJTNFJTIwbGlzdCU1QmZsb2F0JTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjB0ZXh0LnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJBdHRlbXB0ZWQlMjB0byUyMGdldCUyMGVtYmVkZGluZyUyMGZvciUyMGVtcHR5JTIwdGV4dC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTIwJTNEJTIwZW1iZWRkaW5nX21vZGVsLmVuY29kZSh0ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZy50b2xpc3QoKSUwQSUwQSUwQWRhdGFzZXRfZGYlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjBkYXRhc2V0X2RmJTVCJTIyZnVsbHBsb3QlMjIlNUQuYXBwbHkoZ2V0X2VtYmVkZGluZyklMEElMEFkYXRhc2V0X2RmLmhlYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># https://huggingface.co/thenlper/gte-large</span>
embedding_model = SentenceTransformer(<span class="hljs-string">&quot;thenlper/gte-large&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
        <span class="hljs-keyword">return</span> []

    embedding = embedding_model.encode(text)

    <span class="hljs-keyword">return</span> embedding.tolist()


dataset_df[<span class="hljs-string">&quot;embedding&quot;</span>] = dataset_df[<span class="hljs-string">&quot;fullplot&quot;</span>].apply(get_embedding)

dataset_df.head()`,wrap:!1}}),Q=new u({props:{title:"Step 4: Database setup and connection",local:"step-4-database-setup-and-connection",headingTag:"h2"}}),x=new u({props:{title:"4.1 Database and Collection Setup",local:"41-database-and-collection-setup",headingTag:"h3"}}),P=new u({props:{title:"Step 5: Create a Vector Search Index",local:"step-5-create-a-vector-search-index",headingTag:"h2"}}),ee=new y({props:{code:"JTdCJTBBJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIybnVtRGltZW5zaW9ucyUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJwYXRoJTIyJTNBJTIwJTIyZW1iZWRkaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyc2ltaWxhcml0eSUyMiUzQSUyMCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ2ZWN0b3IlMjIlMEElMjAlMjAlMjAlN0QlNUQlMEElN0QlMEE=",highlighted:`{
 <span class="hljs-string">&quot;fields&quot;</span>: [{
     <span class="hljs-string">&quot;numDimensions&quot;</span>: <span class="hljs-number">1024</span>,
     <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
     <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
     <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;vector&quot;</span>
   }]
}
`,wrap:!1}}),se=new u({props:{title:"Step 6: Establish Data Connection",local:"step-6-establish-data-connection",headingTag:"h2"}}),ne=new y({props:{code:"aW1wb3J0JTIwcHltb25nbyUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQSUwQSUwQWRlZiUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkVzdGFibGlzaCUyMGNvbm5lY3Rpb24lMjB0byUyMHRoZSUyME1vbmdvREIuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwcHltb25nby5Nb25nb0NsaWVudChtb25nb191cmkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29ubmVjdGlvbiUyMHRvJTIwTW9uZ29EQiUyMHN1Y2Nlc3NmdWwlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2xpZW50JTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwcHltb25nby5lcnJvcnMuQ29ubmVjdGlvbkZhaWx1cmUlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyQ29ubmVjdGlvbiUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUwQSUwQSUwQW1vbmdvX3VyaSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBaWYlMjBub3QlMjBtb25nb191cmklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJNT05HT19VUkklMjBub3QlMjBzZXQlMjBpbiUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIyKSUwQSUwQW1vbmdvX2NsaWVudCUyMCUzRCUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUwQSUwQSUyMyUyMEluZ2VzdCUyMGRhdGElMjBpbnRvJTIwTW9uZ29EQiUwQWRiJTIwJTNEJTIwbW9uZ29fY2xpZW50JTVCJTIybW92aWVzJTIyJTVEJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRiJTVCJTIybW92aWVfY29sbGVjdGlvbl8yJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pymongo
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_mongo_client</span>(<span class="hljs-params">mongo_uri</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Establish connection to the MongoDB.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        client = pymongo.MongoClient(mongo_uri)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Connection to MongoDB successful&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> pymongo.errors.ConnectionFailure <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Connection failed: <span class="hljs-subst">{e}</span>&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


<span class="hljs-meta">... </span>mongo_uri = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> mongo_uri:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;MONGO_URI not set in environment variables&quot;</span>)

<span class="hljs-meta">... </span>mongo_client = get_mongo_client(mongo_uri)

<span class="hljs-meta">... </span><span class="hljs-comment"># Ingest data into MongoDB</span>
<span class="hljs-meta">... </span>db = mongo_client[<span class="hljs-string">&quot;movies&quot;</span>]
<span class="hljs-meta">... </span>collection = db[<span class="hljs-string">&quot;movie_collection_2&quot;</span>]`,wrap:!1}}),ie=new y({props:{code:"JTIzJTIwRGVsZXRlJTIwYW55JTIwZXhpc3RpbmclMjByZWNvcmRzJTIwaW4lMjB0aGUlMjBjb2xsZWN0aW9uJTBBY29sbGVjdGlvbi5kZWxldGVfbWFueSglN0IlN0Qp",highlighted:`<span class="hljs-comment"># Delete any existing records in the collection</span>
collection.delete_many({})`,wrap:!1}}),re=new y({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldF9kZi50b19kaWN0KCUyMnJlY29yZHMlMjIpJTBBY29sbGVjdGlvbi5pbnNlcnRfbWFueShkb2N1bWVudHMpJTBBJTBBcHJpbnQoJTIyRGF0YSUyMGluZ2VzdGlvbiUyMGludG8lMjBNb25nb0RCJTIwY29tcGxldGVkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>documents = dataset_df.to_dict(<span class="hljs-string">&quot;records&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.insert_many(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into MongoDB completed&quot;</span>)`,wrap:!1}}),ce=new u({props:{title:"Step 7: Perform Vector Search on User Queries",local:"step-7-perform-vector-search-on-user-queries",headingTag:"h2"}}),de=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">user_query, collection</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Perform a vector search in the MongoDB collection based on the user query.

    Args:
    user_query (str): The user&#x27;s query string.
    collection (MongoCollection): The MongoDB collection to search.

    Returns:
    list: A list of matching documents.
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate embedding for the user query</span>
    query_embedding = get_embedding(user_query)

    <span class="hljs-keyword">if</span> query_embedding <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Invalid query or embedding generation failed.&quot;</span>

    <span class="hljs-comment"># Define the vector search pipeline</span>
    pipeline = [
        {
            <span class="hljs-string">&quot;$vectorSearch&quot;</span>: {
                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;vector_index&quot;</span>,
                <span class="hljs-string">&quot;queryVector&quot;</span>: query_embedding,
                <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
                <span class="hljs-string">&quot;numCandidates&quot;</span>: <span class="hljs-number">150</span>,  <span class="hljs-comment"># Number of candidate matches to consider</span>
                <span class="hljs-string">&quot;limit&quot;</span>: <span class="hljs-number">4</span>,  <span class="hljs-comment"># Return top 4 matches</span>
            }
        },
        {
            <span class="hljs-string">&quot;$project&quot;</span>: {
                <span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-number">0</span>,  <span class="hljs-comment"># Exclude the _id field</span>
                <span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the plot field</span>
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the title field</span>
                <span class="hljs-string">&quot;genres&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the genres field</span>
                <span class="hljs-string">&quot;score&quot;</span>: {<span class="hljs-string">&quot;$meta&quot;</span>: <span class="hljs-string">&quot;vectorSearchScore&quot;</span>},  <span class="hljs-comment"># Include the search score</span>
            }
        },
    ]

    <span class="hljs-comment"># Execute the search</span>
    results = collection.aggregate(pipeline)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(results)`,wrap:!1}}),he=new u({props:{title:"Step 8: Handling user queries and loading Gemma",local:"step-8-handling-user-queries-and-loading-gemma",headingTag:"h2"}}),ye=new y({props:{code:"ZGVmJTIwZ2V0X3NlYXJjaF9yZXN1bHQocXVlcnklMkMlMjBjb2xsZWN0aW9uKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGdldF9rbm93bGVkZ2UlMjAlM0QlMjB2ZWN0b3Jfc2VhcmNoKHF1ZXJ5JTJDJTIwY29sbGVjdGlvbiklMEElMEElMjAlMjAlMjAlMjBzZWFyY2hfcmVzdWx0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVzdWx0JTIwaW4lMjBnZXRfa25vd2xlZGdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUyQiUzRCUyMGYlMjJUaXRsZSUzQSUyMCU3QnJlc3VsdC5nZXQoJ3RpdGxlJyUyQyUyMCdOJTJGQScpJTdEJTJDJTIwUGxvdCUzQSUyMCU3QnJlc3VsdC5nZXQoJ2Z1bGxwbG90JyUyQyUyMCdOJTJGQScpJTdEJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlYXJjaF9yZXN1bHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_search_result</span>(<span class="hljs-params">query, collection</span>):

    get_knowledge = vector_search(query, collection)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),ue=new y({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFzb3VyY2VfaW5mb3JtYXRpb24lMjAlM0QlMjBnZXRfc2VhcmNoX3Jlc3VsdChxdWVyeSUyQyUyMGNvbGxlY3Rpb24pJTBBY29tYmluZWRfaW5mb3JtYXRpb24lMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMlF1ZXJ5JTNBJTIwJTdCcXVlcnklN0QlNUNuQ29udGludWUlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXJ5JTIwYnklMjB1c2luZyUyMHRoZSUyMFNlYXJjaCUyMFJlc3VsdHMlM0ElNUNuJTdCc291cmNlX2luZm9ybWF0aW9uJTdELiUyMiUwQSklMEElMEFwcmludChjb21iaW5lZF9pbmZvcm1hdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_information = get_search_result(query, collection)
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_information = (
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using the Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_information)`,wrap:!1}}),ge=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;)</span>
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),je=new y({props:{code:"JTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFyZXNwb25zZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MDApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShyZXNwb25zZSU1QjAlNUQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">500</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(response[<span class="hljs-number">0</span>]))`,wrap:!1}}),Te=new y({props:{code:"",highlighted:"",wrap:!1}}),be=new Us({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_mongodb.md"}}),{c(){w=i("meta"),Ie=n(),Ue=i("p"),Ce=n(),p(g.$$.fragment),Ze=n(),p(j.$$.fragment),ve=n(),J=i("p"),J.innerHTML=$t,Be=n(),p(T.$$.fragment),Ge=n(),b=i("p"),b.textContent=Rt,Ae=n(),U=i("ul"),U.innerHTML=Vt,We=n(),p(f.$$.fragment),ke=n(),p(I.$$.fragment),$e=n(),C=i("p"),C.innerHTML=Qt,Re=n(),p(Z.$$.fragment),Ve=n(),v=i("p"),v.textContent=_t,Qe=n(),B=i("ol"),B.innerHTML=St,_e=n(),p(G.$$.fragment),Se=n(),A=i("pre"),A.textContent=qt,qe=n(),p(W.$$.fragment),xe=n(),k=i("p"),k.innerHTML=xt,Ee=n(),$=i("ol"),$.innerHTML=Et,Ne=n(),R=i("p"),R.innerHTML=Nt,Xe=n(),p(V.$$.fragment),He=n(),p(Q.$$.fragment),Fe=n(),_=i("p"),_.textContent=Xt,Ye=n(),S=i("p"),S.innerHTML=Ht,ze=n(),q=i("ol"),q.innerHTML=Ft,Pe=n(),p(x.$$.fragment),De=n(),E=i("p"),E.textContent=Yt,Le=n(),N=i("ul"),N.innerHTML=zt,Ke=n(),X=i("p"),X.innerHTML=Pt,Oe=n(),H=i("p"),H.textContent=Dt,et=n(),F=i("p"),F.innerHTML=Lt,tt=n(),Y=i("p"),Y.innerHTML=Kt,st=n(),z=i("p"),z.innerHTML=Ot,lt=n(),p(P.$$.fragment),nt=n(),D=i("p"),D.textContent=es,at=n(),L=i("p"),L.innerHTML=ts,it=n(),K=i("p"),K.textContent=ss,ot=n(),O=i("p"),O.innerHTML=ls,rt=n(),p(ee.$$.fragment),pt=n(),te=i("p"),te.innerHTML=ns,ct=n(),p(se.$$.fragment),mt=n(),le=i("p"),le.textContent=as,Mt=n(),p(ne.$$.fragment),dt=n(),ae=i("pre"),ae.textContent=is,ht=n(),p(ie.$$.fragment),yt=n(),oe=i("p"),oe.innerHTML=os,ut=n(),p(re.$$.fragment),wt=n(),pe=i("pre"),pe.textContent=rs,gt=n(),p(ce.$$.fragment),jt=n(),me=i("p"),me.textContent=ps,Jt=n(),Me=i("p"),Me.innerHTML=cs,Tt=n(),p(de.$$.fragment),bt=n(),p(he.$$.fragment),Ut=n(),p(ye.$$.fragment),ft=n(),p(ue.$$.fragment),It=n(),we=i("pre"),we.textContent=ms,Ct=n(),p(ge.$$.fragment),Zt=n(),p(je.$$.fragment),vt=n(),Je=i("pre"),Je.innerHTML=Ms,Bt=n(),p(Te.$$.fragment),Gt=n(),p(be.$$.fragment),At=n(),fe=i("p"),this.h()},l(e){const t=Js("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ie=a(e),Ue=o(e,"P",{}),ds(Ue).forEach(s),Ce=a(e),c(g.$$.fragment,e),Ze=a(e),c(j.$$.fragment,e),ve=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-v2pm3i"&&(J.innerHTML=$t),Be=a(e),c(T.$$.fragment,e),Ge=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1l8u5ax"&&(b.textContent=Rt),Ae=a(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-oizoqw"&&(U.innerHTML=Vt),We=a(e),c(f.$$.fragment,e),ke=a(e),c(I.$$.fragment,e),$e=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-mi16g3"&&(C.innerHTML=Qt),Re=a(e),c(Z.$$.fragment,e),Ve=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-s56722"&&(v.textContent=_t),Qe=a(e),B=o(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-18k6dgd"&&(B.innerHTML=St),_e=a(e),c(G.$$.fragment,e),Se=a(e),A=o(e,"PRE",{"data-svelte-h":!0}),r(A)!=="svelte-kp0u3c"&&(A.textContent=qt),qe=a(e),c(W.$$.fragment,e),xe=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16a70y4"&&(k.innerHTML=xt),Ee=a(e),$=o(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-2t4hjb"&&($.innerHTML=Et),Ne=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-18ffxry"&&(R.innerHTML=Nt),Xe=a(e),c(V.$$.fragment,e),He=a(e),c(Q.$$.fragment,e),Fe=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1bv8nrt"&&(_.textContent=Xt),Ye=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1lfzr8d"&&(S.innerHTML=Ht),ze=a(e),q=o(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-1mt6yhl"&&(q.innerHTML=Ft),Pe=a(e),c(x.$$.fragment,e),De=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ee4dh7"&&(E.textContent=Yt),Le=a(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-12k93hp"&&(N.innerHTML=zt),Ke=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1rvrea9"&&(X.innerHTML=Pt),Oe=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-19eikyc"&&(H.textContent=Dt),et=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-g1ykc5"&&(F.innerHTML=Lt),tt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1slb9bh"&&(Y.innerHTML=Kt),st=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-7nku6n"&&(z.innerHTML=Ot),lt=a(e),c(P.$$.fragment,e),nt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-bgxno0"&&(D.textContent=es),at=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ryzl16"&&(L.innerHTML=ts),it=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1haeg7n"&&(K.textContent=ss),ot=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1x2bslh"&&(O.innerHTML=ls),rt=a(e),c(ee.$$.fragment,e),pt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1lac1sw"&&(te.innerHTML=ns),ct=a(e),c(se.$$.fragment,e),mt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-c17qkj"&&(le.textContent=as),Mt=a(e),c(ne.$$.fragment,e),dt=a(e),ae=o(e,"PRE",{"data-svelte-h":!0}),r(ae)!=="svelte-1im4pel"&&(ae.textContent=is),ht=a(e),c(ie.$$.fragment,e),yt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1f9pwum"&&(oe.innerHTML=os),ut=a(e),c(re.$$.fragment,e),wt=a(e),pe=o(e,"PRE",{"data-svelte-h":!0}),r(pe)!=="svelte-48vgel"&&(pe.textContent=rs),gt=a(e),c(ce.$$.fragment,e),jt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1r00an3"&&(me.textContent=ps),Jt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1hz15p5"&&(Me.innerHTML=cs),Tt=a(e),c(de.$$.fragment,e),bt=a(e),c(he.$$.fragment,e),Ut=a(e),c(ye.$$.fragment,e),ft=a(e),c(ue.$$.fragment,e),It=a(e),we=o(e,"PRE",{"data-svelte-h":!0}),r(we)!=="svelte-kam1j9"&&(we.textContent=ms),Ct=a(e),c(ge.$$.fragment,e),Zt=a(e),c(je.$$.fragment,e),vt=a(e),Je=o(e,"PRE",{"data-svelte-h":!0}),r(Je)!=="svelte-146jypo"&&(Je.innerHTML=Ms),Bt=a(e),c(Te.$$.fragment,e),Gt=a(e),c(be.$$.fragment,e),At=a(e),fe=o(e,"P",{}),ds(fe).forEach(s),this.h()},h(){hs(w,"name","hf:doc:metadata"),hs(w,"content",Is)},m(e,t){Ts(document.head,w),l(e,Ie,t),l(e,Ue,t),l(e,Ce,t),m(g,e,t),l(e,Ze,t),m(j,e,t),l(e,ve,t),l(e,J,t),l(e,Be,t),m(T,e,t),l(e,Ge,t),l(e,b,t),l(e,Ae,t),l(e,U,t),l(e,We,t),m(f,e,t),l(e,ke,t),m(I,e,t),l(e,$e,t),l(e,C,t),l(e,Re,t),m(Z,e,t),l(e,Ve,t),l(e,v,t),l(e,Qe,t),l(e,B,t),l(e,_e,t),m(G,e,t),l(e,Se,t),l(e,A,t),l(e,qe,t),m(W,e,t),l(e,xe,t),l(e,k,t),l(e,Ee,t),l(e,$,t),l(e,Ne,t),l(e,R,t),l(e,Xe,t),m(V,e,t),l(e,He,t),m(Q,e,t),l(e,Fe,t),l(e,_,t),l(e,Ye,t),l(e,S,t),l(e,ze,t),l(e,q,t),l(e,Pe,t),m(x,e,t),l(e,De,t),l(e,E,t),l(e,Le,t),l(e,N,t),l(e,Ke,t),l(e,X,t),l(e,Oe,t),l(e,H,t),l(e,et,t),l(e,F,t),l(e,tt,t),l(e,Y,t),l(e,st,t),l(e,z,t),l(e,lt,t),m(P,e,t),l(e,nt,t),l(e,D,t),l(e,at,t),l(e,L,t),l(e,it,t),l(e,K,t),l(e,ot,t),l(e,O,t),l(e,rt,t),m(ee,e,t),l(e,pt,t),l(e,te,t),l(e,ct,t),m(se,e,t),l(e,mt,t),l(e,le,t),l(e,Mt,t),m(ne,e,t),l(e,dt,t),l(e,ae,t),l(e,ht,t),m(ie,e,t),l(e,yt,t),l(e,oe,t),l(e,ut,t),m(re,e,t),l(e,wt,t),l(e,pe,t),l(e,gt,t),m(ce,e,t),l(e,jt,t),l(e,me,t),l(e,Jt,t),l(e,Me,t),l(e,Tt,t),m(de,e,t),l(e,bt,t),m(he,e,t),l(e,Ut,t),m(ye,e,t),l(e,ft,t),m(ue,e,t),l(e,It,t),l(e,we,t),l(e,Ct,t),m(ge,e,t),l(e,Zt,t),m(je,e,t),l(e,vt,t),l(e,Je,t),l(e,Bt,t),m(Te,e,t),l(e,Gt,t),m(be,e,t),l(e,At,t),l(e,fe,t),Wt=!0},p:us,i(e){Wt||(M(g.$$.fragment,e),M(j.$$.fragment,e),M(T.$$.fragment,e),M(f.$$.fragment,e),M(I.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(V.$$.fragment,e),M(Q.$$.fragment,e),M(x.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(ue.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),Wt=!0)},o(e){d(g.$$.fragment,e),d(j.$$.fragment,e),d(T.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(V.$$.fragment,e),d(Q.$$.fragment,e),d(x.$$.fragment,e),d(P.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(be.$$.fragment,e),Wt=!1},d(e){e&&(s(Ie),s(Ue),s(Ce),s(Ze),s(ve),s(J),s(Be),s(Ge),s(b),s(Ae),s(U),s(We),s(ke),s($e),s(C),s(Re),s(Ve),s(v),s(Qe),s(B),s(_e),s(Se),s(A),s(qe),s(xe),s(k),s(Ee),s($),s(Ne),s(R),s(Xe),s(He),s(Fe),s(_),s(Ye),s(S),s(ze),s(q),s(Pe),s(De),s(E),s(Le),s(N),s(Ke),s(X),s(Oe),s(H),s(et),s(F),s(tt),s(Y),s(st),s(z),s(lt),s(nt),s(D),s(at),s(L),s(it),s(K),s(ot),s(O),s(rt),s(pt),s(te),s(ct),s(mt),s(le),s(Mt),s(dt),s(ae),s(ht),s(yt),s(oe),s(ut),s(wt),s(pe),s(gt),s(jt),s(me),s(Jt),s(Me),s(Tt),s(bt),s(Ut),s(ft),s(It),s(we),s(Ct),s(Zt),s(vt),s(Je),s(Bt),s(Gt),s(At),s(fe)),s(w),h(g,e),h(j,e),h(T,e),h(f,e),h(I,e),h(Z,e),h(G,e),h(W,e),h(V,e),h(Q,e),h(x,e),h(P,e),h(ee,e),h(se,e),h(ne,e),h(ie,e),h(re,e),h(ce,e),h(de,e),h(he,e),h(ye,e),h(ue,e),h(ge,e),h(je,e),h(Te,e),h(be,e)}}}const Is='{"title":"Building A RAG System with Gemma, MongoDB and Open Source Models","local":"building-a-rag-system-with-gemma-mongodb-and-open-source-models","sections":[{"title":"Step 1: Installing Libraries","local":"step-1-installing-libraries","sections":[],"depth":2},{"title":"Step 2: Data sourcing and preparation","local":"step-2-data-sourcing-and-preparation","sections":[],"depth":2},{"title":"Step 3: Generating embeddings","local":"step-3-generating-embeddings","sections":[],"depth":2},{"title":"Step 4: Database setup and connection","local":"step-4-database-setup-and-connection","sections":[{"title":"4.1 Database and Collection Setup","local":"41-database-and-collection-setup","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Create a Vector Search Index","local":"step-5-create-a-vector-search-index","sections":[],"depth":2},{"title":"Step 6: Establish Data Connection","local":"step-6-establish-data-connection","sections":[],"depth":2},{"title":"Step 7: Perform Vector Search on User Queries","local":"step-7-perform-vector-search-on-user-queries","sections":[],"depth":2},{"title":"Step 8: Handling user queries and loading Gemma","local":"step-8-handling-user-queries-and-loading-gemma","sections":[],"depth":2}],"depth":1}';function Cs(kt){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends gs{constructor(w){super(),js(this,w,Cs,fs,ys,{})}}export{As as component};
