import{s as fl,n as Ul,o as bl}from"../chunks/scheduler.7bc62968.js";import{S as Il,i as Zl,g as p,s as t,r as o,A as Cl,h as i,f as a,c as n,j as ml,u as c,x as u,k as gl,y as Bl,a as e,v as h,d as J,t as M,w as T}from"../chunks/index.66556066.js";import{C as r}from"../chunks/CodeBlock.5372f996.js";import{H as w,E as Gl}from"../chunks/index.0cc03bb1.js";function $l(Os){let d,os,ps,cs,y,hs,j,sl="Official utilities to use the Hugging Face Hub API.",Js,m,Ms,g,Ts,f,us,U,ws,b,ds,I,ll='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',rs,Z,al='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',ys,C,js,B,ms,G,el="You can use <code>@huggingface/hub</code> in CLI mode to upload files and folders to your repo.",gs,$,fs,k,tl="You can also instal globally with <code>npm install -g @huggingface/hub</code>. Then you can do:",Us,W,bs,N,Is,R,nl='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',Zs,V,pl="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",Cs,Y,Bs,v,il='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',Gs,E,$s,Q,ol='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',ks,H,Ws,F,cl="You can get the list of cached repositories using the <code>scanCacheDir</code> function.",Ns,x,Rs,X,hl="Note: this does not work in the browser",Vs,L,Ys,_,Jl="You can cache a file of a repository using the <code>downloadFileToCacheDir</code> function.",vs,S,Es,z,Ml="Note: this does not work in the browser",Qs,A,Hs,q,Tl="You can download an entire repository at a given revision in the cache directory using the <code>snapshotDownload</code> function.",Fs,D,xs,P,ul="The code use internally the <code>downloadFileToCacheDir</code> function.",Xs,K,wl="Note: this does not work in the browser",Ls,O,_s,ss,dl="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",Ss,ls,rl="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",zs,as,yl="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",As,es,qs,ts,jl="<li><code>@huggingface/tasks</code> : Typings only</li> <li><code>@huggingface/lz4</code> : URL join utility</li>",Ds,ns,Ps,is,Ks;return y=new w({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),m=new w({props:{title:"Install",local:"install",headingTag:"h2"}}),g=new r({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),f=new w({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new r({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),b=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),C=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Local folder URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./models&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),B=new w({props:{title:"CLI usage",local:"cli-usage",headingTag:"h2"}}),$=new r({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMC4lMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMGRhdGFzZXRzJTJGY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMC4lMEElMjMlMjBTYW1lJTIwdGhpbmclMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUyMGNveW90dGU1MDglMkZ0ZXN0LWRhdGFzZXQlMjAuJTBBJTIzJTIwVXBsb2FkJTIwbmV3JTIwZGF0YSUyMHdpdGglMjAwJTIwaGlzdG9yeSUyMGluJTIwYSUyMHNlcGFyYXRlJTIwYnJhbmNoJTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjBjcmVhdGUtYnJhbmNoJTIwY295b3R0ZTUwOCUyRnRlc3QtbW9kZWwlMjByZWxlYXNlJTIwLS1lbXB0eSUwQW5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTIwdXBsb2FkJTIwY295b3R0ZTUwOCUyRnRlc3QtbW9kZWwlMjAuJTIwLS1yZXZpc2lvbiUyMHJlbGVhc2UlMEElMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMC0taGVscCUwQW5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTIwdXBsb2FkJTIwLS1oZWxw",highlighted:`npx @huggingface/hub upload coyotte508/test-model .
npx @huggingface/hub upload datasets/coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Same thing</span>
npx @huggingface/hub upload --repo-type dataset coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Upload new data with 0 <span class="hljs-built_in">history</span> <span class="hljs-keyword">in</span> a separate branch</span>
npx @huggingface/hub create-branch coyotte508/test-model release --empty
npx @huggingface/hub upload coyotte508/test-model . --revision release

npx @huggingface/hub --help
npx @huggingface/hub upload --help`,wrap:!1}}),W=new r({props:{code:"aGZqcyUyMHVwbG9hZCUyMGNveW90dGU1MDglMkZ0ZXN0LW1vZGVsJTIwLiUwQSUwQWhmanMlMjBjcmVhdGUtYnJhbmNoJTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMHJlbGVhc2UlMjAtLWVtcHR5JTBBaGZqcyUyMHVwbG9hZCUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUyMGNveW90dGU1MDglMkZ0ZXN0LWRhdGFzZXQlMjAuJTIwLS1yZXZpc2lvbiUyMHJlbGVhc2UlMEElMEFoZmpzJTIwLS1oZWxwJTBBaGZqcyUyMCUyMHVwbG9hZCUyMC0taGVscA==",highlighted:`hfjs upload coyotte508/test-model .

hfjs create-branch --repo-type dataset coyotte508/test-dataset release --empty
hfjs upload --repo-type dataset coyotte508/test-dataset . --revision release

hfjs --help
hfjs  upload --help`,wrap:!1}}),N=new w({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),Y=new r({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),E=new w({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),H=new w({props:{title:"scanCacheDir",local:"scancachedir",headingTag:"h3"}}),x=new r({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),L=new w({props:{title:"downloadFileToCacheDir",local:"downloadfiletocachedir",headingTag:"h3"}}),S=new r({props:{code:"aW1wb3J0JTIwJTdCJTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZmlsZSUyMCUzRCUyMGF3YWl0JTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciglN0IlMEElMjAlMjByZXBvJTNBJTIwJ2ZvbyUyRmJhciclMkMlMEElMjAlMjBwYXRoJTNBJTIwJ1JFQURNRS5tZCclMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coZmlsZSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { downloadFileToCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> file = <span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFileToCacheDir</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
  <span class="hljs-attr">path</span>: <span class="hljs-string">&#x27;README.md&#x27;</span>
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(file);`,wrap:!1}}),A=new w({props:{title:"snapshotDownload",local:"snapshotdownload",headingTag:"h3"}}),D=new r({props:{code:"aW1wb3J0JTIwJTdCJTIwc25hcHNob3REb3dubG9hZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZGlyZWN0b3J5JTIwJTNEJTIwYXdhaXQlMjBzbmFwc2hvdERvd25sb2FkKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAnZm9vJTJGYmFyJyUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhkaXJlY3RvcnkpJTNC",highlighted:`<span class="hljs-keyword">import</span> { snapshotDownload } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> directory = <span class="hljs-keyword">await</span> <span class="hljs-title function_">snapshotDownload</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(directory);`,wrap:!1}}),O=new w({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),es=new w({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),ns=new Gl({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){d=p("meta"),os=t(),ps=p("p"),cs=t(),o(y.$$.fragment),hs=t(),j=p("p"),j.textContent=sl,Js=t(),o(m.$$.fragment),Ms=t(),o(g.$$.fragment),Ts=t(),o(f.$$.fragment),us=t(),o(U.$$.fragment),ws=t(),o(b.$$.fragment),ds=t(),I=p("p"),I.innerHTML=ll,rs=t(),Z=p("p"),Z.innerHTML=al,ys=t(),o(C.$$.fragment),js=t(),o(B.$$.fragment),ms=t(),G=p("p"),G.innerHTML=el,gs=t(),o($.$$.fragment),fs=t(),k=p("p"),k.innerHTML=tl,Us=t(),o(W.$$.fragment),bs=t(),o(N.$$.fragment),Is=t(),R=p("p"),R.innerHTML=nl,Zs=t(),V=p("p"),V.textContent=pl,Cs=t(),o(Y.$$.fragment),Bs=t(),v=p("p"),v.innerHTML=il,Gs=t(),o(E.$$.fragment),$s=t(),Q=p("p"),Q.innerHTML=ol,ks=t(),o(H.$$.fragment),Ws=t(),F=p("p"),F.innerHTML=cl,Ns=t(),o(x.$$.fragment),Rs=t(),X=p("p"),X.textContent=hl,Vs=t(),o(L.$$.fragment),Ys=t(),_=p("p"),_.innerHTML=Jl,vs=t(),o(S.$$.fragment),Es=t(),z=p("p"),z.textContent=Ml,Qs=t(),o(A.$$.fragment),Hs=t(),q=p("p"),q.innerHTML=Tl,Fs=t(),o(D.$$.fragment),xs=t(),P=p("p"),P.innerHTML=ul,Xs=t(),K=p("p"),K.textContent=wl,Ls=t(),o(O.$$.fragment),_s=t(),ss=p("p"),ss.innerHTML=dl,Ss=t(),ls=p("p"),ls.innerHTML=rl,zs=t(),as=p("p"),as.innerHTML=yl,As=t(),o(es.$$.fragment),qs=t(),ts=p("ul"),ts.innerHTML=jl,Ds=t(),o(ns.$$.fragment),Ps=t(),is=p("p"),this.h()},l(s){const l=Cl("svelte-u9bgzb",document.head);d=i(l,"META",{name:!0,content:!0}),l.forEach(a),os=n(s),ps=i(s,"P",{}),ml(ps).forEach(a),cs=n(s),c(y.$$.fragment,s),hs=n(s),j=i(s,"P",{"data-svelte-h":!0}),u(j)!=="svelte-a2asrt"&&(j.textContent=sl),Js=n(s),c(m.$$.fragment,s),Ms=n(s),c(g.$$.fragment,s),Ts=n(s),c(f.$$.fragment,s),us=n(s),c(U.$$.fragment,s),ws=n(s),c(b.$$.fragment,s),ds=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1nqczoz"&&(I.innerHTML=ll),rs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-6ptpin"&&(Z.innerHTML=al),ys=n(s),c(C.$$.fragment,s),js=n(s),c(B.$$.fragment,s),ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1z0peli"&&(G.innerHTML=el),gs=n(s),c($.$$.fragment,s),fs=n(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-8e4k07"&&(k.innerHTML=tl),Us=n(s),c(W.$$.fragment,s),bs=n(s),c(N.$$.fragment,s),Is=n(s),R=i(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-bfok93"&&(R.innerHTML=nl),Zs=n(s),V=i(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1az135e"&&(V.textContent=pl),Cs=n(s),c(Y.$$.fragment,s),Bs=n(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1qsa6tj"&&(v.innerHTML=il),Gs=n(s),c(E.$$.fragment,s),$s=n(s),Q=i(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-8xjlck"&&(Q.innerHTML=ol),ks=n(s),c(H.$$.fragment,s),Ws=n(s),F=i(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1s5ry35"&&(F.innerHTML=cl),Ns=n(s),c(x.$$.fragment,s),Rs=n(s),X=i(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-zyh43t"&&(X.textContent=hl),Vs=n(s),c(L.$$.fragment,s),Ys=n(s),_=i(s,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1ucnuxi"&&(_.innerHTML=Jl),vs=n(s),c(S.$$.fragment,s),Es=n(s),z=i(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-zyh43t"&&(z.textContent=Ml),Qs=n(s),c(A.$$.fragment,s),Hs=n(s),q=i(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1yti9iu"&&(q.innerHTML=Tl),Fs=n(s),c(D.$$.fragment,s),xs=n(s),P=i(s,"P",{"data-svelte-h":!0}),u(P)!=="svelte-809o1h"&&(P.innerHTML=ul),Xs=n(s),K=i(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-zyh43t"&&(K.textContent=wl),Ls=n(s),c(O.$$.fragment,s),_s=n(s),ss=i(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-1gspubq"&&(ss.innerHTML=dl),Ss=n(s),ls=i(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-em0etc"&&(ls.innerHTML=rl),zs=n(s),as=i(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-lja874"&&(as.innerHTML=yl),As=n(s),c(es.$$.fragment,s),qs=n(s),ts=i(s,"UL",{"data-svelte-h":!0}),u(ts)!=="svelte-3axdjj"&&(ts.innerHTML=jl),Ds=n(s),c(ns.$$.fragment,s),Ps=n(s),is=i(s,"P",{}),ml(is).forEach(a),this.h()},h(){gl(d,"name","hf:doc:metadata"),gl(d,"content",kl)},m(s,l){Bl(document.head,d),e(s,os,l),e(s,ps,l),e(s,cs,l),h(y,s,l),e(s,hs,l),e(s,j,l),e(s,Js,l),h(m,s,l),e(s,Ms,l),h(g,s,l),e(s,Ts,l),h(f,s,l),e(s,us,l),h(U,s,l),e(s,ws,l),h(b,s,l),e(s,ds,l),e(s,I,l),e(s,rs,l),e(s,Z,l),e(s,ys,l),h(C,s,l),e(s,js,l),h(B,s,l),e(s,ms,l),e(s,G,l),e(s,gs,l),h($,s,l),e(s,fs,l),e(s,k,l),e(s,Us,l),h(W,s,l),e(s,bs,l),h(N,s,l),e(s,Is,l),e(s,R,l),e(s,Zs,l),e(s,V,l),e(s,Cs,l),h(Y,s,l),e(s,Bs,l),e(s,v,l),e(s,Gs,l),h(E,s,l),e(s,$s,l),e(s,Q,l),e(s,ks,l),h(H,s,l),e(s,Ws,l),e(s,F,l),e(s,Ns,l),h(x,s,l),e(s,Rs,l),e(s,X,l),e(s,Vs,l),h(L,s,l),e(s,Ys,l),e(s,_,l),e(s,vs,l),h(S,s,l),e(s,Es,l),e(s,z,l),e(s,Qs,l),h(A,s,l),e(s,Hs,l),e(s,q,l),e(s,Fs,l),h(D,s,l),e(s,xs,l),e(s,P,l),e(s,Xs,l),e(s,K,l),e(s,Ls,l),h(O,s,l),e(s,_s,l),e(s,ss,l),e(s,Ss,l),e(s,ls,l),e(s,zs,l),e(s,as,l),e(s,As,l),h(es,s,l),e(s,qs,l),e(s,ts,l),e(s,Ds,l),h(ns,s,l),e(s,Ps,l),e(s,is,l),Ks=!0},p:Ul,i(s){Ks||(J(y.$$.fragment,s),J(m.$$.fragment,s),J(g.$$.fragment,s),J(f.$$.fragment,s),J(U.$$.fragment,s),J(b.$$.fragment,s),J(C.$$.fragment,s),J(B.$$.fragment,s),J($.$$.fragment,s),J(W.$$.fragment,s),J(N.$$.fragment,s),J(Y.$$.fragment,s),J(E.$$.fragment,s),J(H.$$.fragment,s),J(x.$$.fragment,s),J(L.$$.fragment,s),J(S.$$.fragment,s),J(A.$$.fragment,s),J(D.$$.fragment,s),J(O.$$.fragment,s),J(es.$$.fragment,s),J(ns.$$.fragment,s),Ks=!0)},o(s){M(y.$$.fragment,s),M(m.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(U.$$.fragment,s),M(b.$$.fragment,s),M(C.$$.fragment,s),M(B.$$.fragment,s),M($.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),M(Y.$$.fragment,s),M(E.$$.fragment,s),M(H.$$.fragment,s),M(x.$$.fragment,s),M(L.$$.fragment,s),M(S.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(es.$$.fragment,s),M(ns.$$.fragment,s),Ks=!1},d(s){s&&(a(os),a(ps),a(cs),a(hs),a(j),a(Js),a(Ms),a(Ts),a(us),a(ws),a(ds),a(I),a(rs),a(Z),a(ys),a(js),a(ms),a(G),a(gs),a(fs),a(k),a(Us),a(bs),a(Is),a(R),a(Zs),a(V),a(Cs),a(Bs),a(v),a(Gs),a($s),a(Q),a(ks),a(Ws),a(F),a(Ns),a(Rs),a(X),a(Vs),a(Ys),a(_),a(vs),a(Es),a(z),a(Qs),a(Hs),a(q),a(Fs),a(xs),a(P),a(Xs),a(K),a(Ls),a(_s),a(ss),a(Ss),a(ls),a(zs),a(as),a(As),a(qs),a(ts),a(Ds),a(Ps),a(is)),a(d),T(y,s),T(m,s),T(g,s),T(f,s),T(U,s),T(b,s),T(C,s),T(B,s),T($,s),T(W,s),T(N,s),T(Y,s),T(E,s),T(H,s),T(x,s),T(L,s),T(S,s),T(A,s),T(D,s),T(O,s),T(es,s),T(ns,s)}}}const kl='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"CLI usage","local":"cli-usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[{"title":"scanCacheDir","local":"scancachedir","sections":[],"depth":3},{"title":"downloadFileToCacheDir","local":"downloadfiletocachedir","sections":[],"depth":3},{"title":"snapshotDownload","local":"snapshotdownload","sections":[],"depth":3}],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Wl(Os){return bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vl extends Il{constructor(d){super(),Zl(this,d,Wl,$l,fl,{})}}export{vl as component};
