import{s as Ns,f as Cs,o as Zs,n as Se}from"../chunks/scheduler.25b97de1.js";import{S as Js,i as Ws,g as a,s as n,r as g,A as Bs,h as i,f as t,c as r,j as y,u as f,x as h,k as w,y as o,a as c,v as u,d as _,t as b,w as k}from"../chunks/index.d9030fc9.js";import{T as qo}from"../chunks/Tip.baa67368.js";import{D as x}from"../chunks/Docstring.e257edda.js";import{C as no}from"../chunks/CodeBlock.e6cd0d95.js";import{E as so}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Ls}from"../chunks/PipelineTag.5f100392.js";import{H as vt,E as Rs}from"../chunks/EditOnGithub.91d95064.js";function Ps(z){let l,v=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){l=a("p"),l.innerHTML=v},l(m){l=i(m,"P",{"data-svelte-h":!0}),h(l)!=="svelte-j665pk"&&(l.innerHTML=v)},m(m,p){c(m,l,p)},p:Se,d(m){m&&t(l)}}}function Vs(z){let l,v="Examples:",m,p,M;return p=new no({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWFza0Zvcm1lciUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MaskFormer facebook/maskformer-swin-base-ade configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MaskFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/maskformer-swin-base-ade style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,m=n(),g(p.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),h(l)!=="svelte-kvfsh7"&&(l.textContent=v),m=r(d),f(p.$$.fragment,d)},m(d,F){c(d,l,F),c(d,m,F),u(p,d,F),M=!0},p:Se,i(d){M||(_(p.$$.fragment,d),M=!0)},o(d){b(p.$$.fragment,d),M=!1},d(d){d&&(t(l),t(m)),k(p,d)}}}function Es(z){let l,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=a("p"),l.innerHTML=v},l(m){l=i(m,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fincs2"&&(l.innerHTML=v)},m(m,p){c(m,l,p)},p:Se,d(m){m&&t(l)}}}function Xs(z){let l,v="Examples:",m,p,M;return p=new no({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBBREUyMGslMjBzZW1hbnRpYyUyMHNlZ21lbnRhdGlvbiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGRlY29kZXIlMjBvZiUyME1hc2tGb3JtZXIlMjBvdXRwdXRzJTIwaGlkZGVuJTIwc3RhdGVzJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEF0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy50cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdCh0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the decoder of MaskFormer outputs hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer_decoder_last_hidden_state = outputs.transformer_decoder_last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(transformer_decoder_last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,m=n(),g(p.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),h(l)!=="svelte-kvfsh7"&&(l.textContent=v),m=r(d),f(p.$$.fragment,d)},m(d,F){c(d,l,F),c(d,m,F),u(p,d,F),M=!0},p:Se,i(d){M||(_(p.$$.fragment,d),M=!0)},o(d){b(p.$$.fragment,d),M=!1},d(d){d&&(t(l),t(m)),k(p,d)}}}function Hs(z){let l,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=a("p"),l.innerHTML=v},l(m){l=i(m,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fincs2"&&(l.innerHTML=v)},m(m,p){c(m,l,p)},p:Se,d(m){m&&t(l)}}}function Ss(z){let l,v="Semantic segmentation example:",m,p,M;return p=new no({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_semantic_map.shape)
[<span class="hljs-number">512</span>, <span class="hljs-number">683</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,m=n(),g(p.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),h(l)!=="svelte-ec2k7m"&&(l.textContent=v),m=r(d),f(p.$$.fragment,d)},m(d,F){c(d,l,F),c(d,m,F),u(p,d,F),M=!0},p:Se,i(d){M||(_(p.$$.fragment,d),M=!0)},o(d){b(p.$$.fragment,d),M=!1},d(d){d&&(t(l),t(m)),k(p,d)}}}function Gs(z){let l,v="Panoptic segmentation example:",m,p,M;return p=new no({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBDT0NPJTIwcGFub3B0aWMlMjBzZWdtZW50YXRpb24lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtY29jbyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1jb2NvJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwY2xhc3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyklNjAlMEElMjMlMjBhbmQlMjBtYXNrc19xdWVyaWVzX2xvZ2l0cyUyMG9mJTIwc2hhcGUlMjAlNjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTYwJTBBY2xhc3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmNsYXNzX3F1ZXJpZXNfbG9naXRzJTBBbWFza3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLm1hc2tzX3F1ZXJpZXNfbG9naXRzJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwcGFzcyUyMHRoZW0lMjB0byUyMGltYWdlX3Byb2Nlc3NvciUyMGZvciUyMHBvc3Rwcm9jZXNzaW5nJTBBcmVzdWx0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19wYW5vcHRpY19zZWdtZW50YXRpb24ob3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklNUIwJTVEJTBBJTBBJTIzJTIwd2UlMjByZWZlciUyMHRvJTIwdGhlJTIwZGVtbyUyMG5vdGVib29rcyUyMGZvciUyMHZpc3VhbGl6YXRpb24lMjAoc2VlJTIwJTIyUmVzb3VyY2VzJTIyJTIwc2VjdGlvbiUyMGluJTIwdGhlJTIwTWFza0Zvcm1lciUyMGRvY3MpJTBBcHJlZGljdGVkX3Bhbm9wdGljX21hcCUyMCUzRCUyMHJlc3VsdCU1QiUyMnNlZ21lbnRhdGlvbiUyMiU1RCUwQWxpc3QocHJlZGljdGVkX3Bhbm9wdGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on COCO panoptic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]])[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = result[<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)
[<span class="hljs-number">480</span>, <span class="hljs-number">640</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,m=n(),g(p.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1hqqxa2"&&(l.textContent=v),m=r(d),f(p.$$.fragment,d)},m(d,F){c(d,l,F),c(d,m,F),u(p,d,F),M=!0},p:Se,i(d){M||(_(p.$$.fragment,d),M=!0)},o(d){b(p.$$.fragment,d),M=!1},d(d){d&&(t(l),t(m)),k(p,d)}}}function Os(z){let l,v,m,p,M,d,F,Ft,ne,wt,re,Ao='The MaskFormer model was proposed in <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">Per-Pixel Classification is Not All You Need for Semantic Segmentation</a> by Bowen Cheng, Alexander G. Schwing, Alexander Kirillov. MaskFormer addresses semantic segmentation with a mask classification paradigm instead of performing classic pixel-level classification.',yt,ae,Yo="The abstract from the paper is the following:",Tt,ie,Do="<em>Modern approaches typically formulate semantic segmentation as a per-pixel classification task, while instance-level segmentation is handled with an alternative mask classification. Our key insight: mask classification is sufficiently general to solve both semantic- and instance-level segmentation tasks in a unified manner using the exact same model, loss, and training procedure. Following this observation, we propose MaskFormer, a simple mask classification model which predicts a set of binary masks, each associated with a single global class label prediction. Overall, the proposed mask classification-based method simplifies the landscape of effective approaches to semantic and panoptic segmentation tasks and shows excellent empirical results. In particular, we observe that MaskFormer outperforms per-pixel classification baselines when the number of classes is large. Our mask classification-based method outperforms both current state-of-the-art semantic (55.6 mIoU on ADE20K) and panoptic segmentation (52.7 PQ on COCO) models.</em>",xt,le,Qo='The figure below illustrates the architecture of MaskFormer. Taken from the <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">original paper</a>.',$t,de,Ko,It,ce,es='This model was contributed by <a href="https://huggingface.co/francesco" rel="nofollow">francesco</a>. The original code can be found <a href="https://github.com/facebookresearch/MaskFormer" rel="nofollow">here</a>.',jt,me,zt,pe,ts=`<li>MaskFormer’s Transformer decoder is identical to the decoder of <a href="detr">DETR</a>. During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help the model output the correct number of objects of each class. If you set the parameter <code>use_auxiliary_loss</code> of <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>MaskFormerLoss</code> class of <code>modeling_maskformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/MaskFormer/blob/da3e60d85fdeedcb31476b5edd7d328826ce56cc/mask_former/modeling/criterion.py#L169" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> to prepare images for the model and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. Both tasks can be solved using <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,Ut,he,Nt,ge,Ct,fe,os='<li>All notebooks that illustrate inference as well as fine-tuning on custom data with MaskFormer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MaskFormer" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <code>MaskFormer</code> with <a href="/docs/transformers/pr_30511/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/instance-segmentation" rel="nofollow">here</a>.</li>',Zt,ue,Jt,P,_e,ro,Ge,ss='Class for outputs of <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. This class returns all the needed hidden states to compute the logits.',Wt,W,be,ao,Oe,ns='Class for outputs of <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.',io,qe,rs=`This output can be directly passed to <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or or
<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~MaskFormerImageProcessor] for details regarding usage.`,Bt,ke,as="## MaskFormerConfig[[transformers.MaskFormerConfig]]",Lt,I,Me,lo,Ae,is=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. It is used to instantiate a
MaskFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MaskFormer
<a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a> architecture trained
on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,co,Ye,ls=`Configuration objects inherit from <a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,mo,De,ds='Currently, MaskFormer only supports the <a href="swin">Swin Transformer</a> as backbone.',po,H,ho,S,ve,go,Qe,cs=`Instantiate a <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (or a derived class) from a pre-trained backbone model configuration and DETR model
configuration.`,Rt,Fe,ms="## MaskFormerImageProcessor[[transformers.MaskFormerImageProcessor]]",Pt,T,we,fo,Ke,ps=`Constructs a MaskFormer image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,uo,et,hs=`This image processor inherits from <a href="/docs/transformers/pr_30511/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,_o,tt,ye,bo,L,Te,ko,ot,gs="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",Mo,st,fs=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,vo,G,xe,Fo,nt,us=`Converts the output of <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,wo,O,$e,yo,rt,_s=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,To,q,Ie,xo,at,bs=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Vt,je,ks="## MaskFormerFeatureExtractor[[transformers.MaskFormerFeatureExtractor]]",Et,j,ze,$o,it,Ue,Io,R,Ne,jo,lt,Ms="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",zo,dt,vs=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,Uo,A,Ce,No,ct,Fs=`Converts the output of <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,Co,Y,Ze,Zo,mt,ws=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,Jo,D,Je,Wo,pt,ys=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Xt,We,Ts="## MaskFormerModel[[transformers.MaskFormerModel]]",Ht,B,Be,Bo,ht,xs=`The bare MaskFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Lo,C,Le,Ro,gt,$s='The <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Po,Q,Vo,K,St,Re,Is="## MaskFormerForInstanceSegmentation[[transformers.MaskFormerForInstanceSegmentation]]",Gt,V,Pe,Eo,U,Ve,Xo,ft,js='The <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Ho,ee,So,ut,zs="Examples:",Go,te,Oo,oe,Ot,Ee,qt,kt,At;return M=new vt({props:{title:"MaskFormer",local:"maskformer",headingTag:"h1"}}),F=new qo({props:{$$slots:{default:[Ps]},$$scope:{ctx:z}}}),ne=new vt({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new vt({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),he=new vt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new Ls({props:{pipeline:"image-segmentation"}}),ue=new vt({props:{title:"MaskFormer specific outputs",local:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",headingTag:"h2"}}),_e=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"pixel_decoder_last_hidden_state",val:": Optional = None"},{name:"transformer_decoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L147"}}),be=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": FloatTensor = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"pixel_decoder_last_hidden_state",val:": Optional = None"},{name:"transformer_decoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L190"}}),Me=new x({props:{name:"class transformers.MaskFormerConfig",anchor:"transformers.MaskFormerConfig",parameters:[{name:"fpn_feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"no_object_weight",val:": float = 0.1"},{name:"use_auxiliary_loss",val:": bool = False"},{name:"backbone_config",val:": Optional = None"},{name:"decoder_config",val:": Optional = None"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"dice_weight",val:": float = 1.0"},{name:"cross_entropy_weight",val:": float = 1.0"},{name:"mask_weight",val:": float = 20.0"},{name:"output_auxiliary_logits",val:": Optional = None"},{name:"backbone",val:": Optional = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.MaskFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.MaskFormerConfig.use_auxiliary_loss(bool,",description:`<strong>use_auxiliary_loss(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code> <code>MaskFormerForInstanceSegmentationOutput</code> will contain the auxiliary losses computed using the
logits from each decoder&#x2019;s stage.`,name:"use_auxiliary_loss(bool,"},{anchor:"transformers.MaskFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the backbone, if unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.MaskFormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.MaskFormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.MaskFormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.MaskFormerConfig.decoder_config",description:`<strong>decoder_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the transformer decoder model, if unset the base config for <code>detr-resnet-50</code>
will be used.`,name:"decoder_config"},{anchor:"transformers.MaskFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.MaskFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.MaskFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.MaskFormerConfig.cross_entropy_weight",description:`<strong>cross_entropy_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the cross entropy loss.`,name:"cross_entropy_weight"},{anchor:"transformers.MaskFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.MaskFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/configuration_maskformer.py#L30",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
Raised if the backbone model type selected is not in <code>["swin"]</code> or the decoder model type selected is not
in <code>["detr"]</code></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),H=new so({props:{anchor:"transformers.MaskFormerConfig.example",$$slots:{default:[Vs]},$$scope:{ctx:z}}}),ve=new x({props:{name:"from_backbone_and_decoder_configs",anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"decoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.decoder_config",description:`<strong>decoder_config</strong> (<a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The transformer decoder configuration to use.`,name:"decoder_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/configuration_maskformer.py#L203",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a></p>
`}}),we=new x({props:{name:"class transformers.MaskFormerImageProcessor",anchor:"transformers.MaskFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"num_labels",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.MaskFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.MaskFormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.MaskFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.MaskFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.MaskFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MaskFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.MaskFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.MaskFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.MaskFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.MaskFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.MaskFormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L354"}}),ye=new x({props:{name:"preprocess",anchor:"transformers.MaskFormerImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Optional = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"size_divisor",val:": Optional = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L678"}}),Te=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": List"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30511/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30511/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30511/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),xe=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1020",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),$e=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"},{name:"return_binary_maps",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1070",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ie=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1184",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ze=new x({props:{name:"class transformers.MaskFormerFeatureExtractor",anchor:"transformers.MaskFormerFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/feature_extraction_maskformer.py#L26"}}),Ue=new x({props:{name:"__call__",anchor:"transformers.MaskFormerFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L572"}}),Ne=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs",parameters:[{name:"pixel_values_list",val:": List"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30511/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30511/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30511/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Ce=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1020",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Ze=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"},{name:"return_binary_maps",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1070",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Je=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/image_processing_maskformer.py#L1184",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Be=new x({props:{name:"class transformers.MaskFormerModel",anchor:"transformers.MaskFormerModel",parameters:[{name:"config",val:": MaskFormerConfig"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L1525"}}),Le=new x({props:{name:"forward",anchor:"transformers.MaskFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L1539",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code></li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new qo({props:{$$slots:{default:[Es]},$$scope:{ctx:z}}}),K=new so({props:{anchor:"transformers.MaskFormerModel.forward.example",$$slots:{default:[Xs]},$$scope:{ctx:z}}}),Pe=new x({props:{name:"class transformers.MaskFormerForInstanceSegmentation",anchor:"transformers.MaskFormerForInstanceSegmentation",parameters:[{name:"config",val:": MaskFormerConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L1628"}}),Ve=new x({props:{name:"forward",anchor:"transformers.MaskFormerForInstanceSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": Optional = None"},{name:"class_labels",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_auxiliary_logits",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/maskformer/modeling_maskformer.py#L1737",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30511/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new qo({props:{$$slots:{default:[Hs]},$$scope:{ctx:z}}}),te=new so({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example",$$slots:{default:[Ss]},$$scope:{ctx:z}}}),oe=new so({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example-2",$$slots:{default:[Gs]},$$scope:{ctx:z}}}),Ee=new Rs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/maskformer.md"}}),{c(){l=a("meta"),v=n(),m=a("p"),p=n(),g(M.$$.fragment),d=n(),g(F.$$.fragment),Ft=n(),g(ne.$$.fragment),wt=n(),re=a("p"),re.innerHTML=Ao,yt=n(),ae=a("p"),ae.textContent=Yo,Tt=n(),ie=a("p"),ie.innerHTML=Do,xt=n(),le=a("p"),le.innerHTML=Qo,$t=n(),de=a("img"),It=n(),ce=a("p"),ce.innerHTML=es,jt=n(),g(me.$$.fragment),zt=n(),pe=a("ul"),pe.innerHTML=ts,Ut=n(),g(he.$$.fragment),Nt=n(),g(ge.$$.fragment),Ct=n(),fe=a("ul"),fe.innerHTML=os,Zt=n(),g(ue.$$.fragment),Jt=n(),P=a("div"),g(_e.$$.fragment),ro=n(),Ge=a("p"),Ge.innerHTML=ss,Wt=n(),W=a("div"),g(be.$$.fragment),ao=n(),Oe=a("p"),Oe.innerHTML=ns,io=n(),qe=a("p"),qe.innerHTML=rs,Bt=n(),ke=a("p"),ke.textContent=as,Lt=n(),I=a("div"),g(Me.$$.fragment),lo=n(),Ae=a("p"),Ae.innerHTML=is,co=n(),Ye=a("p"),Ye.innerHTML=ls,mo=n(),De=a("p"),De.innerHTML=ds,po=n(),g(H.$$.fragment),ho=n(),S=a("div"),g(ve.$$.fragment),go=n(),Qe=a("p"),Qe.innerHTML=cs,Rt=n(),Fe=a("p"),Fe.textContent=ms,Pt=n(),T=a("div"),g(we.$$.fragment),fo=n(),Ke=a("p"),Ke.textContent=ps,uo=n(),et=a("p"),et.innerHTML=hs,_o=n(),tt=a("div"),g(ye.$$.fragment),bo=n(),L=a("div"),g(Te.$$.fragment),ko=n(),ot=a("p"),ot.innerHTML=gs,Mo=n(),st=a("p"),st.innerHTML=fs,vo=n(),G=a("div"),g(xe.$$.fragment),Fo=n(),nt=a("p"),nt.innerHTML=us,wo=n(),O=a("div"),g($e.$$.fragment),yo=n(),rt=a("p"),rt.innerHTML=_s,To=n(),q=a("div"),g(Ie.$$.fragment),xo=n(),at=a("p"),at.innerHTML=bs,Vt=n(),je=a("p"),je.textContent=ks,Et=n(),j=a("div"),g(ze.$$.fragment),$o=n(),it=a("div"),g(Ue.$$.fragment),Io=n(),R=a("div"),g(Ne.$$.fragment),jo=n(),lt=a("p"),lt.innerHTML=Ms,zo=n(),dt=a("p"),dt.innerHTML=vs,Uo=n(),A=a("div"),g(Ce.$$.fragment),No=n(),ct=a("p"),ct.innerHTML=Fs,Co=n(),Y=a("div"),g(Ze.$$.fragment),Zo=n(),mt=a("p"),mt.innerHTML=ws,Jo=n(),D=a("div"),g(Je.$$.fragment),Wo=n(),pt=a("p"),pt.innerHTML=ys,Xt=n(),We=a("p"),We.textContent=Ts,Ht=n(),B=a("div"),g(Be.$$.fragment),Bo=n(),ht=a("p"),ht.innerHTML=xs,Lo=n(),C=a("div"),g(Le.$$.fragment),Ro=n(),gt=a("p"),gt.innerHTML=$s,Po=n(),g(Q.$$.fragment),Vo=n(),g(K.$$.fragment),St=n(),Re=a("p"),Re.textContent=Is,Gt=n(),V=a("div"),g(Pe.$$.fragment),Eo=n(),U=a("div"),g(Ve.$$.fragment),Xo=n(),ft=a("p"),ft.innerHTML=js,Ho=n(),g(ee.$$.fragment),So=n(),ut=a("p"),ut.textContent=zs,Go=n(),g(te.$$.fragment),Oo=n(),g(oe.$$.fragment),Ot=n(),g(Ee.$$.fragment),qt=n(),kt=a("p"),this.h()},l(e){const s=Bs("svelte-u9bgzb",document.head);l=i(s,"META",{name:!0,content:!0}),s.forEach(t),v=r(e),m=i(e,"P",{}),y(m).forEach(t),p=r(e),f(M.$$.fragment,e),d=r(e),f(F.$$.fragment,e),Ft=r(e),f(ne.$$.fragment,e),wt=r(e),re=i(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1nc0rjr"&&(re.innerHTML=Ao),yt=r(e),ae=i(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-vfdo9a"&&(ae.textContent=Yo),Tt=r(e),ie=i(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-lfolgg"&&(ie.innerHTML=Do),xt=r(e),le=i(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-58561s"&&(le.innerHTML=Qo),$t=r(e),de=i(e,"IMG",{width:!0,src:!0}),It=r(e),ce=i(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-1j464j"&&(ce.innerHTML=es),jt=r(e),f(me.$$.fragment,e),zt=r(e),pe=i(e,"UL",{"data-svelte-h":!0}),h(pe)!=="svelte-1ejueif"&&(pe.innerHTML=ts),Ut=r(e),f(he.$$.fragment,e),Nt=r(e),f(ge.$$.fragment,e),Ct=r(e),fe=i(e,"UL",{"data-svelte-h":!0}),h(fe)!=="svelte-18rx145"&&(fe.innerHTML=os),Zt=r(e),f(ue.$$.fragment,e),Jt=r(e),P=i(e,"DIV",{class:!0});var Xe=y(P);f(_e.$$.fragment,Xe),ro=r(Xe),Ge=i(Xe,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1kwtolp"&&(Ge.innerHTML=ss),Xe.forEach(t),Wt=r(e),W=i(e,"DIV",{class:!0});var E=y(W);f(be.$$.fragment,E),ao=r(E),Oe=i(E,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-9b3ghk"&&(Oe.innerHTML=ns),io=r(E),qe=i(E,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-1jenl1u"&&(qe.innerHTML=rs),E.forEach(t),Bt=r(e),ke=i(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-1g3kgbq"&&(ke.textContent=as),Lt=r(e),I=i(e,"DIV",{class:!0});var N=y(I);f(Me.$$.fragment,N),lo=r(N),Ae=i(N,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-xjewvg"&&(Ae.innerHTML=is),co=r(N),Ye=i(N,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-b62xan"&&(Ye.innerHTML=ls),mo=r(N),De=i(N,"P",{"data-svelte-h":!0}),h(De)!=="svelte-l3soxz"&&(De.innerHTML=ds),po=r(N),f(H.$$.fragment,N),ho=r(N),S=i(N,"DIV",{class:!0});var He=y(S);f(ve.$$.fragment,He),go=r(He),Qe=i(He,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-12s9ux6"&&(Qe.innerHTML=cs),He.forEach(t),N.forEach(t),Rt=r(e),Fe=i(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-hn8ixw"&&(Fe.textContent=ms),Pt=r(e),T=i(e,"DIV",{class:!0});var $=y(T);f(we.$$.fragment,$),fo=r($),Ke=i($,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-1fb5les"&&(Ke.textContent=ps),uo=r($),et=i($,"P",{"data-svelte-h":!0}),h(et)!=="svelte-i9q8er"&&(et.innerHTML=hs),_o=r($),tt=i($,"DIV",{class:!0});var Mt=y(tt);f(ye.$$.fragment,Mt),Mt.forEach(t),bo=r($),L=i($,"DIV",{class:!0});var X=y(L);f(Te.$$.fragment,X),ko=r(X),ot=i(X,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-1tetyua"&&(ot.innerHTML=gs),Mo=r(X),st=i(X,"P",{"data-svelte-h":!0}),h(st)!=="svelte-1r85oma"&&(st.innerHTML=fs),X.forEach(t),vo=r($),G=i($,"DIV",{class:!0});var Yt=y(G);f(xe.$$.fragment,Yt),Fo=r(Yt),nt=i(Yt,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-mhd7an"&&(nt.innerHTML=us),Yt.forEach(t),wo=r($),O=i($,"DIV",{class:!0});var Dt=y(O);f($e.$$.fragment,Dt),yo=r(Dt),rt=i(Dt,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-109ykdi"&&(rt.innerHTML=_s),Dt.forEach(t),To=r($),q=i($,"DIV",{class:!0});var Qt=y(q);f(Ie.$$.fragment,Qt),xo=r(Qt),at=i(Qt,"P",{"data-svelte-h":!0}),h(at)!=="svelte-pw2uru"&&(at.innerHTML=bs),Qt.forEach(t),$.forEach(t),Vt=r(e),je=i(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-cresm6"&&(je.textContent=ks),Et=r(e),j=i(e,"DIV",{class:!0});var Z=y(j);f(ze.$$.fragment,Z),$o=r(Z),it=i(Z,"DIV",{class:!0});var Us=y(it);f(Ue.$$.fragment,Us),Us.forEach(t),Io=r(Z),R=i(Z,"DIV",{class:!0});var _t=y(R);f(Ne.$$.fragment,_t),jo=r(_t),lt=i(_t,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-1tetyua"&&(lt.innerHTML=Ms),zo=r(_t),dt=i(_t,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-1r85oma"&&(dt.innerHTML=vs),_t.forEach(t),Uo=r(Z),A=i(Z,"DIV",{class:!0});var Kt=y(A);f(Ce.$$.fragment,Kt),No=r(Kt),ct=i(Kt,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-mhd7an"&&(ct.innerHTML=Fs),Kt.forEach(t),Co=r(Z),Y=i(Z,"DIV",{class:!0});var eo=y(Y);f(Ze.$$.fragment,eo),Zo=r(eo),mt=i(eo,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-109ykdi"&&(mt.innerHTML=ws),eo.forEach(t),Jo=r(Z),D=i(Z,"DIV",{class:!0});var to=y(D);f(Je.$$.fragment,to),Wo=r(to),pt=i(to,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-pw2uru"&&(pt.innerHTML=ys),to.forEach(t),Z.forEach(t),Xt=r(e),We=i(e,"P",{"data-svelte-h":!0}),h(We)!=="svelte-1qmy5mk"&&(We.textContent=Ts),Ht=r(e),B=i(e,"DIV",{class:!0});var bt=y(B);f(Be.$$.fragment,bt),Bo=r(bt),ht=i(bt,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-18inji4"&&(ht.innerHTML=xs),Lo=r(bt),C=i(bt,"DIV",{class:!0});var se=y(C);f(Le.$$.fragment,se),Ro=r(se),gt=i(se,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-1lgirpq"&&(gt.innerHTML=$s),Po=r(se),f(Q.$$.fragment,se),Vo=r(se),f(K.$$.fragment,se),se.forEach(t),bt.forEach(t),St=r(e),Re=i(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1bfoxsg"&&(Re.textContent=Is),Gt=r(e),V=i(e,"DIV",{class:!0});var oo=y(V);f(Pe.$$.fragment,oo),Eo=r(oo),U=i(oo,"DIV",{class:!0});var J=y(U);f(Ve.$$.fragment,J),Xo=r(J),ft=i(J,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-gy1cti"&&(ft.innerHTML=js),Ho=r(J),f(ee.$$.fragment,J),So=r(J),ut=i(J,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-kvfsh7"&&(ut.textContent=zs),Go=r(J),f(te.$$.fragment,J),Oo=r(J),f(oe.$$.fragment,J),J.forEach(t),oo.forEach(t),Ot=r(e),f(Ee.$$.fragment,e),qt=r(e),kt=i(e,"P",{}),y(kt).forEach(t),this.h()},h(){w(l,"name","hf:doc:metadata"),w(l,"content",qs),w(de,"width","600"),Cs(de.src,Ko="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/maskformer_architecture.png")||w(de,"src",Ko),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){o(document.head,l),c(e,v,s),c(e,m,s),c(e,p,s),u(M,e,s),c(e,d,s),u(F,e,s),c(e,Ft,s),u(ne,e,s),c(e,wt,s),c(e,re,s),c(e,yt,s),c(e,ae,s),c(e,Tt,s),c(e,ie,s),c(e,xt,s),c(e,le,s),c(e,$t,s),c(e,de,s),c(e,It,s),c(e,ce,s),c(e,jt,s),u(me,e,s),c(e,zt,s),c(e,pe,s),c(e,Ut,s),u(he,e,s),c(e,Nt,s),u(ge,e,s),c(e,Ct,s),c(e,fe,s),c(e,Zt,s),u(ue,e,s),c(e,Jt,s),c(e,P,s),u(_e,P,null),o(P,ro),o(P,Ge),c(e,Wt,s),c(e,W,s),u(be,W,null),o(W,ao),o(W,Oe),o(W,io),o(W,qe),c(e,Bt,s),c(e,ke,s),c(e,Lt,s),c(e,I,s),u(Me,I,null),o(I,lo),o(I,Ae),o(I,co),o(I,Ye),o(I,mo),o(I,De),o(I,po),u(H,I,null),o(I,ho),o(I,S),u(ve,S,null),o(S,go),o(S,Qe),c(e,Rt,s),c(e,Fe,s),c(e,Pt,s),c(e,T,s),u(we,T,null),o(T,fo),o(T,Ke),o(T,uo),o(T,et),o(T,_o),o(T,tt),u(ye,tt,null),o(T,bo),o(T,L),u(Te,L,null),o(L,ko),o(L,ot),o(L,Mo),o(L,st),o(T,vo),o(T,G),u(xe,G,null),o(G,Fo),o(G,nt),o(T,wo),o(T,O),u($e,O,null),o(O,yo),o(O,rt),o(T,To),o(T,q),u(Ie,q,null),o(q,xo),o(q,at),c(e,Vt,s),c(e,je,s),c(e,Et,s),c(e,j,s),u(ze,j,null),o(j,$o),o(j,it),u(Ue,it,null),o(j,Io),o(j,R),u(Ne,R,null),o(R,jo),o(R,lt),o(R,zo),o(R,dt),o(j,Uo),o(j,A),u(Ce,A,null),o(A,No),o(A,ct),o(j,Co),o(j,Y),u(Ze,Y,null),o(Y,Zo),o(Y,mt),o(j,Jo),o(j,D),u(Je,D,null),o(D,Wo),o(D,pt),c(e,Xt,s),c(e,We,s),c(e,Ht,s),c(e,B,s),u(Be,B,null),o(B,Bo),o(B,ht),o(B,Lo),o(B,C),u(Le,C,null),o(C,Ro),o(C,gt),o(C,Po),u(Q,C,null),o(C,Vo),u(K,C,null),c(e,St,s),c(e,Re,s),c(e,Gt,s),c(e,V,s),u(Pe,V,null),o(V,Eo),o(V,U),u(Ve,U,null),o(U,Xo),o(U,ft),o(U,Ho),u(ee,U,null),o(U,So),o(U,ut),o(U,Go),u(te,U,null),o(U,Oo),u(oe,U,null),c(e,Ot,s),u(Ee,e,s),c(e,qt,s),c(e,kt,s),At=!0},p(e,[s]){const Xe={};s&2&&(Xe.$$scope={dirty:s,ctx:e}),F.$set(Xe);const E={};s&2&&(E.$$scope={dirty:s,ctx:e}),H.$set(E);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),Q.$set(N);const He={};s&2&&(He.$$scope={dirty:s,ctx:e}),K.$set(He);const $={};s&2&&($.$$scope={dirty:s,ctx:e}),ee.$set($);const Mt={};s&2&&(Mt.$$scope={dirty:s,ctx:e}),te.$set(Mt);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),oe.$set(X)},i(e){At||(_(M.$$.fragment,e),_(F.$$.fragment,e),_(ne.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(H.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(Ie.$$.fragment,e),_(ze.$$.fragment,e),_(Ue.$$.fragment,e),_(Ne.$$.fragment,e),_(Ce.$$.fragment,e),_(Ze.$$.fragment,e),_(Je.$$.fragment,e),_(Be.$$.fragment,e),_(Le.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(Pe.$$.fragment,e),_(Ve.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(Ee.$$.fragment,e),At=!0)},o(e){b(M.$$.fragment,e),b(F.$$.fragment,e),b(ne.$$.fragment,e),b(me.$$.fragment,e),b(he.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(H.$$.fragment,e),b(ve.$$.fragment,e),b(we.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(xe.$$.fragment,e),b($e.$$.fragment,e),b(Ie.$$.fragment,e),b(ze.$$.fragment,e),b(Ue.$$.fragment,e),b(Ne.$$.fragment,e),b(Ce.$$.fragment,e),b(Ze.$$.fragment,e),b(Je.$$.fragment,e),b(Be.$$.fragment,e),b(Le.$$.fragment,e),b(Q.$$.fragment,e),b(K.$$.fragment,e),b(Pe.$$.fragment,e),b(Ve.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(Ee.$$.fragment,e),At=!1},d(e){e&&(t(v),t(m),t(p),t(d),t(Ft),t(wt),t(re),t(yt),t(ae),t(Tt),t(ie),t(xt),t(le),t($t),t(de),t(It),t(ce),t(jt),t(zt),t(pe),t(Ut),t(Nt),t(Ct),t(fe),t(Zt),t(Jt),t(P),t(Wt),t(W),t(Bt),t(ke),t(Lt),t(I),t(Rt),t(Fe),t(Pt),t(T),t(Vt),t(je),t(Et),t(j),t(Xt),t(We),t(Ht),t(B),t(St),t(Re),t(Gt),t(V),t(Ot),t(qt),t(kt)),t(l),k(M,e),k(F,e),k(ne,e),k(me,e),k(he,e),k(ge,e),k(ue,e),k(_e),k(be),k(Me),k(H),k(ve),k(we),k(ye),k(Te),k(xe),k($e),k(Ie),k(ze),k(Ue),k(Ne),k(Ce),k(Ze),k(Je),k(Be),k(Le),k(Q),k(K),k(Pe),k(Ve),k(ee),k(te),k(oe),k(Ee,e)}}}const qs='{"title":"MaskFormer","local":"maskformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput","sections":[],"depth":2}],"depth":1}';function As(z){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends Js{constructor(l){super(),Ws(this,l,As,Os,Ns,{})}}export{nn as component};
