import{s as Qi,o as qi,n as I}from"../chunks/scheduler.8c3d61f6.js";import{S as Ai,i as Oi,g as a,s as i,r as h,A as Ki,h as r,f as p,c as s,j as U,u as g,x as c,k as D,y as n,a as m,v as b,d as _,t as v,w as y}from"../chunks/index.589a98e8.js";import{T as _t}from"../chunks/Tip.42aa8582.js";import{D as j}from"../chunks/Docstring.27406313.js";import{C as te}from"../chunks/CodeBlock.36627b28.js";import{E as ee}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as oi,E as es}from"../chunks/EditOnGithub.e5a8d9cb.js";function ts(T){let o,x='You shouldn’t use the <a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/pr_8460/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/pr_8460/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',d,l,u,t,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=a("p"),o.innerHTML=x,d=i(),l=a("br"),u=i(),t=a("p"),t.innerHTML=M},l(J){o=r(J,"P",{"data-svelte-h":!0}),c(o)!=="svelte-13cxj4v"&&(o.innerHTML=x),d=s(J),l=r(J,"BR",{}),u=s(J),t=r(J,"P",{"data-svelte-h":!0}),c(t)!=="svelte-1a94ctl"&&(t.innerHTML=M)},m(J,z){m(J,o,z),m(J,d,z),m(J,l,z),m(J,u,z),m(J,t,z)},p:I,d(J){J&&(p(o),p(d),p(l),p(u),p(t))}}}function ns(T){let o,x=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=a("p"),o.textContent=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-18gkv0g"&&(o.textContent=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function os(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function is(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-6jnfc0"&&(o.innerHTML=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function ss(T){let o,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-ackzsn"&&(o.innerHTML=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function as(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function rs(T){let o,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17p1lpg"&&(o.textContent=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function ls(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ds(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQW5ld19waXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUuZnJvbV9waXBlKHBpcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ps(T){let o,x="If you get the error message below, you need to finetune the weights for your downstream task:",d,l,u;return l=new te({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function fs(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-x73rgs"&&(o.innerHTML=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function cs(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ms(T){let o,x="If you get the error message below, you need to finetune the weights for your downstream task:",d,l,u;return l=new te({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:',wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function us(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=x},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1fgfsm2"&&(o.innerHTML=x)},m(d,l){m(d,o,l)},p:I,d(d){d&&p(o)}}}function hs(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZHBtcHAlMkMlMjBkcG1wcF9zdGF0ZSUyMCUzRCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBKSUwQSUwQWRwbV9waXBlJTJDJTIwZHBtX3BhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function gs(T){let o,x="Examples:",d,l,u;return l=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=x,d=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),g(l.$$.fragment,t)},m(t,M){m(t,o,M),m(t,d,M),b(l,t,M),u=!0},p:I,i(t){u||(_(l.$$.fragment,t),u=!0)},o(t){v(l.$$.fragment,t),u=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function bs(T){let o,x,d,l,u,t,M,J="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",z,Je,ii='All pipelines are built from the base <a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/pr_8460/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',cn,ne,mn,ke,si="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",un,Ce,ai='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="alt_diffusion">AltDiffusion</a></td> <td>image2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audio_diffusion">Audio Diffusion</a></td> <td>image2audio</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="cycle_diffusion">Cycle Diffusion</a></td> <td>image2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/gligen">GLIGEN</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="stable_diffusion/ldm3d_diffusion">LDM3D</a></td> <td>text2image, text-to-3D, text-to-pano, upscaling</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="paradigms">ParaDiGMS</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix_zero">Pix2Pix Zero</a></td> <td>image editing</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pndm">PNDM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="repaint">RePaint</a></td> <td>inpainting</td></tr> <tr><td><a href="score_sde_ve">Score SDE VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="spectrogram_diffusion">Spectrogram Diffusion</a></td> <td></td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="model_editing">Stable Diffusion Model Editing</a></td> <td>model editing</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stochastic_karras_ve">Stochastic Karras VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="latent_diffusion_uncond">Unconditional Latent Diffusion</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="versatile_diffusion">Versatile Diffusion</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="vq_diffusion">VQ Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr></tbody>',hn,Ie,gn,w,Ge,kn,vt,ri="Base class for all pipelines.",Cn,yt,li=`<a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,In,wt,di="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",Gn,xt,pi="Class attributes:",Wn,$t,fi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,Vn,oe,We,Bn,Mt,ci="Call self as a function.",Hn,Tt,Ve,Fn,W,Be,Sn,Ut,mi=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Nn,ie,Ln,Dt,ui="Here are the ways to call <code>to</code>:",Xn,jt,hi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,En,H,He,Rn,Pt,gi=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,zn,Zt,bi=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,Yn,se,Qn,ae,Fe,qn,Jt,_i=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,An,re,Se,On,kt,vi='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Kn,Y,Ne,eo,Ct,yi="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",to,le,no,F,Le,oo,It,wi=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,io,de,so,pe,ao,fe,Xe,ro,Gt,xi=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,lo,ce,Ee,po,Wt,$i=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,fo,S,Re,co,Vt,Mi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,mo,me,uo,ue,ho,Q,ze,go,Bt,Ti=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,bo,he,_o,k,Ye,vo,Ht,Ui="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",yo,Ft,Di="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",wo,ge,xo,be,$o,_e,Mo,ve,Qe,To,St,ji=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,Uo,ye,qe,Do,Nt,Pi="Convert a NumPy image or a batch of images to a PIL image.",jo,we,Ae,Po,Lt,Zi="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",Zo,xe,Oe,Jo,Xt,Ji="Resets the device maps (if any) to None.",ko,$e,Ke,Co,Et,ki=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,bn,V,et,Io,Rt,Ci='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Go,zt,Ii="The suffixes after the scaling factors represent the stages where they are being applied.",Wo,Yt,Gi=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,_n,A,tt,Vo,Qt,Wi="Disables the FreeU mechanism if enabled.",vn,nt,yn,P,ot,Bo,qt,Vi="Base class for Flax-based pipelines.",Ho,At,Bi=`<a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Fo,Ot,Hi="<li>enable/disable the progress bar for the denoising iteration</li>",So,Kt,Fi="Class attributes:",No,en,Si=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,Lo,C,it,Xo,tn,Ni="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",Eo,nn,Li="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",Ro,Me,zo,Te,Yo,Ue,Qo,De,st,qo,on,Xi="Convert a NumPy image or a batch of images to a PIL image.",Ao,je,at,Oo,sn,Ei=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,wn,rt,Ri="## PushToHubMixin[[diffusers.utils.PushToHubMixin]]",xn,L,lt,Ko,an,zi="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",ei,q,dt,ti,rn,Yi="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",ni,Pe,$n,pt,Mn,pn,Tn;return u=new oi({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),ne=new _t({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:T}}}),Ie=new oi({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),Ge=new j({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L127"}}),We=new j({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ve=new j({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Be=new j({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),ie=new _t({props:{$$slots:{default:[ns]},$$scope:{ctx:T}}}),He=new j({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1581"}}),se=new ee({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[os]},$$scope:{ctx:T}}}),Fe=new j({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1743"}}),Se=new j({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1677"}}),Ne=new j({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1181",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),le=new _t({props:{$$slots:{default:[is]},$$scope:{ctx:T}}}),Le=new j({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1703"}}),de=new _t({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:T}}}),pe=new ee({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[as]},$$scope:{ctx:T}}}),Xe=new j({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1015"}}),Ee=new j({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1107"}}),Re=new j({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1642"}}),me=new _t({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:T}}}),ue=new ee({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ls]},$$scope:{ctx:T}}}),ze=new j({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1759",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),he=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[ds]},$$scope:{ctx:T}}}),Ye=new j({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L478"}}),ge=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[ps]},$$scope:{ctx:T}}}),be=new _t({props:{$$slots:{default:[fs]},$$scope:{ctx:T}}}),_e=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[cs]},$$scope:{ctx:T}}}),Qe=new j({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1093"}}),qe=new j({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1617"}}),Ae=new j({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1006"}}),Oe=new j({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1168"}}),Ke=new j({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/pr_8460/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L183"}}),et=new j({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1917"}}),tt=new j({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_utils.py#L1939"}}),nt=new oi({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),ot=new j({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),it=new j({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/pr_8460/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),Me=new ee({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[ms]},$$scope:{ctx:T}}}),Te=new _t({props:{$$slots:{default:[us]},$$scope:{ctx:T}}}),Ue=new ee({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[hs]},$$scope:{ctx:T}}}),st=new j({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_flax_utils.py#L588"}}),at=new j({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/pr_8460/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),lt=new j({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/utils/hub_utils.py#L502"}}),dt=new j({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/vr_8460/src/diffusers/utils/hub_utils.py#L531"}}),Pe=new ee({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[gs]},$$scope:{ctx:T}}}),pt=new es({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=a("meta"),x=i(),d=a("p"),l=i(),h(u.$$.fragment),t=i(),M=a("p"),M.textContent=J,z=i(),Je=a("p"),Je.innerHTML=ii,cn=i(),h(ne.$$.fragment),mn=i(),ke=a("p"),ke.textContent=si,un=i(),Ce=a("table"),Ce.innerHTML=ai,hn=i(),h(Ie.$$.fragment),gn=i(),w=a("div"),h(Ge.$$.fragment),kn=i(),vt=a("p"),vt.textContent=ri,Cn=i(),yt=a("p"),yt.innerHTML=li,In=i(),wt=a("ul"),wt.innerHTML=di,Gn=i(),xt=a("p"),xt.textContent=pi,Wn=i(),$t=a("ul"),$t.innerHTML=fi,Vn=i(),oe=a("div"),h(We.$$.fragment),Bn=i(),Mt=a("p"),Mt.textContent=ci,Hn=i(),Tt=a("div"),h(Ve.$$.fragment),Fn=i(),W=a("div"),h(Be.$$.fragment),Sn=i(),Ut=a("p"),Ut.innerHTML=mi,Nn=i(),h(ie.$$.fragment),Ln=i(),Dt=a("p"),Dt.innerHTML=ui,Xn=i(),jt=a("ul"),jt.innerHTML=hi,En=i(),H=a("div"),h(He.$$.fragment),Rn=i(),Pt=a("p"),Pt.innerHTML=gi,zn=i(),Zt=a("p"),Zt.innerHTML=bi,Yn=i(),h(se.$$.fragment),Qn=i(),ae=a("div"),h(Fe.$$.fragment),qn=i(),Jt=a("p"),Jt.innerHTML=_i,An=i(),re=a("div"),h(Se.$$.fragment),On=i(),kt=a("p"),kt.innerHTML=vi,Kn=i(),Y=a("div"),h(Ne.$$.fragment),eo=i(),Ct=a("p"),Ct.textContent=yi,to=i(),h(le.$$.fragment),no=i(),F=a("div"),h(Le.$$.fragment),oo=i(),It=a("p"),It.textContent=wi,io=i(),h(de.$$.fragment),so=i(),h(pe.$$.fragment),ao=i(),fe=a("div"),h(Xe.$$.fragment),ro=i(),Gt=a("p"),Gt.innerHTML=xi,lo=i(),ce=a("div"),h(Ee.$$.fragment),po=i(),Wt=a("p"),Wt.innerHTML=$i,fo=i(),S=a("div"),h(Re.$$.fragment),co=i(),Vt=a("p"),Vt.innerHTML=Mi,mo=i(),h(me.$$.fragment),uo=i(),h(ue.$$.fragment),ho=i(),Q=a("div"),h(ze.$$.fragment),go=i(),Bt=a("p"),Bt.textContent=Ti,bo=i(),h(he.$$.fragment),_o=i(),k=a("div"),h(Ye.$$.fragment),vo=i(),Ht=a("p"),Ht.textContent=Ui,yo=i(),Ft=a("p"),Ft.innerHTML=Di,wo=i(),h(ge.$$.fragment),xo=i(),h(be.$$.fragment),$o=i(),h(_e.$$.fragment),Mo=i(),ve=a("div"),h(Qe.$$.fragment),To=i(),St=a("p"),St.innerHTML=ji,Uo=i(),ye=a("div"),h(qe.$$.fragment),Do=i(),Nt=a("p"),Nt.textContent=Pi,jo=i(),we=a("div"),h(Ae.$$.fragment),Po=i(),Lt=a("p"),Lt.innerHTML=Zi,Zo=i(),xe=a("div"),h(Oe.$$.fragment),Jo=i(),Xt=a("p"),Xt.textContent=Ji,ko=i(),$e=a("div"),h(Ke.$$.fragment),Co=i(),Et=a("p"),Et.innerHTML=ki,bn=i(),V=a("div"),h(et.$$.fragment),Io=i(),Rt=a("p"),Rt.innerHTML=Ci,Go=i(),zt=a("p"),zt.textContent=Ii,Wo=i(),Yt=a("p"),Yt.innerHTML=Gi,_n=i(),A=a("div"),h(tt.$$.fragment),Vo=i(),Qt=a("p"),Qt.textContent=Wi,vn=i(),h(nt.$$.fragment),yn=i(),P=a("div"),h(ot.$$.fragment),Bo=i(),qt=a("p"),qt.textContent=Vi,Ho=i(),At=a("p"),At.innerHTML=Bi,Fo=i(),Ot=a("ul"),Ot.innerHTML=Hi,So=i(),Kt=a("p"),Kt.textContent=Fi,No=i(),en=a("ul"),en.innerHTML=Si,Lo=i(),C=a("div"),h(it.$$.fragment),Xo=i(),tn=a("p"),tn.textContent=Ni,Eo=i(),nn=a("p"),nn.textContent=Li,Ro=i(),h(Me.$$.fragment),zo=i(),h(Te.$$.fragment),Yo=i(),h(Ue.$$.fragment),Qo=i(),De=a("div"),h(st.$$.fragment),qo=i(),on=a("p"),on.textContent=Xi,Ao=i(),je=a("div"),h(at.$$.fragment),Oo=i(),sn=a("p"),sn.innerHTML=Ei,wn=i(),rt=a("p"),rt.textContent=Ri,xn=i(),L=a("div"),h(lt.$$.fragment),Ko=i(),an=a("p"),an.textContent=zi,ei=i(),q=a("div"),h(dt.$$.fragment),ti=i(),rn=a("p"),rn.textContent=Yi,ni=i(),h(Pe.$$.fragment),$n=i(),h(pt.$$.fragment),Mn=i(),pn=a("p"),this.h()},l(e){const f=Ki("svelte-u9bgzb",document.head);o=r(f,"META",{name:!0,content:!0}),f.forEach(p),x=s(e),d=r(e,"P",{}),U(d).forEach(p),l=s(e),g(u.$$.fragment,e),t=s(e),M=r(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-eejdx6"&&(M.textContent=J),z=s(e),Je=r(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1hfebzb"&&(Je.innerHTML=ii),cn=s(e),g(ne.$$.fragment,e),mn=s(e),ke=r(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-2xd39c"&&(ke.textContent=si),un=s(e),Ce=r(e,"TABLE",{"data-svelte-h":!0}),c(Ce)!=="svelte-156aj54"&&(Ce.innerHTML=ai),hn=s(e),g(Ie.$$.fragment,e),gn=s(e),w=r(e,"DIV",{class:!0});var $=U(w);g(Ge.$$.fragment,$),kn=s($),vt=r($,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1neg3rw"&&(vt.textContent=ri),Cn=s($),yt=r($,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-k49fnk"&&(yt.innerHTML=li),In=s($),wt=r($,"UL",{"data-svelte-h":!0}),c(wt)!=="svelte-2a5chx"&&(wt.innerHTML=di),Gn=s($),xt=r($,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-wz8va1"&&(xt.textContent=pi),Wn=s($),$t=r($,"UL",{"data-svelte-h":!0}),c($t)!=="svelte-1ilr6sx"&&($t.innerHTML=fi),Vn=s($),oe=r($,"DIV",{class:!0});var ft=U(oe);g(We.$$.fragment,ft),Bn=s(ft),Mt=r(ft,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1eed40t"&&(Mt.textContent=ci),ft.forEach(p),Hn=s($),Tt=r($,"DIV",{class:!0});var fn=U(Tt);g(Ve.$$.fragment,fn),fn.forEach(p),Fn=s($),W=r($,"DIV",{class:!0});var B=U(W);g(Be.$$.fragment,B),Sn=s(B),Ut=r(B,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1vbhnip"&&(Ut.innerHTML=mi),Nn=s(B),g(ie.$$.fragment,B),Ln=s(B),Dt=r(B,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-5ul9n2"&&(Dt.innerHTML=ui),Xn=s(B),jt=r(B,"UL",{"data-svelte-h":!0}),c(jt)!=="svelte-1icy6l9"&&(jt.innerHTML=hi),B.forEach(p),En=s($),H=r($,"DIV",{class:!0});var X=U(H);g(He.$$.fragment,X),Rn=s(X),Pt=r(X,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-had4mb"&&(Pt.innerHTML=gi),zn=s(X),Zt=r(X,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-19k67ce"&&(Zt.innerHTML=bi),Yn=s(X),g(se.$$.fragment,X),X.forEach(p),Qn=s($),ae=r($,"DIV",{class:!0});var ct=U(ae);g(Fe.$$.fragment,ct),qn=s(ct),Jt=r(ct,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1lh0nh5"&&(Jt.innerHTML=_i),ct.forEach(p),An=s($),re=r($,"DIV",{class:!0});var mt=U(re);g(Se.$$.fragment,mt),On=s(mt),kt=r(mt,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-1vfte1e"&&(kt.innerHTML=vi),mt.forEach(p),Kn=s($),Y=r($,"DIV",{class:!0});var O=U(Y);g(Ne.$$.fragment,O),eo=s(O),Ct=r(O,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1mfctah"&&(Ct.textContent=yi),to=s(O),g(le.$$.fragment,O),O.forEach(p),no=s($),F=r($,"DIV",{class:!0});var E=U(F);g(Le.$$.fragment,E),oo=s(E),It=r(E,"P",{"data-svelte-h":!0}),c(It)!=="svelte-10jaql7"&&(It.textContent=wi),io=s(E),g(de.$$.fragment,E),so=s(E),g(pe.$$.fragment,E),E.forEach(p),ao=s($),fe=r($,"DIV",{class:!0});var ut=U(fe);g(Xe.$$.fragment,ut),ro=s(ut),Gt=r(ut,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-d7vywi"&&(Gt.innerHTML=xi),ut.forEach(p),lo=s($),ce=r($,"DIV",{class:!0});var ht=U(ce);g(Ee.$$.fragment,ht),po=s(ht),Wt=r(ht,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-n1oyuv"&&(Wt.innerHTML=$i),ht.forEach(p),fo=s($),S=r($,"DIV",{class:!0});var R=U(S);g(Re.$$.fragment,R),co=s(R),Vt=r(R,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-e03q3e"&&(Vt.innerHTML=Mi),mo=s(R),g(me.$$.fragment,R),uo=s(R),g(ue.$$.fragment,R),R.forEach(p),ho=s($),Q=r($,"DIV",{class:!0});var K=U(Q);g(ze.$$.fragment,K),go=s(K),Bt=r(K,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-1jx3icn"&&(Bt.textContent=Ti),bo=s(K),g(he.$$.fragment,K),K.forEach(p),_o=s($),k=r($,"DIV",{class:!0});var G=U(k);g(Ye.$$.fragment,G),vo=s(G),Ht=r(G,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-ccbjek"&&(Ht.textContent=Ui),yo=s(G),Ft=r(G,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1p5vgmd"&&(Ft.innerHTML=Di),wo=s(G),g(ge.$$.fragment,G),xo=s(G),g(be.$$.fragment,G),$o=s(G),g(_e.$$.fragment,G),G.forEach(p),Mo=s($),ve=r($,"DIV",{class:!0});var gt=U(ve);g(Qe.$$.fragment,gt),To=s(gt),St=r(gt,"P",{"data-svelte-h":!0}),c(St)!=="svelte-zkab0b"&&(St.innerHTML=ji),gt.forEach(p),Uo=s($),ye=r($,"DIV",{class:!0});var bt=U(ye);g(qe.$$.fragment,bt),Do=s(bt),Nt=r(bt,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1gut907"&&(Nt.textContent=Pi),bt.forEach(p),jo=s($),we=r($,"DIV",{class:!0});var Un=U(we);g(Ae.$$.fragment,Un),Po=s(Un),Lt=r(Un,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-8kophh"&&(Lt.innerHTML=Zi),Un.forEach(p),Zo=s($),xe=r($,"DIV",{class:!0});var Dn=U(xe);g(Oe.$$.fragment,Dn),Jo=s(Dn),Xt=r(Dn,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-6tjysh"&&(Xt.textContent=Ji),Dn.forEach(p),ko=s($),$e=r($,"DIV",{class:!0});var jn=U($e);g(Ke.$$.fragment,jn),Co=s(jn),Et=r(jn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-fyjfpe"&&(Et.innerHTML=ki),jn.forEach(p),$.forEach(p),bn=s(e),V=r(e,"DIV",{class:!0});var Ze=U(V);g(et.$$.fragment,Ze),Io=s(Ze),Rt=r(Ze,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-1f3tmq1"&&(Rt.innerHTML=Ci),Go=s(Ze),zt=r(Ze,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-xjijlp"&&(zt.textContent=Ii),Wo=s(Ze),Yt=r(Ze,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-hy0nzs"&&(Yt.innerHTML=Gi),Ze.forEach(p),_n=s(e),A=r(e,"DIV",{class:!0});var Pn=U(A);g(tt.$$.fragment,Pn),Vo=s(Pn),Qt=r(Pn,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-psupw6"&&(Qt.textContent=Wi),Pn.forEach(p),vn=s(e),g(nt.$$.fragment,e),yn=s(e),P=r(e,"DIV",{class:!0});var Z=U(P);g(ot.$$.fragment,Z),Bo=s(Z),qt=r(Z,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-1o1wti6"&&(qt.textContent=Vi),Ho=s(Z),At=r(Z,"P",{"data-svelte-h":!0}),c(At)!=="svelte-1pkfdqg"&&(At.innerHTML=Bi),Fo=s(Z),Ot=r(Z,"UL",{"data-svelte-h":!0}),c(Ot)!=="svelte-1kk3msp"&&(Ot.innerHTML=Hi),So=s(Z),Kt=r(Z,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-wz8va1"&&(Kt.textContent=Fi),No=s(Z),en=r(Z,"UL",{"data-svelte-h":!0}),c(en)!=="svelte-56flce"&&(en.innerHTML=Si),Lo=s(Z),C=r(Z,"DIV",{class:!0});var N=U(C);g(it.$$.fragment,N),Xo=s(N),tn=r(N,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-7z61o"&&(tn.textContent=Ni),Eo=s(N),nn=r(N,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-wyh2cr"&&(nn.textContent=Li),Ro=s(N),g(Me.$$.fragment,N),zo=s(N),g(Te.$$.fragment,N),Yo=s(N),g(Ue.$$.fragment,N),N.forEach(p),Qo=s(Z),De=r(Z,"DIV",{class:!0});var Zn=U(De);g(st.$$.fragment,Zn),qo=s(Zn),on=r(Zn,"P",{"data-svelte-h":!0}),c(on)!=="svelte-1gut907"&&(on.textContent=Xi),Zn.forEach(p),Ao=s(Z),je=r(Z,"DIV",{class:!0});var Jn=U(je);g(at.$$.fragment,Jn),Oo=s(Jn),sn=r(Jn,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-wblbv"&&(sn.innerHTML=Ei),Jn.forEach(p),Z.forEach(p),wn=s(e),rt=r(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-12a2n2m"&&(rt.textContent=Ri),xn=s(e),L=r(e,"DIV",{class:!0});var ln=U(L);g(lt.$$.fragment,ln),Ko=s(ln),an=r(ln,"P",{"data-svelte-h":!0}),c(an)!=="svelte-7y8zei"&&(an.textContent=zi),ei=s(ln),q=r(ln,"DIV",{class:!0});var dn=U(q);g(dt.$$.fragment,dn),ti=s(dn),rn=r(dn,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-5nfhmh"&&(rn.textContent=Yi),ni=s(dn),g(Pe.$$.fragment,dn),dn.forEach(p),ln.forEach(p),$n=s(e),g(pt.$$.fragment,e),Mn=s(e),pn=r(e,"P",{}),U(pn).forEach(p),this.h()},h(){D(o,"name","hf:doc:metadata"),D(o,"content",_s),D(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){n(document.head,o),m(e,x,f),m(e,d,f),m(e,l,f),b(u,e,f),m(e,t,f),m(e,M,f),m(e,z,f),m(e,Je,f),m(e,cn,f),b(ne,e,f),m(e,mn,f),m(e,ke,f),m(e,un,f),m(e,Ce,f),m(e,hn,f),b(Ie,e,f),m(e,gn,f),m(e,w,f),b(Ge,w,null),n(w,kn),n(w,vt),n(w,Cn),n(w,yt),n(w,In),n(w,wt),n(w,Gn),n(w,xt),n(w,Wn),n(w,$t),n(w,Vn),n(w,oe),b(We,oe,null),n(oe,Bn),n(oe,Mt),n(w,Hn),n(w,Tt),b(Ve,Tt,null),n(w,Fn),n(w,W),b(Be,W,null),n(W,Sn),n(W,Ut),n(W,Nn),b(ie,W,null),n(W,Ln),n(W,Dt),n(W,Xn),n(W,jt),n(w,En),n(w,H),b(He,H,null),n(H,Rn),n(H,Pt),n(H,zn),n(H,Zt),n(H,Yn),b(se,H,null),n(w,Qn),n(w,ae),b(Fe,ae,null),n(ae,qn),n(ae,Jt),n(w,An),n(w,re),b(Se,re,null),n(re,On),n(re,kt),n(w,Kn),n(w,Y),b(Ne,Y,null),n(Y,eo),n(Y,Ct),n(Y,to),b(le,Y,null),n(w,no),n(w,F),b(Le,F,null),n(F,oo),n(F,It),n(F,io),b(de,F,null),n(F,so),b(pe,F,null),n(w,ao),n(w,fe),b(Xe,fe,null),n(fe,ro),n(fe,Gt),n(w,lo),n(w,ce),b(Ee,ce,null),n(ce,po),n(ce,Wt),n(w,fo),n(w,S),b(Re,S,null),n(S,co),n(S,Vt),n(S,mo),b(me,S,null),n(S,uo),b(ue,S,null),n(w,ho),n(w,Q),b(ze,Q,null),n(Q,go),n(Q,Bt),n(Q,bo),b(he,Q,null),n(w,_o),n(w,k),b(Ye,k,null),n(k,vo),n(k,Ht),n(k,yo),n(k,Ft),n(k,wo),b(ge,k,null),n(k,xo),b(be,k,null),n(k,$o),b(_e,k,null),n(w,Mo),n(w,ve),b(Qe,ve,null),n(ve,To),n(ve,St),n(w,Uo),n(w,ye),b(qe,ye,null),n(ye,Do),n(ye,Nt),n(w,jo),n(w,we),b(Ae,we,null),n(we,Po),n(we,Lt),n(w,Zo),n(w,xe),b(Oe,xe,null),n(xe,Jo),n(xe,Xt),n(w,ko),n(w,$e),b(Ke,$e,null),n($e,Co),n($e,Et),m(e,bn,f),m(e,V,f),b(et,V,null),n(V,Io),n(V,Rt),n(V,Go),n(V,zt),n(V,Wo),n(V,Yt),m(e,_n,f),m(e,A,f),b(tt,A,null),n(A,Vo),n(A,Qt),m(e,vn,f),b(nt,e,f),m(e,yn,f),m(e,P,f),b(ot,P,null),n(P,Bo),n(P,qt),n(P,Ho),n(P,At),n(P,Fo),n(P,Ot),n(P,So),n(P,Kt),n(P,No),n(P,en),n(P,Lo),n(P,C),b(it,C,null),n(C,Xo),n(C,tn),n(C,Eo),n(C,nn),n(C,Ro),b(Me,C,null),n(C,zo),b(Te,C,null),n(C,Yo),b(Ue,C,null),n(P,Qo),n(P,De),b(st,De,null),n(De,qo),n(De,on),n(P,Ao),n(P,je),b(at,je,null),n(je,Oo),n(je,sn),m(e,wn,f),m(e,rt,f),m(e,xn,f),m(e,L,f),b(lt,L,null),n(L,Ko),n(L,an),n(L,ei),n(L,q),b(dt,q,null),n(q,ti),n(q,rn),n(q,ni),b(Pe,q,null),m(e,$n,f),b(pt,e,f),m(e,Mn,f),m(e,pn,f),Tn=!0},p(e,[f]){const $={};f&2&&($.$$scope={dirty:f,ctx:e}),ne.$set($);const ft={};f&2&&(ft.$$scope={dirty:f,ctx:e}),ie.$set(ft);const fn={};f&2&&(fn.$$scope={dirty:f,ctx:e}),se.$set(fn);const B={};f&2&&(B.$$scope={dirty:f,ctx:e}),le.$set(B);const X={};f&2&&(X.$$scope={dirty:f,ctx:e}),de.$set(X);const ct={};f&2&&(ct.$$scope={dirty:f,ctx:e}),pe.$set(ct);const mt={};f&2&&(mt.$$scope={dirty:f,ctx:e}),me.$set(mt);const O={};f&2&&(O.$$scope={dirty:f,ctx:e}),ue.$set(O);const E={};f&2&&(E.$$scope={dirty:f,ctx:e}),he.$set(E);const ut={};f&2&&(ut.$$scope={dirty:f,ctx:e}),ge.$set(ut);const ht={};f&2&&(ht.$$scope={dirty:f,ctx:e}),be.$set(ht);const R={};f&2&&(R.$$scope={dirty:f,ctx:e}),_e.$set(R);const K={};f&2&&(K.$$scope={dirty:f,ctx:e}),Me.$set(K);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),Te.$set(G);const gt={};f&2&&(gt.$$scope={dirty:f,ctx:e}),Ue.$set(gt);const bt={};f&2&&(bt.$$scope={dirty:f,ctx:e}),Pe.$set(bt)},i(e){Tn||(_(u.$$.fragment,e),_(ne.$$.fragment,e),_(Ie.$$.fragment,e),_(Ge.$$.fragment,e),_(We.$$.fragment,e),_(Ve.$$.fragment,e),_(Be.$$.fragment,e),_(ie.$$.fragment,e),_(He.$$.fragment,e),_(se.$$.fragment,e),_(Fe.$$.fragment,e),_(Se.$$.fragment,e),_(Ne.$$.fragment,e),_(le.$$.fragment,e),_(Le.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(Re.$$.fragment,e),_(me.$$.fragment,e),_(ue.$$.fragment,e),_(ze.$$.fragment,e),_(he.$$.fragment,e),_(Ye.$$.fragment,e),_(ge.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(Qe.$$.fragment,e),_(qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(Ue.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(Pe.$$.fragment,e),_(pt.$$.fragment,e),Tn=!0)},o(e){v(u.$$.fragment,e),v(ne.$$.fragment,e),v(Ie.$$.fragment,e),v(Ge.$$.fragment,e),v(We.$$.fragment,e),v(Ve.$$.fragment,e),v(Be.$$.fragment,e),v(ie.$$.fragment,e),v(He.$$.fragment,e),v(se.$$.fragment,e),v(Fe.$$.fragment,e),v(Se.$$.fragment,e),v(Ne.$$.fragment,e),v(le.$$.fragment,e),v(Le.$$.fragment,e),v(de.$$.fragment,e),v(pe.$$.fragment,e),v(Xe.$$.fragment,e),v(Ee.$$.fragment,e),v(Re.$$.fragment,e),v(me.$$.fragment,e),v(ue.$$.fragment,e),v(ze.$$.fragment,e),v(he.$$.fragment,e),v(Ye.$$.fragment,e),v(ge.$$.fragment,e),v(be.$$.fragment,e),v(_e.$$.fragment,e),v(Qe.$$.fragment,e),v(qe.$$.fragment,e),v(Ae.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(nt.$$.fragment,e),v(ot.$$.fragment,e),v(it.$$.fragment,e),v(Me.$$.fragment,e),v(Te.$$.fragment,e),v(Ue.$$.fragment,e),v(st.$$.fragment,e),v(at.$$.fragment,e),v(lt.$$.fragment,e),v(dt.$$.fragment,e),v(Pe.$$.fragment,e),v(pt.$$.fragment,e),Tn=!1},d(e){e&&(p(x),p(d),p(l),p(t),p(M),p(z),p(Je),p(cn),p(mn),p(ke),p(un),p(Ce),p(hn),p(gn),p(w),p(bn),p(V),p(_n),p(A),p(vn),p(yn),p(P),p(wn),p(rt),p(xn),p(L),p($n),p(Mn),p(pn)),p(o),y(u,e),y(ne,e),y(Ie,e),y(Ge),y(We),y(Ve),y(Be),y(ie),y(He),y(se),y(Fe),y(Se),y(Ne),y(le),y(Le),y(de),y(pe),y(Xe),y(Ee),y(Re),y(me),y(ue),y(ze),y(he),y(Ye),y(ge),y(be),y(_e),y(Qe),y(qe),y(Ae),y(Oe),y(Ke),y(et),y(tt),y(nt,e),y(ot),y(it),y(Me),y(Te),y(Ue),y(st),y(at),y(lt),y(dt),y(Pe),y(pt,e)}}}const _s='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2}],"depth":1}';function vs(T){return qi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ai{constructor(o){super(),Oi(this,o,vs,bs,Qi,{})}}export{Ds as component};
