import{s as Nt,o as Ht,n as Ue}from"../chunks/scheduler.c57aa7ef.js";import{S as qt,i as Lt,g as w,s as o,r as M,A as St,h as T,f as a,c as r,j as Et,u as d,x as b,k as wt,y as Dt,a as l,v as f,d as y,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Tt}from"../chunks/Tip.9268b0ca.js";import{C as j}from"../chunks/CodeBlock.34f0a53d.js";import{H as Te,E as Pt}from"../chunks/EditOnGithub.958a8a49.js";import{H as Kt,a as Jt}from"../chunks/HfOption.189bbdfa.js";function Ot($){let s,U='Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){s=w("p"),s.innerHTML=U},l(i){s=T(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-122rdqq"&&(s.innerHTML=U)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function ea($){let s,U='Call the <a href="/docs/peft/pr_1664/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/pr_1664/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){s=w("p"),s.innerHTML=U},l(i){s=T(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1ldmh6b"&&(s.innerHTML=U)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function ta($){let s,U='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1664/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=U,i=o(),M(p.$$.fragment)},l(n){s=T(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-7iovso"&&(s.innerHTML=U),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function aa($){let s,U='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1664/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=U,i=o(),M(p.$$.fragment)},l(n){s=T(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-y2al4d"&&(s.innerHTML=U),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function la($){let s,U='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1664/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=U,i=o(),M(p.$$.fragment)},l(n){s=T(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1sptnfa"&&(s.innerHTML=U),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function sa($){let s,U='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1664/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=U,i=o(),M(p.$$.fragment)},l(n){s=T(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1x6mbgg"&&(s.innerHTML=U),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function na($){let s,U,i,p,c,n,J,B;return s=new Jt({props:{id:"loras",option:"LoRA",$$slots:{default:[ta]},$$scope:{ctx:$}}}),i=new Jt({props:{id:"loras",option:"LoHa",$$slots:{default:[aa]},$$scope:{ctx:$}}}),c=new Jt({props:{id:"loras",option:"LoKr",$$slots:{default:[la]},$$scope:{ctx:$}}}),J=new Jt({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[sa]},$$scope:{ctx:$}}}),{c(){M(s.$$.fragment),U=o(),M(i.$$.fragment),p=o(),M(c.$$.fragment),n=o(),M(J.$$.fragment)},l(m){d(s.$$.fragment,m),U=r(m),d(i.$$.fragment,m),p=r(m),d(c.$$.fragment,m),n=r(m),d(J.$$.fragment,m)},m(m,g){f(s,m,g),l(m,U,g),f(i,m,g),l(m,p,g),f(c,m,g),l(m,n,g),f(J,m,g),B=!0},p(m,g){const be={};g&2&&(be.$$scope={dirty:g,ctx:m}),s.$set(be);const v={};g&2&&(v.$$scope={dirty:g,ctx:m}),i.$set(v);const C={};g&2&&(C.$$scope={dirty:g,ctx:m}),c.$set(C);const ge={};g&2&&(ge.$$scope={dirty:g,ctx:m}),J.$set(ge)},i(m){B||(y(s.$$.fragment,m),y(i.$$.fragment,m),y(c.$$.fragment,m),y(J.$$.fragment,m),B=!0)},o(m){h(s.$$.fragment,m),h(i.$$.fragment,m),h(c.$$.fragment,m),h(J.$$.fragment,m),B=!1},d(m){m&&(a(U),a(p),a(n)),u(s,m),u(i,m),u(c,m),u(J,m)}}}function oa($){let s,U='AdaLoRA has an <a href="/docs/peft/pr_1664/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.';return{c(){s=w("p"),s.innerHTML=U},l(i){s=T(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-150zfiy"&&(s.innerHTML=U)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function ra($){let s,U,i,p,c,n,J,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",m,g,be='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,C,ge='Additionally, PEFT supports the <a href="../conceptual_guides/adapter#mixture-of-lora-experts-x-lora">X-LoRA</a> Mixture of LoRA Experts method.',$e,Q,Ut="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",Ce,_,_e,R,bt="Before you begin, make sure you have all the necessary libraries installed.",Ze,G,Ie,F,ke,X,gt='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',We,Y,jt='Load the dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',Be,A,ve,z,$t="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Qe,V,Re,x,Ct="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Ge,E,Fe,N,_t="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Xe,H,Ye,q,Zt='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Ae,L,ze,S,It="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ve,D,xe,P,Ee,K,kt='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ne,O,He,ee,qe,te,Wt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/pr_1664/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/pr_1664/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Le,Z,Se,I,De,ae,Pe,le,Bt='For training, let’s use the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',Ke,k,Oe,se,et,ne,vt='Begin training with <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',tt,oe,at,re,lt,ie,Qt='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',st,pe,nt,me,Rt='Call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',ot,ce,rt,Me,it,de,Gt="Let’s load the model from the Hub and test it out on a food image.",pt,fe,mt,W,Ft='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',ct,ye,Xt="Convert the image to RGB and return the underlying PyTorch tensors.",Mt,he,dt,ue,Yt="Now run the model and return the predicted class!",ft,Je,yt,we,ht,je,ut;return c=new Te({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),_=new Tt({props:{$$slots:{default:[Ot]},$$scope:{ctx:$}}}),G=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),F=new Te({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),V=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),L=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),P=new Te({props:{title:"Model",local:"model",headingTag:"h2"}}),O=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ee=new Te({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),Z=new Tt({props:{$$slots:{default:[ea]},$$scope:{ctx:$}}}),I=new Kt({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[na]},$$scope:{ctx:$}}}),ae=new Te({props:{title:"Training",local:"training",headingTag:"h3"}}),k=new Tt({props:{warning:!0,$$slots:{default:[oa]},$$scope:{ctx:$}}}),se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),oe=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    tokenizer=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),re=new Te({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),pe=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ce=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),Me=new Te({props:{title:"Inference",local:"inference",headingTag:"h2"}}),fe=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGYmVpZ25ldHMuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),he=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Je=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),we=new Pt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){s=w("meta"),U=o(),i=w("p"),p=o(),M(c.$$.fragment),n=o(),J=w("p"),J.textContent=B,m=o(),g=w("p"),g.innerHTML=be,v=o(),C=w("p"),C.innerHTML=ge,$e=o(),Q=w("p"),Q.textContent=Ut,Ce=o(),M(_.$$.fragment),_e=o(),R=w("p"),R.textContent=bt,Ze=o(),M(G.$$.fragment),Ie=o(),M(F.$$.fragment),ke=o(),X=w("p"),X.innerHTML=gt,We=o(),Y=w("p"),Y.innerHTML=jt,Be=o(),M(A.$$.fragment),ve=o(),z=w("p"),z.innerHTML=$t,Qe=o(),M(V.$$.fragment),Re=o(),x=w("p"),x.textContent=Ct,Ge=o(),M(E.$$.fragment),Fe=o(),N=w("p"),N.textContent=_t,Xe=o(),M(H.$$.fragment),Ye=o(),q=w("p"),q.innerHTML=Zt,Ae=o(),M(L.$$.fragment),ze=o(),S=w("p"),S.innerHTML=It,Ve=o(),M(D.$$.fragment),xe=o(),M(P.$$.fragment),Ee=o(),K=w("p"),K.innerHTML=kt,Ne=o(),M(O.$$.fragment),He=o(),M(ee.$$.fragment),qe=o(),te=w("p"),te.innerHTML=Wt,Le=o(),M(Z.$$.fragment),Se=o(),M(I.$$.fragment),De=o(),M(ae.$$.fragment),Pe=o(),le=w("p"),le.innerHTML=Bt,Ke=o(),M(k.$$.fragment),Oe=o(),M(se.$$.fragment),et=o(),ne=w("p"),ne.innerHTML=vt,tt=o(),M(oe.$$.fragment),at=o(),M(re.$$.fragment),lt=o(),ie=w("p"),ie.innerHTML=Qt,st=o(),M(pe.$$.fragment),nt=o(),me=w("p"),me.innerHTML=Rt,ot=o(),M(ce.$$.fragment),rt=o(),M(Me.$$.fragment),it=o(),de=w("p"),de.textContent=Gt,pt=o(),M(fe.$$.fragment),mt=o(),W=w("div"),W.innerHTML=Ft,ct=o(),ye=w("p"),ye.textContent=Xt,Mt=o(),M(he.$$.fragment),dt=o(),ue=w("p"),ue.textContent=Yt,ft=o(),M(Je.$$.fragment),yt=o(),M(we.$$.fragment),ht=o(),je=w("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);s=T(t,"META",{name:!0,content:!0}),t.forEach(a),U=r(e),i=T(e,"P",{}),Et(i).forEach(a),p=r(e),d(c.$$.fragment,e),n=r(e),J=T(e,"P",{"data-svelte-h":!0}),b(J)!=="svelte-3c4mx2"&&(J.textContent=B),m=r(e),g=T(e,"P",{"data-svelte-h":!0}),b(g)!=="svelte-1mec8a1"&&(g.innerHTML=be),v=r(e),C=T(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-wawyyc"&&(C.innerHTML=ge),$e=r(e),Q=T(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-3yvnz9"&&(Q.textContent=Ut),Ce=r(e),d(_.$$.fragment,e),_e=r(e),R=T(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-1rdzhb1"&&(R.textContent=bt),Ze=r(e),d(G.$$.fragment,e),Ie=r(e),d(F.$$.fragment,e),ke=r(e),X=T(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-l33v6t"&&(X.innerHTML=gt),We=r(e),Y=T(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-zwwqy7"&&(Y.innerHTML=jt),Be=r(e),d(A.$$.fragment,e),ve=r(e),z=T(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1a5q7dy"&&(z.innerHTML=$t),Qe=r(e),d(V.$$.fragment,e),Re=r(e),x=T(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-13cytaa"&&(x.textContent=Ct),Ge=r(e),d(E.$$.fragment,e),Fe=r(e),N=T(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1p1x6w4"&&(N.textContent=_t),Xe=r(e),d(H.$$.fragment,e),Ye=r(e),q=T(e,"P",{"data-svelte-h":!0}),b(q)!=="svelte-xbqbtr"&&(q.innerHTML=Zt),Ae=r(e),d(L.$$.fragment,e),ze=r(e),S=T(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-mznco7"&&(S.innerHTML=It),Ve=r(e),d(D.$$.fragment,e),xe=r(e),d(P.$$.fragment,e),Ee=r(e),K=T(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-akpunr"&&(K.innerHTML=kt),Ne=r(e),d(O.$$.fragment,e),He=r(e),d(ee.$$.fragment,e),qe=r(e),te=T(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-144sqqc"&&(te.innerHTML=Wt),Le=r(e),d(Z.$$.fragment,e),Se=r(e),d(I.$$.fragment,e),De=r(e),d(ae.$$.fragment,e),Pe=r(e),le=T(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-wcjxic"&&(le.innerHTML=Bt),Ke=r(e),d(k.$$.fragment,e),Oe=r(e),d(se.$$.fragment,e),et=r(e),ne=T(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-ntqszh"&&(ne.innerHTML=vt),tt=r(e),d(oe.$$.fragment,e),at=r(e),d(re.$$.fragment,e),lt=r(e),ie=T(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-vaxac6"&&(ie.innerHTML=Qt),st=r(e),d(pe.$$.fragment,e),nt=r(e),me=T(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-1qc4exu"&&(me.innerHTML=Rt),ot=r(e),d(ce.$$.fragment,e),rt=r(e),d(Me.$$.fragment,e),it=r(e),de=T(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1whrqzq"&&(de.textContent=Gt),pt=r(e),d(fe.$$.fragment,e),mt=r(e),W=T(e,"DIV",{class:!0,"data-svelte-h":!0}),b(W)!=="svelte-sucph9"&&(W.innerHTML=Ft),ct=r(e),ye=T(e,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-1nlb27h"&&(ye.textContent=Xt),Mt=r(e),d(he.$$.fragment,e),dt=r(e),ue=T(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1mvhoi"&&(ue.textContent=Yt),ft=r(e),d(Je.$$.fragment,e),yt=r(e),d(we.$$.fragment,e),ht=r(e),je=T(e,"P",{}),Et(je).forEach(a),this.h()},h(){wt(s,"name","hf:doc:metadata"),wt(s,"content",ia),wt(W,"class","flex justify-center")},m(e,t){Dt(document.head,s),l(e,U,t),l(e,i,t),l(e,p,t),f(c,e,t),l(e,n,t),l(e,J,t),l(e,m,t),l(e,g,t),l(e,v,t),l(e,C,t),l(e,$e,t),l(e,Q,t),l(e,Ce,t),f(_,e,t),l(e,_e,t),l(e,R,t),l(e,Ze,t),f(G,e,t),l(e,Ie,t),f(F,e,t),l(e,ke,t),l(e,X,t),l(e,We,t),l(e,Y,t),l(e,Be,t),f(A,e,t),l(e,ve,t),l(e,z,t),l(e,Qe,t),f(V,e,t),l(e,Re,t),l(e,x,t),l(e,Ge,t),f(E,e,t),l(e,Fe,t),l(e,N,t),l(e,Xe,t),f(H,e,t),l(e,Ye,t),l(e,q,t),l(e,Ae,t),f(L,e,t),l(e,ze,t),l(e,S,t),l(e,Ve,t),f(D,e,t),l(e,xe,t),f(P,e,t),l(e,Ee,t),l(e,K,t),l(e,Ne,t),f(O,e,t),l(e,He,t),f(ee,e,t),l(e,qe,t),l(e,te,t),l(e,Le,t),f(Z,e,t),l(e,Se,t),f(I,e,t),l(e,De,t),f(ae,e,t),l(e,Pe,t),l(e,le,t),l(e,Ke,t),f(k,e,t),l(e,Oe,t),f(se,e,t),l(e,et,t),l(e,ne,t),l(e,tt,t),f(oe,e,t),l(e,at,t),f(re,e,t),l(e,lt,t),l(e,ie,t),l(e,st,t),f(pe,e,t),l(e,nt,t),l(e,me,t),l(e,ot,t),f(ce,e,t),l(e,rt,t),f(Me,e,t),l(e,it,t),l(e,de,t),l(e,pt,t),f(fe,e,t),l(e,mt,t),l(e,W,t),l(e,ct,t),l(e,ye,t),l(e,Mt,t),f(he,e,t),l(e,dt,t),l(e,ue,t),l(e,ft,t),f(Je,e,t),l(e,yt,t),f(we,e,t),l(e,ht,t),l(e,je,t),ut=!0},p(e,[t]){const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),_.$set(At);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),Z.$set(zt);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),I.$set(Vt);const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),k.$set(xt)},i(e){ut||(y(c.$$.fragment,e),y(_.$$.fragment,e),y(G.$$.fragment,e),y(F.$$.fragment,e),y(A.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(ae.$$.fragment,e),y(k.$$.fragment,e),y(se.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(Me.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(we.$$.fragment,e),ut=!0)},o(e){h(c.$$.fragment,e),h(_.$$.fragment,e),h(G.$$.fragment,e),h(F.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(ae.$$.fragment,e),h(k.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(Je.$$.fragment,e),h(we.$$.fragment,e),ut=!1},d(e){e&&(a(U),a(i),a(p),a(n),a(J),a(m),a(g),a(v),a(C),a($e),a(Q),a(Ce),a(_e),a(R),a(Ze),a(Ie),a(ke),a(X),a(We),a(Y),a(Be),a(ve),a(z),a(Qe),a(Re),a(x),a(Ge),a(Fe),a(N),a(Xe),a(Ye),a(q),a(Ae),a(ze),a(S),a(Ve),a(xe),a(Ee),a(K),a(Ne),a(He),a(qe),a(te),a(Le),a(Se),a(De),a(Pe),a(le),a(Ke),a(Oe),a(et),a(ne),a(tt),a(at),a(lt),a(ie),a(st),a(nt),a(me),a(ot),a(rt),a(it),a(de),a(pt),a(mt),a(W),a(ct),a(ye),a(Mt),a(dt),a(ue),a(ft),a(yt),a(ht),a(je)),a(s),u(c,e),u(_,e),u(G,e),u(F,e),u(A,e),u(V,e),u(E,e),u(H,e),u(L,e),u(D,e),u(P,e),u(O,e),u(ee,e),u(Z,e),u(I,e),u(ae,e),u(k,e),u(se,e),u(oe,e),u(re,e),u(pe,e),u(ce,e),u(Me,e),u(fe,e),u(he,e),u(Je,e),u(we,e)}}}const ia='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function pa($){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ha extends qt{constructor(s){super(),Lt(this,s,pa,ra,Nt,{})}}export{ha as component};
