import{s as wt,n as ft,o as Jt}from"../chunks/scheduler.7bc62968.js";import{S as Ut,i as It,g as p,s as a,r as c,A as bt,h as i,f as t,c as n,j as yt,u as r,x as o,k as j,y as kt,a as l,v as h,d as u,t as M,w as d}from"../chunks/index.66556066.js";import{H as g,g as $t}from"../chunks/Heading.8f17e89c.js";import{C as m}from"../chunks/CodeBlock.a759539a.js";function Ct(Se){let T,$s,bs,Cs,B,Bs,R,Le='In the following sections, you’ll learn the basics of creating a Docker Space, configuring it, and deploying your code to it. We’ll create a <strong>Text Generation</strong> Space with Docker that’ll be used to demo the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model, which can generate text given some input text, using FastAPI as the server.',Rs,v,Ae='You can find a completed version of this hosted <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">here</a>.',vs,Z,Zs,E,xe='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Docker</strong> as our SDK.',Es,y,Ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface.co_new-space_docker.jpg"/>',Vs,V,Qe='Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing. If you prefer to work with a UI, you can also do the work directly in the browser.',Hs,H,_e='Selecting <strong>Docker</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Docker Space by setting the <code>sdk</code> property to <code>docker</code> in your <code>README.md</code> file’s YAML block.',Ss,S,Ls,L,Xe="You have the option to change the default application port of your Space by setting the <code>app_port</code> property in your <code>README.md</code> file’s YAML block. The default port is <code>7860</code>.",As,A,xs,x,Gs,G,We='For the <strong>Text Generation</strong> Space, we’ll be building a FastAPI app that showcases a text generation model called Flan T5. For the model inference, we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model. We need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',Qs,Q,_s,_,Ne="These dependencies will be installed in the Dockerfile we’ll create later.",Xs,X,Ws,W,Fe="Let’s kick off the process with a dummy FastAPI app to see that we can get an endpoint working. The first step is to create an app file, in this case, we’ll call it <code>main.py</code>.",Ns,N,Fs,F,qs,q,qe='The main step for a Docker Space is creating a Dockerfile. You can read more about Dockerfiles <a href="https://docs.docker.com/get-started/" rel="nofollow">here</a>. Although we’re using FastAPI in this tutorial, Dockerfiles give great flexibility to users allowing you to build a new generation of ML demos. Let’s write the Dockerfile for our application',Ys,Y,zs,z,Ye='When the changes are saved, the Space will rebuild and your demo should be up after a couple of seconds! <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_dummy" rel="nofollow">Here</a> is an example result at this point.',Ds,w,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_dummy.jpg"/>',Ps,D,Os,P,De="<strong>Tip for power users (you can skip):</strong> If you’re developing locally, this is a good moment in which you can do <code>docker build</code> and <code>docker run</code> to debug locally, but it’s even easier to push the changes to the Hub and see how it looks like!",Ks,O,se,K,Pe='If you have <a href="spaces-sdks-docker#secret-management">Secrets</a> you can use <code>docker buildx</code> and pass the secrets as build arguments',ee,ss,te,es,Oe="and run with <code>docker run</code> passing the secrets as environment variables",le,ts,ae,ls,ne,as,Ke="As mentioned before, the idea is to use a Flan T5 model for text generation. We’ll want to add some HTML and CSS for an input field, so let’s create a directory called static with <code>index.html</code>, <code>style.css</code>, and <code>script.js</code> files. At this moment, your file structure should look like this:",pe,ns,ie,ps,st='Let’s go through all the steps to make this working. We’ll skip some of the details of the CSS and HTML. You can find the whole code in the Files and versions tab of the <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> Space.',oe,is,et="<li>Write the FastAPI endpoint to do inference</li>",ce,os,tt='We’ll use the <code>pipeline</code> from <code>transformers</code> to load the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model. We’ll set an endpoint called <code>infer_t5</code> that receives and input and outputs the result of the inference call',re,cs,he,f,lt="<li>Write the <code>index.html</code> to have a simple form containing the code of the page.</li>",ue,rs,Me,J,at="<li>In the <code>app.py</code> file, mount the static files and show the html file in the root route</li>",de,hs,me,U,nt="<li>In the <code>script.js</code> file, make it handle the request</li>",je,us,Te,I,pt="<li>Grant permissions to the right directories</li>",ge,Ms,it='As discussed in the <a href="./spaces-sdks-docker#permissions">Permissions Section</a>, the container runs with user ID 1000. That means that the Space might face permission issues. For example, <code>transformers</code> downloads and caches the models in the path under the <code>HUGGINGFACE_HUB_CACHE</code> path. The easiest way to solve this is to create a user with righ permissions and use it to run the container application. We can do this by adding the following lines to the <code>Dockerfile</code>.',ye,ds,we,ms,ot="The final <code>Dockerfile</code> should look like this:",fe,js,Je,Ts,ct='Success! Your app should be working now! Check out <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> to see the final result.',Ue,b,rt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5.jpg"/>',Ie,gs,ht='What a journey! Please remember that Docker Spaces give you lots of freedom, so you’re not limited to use FastAPI. From a <a href="https://huggingface.co/spaces/DockerTemplates/test-docker-go" rel="nofollow">Go Endpoint</a> to a <a href="https://huggingface.co/spaces/DockerTemplates/shiny-with-python" rel="nofollow">Shiny App</a>, the limit is the moon! Check out <a href="./spaces-sdks-docker-examples">some official examples</a>. You can also upgrade your Space to a GPU if needed 😃',be,ys,ke,ws,ut="You can debug your Space by checking the <strong>Build</strong> and <strong>Container</strong> logs. Click on the <strong>Open Logs</strong> button to open the modal.",$e,k,Mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_3.jpg"/>',Ce,fs,dt="If everything went well, you will see <code>Pushing Image</code> and <code>Scheduling Space</code> on the <strong>Build</strong> tab",Be,$,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_1.jpg"/>',Re,Js,jt="On the <strong>Container</strong> tab, you will see the application status, in this case, <code>Uvicorn running on http://0.0.0.0:7860</code>",ve,C,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_2.jpg"/>',Ze,Us,Ee,Is,gt='<li><a href="spaces-sdks-docker">Docker Spaces</a></li> <li><a href="spaces-sdks-docker-examples">List of Docker Spaces examples</a></li>',Ve,ks,He;return B=new g({props:{title:"Your First Docker Space: Text Generation with T5",local:"your-first-docker-space-text-generation-with-t5",headingTag:"h1"}}),Z=new g({props:{title:"Create a new Docker Space",local:"create-a-new-docker-space",headingTag:"h2"}}),S=new m({props:{code:"c2RrJTNBJTIwZG9ja2Vy",highlighted:'<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>',wrap:!1}}),A=new m({props:{code:"YXBwX3BvcnQlM0ElMjA3ODYw",highlighted:'<span class="hljs-attr">app_port:</span> <span class="hljs-number">7860</span>',wrap:!1}}),x=new g({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),Q=new m({props:{code:"ZmFzdGFwaSUzRCUzRDAuNzQuKiUwQXJlcXVlc3RzJTNEJTNEMi4yNy4qJTBBc2VudGVuY2VwaWVjZSUzRCUzRDAuMS4qJTBBdG9yY2glM0QlM0QxLjExLiolMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LiolMEF1dmljb3JuJTVCc3RhbmRhcmQlNUQlM0QlM0QwLjE3Lio=",highlighted:`<span class="hljs-attribute">fastapi</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.74</span>.*
<span class="hljs-attribute">requests</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">2.27</span>.*
<span class="hljs-attribute">sentencepiece</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.1</span>.*
<span class="hljs-attribute">torch</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">1.11</span>.*
<span class="hljs-attribute">transformers</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">4</span>.*
uvicorn[standard]<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.17</span>.*`,wrap:!1}}),X=new g({props:{title:"Create the app",local:"create-the-app",headingTag:"h2"}}),N=new m({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwcmVhZF9yb290KCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJIZWxsbyUyMiUzQSUyMCUyMldvcmxkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_root</span>():
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;Hello&quot;</span>: <span class="hljs-string">&quot;World!&quot;</span>}`,wrap:!1}}),F=new g({props:{title:"Create the Dockerfile",local:"create-the-dockerfile",headingTag:"h2"}}),Y=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQVdPUktESVIlMjAlMkZjb2RlJTBBJTBBQ09QWSUyMC4lMkZyZXF1aXJlbWVudHMudHh0JTIwJTJGY29kZSUyRnJlcXVpcmVtZW50cy50eHQlMEElMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMCUyRmNvZGUlMkZyZXF1aXJlbWVudHMudHh0JTBBJTBBQ09QWSUyMC4lMjAuJTBBJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RCUwQQ==",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /code</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> ./requirements.txt /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r /code/requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> . .</span>

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>
`,wrap:!1}}),D=new g({props:{title:"Testing locally",local:"testing-locally",headingTag:"h3"}}),O=new m({props:{code:"ZG9ja2VyJTIwYnVpbGQlMjAtdCUyMGZhc3RhcGklMjAuJTBBZG9ja2VyJTIwcnVuJTIwJTIwLWl0JTIwLXAlMjA3ODYwJTNBNzg2MCUyMGZhc3RhcGk=",highlighted:`docker build -t fastapi .
docker run  -it -p 7860:7860 fastapi`,wrap:!1}}),ss=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBidWlsZHglMjBidWlsZCUyMC0tc2VjcmV0JTIwaWQlM0RTRUNSRVRfRVhBTVBMRSUyQ2VudiUzRFNFQ1JFVF9FWEFNUExFJTIwLXQlMjBmYXN0YXBpJTIwLg==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker buildx build --secret <span class="hljs-built_in">id</span>=SECRET_EXAMPLE,<span class="hljs-built_in">env</span>=SECRET_EXAMPLE -t fastapi .`,wrap:!1}}),ts=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBydW4lMjAtaXQlMjAtcCUyMDc4NjAlM0E3ODYwJTIwLWUlMjBTRUNSRVRfRVhBTVBMRSUzRCUyNFNFQ1JFVF9FWEFNUExFJTIwZmFzdGFwaQ==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker run -it -p 7860:7860 -e SECRET_EXAMPLE=<span class="hljs-variable">$SECRET_EXAMPLE</span> fastapi`,wrap:!1}}),ls=new g({props:{title:"Adding some ML to our app",local:"adding-some-ml-to-our-app",headingTag:"h2"}}),ns=new m({props:{code:"JTJGc3RhdGljJTBBJTJGc3RhdGljJTJGaW5kZXguaHRtbCUwQSUyRnN0YXRpYyUyRnNjcmlwdC5qcyUwQSUyRnN0YXRpYyUyRnN0eWxlLmNzcyUwQURvY2tlcmZpbGUlMEFtYWluLnB5JTBBUkVBRE1FLm1kJTBBcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`/static
/static/index.html
/static/script.js
/static/style.css
Dockerfile
main.py
README.md
requirements.txt`,wrap:!1}}),cs=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZV9mbGFuJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dDJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkZpbmZlcl90NSUyMiklMEFkZWYlMjB0NShpbnB1dCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwaXBlX2ZsYW4oaW5wdXQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyb3V0cHV0JTIyJTNBJTIwb3V0cHV0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe_flan = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/infer_t5&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">t5</span>(<span class="hljs-params"><span class="hljs-built_in">input</span></span>):
    output = pipe_flan(<span class="hljs-built_in">input</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;output&quot;</span>: output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]}`,wrap:!1}}),rs=new m({props:{code:"JTNDbWFpbiUzRSUwQSUyMCUyMCUzQ3NlY3Rpb24lMjBpZCUzRCUyMnRleHQtZ2VuJTIyJTNFJTBBJTIwJTIwJTIwJTIwJTNDaDIlM0VUZXh0JTIwZ2VuZXJhdGlvbiUyMHVzaW5nJTIwRmxhbiUyMFQ1JTNDJTJGaDIlM0UlMEElMjAlMjAlMjAlMjAlM0NwJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwTW9kZWwlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NhJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHJlZiUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVsJTNEJTIybm9yZWZlcnJlciUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCUzRCUyMl9ibGFuayUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRWdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZhJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGcCUzRSUwQSUyMCUyMCUyMCUyMCUzQ2Zvcm0lMjBjbGFzcyUzRCUyMnRleHQtZ2VuLWZvcm0lMjIlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NsYWJlbCUyMGZvciUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTNFVGV4dCUyMHByb21wdCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaW5wdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzRCUyMkdlcm1hbiUzQSUyMFRoZXJlJTIwYXJlJTIwbWFueSUyMGR1Y2tzJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDYnV0dG9uJTIwaWQlM0QlMjJ0ZXh0LWdlbi1zdWJtaXQlMjIlM0VTdWJtaXQlM0MlMkZidXR0b24lM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NwJTIwY2xhc3MlM0QlMjJ0ZXh0LWdlbi1vdXRwdXQlMjIlM0UlM0MlMkZwJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZm9ybSUzRSUwQSUyMCUyMCUzQyUyRnNlY3Rpb24lM0UlMEElM0MlMkZtYWluJTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">section</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h2</span>&gt;</span>Text generation using Flan T5<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>
      Model:
      <span class="hljs-tag">&lt;<span class="hljs-name">a</span>
        <span class="hljs-attr">href</span>=<span class="hljs-string">&quot;https://huggingface.co/google/flan-t5-small&quot;</span>
        <span class="hljs-attr">rel</span>=<span class="hljs-string">&quot;noreferrer&quot;</span>
        <span class="hljs-attr">target</span>=<span class="hljs-string">&quot;_blank&quot;</span>
        &gt;</span>google/flan-t5-small
      <span class="hljs-tag">&lt;/<span class="hljs-name">a</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">form</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-form&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">for</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>&gt;</span>Text prompt<span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">value</span>=<span class="hljs-string">&quot;German: There are many ducks&quot;</span>
      /&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-submit&quot;</span>&gt;</span>Submit<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-output&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">form</span>&gt;</span>
  <span class="hljs-tag">&lt;/<span class="hljs-name">section</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),hs=new m({props:{code:"YXBwLm1vdW50KCUyMiUyRiUyMiUyQyUyMFN0YXRpY0ZpbGVzKGRpcmVjdG9yeSUzRCUyMnN0YXRpYyUyMiUyQyUyMGh0bWwlM0RUcnVlKSUyQyUyMG5hbWUlM0QlMjJzdGF0aWMlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwaW5kZXgoKSUyMC0lM0UlMjBGaWxlUmVzcG9uc2UlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGaWxlUmVzcG9uc2UocGF0aCUzRCUyMiUyRmFwcCUyRnN0YXRpYyUyRmluZGV4Lmh0bWwlMjIlMkMlMjBtZWRpYV90eXBlJTNEJTIydGV4dCUyRmh0bWwlMjIp",highlighted:`app.mount(<span class="hljs-string">&quot;/&quot;</span>, StaticFiles(directory=<span class="hljs-string">&quot;static&quot;</span>, html=<span class="hljs-literal">True</span>), name=<span class="hljs-string">&quot;static&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">index</span>() -&gt; FileResponse:
    <span class="hljs-keyword">return</span> FileResponse(path=<span class="hljs-string">&quot;/app/static/index.html&quot;</span>, media_type=<span class="hljs-string">&quot;text/html&quot;</span>)`,wrap:!1}}),us=new m({props:{code:"Y29uc3QlMjB0ZXh0R2VuRm9ybSUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLWZvcm0lMjIpJTNCJTBBJTBBY29uc3QlMjB0cmFuc2xhdGVUZXh0JTIwJTNEJTIwYXN5bmMlMjAodGV4dCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjBjb25zdCUyMGluZmVyUmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGZldGNoKCU2MGluZmVyX3Q1JTNGaW5wdXQlM0QlMjQlN0J0ZXh0JTdEJTYwKSUzQiUwQSUyMCUyMGNvbnN0JTIwaW5mZXJKc29uJTIwJTNEJTIwYXdhaXQlMjBpbmZlclJlc3BvbnNlLmpzb24oKSUzQiUwQSUwQSUyMCUyMHJldHVybiUyMGluZmVySnNvbi5vdXRwdXQlM0IlMEElN0QlM0IlMEElMEF0ZXh0R2VuRm9ybS5hZGRFdmVudExpc3RlbmVyKCUyMnN1Ym1pdCUyMiUyQyUyMGFzeW5jJTIwKGV2ZW50KSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMGV2ZW50LnByZXZlbnREZWZhdWx0KCklM0IlMEElMEElMjAlMjBjb25zdCUyMHRleHRHZW5JbnB1dCUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnRleHQtZ2VuLWlucHV0JTIyKSUzQiUwQSUyMCUyMGNvbnN0JTIwdGV4dEdlblBhcmFncmFwaCUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLW91dHB1dCUyMiklM0IlMEElMEElMjAlMjB0ZXh0R2VuUGFyYWdyYXBoLnRleHRDb250ZW50JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdGVUZXh0KHRleHRHZW5JbnB1dC52YWx1ZSklM0IlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> textGenForm = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-form&quot;</span>);

<span class="hljs-keyword">const</span> <span class="hljs-title function_">translateText</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
  <span class="hljs-keyword">const</span> inferResponse = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`infer_t5?input=<span class="hljs-subst">\${text}</span>\`</span>);
  <span class="hljs-keyword">const</span> inferJson = <span class="hljs-keyword">await</span> inferResponse.<span class="hljs-title function_">json</span>();

  <span class="hljs-keyword">return</span> inferJson.<span class="hljs-property">output</span>;
};

textGenForm.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;submit&quot;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
  event.<span class="hljs-title function_">preventDefault</span>();

  <span class="hljs-keyword">const</span> textGenInput = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;text-gen-input&quot;</span>);
  <span class="hljs-keyword">const</span> textGenParagraph = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-output&quot;</span>);

  textGenParagraph.<span class="hljs-property">textContent</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translateText</span>(textGenInput.<span class="hljs-property">value</span>);
});`,wrap:!1}}),ds=new m({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBhJTIwbmV3JTIwdXNlciUyMG5hbWVkJTIwJTIydXNlciUyMiUyMHdpdGglMjB1c2VyJTIwSUQlMjAxMDAwJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQSUwQSUyMyUyMFN3aXRjaCUyMHRvJTIwdGhlJTIwJTIydXNlciUyMiUyMHVzZXIlMEFVU0VSJTIwdXNlciUwQSUwQSUyMyUyMFNldCUyMGhvbWUlMjB0byUyMHRoZSUyMHVzZXIncyUyMGhvbWUlMjBkaXJlY3RvcnklMEFFTlYlMjBIT01FJTNEJTJGaG9tZSUyRnVzZXIlMjAlNUMlMEElMDlQQVRIJTNEJTJGaG9tZSUyRnVzZXIlMkYubG9jYWwlMkZiaW4lM0ElMjRQQVRIJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwd29ya2luZyUyMGRpcmVjdG9yeSUyMHRvJTIwdGhlJTIwdXNlcidzJTIwaG9tZSUyMGRpcmVjdG9yeSUwQVdPUktESVIlMjAlMjRIT01FJTJGYXBwJTBBJTBBJTIzJTIwQ29weSUyMHRoZSUyMGN1cnJlbnQlMjBkaXJlY3RvcnklMjBjb250ZW50cyUyMGludG8lMjB0aGUlMjBjb250YWluZXIlMjBhdCUyMCUyNEhPTUUlMkZhcHAlMjBzZXR0aW5nJTIwdGhlJTIwb3duZXIlMjB0byUyMHRoZSUyMHVzZXIlMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTI0SE9NRSUyRmFwcA==",highlighted:`<span class="hljs-comment"># Set up a new user named &quot;user&quot; with user ID 1000</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>

<span class="hljs-comment"># Switch to the &quot;user&quot; user</span>
<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-comment"># Set home to the user&#x27;s home directory</span>
<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-comment"># Set the working directory to the user&#x27;s home directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-comment"># Copy the current directory contents into the container at $HOME/app setting the owner to the user</span>
<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . <span class="hljs-variable">$HOME</span>/app</span>`,wrap:!1}}),js=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQVdPUktESVIlMjAlMkZjb2RlJTBBJTBBQ09QWSUyMC4lMkZyZXF1aXJlbWVudHMudHh0JTIwJTJGY29kZSUyRnJlcXVpcmVtZW50cy50eHQlMEElMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMCUyRmNvZGUlMkZyZXF1aXJlbWVudHMudHh0JTBBJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQSUwQVVTRVIlMjB1c2VyJTBBJTBBRU5WJTIwSE9NRSUzRCUyRmhvbWUlMkZ1c2VyJTIwJTVDJTBBJTA5UEFUSCUzRCUyRmhvbWUlMkZ1c2VyJTJGLmxvY2FsJTJGYmluJTNBJTI0UEFUSCUwQSUwQVdPUktESVIlMjAlMjRIT01FJTJGYXBwJTBBJTBBQ09QWSUyMC0tY2hvd24lM0R1c2VyJTIwLiUyMCUyNEhPTUUlMkZhcHAlMEElMEFDTUQlMjAlNUIlMjJ1dmljb3JuJTIyJTJDJTIwJTIybWFpbiUzQWFwcCUyMiUyQyUyMCUyMi0taG9zdCUyMiUyQyUyMCUyMjAuMC4wLjAlMjIlMkMlMjAlMjItLXBvcnQlMjIlMkMlMjAlMjI3ODYwJTIyJTVE",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /code</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> ./requirements.txt /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>

<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>`,wrap:!1}}),ys=new g({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),Us=new g({props:{title:"Read More",local:"read-more",headingTag:"h2"}}),{c(){T=p("meta"),$s=a(),bs=p("p"),Cs=a(),c(B.$$.fragment),Bs=a(),R=p("p"),R.innerHTML=Le,Rs=a(),v=p("p"),v.innerHTML=Ae,vs=a(),c(Z.$$.fragment),Zs=a(),E=p("p"),E.innerHTML=xe,Es=a(),y=p("div"),y.innerHTML=Ge,Vs=a(),V=p("p"),V.innerHTML=Qe,Hs=a(),H=p("p"),H.innerHTML=_e,Ss=a(),c(S.$$.fragment),Ls=a(),L=p("p"),L.innerHTML=Xe,As=a(),c(A.$$.fragment),xs=a(),c(x.$$.fragment),Gs=a(),G=p("p"),G.innerHTML=We,Qs=a(),c(Q.$$.fragment),_s=a(),_=p("p"),_.textContent=Ne,Xs=a(),c(X.$$.fragment),Ws=a(),W=p("p"),W.innerHTML=Fe,Ns=a(),c(N.$$.fragment),Fs=a(),c(F.$$.fragment),qs=a(),q=p("p"),q.innerHTML=qe,Ys=a(),c(Y.$$.fragment),zs=a(),z=p("p"),z.innerHTML=Ye,Ds=a(),w=p("div"),w.innerHTML=ze,Ps=a(),c(D.$$.fragment),Os=a(),P=p("p"),P.innerHTML=De,Ks=a(),c(O.$$.fragment),se=a(),K=p("p"),K.innerHTML=Pe,ee=a(),c(ss.$$.fragment),te=a(),es=p("p"),es.innerHTML=Oe,le=a(),c(ts.$$.fragment),ae=a(),c(ls.$$.fragment),ne=a(),as=p("p"),as.innerHTML=Ke,pe=a(),c(ns.$$.fragment),ie=a(),ps=p("p"),ps.innerHTML=st,oe=a(),is=p("ol"),is.innerHTML=et,ce=a(),os=p("p"),os.innerHTML=tt,re=a(),c(cs.$$.fragment),he=a(),f=p("ol"),f.innerHTML=lt,ue=a(),c(rs.$$.fragment),Me=a(),J=p("ol"),J.innerHTML=at,de=a(),c(hs.$$.fragment),me=a(),U=p("ol"),U.innerHTML=nt,je=a(),c(us.$$.fragment),Te=a(),I=p("ol"),I.innerHTML=pt,ge=a(),Ms=p("p"),Ms.innerHTML=it,ye=a(),c(ds.$$.fragment),we=a(),ms=p("p"),ms.innerHTML=ot,fe=a(),c(js.$$.fragment),Je=a(),Ts=p("p"),Ts.innerHTML=ct,Ue=a(),b=p("div"),b.innerHTML=rt,Ie=a(),gs=p("p"),gs.innerHTML=ht,be=a(),c(ys.$$.fragment),ke=a(),ws=p("p"),ws.innerHTML=ut,$e=a(),k=p("div"),k.innerHTML=Mt,Ce=a(),fs=p("p"),fs.innerHTML=dt,Be=a(),$=p("div"),$.innerHTML=mt,Re=a(),Js=p("p"),Js.innerHTML=jt,ve=a(),C=p("div"),C.innerHTML=Tt,Ze=a(),c(Us.$$.fragment),Ee=a(),Is=p("ul"),Is.innerHTML=gt,Ve=a(),ks=p("p"),this.h()},l(s){const e=bt("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(t),$s=n(s),bs=i(s,"P",{}),yt(bs).forEach(t),Cs=n(s),r(B.$$.fragment,s),Bs=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-jw7cyg"&&(R.innerHTML=Le),Rs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1i4ovll"&&(v.innerHTML=Ae),vs=n(s),r(Z.$$.fragment,s),Zs=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-v1etaf"&&(E.innerHTML=xe),Es=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1t9e90m"&&(y.innerHTML=Ge),Vs=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1eepspk"&&(V.innerHTML=Qe),Hs=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ebivvn"&&(H.innerHTML=_e),Ss=n(s),r(S.$$.fragment,s),Ls=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-16g740l"&&(L.innerHTML=Xe),As=n(s),r(A.$$.fragment,s),xs=n(s),r(x.$$.fragment,s),Gs=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-saf9yg"&&(G.innerHTML=We),Qs=n(s),r(Q.$$.fragment,s),_s=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-nrg5eu"&&(_.textContent=Ne),Xs=n(s),r(X.$$.fragment,s),Ws=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-o8f96i"&&(W.innerHTML=Fe),Ns=n(s),r(N.$$.fragment,s),Fs=n(s),r(F.$$.fragment,s),qs=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1jworwg"&&(q.innerHTML=qe),Ys=n(s),r(Y.$$.fragment,s),zs=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1qy8wh6"&&(z.innerHTML=Ye),Ds=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1gv7naz"&&(w.innerHTML=ze),Ps=n(s),r(D.$$.fragment,s),Os=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1887xzo"&&(P.innerHTML=De),Ks=n(s),r(O.$$.fragment,s),se=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1wqy5vs"&&(K.innerHTML=Pe),ee=n(s),r(ss.$$.fragment,s),te=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-zs1fi1"&&(es.innerHTML=Oe),le=n(s),r(ts.$$.fragment,s),ae=n(s),r(ls.$$.fragment,s),ne=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1gdsumy"&&(as.innerHTML=Ke),pe=n(s),r(ns.$$.fragment,s),ie=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-16tk1cq"&&(ps.innerHTML=st),oe=n(s),is=i(s,"OL",{"data-svelte-h":!0}),o(is)!=="svelte-42bpu9"&&(is.innerHTML=et),ce=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1s0pz1q"&&(os.innerHTML=tt),re=n(s),r(cs.$$.fragment,s),he=n(s),f=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(f)!=="svelte-k9s0qn"&&(f.innerHTML=lt),ue=n(s),r(rs.$$.fragment,s),Me=n(s),J=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-19p8yis"&&(J.innerHTML=at),de=n(s),r(hs.$$.fragment,s),me=n(s),U=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(U)!=="svelte-ztetn2"&&(U.innerHTML=nt),je=n(s),r(us.$$.fragment,s),Te=n(s),I=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(I)!=="svelte-1dn7zpw"&&(I.innerHTML=pt),ge=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1dto2my"&&(Ms.innerHTML=it),ye=n(s),r(ds.$$.fragment,s),we=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-hrrqd1"&&(ms.innerHTML=ot),fe=n(s),r(js.$$.fragment,s),Je=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-cvojof"&&(Ts.innerHTML=ct),Ue=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-7ddsz3"&&(b.innerHTML=rt),Ie=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1m82b2h"&&(gs.innerHTML=ht),be=n(s),r(ys.$$.fragment,s),ke=n(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-40o9jr"&&(ws.innerHTML=ut),$e=n(s),k=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-15efue1"&&(k.innerHTML=Mt),Ce=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-86h2ue"&&(fs.innerHTML=dt),Be=n(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-1kv7f9v"&&($.innerHTML=mt),Re=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-10fpzqt"&&(Js.innerHTML=jt),ve=n(s),C=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1wbh090"&&(C.innerHTML=Tt),Ze=n(s),r(Us.$$.fragment,s),Ee=n(s),Is=i(s,"UL",{"data-svelte-h":!0}),o(Is)!=="svelte-bhfcx6"&&(Is.innerHTML=gt),Ve=n(s),ks=i(s,"P",{}),yt(ks).forEach(t),this.h()},h(){j(T,"name","hf:doc:metadata"),j(T,"content",Bt),j(y,"class","flex justify-center"),j(w,"class","flex justify-center"),j(f,"start","2"),j(J,"start","3"),j(U,"start","4"),j(I,"start","5"),j(b,"class","flex justify-center"),j(k,"class","flex justify-center"),j($,"class","flex justify-center"),j(C,"class","flex justify-center")},m(s,e){kt(document.head,T),l(s,$s,e),l(s,bs,e),l(s,Cs,e),h(B,s,e),l(s,Bs,e),l(s,R,e),l(s,Rs,e),l(s,v,e),l(s,vs,e),h(Z,s,e),l(s,Zs,e),l(s,E,e),l(s,Es,e),l(s,y,e),l(s,Vs,e),l(s,V,e),l(s,Hs,e),l(s,H,e),l(s,Ss,e),h(S,s,e),l(s,Ls,e),l(s,L,e),l(s,As,e),h(A,s,e),l(s,xs,e),h(x,s,e),l(s,Gs,e),l(s,G,e),l(s,Qs,e),h(Q,s,e),l(s,_s,e),l(s,_,e),l(s,Xs,e),h(X,s,e),l(s,Ws,e),l(s,W,e),l(s,Ns,e),h(N,s,e),l(s,Fs,e),h(F,s,e),l(s,qs,e),l(s,q,e),l(s,Ys,e),h(Y,s,e),l(s,zs,e),l(s,z,e),l(s,Ds,e),l(s,w,e),l(s,Ps,e),h(D,s,e),l(s,Os,e),l(s,P,e),l(s,Ks,e),h(O,s,e),l(s,se,e),l(s,K,e),l(s,ee,e),h(ss,s,e),l(s,te,e),l(s,es,e),l(s,le,e),h(ts,s,e),l(s,ae,e),h(ls,s,e),l(s,ne,e),l(s,as,e),l(s,pe,e),h(ns,s,e),l(s,ie,e),l(s,ps,e),l(s,oe,e),l(s,is,e),l(s,ce,e),l(s,os,e),l(s,re,e),h(cs,s,e),l(s,he,e),l(s,f,e),l(s,ue,e),h(rs,s,e),l(s,Me,e),l(s,J,e),l(s,de,e),h(hs,s,e),l(s,me,e),l(s,U,e),l(s,je,e),h(us,s,e),l(s,Te,e),l(s,I,e),l(s,ge,e),l(s,Ms,e),l(s,ye,e),h(ds,s,e),l(s,we,e),l(s,ms,e),l(s,fe,e),h(js,s,e),l(s,Je,e),l(s,Ts,e),l(s,Ue,e),l(s,b,e),l(s,Ie,e),l(s,gs,e),l(s,be,e),h(ys,s,e),l(s,ke,e),l(s,ws,e),l(s,$e,e),l(s,k,e),l(s,Ce,e),l(s,fs,e),l(s,Be,e),l(s,$,e),l(s,Re,e),l(s,Js,e),l(s,ve,e),l(s,C,e),l(s,Ze,e),h(Us,s,e),l(s,Ee,e),l(s,Is,e),l(s,Ve,e),l(s,ks,e),He=!0},p:ft,i(s){He||(u(B.$$.fragment,s),u(Z.$$.fragment,s),u(S.$$.fragment,s),u(A.$$.fragment,s),u(x.$$.fragment,s),u(Q.$$.fragment,s),u(X.$$.fragment,s),u(N.$$.fragment,s),u(F.$$.fragment,s),u(Y.$$.fragment,s),u(D.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ls.$$.fragment,s),u(ns.$$.fragment,s),u(cs.$$.fragment,s),u(rs.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(ds.$$.fragment,s),u(js.$$.fragment,s),u(ys.$$.fragment,s),u(Us.$$.fragment,s),He=!0)},o(s){M(B.$$.fragment,s),M(Z.$$.fragment,s),M(S.$$.fragment,s),M(A.$$.fragment,s),M(x.$$.fragment,s),M(Q.$$.fragment,s),M(X.$$.fragment,s),M(N.$$.fragment,s),M(F.$$.fragment,s),M(Y.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(cs.$$.fragment,s),M(rs.$$.fragment,s),M(hs.$$.fragment,s),M(us.$$.fragment,s),M(ds.$$.fragment,s),M(js.$$.fragment,s),M(ys.$$.fragment,s),M(Us.$$.fragment,s),He=!1},d(s){s&&(t($s),t(bs),t(Cs),t(Bs),t(R),t(Rs),t(v),t(vs),t(Zs),t(E),t(Es),t(y),t(Vs),t(V),t(Hs),t(H),t(Ss),t(Ls),t(L),t(As),t(xs),t(Gs),t(G),t(Qs),t(_s),t(_),t(Xs),t(Ws),t(W),t(Ns),t(Fs),t(qs),t(q),t(Ys),t(zs),t(z),t(Ds),t(w),t(Ps),t(Os),t(P),t(Ks),t(se),t(K),t(ee),t(te),t(es),t(le),t(ae),t(ne),t(as),t(pe),t(ie),t(ps),t(oe),t(is),t(ce),t(os),t(re),t(he),t(f),t(ue),t(Me),t(J),t(de),t(me),t(U),t(je),t(Te),t(I),t(ge),t(Ms),t(ye),t(we),t(ms),t(fe),t(Je),t(Ts),t(Ue),t(b),t(Ie),t(gs),t(be),t(ke),t(ws),t($e),t(k),t(Ce),t(fs),t(Be),t($),t(Re),t(Js),t(ve),t(C),t(Ze),t(Ee),t(Is),t(Ve),t(ks)),t(T),d(B,s),d(Z,s),d(S,s),d(A,s),d(x,s),d(Q,s),d(X,s),d(N,s),d(F,s),d(Y,s),d(D,s),d(O,s),d(ss,s),d(ts,s),d(ls,s),d(ns,s),d(cs,s),d(rs,s),d(hs,s),d(us,s),d(ds,s),d(js,s),d(ys,s),d(Us,s)}}}const Bt='{"title":"Your First Docker Space: Text Generation with T5","local":"your-first-docker-space-text-generation-with-t5","sections":[{"title":"Create a new Docker Space","local":"create-a-new-docker-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the app","local":"create-the-app","sections":[],"depth":2},{"title":"Create the Dockerfile","local":"create-the-dockerfile","sections":[{"title":"Testing locally","local":"testing-locally","sections":[],"depth":3}],"depth":2},{"title":"Adding some ML to our app","local":"adding-some-ml-to-our-app","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Read More","local":"read-more","sections":[],"depth":2}],"depth":1}';function Rt(Se){return Jt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=$t}),[]}class Ht extends Ut{constructor(T){super(),It(this,T,Rt,Ct,wt,{})}}export{Ht as component};
