import{s as gs,f as ml,n as Bs,o as xs}from"../chunks/scheduler.f6b352c8.js";import{S as _s,i as Gs,g as i,s as n,r as p,A as Hs,h as o,f as l,c as a,j as hl,u as w,x as M,k as c,y as Il,a as s,v as r,d as T,t as u,w as y}from"../chunks/index.7f38e934.js";import{C as m}from"../chunks/CodeBlock.2a338b68.js";import{H as St}from"../chunks/Heading.333929c4.js";import{E as Ws}from"../chunks/EditOnGithub.c3245a01.js";function ks(dl){let J,Qt,Yt,Xt,h,Vt,I,Ul,qt,d,fl="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",Nt,U,Cl="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",Ft,f,bl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",Pt,C,Dt,b,Al="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",Kt,A,vl="Here are some commonly used tools in AI agents:",Ot,v,gl="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",te,g,Bl="Those are only examples, as you can in fact create a tool for any use case!",ee,B,xl="A good tool should be something that <strong>complements the power of an LLM</strong>.",le,x,_l="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",se,_,Gl="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",ne,G,Hl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",ae,H,Wl,ie,W,kl="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",oe,k,Me,L,Ll="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. What we mean when we talk about <em>providing tools to an Agent</em>, is that we <strong>teach</strong> the LLM about the existence of tools, and ask the model to generate text that will invoke tools when it needs to. For example, if we provide a tool to check the weather at a location from the Internet, and then ask the LLM about the weather in Paris, the LLM will recognize that question as a relevant opportunity to use the “weather” tool we taught it about. The LLM will generate <em>text</em>, in the form of code, to invoke that tool. It is the responsibility of the <strong>Agent</strong> to parse the LLM’s output, recognize that a tool call is required, and invoke the tool on the LLM’s behalf. The output from the tool will then be sent back to the LLM, which will compose its final response for the user.",pe,$,$l="The output from a tool call is another type of message in the conversation. Tool calling steps are typically not shown to the user: the Agent retrieves the conversation, calls the tool(s), gets the outputs, adds them as a new conversation message, and sends the updated conversation to the LLM again. From the user’s point of view, it’s like the LLM had used the tool, but in fact it was our application code (the <strong>Agent</strong>) who did it.",we,E,El="We’ll talk a lot more about this process in future sessions.",re,Z,Te,R,Zl="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",ue,S,Rl,ye,Y,Sl="For this to work, we have to be very precise and accurate about:",ce,z,Yl="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",Je,Q,zl="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",me,X,Ql="If this seems too theoretical, let’s understand it through a concrete example.",je,V,Xl="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",he,q,Ie,N,Vl="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",de,F,ql="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",Ue,P,Nl="The output of the tool is another integer number that we can describe like this:",fe,D,Fl="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",Ce,K,Pl="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",be,O,Ae,tt,Dl="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",ve,et,Kl="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",ge,lt,Ol="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",Be,st,ts="Is there a better way?",xe,nt,_e,at,es="Our tool was written in Python, and the implementation already provides everything we need:",Ge,it,ls="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",He,ot,ss="There’s a reason people use programming languages: they are expressive, concise, and precise.",We,Mt,ns="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",ke,pt,as="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",Le,wt,is="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",$e,rt,Ee,Tt,os="Note the <code>@tool</code> decorator before the function definition.",Ze,ut,Ms="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code:",Re,yt,Se,ct,ps="As you can see, it’s the same thing we wrote manually before!",Ye,Jt,ze,mt,ws="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Qe,jt,rs="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",Xe,ht,Ve,It,Ts="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",qe,dt,us="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>input_arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",Ne,Ut,ys="We could create a Tool with this class using code like the following:",Fe,ft,Pe,Ct,cs="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",De,bt,Js="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",Ke,j,Rt,ms="decorator code",jl,At,Oe,vt,js="Just to reiterate, with this decorator in place we can implement our tool like this:",tl,gt,el,Bt,hs="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",ll,xt,sl,_t,Is="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",nl,Gt,ds,al,Ht,Us='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',il,ol,Ml,Wt,fs="Tools play a crucial role in enhancing the capabilities of AI agents.",pl,kt,Cs="To summarize, we learned:",wl,Lt,bs="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",rl,$t,As='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',Tl,Et,vs="But first, it’s time for another short quiz!",ul,Zt,yl,zt,cl;return h=new St({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),C=new St({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),k=new St({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),Z=new St({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),q=new m({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhdG9yLnRvX3N0cmluZygpKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),O=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, <span class="hljs-keyword">Description</span>: <span class="hljs-keyword">Multiply</span> two integers., Arguments: a: <span class="hljs-keyword">int</span>, b: <span class="hljs-keyword">int</span>, Outputs: <span class="hljs-keyword">int</span>',wrap:!1}}),nt=new St({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),rt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),yt=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, <span class="hljs-keyword">Description</span>: <span class="hljs-keyword">Multiply</span> two integers., Arguments: a: <span class="hljs-keyword">int</span>, b: <span class="hljs-keyword">int</span>, Outputs: <span class="hljs-keyword">int</span>',wrap:!1}}),Jt=new St({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),ht=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).
    
    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool, 
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),ft=new m({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),At=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__
    
    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),gt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),xt=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, <span class="hljs-keyword">Description</span>: <span class="hljs-keyword">Multiply</span> two integers., Arguments: a: <span class="hljs-keyword">int</span>, b: <span class="hljs-keyword">int</span>, Outputs: <span class="hljs-keyword">int</span>',wrap:!1}}),Zt=new Ws({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){J=i("meta"),Qt=n(),Yt=i("p"),Xt=n(),p(h.$$.fragment),Vt=n(),I=i("img"),qt=n(),d=i("p"),d.innerHTML=fl,Nt=n(),U=i("p"),U.textContent=Cl,Ft=n(),f=i("p"),f.textContent=bl,Pt=n(),p(C.$$.fragment),Dt=n(),b=i("p"),b.innerHTML=Al,Kt=n(),A=i("p"),A.textContent=vl,Ot=n(),v=i("table"),v.innerHTML=gl,te=n(),g=i("p"),g.textContent=Bl,ee=n(),B=i("p"),B.innerHTML=xl,le=n(),x=i("p"),x.innerHTML=_l,se=n(),_=i("p"),_.innerHTML=Gl,ne=n(),G=i("p"),G.textContent=Hl,ae=n(),H=i("img"),ie=n(),W=i("ul"),W.innerHTML=kl,oe=n(),p(k.$$.fragment),Me=n(),L=i("p"),L.innerHTML=Ll,pe=n(),$=i("p"),$.innerHTML=$l,we=n(),E=i("p"),E.textContent=El,re=n(),p(Z.$$.fragment),Te=n(),R=i("p"),R.textContent=Zl,ue=n(),S=i("img"),ye=n(),Y=i("p"),Y.textContent=Sl,ce=n(),z=i("ol"),z.innerHTML=Yl,Je=n(),Q=i("p"),Q.innerHTML=zl,me=n(),X=i("p"),X.textContent=Ql,je=n(),V=i("p"),V.innerHTML=Xl,he=n(),p(q.$$.fragment),Ie=n(),N=i("p"),N.innerHTML=Vl,de=n(),F=i("ul"),F.innerHTML=ql,Ue=n(),P=i("p"),P.textContent=Nl,fe=n(),D=i("ul"),D.innerHTML=Fl,Ce=n(),K=i("p"),K.textContent=Pl,be=n(),p(O.$$.fragment),Ae=n(),tt=i("blockquote"),tt.innerHTML=Dl,ve=n(),et=i("p"),et.textContent=Kl,ge=n(),lt=i("p"),lt.textContent=Ol,Be=n(),st=i("p"),st.textContent=ts,xe=n(),p(nt.$$.fragment),_e=n(),at=i("p"),at.textContent=es,Ge=n(),it=i("ul"),it.innerHTML=ls,He=n(),ot=i("p"),ot.textContent=ss,We=n(),Mt=i("p"),Mt.innerHTML=ns,ke=n(),pt=i("p"),pt.textContent=as,Le=n(),wt=i("p"),wt.innerHTML=is,$e=n(),p(rt.$$.fragment),Ee=n(),Tt=i("p"),Tt.innerHTML=os,Ze=n(),ut=i("p"),ut.textContent=Ms,Re=n(),p(yt.$$.fragment),Se=n(),ct=i("p"),ct.textContent=ps,Ye=n(),p(Jt.$$.fragment),ze=n(),mt=i("p"),mt.innerHTML=ws,Qe=n(),jt=i("blockquote"),jt.innerHTML=rs,Xe=n(),p(ht.$$.fragment),Ve=n(),It=i("p"),It.innerHTML=Ts,qe=n(),dt=i("ul"),dt.innerHTML=us,Ne=n(),Ut=i("p"),Ut.textContent=ys,Fe=n(),p(ft.$$.fragment),Pe=n(),Ct=i("p"),Ct.innerHTML=cs,De=n(),bt=i("blockquote"),bt.innerHTML=Js,Ke=n(),j=i("details"),Rt=i("summary"),Rt.textContent=ms,jl=n(),p(At.$$.fragment),Oe=n(),vt=i("p"),vt.textContent=js,tl=n(),p(gt.$$.fragment),el=n(),Bt=i("p"),Bt.innerHTML=hs,ll=n(),p(xt.$$.fragment),sl=n(),_t=i("p"),_t.innerHTML=Is,nl=n(),Gt=i("img"),al=n(),Ht=i("p"),Ht.innerHTML=Us,il=n(),ol=i("hr"),Ml=n(),Wt=i("p"),Wt.textContent=fs,pl=n(),kt=i("p"),kt.textContent=Cs,wl=n(),Lt=i("ul"),Lt.innerHTML=bs,rl=n(),$t=i("p"),$t.innerHTML=As,Tl=n(),Et=i("p"),Et.textContent=vs,ul=n(),p(Zt.$$.fragment),yl=n(),zt=i("p"),this.h()},l(t){const e=Hs("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),Qt=a(t),Yt=o(t,"P",{}),hl(Yt).forEach(l),Xt=a(t),w(h.$$.fragment,t),Vt=a(t),I=o(t,"IMG",{src:!0,alt:!0}),qt=a(t),d=o(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-12q0l6c"&&(d.innerHTML=fl),Nt=a(t),U=o(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-vccz0n"&&(U.textContent=Cl),Ft=a(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=bl),Pt=a(t),w(C.$$.fragment,t),Dt=a(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-d0memu"&&(b.innerHTML=Al),Kt=a(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnicmb"&&(A.textContent=vl),Ot=a(t),v=o(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=gl),te=a(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=Bl),ee=a(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1eopnbk"&&(B.innerHTML=xl),le=a(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1redoxr"&&(x.innerHTML=_l),se=a(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v1ck09"&&(_.innerHTML=Gl),ne=a(t),G=o(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-mz2far"&&(G.textContent=Hl),ae=a(t),H=o(t,"IMG",{src:!0,alt:!0}),ie=a(t),W=o(t,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-gj3em1"&&(W.innerHTML=kl),oe=a(t),w(k.$$.fragment,t),Me=a(t),L=o(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-bf3q0z"&&(L.innerHTML=Ll),pe=a(t),$=o(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-19cyzqu"&&($.innerHTML=$l),we=a(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1gym7on"&&(E.textContent=El),re=a(t),w(Z.$$.fragment,t),Te=a(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1m76tol"&&(R.textContent=Zl),ue=a(t),S=o(t,"IMG",{src:!0,alt:!0}),ye=a(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-e466s4"&&(Y.textContent=Sl),ce=a(t),z=o(t,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-12vrnnv"&&(z.innerHTML=Yl),Je=a(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1lxlzbg"&&(Q.innerHTML=zl),me=a(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1p033lp"&&(X.textContent=Ql),je=a(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1if40sb"&&(V.innerHTML=Xl),he=a(t),w(q.$$.fragment,t),Ie=a(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-somofk"&&(N.innerHTML=Vl),de=a(t),F=o(t,"UL",{"data-svelte-h":!0}),M(F)!=="svelte-1qi2vj"&&(F.innerHTML=ql),Ue=a(t),P=o(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-z90coj"&&(P.textContent=Nl),fe=a(t),D=o(t,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-1rd1o27"&&(D.innerHTML=Fl),Ce=a(t),K=o(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1gl47rm"&&(K.textContent=Pl),be=a(t),w(O.$$.fragment,t),Ae=a(t),tt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(tt)!=="svelte-jn5onw"&&(tt.innerHTML=Dl),ve=a(t),et=o(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-dd2uu2"&&(et.textContent=Kl),ge=a(t),lt=o(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-1ec16zo"&&(lt.textContent=Ol),Be=a(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-xhigt1"&&(st.textContent=ts),xe=a(t),w(nt.$$.fragment,t),_e=a(t),at=o(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-xwh6nk"&&(at.textContent=es),Ge=a(t),it=o(t,"UL",{"data-svelte-h":!0}),M(it)!=="svelte-1mufwba"&&(it.innerHTML=ls),He=a(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-6ogn9l"&&(ot.textContent=ss),We=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-2908e6"&&(Mt.innerHTML=ns),ke=a(t),pt=o(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1nshzlk"&&(pt.textContent=as),Le=a(t),wt=o(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1iag2er"&&(wt.innerHTML=is),$e=a(t),w(rt.$$.fragment,t),Ee=a(t),Tt=o(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-1xfdhk0"&&(Tt.innerHTML=os),Ze=a(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-i0wjh"&&(ut.textContent=Ms),Re=a(t),w(yt.$$.fragment,t),Se=a(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-ah55dy"&&(ct.textContent=ps),Ye=a(t),w(Jt.$$.fragment,t),ze=a(t),mt=o(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1g4lbet"&&(mt.innerHTML=ws),Qe=a(t),jt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(jt)!=="svelte-17jlnyo"&&(jt.innerHTML=rs),Xe=a(t),w(ht.$$.fragment,t),Ve=a(t),It=o(t,"P",{"data-svelte-h":!0}),M(It)!=="svelte-1m24zfs"&&(It.innerHTML=Ts),qe=a(t),dt=o(t,"UL",{"data-svelte-h":!0}),M(dt)!=="svelte-1cnrr36"&&(dt.innerHTML=us),Ne=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-9jg0w0"&&(Ut.textContent=ys),Fe=a(t),w(ft.$$.fragment,t),Pe=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-imjo5d"&&(Ct.innerHTML=cs),De=a(t),bt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(bt)!=="svelte-5gslq7"&&(bt.innerHTML=Js),Ke=a(t),j=o(t,"DETAILS",{});var Jl=hl(j);Rt=o(Jl,"SUMMARY",{"data-svelte-h":!0}),M(Rt)!=="svelte-14wmf42"&&(Rt.textContent=ms),jl=a(Jl),w(At.$$.fragment,Jl),Jl.forEach(l),Oe=a(t),vt=o(t,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-1pxgdsn"&&(vt.textContent=js),tl=a(t),w(gt.$$.fragment,t),el=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-oh725x"&&(Bt.innerHTML=hs),ll=a(t),w(xt.$$.fragment,t),sl=a(t),_t=o(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-1gsasw4"&&(_t.innerHTML=Is),nl=a(t),Gt=o(t,"IMG",{src:!0,alt:!0}),al=a(t),Ht=o(t,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-14h2jbz"&&(Ht.innerHTML=Us),il=a(t),ol=o(t,"HR",{}),Ml=a(t),Wt=o(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-yaz9vn"&&(Wt.textContent=fs),pl=a(t),kt=o(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-1mncb1b"&&(kt.textContent=Cs),wl=a(t),Lt=o(t,"UL",{"data-svelte-h":!0}),M(Lt)!=="svelte-1lbaznq"&&(Lt.innerHTML=bs),rl=a(t),$t=o(t,"P",{"data-svelte-h":!0}),M($t)!=="svelte-16mxhlc"&&($t.innerHTML=As),Tl=a(t),Et=o(t,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-1w2njod"&&(Et.textContent=vs),ul=a(t),w(Zt.$$.fragment,t),yl=a(t),zt=o(t,"P",{}),hl(zt).forEach(l),this.h()},h(){c(J,"name","hf:doc:metadata"),c(J,"content",Ls),ml(I.src,Ul="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||c(I,"src",Ul),c(I,"alt","Unit 1 planning"),ml(H.src,Wl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||c(H,"src",Wl),c(H,"alt","Weather"),ml(S.src,Rl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||c(S,"src",Rl),c(S,"alt","System prompt for tools"),ml(Gt.src,ds="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||c(Gt,"src",ds),c(Gt,"alt","System prompt for tools")},m(t,e){Il(document.head,J),s(t,Qt,e),s(t,Yt,e),s(t,Xt,e),r(h,t,e),s(t,Vt,e),s(t,I,e),s(t,qt,e),s(t,d,e),s(t,Nt,e),s(t,U,e),s(t,Ft,e),s(t,f,e),s(t,Pt,e),r(C,t,e),s(t,Dt,e),s(t,b,e),s(t,Kt,e),s(t,A,e),s(t,Ot,e),s(t,v,e),s(t,te,e),s(t,g,e),s(t,ee,e),s(t,B,e),s(t,le,e),s(t,x,e),s(t,se,e),s(t,_,e),s(t,ne,e),s(t,G,e),s(t,ae,e),s(t,H,e),s(t,ie,e),s(t,W,e),s(t,oe,e),r(k,t,e),s(t,Me,e),s(t,L,e),s(t,pe,e),s(t,$,e),s(t,we,e),s(t,E,e),s(t,re,e),r(Z,t,e),s(t,Te,e),s(t,R,e),s(t,ue,e),s(t,S,e),s(t,ye,e),s(t,Y,e),s(t,ce,e),s(t,z,e),s(t,Je,e),s(t,Q,e),s(t,me,e),s(t,X,e),s(t,je,e),s(t,V,e),s(t,he,e),r(q,t,e),s(t,Ie,e),s(t,N,e),s(t,de,e),s(t,F,e),s(t,Ue,e),s(t,P,e),s(t,fe,e),s(t,D,e),s(t,Ce,e),s(t,K,e),s(t,be,e),r(O,t,e),s(t,Ae,e),s(t,tt,e),s(t,ve,e),s(t,et,e),s(t,ge,e),s(t,lt,e),s(t,Be,e),s(t,st,e),s(t,xe,e),r(nt,t,e),s(t,_e,e),s(t,at,e),s(t,Ge,e),s(t,it,e),s(t,He,e),s(t,ot,e),s(t,We,e),s(t,Mt,e),s(t,ke,e),s(t,pt,e),s(t,Le,e),s(t,wt,e),s(t,$e,e),r(rt,t,e),s(t,Ee,e),s(t,Tt,e),s(t,Ze,e),s(t,ut,e),s(t,Re,e),r(yt,t,e),s(t,Se,e),s(t,ct,e),s(t,Ye,e),r(Jt,t,e),s(t,ze,e),s(t,mt,e),s(t,Qe,e),s(t,jt,e),s(t,Xe,e),r(ht,t,e),s(t,Ve,e),s(t,It,e),s(t,qe,e),s(t,dt,e),s(t,Ne,e),s(t,Ut,e),s(t,Fe,e),r(ft,t,e),s(t,Pe,e),s(t,Ct,e),s(t,De,e),s(t,bt,e),s(t,Ke,e),s(t,j,e),Il(j,Rt),Il(j,jl),r(At,j,null),s(t,Oe,e),s(t,vt,e),s(t,tl,e),r(gt,t,e),s(t,el,e),s(t,Bt,e),s(t,ll,e),r(xt,t,e),s(t,sl,e),s(t,_t,e),s(t,nl,e),s(t,Gt,e),s(t,al,e),s(t,Ht,e),s(t,il,e),s(t,ol,e),s(t,Ml,e),s(t,Wt,e),s(t,pl,e),s(t,kt,e),s(t,wl,e),s(t,Lt,e),s(t,rl,e),s(t,$t,e),s(t,Tl,e),s(t,Et,e),s(t,ul,e),r(Zt,t,e),s(t,yl,e),s(t,zt,e),cl=!0},p:Bs,i(t){cl||(T(h.$$.fragment,t),T(C.$$.fragment,t),T(k.$$.fragment,t),T(Z.$$.fragment,t),T(q.$$.fragment,t),T(O.$$.fragment,t),T(nt.$$.fragment,t),T(rt.$$.fragment,t),T(yt.$$.fragment,t),T(Jt.$$.fragment,t),T(ht.$$.fragment,t),T(ft.$$.fragment,t),T(At.$$.fragment,t),T(gt.$$.fragment,t),T(xt.$$.fragment,t),T(Zt.$$.fragment,t),cl=!0)},o(t){u(h.$$.fragment,t),u(C.$$.fragment,t),u(k.$$.fragment,t),u(Z.$$.fragment,t),u(q.$$.fragment,t),u(O.$$.fragment,t),u(nt.$$.fragment,t),u(rt.$$.fragment,t),u(yt.$$.fragment,t),u(Jt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(At.$$.fragment,t),u(gt.$$.fragment,t),u(xt.$$.fragment,t),u(Zt.$$.fragment,t),cl=!1},d(t){t&&(l(Qt),l(Yt),l(Xt),l(Vt),l(I),l(qt),l(d),l(Nt),l(U),l(Ft),l(f),l(Pt),l(Dt),l(b),l(Kt),l(A),l(Ot),l(v),l(te),l(g),l(ee),l(B),l(le),l(x),l(se),l(_),l(ne),l(G),l(ae),l(H),l(ie),l(W),l(oe),l(Me),l(L),l(pe),l($),l(we),l(E),l(re),l(Te),l(R),l(ue),l(S),l(ye),l(Y),l(ce),l(z),l(Je),l(Q),l(me),l(X),l(je),l(V),l(he),l(Ie),l(N),l(de),l(F),l(Ue),l(P),l(fe),l(D),l(Ce),l(K),l(be),l(Ae),l(tt),l(ve),l(et),l(ge),l(lt),l(Be),l(st),l(xe),l(_e),l(at),l(Ge),l(it),l(He),l(ot),l(We),l(Mt),l(ke),l(pt),l(Le),l(wt),l($e),l(Ee),l(Tt),l(Ze),l(ut),l(Re),l(Se),l(ct),l(Ye),l(ze),l(mt),l(Qe),l(jt),l(Xe),l(Ve),l(It),l(qe),l(dt),l(Ne),l(Ut),l(Fe),l(Pe),l(Ct),l(De),l(bt),l(Ke),l(j),l(Oe),l(vt),l(tl),l(el),l(Bt),l(ll),l(sl),l(_t),l(nl),l(Gt),l(al),l(Ht),l(il),l(ol),l(Ml),l(Wt),l(pl),l(kt),l(wl),l(Lt),l(rl),l($t),l(Tl),l(Et),l(ul),l(yl),l(zt)),l(J),y(h,t),y(C,t),y(k,t),y(Z,t),y(q,t),y(O,t),y(nt,t),y(rt,t),y(yt,t),y(Jt,t),y(ht,t),y(ft,t),y(At),y(gt,t),y(xt,t),y(Zt,t)}}}const Ls='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3}],"depth":2}],"depth":1}';function $s(dl){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends _s{constructor(J){super(),Gs(this,J,$s,ks,gs,{})}}export{zs as component};
