import{s as Ht,o as Qt,n as Dt}from"../chunks/scheduler.8c3d61f6.js";import{S as Yt,i as Kt,g as r,s as o,r as u,A as en,h as d,f as n,c as s,j as k,u as g,x as f,k as S,y as t,a as p,v as _,d as h,t as b,w as P,m as tn,n as nn}from"../chunks/index.da70eac4.js";import{T as At}from"../chunks/Tip.1d9b8c37.js";import{D as E}from"../chunks/Docstring.6b390b9a.js";import{C as Ft}from"../chunks/CodeBlock.00a903b3.js";import{E as Vt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Me,E as on}from"../chunks/EditOnGithub.1e64e623.js";function sn(I){let a,w='You can find additional information about LEDITS++ on the <a href="https://leditsplusplus-project.static.hf.space/index.html" rel="nofollow">project page</a> and try it out in a <a href="https://huggingface.co/spaces/editing-images/leditsplusplus" rel="nofollow">demo</a>.';return{c(){a=r("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-rdvyhm"&&(a.innerHTML=w)},m(m,v){p(m,a,v)},p:Dt,d(m){m&&n(a)}}}function an(I){let a;return{c(){a=tn(`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},l(w){a=nn(w,`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},m(w,m){p(w,a,m)},d(w){w&&n(a)}}}function rn(I){let a,w="Examples:",m,v,y;return v=new Ft({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvbiUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMExFZGl0c1BQUGlwZWxpbmVTdGFibGVEaWZmdXNpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGd3d3LmFpbWwuaW5mb3JtYXRpay50dS1kYXJtc3RhZHQuZGUlMkZwZW9wbGUlMkZtYnJhY2slMkZjaGVycnlfYmxvc3NvbS5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBXyUyMCUzRCUyMHBpcGUuaW52ZXJ0KGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW52ZXJzaW9uX3N0ZXBzJTNENTAlMkMlMjBza2lwJTNEMC4xKSUwQSUwQWVkaXRlZF9pbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZWRpdGluZ19wcm9tcHQlM0QlNUIlMjJjaGVycnklMjBibG9zc29tJTIyJTVEJTJDJTIwZWRpdF9ndWlkYW5jZV9zY2FsZSUzRDEwLjAlMkMlMjBlZGl0X3RocmVzaG9sZCUzRDAuNzUlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusion
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusion.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/cherry_blossom.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;cherry blossom&quot;</span>], edit_guidance_scale=<span class="hljs-number">10.0</span>, edit_threshold=<span class="hljs-number">0.75</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=r("p"),a.textContent=w,m=o(),u(v.$$.fragment)},l(l){a=d(l,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=w),m=s(l),g(v.$$.fragment,l)},m(l,D){p(l,a,D),p(l,m,D),_(v,l,D),y=!0},p:Dt,i(l){y||(h(v.$$.fragment,l),y=!0)},o(l){b(v.$$.fragment,l),y=!1},d(l){l&&(n(a),n(m)),P(v,l)}}}function dn(I){let a,w="Examples:",m,v,y;return v=new Ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBQSUwlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvblhMJTBBJTBBcGlwZSUyMCUzRCUyMExFZGl0c1BQUGlwZWxpbmVTdGFibGVEaWZmdXNpb25YTC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuYWltbC5pbmZvcm1hdGlrLnR1LWRhcm1zdGFkdC5kZSUyRnBlb3BsZSUyRm1icmFjayUyRnRlbm5pcy5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpJTBBJTBBXyUyMCUzRCUyMHBpcGUuaW52ZXJ0KGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW52ZXJzaW9uX3N0ZXBzJTNENTAlMkMlMjBza2lwJTNEMC4yKSUwQSUwQWVkaXRlZF9pbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZWRpdGluZ19wcm9tcHQlM0QlNUIlMjJ0ZW5uaXMlMjBiYWxsJTIyJTJDJTIwJTIydG9tYXRvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV2ZXJzZV9lZGl0aW5nX2RpcmVjdGlvbiUzRCU1QlRydWUlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMGVkaXRfZ3VpZGFuY2Vfc2NhbGUlM0QlNUI1LjAlMkMlMjAxMC4wJTVEJTJDJTBBJTIwJTIwJTIwJTIwZWRpdF90aHJlc2hvbGQlM0QlNUIwLjklMkMlMjAwLjg1JTVEJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusionXL

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusionXL.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/tennis.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url)

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;tennis ball&quot;</span>, <span class="hljs-string">&quot;tomato&quot;</span>],
<span class="hljs-meta">... </span>    reverse_editing_direction=[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>],
<span class="hljs-meta">... </span>    edit_guidance_scale=[<span class="hljs-number">5.0</span>, <span class="hljs-number">10.0</span>],
<span class="hljs-meta">... </span>    edit_threshold=[<span class="hljs-number">0.9</span>, <span class="hljs-number">0.85</span>],
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=r("p"),a.textContent=w,m=o(),u(v.$$.fragment)},l(l){a=d(l,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=w),m=s(l),g(v.$$.fragment,l)},m(l,D){p(l,a,D),p(l,m,D),_(v,l,D),y=!0},p:Dt,i(l){y||(h(v.$$.fragment,l),y=!0)},o(l){b(v.$$.fragment,l),y=!1},d(l){l&&(n(a),n(m)),P(v,l)}}}function ln(I){let a,w,m,v,y,l,D,Tt='LEDITS++ was proposed in <a href="https://huggingface.co/papers/2311.16711" rel="nofollow">LEDITS++: Limitless Image Editing using Text-to-Image Models</a> by Manuel Brack, Felix Friedrich, Katharina Kornmeier, Linoy Tsaban, Patrick Schramowski, Kristian Kersting, Apolinário Passos.',$e,R,kt="The abstract from the paper is:",Ce,q,St='<em>Text-to-image diffusion models have recently received increasing interest for their astonishing ability to produce high-fidelity images from solely text inputs. Subsequent research efforts aim to exploit and apply their capabilities to real image editing. However, existing image-to-image methods are often inefficient, imprecise, and of limited versatility. They either require time-consuming fine-tuning, deviate unnecessarily strongly from the input image, and/or lack support for multiple, simultaneous edits. To address these issues, we introduce LEDITS++, an efficient yet versatile and precise textual image manipulation technique. LEDITS++‘s novel inversion approach requires no tuning nor optimization and produces high-fidelity results with a few diffusion steps. Second, our methodology supports multiple simultaneous edits and is architecture-agnostic. Third, we use a novel implicit masking technique that limits changes to relevant image regions. We propose the novel TEdBench++ benchmark as part of our exhaustive evaluation. Our results demonstrate the capabilities of LEDITS++ and its improvements over previous methods. The project page is available at <a href="https://leditsplusplus-project.static.hf.space" rel="nofollow">https://leditsplusplus-project.static.hf.space</a> .</em>',je,X,Ne,U,Xe,A,Et="We provide two distinct pipelines based on different pre-trained models.",Ue,V,Je,x,F,Ke,fe,It="Pipeline for textual image editing using LEDits++ with Stable Diffusion.",et,me,Mt=`This model inherits from <a href="/docs/diffusers/pr_10005/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_10005/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Check the superclass
documentation for the generic methods implemented for all pipelines (downloading, saving, running on a particular
device, etc.).`,tt,M,H,nt,ue,$t=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusion.invert">invert()</a> method has to be called beforehand. Edits will
always be performed for the last inverted image(s).`,it,J,ot,z,Q,st,ge,Ct=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,at,B,Y,rt,_e,jt="Encodes the prompt into text encoder hidden states.",ze,K,Be,c,ee,dt,he,Nt="Pipeline for textual image editing using LEDits++ with Stable Diffusion XL.",lt,be,Xt=`This model inherits from <a href="/docs/diffusers/pr_10005/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_10005/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>. Check the
superclass documentation for the generic methods implemented for all pipelines (downloading, saving, running on a
particular device, etc.).`,pt,Pe,Ut="In addition the pipeline inherits the following loading methods:",ct,ve,Jt='<li><em>LoRA</em>: <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">LEditsPPPipelineStableDiffusionXL.load_lora_weights()</a></li> <li><em>Ckpt</em>: <a href="/docs/diffusers/pr_10005/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a></li>',ft,Le,zt="as well as the following saving methods:",mt,we,Bt="<li><em>LoRA</em>: <code>loaders.StableDiffusionXLPipeline.save_lora_weights</code></li>",ut,$,te,gt,ye,Gt=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusionXL.invert">invert()</a> method has to be called beforehand. Edits
will always be performed for the last inverted image(s).`,_t,G,ht,W,ne,bt,xe,Wt=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,Pt,Z,ie,vt,De,Zt="Encodes the prompt into text encoder hidden states.",Lt,O,oe,wt,Te,Ot='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ge,se,We,C,ae,yt,ke,Rt="Output class for LEdits++ Diffusion pipelines.",Ze,re,Oe,j,de,xt,Se,qt="Output class for LEdits++ Diffusion pipelines.",Re,le,qe,Ie,Ae;return y=new Me({props:{title:"LEDITS++",local:"ledits",headingTag:"h1"}}),X=new At({props:{$$slots:{default:[sn]},$$scope:{ctx:I}}}),U=new At({props:{warning:!0,$$slots:{default:[an]},$$scope:{ctx:I}}}),V=new Me({props:{title:"LEditsPPPipelineStableDiffusion",local:"diffusers.LEditsPPPipelineStableDiffusion",headingTag:"h2"}}),F=new E({props:{name:"class diffusers.LEditsPPPipelineStableDiffusion",anchor:"diffusers.LEditsPPPipelineStableDiffusion",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler]"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10005/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10005/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please, refer to the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">model card</a> for details.`,name:"safety_checker"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L262"}}),H=new E({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__",parameters:[{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"editing_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"reverse_editing_direction",val:": typing.Union[bool, typing.List[bool], NoneType] = False"},{name:"edit_guidance_scale",val:": typing.Union[float, typing.List[float], NoneType] = 5"},{name:"edit_warmup_steps",val:": typing.Union[int, typing.List[int], NoneType] = 0"},{name:"edit_cooldown_steps",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"edit_threshold",val:": typing.Union[float, typing.List[float], NoneType] = 0.9"},{name:"user_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sem_guidance",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = True"},{name:"attn_store_steps",val:": typing.Optional[typing.List[int]] = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput">LEditsPPDiffusionPipelineOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor&gt;</code>, <em>optional</em>) &#x2014;
Pre-computed embeddings to use for guiding the image generation. Guidance direction of embedding should
be specified via <code>reverse_editing_direction</code>.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance will not be applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance will no longer be applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.user_mask",description:`<strong>user_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.`,name:"user_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_cross_attn_mask",description:`<strong>use_cross_attn_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.`,name:"use_cross_attn_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_intersect_mask",description:`<strong>use_intersect_mask</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.`,name:"use_intersect_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.attn_store_steps",description:`<strong>attn_store_steps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.`,name:"attn_store_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.store_averaged_over_steps",description:`<strong>store_averaged_over_steps</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"store_averaged_over_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L709",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),J=new Vt({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.example",$$slots:{default:[rn]},$$scope:{ctx:I}}}),Q=new E({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:": float = 3.5"},{name:"num_inversion_steps",val:": int = 30"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"resize_mode",val:": typing.Optional[str] = 'default'"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The height in preprocessed image. If <code>None</code>, will use the <code>get_default_height_width()</code> to get default
height.`,name:"height"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.width",description:"<strong>width</strong> (<code>int</code>, <em>optional</em><code>, defaults to </code>None<code>) -- The width in preprocessed. If </code>None<code>, will use get_default_height_width()</code> to get the default width.",name:"width"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit within
the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>, will
resize the image to fit within the specified width and height, maintaining the aspect ratio, and then
center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize the
image to fit within the specified width and height, maintaining the aspect ratio, and then center the
image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.crops_coords",description:`<strong>crops_coords</strong> (<code>List[Tuple[int, int, int, int]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The crop coordinates for each image in the batch. If <code>None</code>, will not crop the image.`,name:"crops_coords"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L1210",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),Y=new E({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt",parameters:[{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"enable_edit_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"editing_prompt",val:" = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
whether to perform any editing or reconstruct the input image instead`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined, one has to pass <code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L510"}}),K=new Me({props:{title:"LEditsPPPipelineStableDiffusionXL",local:"diffusers.LEditsPPPipelineStableDiffusionXL",headingTag:"h2"}}),ee=new E({props:{name:"class diffusers.LEditsPPPipelineStableDiffusionXL",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler, diffusers.schedulers.scheduling_ddim.DDIMScheduler]"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10005/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10005/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10005/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L281"}}),te=new E({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__",parameters:[{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"editing_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"editing_prompt_embeddings",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"reverse_editing_direction",val:": typing.Union[bool, typing.List[bool], NoneType] = False"},{name:"edit_guidance_scale",val:": typing.Union[float, typing.List[float], NoneType] = 5"},{name:"edit_warmup_steps",val:": typing.Union[int, typing.List[int], NoneType] = 0"},{name:"edit_cooldown_steps",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"edit_threshold",val:": typing.Union[float, typing.List[float], NoneType] = 0.9"},{name:"sem_guidance",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = False"},{name:"user_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"attn_store_steps",val:": typing.Optional[typing.List[int]] = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in [**Refining the Image`,name:"denoising_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt_embeddings",description:`<strong>editing_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input argument.`,name:"editing_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_pooled_prompt_embeddings",description:`<strong>editing_pooled_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input
argument.`,name:"editing_pooled_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance is not applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance is no longer applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.use_cross_attn_mask",description:`<strong>use_cross_attn_mask</strong> &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.`,name:"use_cross_attn_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.use_intersect_mask",description:`<strong>use_intersect_mask</strong> &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.`,name:"use_intersect_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.user_mask",description:`<strong>user_mask</strong> &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.`,name:"user_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.attn_store_steps",description:`<strong>attn_store_steps</strong> &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.`,name:"attn_store_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.store_averaged_over_steps",description:`<strong>store_averaged_over_steps</strong> &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"store_averaged_over_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L796",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a \`tuple. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Vt({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.example",$$slots:{default:[dn]},$$scope:{ctx:I}}}),ne=new E({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:" = 3.5"},{name:"negative_prompt",val:": str = None"},{name:"negative_prompt_2",val:": str = None"},{name:"num_inversion_steps",val:": int = 50"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"num_zero_noise_steps",val:": int = 3"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_zero_noise_steps",description:`<strong>num_zero_noise_steps</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
Number of final diffusion steps that will not renoise the current image. If no steps are set to zero
SD-XL in combination with <a href="/docs/diffusers/pr_10005/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> will produce noise artifacts.`,name:"num_zero_noise_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L1428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10005/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),ie=new E({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt",parameters:[{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"enable_edit_guidance",val:": bool = True"},{name:"editing_prompt",val:": typing.Optional[str] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead.`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
Whether to guide towards an editing prompt or not.`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined and &#x2018;enable_edit_guidance&#x2019; is True, one has to pass
<code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided and &#x2018;enable_edit_guidance&#x2019; is True, editing_prompt_embeds will be generated from
<code>editing_prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_pooled_prompt_embeds",description:`<strong>editing_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled editing_pooled_prompt_embeds will be generated from <code>editing_prompt</code>
input argument.`,name:"editing_pooled_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L404"}}),oe=new E({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L710",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),se=new Me({props:{title:"LEditsPPDiffusionPipelineOutput",local:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",headingTag:"h2"}}),ae=new E({props:{name:"class diffusers.pipelines.LEditsPPDiffusionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L10"}}),re=new Me({props:{title:"LEditsPPInversionPipelineOutput",local:"diffusers.pipelines.LEditsPPInversionPipelineOutput",headingTag:"h2"}}),de=new E({props:{name:"class diffusers.pipelines.LEditsPPInversionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"vae_reconstruction_images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.input_images",description:`<strong>input_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of the cropped and resized input images as PIL images of length <code>batch_size</code> or NumPy array of shape <code> (batch_size, height, width, num_channels)</code>.`,name:"input_images"},{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.vae_reconstruction_images",description:`<strong>vae_reconstruction_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of VAE reconstruction of all input images as PIL images of length <code>batch_size</code> or NumPy array of shape
<code> (batch_size, height, width, num_channels)</code>.`,name:"vae_reconstruction_images"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L28"}}),le=new on({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ledits_pp.md"}}),{c(){a=r("meta"),w=o(),m=r("p"),v=o(),u(y.$$.fragment),l=o(),D=r("p"),D.innerHTML=Tt,$e=o(),R=r("p"),R.textContent=kt,Ce=o(),q=r("p"),q.innerHTML=St,je=o(),u(X.$$.fragment),Ne=o(),u(U.$$.fragment),Xe=o(),A=r("p"),A.textContent=Et,Ue=o(),u(V.$$.fragment),Je=o(),x=r("div"),u(F.$$.fragment),Ke=o(),fe=r("p"),fe.textContent=It,et=o(),me=r("p"),me.innerHTML=Mt,tt=o(),M=r("div"),u(H.$$.fragment),nt=o(),ue=r("p"),ue.innerHTML=$t,it=o(),u(J.$$.fragment),ot=o(),z=r("div"),u(Q.$$.fragment),st=o(),ge=r("p"),ge.innerHTML=Ct,at=o(),B=r("div"),u(Y.$$.fragment),rt=o(),_e=r("p"),_e.textContent=jt,ze=o(),u(K.$$.fragment),Be=o(),c=r("div"),u(ee.$$.fragment),dt=o(),he=r("p"),he.textContent=Nt,lt=o(),be=r("p"),be.innerHTML=Xt,pt=o(),Pe=r("p"),Pe.textContent=Ut,ct=o(),ve=r("ul"),ve.innerHTML=Jt,ft=o(),Le=r("p"),Le.textContent=zt,mt=o(),we=r("ul"),we.innerHTML=Bt,ut=o(),$=r("div"),u(te.$$.fragment),gt=o(),ye=r("p"),ye.innerHTML=Gt,_t=o(),u(G.$$.fragment),ht=o(),W=r("div"),u(ne.$$.fragment),bt=o(),xe=r("p"),xe.innerHTML=Wt,Pt=o(),Z=r("div"),u(ie.$$.fragment),vt=o(),De=r("p"),De.textContent=Zt,Lt=o(),O=r("div"),u(oe.$$.fragment),wt=o(),Te=r("p"),Te.innerHTML=Ot,Ge=o(),u(se.$$.fragment),We=o(),C=r("div"),u(ae.$$.fragment),yt=o(),ke=r("p"),ke.textContent=Rt,Ze=o(),u(re.$$.fragment),Oe=o(),j=r("div"),u(de.$$.fragment),xt=o(),Se=r("p"),Se.textContent=qt,Re=o(),u(le.$$.fragment),qe=o(),Ie=r("p"),this.h()},l(e){const i=en("svelte-u9bgzb",document.head);a=d(i,"META",{name:!0,content:!0}),i.forEach(n),w=s(e),m=d(e,"P",{}),k(m).forEach(n),v=s(e),g(y.$$.fragment,e),l=s(e),D=d(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-ke65yv"&&(D.innerHTML=Tt),$e=s(e),R=d(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1cwsb16"&&(R.textContent=kt),Ce=s(e),q=d(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-1jncrmh"&&(q.innerHTML=St),je=s(e),g(X.$$.fragment,e),Ne=s(e),g(U.$$.fragment,e),Xe=s(e),A=d(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-1qwf4p0"&&(A.textContent=Et),Ue=s(e),g(V.$$.fragment,e),Je=s(e),x=d(e,"DIV",{class:!0});var T=k(x);g(F.$$.fragment,T),Ke=s(T),fe=d(T,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-i87xsw"&&(fe.textContent=It),et=s(T),me=d(T,"P",{"data-svelte-h":!0}),f(me)!=="svelte-hfnj5j"&&(me.innerHTML=Mt),tt=s(T),M=d(T,"DIV",{class:!0});var N=k(M);g(H.$$.fragment,N),nt=s(N),ue=d(N,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-ew2a8v"&&(ue.innerHTML=$t),it=s(N),g(J.$$.fragment,N),N.forEach(n),ot=s(T),z=d(T,"DIV",{class:!0});var pe=k(z);g(Q.$$.fragment,pe),st=s(pe),ge=d(pe,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1cww0at"&&(ge.innerHTML=Ct),pe.forEach(n),at=s(T),B=d(T,"DIV",{class:!0});var ce=k(B);g(Y.$$.fragment,ce),rt=s(ce),_e=d(ce,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-16q0ax1"&&(_e.textContent=jt),ce.forEach(n),T.forEach(n),ze=s(e),g(K.$$.fragment,e),Be=s(e),c=d(e,"DIV",{class:!0});var L=k(c);g(ee.$$.fragment,L),dt=s(L),he=d(L,"P",{"data-svelte-h":!0}),f(he)!=="svelte-ojahy4"&&(he.textContent=Nt),lt=s(L),be=d(L,"P",{"data-svelte-h":!0}),f(be)!=="svelte-gqdq5j"&&(be.innerHTML=Xt),pt=s(L),Pe=d(L,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-984r3o"&&(Pe.textContent=Ut),ct=s(L),ve=d(L,"UL",{"data-svelte-h":!0}),f(ve)!=="svelte-1xn8mx8"&&(ve.innerHTML=Jt),ft=s(L),Le=d(L,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-19qtqre"&&(Le.textContent=zt),mt=s(L),we=d(L,"UL",{"data-svelte-h":!0}),f(we)!=="svelte-1tez18v"&&(we.innerHTML=Bt),ut=s(L),$=d(L,"DIV",{class:!0});var Ee=k($);g(te.$$.fragment,Ee),gt=s(Ee),ye=d(Ee,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-h32isr"&&(ye.innerHTML=Gt),_t=s(Ee),g(G.$$.fragment,Ee),Ee.forEach(n),ht=s(L),W=d(L,"DIV",{class:!0});var Ve=k(W);g(ne.$$.fragment,Ve),bt=s(Ve),xe=d(Ve,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1cww0at"&&(xe.innerHTML=Wt),Ve.forEach(n),Pt=s(L),Z=d(L,"DIV",{class:!0});var Fe=k(Z);g(ie.$$.fragment,Fe),vt=s(Fe),De=d(Fe,"P",{"data-svelte-h":!0}),f(De)!=="svelte-16q0ax1"&&(De.textContent=Zt),Fe.forEach(n),Lt=s(L),O=d(L,"DIV",{class:!0});var He=k(O);g(oe.$$.fragment,He),wt=s(He),Te=d(He,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-vo59ec"&&(Te.innerHTML=Ot),He.forEach(n),L.forEach(n),Ge=s(e),g(se.$$.fragment,e),We=s(e),C=d(e,"DIV",{class:!0});var Qe=k(C);g(ae.$$.fragment,Qe),yt=s(Qe),ke=d(Qe,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-hu8uib"&&(ke.textContent=Rt),Qe.forEach(n),Ze=s(e),g(re.$$.fragment,e),Oe=s(e),j=d(e,"DIV",{class:!0});var Ye=k(j);g(de.$$.fragment,Ye),xt=s(Ye),Se=d(Ye,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-hu8uib"&&(Se.textContent=qt),Ye.forEach(n),Re=s(e),g(le.$$.fragment,e),qe=s(e),Ie=d(e,"P",{}),k(Ie).forEach(n),this.h()},h(){S(a,"name","hf:doc:metadata"),S(a,"content",pn),S(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,a),p(e,w,i),p(e,m,i),p(e,v,i),_(y,e,i),p(e,l,i),p(e,D,i),p(e,$e,i),p(e,R,i),p(e,Ce,i),p(e,q,i),p(e,je,i),_(X,e,i),p(e,Ne,i),_(U,e,i),p(e,Xe,i),p(e,A,i),p(e,Ue,i),_(V,e,i),p(e,Je,i),p(e,x,i),_(F,x,null),t(x,Ke),t(x,fe),t(x,et),t(x,me),t(x,tt),t(x,M),_(H,M,null),t(M,nt),t(M,ue),t(M,it),_(J,M,null),t(x,ot),t(x,z),_(Q,z,null),t(z,st),t(z,ge),t(x,at),t(x,B),_(Y,B,null),t(B,rt),t(B,_e),p(e,ze,i),_(K,e,i),p(e,Be,i),p(e,c,i),_(ee,c,null),t(c,dt),t(c,he),t(c,lt),t(c,be),t(c,pt),t(c,Pe),t(c,ct),t(c,ve),t(c,ft),t(c,Le),t(c,mt),t(c,we),t(c,ut),t(c,$),_(te,$,null),t($,gt),t($,ye),t($,_t),_(G,$,null),t(c,ht),t(c,W),_(ne,W,null),t(W,bt),t(W,xe),t(c,Pt),t(c,Z),_(ie,Z,null),t(Z,vt),t(Z,De),t(c,Lt),t(c,O),_(oe,O,null),t(O,wt),t(O,Te),p(e,Ge,i),_(se,e,i),p(e,We,i),p(e,C,i),_(ae,C,null),t(C,yt),t(C,ke),p(e,Ze,i),_(re,e,i),p(e,Oe,i),p(e,j,i),_(de,j,null),t(j,xt),t(j,Se),p(e,Re,i),_(le,e,i),p(e,qe,i),p(e,Ie,i),Ae=!0},p(e,[i]){const T={};i&2&&(T.$$scope={dirty:i,ctx:e}),X.$set(T);const N={};i&2&&(N.$$scope={dirty:i,ctx:e}),U.$set(N);const pe={};i&2&&(pe.$$scope={dirty:i,ctx:e}),J.$set(pe);const ce={};i&2&&(ce.$$scope={dirty:i,ctx:e}),G.$set(ce)},i(e){Ae||(h(y.$$.fragment,e),h(X.$$.fragment,e),h(U.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(G.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(le.$$.fragment,e),Ae=!0)},o(e){b(y.$$.fragment,e),b(X.$$.fragment,e),b(U.$$.fragment,e),b(V.$$.fragment,e),b(F.$$.fragment,e),b(H.$$.fragment,e),b(J.$$.fragment,e),b(Q.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(G.$$.fragment,e),b(ne.$$.fragment,e),b(ie.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(de.$$.fragment,e),b(le.$$.fragment,e),Ae=!1},d(e){e&&(n(w),n(m),n(v),n(l),n(D),n($e),n(R),n(Ce),n(q),n(je),n(Ne),n(Xe),n(A),n(Ue),n(Je),n(x),n(ze),n(Be),n(c),n(Ge),n(We),n(C),n(Ze),n(Oe),n(j),n(Re),n(qe),n(Ie)),n(a),P(y,e),P(X,e),P(U,e),P(V,e),P(F),P(H),P(J),P(Q),P(Y),P(K,e),P(ee),P(te),P(G),P(ne),P(ie),P(oe),P(se,e),P(ae),P(re,e),P(de),P(le,e)}}}const pn='{"title":"LEDITS++","local":"ledits","sections":[{"title":"LEditsPPPipelineStableDiffusion","local":"diffusers.LEditsPPPipelineStableDiffusion","sections":[],"depth":2},{"title":"LEditsPPPipelineStableDiffusionXL","local":"diffusers.LEditsPPPipelineStableDiffusionXL","sections":[],"depth":2},{"title":"LEditsPPDiffusionPipelineOutput","local":"diffusers.pipelines.LEditsPPDiffusionPipelineOutput","sections":[],"depth":2},{"title":"LEditsPPInversionPipelineOutput","local":"diffusers.pipelines.LEditsPPInversionPipelineOutput","sections":[],"depth":2}],"depth":1}';function cn(I){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends Yt{constructor(a){super(),Kt(this,a,cn,ln,Ht,{})}}export{Pn as component};
