import{s as zt,n as It,o as Et}from"../chunks/scheduler.0219f8bd.js";import{S as Nt,i as Rt,g as i,s as r,r as n,A as Qt,h as c,f as s,c as l,j as d,u as m,x as a,k as p,y as Bt,a as o,v as f,d as u,t as _,w as h}from"../chunks/index.f61edf3b.js";import{C as Dt}from"../chunks/CodeBlock.38e566ae.js";import{H as P,E as Zt}from"../chunks/EditOnGithub.48fa589f.js";function Yt(ut){let M,ce,le,ae,T,pe,$,ne,y,_t="Processors are used to prepare inputs (e.g., text, image or audio) for a model.",de,w,ht="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",me,g,fe,x,Mt='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..PretrainedProcessorOptions"><code>~PretrainedProcessorOptions</code></a> : <code>Object</code></li></ul></li></ul></li>',ue,_e,he,b,Me,j,Pe,J,Pt="Represents a Processor that extracts features from an input.",Te,v,Tt='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',$e,H,$t='<li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li>',ye,we,ge,C,xe,k,be,A,yt="Creates a new Processor with the given components",je,L,wt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td> </tr><tr><td>components</td><td><code>Record.&lt;string, Object&gt;</code></td></tr></tbody>",Je,ve,He,U,Ce,z,ke,I,gt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image processor of the processor, if it exists.',Ae,Le,Ue,E,ze,N,Ie,R,xt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The tokenizer of the processor, if it exists.',Ee,Ne,Re,Q,Qe,B,Be,D,bt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The feature extractor of the processor, if it exists.',De,Ze,Ye,Z,Xe,Y,Oe,X,jt="Calls the feature_extractor function with the given input.",Ge,O,Jt='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',We,G,vt="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Fe,Ke,Se,W,Ve,F,qe,K,Ht="Instantiate one of the processor classes of the library from a pretrained model.",et,S,Ct=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,tt,V,kt='<strong>Kind</strong>: static method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',st,q,At=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>PretrainedProcessorOptions</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,ot,rt,lt,ee,it,te,ct,se,Lt="Additional processor-specific properties.",at,oe,Ut='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',pt,nt,dt,re,mt,ie,ft;return $=new P({props:{title:"processors",local:"processors",headingTag:"h1"}}),g=new Dt({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFjb25zdCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWNvbnN0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">const</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),j=new P({props:{title:"processors.Processor",local:"processorsprocessor",headingTag:"h2"}}),k=new P({props:{title:"new Processor(config, components)",local:"new-processorconfig-components",headingTag:"h3"}}),z=new P({props:{title:"processor.image_processor ⇒ <code> * </code>",local:"processorimageprocessor--code--code",headingTag:"h3"}}),N=new P({props:{title:"processor.tokenizer ⇒ <code> * </code>",local:"processortokenizer--code--code",headingTag:"h3"}}),B=new P({props:{title:"processor.feature_extractor ⇒ <code> * </code>",local:"processorfeatureextractor--code--code",headingTag:"h3"}}),Y=new P({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),F=new P({props:{title:"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),te=new P({props:{title:"processors~PretrainedProcessorOptions : <code> Object </code>",local:"processorspretrainedprocessoroptions--code-object-code",headingTag:"h2"}}),re=new Zt({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){M=i("meta"),ce=r(),le=i("p"),ae=r(),T=i("a"),pe=r(),n($.$$.fragment),ne=r(),y=i("p"),y.textContent=_t,de=r(),w=i("p"),w.innerHTML=ht,me=r(),n(g.$$.fragment),fe=r(),x=i("ul"),x.innerHTML=Mt,ue=r(),_e=i("hr"),he=r(),b=i("a"),Me=r(),n(j.$$.fragment),Pe=r(),J=i("p"),J.textContent=Pt,Te=r(),v=i("p"),v.innerHTML=Tt,$e=r(),H=i("ul"),H.innerHTML=$t,ye=r(),we=i("hr"),ge=r(),C=i("a"),xe=r(),n(k.$$.fragment),be=r(),A=i("p"),A.textContent=yt,je=r(),L=i("table"),L.innerHTML=wt,Je=r(),ve=i("hr"),He=r(),U=i("a"),Ce=r(),n(z.$$.fragment),ke=r(),I=i("p"),I.innerHTML=gt,Ae=r(),Le=i("hr"),Ue=r(),E=i("a"),ze=r(),n(N.$$.fragment),Ie=r(),R=i("p"),R.innerHTML=xt,Ee=r(),Ne=i("hr"),Re=r(),Q=i("a"),Qe=r(),n(B.$$.fragment),Be=r(),D=i("p"),D.innerHTML=bt,De=r(),Ze=i("hr"),Ye=r(),Z=i("a"),Xe=r(),n(Y.$$.fragment),Oe=r(),X=i("p"),X.textContent=jt,Ge=r(),O=i("p"),O.innerHTML=Jt,We=r(),G=i("table"),G.innerHTML=vt,Fe=r(),Ke=i("hr"),Se=r(),W=i("a"),Ve=r(),n(F.$$.fragment),qe=r(),K=i("p"),K.textContent=Ht,et=r(),S=i("p"),S.innerHTML=Ct,tt=r(),V=i("p"),V.innerHTML=kt,st=r(),q=i("table"),q.innerHTML=At,ot=r(),rt=i("hr"),lt=r(),ee=i("a"),it=r(),n(te.$$.fragment),ct=r(),se=i("p"),se.textContent=Lt,at=r(),oe=i("p"),oe.innerHTML=Ut,pt=r(),nt=i("hr"),dt=r(),n(re.$$.fragment),mt=r(),ie=i("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);M=c(t,"META",{name:!0,content:!0}),t.forEach(s),ce=l(e),le=c(e,"P",{}),d(le).forEach(s),ae=l(e),T=c(e,"A",{id:!0,class:!0}),d(T).forEach(s),pe=l(e),m($.$$.fragment,e),ne=l(e),y=c(e,"P",{"data-svelte-h":!0}),a(y)!=="svelte-199vh5q"&&(y.textContent=_t),de=l(e),w=c(e,"P",{"data-svelte-h":!0}),a(w)!=="svelte-1olsie5"&&(w.innerHTML=ht),me=l(e),m(g.$$.fragment,e),fe=l(e),x=c(e,"UL",{"data-svelte-h":!0}),a(x)!=="svelte-d99a57"&&(x.innerHTML=Mt),ue=l(e),_e=c(e,"HR",{}),he=l(e),b=c(e,"A",{id:!0,class:!0}),d(b).forEach(s),Me=l(e),m(j.$$.fragment,e),Pe=l(e),J=c(e,"P",{"data-svelte-h":!0}),a(J)!=="svelte-o9f953"&&(J.textContent=Pt),Te=l(e),v=c(e,"P",{"data-svelte-h":!0}),a(v)!=="svelte-wmyz1o"&&(v.innerHTML=Tt),$e=l(e),H=c(e,"UL",{"data-svelte-h":!0}),a(H)!=="svelte-5zmz6k"&&(H.innerHTML=$t),ye=l(e),we=c(e,"HR",{}),ge=l(e),C=c(e,"A",{id:!0,class:!0}),d(C).forEach(s),xe=l(e),m(k.$$.fragment,e),be=l(e),A=c(e,"P",{"data-svelte-h":!0}),a(A)!=="svelte-rj7jmq"&&(A.textContent=yt),je=l(e),L=c(e,"TABLE",{"data-svelte-h":!0}),a(L)!=="svelte-4j8lfj"&&(L.innerHTML=wt),Je=l(e),ve=c(e,"HR",{}),He=l(e),U=c(e,"A",{id:!0,class:!0}),d(U).forEach(s),Ce=l(e),m(z.$$.fragment,e),ke=l(e),I=c(e,"P",{"data-svelte-h":!0}),a(I)!=="svelte-gyqxdz"&&(I.innerHTML=gt),Ae=l(e),Le=c(e,"HR",{}),Ue=l(e),E=c(e,"A",{id:!0,class:!0}),d(E).forEach(s),ze=l(e),m(N.$$.fragment,e),Ie=l(e),R=c(e,"P",{"data-svelte-h":!0}),a(R)!=="svelte-mxp6mr"&&(R.innerHTML=xt),Ee=l(e),Ne=c(e,"HR",{}),Re=l(e),Q=c(e,"A",{id:!0,class:!0}),d(Q).forEach(s),Qe=l(e),m(B.$$.fragment,e),Be=l(e),D=c(e,"P",{"data-svelte-h":!0}),a(D)!=="svelte-iz9woy"&&(D.innerHTML=bt),De=l(e),Ze=c(e,"HR",{}),Ye=l(e),Z=c(e,"A",{id:!0,class:!0}),d(Z).forEach(s),Xe=l(e),m(Y.$$.fragment,e),Oe=l(e),X=c(e,"P",{"data-svelte-h":!0}),a(X)!=="svelte-zbbm3j"&&(X.textContent=jt),Ge=l(e),O=c(e,"P",{"data-svelte-h":!0}),a(O)!=="svelte-kflsb2"&&(O.innerHTML=Jt),We=l(e),G=c(e,"TABLE",{"data-svelte-h":!0}),a(G)!=="svelte-pm1u9z"&&(G.innerHTML=vt),Fe=l(e),Ke=c(e,"HR",{}),Se=l(e),W=c(e,"A",{id:!0,class:!0}),d(W).forEach(s),Ve=l(e),m(F.$$.fragment,e),qe=l(e),K=c(e,"P",{"data-svelte-h":!0}),a(K)!=="svelte-jwfdp9"&&(K.textContent=Ht),et=l(e),S=c(e,"P",{"data-svelte-h":!0}),a(S)!=="svelte-t85gxq"&&(S.innerHTML=Ct),tt=l(e),V=c(e,"P",{"data-svelte-h":!0}),a(V)!=="svelte-vp40qx"&&(V.innerHTML=kt),st=l(e),q=c(e,"TABLE",{"data-svelte-h":!0}),a(q)!=="svelte-fupyjd"&&(q.innerHTML=At),ot=l(e),rt=c(e,"HR",{}),lt=l(e),ee=c(e,"A",{id:!0,class:!0}),d(ee).forEach(s),it=l(e),m(te.$$.fragment,e),ct=l(e),se=c(e,"P",{"data-svelte-h":!0}),a(se)!=="svelte-ivm759"&&(se.textContent=Lt),at=l(e),oe=c(e,"P",{"data-svelte-h":!0}),a(oe)!=="svelte-3xndnt"&&(oe.innerHTML=Ut),pt=l(e),nt=c(e,"HR",{}),dt=l(e),m(re.$$.fragment,e),mt=l(e),ie=c(e,"P",{}),d(ie).forEach(s),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",Xt),p(T,"id","module_processors"),p(T,"class","group"),p(b,"id","module_processors.Processor"),p(b,"class","group"),p(C,"id","new_module_processors.Processor_new"),p(C,"class","group"),p(U,"id","module_processors.Processor+image_processor"),p(U,"class","group"),p(E,"id","module_processors.Processor+tokenizer"),p(E,"class","group"),p(Q,"id","module_processors.Processor+feature_extractor"),p(Q,"class","group"),p(Z,"id","module_processors.Processor+_call"),p(Z,"class","group"),p(W,"id","module_processors.Processor.from_pretrained"),p(W,"class","group"),p(ee,"id","module_processors..PretrainedProcessorOptions"),p(ee,"class","group")},m(e,t){Bt(document.head,M),o(e,ce,t),o(e,le,t),o(e,ae,t),o(e,T,t),o(e,pe,t),f($,e,t),o(e,ne,t),o(e,y,t),o(e,de,t),o(e,w,t),o(e,me,t),f(g,e,t),o(e,fe,t),o(e,x,t),o(e,ue,t),o(e,_e,t),o(e,he,t),o(e,b,t),o(e,Me,t),f(j,e,t),o(e,Pe,t),o(e,J,t),o(e,Te,t),o(e,v,t),o(e,$e,t),o(e,H,t),o(e,ye,t),o(e,we,t),o(e,ge,t),o(e,C,t),o(e,xe,t),f(k,e,t),o(e,be,t),o(e,A,t),o(e,je,t),o(e,L,t),o(e,Je,t),o(e,ve,t),o(e,He,t),o(e,U,t),o(e,Ce,t),f(z,e,t),o(e,ke,t),o(e,I,t),o(e,Ae,t),o(e,Le,t),o(e,Ue,t),o(e,E,t),o(e,ze,t),f(N,e,t),o(e,Ie,t),o(e,R,t),o(e,Ee,t),o(e,Ne,t),o(e,Re,t),o(e,Q,t),o(e,Qe,t),f(B,e,t),o(e,Be,t),o(e,D,t),o(e,De,t),o(e,Ze,t),o(e,Ye,t),o(e,Z,t),o(e,Xe,t),f(Y,e,t),o(e,Oe,t),o(e,X,t),o(e,Ge,t),o(e,O,t),o(e,We,t),o(e,G,t),o(e,Fe,t),o(e,Ke,t),o(e,Se,t),o(e,W,t),o(e,Ve,t),f(F,e,t),o(e,qe,t),o(e,K,t),o(e,et,t),o(e,S,t),o(e,tt,t),o(e,V,t),o(e,st,t),o(e,q,t),o(e,ot,t),o(e,rt,t),o(e,lt,t),o(e,ee,t),o(e,it,t),f(te,e,t),o(e,ct,t),o(e,se,t),o(e,at,t),o(e,oe,t),o(e,pt,t),o(e,nt,t),o(e,dt,t),f(re,e,t),o(e,mt,t),o(e,ie,t),ft=!0},p:It,i(e){ft||(u($.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(te.$$.fragment,e),u(re.$$.fragment,e),ft=!0)},o(e){_($.$$.fragment,e),_(g.$$.fragment,e),_(j.$$.fragment,e),_(k.$$.fragment,e),_(z.$$.fragment,e),_(N.$$.fragment,e),_(B.$$.fragment,e),_(Y.$$.fragment,e),_(F.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),ft=!1},d(e){e&&(s(ce),s(le),s(ae),s(T),s(pe),s(ne),s(y),s(de),s(w),s(me),s(fe),s(x),s(ue),s(_e),s(he),s(b),s(Me),s(Pe),s(J),s(Te),s(v),s($e),s(H),s(ye),s(we),s(ge),s(C),s(xe),s(be),s(A),s(je),s(L),s(Je),s(ve),s(He),s(U),s(Ce),s(ke),s(I),s(Ae),s(Le),s(Ue),s(E),s(ze),s(Ie),s(R),s(Ee),s(Ne),s(Re),s(Q),s(Qe),s(Be),s(D),s(De),s(Ze),s(Ye),s(Z),s(Xe),s(Oe),s(X),s(Ge),s(O),s(We),s(G),s(Fe),s(Ke),s(Se),s(W),s(Ve),s(qe),s(K),s(et),s(S),s(tt),s(V),s(st),s(q),s(ot),s(rt),s(lt),s(ee),s(it),s(ct),s(se),s(at),s(oe),s(pt),s(nt),s(dt),s(mt),s(ie)),s(M),h($,e),h(g,e),h(j,e),h(k,e),h(z,e),h(N,e),h(B,e),h(Y,e),h(F,e),h(te,e),h(re,e)}}}const Xt='{"title":"processors","local":"processors","sections":[{"title":"processors.Processor","local":"processorsprocessor","sections":[{"title":"new Processor(config, components)","local":"new-processorconfig-components","sections":[],"depth":3},{"title":"processor.image_processor ⇒ <code> * </code>","local":"processorimageprocessor--code--code","sections":[],"depth":3},{"title":"processor.tokenizer ⇒ <code> * </code>","local":"processortokenizer--code--code","sections":[],"depth":3},{"title":"processor.feature_extractor ⇒ <code> * </code>","local":"processorfeatureextractor--code--code","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3},{"title":"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~PretrainedProcessorOptions : <code> Object </code>","local":"processorspretrainedprocessoroptions--code-object-code","sections":[],"depth":2}],"depth":1}';function Ot(ut){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Nt{constructor(M){super(),Rt(this,M,Ot,Yt,zt,{})}}export{St as component};
