import{s as vn,o as Jn,n as St}from"../chunks/scheduler.8c3d61f6.js";import{S as Un,i as Pn,g as l,s as o,r as m,A as xn,h as r,f as n,c as s,j,u as g,x as b,k as S,y as c,a,v as u,d as f,t as _,w as h}from"../chunks/index.da70eac4.js";import{T as In}from"../chunks/Tip.1d9b8c37.js";import{D as N}from"../chunks/Docstring.6b390b9a.js";import{C as Qe}from"../chunks/CodeBlock.00a903b3.js";import{E as Ot}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as U,E as jn}from"../chunks/EditOnGithub.1e64e623.js";function Sn($){let d,v="There are some restrictions on data types that can be used with the Stable Cascade models. The official checkpoints for the  <code>StableCascadePriorPipeline</code> do not support the <code>torch.float16</code> data type. Please use <code>torch.bfloat16</code> instead.",w,p,C="In order to use the <code>torch.bfloat16</code> data type with the <code>StableCascadeDecoderPipeline</code> you need to have PyTorch 2.2.0 or higher installed. This also means that using the <code>StableCascadeCombinedPipeline</code> with <code>torch.bfloat16</code> requires PyTorch 2.2.0 or higher, since it calls the <code>StableCascadeDecoderPipeline</code> internally.",i,y,Xe="If it is not possible to install PyTorch 2.2.0 or higher in your environment, the <code>StableCascadeDecoderPipeline</code> can be used on its own with the <code>torch.float16</code> data type. You can download the full precision or <code>bf16</code> variant weights for the pipeline and cast the weights to <code>torch.float16</code>.";return{c(){d=l("p"),d.innerHTML=v,w=o(),p=l("p"),p.innerHTML=C,i=o(),y=l("p"),y.innerHTML=Xe},l(T){d=r(T,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1tw7sew"&&(d.innerHTML=v),w=s(T),p=r(T,"P",{"data-svelte-h":!0}),b(p)!=="svelte-szepwi"&&(p.innerHTML=C),i=s(T),y=r(T,"P",{"data-svelte-h":!0}),b(y)!=="svelte-jwlk0w"&&(y.innerHTML=Xe)},m(T,P){a(T,d,P),a(T,w,P),a(T,p,P),a(T,i,P),a(T,y,P)},p:St,d(T){T&&(n(d),n(w),n(p),n(i),n(y))}}}function $n($){let d,v="Examples:",w,p,C;return p=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlQ2FzY2FkZUNvbWJpbmVkUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZUNvbWJpbmVkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUlMjIlMkMlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeCombinedPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableCascadeCombinedPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt)`,wrap:!1}}),{c(){d=l("p"),d.textContent=v,w=o(),m(p.$$.fragment)},l(i){d=r(i,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=v),w=s(i),g(p.$$.fragment,i)},m(i,y){a(i,d,y),a(i,w,y),u(p,i,y),C=!0},p:St,i(i){C||(f(p.$$.fragment,i),C=!0)},o(i){_(p.$$.fragment,i),C=!1},d(i){i&&(n(d),n(w)),h(p,i)}}}function Zn($){let d,v="Examples:",w,p,C;return p=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlQ2FzY2FkZVByaW9yUGlwZWxpbmUlMEElMEFwcmlvcl9waXBlJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUtcHJpb3IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadePriorPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = StableCascadePriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)`,wrap:!1}}),{c(){d=l("p"),d.textContent=v,w=o(),m(p.$$.fragment)},l(i){d=r(i,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=v),w=s(i),g(p.$$.fragment,i)},m(i,y){a(i,d,y),a(i,w,y),u(p,i,y),C=!0},p:St,i(i){C||(f(p.$$.fragment,i),C=!0)},o(i){_(p.$$.fragment,i),C=!1},d(i){i&&(n(d),n(w)),h(p,i)}}}function kn($){let d,v="Examples:",w,p,C;return p=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlQ2FzY2FkZVByaW9yUGlwZWxpbmUlMkMlMjBTdGFibGVDYXNjYWRlRGVjb2RlclBpcGVsaW5lJTBBJTBBcHJpb3JfcGlwZSUyMCUzRCUyMFN0YWJsZUNhc2NhZGVQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1jYXNjYWRlLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5fcGlwZSUyMCUzRCUyMFN0YWJsZUNhc2NhZGVEZWNvZGVyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbiglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1jYXNjYWRlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQpJTBBaW1hZ2VzJTIwJTNEJTIwZ2VuX3BpcGUocHJpb3Jfb3V0cHV0LmltYWdlX2VtYmVkZGluZ3MlMkMlMjBwcm9tcHQlM0Rwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadePriorPipeline, StableCascadeDecoderPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = StableCascadePriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_pipe = StableCascadeDecoderPipeline.from_pretrain(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = gen_pipe(prior_output.image_embeddings, prompt=prompt)`,wrap:!1}}),{c(){d=l("p"),d.textContent=v,w=o(),m(p.$$.fragment)},l(i){d=r(i,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=v),w=s(i),g(p.$$.fragment,i)},m(i,y){a(i,d,y),a(i,w,y),u(p,i,y),C=!0},p:St,i(i){C||(f(p.$$.fragment,i),C=!0)},o(i){_(p.$$.fragment,i),C=!1},d(i){i&&(n(d),n(w)),h(p,i)}}}function Wn($){let d,v,w,p,C,i,y,Xe=`This model is built upon the <a href="https://openreview.net/forum?id=gU58d5QeGv" rel="nofollow">Würstchen</a> architecture and its main
difference to other models like Stable Diffusion is that it is working at a much smaller latent space. Why is this
important? The smaller the latent space, the <strong>faster</strong> you can run inference and the <strong>cheaper</strong> the training becomes.
How small is the latent space? Stable Diffusion uses a compression factor of 8, resulting in a 1024x1024 image being
encoded to 128x128. Stable Cascade achieves a compression factor of 42, meaning that it is possible to encode a
1024x1024 image to 24x24, while maintaining crisp reconstructions. The text-conditional model is then trained in the
highly compressed latent space. Previous versions of this architecture, achieved a 16x cost reduction over Stable
Diffusion 1.5.`,T,P,Kt=`Therefore, this kind of model is well suited for usages where efficiency is important. Furthermore, all known extensions
like finetuning, LoRA, ControlNet, IP-Adapter, LCM etc. are possible with this method as well.`,ze,X,en='The original codebase can be found at <a href="https://github.com/Stability-AI/StableCascade" rel="nofollow">Stability-AI/StableCascade</a>.',qe,F,Ae,z,tn=`Stable Cascade consists of three models: Stage A, Stage B and Stage C, representing a cascade to generate images,
hence the name “Stable Cascade”.`,Oe,q,nn=`Stage A & B are used to compress images, similar to what the job of the VAE is in Stable Diffusion.
However, with this setup, a much higher compression of images can be achieved. While the Stable Diffusion models use a
spatial compression factor of 8, encoding an image with resolution of 1024 x 1024 to 128 x 128, Stable Cascade achieves
a compression factor of 42. This encodes a 1024 x 1024 image to 24 x 24, while being able to accurately decode the
image. This comes with the great benefit of cheaper training and inference. Furthermore, Stage C is responsible
for generating the small 24 x 24 latents given a text prompt.`,Ke,A,an="The Stage C model operates on the small 24 x 24 latents and denoises the latents conditioned on text prompts. The model is also the largest component in the Cascade pipeline and is meant to be used with the <code>StableCascadePriorPipeline</code>",et,O,on="The Stage B and Stage A models are used with the <code>StableCascadeDecoderPipeline</code> and are responsible for generating the final image given the small 24 x 24 latents.",tt,V,nt,K,at,ee,ot,te,st,ne,it,ae,lt,oe,sn="Loading the original format checkpoints is supported via <code>from_single_file</code> method in the StableCascadeUNet.",rt,se,dt,ie,ct,le,pt,re,ln="The model is intended for research purposes for now. Possible research areas and tasks include",mt,de,rn="<li>Research on generative models.</li> <li>Safe deployment of models which have the potential to generate harmful content.</li> <li>Probing and understanding the limitations and biases of generative models.</li> <li>Generation of artworks and use in design and other artistic processes.</li> <li>Applications in educational or creative tools.</li>",gt,ce,dn="Excluded uses are described below.",ut,pe,ft,me,cn=`The model was not trained to be factual or true representations of people or events,
and therefore using the model to generate such content is out-of-scope for the abilities of this model.
The model should not be used in any way that violates Stability AI’s <a href="https://stability.ai/use-policy" rel="nofollow">Acceptable Use Policy</a>.`,_t,ge,ht,ue,bt,fe,pn="<li>Faces and people in general may not be generated properly.</li> <li>The autoencoding part of the model is lossy.</li>",yt,_e,wt,M,he,$t,$e,mn="Combined Pipeline for text-to-image generation using Stable Cascade.",Zt,Ze,gn=`This model inherits from <a href="/docs/diffusers/pr_10133/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,kt,Z,be,Wt,ke,un="Function invoked when calling the pipeline for generation.",Gt,Y,Bt,R,ye,Nt,We,fn=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Vt,L,we,Yt,Ge,_n=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,Ct,Ce,Tt,x,Te,Rt,Be,hn="Pipeline for generating image prior for Stable Cascade.",Lt,Ne,bn=`This model inherits from <a href="/docs/diffusers/pr_10133/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ht,k,Me,Dt,Ve,yn="Function invoked when calling the pipeline for generation.",Et,H,Mt,ve,vt,G,Je,Qt,Ye,wn="Output class for WuerstchenPriorPipeline.",Jt,Ue,Ut,I,Pe,Xt,Re,Cn="Pipeline for generating images from the Stable Cascade model.",Ft,Le,Tn=`This model inherits from <a href="/docs/diffusers/pr_10133/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,zt,W,xe,qt,He,Mn="Function invoked when calling the pipeline for generation.",At,D,Pt,Ie,xt,Fe,It;return C=new U({props:{title:"Stable Cascade",local:"stable-cascade",headingTag:"h1"}}),F=new U({props:{title:"Model Overview",local:"model-overview",headingTag:"h2"}}),V=new In({props:{warning:!0,$$slots:{default:[Sn]},$$scope:{ctx:$}}}),K=new U({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ee=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlQ2FzY2FkZURlY29kZXJQaXBlbGluZSUyQyUyMFN0YWJsZUNhc2NhZGVQcmlvclBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbWFnZSUyMG9mJTIwYSUyMHNoaWJhJTIwaW51JTJDJTIwZG9ubmluZyUyMGElMjBzcGFjZXN1aXQlMjBhbmQlMjBoZWxtZXQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjIlMjIlMEElMEFwcmlvciUyMCUzRCUyMFN0YWJsZUNhc2NhZGVQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1jYXNjYWRlLXByaW9yJTIyJTJDJTIwdmFyaWFudCUzRCUyMmJmMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQWRlY29kZXIlMjAlM0QlMjBTdGFibGVDYXNjYWRlRGVjb2RlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1jYXNjYWRlJTIyJTJDJTIwdmFyaWFudCUzRCUyMmJmMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcHJpb3IuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwcmlvcl9vdXRwdXQlMjAlM0QlMjBwcmlvciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTBBKSUwQSUwQWRlY29kZXIuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFkZWNvZGVyX291dHB1dCUyMCUzRCUyMGRlY29kZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRkaW5ncyUzRHByaW9yX291dHB1dC5pbWFnZV9lbWJlZGRpbmdzLnRvKHRvcmNoLmZsb2F0MTYpJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMnBpbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlY29kZXJfb3V0cHV0LnNhdmUoJTIyY2FzY2FkZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeDecoderPipeline, StableCascadePriorPipeline

prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior = StableCascadePriorPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16)
decoder = StableCascadeDecoderPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.float16)

prior.enable_model_cpu_offload()
prior_output = prior(
    prompt=prompt,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    num_inference_steps=<span class="hljs-number">20</span>
)

decoder.enable_model_cpu_offload()
decoder_output = decoder(
    image_embeddings=prior_output.image_embeddings.to(torch.float16),
    prompt=prompt,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">10</span>
).images[<span class="hljs-number">0</span>]
decoder_output.save(<span class="hljs-string">&quot;cascade.png&quot;</span>)`,wrap:!1}}),te=new U({props:{title:"Using the Lite Versions of the Stage B and Stage C models",local:"using-the-lite-versions-of-the-stage-b-and-stage-c-models",headingTag:"h2"}}),ne=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    StableCascadeDecoderPipeline,
    StableCascadePriorPipeline,
    StableCascadeUNet,
)

prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior_unet = StableCascadeUNet.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, subfolder=<span class="hljs-string">&quot;prior_lite&quot;</span>)
decoder_unet = StableCascadeUNet.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, subfolder=<span class="hljs-string">&quot;decoder_lite&quot;</span>)

prior = StableCascadePriorPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, prior=prior_unet)
decoder = StableCascadeDecoderPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, decoder=decoder_unet)

prior.enable_model_cpu_offload()
prior_output = prior(
    prompt=prompt,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    num_inference_steps=<span class="hljs-number">20</span>
)

decoder.enable_model_cpu_offload()
decoder_output = decoder(
    image_embeddings=prior_output.image_embeddings,
    prompt=prompt,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">10</span>
).images[<span class="hljs-number">0</span>]
decoder_output.save(<span class="hljs-string">&quot;cascade.png&quot;</span>)`,wrap:!1}}),ae=new U({props:{title:"Loading original checkpoints with from_single_file",local:"loading-original-checkpoints-with-fromsinglefile",headingTag:"h2"}}),se=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    StableCascadeDecoderPipeline,
    StableCascadePriorPipeline,
    StableCascadeUNet,
)

prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior_unet = StableCascadeUNet.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/resolve/main/stage_c_bf16.safetensors&quot;</span>,
    torch_dtype=torch.bfloat16
)
decoder_unet = StableCascadeUNet.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/blob/main/stage_b_bf16.safetensors&quot;</span>,
    torch_dtype=torch.bfloat16
)

prior = StableCascadePriorPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade-prior&quot;</span>, prior=prior_unet, torch_dtype=torch.bfloat16)
decoder = StableCascadeDecoderPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-cascade&quot;</span>, decoder=decoder_unet, torch_dtype=torch.bfloat16)

prior.enable_model_cpu_offload()
prior_output = prior(
    prompt=prompt,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    num_inference_steps=<span class="hljs-number">20</span>
)

decoder.enable_model_cpu_offload()
decoder_output = decoder(
    image_embeddings=prior_output.image_embeddings,
    prompt=prompt,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">10</span>
).images[<span class="hljs-number">0</span>]
decoder_output.save(<span class="hljs-string">&quot;cascade-single-file.png&quot;</span>)`,wrap:!1}}),ie=new U({props:{title:"Uses",local:"uses",headingTag:"h2"}}),le=new U({props:{title:"Direct Use",local:"direct-use",headingTag:"h3"}}),pe=new U({props:{title:"Out-of-Scope Use",local:"out-of-scope-use",headingTag:"h3"}}),ge=new U({props:{title:"Limitations and Bias",local:"limitations-and-bias",headingTag:"h2"}}),ue=new U({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),_e=new U({props:{title:"StableCascadeCombinedPipeline",local:"diffusers.StableCascadeCombinedPipeline",headingTag:"h2"}}),he=new N({props:{name:"class diffusers.StableCascadeCombinedPipeline",anchor:"diffusers.StableCascadeCombinedPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": StableCascadeUNet"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"prior_prior",val:": StableCascadeUNet"},{name:"prior_text_encoder",val:": CLIPTextModel"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": DDPMWuerstchenScheduler"},{name:"prior_feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"prior_image_encoder",val:": typing.Optional[transformers.models.clip.modeling_clip.CLIPVisionModelWithProjection] = None"}],parametersDescription:[{anchor:"diffusers.StableCascadeCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The decoder tokenizer to be used for text inputs.`,name:"tokenizer"},{anchor:"diffusers.StableCascadeCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The decoder text encoder to be used for text inputs.`,name:"text_encoder"},{anchor:"diffusers.StableCascadeCombinedPipeline.decoder",description:`<strong>decoder</strong> (<code>StableCascadeUNet</code>) &#x2014;
The decoder model to be used for decoder image generation pipeline.`,name:"decoder"},{anchor:"diffusers.StableCascadeCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for decoder image generation pipeline.`,name:"scheduler"},{anchor:"diffusers.StableCascadeCombinedPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model to be used for decoder image generation pipeline.`,name:"vqgan"},{anchor:"diffusers.StableCascadeCombinedPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>image_encoder</code>.`,name:"feature_extractor"},{anchor:"diffusers.StableCascadeCombinedPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen CLIP image-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"image_encoder"},{anchor:"diffusers.StableCascadeCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<code>StableCascadeUNet</code>) &#x2014;
The prior model to be used for prior pipeline.`,name:"prior_prior"},{anchor:"diffusers.StableCascadeCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for prior pipeline.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_combined.py#L45"}}),be=new N({props:{name:"__call__",anchor:"diffusers.StableCascadeCombinedPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"images",val:": typing.Union[torch.Tensor, PIL.Image.Image, typing.List[torch.Tensor], typing.List[PIL.Image.Image]] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_num_inference_steps",val:": int = 60"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"num_inference_steps",val:": int = 12"},{name:"decoder_guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation for the prior and decoder.`,name:"prompt"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.images",description:`<strong>images</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <em>optional</em>) &#x2014;
The images to guide the image generation for the prior.`,name:"images"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prompt_embeds_pooled",description:`<strong>prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds_pooled"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.negative_prompt_embeds_pooled",description:`<strong>negative_prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds_pooled"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>prior_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>prior_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked
to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>Union[int, Dict[float, int]]</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of prior denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. For more specific timestep spacing, you can pass customized
<code>prior_timesteps</code>`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of decoder denoising steps. More denoising steps usually lead to a higher quality image at
the expense of slower inference. For more specific timestep spacing, you can pass customized
<code>timesteps</code>`,name:"num_inference_steps"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.decoder_guidance_scale",description:`<strong>decoder_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"decoder_guidance_scale"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_combined.py#L152",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`}}),Y=new Ot({props:{anchor:"diffusers.StableCascadeCombinedPipeline.__call__.example",$$slots:{default:[$n]},$$scope:{ctx:$}}}),ye=new N({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableCascadeCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_combined.py#L124"}}),we=new N({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableCascadeCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_combined.py#L134"}}),Ce=new U({props:{title:"StableCascadePriorPipeline",local:"diffusers.StableCascadePriorPipeline",headingTag:"h2"}}),Te=new N({props:{name:"class diffusers.StableCascadePriorPipeline",anchor:"diffusers.StableCascadePriorPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": StableCascadeUNet"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"resolution_multiple",val:": float = 42.67"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"image_encoder",val:": typing.Optional[transformers.models.clip.modeling_clip.CLIPVisionModelWithProjection] = None"}],parametersDescription:[{anchor:"diffusers.StableCascadePriorPipeline.prior",description:`<strong>prior</strong> (<code>StableCascadeUNet</code>) &#x2014;
The Stable Cascade prior to approximate the image embedding from the text and/or image embedding.`,name:"prior"},{anchor:"diffusers.StableCascadePriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder"},{anchor:"diffusers.StableCascadePriorPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>image_encoder</code>.`,name:"feature_extractor"},{anchor:"diffusers.StableCascadePriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen CLIP image-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"image_encoder"},{anchor:"diffusers.StableCascadePriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableCascadePriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.StableCascadePriorPipeline.resolution_multiple",description:`<strong>resolution_multiple</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.67) &#x2014;
Default resolution for multiple images generated.`,name:"resolution_multiple"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_prior.py#L72"}}),Me=new N({props:{name:"__call__",anchor:"diffusers.StableCascadePriorPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"images",val:": typing.Union[torch.Tensor, PIL.Image.Image, typing.List[torch.Tensor], typing.List[PIL.Image.Image]] = None"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.StableCascadePriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.prompt_embeds_pooled",description:`<strong>prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds_pooled"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.negative_prompt_embeds_pooled",description:`<strong>negative_prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds_pooled will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds_pooled"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs, <em>e.g.</em> prompt weighting. If
not provided, image embeddings will be generated from <code>image</code> input argument if existing.`,name:"image_embeds"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableCascadePriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_prior.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StableCascadePriorPipelineOutput</code> or <code>tuple</code> <code>StableCascadePriorPipelineOutput</code> if <code>return_dict</code> is
True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated image
embeddings.</p>
`}}),H=new Ot({props:{anchor:"diffusers.StableCascadePriorPipeline.__call__.example",$$slots:{default:[Zn]},$$scope:{ctx:$}}}),ve=new U({props:{title:"StableCascadePriorPipelineOutput",local:"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput",headingTag:"h2"}}),Je=new N({props:{name:"class diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput",anchor:"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput",parameters:[{name:"image_embeddings",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"prompt_embeds",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"prompt_embeds_pooled",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"negative_prompt_embeds",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"negative_prompt_embeds_pooled",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
Prior image embeddings for text prompt`,name:"image_embeddings"},{anchor:"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>) &#x2014;
Text embeddings for the prompt.`,name:"prompt_embeds"},{anchor:"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>) &#x2014;
Text embeddings for the negative prompt.`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade_prior.py#L51"}}),Ue=new U({props:{title:"StableCascadeDecoderPipeline",local:"diffusers.StableCascadeDecoderPipeline",headingTag:"h2"}}),Pe=new N({props:{name:"class diffusers.StableCascadeDecoderPipeline",anchor:"diffusers.StableCascadeDecoderPipeline",parameters:[{name:"decoder",val:": StableCascadeUNet"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"latent_dim_scale",val:": float = 10.67"}],parametersDescription:[{anchor:"diffusers.StableCascadeDecoderPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableCascadeDecoderPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The CLIP text encoder.`,name:"text_encoder"},{anchor:"diffusers.StableCascadeDecoderPipeline.decoder",description:`<strong>decoder</strong> (<code>StableCascadeUNet</code>) &#x2014;
The Stable Cascade decoder unet.`,name:"decoder"},{anchor:"diffusers.StableCascadeDecoderPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model.`,name:"vqgan"},{anchor:"diffusers.StableCascadeDecoderPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.StableCascadeDecoderPipeline.latent_dim_scale",description:`<strong>latent_dim_scale</strong> (float, <code>optional</code>, defaults to 10.67) &#x2014;
Multiplier to determine the VQ latent space size from the image embeddings. If the image embeddings are
height=24 and width=24, the VQ latent shape needs to be height=int(24<em>10.67)=256 and
width=int(24</em>10.67)=256 in order to match the training conditions.`,name:"latent_dim_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade.py#L50"}}),xe=new N({props:{name:"__call__",anchor:"diffusers.StableCascadeDecoderPipeline.__call__",parameters:[{name:"image_embeddings",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"num_inference_steps",val:": int = 10"},{name:"guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_pooled",val:": typing.Optional[torch.Tensor] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.image_embedding",description:`<strong>image_embedding</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
Image Embeddings either extracted from an image or generated by a Prior Model.`,name:"image_embedding"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.prompt_embeds_pooled",description:`<strong>prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds_pooled"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.negative_prompt_embeds_pooled",description:`<strong>negative_prompt_embeds_pooled</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds_pooled will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds_pooled"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10133/src/diffusers/pipelines/stable_cascade/pipeline_stable_cascade.py#L294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/pr_10133/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated image
embeddings.</p>
`}}),D=new Ot({props:{anchor:"diffusers.StableCascadeDecoderPipeline.__call__.example",$$slots:{default:[kn]},$$scope:{ctx:$}}}),Ie=new jn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_cascade.md"}}),{c(){d=l("meta"),v=o(),w=l("p"),p=o(),m(C.$$.fragment),i=o(),y=l("p"),y.innerHTML=Xe,T=o(),P=l("p"),P.textContent=Kt,ze=o(),X=l("p"),X.innerHTML=en,qe=o(),m(F.$$.fragment),Ae=o(),z=l("p"),z.textContent=tn,Oe=o(),q=l("p"),q.textContent=nn,Ke=o(),A=l("p"),A.innerHTML=an,et=o(),O=l("p"),O.innerHTML=on,tt=o(),m(V.$$.fragment),nt=o(),m(K.$$.fragment),at=o(),m(ee.$$.fragment),ot=o(),m(te.$$.fragment),st=o(),m(ne.$$.fragment),it=o(),m(ae.$$.fragment),lt=o(),oe=l("p"),oe.innerHTML=sn,rt=o(),m(se.$$.fragment),dt=o(),m(ie.$$.fragment),ct=o(),m(le.$$.fragment),pt=o(),re=l("p"),re.textContent=ln,mt=o(),de=l("ul"),de.innerHTML=rn,gt=o(),ce=l("p"),ce.textContent=dn,ut=o(),m(pe.$$.fragment),ft=o(),me=l("p"),me.innerHTML=cn,_t=o(),m(ge.$$.fragment),ht=o(),m(ue.$$.fragment),bt=o(),fe=l("ul"),fe.innerHTML=pn,yt=o(),m(_e.$$.fragment),wt=o(),M=l("div"),m(he.$$.fragment),$t=o(),$e=l("p"),$e.textContent=mn,Zt=o(),Ze=l("p"),Ze.innerHTML=gn,kt=o(),Z=l("div"),m(be.$$.fragment),Wt=o(),ke=l("p"),ke.textContent=un,Gt=o(),m(Y.$$.fragment),Bt=o(),R=l("div"),m(ye.$$.fragment),Nt=o(),We=l("p"),We.innerHTML=fn,Vt=o(),L=l("div"),m(we.$$.fragment),Yt=o(),Ge=l("p"),Ge.innerHTML=_n,Ct=o(),m(Ce.$$.fragment),Tt=o(),x=l("div"),m(Te.$$.fragment),Rt=o(),Be=l("p"),Be.textContent=hn,Lt=o(),Ne=l("p"),Ne.innerHTML=bn,Ht=o(),k=l("div"),m(Me.$$.fragment),Dt=o(),Ve=l("p"),Ve.textContent=yn,Et=o(),m(H.$$.fragment),Mt=o(),m(ve.$$.fragment),vt=o(),G=l("div"),m(Je.$$.fragment),Qt=o(),Ye=l("p"),Ye.textContent=wn,Jt=o(),m(Ue.$$.fragment),Ut=o(),I=l("div"),m(Pe.$$.fragment),Xt=o(),Re=l("p"),Re.textContent=Cn,Ft=o(),Le=l("p"),Le.innerHTML=Tn,zt=o(),W=l("div"),m(xe.$$.fragment),qt=o(),He=l("p"),He.textContent=Mn,At=o(),m(D.$$.fragment),Pt=o(),m(Ie.$$.fragment),xt=o(),Fe=l("p"),this.h()},l(e){const t=xn("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),v=s(e),w=r(e,"P",{}),j(w).forEach(n),p=s(e),g(C.$$.fragment,e),i=s(e),y=r(e,"P",{"data-svelte-h":!0}),b(y)!=="svelte-58yed7"&&(y.innerHTML=Xe),T=s(e),P=r(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-pdgmnb"&&(P.textContent=Kt),ze=s(e),X=r(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1rol617"&&(X.innerHTML=en),qe=s(e),g(F.$$.fragment,e),Ae=s(e),z=r(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-13mtumf"&&(z.textContent=tn),Oe=s(e),q=r(e,"P",{"data-svelte-h":!0}),b(q)!=="svelte-1lpwfdo"&&(q.textContent=nn),Ke=s(e),A=r(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-nx9r15"&&(A.innerHTML=an),et=s(e),O=r(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-1r2fmf1"&&(O.innerHTML=on),tt=s(e),g(V.$$.fragment,e),nt=s(e),g(K.$$.fragment,e),at=s(e),g(ee.$$.fragment,e),ot=s(e),g(te.$$.fragment,e),st=s(e),g(ne.$$.fragment,e),it=s(e),g(ae.$$.fragment,e),lt=s(e),oe=r(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-vq9k87"&&(oe.innerHTML=sn),rt=s(e),g(se.$$.fragment,e),dt=s(e),g(ie.$$.fragment,e),ct=s(e),g(le.$$.fragment,e),pt=s(e),re=r(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-marzm0"&&(re.textContent=ln),mt=s(e),de=r(e,"UL",{"data-svelte-h":!0}),b(de)!=="svelte-1io3utn"&&(de.innerHTML=rn),gt=s(e),ce=r(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-usmk6k"&&(ce.textContent=dn),ut=s(e),g(pe.$$.fragment,e),ft=s(e),me=r(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-md3bci"&&(me.innerHTML=cn),_t=s(e),g(ge.$$.fragment,e),ht=s(e),g(ue.$$.fragment,e),bt=s(e),fe=r(e,"UL",{"data-svelte-h":!0}),b(fe)!=="svelte-1lgsa2f"&&(fe.innerHTML=pn),yt=s(e),g(_e.$$.fragment,e),wt=s(e),M=r(e,"DIV",{class:!0});var J=j(M);g(he.$$.fragment,J),$t=s(J),$e=r(J,"P",{"data-svelte-h":!0}),b($e)!=="svelte-zuq8la"&&($e.textContent=mn),Zt=s(J),Ze=r(J,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-1ty2ko3"&&(Ze.innerHTML=gn),kt=s(J),Z=r(J,"DIV",{class:!0});var B=j(Z);g(be.$$.fragment,B),Wt=s(B),ke=r(B,"P",{"data-svelte-h":!0}),b(ke)!=="svelte-v78lg8"&&(ke.textContent=un),Gt=s(B),g(Y.$$.fragment,B),B.forEach(n),Bt=s(J),R=r(J,"DIV",{class:!0});var je=j(R);g(ye.$$.fragment,je),Nt=s(je),We=r(je,"P",{"data-svelte-h":!0}),b(We)!=="svelte-d7vywi"&&(We.innerHTML=fn),je.forEach(n),Vt=s(J),L=r(J,"DIV",{class:!0});var Se=j(L);g(we.$$.fragment,Se),Yt=s(Se),Ge=r(Se,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-a2a0wt"&&(Ge.innerHTML=_n),Se.forEach(n),J.forEach(n),Ct=s(e),g(Ce.$$.fragment,e),Tt=s(e),x=r(e,"DIV",{class:!0});var E=j(x);g(Te.$$.fragment,E),Rt=s(E),Be=r(E,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-1k7c4ws"&&(Be.textContent=hn),Lt=s(E),Ne=r(E,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-1ty2ko3"&&(Ne.innerHTML=bn),Ht=s(E),k=r(E,"DIV",{class:!0});var De=j(k);g(Me.$$.fragment,De),Dt=s(De),Ve=r(De,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-v78lg8"&&(Ve.textContent=yn),Et=s(De),g(H.$$.fragment,De),De.forEach(n),E.forEach(n),Mt=s(e),g(ve.$$.fragment,e),vt=s(e),G=r(e,"DIV",{class:!0});var jt=j(G);g(Je.$$.fragment,jt),Qt=s(jt),Ye=r(jt,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-cw9h8a"&&(Ye.textContent=wn),jt.forEach(n),Jt=s(e),g(Ue.$$.fragment,e),Ut=s(e),I=r(e,"DIV",{class:!0});var Q=j(I);g(Pe.$$.fragment,Q),Xt=s(Q),Re=r(Q,"P",{"data-svelte-h":!0}),b(Re)!=="svelte-1bqijj8"&&(Re.textContent=Cn),Ft=s(Q),Le=r(Q,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-1ty2ko3"&&(Le.innerHTML=Tn),zt=s(Q),W=r(Q,"DIV",{class:!0});var Ee=j(W);g(xe.$$.fragment,Ee),qt=s(Ee),He=r(Ee,"P",{"data-svelte-h":!0}),b(He)!=="svelte-v78lg8"&&(He.textContent=Mn),At=s(Ee),g(D.$$.fragment,Ee),Ee.forEach(n),Q.forEach(n),Pt=s(e),g(Ie.$$.fragment,e),xt=s(e),Fe=r(e,"P",{}),j(Fe).forEach(n),this.h()},h(){S(d,"name","hf:doc:metadata"),S(d,"content",Gn),S(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,d),a(e,v,t),a(e,w,t),a(e,p,t),u(C,e,t),a(e,i,t),a(e,y,t),a(e,T,t),a(e,P,t),a(e,ze,t),a(e,X,t),a(e,qe,t),u(F,e,t),a(e,Ae,t),a(e,z,t),a(e,Oe,t),a(e,q,t),a(e,Ke,t),a(e,A,t),a(e,et,t),a(e,O,t),a(e,tt,t),u(V,e,t),a(e,nt,t),u(K,e,t),a(e,at,t),u(ee,e,t),a(e,ot,t),u(te,e,t),a(e,st,t),u(ne,e,t),a(e,it,t),u(ae,e,t),a(e,lt,t),a(e,oe,t),a(e,rt,t),u(se,e,t),a(e,dt,t),u(ie,e,t),a(e,ct,t),u(le,e,t),a(e,pt,t),a(e,re,t),a(e,mt,t),a(e,de,t),a(e,gt,t),a(e,ce,t),a(e,ut,t),u(pe,e,t),a(e,ft,t),a(e,me,t),a(e,_t,t),u(ge,e,t),a(e,ht,t),u(ue,e,t),a(e,bt,t),a(e,fe,t),a(e,yt,t),u(_e,e,t),a(e,wt,t),a(e,M,t),u(he,M,null),c(M,$t),c(M,$e),c(M,Zt),c(M,Ze),c(M,kt),c(M,Z),u(be,Z,null),c(Z,Wt),c(Z,ke),c(Z,Gt),u(Y,Z,null),c(M,Bt),c(M,R),u(ye,R,null),c(R,Nt),c(R,We),c(M,Vt),c(M,L),u(we,L,null),c(L,Yt),c(L,Ge),a(e,Ct,t),u(Ce,e,t),a(e,Tt,t),a(e,x,t),u(Te,x,null),c(x,Rt),c(x,Be),c(x,Lt),c(x,Ne),c(x,Ht),c(x,k),u(Me,k,null),c(k,Dt),c(k,Ve),c(k,Et),u(H,k,null),a(e,Mt,t),u(ve,e,t),a(e,vt,t),a(e,G,t),u(Je,G,null),c(G,Qt),c(G,Ye),a(e,Jt,t),u(Ue,e,t),a(e,Ut,t),a(e,I,t),u(Pe,I,null),c(I,Xt),c(I,Re),c(I,Ft),c(I,Le),c(I,zt),c(I,W),u(xe,W,null),c(W,qt),c(W,He),c(W,At),u(D,W,null),a(e,Pt,t),u(Ie,e,t),a(e,xt,t),a(e,Fe,t),It=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),V.$set(J);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),Y.$set(B);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),H.$set(je);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),D.$set(Se)},i(e){It||(f(C.$$.fragment,e),f(F.$$.fragment,e),f(V.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),f(Y.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Ce.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(H.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(Pe.$$.fragment,e),f(xe.$$.fragment,e),f(D.$$.fragment,e),f(Ie.$$.fragment,e),It=!0)},o(e){_(C.$$.fragment,e),_(F.$$.fragment,e),_(V.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(he.$$.fragment,e),_(be.$$.fragment,e),_(Y.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(Ce.$$.fragment,e),_(Te.$$.fragment,e),_(Me.$$.fragment,e),_(H.$$.fragment,e),_(ve.$$.fragment,e),_(Je.$$.fragment,e),_(Ue.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(D.$$.fragment,e),_(Ie.$$.fragment,e),It=!1},d(e){e&&(n(v),n(w),n(p),n(i),n(y),n(T),n(P),n(ze),n(X),n(qe),n(Ae),n(z),n(Oe),n(q),n(Ke),n(A),n(et),n(O),n(tt),n(nt),n(at),n(ot),n(st),n(it),n(lt),n(oe),n(rt),n(dt),n(ct),n(pt),n(re),n(mt),n(de),n(gt),n(ce),n(ut),n(ft),n(me),n(_t),n(ht),n(bt),n(fe),n(yt),n(wt),n(M),n(Ct),n(Tt),n(x),n(Mt),n(vt),n(G),n(Jt),n(Ut),n(I),n(Pt),n(xt),n(Fe)),n(d),h(C,e),h(F,e),h(V,e),h(K,e),h(ee,e),h(te,e),h(ne,e),h(ae,e),h(se,e),h(ie,e),h(le,e),h(pe,e),h(ge,e),h(ue,e),h(_e,e),h(he),h(be),h(Y),h(ye),h(we),h(Ce,e),h(Te),h(Me),h(H),h(ve,e),h(Je),h(Ue,e),h(Pe),h(xe),h(D),h(Ie,e)}}}const Gn='{"title":"Stable Cascade","local":"stable-cascade","sections":[{"title":"Model Overview","local":"model-overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using the Lite Versions of the Stage B and Stage C models","local":"using-the-lite-versions-of-the-stage-b-and-stage-c-models","sections":[],"depth":2},{"title":"Loading original checkpoints with from_single_file","local":"loading-original-checkpoints-with-fromsinglefile","sections":[],"depth":2},{"title":"Uses","local":"uses","sections":[{"title":"Direct Use","local":"direct-use","sections":[],"depth":3},{"title":"Out-of-Scope Use","local":"out-of-scope-use","sections":[],"depth":3}],"depth":2},{"title":"Limitations and Bias","local":"limitations-and-bias","sections":[{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"StableCascadeCombinedPipeline","local":"diffusers.StableCascadeCombinedPipeline","sections":[],"depth":2},{"title":"StableCascadePriorPipeline","local":"diffusers.StableCascadePriorPipeline","sections":[],"depth":2},{"title":"StableCascadePriorPipelineOutput","local":"diffusers.pipelines.stable_cascade.pipeline_stable_cascade_prior.StableCascadePriorPipelineOutput","sections":[],"depth":2},{"title":"StableCascadeDecoderPipeline","local":"diffusers.StableCascadeDecoderPipeline","sections":[],"depth":2}],"depth":1}';function Bn($){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class En extends Un{constructor(d){super(),Pn(this,d,Bn,Wn,vn,{})}}export{En as component};
