import{s as xt,o as wt,n as vt}from"../chunks/scheduler.8c3d61f6.js";import{S as $t,i as Mt,g as s,s as i,r as c,A as Ht,h as r,f as n,c as a,j as ce,u,x as p,k as ue,y as T,a as o,v as f,d as _,t as g,w as h}from"../chunks/index.589a98e8.js";import{T as kt}from"../chunks/Tip.42aa8582.js";import{D as Ke}from"../chunks/Docstring.27406313.js";import{C as de}from"../chunks/CodeBlock.36627b28.js";import{E as Dt}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as fe,E as Ut}from"../chunks/EditOnGithub.e5a8d9cb.js";function Pt(ie){let l,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=s("p"),l.innerHTML=$},l(b){l=r(b,"P",{"data-svelte-h":!0}),p(l)!=="svelte-w7r39y"&&(l.innerHTML=$)},m(b,v){o(b,l,v)},p:vt,d(b){b&&n(l)}}}function Ct(ie){let l,$="Examples:",b,v,x;return v=new de({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSHVueXVhbkRpVFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEh1bnl1YW5EaVRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyVGVuY2VudC1IdW55dWFuJTJGSHVueXVhbkRpVC1EaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMFlvdSUyMG1heSUyMGFsc28lMjB1c2UlMjBFbmdsaXNoJTIwcHJvbXB0JTIwYXMlMjBIdW55dWFuRGlUJTIwc3VwcG9ydHMlMjBib3RoJTIwRW5nbGlzaCUyMGFuZCUyMENoaW5lc2UlMEElMjMlMjBwcm9tcHQlMjAlM0QlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMiUwQXByb21wdCUyMCUzRCUyMCUyMiVFNCVCOCU4MCVFNCVCOCVBQSVFNSVBRSU4NyVFOCU4OCVBQSVFNSU5MSU5OCVFNSU5QyVBOCVFOSVBQSU5MSVFOSVBOSVBQyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanDiTPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = HunyuanDiTPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Tencent-Hunyuan/HunyuanDiT-Diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You may also use English prompt as HunyuanDiT supports both English and Chinese</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prompt = &quot;An astronaut riding a horse&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;一个宇航员在骑马&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=s("p"),l.textContent=$,b=i(),c(v.$$.fragment)},l(d){l=r(d,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=$),b=a(d),u(v.$$.fragment,d)},m(d,w){o(d,l,w),o(d,b,w),f(v,d,w),x=!0},p:vt,i(d){x||(_(v.$$.fragment,d),x=!0)},o(d){g(v.$$.fragment,d),x=!1},d(d){d&&(n(l),n(b)),h(v,d)}}}function Jt(ie){let l,$,b,v,x,d,w,et='<img src="https://github.com/gnobitab/diffusers-hunyuan/assets/1157982/39b99036-c3cb-4f16-bb1a-40ec25eda573" alt="chinese elements understanding"/>',_e,P,tt='<a href="https://arxiv.org/abs/2405.08748" rel="nofollow">Hunyuan-DiT : A Powerful Multi-Resolution Diffusion Transformer with Fine-Grained Chinese Understanding</a> from Tencent Hunyuan.',ge,C,nt="The abstract from the paper is:",he,J,ot="<em>We present Hunyuan-DiT, a text-to-image diffusion transformer with fine-grained understanding of both English and Chinese. To construct Hunyuan-DiT, we carefully design the transformer structure, text encoder, and positional encoding. We also build from scratch a whole data pipeline to update and evaluate data for iterative model optimization. For fine-grained language understanding, we train a Multimodal Large Language Model to refine the captions of the images. Finally, Hunyuan-DiT can perform multi-turn multimodal dialogue with users, generating and refining images according to the context. Through our holistic human evaluation protocol with more than 50 professional human evaluators, Hunyuan-DiT sets a new state-of-the-art in Chinese-to-image generation compared with other open-source models.</em>",be,I,it='You can find the original codebase at <a href="https://github.com/Tencent/HunyuanDiT" rel="nofollow">Tencent/HunyuanDiT</a> and all the available checkpoints at <a href="https://huggingface.co/Tencent-Hunyuan/HunyuanDiT" rel="nofollow">Tencent-Hunyuan</a>.',Te,j,at="<strong>Highlights</strong>: HunyuanDiT supports Chinese/English-to-image, multi-resolution generation.",ye,S,st="HunyuanDiT has the following components:",ve,B,rt="<li>It uses a diffusion transformer as the backbone</li> <li>It combines two text encoders, a bilingual CLIP and a multilingual T5 encoder</li>",xe,k,we,z,$e,L,lt='You can optimize the pipeline’s runtime and memory consumption with torch.compile and feed-forward chunking. To learn about other optimization methods, check out the <a href="../../optimization/fp16">Speed up inference</a> and <a href="../../optimization/memory">Reduce memory usage</a> guides.',Me,G,He,Z,pt='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',ke,V,dt="First, load the pipeline:",De,W,Ue,N,mt="Then change the memory layout of the pipelines <code>transformer</code> and <code>vae</code> components to <code>torch.channels-last</code>:",Pe,R,Ce,F,ct="Finally, compile the components and run inference:",Je,E,Ie,O,ut='The <a href="https://gist.github.com/sayakpaul/29d3a14905cfcbf611fe71ebd22e9b23" rel="nofollow">benchmark</a> results on a 80GB A100 machine are:',je,q,Se,Q,Be,X,ft='By loading the T5 text encoder in 8 bits, you can run the pipeline in just under 6 GBs of GPU VRAM. Refer to <a href="https://gist.github.com/sayakpaul/3154605f6af05b98a41081aaba5ca43e" rel="nofollow">this script</a> for details.',ze,A,_t='Furthermore, you can use the <a href="/docs/diffusers/pr_8324/en/api/models/hunyuan_transformer2d#diffusers.HunyuanDiT2DModel.enable_forward_chunking">enable_forward_chunking()</a> method to reduce memory usage. Feed-forward chunking runs the feed-forward layers in a transformer block in a loop instead of all at once. This gives you a trade-off between memory consumption and inference runtime.',Le,Y,Ge,K,Ze,m,ee,Fe,ae,gt="Pipeline for English/Chinese-to-image generation using HunyuanDiT.",Ee,se,ht=`This model inherits from <a href="/docs/diffusers/pr_8324/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Oe,re,bt=`HunyuanDiT uses two text encoders: <a href="https://huggingface.co/google/mt5-base" rel="nofollow">mT5</a> and [bilingual CLIP](fine-tuned by
ourselves)`,qe,M,te,Qe,le,Tt="The call function to the pipeline for generation with HunyuanDiT.",Xe,D,Ae,U,ne,Ye,pe,yt="Encodes the prompt into text encoder hidden states.",Ve,oe,We,me,Ne;return x=new fe({props:{title:"Hunyuan-DiT",local:"hunyuan-dit",headingTag:"h1"}}),k=new kt({props:{$$slots:{default:[Pt]},$$scope:{ctx:ie}}}),z=new fe({props:{title:"Optimization",local:"optimization",headingTag:"h2"}}),G=new fe({props:{title:"Inference",local:"inference",headingTag:"h3"}}),W=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5EaVRQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBIdW55dWFuRGlUUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUwOSUyMlRlbmNlbnQtSHVueXVhbiUyRkh1bnl1YW5EaVQtRGlmZnVzZXJzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanDiTPipeline
<span class="hljs-keyword">import</span> torch 

pipeline = HunyuanDiTPipeline.from_pretrained(
	<span class="hljs-string">&quot;Tencent-Hunyuan/HunyuanDiT-Diffusers&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),R=new de({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudmFlLnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KQ==",highlighted:`pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),E=new de({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGVsaW5lLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZWxpbmUudmFlLmRlY29kZSUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEJTIyJUU0JUI4JTgwJUU0JUI4JUFBJUU1JUFFJTg3JUU4JTg4JUFBJUU1JTkxJTk4JUU1JTlDJUE4JUU5JUFBJTkxJUU5JUE5JUFDJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipeline.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipeline.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

image = pipeline(prompt=<span class="hljs-string">&quot;一个宇航员在骑马&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new de({props:{code:"V2l0aCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwMTIuNDcwJTIwc2Vjb25kcy4lMEFXaXRob3V0JTIwdG9yY2guY29tcGlsZSgpJTNBJTIwQXZlcmFnZSUyMGluZmVyZW5jZSUyMHRpbWUlM0ElMjAyMC41NzAlMjBzZWNvbmRzLg==",highlighted:`With torch.compile(): Average inference time: 12.470 seconds.
Without torch.compile(): Average inference time: 20.570 seconds.`,wrap:!1}}),Q=new fe({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),Y=new de({props:{code:"JTJCJTIwcGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKQ==",highlighted:'<span class="hljs-addition">+ pipeline.transformer.enable_forward_chunking(chunk_size=1, dim=1)</span>',wrap:!1}}),K=new fe({props:{title:"HunyuanDiTPipeline",local:"diffusers.HunyuanDiTPipeline",headingTag:"h2"}}),ee=new Ke({props:{name:"class diffusers.HunyuanDiTPipeline",anchor:"diffusers.HunyuanDiTPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": BertModel"},{name:"tokenizer",val:": BertTokenizer"},{name:"transformer",val:": HunyuanDiT2DModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"},{name:"text_encoder_2",val:" = <class 'transformers.models.t5.modeling_t5.T5EncoderModel'>"},{name:"tokenizer_2",val:" = <class 'transformers.models.t5.tokenization_t5.T5Tokenizer'>"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_8324/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. We use
<code>sdxl-vae-fp16-fix</code>.`,name:"vae"},{anchor:"diffusers.HunyuanDiTPipeline.text_encoder",description:`<strong>text_encoder</strong> (Optional[<code>~transformers.BertModel</code>, <code>~transformers.CLIPTextModel</code>]) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
HunyuanDiT uses a fine-tuned [bilingual CLIP].`,name:"text_encoder"},{anchor:"diffusers.HunyuanDiTPipeline.tokenizer",description:`<strong>tokenizer</strong> (Optional[<code>~transformers.BertTokenizer</code>, <code>~transformers.CLIPTokenizer</code>]) &#x2014;
A <code>BertTokenizer</code> or <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.HunyuanDiTPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_8324/en/api/models/hunyuan_transformer2d#diffusers.HunyuanDiT2DModel">HunyuanDiT2DModel</a>) &#x2014;
The HunyuanDiT model designed by Tencent Hunyuan.`,name:"transformer"},{anchor:"diffusers.HunyuanDiTPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
The mT5 embedder. Specifically, it is &#x2018;t5-v1_1-xxl&#x2019;.`,name:"text_encoder_2"},{anchor:"diffusers.HunyuanDiTPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>MT5Tokenizer</code>) &#x2014;
The tokenizer for the mT5 embedder.`,name:"tokenizer_2"},{anchor:"diffusers.HunyuanDiTPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8324/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>) &#x2014;
A scheduler to be used in combination with HunyuanDiT to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/hunyuandit/pipeline_hunyuandit.py#L141"}}),te=new Ke({props:{name:"__call__",anchor:"diffusers.HunyuanDiTPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = 50"},{name:"guidance_scale",val:": Optional = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_embeds_2",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds_2",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"prompt_attention_mask_2",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask_2",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Optional = (1024, 1024)"},{name:"target_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"use_resolution_binning",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_8324/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.prompt_embeds_2",description:`<strong>prompt_embeds_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds_2"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.negative_prompt_embeds_2",description:`<strong>negative_prompt_embeds_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds_2"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds</code> is passed directly.`,name:"prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.prompt_attention_mask_2",description:`<strong>prompt_attention_mask_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds_2</code> is passed directly.`,name:"prompt_attention_mask_2"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds</code> is passed directly.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.negative_prompt_attention_mask_2",description:`<strong>negative_prompt_attention_mask_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds_2</code> is passed directly.`,name:"negative_prompt_attention_mask_2"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8324/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, Dict], None]</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A callback function or a list of callback functions to be called at the end of each denoising step.`,name:"callback_on_step_end"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tensor inputs that should be passed to the callback function. If not defined, all tensor
inputs will be passed.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Rescale the noise_cfg according to <code>guidance_rescale</code>. Based on findings of <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise
Schedules and Sample Steps are Flawed</a>. See Section 3.4`,name:"guidance_rescale"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>(1024, 1024)</code>) &#x2014;
The original size of the image. Used to calculate the time ids.`,name:"original_size"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
The target size of the image. Used to calculate the time ids.`,name:"target_size"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>(0, 0)</code>) &#x2014;
The top left coordinates of the crop. Used to calculate the time ids.`,name:"crops_coords_top_left"},{anchor:"diffusers.HunyuanDiTPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use resolution binning or not. If <code>True</code>, the input resolution will be mapped to the closest
standard resolution. Supported resolutions are 1024x1024, 1280x1280, 1024x768, 1152x864, 1280x960,
768x1024, 864x1152, 960x1280, 1280x768, and 768x1280. It is recommended to set this to <code>True</code>.`,name:"use_resolution_binning"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/hunyuandit/pipeline_hunyuandit.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_8324/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8324/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),D=new Dt({props:{anchor:"diffusers.HunyuanDiTPipeline.__call__.example",$$slots:{default:[Ct]},$$scope:{ctx:ie}}}),ne=new Ke({props:{name:"encode_prompt",anchor:"diffusers.HunyuanDiTPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"max_sequence_length",val:": Optional = None"},{name:"text_encoder_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
torch dtype`,name:"dtype"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds</code> is passed directly.`,name:"prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds</code> is passed directly.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>) &#x2014; maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.HunyuanDiTPipeline.encode_prompt.text_encoder_index",description:`<strong>text_encoder_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Index of the text encoder to use. <code>0</code> for clip and <code>1</code> for T5.`,name:"text_encoder_index"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/hunyuandit/pipeline_hunyuandit.py#L242"}}),oe=new Ut({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/hunyuandit.md"}}),{c(){l=s("meta"),$=i(),b=s("p"),v=i(),c(x.$$.fragment),d=i(),w=s("p"),w.innerHTML=et,_e=i(),P=s("p"),P.innerHTML=tt,ge=i(),C=s("p"),C.textContent=nt,he=i(),J=s("p"),J.innerHTML=ot,be=i(),I=s("p"),I.innerHTML=it,Te=i(),j=s("p"),j.innerHTML=at,ye=i(),S=s("p"),S.textContent=st,ve=i(),B=s("ul"),B.innerHTML=rt,xe=i(),c(k.$$.fragment),we=i(),c(z.$$.fragment),$e=i(),L=s("p"),L.innerHTML=lt,Me=i(),c(G.$$.fragment),He=i(),Z=s("p"),Z.innerHTML=pt,ke=i(),V=s("p"),V.textContent=dt,De=i(),c(W.$$.fragment),Ue=i(),N=s("p"),N.innerHTML=mt,Pe=i(),c(R.$$.fragment),Ce=i(),F=s("p"),F.textContent=ct,Je=i(),c(E.$$.fragment),Ie=i(),O=s("p"),O.innerHTML=ut,je=i(),c(q.$$.fragment),Se=i(),c(Q.$$.fragment),Be=i(),X=s("p"),X.innerHTML=ft,ze=i(),A=s("p"),A.innerHTML=_t,Le=i(),c(Y.$$.fragment),Ge=i(),c(K.$$.fragment),Ze=i(),m=s("div"),c(ee.$$.fragment),Fe=i(),ae=s("p"),ae.textContent=gt,Ee=i(),se=s("p"),se.innerHTML=ht,Oe=i(),re=s("p"),re.innerHTML=bt,qe=i(),M=s("div"),c(te.$$.fragment),Qe=i(),le=s("p"),le.textContent=Tt,Xe=i(),c(D.$$.fragment),Ae=i(),U=s("div"),c(ne.$$.fragment),Ye=i(),pe=s("p"),pe.textContent=yt,Ve=i(),c(oe.$$.fragment),We=i(),me=s("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(n),$=a(e),b=r(e,"P",{}),ce(b).forEach(n),v=a(e),u(x.$$.fragment,e),d=a(e),w=r(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-2bc00t"&&(w.innerHTML=et),_e=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-k67k6c"&&(P.innerHTML=tt),ge=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1cwsb16"&&(C.textContent=nt),he=a(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-pnixkh"&&(J.innerHTML=ot),be=a(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-14jgagb"&&(I.innerHTML=it),Te=a(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-4ilgcj"&&(j.innerHTML=at),ye=a(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-csifv3"&&(S.textContent=st),ve=a(e),B=r(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-1jg2mmd"&&(B.innerHTML=rt),xe=a(e),u(k.$$.fragment,e),we=a(e),u(z.$$.fragment,e),$e=a(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-152y6vu"&&(L.innerHTML=lt),Me=a(e),u(G.$$.fragment,e),He=a(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-iekg51"&&(Z.innerHTML=pt),ke=a(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-jub7f1"&&(V.textContent=dt),De=a(e),u(W.$$.fragment,e),Ue=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-4294wb"&&(N.innerHTML=mt),Pe=a(e),u(R.$$.fragment,e),Ce=a(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-9i4prs"&&(F.textContent=ct),Je=a(e),u(E.$$.fragment,e),Ie=a(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1918cyp"&&(O.innerHTML=ut),je=a(e),u(q.$$.fragment,e),Se=a(e),u(Q.$$.fragment,e),Be=a(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-s8wnu9"&&(X.innerHTML=ft),ze=a(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-dnpbts"&&(A.innerHTML=_t),Le=a(e),u(Y.$$.fragment,e),Ge=a(e),u(K.$$.fragment,e),Ze=a(e),m=r(e,"DIV",{class:!0});var y=ce(m);u(ee.$$.fragment,y),Fe=a(y),ae=r(y,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-ue2deu"&&(ae.textContent=gt),Ee=a(y),se=r(y,"P",{"data-svelte-h":!0}),p(se)!=="svelte-xcsvk8"&&(se.innerHTML=ht),Oe=a(y),re=r(y,"P",{"data-svelte-h":!0}),p(re)!=="svelte-18ud7q1"&&(re.innerHTML=bt),qe=a(y),M=r(y,"DIV",{class:!0});var H=ce(M);u(te.$$.fragment,H),Qe=a(H),le=r(H,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1jqbgbl"&&(le.textContent=Tt),Xe=a(H),u(D.$$.fragment,H),H.forEach(n),Ae=a(y),U=r(y,"DIV",{class:!0});var Re=ce(U);u(ne.$$.fragment,Re),Ye=a(Re),pe=r(Re,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-16q0ax1"&&(pe.textContent=yt),Re.forEach(n),y.forEach(n),Ve=a(e),u(oe.$$.fragment,e),We=a(e),me=r(e,"P",{}),ce(me).forEach(n),this.h()},h(){ue(l,"name","hf:doc:metadata"),ue(l,"content",It),ue(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){T(document.head,l),o(e,$,t),o(e,b,t),o(e,v,t),f(x,e,t),o(e,d,t),o(e,w,t),o(e,_e,t),o(e,P,t),o(e,ge,t),o(e,C,t),o(e,he,t),o(e,J,t),o(e,be,t),o(e,I,t),o(e,Te,t),o(e,j,t),o(e,ye,t),o(e,S,t),o(e,ve,t),o(e,B,t),o(e,xe,t),f(k,e,t),o(e,we,t),f(z,e,t),o(e,$e,t),o(e,L,t),o(e,Me,t),f(G,e,t),o(e,He,t),o(e,Z,t),o(e,ke,t),o(e,V,t),o(e,De,t),f(W,e,t),o(e,Ue,t),o(e,N,t),o(e,Pe,t),f(R,e,t),o(e,Ce,t),o(e,F,t),o(e,Je,t),f(E,e,t),o(e,Ie,t),o(e,O,t),o(e,je,t),f(q,e,t),o(e,Se,t),f(Q,e,t),o(e,Be,t),o(e,X,t),o(e,ze,t),o(e,A,t),o(e,Le,t),f(Y,e,t),o(e,Ge,t),f(K,e,t),o(e,Ze,t),o(e,m,t),f(ee,m,null),T(m,Fe),T(m,ae),T(m,Ee),T(m,se),T(m,Oe),T(m,re),T(m,qe),T(m,M),f(te,M,null),T(M,Qe),T(M,le),T(M,Xe),f(D,M,null),T(m,Ae),T(m,U),f(ne,U,null),T(U,Ye),T(U,pe),o(e,Ve,t),f(oe,e,t),o(e,We,t),o(e,me,t),Ne=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),k.$set(y);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),D.$set(H)},i(e){Ne||(_(x.$$.fragment,e),_(k.$$.fragment,e),_(z.$$.fragment,e),_(G.$$.fragment,e),_(W.$$.fragment,e),_(R.$$.fragment,e),_(E.$$.fragment,e),_(q.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(D.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),Ne=!0)},o(e){g(x.$$.fragment,e),g(k.$$.fragment,e),g(z.$$.fragment,e),g(G.$$.fragment,e),g(W.$$.fragment,e),g(R.$$.fragment,e),g(E.$$.fragment,e),g(q.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(D.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),Ne=!1},d(e){e&&(n($),n(b),n(v),n(d),n(w),n(_e),n(P),n(ge),n(C),n(he),n(J),n(be),n(I),n(Te),n(j),n(ye),n(S),n(ve),n(B),n(xe),n(we),n($e),n(L),n(Me),n(He),n(Z),n(ke),n(V),n(De),n(Ue),n(N),n(Pe),n(Ce),n(F),n(Je),n(Ie),n(O),n(je),n(Se),n(Be),n(X),n(ze),n(A),n(Le),n(Ge),n(Ze),n(m),n(Ve),n(We),n(me)),n(l),h(x,e),h(k,e),h(z,e),h(G,e),h(W,e),h(R,e),h(E,e),h(q,e),h(Q,e),h(Y,e),h(K,e),h(ee),h(te),h(D),h(ne),h(oe,e)}}}const It='{"title":"Hunyuan-DiT","local":"hunyuan-dit","sections":[{"title":"Optimization","local":"optimization","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3},{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3}],"depth":2},{"title":"HunyuanDiTPipeline","local":"diffusers.HunyuanDiTPipeline","sections":[],"depth":2}],"depth":1}';function jt(ie){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends $t{constructor(l){super(),Mt(this,l,jt,Jt,xt,{})}}export{Wt as component};
