import{s as ga,o as ua,n as S}from"../chunks/scheduler.8c3d61f6.js";import{S as fa,i as ha,g as d,s as i,r as u,A as _a,h as p,f as s,c as o,j as I,u as f,x as w,k as v,y as a,a as m,v as h,d as _,t as y,w as b}from"../chunks/index.589a98e8.js";import{T as ma}from"../chunks/Tip.42aa8582.js";import{D as J}from"../chunks/Docstring.27406313.js";import{C as he}from"../chunks/CodeBlock.36627b28.js";import{E as ue}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as fe,E as ya}from"../chunks/EditOnGithub.e5a8d9cb.js";function ba(T){let t,M='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){t=d("p"),t.innerHTML=M},l(c){t=p(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1nfky5i"&&(t.innerHTML=M)},m(c,r){m(c,t,r)},p:S,d(c){c&&s(t)}}}function ka(T){let t,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){t=d("p"),t.innerHTML=M},l(c){t=p(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1wmc0l4"&&(t.innerHTML=M)},m(c,r){m(c,t,r)},p:S,d(c){c&&s(t)}}}function wa(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ma(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvci5pbnRlcnBvbGF0ZShpbWFnZXNfdGV4dHMlMkMlMjB3ZWlnaHRzKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPriorPipeline, KandinskyPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;</span>,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ta(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZLYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/Kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ia(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGxpb24lMjBpbiUyMGdhbGF4aWVzJTJDJTIwc3BpcmFscyUyQyUyMG5lYnVsYWUlMkMlMjBzdGFycyUyQyUyMHNtb2tlJTJDJTIwaXJpZGVzY2VudCUyQyUyMGludHJpY2F0ZSUyMGRldGFpbCUyQyUyMG9jdGFuZSUyMHJlbmRlciUyQyUyMDhrJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function va(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUltZzJJbWdQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcmVkJTIwY2FydG9vbiUyMGZyb2clMkMlMjA0ayUyMiUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGZnJvZy5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjIlMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMnJlZF9mcm9nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyImg2ImgPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A red cartoon frog, 4k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/frog.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;red_frog.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ja(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Pa(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwaGF0JTIyJTBBaW1hZ2VfZW1iJTJDJTIwemVyb19pbWFnZV9lbWIlMjAlM0QlMjBwaXBlX3ByaW9yKHByb21wdCUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTEtaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBbWFzayUyMCUzRCUyMG5wLnplcm9zKCg3NjglMkMlMjA3NjgpJTJDJTIwZHR5cGUlM0RucC5mbG9hdDMyKSUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwb3V0LmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdF93aXRoX2hhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyInpaintPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = out.images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;cat_with_hat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ua(T){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFtYXNrJTIwJTNEJTIwbnAuemVyb3MoKDc2OCUyQyUyMDc2OCklMkMlMjBkdHlwZSUzRG5wLmZsb2F0MzIpJTBBJTIzJTIwTGV0J3MlMjBtYXNrJTIwb3V0JTIwYW4lMjBhcmVhJTIwYWJvdmUlMjB0aGUlMjBjYXQncyUyMGhlYWQlMEFtYXNrJTVCJTNBMjUwJTJDJTIwMjUwJTNBLTI1MCU1RCUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=i(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=o(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function xa(T){let t,M,c,r,g,n,k,Kt='Kandinsky 2.1 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',Tn,_e,Vt="The description from it’s GitHub page is:",In,ye,qt="<em>Kandinsky 2.1 inherits best practicies from Dall-E 2 and Latent diffusion, while introducing some new ideas. As text and image encoder it uses CLIP model and diffusion image prior (mapping) between latent spaces of CLIP modalities. This approach increases the visual performance of the model and unveils new horizons in blending images and text-guided image manipulation.</em>",vn,be,Lt='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',Jn,ee,Pn,ne,Un,ke,xn,P,we,Xn,Xe,zt="Pipeline for generating image prior for Kandinsky",Sn,Se,Nt=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Dn,V,Me,Hn,De,Et="Function invoked when calling the pipeline for generation.",Yn,te,An,q,Te,On,He,Qt="Function invoked when using the prior pipeline for interpolation.",et,ae,Cn,Ie,jn,j,ve,nt,Ye,Rt="Pipeline for text-to-image generation using Kandinsky",tt,Ae,Ft=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,at,L,Je,st,Oe,Xt="Function invoked when calling the pipeline for generation.",it,se,$n,Pe,Zn,U,Ue,ot,en,St="Combined Pipeline for text-to-image generation using Kandinsky",rt,nn,Dt=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,lt,z,xe,dt,tn,Ht="Function invoked when calling the pipeline for generation.",pt,ie,ct,oe,Ce,mt,an,Yt=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,Wn,je,Gn,$,$e,gt,sn,At="Pipeline for image-to-image generation using Kandinsky",ut,on,Ot=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ft,N,Ze,ht,rn,ea="Function invoked when calling the pipeline for generation.",_t,re,Bn,We,Kn,x,Ge,yt,ln,na="Combined Pipeline for image-to-image generation using Kandinsky",bt,dn,ta=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,kt,E,Be,wt,pn,aa="Function invoked when calling the pipeline for generation.",Mt,le,Tt,de,Ke,It,cn,sa=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Vn,Ve,qn,Z,qe,vt,mn,ia="Pipeline for text-guided image inpainting using Kandinsky2.1",Jt,gn,oa=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Pt,Q,Le,Ut,un,ra="Function invoked when calling the pipeline for generation.",xt,pe,Ln,ze,zn,C,Ne,Ct,fn,la="Combined Pipeline for generation using Kandinsky",jt,hn,da=`This model inherits from <a href="/docs/diffusers/pr_8461/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,$t,R,Ee,Zt,_n,pa="Function invoked when calling the pipeline for generation.",Wt,ce,Gt,me,Qe,Bt,yn,ca=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Nn,Re,En,Mn,Qn;return g=new fe({props:{title:"Kandinsky 2.1",local:"kandinsky-21",headingTag:"h1"}}),ee=new ma({props:{$$slots:{default:[ba]},$$scope:{ctx:T}}}),ne=new ma({props:{$$slots:{default:[ka]},$$scope:{ctx:T}}}),ke=new fe({props:{title:"KandinskyPriorPipeline",local:"diffusers.KandinskyPriorPipeline",headingTag:"h2"}}),we=new J({props:{name:"class diffusers.KandinskyPriorPipeline",anchor:"diffusers.KandinskyPriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyPriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L128"}}),Me=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L397",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),te=new ue({props:{anchor:"diffusers.KandinskyPriorPipeline.__call__.example",$$slots:{default:[wa]},$$scope:{ctx:T}}}),Te=new J({props:{name:"interpolate",anchor:"diffusers.KandinskyPriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.Tensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L172",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),ae=new ue({props:{anchor:"diffusers.KandinskyPriorPipeline.interpolate.example",$$slots:{default:[Ma]},$$scope:{ctx:T}}}),Ie=new fe({props:{title:"KandinskyPipeline",local:"diffusers.KandinskyPipeline",headingTag:"h2"}}),ve=new J({props:{name:"class diffusers.KandinskyPipeline",anchor:"diffusers.KandinskyPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L76"}}),Je=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L231",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),se=new ue({props:{anchor:"diffusers.KandinskyPipeline.__call__.example",$$slots:{default:[Ta]},$$scope:{ctx:T}}}),Pe=new fe({props:{title:"KandinskyCombinedPipeline",local:"diffusers.KandinskyCombinedPipeline",headingTag:"h2"}}),Ue=new J({props:{name:"class diffusers.KandinskyCombinedPipeline",anchor:"diffusers.KandinskyCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L113"}}),xe=new J({props:{name:"__call__",anchor:"diffusers.KandinskyCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L215",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ie=new ue({props:{anchor:"diffusers.KandinskyCombinedPipeline.__call__.example",$$slots:{default:[Ia]},$$scope:{ctx:T}}}),Ce=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L196"}}),je=new fe({props:{title:"KandinskyImg2ImgPipeline",local:"diffusers.KandinskyImg2ImgPipeline",headingTag:"h2"}}),$e=new J({props:{name:"class diffusers.KandinskyImg2ImgPipeline",anchor:"diffusers.KandinskyImg2ImgPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8461/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L98"}}),Ze=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"image_embeds",val:": Tensor"},{name:"negative_image_embeds",val:": Tensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"strength",val:": float = 0.3"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L293",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),re=new ue({props:{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.example",$$slots:{default:[va]},$$scope:{ctx:T}}}),We=new fe({props:{title:"KandinskyImg2ImgCombinedPipeline",local:"diffusers.KandinskyImg2ImgCombinedPipeline",headingTag:"h2"}}),Ge=new J({props:{name:"class diffusers.KandinskyImg2ImgCombinedPipeline",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L331"}}),Be=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"strength",val:": float = 0.3"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L434",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),le=new ue({props:{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.example",$$slots:{default:[Ja]},$$scope:{ctx:T}}}),Ke=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L414"}}),Ve=new fe({props:{title:"KandinskyInpaintPipeline",local:"diffusers.KandinskyInpaintPipeline",headingTag:"h2"}}),qe=new J({props:{name:"class diffusers.KandinskyInpaintPipeline",anchor:"diffusers.KandinskyInpaintPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8461/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L240"}}),Le=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"image_embeds",val:": Tensor"},{name:"negative_image_embeds",val:": Tensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>,<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or a tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. You can pass a pytorch tensor as mask only if the
image you passed is a pytorch tensor, and it should contain one color channel (L) instead of 3, so the
expected shape would be either <code>(B, 1, H, W,)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code> or <code>(H, W)</code> If image is an PIL
image or numpy array, mask should also be a either PIL image or numpy array. If it is a PIL image, it
will be converted to a single channel (luminance) before use. If it is a nummpy array, the expected
shape is <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),pe=new ue({props:{anchor:"diffusers.KandinskyInpaintPipeline.__call__.example",$$slots:{default:[Pa]},$$scope:{ctx:T}}}),ze=new fe({props:{title:"KandinskyInpaintCombinedPipeline",local:"diffusers.KandinskyInpaintCombinedPipeline",headingTag:"h2"}}),Ne=new J({props:{name:"class diffusers.KandinskyInpaintCombinedPipeline",anchor:"diffusers.KandinskyInpaintCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/pr_8461/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L572"}}),Ee=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L675",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8461/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ce=new ue({props:{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.example",$$slots:{default:[Ua]},$$scope:{ctx:T}}}),Qe=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyInpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/vr_8461/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L655"}}),Re=new ya({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/kandinsky.md"}}),{c(){t=d("meta"),M=i(),c=d("p"),r=i(),u(g.$$.fragment),n=i(),k=d("p"),k.innerHTML=Kt,Tn=i(),_e=d("p"),_e.textContent=Vt,In=i(),ye=d("p"),ye.innerHTML=qt,vn=i(),be=d("p"),be.innerHTML=Lt,Jn=i(),u(ee.$$.fragment),Pn=i(),u(ne.$$.fragment),Un=i(),u(ke.$$.fragment),xn=i(),P=d("div"),u(we.$$.fragment),Xn=i(),Xe=d("p"),Xe.textContent=zt,Sn=i(),Se=d("p"),Se.innerHTML=Nt,Dn=i(),V=d("div"),u(Me.$$.fragment),Hn=i(),De=d("p"),De.textContent=Et,Yn=i(),u(te.$$.fragment),An=i(),q=d("div"),u(Te.$$.fragment),On=i(),He=d("p"),He.textContent=Qt,et=i(),u(ae.$$.fragment),Cn=i(),u(Ie.$$.fragment),jn=i(),j=d("div"),u(ve.$$.fragment),nt=i(),Ye=d("p"),Ye.textContent=Rt,tt=i(),Ae=d("p"),Ae.innerHTML=Ft,at=i(),L=d("div"),u(Je.$$.fragment),st=i(),Oe=d("p"),Oe.textContent=Xt,it=i(),u(se.$$.fragment),$n=i(),u(Pe.$$.fragment),Zn=i(),U=d("div"),u(Ue.$$.fragment),ot=i(),en=d("p"),en.textContent=St,rt=i(),nn=d("p"),nn.innerHTML=Dt,lt=i(),z=d("div"),u(xe.$$.fragment),dt=i(),tn=d("p"),tn.textContent=Ht,pt=i(),u(ie.$$.fragment),ct=i(),oe=d("div"),u(Ce.$$.fragment),mt=i(),an=d("p"),an.innerHTML=Yt,Wn=i(),u(je.$$.fragment),Gn=i(),$=d("div"),u($e.$$.fragment),gt=i(),sn=d("p"),sn.textContent=At,ut=i(),on=d("p"),on.innerHTML=Ot,ft=i(),N=d("div"),u(Ze.$$.fragment),ht=i(),rn=d("p"),rn.textContent=ea,_t=i(),u(re.$$.fragment),Bn=i(),u(We.$$.fragment),Kn=i(),x=d("div"),u(Ge.$$.fragment),yt=i(),ln=d("p"),ln.textContent=na,bt=i(),dn=d("p"),dn.innerHTML=ta,kt=i(),E=d("div"),u(Be.$$.fragment),wt=i(),pn=d("p"),pn.textContent=aa,Mt=i(),u(le.$$.fragment),Tt=i(),de=d("div"),u(Ke.$$.fragment),It=i(),cn=d("p"),cn.innerHTML=sa,Vn=i(),u(Ve.$$.fragment),qn=i(),Z=d("div"),u(qe.$$.fragment),vt=i(),mn=d("p"),mn.textContent=ia,Jt=i(),gn=d("p"),gn.innerHTML=oa,Pt=i(),Q=d("div"),u(Le.$$.fragment),Ut=i(),un=d("p"),un.textContent=ra,xt=i(),u(pe.$$.fragment),Ln=i(),u(ze.$$.fragment),zn=i(),C=d("div"),u(Ne.$$.fragment),Ct=i(),fn=d("p"),fn.textContent=la,jt=i(),hn=d("p"),hn.innerHTML=da,$t=i(),R=d("div"),u(Ee.$$.fragment),Zt=i(),_n=d("p"),_n.textContent=pa,Wt=i(),u(ce.$$.fragment),Gt=i(),me=d("div"),u(Qe.$$.fragment),Bt=i(),yn=d("p"),yn.innerHTML=ca,Nn=i(),u(Re.$$.fragment),En=i(),Mn=d("p"),this.h()},l(e){const l=_a("svelte-u9bgzb",document.head);t=p(l,"META",{name:!0,content:!0}),l.forEach(s),M=o(e),c=p(e,"P",{}),I(c).forEach(s),r=o(e),f(g.$$.fragment,e),n=o(e),k=p(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-z239mp"&&(k.innerHTML=Kt),Tn=o(e),_e=p(e,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-1og8lwg"&&(_e.textContent=Vt),In=o(e),ye=p(e,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-1ax7cek"&&(ye.innerHTML=qt),vn=o(e),be=p(e,"P",{"data-svelte-h":!0}),w(be)!=="svelte-14rg3yz"&&(be.innerHTML=Lt),Jn=o(e),f(ee.$$.fragment,e),Pn=o(e),f(ne.$$.fragment,e),Un=o(e),f(ke.$$.fragment,e),xn=o(e),P=p(e,"DIV",{class:!0});var W=I(P);f(we.$$.fragment,W),Xn=o(W),Xe=p(W,"P",{"data-svelte-h":!0}),w(Xe)!=="svelte-gfz7tn"&&(Xe.textContent=zt),Sn=o(W),Se=p(W,"P",{"data-svelte-h":!0}),w(Se)!=="svelte-1wp8m4q"&&(Se.innerHTML=Nt),Dn=o(W),V=p(W,"DIV",{class:!0});var D=I(V);f(Me.$$.fragment,D),Hn=o(D),De=p(D,"P",{"data-svelte-h":!0}),w(De)!=="svelte-v78lg8"&&(De.textContent=Et),Yn=o(D),f(te.$$.fragment,D),D.forEach(s),An=o(W),q=p(W,"DIV",{class:!0});var H=I(q);f(Te.$$.fragment,H),On=o(H),He=p(H,"P",{"data-svelte-h":!0}),w(He)!=="svelte-1k7d7q8"&&(He.textContent=Qt),et=o(H),f(ae.$$.fragment,H),H.forEach(s),W.forEach(s),Cn=o(e),f(Ie.$$.fragment,e),jn=o(e),j=p(e,"DIV",{class:!0});var B=I(j);f(ve.$$.fragment,B),nt=o(B),Ye=p(B,"P",{"data-svelte-h":!0}),w(Ye)!=="svelte-jhhofy"&&(Ye.textContent=Rt),tt=o(B),Ae=p(B,"P",{"data-svelte-h":!0}),w(Ae)!=="svelte-1wp8m4q"&&(Ae.innerHTML=Ft),at=o(B),L=p(B,"DIV",{class:!0});var Y=I(L);f(Je.$$.fragment,Y),st=o(Y),Oe=p(Y,"P",{"data-svelte-h":!0}),w(Oe)!=="svelte-v78lg8"&&(Oe.textContent=Xt),it=o(Y),f(se.$$.fragment,Y),Y.forEach(s),B.forEach(s),$n=o(e),f(Pe.$$.fragment,e),Zn=o(e),U=p(e,"DIV",{class:!0});var G=I(U);f(Ue.$$.fragment,G),ot=o(G),en=p(G,"P",{"data-svelte-h":!0}),w(en)!=="svelte-1spbql3"&&(en.textContent=St),rt=o(G),nn=p(G,"P",{"data-svelte-h":!0}),w(nn)!=="svelte-1wp8m4q"&&(nn.innerHTML=Dt),lt=o(G),z=p(G,"DIV",{class:!0});var A=I(z);f(xe.$$.fragment,A),dt=o(A),tn=p(A,"P",{"data-svelte-h":!0}),w(tn)!=="svelte-v78lg8"&&(tn.textContent=Ht),pt=o(A),f(ie.$$.fragment,A),A.forEach(s),ct=o(G),oe=p(G,"DIV",{class:!0});var Fe=I(oe);f(Ce.$$.fragment,Fe),mt=o(Fe),an=p(Fe,"P",{"data-svelte-h":!0}),w(an)!=="svelte-a2a0wt"&&(an.innerHTML=Yt),Fe.forEach(s),G.forEach(s),Wn=o(e),f(je.$$.fragment,e),Gn=o(e),$=p(e,"DIV",{class:!0});var K=I($);f($e.$$.fragment,K),gt=o(K),sn=p(K,"P",{"data-svelte-h":!0}),w(sn)!=="svelte-1nm2rj2"&&(sn.textContent=At),ut=o(K),on=p(K,"P",{"data-svelte-h":!0}),w(on)!=="svelte-1wp8m4q"&&(on.innerHTML=Ot),ft=o(K),N=p(K,"DIV",{class:!0});var O=I(N);f(Ze.$$.fragment,O),ht=o(O),rn=p(O,"P",{"data-svelte-h":!0}),w(rn)!=="svelte-v78lg8"&&(rn.textContent=ea),_t=o(O),f(re.$$.fragment,O),O.forEach(s),K.forEach(s),Bn=o(e),f(We.$$.fragment,e),Kn=o(e),x=p(e,"DIV",{class:!0});var F=I(x);f(Ge.$$.fragment,F),yt=o(F),ln=p(F,"P",{"data-svelte-h":!0}),w(ln)!=="svelte-1ql3mrb"&&(ln.textContent=na),bt=o(F),dn=p(F,"P",{"data-svelte-h":!0}),w(dn)!=="svelte-1wp8m4q"&&(dn.innerHTML=ta),kt=o(F),E=p(F,"DIV",{class:!0});var bn=I(E);f(Be.$$.fragment,bn),wt=o(bn),pn=p(bn,"P",{"data-svelte-h":!0}),w(pn)!=="svelte-v78lg8"&&(pn.textContent=aa),Mt=o(bn),f(le.$$.fragment,bn),bn.forEach(s),Tt=o(F),de=p(F,"DIV",{class:!0});var Rn=I(de);f(Ke.$$.fragment,Rn),It=o(Rn),cn=p(Rn,"P",{"data-svelte-h":!0}),w(cn)!=="svelte-1ff7ilh"&&(cn.innerHTML=sa),Rn.forEach(s),F.forEach(s),Vn=o(e),f(Ve.$$.fragment,e),qn=o(e),Z=p(e,"DIV",{class:!0});var ge=I(Z);f(qe.$$.fragment,ge),vt=o(ge),mn=p(ge,"P",{"data-svelte-h":!0}),w(mn)!=="svelte-2p9m8a"&&(mn.textContent=ia),Jt=o(ge),gn=p(ge,"P",{"data-svelte-h":!0}),w(gn)!=="svelte-1wp8m4q"&&(gn.innerHTML=oa),Pt=o(ge),Q=p(ge,"DIV",{class:!0});var kn=I(Q);f(Le.$$.fragment,kn),Ut=o(kn),un=p(kn,"P",{"data-svelte-h":!0}),w(un)!=="svelte-v78lg8"&&(un.textContent=ra),xt=o(kn),f(pe.$$.fragment,kn),kn.forEach(s),ge.forEach(s),Ln=o(e),f(ze.$$.fragment,e),zn=o(e),C=p(e,"DIV",{class:!0});var X=I(C);f(Ne.$$.fragment,X),Ct=o(X),fn=p(X,"P",{"data-svelte-h":!0}),w(fn)!=="svelte-18rw6ko"&&(fn.textContent=la),jt=o(X),hn=p(X,"P",{"data-svelte-h":!0}),w(hn)!=="svelte-1wp8m4q"&&(hn.innerHTML=da),$t=o(X),R=p(X,"DIV",{class:!0});var wn=I(R);f(Ee.$$.fragment,wn),Zt=o(wn),_n=p(wn,"P",{"data-svelte-h":!0}),w(_n)!=="svelte-v78lg8"&&(_n.textContent=pa),Wt=o(wn),f(ce.$$.fragment,wn),wn.forEach(s),Gt=o(X),me=p(X,"DIV",{class:!0});var Fn=I(me);f(Qe.$$.fragment,Fn),Bt=o(Fn),yn=p(Fn,"P",{"data-svelte-h":!0}),w(yn)!=="svelte-1ff7ilh"&&(yn.innerHTML=ca),Fn.forEach(s),X.forEach(s),Nn=o(e),f(Re.$$.fragment,e),En=o(e),Mn=p(e,"P",{}),I(Mn).forEach(s),this.h()},h(){v(t,"name","hf:doc:metadata"),v(t,"content",Ca),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){a(document.head,t),m(e,M,l),m(e,c,l),m(e,r,l),h(g,e,l),m(e,n,l),m(e,k,l),m(e,Tn,l),m(e,_e,l),m(e,In,l),m(e,ye,l),m(e,vn,l),m(e,be,l),m(e,Jn,l),h(ee,e,l),m(e,Pn,l),h(ne,e,l),m(e,Un,l),h(ke,e,l),m(e,xn,l),m(e,P,l),h(we,P,null),a(P,Xn),a(P,Xe),a(P,Sn),a(P,Se),a(P,Dn),a(P,V),h(Me,V,null),a(V,Hn),a(V,De),a(V,Yn),h(te,V,null),a(P,An),a(P,q),h(Te,q,null),a(q,On),a(q,He),a(q,et),h(ae,q,null),m(e,Cn,l),h(Ie,e,l),m(e,jn,l),m(e,j,l),h(ve,j,null),a(j,nt),a(j,Ye),a(j,tt),a(j,Ae),a(j,at),a(j,L),h(Je,L,null),a(L,st),a(L,Oe),a(L,it),h(se,L,null),m(e,$n,l),h(Pe,e,l),m(e,Zn,l),m(e,U,l),h(Ue,U,null),a(U,ot),a(U,en),a(U,rt),a(U,nn),a(U,lt),a(U,z),h(xe,z,null),a(z,dt),a(z,tn),a(z,pt),h(ie,z,null),a(U,ct),a(U,oe),h(Ce,oe,null),a(oe,mt),a(oe,an),m(e,Wn,l),h(je,e,l),m(e,Gn,l),m(e,$,l),h($e,$,null),a($,gt),a($,sn),a($,ut),a($,on),a($,ft),a($,N),h(Ze,N,null),a(N,ht),a(N,rn),a(N,_t),h(re,N,null),m(e,Bn,l),h(We,e,l),m(e,Kn,l),m(e,x,l),h(Ge,x,null),a(x,yt),a(x,ln),a(x,bt),a(x,dn),a(x,kt),a(x,E),h(Be,E,null),a(E,wt),a(E,pn),a(E,Mt),h(le,E,null),a(x,Tt),a(x,de),h(Ke,de,null),a(de,It),a(de,cn),m(e,Vn,l),h(Ve,e,l),m(e,qn,l),m(e,Z,l),h(qe,Z,null),a(Z,vt),a(Z,mn),a(Z,Jt),a(Z,gn),a(Z,Pt),a(Z,Q),h(Le,Q,null),a(Q,Ut),a(Q,un),a(Q,xt),h(pe,Q,null),m(e,Ln,l),h(ze,e,l),m(e,zn,l),m(e,C,l),h(Ne,C,null),a(C,Ct),a(C,fn),a(C,jt),a(C,hn),a(C,$t),a(C,R),h(Ee,R,null),a(R,Zt),a(R,_n),a(R,Wt),h(ce,R,null),a(C,Gt),a(C,me),h(Qe,me,null),a(me,Bt),a(me,yn),m(e,Nn,l),h(Re,e,l),m(e,En,l),m(e,Mn,l),Qn=!0},p(e,[l]){const W={};l&2&&(W.$$scope={dirty:l,ctx:e}),ee.$set(W);const D={};l&2&&(D.$$scope={dirty:l,ctx:e}),ne.$set(D);const H={};l&2&&(H.$$scope={dirty:l,ctx:e}),te.$set(H);const B={};l&2&&(B.$$scope={dirty:l,ctx:e}),ae.$set(B);const Y={};l&2&&(Y.$$scope={dirty:l,ctx:e}),se.$set(Y);const G={};l&2&&(G.$$scope={dirty:l,ctx:e}),ie.$set(G);const A={};l&2&&(A.$$scope={dirty:l,ctx:e}),re.$set(A);const Fe={};l&2&&(Fe.$$scope={dirty:l,ctx:e}),le.$set(Fe);const K={};l&2&&(K.$$scope={dirty:l,ctx:e}),pe.$set(K);const O={};l&2&&(O.$$scope={dirty:l,ctx:e}),ce.$set(O)},i(e){Qn||(_(g.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(ke.$$.fragment,e),_(we.$$.fragment,e),_(Me.$$.fragment,e),_(te.$$.fragment,e),_(Te.$$.fragment,e),_(ae.$$.fragment,e),_(Ie.$$.fragment,e),_(ve.$$.fragment,e),_(Je.$$.fragment,e),_(se.$$.fragment,e),_(Pe.$$.fragment,e),_(Ue.$$.fragment,e),_(xe.$$.fragment,e),_(ie.$$.fragment,e),_(Ce.$$.fragment,e),_(je.$$.fragment,e),_($e.$$.fragment,e),_(Ze.$$.fragment,e),_(re.$$.fragment,e),_(We.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(le.$$.fragment,e),_(Ke.$$.fragment,e),_(Ve.$$.fragment,e),_(qe.$$.fragment,e),_(Le.$$.fragment,e),_(pe.$$.fragment,e),_(ze.$$.fragment,e),_(Ne.$$.fragment,e),_(Ee.$$.fragment,e),_(ce.$$.fragment,e),_(Qe.$$.fragment,e),_(Re.$$.fragment,e),Qn=!0)},o(e){y(g.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(ke.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(te.$$.fragment,e),y(Te.$$.fragment,e),y(ae.$$.fragment,e),y(Ie.$$.fragment,e),y(ve.$$.fragment,e),y(Je.$$.fragment,e),y(se.$$.fragment,e),y(Pe.$$.fragment,e),y(Ue.$$.fragment,e),y(xe.$$.fragment,e),y(ie.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y($e.$$.fragment,e),y(Ze.$$.fragment,e),y(re.$$.fragment,e),y(We.$$.fragment,e),y(Ge.$$.fragment,e),y(Be.$$.fragment,e),y(le.$$.fragment,e),y(Ke.$$.fragment,e),y(Ve.$$.fragment,e),y(qe.$$.fragment,e),y(Le.$$.fragment,e),y(pe.$$.fragment,e),y(ze.$$.fragment,e),y(Ne.$$.fragment,e),y(Ee.$$.fragment,e),y(ce.$$.fragment,e),y(Qe.$$.fragment,e),y(Re.$$.fragment,e),Qn=!1},d(e){e&&(s(M),s(c),s(r),s(n),s(k),s(Tn),s(_e),s(In),s(ye),s(vn),s(be),s(Jn),s(Pn),s(Un),s(xn),s(P),s(Cn),s(jn),s(j),s($n),s(Zn),s(U),s(Wn),s(Gn),s($),s(Bn),s(Kn),s(x),s(Vn),s(qn),s(Z),s(Ln),s(zn),s(C),s(Nn),s(En),s(Mn)),s(t),b(g,e),b(ee,e),b(ne,e),b(ke,e),b(we),b(Me),b(te),b(Te),b(ae),b(Ie,e),b(ve),b(Je),b(se),b(Pe,e),b(Ue),b(xe),b(ie),b(Ce),b(je,e),b($e),b(Ze),b(re),b(We,e),b(Ge),b(Be),b(le),b(Ke),b(Ve,e),b(qe),b(Le),b(pe),b(ze,e),b(Ne),b(Ee),b(ce),b(Qe),b(Re,e)}}}const Ca='{"title":"Kandinsky 2.1","local":"kandinsky-21","sections":[{"title":"KandinskyPriorPipeline","local":"diffusers.KandinskyPriorPipeline","sections":[],"depth":2},{"title":"KandinskyPipeline","local":"diffusers.KandinskyPipeline","sections":[],"depth":2},{"title":"KandinskyCombinedPipeline","local":"diffusers.KandinskyCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyImg2ImgPipeline","local":"diffusers.KandinskyImg2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyImg2ImgCombinedPipeline","local":"diffusers.KandinskyImg2ImgCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyInpaintPipeline","local":"diffusers.KandinskyInpaintPipeline","sections":[],"depth":2},{"title":"KandinskyInpaintCombinedPipeline","local":"diffusers.KandinskyInpaintCombinedPipeline","sections":[],"depth":2}],"depth":1}';function ja(T){return ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends fa{constructor(t){super(),ha(this,t,ja,xa,ga,{})}}export{qa as component};
