import{s as pl,o as rl,n as v}from"../chunks/scheduler.8c3d61f6.js";import{S as cl,i as ml,g,s as h,r as U,A as dl,h as w,f as o,c as f,j as ol,u as T,x as C,k as $,y as Ml,a as p,v as b,d as j,t as Z,w as W}from"../chunks/index.589a98e8.js";import{T as Me}from"../chunks/Tip.42aa8582.js";import{C as R}from"../chunks/CodeBlock.36627b28.js";import{D as ul}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as Q,E as hl}from"../chunks/EditOnGithub.e5a8d9cb.js";import{H as de,a as N}from"../chunks/HfOption.9804ab8b.js";function fl(G){let l,d='LCMs and LCM-LoRAs are available for Stable Diffusion v1.5, Stable Diffusion XL, and the SSD-1B model. You can find their checkpoints on the <a href="https://hf.co/collections/latent-consistency/latent-consistency-models-weights-654ce61a95edd6dffccef6a8" rel="nofollow">Latent Consistency</a> Collections.';return{c(){l=g("p"),l.innerHTML=d},l(t){l=w(t,"P",{"data-svelte-h":!0}),C(l)!=="svelte-1hbl1bd"&&(l.innerHTML=d)},m(t,i){p(t,l,i)},p:v,d(t){t&&o(l)}}}function yl(G){let l,d='To use LCMs, you need to load the LCM checkpoint for your supported model into <a href="/docs/diffusers/pr_8491/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the pipeline as usual, and pass a text prompt to generate an image in just 4 steps.',t,i,s="A couple of notes to keep in mind when using LCMs are:",a,M,m="<li>Typically, batch size is doubled inside the pipeline for classifier-free guidance. But LCM applies guidance with guidance embeddings and doesn’t need to double the batch size, which leads to faster inference. The downside is that negative prompts don’t work with LCM because they don’t have any effect on the denoising process.</li> <li>The ideal range for <code>guidance_scale</code> is [3., 13.] because that is what the UNet was trained with. However, disabling <code>guidance_scale</code> with a value of 1.0 is also effective in most cases.</li>",r,y,n,u,B='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdxl_t2i.png"/>',_;return y=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tc2R4bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjAlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">8.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),i=g("p"),i.textContent=s,a=h(),M=g("ul"),M.innerHTML=m,r=h(),U(y.$$.fragment),n=h(),u=g("div"),u.innerHTML=B,this.h()},l(J){l=w(J,"P",{"data-svelte-h":!0}),C(l)!=="svelte-1ek4ppi"&&(l.innerHTML=d),t=f(J),i=w(J,"P",{"data-svelte-h":!0}),C(i)!=="svelte-185mgq9"&&(i.textContent=s),a=f(J),M=w(J,"UL",{"data-svelte-h":!0}),C(M)!=="svelte-1mvqiqn"&&(M.innerHTML=m),r=f(J),T(y.$$.fragment,J),n=f(J),u=w(J,"DIV",{class:!0,"data-svelte-h":!0}),C(u)!=="svelte-r54e1a"&&(u.innerHTML=B),this.h()},h(){$(u,"class","flex justify-center")},m(J,I){p(J,l,I),p(J,t,I),p(J,i,I),p(J,a,I),p(J,M,I),p(J,r,I),b(y,J,I),p(J,n,I),p(J,u,I),_=!0},p:v,i(J){_||(j(y.$$.fragment,J),_=!0)},o(J){Z(y.$$.fragment,J),_=!1},d(J){J&&(o(l),o(t),o(i),o(a),o(M),o(r),o(n),o(u)),W(y,J)}}}function Jl(G){let l,d='To use LCM-LoRAs, you need to replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt to generate an image in just 4 steps.',t,i,s="A couple of notes to keep in mind when using LCM-LoRAs are:",a,M,m='<li>Typically, batch size is doubled inside the pipeline for classifier-free guidance. But LCM applies guidance with guidance embeddings and doesn’t need to double the batch size, which leads to faster inference. The downside is that negative prompts don’t work with LCM because they don’t have any effect on the denoising process.</li> <li>You could use guidance with LCM-LoRAs, but it is very sensitive to high <code>guidance_scale</code> values and can lead to artifacts in the generated image. The best values we’ve found are between [1.0, 2.0].</li> <li>Replace <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with any finetuned model. For example, try using the <a href="https://huggingface.co/Linaqruf/animagine-xl" rel="nofollow">animagine-xl</a> checkpoint to generate anime images with SDXL.</li>',r,y,n,u,B='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdxl_t2i.png"/>',_;return y=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU2VsZi1wb3J0cmFpdCUyMG9pbCUyMHBhaW50aW5nJTJDJTIwYSUyMGJlYXV0aWZ1bCUyMGN5Ym9yZyUyMHdpdGglMjBnb2xkZW4lMjBoYWlyJTJDJTIwOGslMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuMCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">42</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">1.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),i=g("p"),i.textContent=s,a=h(),M=g("ul"),M.innerHTML=m,r=h(),U(y.$$.fragment),n=h(),u=g("div"),u.innerHTML=B,this.h()},l(J){l=w(J,"P",{"data-svelte-h":!0}),C(l)!=="svelte-b3xfl8"&&(l.innerHTML=d),t=f(J),i=w(J,"P",{"data-svelte-h":!0}),C(i)!=="svelte-1l0tu8o"&&(i.textContent=s),a=f(J),M=w(J,"UL",{"data-svelte-h":!0}),C(M)!=="svelte-yd1arq"&&(M.innerHTML=m),r=f(J),T(y.$$.fragment,J),n=f(J),u=w(J,"DIV",{class:!0,"data-svelte-h":!0}),C(u)!=="svelte-1qjqi5a"&&(u.innerHTML=B),this.h()},h(){$(u,"class","flex justify-center")},m(J,I){p(J,l,I),p(J,t,I),p(J,i,I),p(J,a,I),p(J,M,I),p(J,r,I),b(y,J,I),p(J,n,I),p(J,u,I),_=!0},p:v,i(J){_||(j(y.$$.fragment,J),_=!0)},o(J){Z(y.$$.fragment,J),_=!1},d(J){J&&(o(l),o(t),o(i),o(a),o(M),o(r),o(n),o(u)),W(y,J)}}}function gl(G){let l,d,t,i;return l=new N({props:{id:"lcm-text2img",option:"LCM",$$slots:{default:[yl]},$$scope:{ctx:G}}}),t=new N({props:{id:"lcm-text2img",option:"LCM-LoRA",$$slots:{default:[Jl]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=h(),U(t.$$.fragment)},l(s){T(l.$$.fragment,s),d=f(s),T(t.$$.fragment,s)},m(s,a){b(l,s,a),p(s,d,a),b(t,s,a),i=!0},p(s,a){const M={};a&2&&(M.$$scope={dirty:a,ctx:s}),l.$set(M);const m={};a&2&&(m.$$scope={dirty:a,ctx:s}),t.$set(m)},i(s){i||(j(l.$$.fragment,s),j(t.$$.fragment,s),i=!0)},o(s){Z(l.$$.fragment,s),Z(t.$$.fragment,s),i=!1},d(s){s&&o(d),W(l,s),W(t,s)}}}function wl(G){let l,d="Experiment with different values for <code>num_inference_steps</code>, <code>strength</code>, and <code>guidance_scale</code> to get the best results.";return{c(){l=g("p"),l.innerHTML=d},l(t){l=w(t,"P",{"data-svelte-h":!0}),C(l)!=="svelte-cgukyv"&&(l.innerHTML=d)},m(t,i){p(t,l,i)},p:v,d(t){t&&o(l)}}}function Ul(G){let l,d='To use LCMs for image-to-image, you need to load the LCM checkpoint for your supported model into <a href="/docs/diffusers/pr_8491/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the pipeline as usual, and pass a text prompt and initial image to generate an image in just 4 steps.',t,i,s,a,M,m,r='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',y;return i=new Me({props:{warning:!1,$$slots:{default:[wl]},$$scope:{ctx:G}}}),a=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTHlrb24lMkZkcmVhbXNoYXBlci03JTIyJTJDJTBBJTIwJTIwJTIwJTIwdW5ldCUzRHVuZXQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXRzJTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>,
    subfolder=<span class="hljs-string">&quot;unet&quot;</span>,
    torch_dtype=torch.float16,
)

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>,
    unet=unet,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronauts in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt,
    image=init_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),U(a.$$.fragment),M=h(),m=g("div"),m.innerHTML=r,this.h()},l(n){l=w(n,"P",{"data-svelte-h":!0}),C(l)!=="svelte-11pffk0"&&(l.innerHTML=d),t=f(n),T(i.$$.fragment,n),s=f(n),T(a.$$.fragment,n),M=f(n),m=w(n,"DIV",{class:!0,"data-svelte-h":!0}),C(m)!=="svelte-f0uu5w"&&(m.innerHTML=r),this.h()},h(){$(m,"class","flex gap-4")},m(n,u){p(n,l,u),p(n,t,u),b(i,n,u),p(n,s,u),b(a,n,u),p(n,M,u),p(n,m,u),y=!0},p(n,u){const B={};u&2&&(B.$$scope={dirty:u,ctx:n}),i.$set(B)},i(n){y||(j(i.$$.fragment,n),j(a.$$.fragment,n),y=!0)},o(n){Z(i.$$.fragment,n),Z(a.$$.fragment,n),y=!1},d(n){n&&(o(l),o(t),o(s),o(M),o(m)),W(i,n),W(a,n)}}}function Tl(G){let l,d="Experiment with different values for <code>num_inference_steps</code>, <code>strength</code>, and <code>guidance_scale</code> to get the best results.";return{c(){l=g("p"),l.innerHTML=d},l(t){l=w(t,"P",{"data-svelte-h":!0}),C(l)!=="svelte-cgukyv"&&(l.innerHTML=d)},m(t,i){p(t,l,i)},p:v,d(t){t&&o(l)}}}function bl(G){let l,d='To use LCM-LoRAs for image-to-image, you need to replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt and initial image to generate an image in just 4 steps.',t,i,s,a,M,m,r='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',y;return i=new Me({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:G}}}),a=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMkMlMjBMQ01TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTHlrb24lMkZkcmVhbXNoYXBlci03JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0cyUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC42JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronauts in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt,
    image=init_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
    strength=<span class="hljs-number">0.6</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),U(a.$$.fragment),M=h(),m=g("div"),m.innerHTML=r,this.h()},l(n){l=w(n,"P",{"data-svelte-h":!0}),C(l)!=="svelte-j5khr8"&&(l.innerHTML=d),t=f(n),T(i.$$.fragment,n),s=f(n),T(a.$$.fragment,n),M=f(n),m=w(n,"DIV",{class:!0,"data-svelte-h":!0}),C(m)!=="svelte-1n6qllf"&&(m.innerHTML=r),this.h()},h(){$(m,"class","flex gap-4")},m(n,u){p(n,l,u),p(n,t,u),b(i,n,u),p(n,s,u),b(a,n,u),p(n,M,u),p(n,m,u),y=!0},p(n,u){const B={};u&2&&(B.$$scope={dirty:u,ctx:n}),i.$set(B)},i(n){y||(j(i.$$.fragment,n),j(a.$$.fragment,n),y=!0)},o(n){Z(i.$$.fragment,n),Z(a.$$.fragment,n),y=!1},d(n){n&&(o(l),o(t),o(s),o(M),o(m)),W(i,n),W(a,n)}}}function jl(G){let l,d,t,i;return l=new N({props:{id:"lcm-img2img",option:"LCM",$$slots:{default:[Ul]},$$scope:{ctx:G}}}),t=new N({props:{id:"lcm-img2img",option:"LCM-LoRA",$$slots:{default:[bl]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=h(),U(t.$$.fragment)},l(s){T(l.$$.fragment,s),d=f(s),T(t.$$.fragment,s)},m(s,a){b(l,s,a),p(s,d,a),b(t,s,a),i=!0},p(s,a){const M={};a&2&&(M.$$scope={dirty:a,ctx:s}),l.$set(M);const m={};a&2&&(m.$$scope={dirty:a,ctx:s}),t.$set(m)},i(s){i||(j(l.$$.fragment,s),j(t.$$.fragment,s),i=!0)},o(s){Z(l.$$.fragment,s),Z(t.$$.fragment,s),i=!1},d(s){s&&o(d),W(l,s),W(t,s)}}}function Zl(G){let l,d='Load the LCM checkpoint for your supported model into <a href="/docs/diffusers/pr_8491/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LoRA weights into the LCM and generate a styled image in a few steps.',t,i,s,a,M='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdx_lora_mix.png"/>',m;return i=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tc2R4bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMlRoZUxhc3RCZW4lMkZQYXBlcmN1dF9TRFhMJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwYXBlcmN1dC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBhcGVyY3V0JTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnBhcGVyY3V0JTJDJTIwYSUyMGN1dGUlMjBmb3glMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipe.load_lora_weights(<span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>, weight_name=<span class="hljs-string">&quot;papercut.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;papercut&quot;</span>)

prompt = <span class="hljs-string">&quot;papercut, a cute fox&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">8.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),a=g("div"),a.innerHTML=M,this.h()},l(r){l=w(r,"P",{"data-svelte-h":!0}),C(l)!=="svelte-ws0jvx"&&(l.innerHTML=d),t=f(r),T(i.$$.fragment,r),s=f(r),a=w(r,"DIV",{class:!0,"data-svelte-h":!0}),C(a)!=="svelte-1205m44"&&(a.innerHTML=M),this.h()},h(){$(a,"class","flex justify-center")},m(r,y){p(r,l,y),p(r,t,y),b(i,r,y),p(r,s,y),p(r,a,y),m=!0},p:v,i(r){m||(j(i.$$.fragment,r),m=!0)},o(r){Z(i.$$.fragment,r),m=!1},d(r){r&&(o(l),o(t),o(s),o(a)),W(i,r)}}}function Wl(G){let l,d='Replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights and the style LoRA you want to use. Combine both LoRA adapters with the <a href="/docs/diffusers/pr_8491/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method and generate a styled image in a few steps.',t,i,s,a,M='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdx_lora_mix.png"/>',m;return i=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20lMjIpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJUaGVMYXN0QmVuJTJGUGFwZXJjdXRfU0RYTCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGFwZXJjdXQuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJwYXBlcmN1dCUyMiklMEElMEFwaXBlLnNldF9hZGFwdGVycyglNUIlMjJsY20lMjIlMkMlMjAlMjJwYXBlcmN1dCUyMiU1RCUyQyUyMGFkYXB0ZXJfd2VpZ2h0cyUzRCU1QjEuMCUyQyUyMDAuOCU1RCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJwYXBlcmN1dCUyQyUyMGElMjBjdXRlJTIwZm94JTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDElMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>, weight_name=<span class="hljs-string">&quot;papercut.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;papercut&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;papercut&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>])

prompt = <span class="hljs-string">&quot;papercut, a cute fox&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1</span>, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),a=g("div"),a.innerHTML=M,this.h()},l(r){l=w(r,"P",{"data-svelte-h":!0}),C(l)!=="svelte-1txv1lu"&&(l.innerHTML=d),t=f(r),T(i.$$.fragment,r),s=f(r),a=w(r,"DIV",{class:!0,"data-svelte-h":!0}),C(a)!=="svelte-1onami8"&&(a.innerHTML=M),this.h()},h(){$(a,"class","flex justify-center")},m(r,y){p(r,l,y),p(r,t,y),b(i,r,y),p(r,s,y),p(r,a,y),m=!0},p:v,i(r){m||(j(i.$$.fragment,r),m=!0)},o(r){Z(i.$$.fragment,r),m=!1},d(r){r&&(o(l),o(t),o(s),o(a)),W(i,r)}}}function Cl(G){let l,d,t,i;return l=new N({props:{id:"lcm-lora",option:"LCM",$$slots:{default:[Zl]},$$scope:{ctx:G}}}),t=new N({props:{id:"lcm-lora",option:"LCM-LoRA",$$slots:{default:[Wl]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=h(),U(t.$$.fragment)},l(s){T(l.$$.fragment,s),d=f(s),T(t.$$.fragment,s)},m(s,a){b(l,s,a),p(s,d,a),b(t,s,a),i=!0},p(s,a){const M={};a&2&&(M.$$scope={dirty:a,ctx:s}),l.$set(M);const m={};a&2&&(m.$$scope={dirty:a,ctx:s}),t.$set(m)},i(s){i||(j(l.$$.fragment,s),j(t.$$.fragment,s),i=!0)},o(s){Z(l.$$.fragment,s),Z(t.$$.fragment,s),i=!1},d(s){s&&o(d),W(l,s),W(t,s)}}}function Gl(G){let l,d="Experiment with different values for <code>num_inference_steps</code>, <code>controlnet_conditioning_scale</code>, <code>cross_attention_kwargs</code>, and <code>guidance_scale</code> to get the best results.";return{c(){l=g("p"),l.innerHTML=d},l(t){l=w(t,"P",{"data-svelte-h":!0}),C(l)!=="svelte-doxm01"&&(l.innerHTML=d)},m(t,i){p(t,l,i)},p:v,d(t){t&&o(l)}}}function Il(G){let l,d='Load a ControlNet model trained on canny images and pass it to the <a href="/docs/diffusers/pr_8491/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. Then you can load a LCM model into <a href="/docs/diffusers/pr_8491/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Now pass the canny image to the pipeline and generate an image.',t,i,s,a,M,m,r='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdv1-5_controlnet.png"/>',y;return i=new Me({props:{warning:!1,$$slots:{default:[Gl]},$$scope:{ctx:G}}}),a=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
make_image_grid([canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),U(a.$$.fragment),M=h(),m=g("div"),m.innerHTML=r,this.h()},l(n){l=w(n,"P",{"data-svelte-h":!0}),C(l)!=="svelte-1lgkl23"&&(l.innerHTML=d),t=f(n),T(i.$$.fragment,n),s=f(n),T(a.$$.fragment,n),M=f(n),m=w(n,"DIV",{class:!0,"data-svelte-h":!0}),C(m)!=="svelte-1f4gba0"&&(m.innerHTML=r),this.h()},h(){$(m,"class","flex justify-center")},m(n,u){p(n,l,u),p(n,t,u),b(i,n,u),p(n,s,u),b(a,n,u),p(n,M,u),p(n,m,u),y=!0},p(n,u){const B={};u&2&&(B.$$scope={dirty:u,ctx:n}),i.$set(B)},i(n){y||(j(i.$$.fragment,n),j(a.$$.fragment,n),y=!0)},o(n){Z(i.$$.fragment,n),Z(a.$$.fragment,n),y=!1},d(n){n&&(o(l),o(t),o(s),o(M),o(m)),W(i,n),W(a,n)}}}function Bl(G){let l,d="Experiment with different values for <code>num_inference_steps</code>, <code>controlnet_conditioning_scale</code>, <code>cross_attention_kwargs</code>, and <code>guidance_scale</code> to get the best results.";return{c(){l=g("p"),l.innerHTML=d},l(t){l=w(t,"P",{"data-svelte-h":!0}),C(l)!=="svelte-doxm01"&&(l.innerHTML=d)},m(t,i){p(t,l,i)},p:v,d(t){t&&o(l)}}}function _l(G){let l,d='Load a ControlNet model trained on canny images and pass it to the <a href="/docs/diffusers/pr_8491/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. Then you can load a Stable Diffusion v1.5 model into <a href="/docs/diffusers/pr_8491/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Use the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights, and pass the canny image to the pipeline and generate an image.',t,i,s,a,M,m,r='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_controlnet.png"/>',y;return i=new Me({props:{warning:!1,$$slots:{default:[Bl]},$$scope:{ctx:G}}}),a=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    controlnet_conditioning_scale=<span class="hljs-number">0.8</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),U(a.$$.fragment),M=h(),m=g("div"),m.innerHTML=r,this.h()},l(n){l=w(n,"P",{"data-svelte-h":!0}),C(l)!=="svelte-91ikcw"&&(l.innerHTML=d),t=f(n),T(i.$$.fragment,n),s=f(n),T(a.$$.fragment,n),M=f(n),m=w(n,"DIV",{class:!0,"data-svelte-h":!0}),C(m)!=="svelte-1s0658k"&&(m.innerHTML=r),this.h()},h(){$(m,"class","flex justify-center")},m(n,u){p(n,l,u),p(n,t,u),b(i,n,u),p(n,s,u),b(a,n,u),p(n,M,u),p(n,m,u),y=!0},p(n,u){const B={};u&2&&(B.$$scope={dirty:u,ctx:n}),i.$set(B)},i(n){y||(j(i.$$.fragment,n),j(a.$$.fragment,n),y=!0)},o(n){Z(i.$$.fragment,n),Z(a.$$.fragment,n),y=!1},d(n){n&&(o(l),o(t),o(s),o(M),o(m)),W(i,n),W(a,n)}}}function $l(G){let l,d,t,i;return l=new N({props:{id:"lcm-controlnet",option:"LCM",$$slots:{default:[Il]},$$scope:{ctx:G}}}),t=new N({props:{id:"lcm-controlnet",option:"LCM-LoRA",$$slots:{default:[_l]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=h(),U(t.$$.fragment)},l(s){T(l.$$.fragment,s),d=f(s),T(t.$$.fragment,s)},m(s,a){b(l,s,a),p(s,d,a),b(t,s,a),i=!0},p(s,a){const M={};a&2&&(M.$$scope={dirty:a,ctx:s}),l.$set(M);const m={};a&2&&(m.$$scope={dirty:a,ctx:s}),t.$set(m)},i(s){i||(j(l.$$.fragment,s),j(t.$$.fragment,s),i=!0)},o(s){Z(l.$$.fragment,s),Z(t.$$.fragment,s),i=!1},d(s){s&&o(d),W(l,s),W(t,s)}}}function Rl(G){let l,d='Load a T2IAdapter trained on canny images and pass it to the <a href="/docs/diffusers/pr_8491/en/api/pipelines/stable_diffusion/adapter#diffusers.StableDiffusionXLAdapterPipeline">StableDiffusionXLAdapterPipeline</a>. Then load a LCM checkpoint into <a href="/docs/diffusers/pr_8491/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Now pass the canny image to the pipeline and generate an image.',t,i,s,a,M='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-t2i.png"/>',m;return i=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, UNet2DConditionModel, T2IAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># detect the canny map in low resolution to avoid high-frequency details</span>
image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">384</span>, <span class="hljs-number">384</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1216</span>))

adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, varient=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    unet=unet,
    adapter=adapter,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>, 
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;the mona lisa, 4k picture, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;extra digit, fewer digits, cropped, worst quality, low quality, glitch, deformed, mutated, ugly, disfigured&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    adapter_conditioning_scale=<span class="hljs-number">0.8</span>, 
    adapter_conditioning_factor=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),a=g("div"),a.innerHTML=M,this.h()},l(r){l=w(r,"P",{"data-svelte-h":!0}),C(l)!=="svelte-1ssmt0"&&(l.innerHTML=d),t=f(r),T(i.$$.fragment,r),s=f(r),a=w(r,"DIV",{class:!0,"data-svelte-h":!0}),C(a)!=="svelte-1m6j6i7"&&(a.innerHTML=M),this.h()},h(){$(a,"class","flex justify-center")},m(r,y){p(r,l,y),p(r,t,y),b(i,r,y),p(r,s,y),p(r,a,y),m=!0},p:v,i(r){m||(j(i.$$.fragment,r),m=!0)},o(r){Z(i.$$.fragment,r),m=!1},d(r){r&&(o(l),o(t),o(s),o(a)),W(i,r)}}}function vl(G){let l,d='Load a T2IAdapter trained on canny images and pass it to the <a href="/docs/diffusers/pr_8491/en/api/pipelines/stable_diffusion/adapter#diffusers.StableDiffusionXLAdapterPipeline">StableDiffusionXLAdapterPipeline</a>. Replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>, and use the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights. Pass the canny image to the pipeline and generate an image.',t,i,s,a,M='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-t2i.png"/>',m;return i=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, UNet2DConditionModel, T2IAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># detect the canny map in low resolution to avoid high-frequency details</span>
image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">384</span>, <span class="hljs-number">384</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, varient=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, 
    adapter=adapter,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>, 
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;the mona lisa, 4k picture, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;extra digit, fewer digits, cropped, worst quality, low quality, glitch, deformed, mutated, ugly, disfigured&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>, 
    adapter_conditioning_scale=<span class="hljs-number">0.8</span>, 
    adapter_conditioning_factor=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=g("p"),l.innerHTML=d,t=h(),U(i.$$.fragment),s=h(),a=g("div"),a.innerHTML=M,this.h()},l(r){l=w(r,"P",{"data-svelte-h":!0}),C(l)!=="svelte-3tzh15"&&(l.innerHTML=d),t=f(r),T(i.$$.fragment,r),s=f(r),a=w(r,"DIV",{class:!0,"data-svelte-h":!0}),C(a)!=="svelte-djnrvk"&&(a.innerHTML=M),this.h()},h(){$(a,"class","flex justify-center")},m(r,y){p(r,l,y),p(r,t,y),b(i,r,y),p(r,s,y),p(r,a,y),m=!0},p:v,i(r){m||(j(i.$$.fragment,r),m=!0)},o(r){Z(i.$$.fragment,r),m=!1},d(r){r&&(o(l),o(t),o(s),o(a)),W(i,r)}}}function Nl(G){let l,d,t,i;return l=new N({props:{id:"lcm-t2i",option:"LCM",$$slots:{default:[Rl]},$$scope:{ctx:G}}}),t=new N({props:{id:"lcm-t2i",option:"LCM-LoRA",$$slots:{default:[vl]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=h(),U(t.$$.fragment)},l(s){T(l.$$.fragment,s),d=f(s),T(t.$$.fragment,s)},m(s,a){b(l,s,a),p(s,d,a),b(t,s,a),i=!0},p(s,a){const M={};a&2&&(M.$$scope={dirty:a,ctx:s}),l.$set(M);const m={};a&2&&(m.$$scope={dirty:a,ctx:s}),t.$set(m)},i(s){i||(j(l.$$.fragment,s),j(t.$$.fragment,s),i=!0)},o(s){Z(l.$$.fragment,s),Z(t.$$.fragment,s),i=!1},d(s){s&&o(d),W(l,s),W(t,s)}}}function Ql(G){let l,d,t,i,s,a,M,m,r,y='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> enable fast high-quality image generation by directly predicting the reverse diffusion process in the latent rather than pixel space. In other words, LCMs try to predict the noiseless image from the noisy image in contrast to typical diffusion models that iteratively remove noise from the noisy image. By avoiding the iterative sampling process, LCMs are able to generate high-quality images in 2-4 steps instead of 20-30 steps.',n,u,B='LCMs are distilled from pretrained models which requires ~32 hours of A100 compute. To speed this up, <a href="https://hf.co/papers/2311.05556" rel="nofollow">LCM-LoRAs</a> train a <a href="https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora" rel="nofollow">LoRA adapter</a> which have much fewer parameters to train compared to the full model. The LCM-LoRA can be plugged into a diffusion model once it has been trained.',_,J,I="This guide will show you how to use LCMs and LCM-LoRAs for fast inference on tasks and how to use them with other adapters like ControlNet or T2I-Adapter.",ue,E,he,H,fe,k,ye,x,Je,V,ge,A,we,z,Fe='To use LCM-LoRAs for inpainting, you need to replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/pr_8491/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt, initial image, and mask image to generate an image in just 4 steps.',Ue,q,Te,X,He='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',be,D,je,K,xe="LCMs are compatible with adapters like LoRA, ControlNet, T2I-Adapter, and AnimateDiff. You can bring the speed of LCMs to these adapters to generate images in a certain style or condition the model on another input like a canny image.",Ze,P,We,O,Ae='<a href="../using-diffusers/loading_adapters#lora">LoRA</a> adapters can be rapidly finetuned to learn a new style from just a few images and plugged into a pretrained model to generate images in that style.',Ce,L,Ge,ee,Ie,le,ze='<a href="./controlnet">ControlNet</a> are adapters that can be trained on a variety of inputs like canny edge, pose estimation, or depth. The ControlNet can be inserted into the pipeline to provide additional conditioning and control to the model for more accurate generation.',Be,se,qe='You can find additional ControlNet models trained on other inputs in <a href="https://hf.co/lllyasviel" rel="nofollow">lllyasviel’s</a> repository.',_e,S,$e,te,Re,ae,De='<a href="./t2i_adapter">T2I-Adapter</a> is an even more lightweight adapter than ControlNet, that provides an additional input to condition a pretrained model with. It is faster than ControlNet but the results may be slightly worse.',ve,ne,Ke='You can find additional T2I-Adapter checkpoints trained on other inputs in <a href="https://hf.co/TencentARC" rel="nofollow">TencentArc’s</a> repository.',Ne,Y,Qe,ie,Ee,oe,Pe='<a href="../api/pipelines/animatediff">AnimateDiff</a> is an adapter that adds motion to an image. It can be used with most Stable Diffusion models, effectively turning them into “video generation” models. Generating good results with a video model usually requires generating multiple frames (16-24), which can be very slow with a regular Stable Diffusion model. LCM-LoRA can speed up this process by only taking 4-8 steps for each frame.',ke,pe,Oe='Load a <a href="/docs/diffusers/pr_8491/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and pass a <code>MotionAdapter</code> to it. Then replace the scheduler with the <a href="/docs/diffusers/pr_8491/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>, and combine both LoRA adapters with the <a href="/docs/diffusers/pr_8491/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method. Now you can pass a prompt to the pipeline and generate an animated image.',Ve,re,Xe,F,el='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-animatediff.gif"/>',Le,ce,Se,me,Ye;return s=new Q({props:{title:"Latent Consistency Model",local:"latent-consistency-model",headingTag:"h1"}}),M=new ul({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm.ipynb"}]}}),E=new Me({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:G}}}),H=new Q({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),k=new de({props:{id:"lcm-text2img",options:["LCM","LCM-LoRA"],$$slots:{default:[gl]},$$scope:{ctx:G}}}),x=new Q({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),V=new de({props:{id:"lcm-img2img",options:["LCM","LCM-LoRA"],$$slots:{default:[jl]},$$scope:{ctx:G}}}),A=new Q({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),q=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUyQyUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0JTJDJTIwJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">4</span>, 
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new Q({props:{title:"Adapters",local:"adapters",headingTag:"h2"}}),P=new Q({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),L=new de({props:{id:"lcm-lora",options:["LCM","LCM-LoRA"],$$slots:{default:[Cl]},$$scope:{ctx:G}}}),ee=new Q({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),S=new de({props:{id:"lcm-controlnet",options:["LCM","LCM-LoRA"],$$slots:{default:[$l]},$$scope:{ctx:G}}}),te=new Q({props:{title:"T2I-Adapter",local:"t2i-adapter",headingTag:"h3"}}),Y=new de({props:{id:"lcm-t2i",options:["LCM","LCM-LoRA"],$$slots:{default:[Nl]},$$scope:{ctx:G}}}),ie=new Q({props:{title:"AnimateDiff",local:"animatediff",headingTag:"h3"}}),re=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTJDJTIwTENNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNSUyMiklMEFwaXBlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnJhbmtqb3NodWElMkZ0b29ueW91X2JldGE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTENNLUxvUkElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmxjbSUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1sb3JhLXpvb20taW4lMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIybW90aW9uLWxvcmElMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIybGNtJTIyJTJDJTIwJTIybW90aW9uLWxvcmElMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjU1JTJDJTIwMS4yJTVEKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmJlc3QlMjBxdWFsaXR5JTJDJTIwbWFzdGVycGllY2UlMkMlMjAxZ2lybCUyQyUyMGxvb2tpbmclMjBhdCUyMHZpZXdlciUyQyUyMGJsdXJyeSUyMGJhY2tncm91bmQlMkMlMjB1cHBlciUyMGJvZHklMkMlMjBjb250ZW1wb3JhcnklMkMlMjBkcmVzcyUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBZnJhbWVzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4yNSUyQyUwQSUyMCUyMCUyMCUyMGNyb3NzX2F0dGVudGlvbl9rd2FyZ3MlM0QlN0IlMjJzY2FsZSUyMiUzQSUyMDElN0QlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMjQlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(
    <span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>,
    motion_adapter=adapter,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-in&quot;</span>, weight_name=<span class="hljs-string">&quot;diffusion_pytorch_model.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;motion-lora&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;motion-lora&quot;</span>], adapter_weights=[<span class="hljs-number">0.55</span>, <span class="hljs-number">1.2</span>])

prompt = <span class="hljs-string">&quot;best quality, masterpiece, 1girl, looking at viewer, blurry background, upper body, contemporary, dress&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
frames = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">5</span>,
    guidance_scale=<span class="hljs-number">1.25</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    num_frames=<span class="hljs-number">24</span>,
    generator=generator
).frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ce=new hl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/inference_with_lcm.md"}}),{c(){l=g("meta"),d=h(),t=g("p"),i=h(),U(s.$$.fragment),a=h(),U(M.$$.fragment),m=h(),r=g("p"),r.innerHTML=y,n=h(),u=g("p"),u.innerHTML=B,_=h(),J=g("p"),J.textContent=I,ue=h(),U(E.$$.fragment),he=h(),U(H.$$.fragment),fe=h(),U(k.$$.fragment),ye=h(),U(x.$$.fragment),Je=h(),U(V.$$.fragment),ge=h(),U(A.$$.fragment),we=h(),z=g("p"),z.innerHTML=Fe,Ue=h(),U(q.$$.fragment),Te=h(),X=g("div"),X.innerHTML=He,be=h(),U(D.$$.fragment),je=h(),K=g("p"),K.textContent=xe,Ze=h(),U(P.$$.fragment),We=h(),O=g("p"),O.innerHTML=Ae,Ce=h(),U(L.$$.fragment),Ge=h(),U(ee.$$.fragment),Ie=h(),le=g("p"),le.innerHTML=ze,Be=h(),se=g("p"),se.innerHTML=qe,_e=h(),U(S.$$.fragment),$e=h(),U(te.$$.fragment),Re=h(),ae=g("p"),ae.innerHTML=De,ve=h(),ne=g("p"),ne.innerHTML=Ke,Ne=h(),U(Y.$$.fragment),Qe=h(),U(ie.$$.fragment),Ee=h(),oe=g("p"),oe.innerHTML=Pe,ke=h(),pe=g("p"),pe.innerHTML=Oe,Ve=h(),U(re.$$.fragment),Xe=h(),F=g("div"),F.innerHTML=el,Le=h(),U(ce.$$.fragment),Se=h(),me=g("p"),this.h()},l(e){const c=dl("svelte-u9bgzb",document.head);l=w(c,"META",{name:!0,content:!0}),c.forEach(o),d=f(e),t=w(e,"P",{}),ol(t).forEach(o),i=f(e),T(s.$$.fragment,e),a=f(e),T(M.$$.fragment,e),m=f(e),r=w(e,"P",{"data-svelte-h":!0}),C(r)!=="svelte-fadb22"&&(r.innerHTML=y),n=f(e),u=w(e,"P",{"data-svelte-h":!0}),C(u)!=="svelte-1nhlbs8"&&(u.innerHTML=B),_=f(e),J=w(e,"P",{"data-svelte-h":!0}),C(J)!=="svelte-vcrp3b"&&(J.textContent=I),ue=f(e),T(E.$$.fragment,e),he=f(e),T(H.$$.fragment,e),fe=f(e),T(k.$$.fragment,e),ye=f(e),T(x.$$.fragment,e),Je=f(e),T(V.$$.fragment,e),ge=f(e),T(A.$$.fragment,e),we=f(e),z=w(e,"P",{"data-svelte-h":!0}),C(z)!=="svelte-fexqjn"&&(z.innerHTML=Fe),Ue=f(e),T(q.$$.fragment,e),Te=f(e),X=w(e,"DIV",{class:!0,"data-svelte-h":!0}),C(X)!=="svelte-1olacag"&&(X.innerHTML=He),be=f(e),T(D.$$.fragment,e),je=f(e),K=w(e,"P",{"data-svelte-h":!0}),C(K)!=="svelte-i3adm8"&&(K.textContent=xe),Ze=f(e),T(P.$$.fragment,e),We=f(e),O=w(e,"P",{"data-svelte-h":!0}),C(O)!=="svelte-1wvykf5"&&(O.innerHTML=Ae),Ce=f(e),T(L.$$.fragment,e),Ge=f(e),T(ee.$$.fragment,e),Ie=f(e),le=w(e,"P",{"data-svelte-h":!0}),C(le)!=="svelte-1fviti6"&&(le.innerHTML=ze),Be=f(e),se=w(e,"P",{"data-svelte-h":!0}),C(se)!=="svelte-1wwp3s2"&&(se.innerHTML=qe),_e=f(e),T(S.$$.fragment,e),$e=f(e),T(te.$$.fragment,e),Re=f(e),ae=w(e,"P",{"data-svelte-h":!0}),C(ae)!=="svelte-tl9wrs"&&(ae.innerHTML=De),ve=f(e),ne=w(e,"P",{"data-svelte-h":!0}),C(ne)!=="svelte-18ngb4o"&&(ne.innerHTML=Ke),Ne=f(e),T(Y.$$.fragment,e),Qe=f(e),T(ie.$$.fragment,e),Ee=f(e),oe=w(e,"P",{"data-svelte-h":!0}),C(oe)!=="svelte-14vivd7"&&(oe.innerHTML=Pe),ke=f(e),pe=w(e,"P",{"data-svelte-h":!0}),C(pe)!=="svelte-1ys188t"&&(pe.innerHTML=Oe),Ve=f(e),T(re.$$.fragment,e),Xe=f(e),F=w(e,"DIV",{class:!0,"data-svelte-h":!0}),C(F)!=="svelte-8kha3o"&&(F.innerHTML=el),Le=f(e),T(ce.$$.fragment,e),Se=f(e),me=w(e,"P",{}),ol(me).forEach(o),this.h()},h(){$(l,"name","hf:doc:metadata"),$(l,"content",El),$(X,"class","flex gap-4"),$(F,"class","flex justify-center")},m(e,c){Ml(document.head,l),p(e,d,c),p(e,t,c),p(e,i,c),b(s,e,c),p(e,a,c),b(M,e,c),p(e,m,c),p(e,r,c),p(e,n,c),p(e,u,c),p(e,_,c),p(e,J,c),p(e,ue,c),b(E,e,c),p(e,he,c),b(H,e,c),p(e,fe,c),b(k,e,c),p(e,ye,c),b(x,e,c),p(e,Je,c),b(V,e,c),p(e,ge,c),b(A,e,c),p(e,we,c),p(e,z,c),p(e,Ue,c),b(q,e,c),p(e,Te,c),p(e,X,c),p(e,be,c),b(D,e,c),p(e,je,c),p(e,K,c),p(e,Ze,c),b(P,e,c),p(e,We,c),p(e,O,c),p(e,Ce,c),b(L,e,c),p(e,Ge,c),b(ee,e,c),p(e,Ie,c),p(e,le,c),p(e,Be,c),p(e,se,c),p(e,_e,c),b(S,e,c),p(e,$e,c),b(te,e,c),p(e,Re,c),p(e,ae,c),p(e,ve,c),p(e,ne,c),p(e,Ne,c),b(Y,e,c),p(e,Qe,c),b(ie,e,c),p(e,Ee,c),p(e,oe,c),p(e,ke,c),p(e,pe,c),p(e,Ve,c),b(re,e,c),p(e,Xe,c),p(e,F,c),p(e,Le,c),b(ce,e,c),p(e,Se,c),p(e,me,c),Ye=!0},p(e,[c]){const ll={};c&2&&(ll.$$scope={dirty:c,ctx:e}),E.$set(ll);const sl={};c&2&&(sl.$$scope={dirty:c,ctx:e}),k.$set(sl);const tl={};c&2&&(tl.$$scope={dirty:c,ctx:e}),V.$set(tl);const al={};c&2&&(al.$$scope={dirty:c,ctx:e}),L.$set(al);const nl={};c&2&&(nl.$$scope={dirty:c,ctx:e}),S.$set(nl);const il={};c&2&&(il.$$scope={dirty:c,ctx:e}),Y.$set(il)},i(e){Ye||(j(s.$$.fragment,e),j(M.$$.fragment,e),j(E.$$.fragment,e),j(H.$$.fragment,e),j(k.$$.fragment,e),j(x.$$.fragment,e),j(V.$$.fragment,e),j(A.$$.fragment,e),j(q.$$.fragment,e),j(D.$$.fragment,e),j(P.$$.fragment,e),j(L.$$.fragment,e),j(ee.$$.fragment,e),j(S.$$.fragment,e),j(te.$$.fragment,e),j(Y.$$.fragment,e),j(ie.$$.fragment,e),j(re.$$.fragment,e),j(ce.$$.fragment,e),Ye=!0)},o(e){Z(s.$$.fragment,e),Z(M.$$.fragment,e),Z(E.$$.fragment,e),Z(H.$$.fragment,e),Z(k.$$.fragment,e),Z(x.$$.fragment,e),Z(V.$$.fragment,e),Z(A.$$.fragment,e),Z(q.$$.fragment,e),Z(D.$$.fragment,e),Z(P.$$.fragment,e),Z(L.$$.fragment,e),Z(ee.$$.fragment,e),Z(S.$$.fragment,e),Z(te.$$.fragment,e),Z(Y.$$.fragment,e),Z(ie.$$.fragment,e),Z(re.$$.fragment,e),Z(ce.$$.fragment,e),Ye=!1},d(e){e&&(o(d),o(t),o(i),o(a),o(m),o(r),o(n),o(u),o(_),o(J),o(ue),o(he),o(fe),o(ye),o(Je),o(ge),o(we),o(z),o(Ue),o(Te),o(X),o(be),o(je),o(K),o(Ze),o(We),o(O),o(Ce),o(Ge),o(Ie),o(le),o(Be),o(se),o(_e),o($e),o(Re),o(ae),o(ve),o(ne),o(Ne),o(Qe),o(Ee),o(oe),o(ke),o(pe),o(Ve),o(Xe),o(F),o(Le),o(Se),o(me)),o(l),W(s,e),W(M,e),W(E,e),W(H,e),W(k,e),W(x,e),W(V,e),W(A,e),W(q,e),W(D,e),W(P,e),W(L,e),W(ee,e),W(S,e),W(te,e),W(Y,e),W(ie,e),W(re,e),W(ce,e)}}}const El='{"title":"Latent Consistency Model","local":"latent-consistency-model","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Adapters","local":"adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"T2I-Adapter","local":"t2i-adapter","sections":[],"depth":3},{"title":"AnimateDiff","local":"animatediff","sections":[],"depth":3}],"depth":2}],"depth":1}';function kl(G){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends cl{constructor(l){super(),ml(this,l,kl,Ql,pl,{})}}export{xl as component};
