import{s as Ul,n as el,o as tl}from"../chunks/scheduler.eb0ed874.js";import{S as Cl,i as sl,g as s,s as t,r as a,A as Tl,h as T,f as U,c as C,j as Ml,u as j,x as J,k as ll,y as Jl,a as e,v as n,d as i,t as y,w as A}from"../chunks/index.b954ae78.js";import{C as SM}from"../chunks/CodeBlock.2e864717.js";import{H as $,E as al}from"../chunks/EditOnGithub.6f0e1a75.js";function jl(fM){let w,D,H,K,r,q,I,BM="This document aims at describing the architecture of Text Generation Inference (TGI), by describing the call flow between the separate components.",MM,o,QM="A high-level architecture diagram can be seen here:",lM,V,vM='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/TGI.png" alt="TGI architecture"/>',UM,N,kM="This diagram shows well there are these separate components:",eM,c,ZM="<li><strong>The router</strong>, also named <code>webserver</code>, that receives the client requests, buffers them, creates some batches, and prepares gRPC calls to a model server.</li> <li><strong>The model server</strong>, responsible of receiving the gRPC requests and to process the inference on the model. If the model is sharded across multiple accelerators (e.g.: multiple GPUs), the model server shards might be synchronized via NCCL or equivalent.</li> <li><strong>The launcher</strong> is a helper thar will be able to launch one or several model servers (if model is sharded), and it launches the router with the compatible arguments.</li>",tM,p,XM="The router and the model server can be two different machines, they do not need to be deployed together.",CM,F,sM,h,WM=`This component is a rust web server binary that accepts HTTP requests using the custom <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">HTTP API</a>, as well as OpenAI’s <a href="https://huggingface.co/docs/text-generation-inference/messages_api" rel="nofollow">Messages API</a>.
The router receives the API calls and handles the “baches” logic (and introduction to batching can be found <a href="https://github.com/huggingface/text-generation-inference/blob/main/router/README.md" rel="nofollow">here</a>).
It uses different strategies to reduce latency between requests and responses, especially oriented to decoding latency. It will use queues, schedulers, and block allocators to achieve that and produce batched requests that it will then be sent to the model server.`,TM,d,JM,m,GM="The router command line will be the way to pass parameters to it (it does not rely on configuration file):",aM,g,jM,u,nM,b,_M=`The model server is a python server, capable of starting a server waiting for gRPC requests, loads a given model, perform sharding to provide <a href="https://huggingface.co/docs/text-generation-inference/conceptual/tensor_parallelism" rel="nofollow">tensor parallelism</a>, and stays alive while waiting for new requests.
The model server supports models instantiated using Pytorch and optimized for inference mainly on CUDA/ROCM.`,iM,E,yM,R,xM="Several variants of the model server exist that are actively supported by Hugging Face:",AM,S,zM='<li>By default, the model server will attempt building <a href="https://huggingface.co/docs/text-generation-inference/installation_nvidia" rel="nofollow">a server optimized for Nvidia GPUs with CUDA</a>. The code for this version is hosted in the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">main TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_amd" rel="nofollow">version optimized for AMD with ROCm</a> is hosted in the main TGI repository. Some model features differ.</li> <li>The <a href="https://huggingface.co/docs/text-generation-inference/installation_gaudi" rel="nofollow">version for Intel Gaudi</a> is maintained on a forked repository, often resynchronized with the main <a href="https://github.com/huggingface/tgi-gaudi" rel="nofollow">TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_inferentia" rel="nofollow">version for Neuron (AWS Inferentia2)</a> is maintained as part of <a href="https://github.com/huggingface/optimum-neuron/tree/main/text-generation-inference" rel="nofollow">Optimum Neuron</a>.</li> <li>A version for Google TPUs is maintained as part of <a href="https://github.com/huggingface/optimum-tpu/tree/main/text-generation-inference" rel="nofollow">Optimum TPU</a>.</li>',wM,f,LM="Not all variants provide the same features, as hardware and middleware capabilities do not provide the same optimizations.",rM,B,IM,Q,YM="The official command line interface (CLI) for the server supports three subcommands, <code>download-weights</code>, <code>quantize</code> and <code>serve</code>:",oM,v,OM="<li><code>download-weights</code> will download weights from the hub and, in some variants it will convert weights to a format that is adapted to the given implementation;</li> <li><code>quantize</code> will allow to quantize a model using the <code>qptq</code> package. This feature is not available nor supported on all variants;</li> <li><code>serve</code> will start the server that load a model (or a model shard), receives gRPC calls from the router, performs an inference and provides a formatted response to the given request.</li>",VM,k,$M="Serve’s command line parameters on the TGI repository are these:",NM,Z,cM,X,HM="Note that some variants might support different parameters, and they could possibly accept more options that can be passed on using environment variables.",pM,W,FM,G,PM='Once both components are initialized, weights downloaded and model server is up and running, router and model server exchange data and info through the gRPC call. There are currently two supported schemas, <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/generate.proto" rel="nofollow">v2</a> and <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/v3/generate.proto" rel="nofollow">v3</a>. These two versions are almost identical, except for:',hM,_,DM="<li>input chunks support, for text and image data,</li> <li>paged attention support</li>",dM,x,KM="Here’s a diagram that displays the exchanges that follow the router and model server startup.",mM,z,gM,L,qM="After these are done, the router is ready to receive generate calls from multiple clients. Here’s an example.",uM,Y,bM,O,EM,P,RM;return r=new $({props:{title:"Text Generation Inference Architecture",local:"text-generation-inference-architecture",headingTag:"h1"}}),F=new $({props:{title:"The Router",local:"the-router",headingTag:"h2"}}),d=new $({props:{title:"Router’s command line",local:"routers-command-line",headingTag:"h3"}}),g=new SM({props:{code:"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",highlighted:`Text Generation Webserver

Usage: text-generation-router <span class="hljs-selector-attr">[OPTIONS]</span>

Options:
      <span class="hljs-attr">--max-concurrent-requests</span> &lt;MAX_CONCURRENT_REQUESTS&gt;
          <span class="hljs-selector-attr">[env: MAX_CONCURRENT_REQUESTS=]</span> <span class="hljs-selector-attr">[default: 128]</span>
      <span class="hljs-attr">--max-best-of</span> &lt;MAX_BEST_OF&gt;
          <span class="hljs-selector-attr">[env: MAX_BEST_OF=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--max-stop-sequences</span> &lt;MAX_STOP_SEQUENCES&gt;
          <span class="hljs-selector-attr">[env: MAX_STOP_SEQUENCES=]</span> <span class="hljs-selector-attr">[default: 4]</span>
      <span class="hljs-attr">--max-top-n-tokens</span> &lt;MAX_TOP_N_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOP_N_TOKENS=]</span> <span class="hljs-selector-attr">[default: 5]</span>
      <span class="hljs-attr">--max-input-tokens</span> &lt;MAX_INPUT_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_INPUT_TOKENS=]</span> <span class="hljs-selector-attr">[default: 1024]</span>
      <span class="hljs-attr">--max-total-tokens</span> &lt;MAX_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOTAL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 2048]</span>
      <span class="hljs-attr">--waiting-served-ratio</span> &lt;WAITING_SERVED_RATIO&gt;
          <span class="hljs-selector-attr">[env: WAITING_SERVED_RATIO=]</span> <span class="hljs-selector-attr">[default: 1.2]</span>
      <span class="hljs-attr">--max-batch-prefill-tokens</span> &lt;MAX_BATCH_PREFILL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_PREFILL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 4096]</span>
      <span class="hljs-attr">--max-batch-total-tokens</span> &lt;MAX_BATCH_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_TOTAL_TOKENS=]</span>
      <span class="hljs-attr">--max-waiting-tokens</span> &lt;MAX_WAITING_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_WAITING_TOKENS=]</span> <span class="hljs-selector-attr">[default: 20]</span>
      <span class="hljs-attr">--max-batch-size</span> &lt;MAX_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_SIZE=]</span>
      <span class="hljs-attr">--hostname</span> &lt;HOSTNAME&gt;
          <span class="hljs-selector-attr">[env: HOSTNAME=]</span> <span class="hljs-selector-attr">[default: 0.0.0.0]</span>
  -<span class="hljs-selector-tag">p</span>, <span class="hljs-attr">--port</span> &lt;PORT&gt;
          <span class="hljs-selector-attr">[env: PORT=]</span> <span class="hljs-selector-attr">[default: 3000]</span>
      <span class="hljs-attr">--master-shard-uds-path</span> &lt;MASTER_SHARD_UDS_PATH&gt;
          <span class="hljs-selector-attr">[env: MASTER_SHARD_UDS_PATH=]</span> <span class="hljs-selector-attr">[default: /tmp/text-generation-server-0]</span>
      <span class="hljs-attr">--tokenizer-name</span> &lt;TOKENIZER_NAME&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_NAME=]</span> <span class="hljs-selector-attr">[default: bigscience/bloom]</span>
      <span class="hljs-attr">--tokenizer-config-path</span> &lt;TOKENIZER_CONFIG_PATH&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_CONFIG_PATH=]</span>
      <span class="hljs-attr">--revision</span> &lt;REVISION&gt;
          <span class="hljs-selector-attr">[env: REVISION=]</span>
      <span class="hljs-attr">--validation-workers</span> &lt;VALIDATION_WORKERS&gt;
          <span class="hljs-selector-attr">[env: VALIDATION_WORKERS=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--json-output</span>
          <span class="hljs-selector-attr">[env: JSON_OUTPUT=]</span>
      <span class="hljs-attr">--otlp-endpoint</span> &lt;OTLP_ENDPOINT&gt;
          <span class="hljs-selector-attr">[env: OTLP_ENDPOINT=]</span>
      <span class="hljs-attr">--cors-allow-origin</span> &lt;CORS_ALLOW_ORIGIN&gt;
          <span class="hljs-selector-attr">[env: CORS_ALLOW_ORIGIN=]</span>
      <span class="hljs-attr">--ngrok</span>
          <span class="hljs-selector-attr">[env: NGROK=]</span>
      <span class="hljs-attr">--ngrok-authtoken</span> &lt;NGROK_AUTHTOKEN&gt;
          <span class="hljs-selector-attr">[env: NGROK_AUTHTOKEN=]</span>
      <span class="hljs-attr">--ngrok-edge</span> &lt;NGROK_EDGE&gt;
          <span class="hljs-selector-attr">[env: NGROK_EDGE=]</span>
      <span class="hljs-attr">--messages-api-enabled</span>
          <span class="hljs-selector-attr">[env: MESSAGES_API_ENABLED=]</span>
      <span class="hljs-attr">--disable-grammar-support</span>
          <span class="hljs-selector-attr">[env: DISABLE_GRAMMAR_SUPPORT=]</span>
      <span class="hljs-attr">--max-client-batch-size</span> &lt;MAX_CLIENT_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_CLIENT_BATCH_SIZE=]</span> <span class="hljs-selector-attr">[default: 4]</span>
  -h, <span class="hljs-attr">--help</span>
          Print help
  -V, <span class="hljs-attr">--version</span>
          Print version`,wrap:!1}}),u=new $({props:{title:"The Model Server",local:"the-model-server",headingTag:"h2"}}),E=new $({props:{title:"Model Server Variants",local:"model-server-variants",headingTag:"h3"}}),B=new $({props:{title:"Command Line Interface",local:"command-line-interface",headingTag:"h3"}}),Z=new SM({props:{code:"JTIwVXNhZ2UlM0ElMjBjbGkucHklMjBzZXJ2ZSUyMCU1Qk9QVElPTlMlNUQlMjBNT0RFTF9JRCUwQSUwQSVFMiU5NSVBRCVFMiU5NCU4MCUyMEFyZ3VtZW50cyUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NSVBRSUwQSVFMiU5NCU4MiUyMColMjAlMjAlMjAlMjBtb2RlbF9pZCUyMCUyMCUyMCUyMCUyMCUyMFRFWFQlMjAlMjAlNUJkZWZhdWx0JTNBJTIwTm9uZSU1RCUyMCU1QnJlcXVpcmVkJTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk1JUIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk1JUFGJTBBJUUyJTk1JUFEJUUyJTk0JTgwJTIwT3B0aW9ucyUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NSVBRSUwQSVFMiU5NCU4MiUyMC0tcmV2aXNpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBURVhUJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZGVmYXVsdCUzQSUyME5vbmUlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAtLXNoYXJkZWQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtLW5vLXNoYXJkZWQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJkZWZhdWx0JTNBJTIwbm8tc2hhcmRlZCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMC0tcXVhbnRpemUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJiaXRzYW5kYnl0ZXMlN0NiaXRzYW5kYnl0ZXMlMjAlMjAlNUJkZWZhdWx0JTNBJTIwTm9uZSU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1uZjQlN0NiaXRzYW5kYnl0ZXMtZnA0JTdDZ3B0cSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Q2F3cSU3Q2VldHElN0NleGwyJTdDZnA4JTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwLS1zcGVjdWxhdGUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJTlRFR0VSJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZGVmYXVsdCUzQSUyME5vbmUlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAtLWR0eXBlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZmxvYXQxNiU3Q2JmbG9hdDE2JTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZGVmYXVsdCUzQSUyME5vbmUlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAtLXRydXN0LXJlbW90ZS1jb2RlJTIwJTIwJTIwJTIwLS1uby10cnVzdC1yZW1vdGUtY29kZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmRlZmF1bHQlM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuby10cnVzdC1yZW1vdGUtY29kZSU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMC0tdWRzLXBhdGglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQQVRIJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZGVmYXVsdCUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRnRtcCUyRnRleHQtZ2VuZXJhdGlvbi1zZXJ2ZSVFMiU4MCVBNiUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMC0tbG9nZ2VyLWxldmVsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVEVYVCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmRlZmF1bHQlM0ElMjBJTkZPJTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwLS1qc29uLW91dHB1dCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0tbm8tanNvbi1vdXRwdXQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJkZWZhdWx0JTNBJTIwbm8tanNvbi1vdXRwdXQlNUQlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAtLW90bHAtZW5kcG9pbnQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBURVhUJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZGVmYXVsdCUzQSUyME5vbmUlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjAtLWhlbHAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTaG93JTIwdGhpcyUyMG1lc3NhZ2UlMjBhbmQlMjBleGl0LiUyMCVFMiU5NCU4MiUwQSVFMiU5NSVCMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NSVBRg==",highlighted:` <span class="hljs-keyword">Usage</span>: cli.py serve [<span class="hljs-keyword">OPTIONS</span>] MODEL_ID

╭─ Arguments ──────────────────────────────────────────────────────────────────────────────────────────────╮
│ *    model_id      <span class="hljs-type">TEXT</span>  [<span class="hljs-keyword">default</span>: <span class="hljs-keyword">None</span>] [required]                                                      │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭─ <span class="hljs-keyword">Options</span> ────────────────────────────────────────────────────────────────────────────────────────────────╮
│ <span class="hljs-comment">--revision                                       TEXT                        [default: None]             │</span>
│ <span class="hljs-comment">--sharded              --no-sharded                                          [default: no-sharded]       │</span>
│ <span class="hljs-comment">--quantize                                       [bitsandbytes|bitsandbytes  [default: None]             │</span>
│                                                  -nf4|bitsandbytes-fp4|gptq                              │
│                                                  |awq|eetq|exl2|fp8]                                     │
│ <span class="hljs-comment">--speculate                                      INTEGER                     [default: None]             │</span>
│ <span class="hljs-comment">--dtype                                          [float16|bfloat16]          [default: None]             │</span>
│ <span class="hljs-comment">--trust-remote-code    --no-trust-remote-code                                [default:                   │</span>
│                                                                              <span class="hljs-keyword">no</span>-trust-remote-code]       │
│ <span class="hljs-comment">--uds-path                                       PATH                        [default:                   │</span>
│                                                                              /tmp/<span class="hljs-type">text</span>-generation-serve… │
│ <span class="hljs-comment">--logger-level                                   TEXT                        [default: INFO]             │</span>
│ <span class="hljs-comment">--json-output          --no-json-output                                      [default: no-json-output]   │</span>
│ <span class="hljs-comment">--otlp-endpoint                                  TEXT                        [default: None]             │</span>
│ <span class="hljs-comment">--help                                                                       Show this message and exit. │</span>
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯`,wrap:!1}}),W=new $({props:{title:"Call Flow",local:"call-flow",headingTag:"h2"}}),z=new SM({props:{code:"c2VxdWVuY2VEaWFncmFtJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwc2VydmljZSUyMGRpc2NvdmVyeSUwQSUyMCUyMCUyMCUyME1vZGVsJTIwU2VydmVyLS0lM0UlM0VSb3V0ZXIlM0ElMjB1cmxzJTIwZm9yJTIwb3RoZXIlMjBzaGFyZHMlMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjBnZXQlMjBtb2RlbCUyMGluZm8lMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwc2hhcmQlMjBpbmZvJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwaGVhbHRoJTIwY2hlY2slMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwaGVhbHRoJTIwT0slMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjB3YXJtdXAobWF4X2lucHV0X3Rva2VucyUyQyUyMG1heF9iYXRjaF9wcmVmaWxsX3Rva2VucyUyQyUyMG1heF90b3RhbF90b2tlbnMlMkMlMjBtYXhfYmF0Y2hfc2l6ZSklMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwd2FybXVwJTIwcmVzdWx0",highlighted:`sequenceDiagram

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: service discovery
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: urls <span class="hljs-keyword">for</span> other shards

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: get model info
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: shard info

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: health check
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: health OK

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: warmup(max_input_tokens, max_batch_prefill_tokens, max_total_tokens, max_batch_size)
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: warmup result`,wrap:!1}}),Y=new SM({props:{code:"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",highlighted:`sequenceDiagram
    participant Client <span class="hljs-number">1</span>
    participant Client <span class="hljs-number">2</span>
    participant Client <span class="hljs-number">3</span>
    participant Router
    participant Model Server

    Client <span class="hljs-number">1</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">1</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">2</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">3</span>

    Client <span class="hljs-number">2</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch2)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">1</span>&#x27;

    Router-&gt;&gt;Model Server: decode(cached_batch1, cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">4</span>
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">2</span>&#x27;

    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">1</span> leaves
    Router-&gt;&gt;Model Server: filter_batch(cached_batch1, request_ids_to_keep=batch2)
    Model Server--&gt;&gt;Router: filtered batch

    Router-&gt;&gt;Model Server: decode(cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">3</span>&#x27;

    Client <span class="hljs-number">3</span>-&gt;&gt;Router: generate_stream
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Router-&gt;&gt;Model Server: prefill(batch3)
    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">3</span> leaves without receiving any batch
    Router-&gt;&gt;Model Server: clear_cache(batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted

    Router-&gt;&gt;Model Server: decode(cached_batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: Last token (stopping criteria)
    Model Server--&gt;&gt;Router: generations, cached_batch3, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">4</span>&#x27;

`,wrap:!1}}),O=new al({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/architecture.md"}}),{c(){w=s("meta"),D=t(),H=s("p"),K=t(),a(r.$$.fragment),q=t(),I=s("p"),I.textContent=BM,MM=t(),o=s("p"),o.textContent=QM,lM=t(),V=s("p"),V.innerHTML=vM,UM=t(),N=s("p"),N.textContent=kM,eM=t(),c=s("ul"),c.innerHTML=ZM,tM=t(),p=s("p"),p.textContent=XM,CM=t(),a(F.$$.fragment),sM=t(),h=s("p"),h.innerHTML=WM,TM=t(),a(d.$$.fragment),JM=t(),m=s("p"),m.textContent=GM,aM=t(),a(g.$$.fragment),jM=t(),a(u.$$.fragment),nM=t(),b=s("p"),b.innerHTML=_M,iM=t(),a(E.$$.fragment),yM=t(),R=s("p"),R.textContent=xM,AM=t(),S=s("ul"),S.innerHTML=zM,wM=t(),f=s("p"),f.textContent=LM,rM=t(),a(B.$$.fragment),IM=t(),Q=s("p"),Q.innerHTML=YM,oM=t(),v=s("ul"),v.innerHTML=OM,VM=t(),k=s("p"),k.textContent=$M,NM=t(),a(Z.$$.fragment),cM=t(),X=s("p"),X.textContent=HM,pM=t(),a(W.$$.fragment),FM=t(),G=s("p"),G.innerHTML=PM,hM=t(),_=s("ul"),_.innerHTML=DM,dM=t(),x=s("p"),x.textContent=KM,mM=t(),a(z.$$.fragment),gM=t(),L=s("p"),L.textContent=qM,uM=t(),a(Y.$$.fragment),bM=t(),a(O.$$.fragment),EM=t(),P=s("p"),this.h()},l(M){const l=Tl("svelte-u9bgzb",document.head);w=T(l,"META",{name:!0,content:!0}),l.forEach(U),D=C(M),H=T(M,"P",{}),Ml(H).forEach(U),K=C(M),j(r.$$.fragment,M),q=C(M),I=T(M,"P",{"data-svelte-h":!0}),J(I)!=="svelte-vphelk"&&(I.textContent=BM),MM=C(M),o=T(M,"P",{"data-svelte-h":!0}),J(o)!=="svelte-772u2a"&&(o.textContent=QM),lM=C(M),V=T(M,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1l2f8t4"&&(V.innerHTML=vM),UM=C(M),N=T(M,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1lzr5l3"&&(N.textContent=kM),eM=C(M),c=T(M,"UL",{"data-svelte-h":!0}),J(c)!=="svelte-lfhn4u"&&(c.innerHTML=ZM),tM=C(M),p=T(M,"P",{"data-svelte-h":!0}),J(p)!=="svelte-9in8o2"&&(p.textContent=XM),CM=C(M),j(F.$$.fragment,M),sM=C(M),h=T(M,"P",{"data-svelte-h":!0}),J(h)!=="svelte-12wcxfx"&&(h.innerHTML=WM),TM=C(M),j(d.$$.fragment,M),JM=C(M),m=T(M,"P",{"data-svelte-h":!0}),J(m)!=="svelte-vrz9ad"&&(m.textContent=GM),aM=C(M),j(g.$$.fragment,M),jM=C(M),j(u.$$.fragment,M),nM=C(M),b=T(M,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1fiirti"&&(b.innerHTML=_M),iM=C(M),j(E.$$.fragment,M),yM=C(M),R=T(M,"P",{"data-svelte-h":!0}),J(R)!=="svelte-hdemao"&&(R.textContent=xM),AM=C(M),S=T(M,"UL",{"data-svelte-h":!0}),J(S)!=="svelte-y4ukjf"&&(S.innerHTML=zM),wM=C(M),f=T(M,"P",{"data-svelte-h":!0}),J(f)!=="svelte-12gjbvy"&&(f.textContent=LM),rM=C(M),j(B.$$.fragment,M),IM=C(M),Q=T(M,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-8olu0s"&&(Q.innerHTML=YM),oM=C(M),v=T(M,"UL",{"data-svelte-h":!0}),J(v)!=="svelte-1gvj873"&&(v.innerHTML=OM),VM=C(M),k=T(M,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1v1wq4t"&&(k.textContent=$M),NM=C(M),j(Z.$$.fragment,M),cM=C(M),X=T(M,"P",{"data-svelte-h":!0}),J(X)!=="svelte-182mwi5"&&(X.textContent=HM),pM=C(M),j(W.$$.fragment,M),FM=C(M),G=T(M,"P",{"data-svelte-h":!0}),J(G)!=="svelte-10nkdn7"&&(G.innerHTML=PM),hM=C(M),_=T(M,"UL",{"data-svelte-h":!0}),J(_)!=="svelte-1e4xpg3"&&(_.innerHTML=DM),dM=C(M),x=T(M,"P",{"data-svelte-h":!0}),J(x)!=="svelte-16m2ryh"&&(x.textContent=KM),mM=C(M),j(z.$$.fragment,M),gM=C(M),L=T(M,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1qai9e7"&&(L.textContent=qM),uM=C(M),j(Y.$$.fragment,M),bM=C(M),j(O.$$.fragment,M),EM=C(M),P=T(M,"P",{}),Ml(P).forEach(U),this.h()},h(){ll(w,"name","hf:doc:metadata"),ll(w,"content",nl)},m(M,l){Jl(document.head,w),e(M,D,l),e(M,H,l),e(M,K,l),n(r,M,l),e(M,q,l),e(M,I,l),e(M,MM,l),e(M,o,l),e(M,lM,l),e(M,V,l),e(M,UM,l),e(M,N,l),e(M,eM,l),e(M,c,l),e(M,tM,l),e(M,p,l),e(M,CM,l),n(F,M,l),e(M,sM,l),e(M,h,l),e(M,TM,l),n(d,M,l),e(M,JM,l),e(M,m,l),e(M,aM,l),n(g,M,l),e(M,jM,l),n(u,M,l),e(M,nM,l),e(M,b,l),e(M,iM,l),n(E,M,l),e(M,yM,l),e(M,R,l),e(M,AM,l),e(M,S,l),e(M,wM,l),e(M,f,l),e(M,rM,l),n(B,M,l),e(M,IM,l),e(M,Q,l),e(M,oM,l),e(M,v,l),e(M,VM,l),e(M,k,l),e(M,NM,l),n(Z,M,l),e(M,cM,l),e(M,X,l),e(M,pM,l),n(W,M,l),e(M,FM,l),e(M,G,l),e(M,hM,l),e(M,_,l),e(M,dM,l),e(M,x,l),e(M,mM,l),n(z,M,l),e(M,gM,l),e(M,L,l),e(M,uM,l),n(Y,M,l),e(M,bM,l),n(O,M,l),e(M,EM,l),e(M,P,l),RM=!0},p:el,i(M){RM||(i(r.$$.fragment,M),i(F.$$.fragment,M),i(d.$$.fragment,M),i(g.$$.fragment,M),i(u.$$.fragment,M),i(E.$$.fragment,M),i(B.$$.fragment,M),i(Z.$$.fragment,M),i(W.$$.fragment,M),i(z.$$.fragment,M),i(Y.$$.fragment,M),i(O.$$.fragment,M),RM=!0)},o(M){y(r.$$.fragment,M),y(F.$$.fragment,M),y(d.$$.fragment,M),y(g.$$.fragment,M),y(u.$$.fragment,M),y(E.$$.fragment,M),y(B.$$.fragment,M),y(Z.$$.fragment,M),y(W.$$.fragment,M),y(z.$$.fragment,M),y(Y.$$.fragment,M),y(O.$$.fragment,M),RM=!1},d(M){M&&(U(D),U(H),U(K),U(q),U(I),U(MM),U(o),U(lM),U(V),U(UM),U(N),U(eM),U(c),U(tM),U(p),U(CM),U(sM),U(h),U(TM),U(JM),U(m),U(aM),U(jM),U(nM),U(b),U(iM),U(yM),U(R),U(AM),U(S),U(wM),U(f),U(rM),U(IM),U(Q),U(oM),U(v),U(VM),U(k),U(NM),U(cM),U(X),U(pM),U(FM),U(G),U(hM),U(_),U(dM),U(x),U(mM),U(gM),U(L),U(uM),U(bM),U(EM),U(P)),U(w),A(r,M),A(F,M),A(d,M),A(g,M),A(u,M),A(E,M),A(B,M),A(Z,M),A(W,M),A(z,M),A(Y,M),A(O,M)}}}const nl='{"title":"Text Generation Inference Architecture","local":"text-generation-inference-architecture","sections":[{"title":"The Router","local":"the-router","sections":[{"title":"Router’s command line","local":"routers-command-line","sections":[],"depth":3}],"depth":2},{"title":"The Model Server","local":"the-model-server","sections":[{"title":"Model Server Variants","local":"model-server-variants","sections":[],"depth":3},{"title":"Command Line Interface","local":"command-line-interface","sections":[],"depth":3}],"depth":2},{"title":"Call Flow","local":"call-flow","sections":[],"depth":2}],"depth":1}';function il(fM){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends Cl{constructor(w){super(),sl(this,w,il,jl,Ul,{})}}export{Il as component};
