import{s as Dt,o as Ft,n as $}from"../chunks/scheduler.8c3d61f6.js";import{S as Ht,i as Et,g as r,s as a,r as y,A as At,h as f,f as l,c as p,j as zt,u as h,x as u,k as as,y as Lt,a as t,v as U,d as J,t as T,w as b}from"../chunks/index.da70eac4.js";import{T as Sl}from"../chunks/Tip.1d9b8c37.js";import{C as Z}from"../chunks/CodeBlock.00a903b3.js";import{D as Pt}from"../chunks/DocNotebookDropdown.02900f6b.js";import{H as C,E as Ot}from"../chunks/EditOnGithub.1e64e623.js";import{H as Yl,a as ps}from"../chunks/HfOption.c1483eb1.js";function Kt(w){let i,c='Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you’re interested in an explanation about how the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){i=r("p"),i.innerHTML=c},l(n){i=f(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-173qjuf"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:$,d(n){n&&l(i)}}}function ei(w){let i,c='The <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is a simple and generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. It uses the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method to automatically detect the correct pipeline class for a task from the checkpoint, downloads and caches all the required configuration and weight files, and returns a pipeline ready for inference.',n,d,o,m,j='This same checkpoint can also be used for an image-to-image task. The <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class can handle any task as long as you provide the appropriate inputs. For example, for an image-to-image task, you need to pass an initial image to the pipeline.',g,_,I;return d=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=c,n=a(),y(d.$$.fragment),o=a(),m=r("p"),m.innerHTML=j,g=a(),y(_.$$.fragment)},l(M){i=f(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1eih7q9"&&(i.innerHTML=c),n=p(M),h(d.$$.fragment,M),o=p(M),m=f(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-1gzwx7k"&&(m.innerHTML=j),g=p(M),h(_.$$.fragment,M)},m(M,v){t(M,i,v),t(M,n,v),U(d,M,v),t(M,o,v),t(M,m,v),t(M,g,v),U(_,M,v),I=!0},p:$,i(M){I||(J(d.$$.fragment,M),J(_.$$.fragment,M),I=!0)},o(M){T(d.$$.fragment,M),T(_.$$.fragment,M),I=!1},d(M){M&&(l(i),l(n),l(o),l(m),l(g)),b(d,M),b(_,M)}}}function si(w){let i,c='Checkpoints can be loaded by their specific pipeline class if you already know it. For example, to load a Stable Diffusion model, use the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class.',n,d,o,m,j='This same checkpoint may also be used for another task like image-to-image. To differentiate what task you want to use the checkpoint for, you have to use the corresponding task-specific pipeline class. For example, to use the same checkpoint for image-to-image, use the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> class.',g,_,I;return d=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

pipeline = StableDiffusionImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=c,n=a(),y(d.$$.fragment),o=a(),m=r("p"),m.innerHTML=j,g=a(),y(_.$$.fragment)},l(M){i=f(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-qdj32f"&&(i.innerHTML=c),n=p(M),h(d.$$.fragment,M),o=p(M),m=f(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-1uaa2og"&&(m.innerHTML=j),g=p(M),h(_.$$.fragment,M)},m(M,v){t(M,i,v),t(M,n,v),U(d,M,v),t(M,o,v),t(M,m,v),t(M,g,v),U(_,M,v),I=!0},p:$,i(M){I||(J(d.$$.fragment,M),J(_.$$.fragment,M),I=!0)},o(M){T(d.$$.fragment,M),T(_.$$.fragment,M),I=!1},d(M){M&&(l(i),l(n),l(o),l(m),l(g)),b(d,M),b(_,M)}}}function li(w){let i,c,n,d;return i=new ps({props:{id:"pipelines",option:"generic pipeline",$$slots:{default:[ei]},$$scope:{ctx:w}}}),n=new ps({props:{id:"pipelines",option:"specific pipeline",$$slots:{default:[si]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const j={};m&2&&(j.$$scope={dirty:m,ctx:o}),i.$set(j);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function ti(w){let i,c='To switch between tasks (rather than features), use the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method with the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> class, which automatically identifies the pipeline class based on the task (learn more in the <a href="../tutorials/autopipeline">AutoPipeline</a> tutorial).';return{c(){i=r("p"),i.innerHTML=c},l(n){i=f(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1w2ultx"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:$,d(n){n&&l(i)}}}function ii(w){let i,c='Some pipeline methods may not function properly on new pipelines created with <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For instance, the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method installs hooks on the model components based on a unique offloading sequence for each pipeline. If the models are executed in a different order in the new pipeline, the CPU offloading may not work correctly.',n,d,o='To ensure everything works as expected, we recommend re-applying a pipeline method on a new pipeline created with <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>.';return{c(){i=r("p"),i.innerHTML=c,n=a(),d=r("p"),d.innerHTML=o},l(m){i=f(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1xp7go6"&&(i.innerHTML=c),n=p(m),d=f(m,"P",{"data-svelte-h":!0}),u(d)!=="svelte-1h7yzwm"&&(d.innerHTML=o)},m(m,j){t(m,i,j),t(m,n,j),t(m,d,j)},p:$,d(m){m&&(l(i),l(n),l(d))}}}function ni(w){let i,c='When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories. For example, <a href="https://hf.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a> and <a href="https://hf.co/stabilityai/stable-diffusion-2-1" rel="nofollow">stabilityai/stable-diffusion-2-1</a> are stored in separate repositories.';return{c(){i=r("p"),i.innerHTML=c},l(n){i=f(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11b88rc"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:$,d(n){n&&l(i)}}}function ai(w){let i,c;return i=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:$,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function pi(w){let i,c;return i=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:$,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function oi(w){let i,c,n,d;return i=new ps({props:{id:"variants",option:"fp16",$$slots:{default:[ai]},$$scope:{ctx:w}}}),n=new ps({props:{id:"variants",option:"non-EMA",$$slots:{default:[pi]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const j={};m&2&&(j.$$scope={dirty:m,ctx:o}),i.$set(j);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function ri(w){let i,c;return i=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:$,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function fi(w){let i,c;return i=new Z({props:{code:"cGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:'pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)',wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:$,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function ui(w){let i,c,n,d;return i=new ps({props:{id:"save",option:"fp16",$$slots:{default:[ri]},$$scope:{ctx:w}}}),n=new ps({props:{id:"save",option:"non_ema",$$slots:{default:[fi]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const j={};m&2&&(j.$$scope={dirty:m,ctx:o}),i.$set(j);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function ci(w){let i,c,n,d,o,m,j,g,_,I='Diffusion systems consist of multiple components like parameterized models and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API. At the same time, the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is entirely customizable so you can modify each component to build a diffusion system for your use case.',M,v,xl="This guide will show you how to load:",rs,q,ql="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>multiple pipelines without increasing memory usage</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li>",fs,z,us,G,cs,D,zl="There are two ways to load a pipeline for a task:",ds,F,Dl='<li>Load the generic <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class and allow it to automatically detect the correct pipeline class from the checkpoint.</li> <li>Load a specific pipeline class for a specific task.</li>',ms,V,Ms,H,Fl="Use the Space below to gauge a pipeline’s memory requirements before you download and load it to see if it runs on your hardware.",ys,k,Hl='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',hs,W,El='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',Us,E,Js,A,Al='To load a pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow">git-lfs</a> to manually download a checkpoint to your local disk.',Ts,L,bs,P,Ll='This creates a local folder, ./stable-diffusion-v1-5, on your disk and you should pass its path to <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',ws,O,js,K,Pl='The <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',Zs,ee,gs,se,Ol="You can customize a pipeline by loading different components into it. This is important because you can:",_s,le,Kl="<li>change to a scheduler with faster generation speed or higher generation quality depending on your needs (call the <code>scheduler.compatibles</code> method on your pipeline to see compatible schedulers)</li> <li>change a default pipeline component to a newer and better performing one</li>",vs,te,et='For example, let’s customize the default <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> checkpoint with:',Is,ie,st='<li>The <a href="/docs/diffusers/pr_10001/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a> to generate higher quality images at the expense of slower generation speed. You must pass the <code>subfolder=&quot;scheduler&quot;</code> parameter in <a href="/docs/diffusers/pr_10001/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> to load the scheduler configuration into the correct <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.</li> <li>A more stable VAE that runs in fp16.</li>',Cs,ne,$s,ae,lt='Now pass the new scheduler and VAE to the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Gs,pe,Vs,oe,ks,re,tt="When you load multiple pipelines that share the same model components, it makes sense to reuse the shared components instead of reloading everything into memory again, especially if your hardware is memory-constrained. For example:",Ws,fe,it='<li>You generated an image with the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> but you want to improve its quality with the <a href="/docs/diffusers/pr_10001/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>. Both of these pipelines share the same pretrained model, so it’d be a waste of memory to load the same model twice.</li> <li>You want to add a model component, like a <a href="../api/pipelines/animatediff#animatediffpipeline"><code>MotionAdapter</code></a>, to <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> which was instantiated from an existing <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Again, both pipelines share the same pretrained model, so it’d be a waste of memory to load an entirely new pipeline again.</li>',Rs,ue,nt='With the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a> API, you can switch between multiple pipelines to take advantage of their different features without increasing memory-usage. It is similar to turning on and off a feature in your pipeline.',Bs,R,Ns,ce,at='Let’s start with a <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and then reuse the loaded model components to create a <a href="/docs/diffusers/pr_10001/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> to increase generation quality. You’ll use the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with an <a href="./ip_adapter">IP-Adapter</a> to generate a bear eating pizza.',Xs,de,Qs,B,pt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_0.png"/>',Ss,me,ot="For reference, you can check how much memory this process consumed.",Ys,Me,xs,ye,rt='Now, reuse the same pipeline components from <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> in <a href="/docs/diffusers/pr_10001/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> with the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method.',qs,N,zs,he,Ds,X,ft='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sag_1.png"/>',Fs,Ue,ut='If you check the memory usage, you’ll see it remains the same as before because <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and <a href="/docs/diffusers/pr_10001/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> are sharing the same pipeline components. This allows you to use them interchangeably without any additional memory overhead.',Hs,Je,Es,Te,ct='Let’s animate the image with the <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and also add a <code>MotionAdapter</code> module to the pipeline. For the <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>, you need to unload the IP-Adapter first and reload it <em>after</em> you’ve created your new pipeline (this only applies to the <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>).',As,be,Ls,Q,dt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_animate_3.gif"/>',Ps,we,mt='The <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> is more memory-intensive and consumes 15GB of memory (see the <a href="#memory-usage-of-from_pipe">Memory-usage of from_pipe</a> section to learn what this means for your memory-usage).',Os,je,Ks,Ze,el,ge,Mt='Pipelines loaded with <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> can be customized with different model components or methods. However, whenever you modify the <em>state</em> of the model components, it affects all the other pipelines that share the same components. For example, if you call <a href="/docs/diffusers/pr_10001/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.unload_ip_adapter">unload_ip_adapter()</a> on the <a href="/docs/diffusers/pr_10001/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>, you won’t be able to use IP-Adapter with the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> because it’s been removed from their shared components.',sl,_e,ll,ve,tl,Ie,yt='The memory requirement of loading multiple pipelines with <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> is determined by the pipeline with the highest memory-usage regardless of the number of pipelines you create.',il,Ce,ht="<thead><tr><th>Pipeline</th> <th>Memory usage (GB)</th></tr></thead> <tbody><tr><td>StableDiffusionPipeline</td> <td>4.400</td></tr> <tr><td>StableDiffusionSAGPipeline</td> <td>4.400</td></tr> <tr><td>AnimateDiffPipeline</td> <td>15.178</td></tr></tbody>",nl,$e,Ut='The <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> has the highest memory requirement, so the <em>total memory-usage</em> is based only on the <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Your memory-usage will not increase if you create additional pipelines as long as their memory requirements doesn’t exceed that of the <a href="/docs/diffusers/pr_10001/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Each pipeline can be used interchangeably without any additional memory overhead.',al,Ge,pl,Ve,Jt='Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for Stable Diffusion models which can generate harmful content. The safety checker screens the generated output against known hardcoded not-safe-for-work (NSFW) content. If for whatever reason you’d like to disable the safety checker, pass <code>safety_checker=None</code> to the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',ol,ke,rl,We,fl,Re,Tt="A checkpoint variant is usually a checkpoint whose weights are:",ul,Be,bt='<li>Stored in a different floating point type, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow">torch.float16</a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights which shouldn’t be used for inference. You should use this variant to continue finetuning a model.</li>',cl,S,dl,Ne,wt='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">safetensors</a>), model structure, and their weights have identical tensor shapes.',ml,Xe,jt="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.safetensors</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.safetensors</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.safetensors</td> <td><code>variant</code></td></tr></tbody>",Ml,Qe,Zt="There are two important arguments for loading variants:",yl,Se,gt='<li><p><code>torch_dtype</code> specifies the floating point precision of the loaded checkpoint. For example, if you want to save bandwidth by loading a fp16 variant, you should set <code>variant=&quot;fp16&quot;</code> and <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to fp16. Otherwise, the fp16 weights are converted to the default fp32 precision.</p> <p>If you only set <code>torch_dtype=torch.float16</code>, the default fp32 weights are downloaded first and then converted to fp16.</p></li> <li><p><code>variant</code> specifies which files should be loaded from the repository. For example, if you want to load a non-EMA variant of a UNet from <a href="https://hf.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main/unet" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a>, set <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> file.</p></li>',hl,Y,Ul,Ye,_t='Use the <code>variant</code> parameter in the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method to save a checkpoint as a different floating point type or as a non-EMA variant. You should try save a variant to the same folder as the original checkpoint, so you have the option of loading both from the same folder.',Jl,x,Tl,xe,vt="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint.",bl,qe,wl,ze,jl,De,It='As a class method, <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',Zl,Fe,Ct='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',gl,He,$t='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>.',_l,Ee,vl,Ae,Gt='You’ll see pipeline is an instance of <a href="/docs/diffusers/pr_10001/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',Il,Le,Vt='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/pr_10001/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/pr_10001/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/pr_10001/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Cl,Pe,$l,Oe,kt='Compare the components of the pipeline instance to the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',Gl,Ke,Vl,es,Wt="You can access each of the components of the pipeline as an attribute to view its configuration:",kl,ss,Wl,ls,Rt='Every pipeline expects a <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/pr_10001/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Rl,ts,Bt="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",Bl,is,Nl,ns,Xl,os,Ql;return o=new C({props:{title:"Load pipelines",local:"load-pipelines",headingTag:"h1"}}),j=new Pt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),z=new C({props:{title:"Load a pipeline",local:"load-a-pipeline",headingTag:"h2"}}),G=new Sl({props:{warning:!1,$$slots:{default:[Kt]},$$scope:{ctx:w}}}),V=new Yl({props:{id:"pipelines",options:["generic pipeline","specific pipeline"],$$slots:{default:[li]},$$scope:{ctx:w}}}),E=new C({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),L=new Z({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),O=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ee=new C({props:{title:"Customize a pipeline",local:"customize-a-pipeline",headingTag:"h2"}}),ne=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBBdXRvZW5jb2RlcktMJTBBaW1wb3J0JTIwdG9yY2glMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, HeunDiscreteScheduler, AutoencoderKL
<span class="hljs-keyword">import</span> torch

scheduler = HeunDiscreteScheduler.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjB2YWUlM0R2YWUlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  scheduler=scheduler,
  vae=vae,
  torch_dtype=torch.float16,
  variant=<span class="hljs-string">&quot;fp16&quot;</span>,
  use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),oe=new C({props:{title:"Reuse a pipeline",local:"reuse-a-pipeline",headingTag:"h2"}}),R=new Sl({props:{warning:!1,$$slots:{default:[ti]},$$scope:{ctx:w}}}),de=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMGdjJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXB1dGVfbW9kdWxlX3NpemVzJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmxvYWRfbmVnX2VtYmVkLnBuZyUyMiklMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2QxNS5iaW4lMjIpJTBBcGlwZV9zZC5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBcGlwZV9zZC50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zZA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, StableDiffusionSAGPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compute_module_sizes

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/load_neg_embed.png&quot;</span>)

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, torch_dtype=torch.float16)
pipe_sd.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_sd.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
out_sd`,wrap:!1}}),Me=new Z({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjAlN0JieXRlc190b19naWdhX2J5dGVzKHRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSklN0QlMjBHQiUyMiklMEElMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjA0LjQwNjIxMzI4MzUzODgxOCUyMEdCJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),N=new Sl({props:{warning:!0,$$slots:{default:[ii]},$$scope:{ctx:w}}}),he=new Z({props:{code:"cGlwZV9zYWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25TQUdQaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUwQSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfc2FnJTIwJTNEJTIwcGlwZV9zYWcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwc2FnX3NjYWxlJTNEMC43NSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zYWc=",highlighted:`pipe_sag = StableDiffusionSAGPipeline.from_pipe(
    pipe_sd
)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sag = pipe_sag(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    guidance_scale=<span class="hljs-number">1.0</span>,
    sag_scale=<span class="hljs-number">0.75</span>
).images[<span class="hljs-number">0</span>]
out_sag`,wrap:!1}}),Je=new Z({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDQuNDA2MjEzMjgzNTM4ODE4JTIwR0IlMjI=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),be=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBNb3Rpb25BZGFwdGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBcGlwZV9zYWcudW5sb2FkX2lwX2FkYXB0ZXIoKSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcGlwZV9hbmltYXRlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3BpcGUocGlwZV9zZCUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlX2FuaW1hdGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlX2FuaW1hdGUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIpJTBBJTIzJTIwbG9hZCUyMElQLUFkYXB0ZXIlMjBhbmQlMjBMb1JBJTIwd2VpZ2h0cyUyMGFnYWluJTBBcGlwZV9hbmltYXRlLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfYW5pbWF0ZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyKSUwQXBpcGVfYW5pbWF0ZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQXBpcGVfYW5pbWF0ZS5zZXRfYWRhcHRlcnMoJTIyem9vbS1vdXQlMjIlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QwLjc1KSUwQW91dCUyMCUzRCUyMHBpcGVfYW5pbWF0ZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZWFyJTIwZWF0cyUyMHBpenphJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihvdXQlMkMlMjAlMjJvdXRfYW5pbWF0ZS5naWYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, MotionAdapter, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

pipe_sag.unload_ip_adapter()
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipe_animate = AnimateDiffPipeline.from_pipe(pipe_sd, motion_adapter=adapter)
pipe_animate.scheduler = DDIMScheduler.from_config(pipe_animate.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
<span class="hljs-comment"># load IP-Adapter and LoRA weights again</span>
pipe_animate.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_animate.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe_animate.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
pipe_animate.set_adapters(<span class="hljs-string">&quot;zoom-out&quot;</span>, adapter_weights=<span class="hljs-number">0.75</span>)
out = pipe_animate(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    ip_adapter_image=image,
    generator=generator,
).frames[<span class="hljs-number">0</span>]
export_to_gif(out, <span class="hljs-string">&quot;out_animate.gif&quot;</span>)`,wrap:!1}}),je=new Z({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDE1LjE3ODY2NDIwNzQ1ODQ5NiUyMEdCJTIy",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 15.178664207458496 GB&quot;</span>`,wrap:!1}}),Ze=new C({props:{title:"Modify from_pipe components",local:"modify-frompipe-components",headingTag:"h3"}}),_e=new Z({props:{code:"cGlwZS5zYWdfdW5sb2FkX2lwX2FkYXB0ZXIoKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUyMkF0dHJpYnV0ZUVycm9yJTNBJTIwJ05vbmVUeXBlJyUyMG9iamVjdCUyMGhhcyUyMG5vJTIwYXR0cmlidXRlJTIwJ2ltYWdlX3Byb2plY3Rpb25fbGF5ZXJzJyUyMg==",highlighted:`pipe.sag_unload_ip_adapter()

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;AttributeError: &#x27;NoneType&#x27; object has no attribute &#x27;image_projection_layers&#x27;&quot;</span>`,wrap:!1}}),ve=new C({props:{title:"Memory usage of from_pipe",local:"memory-usage-of-frompipe",headingTag:"h3"}}),Ge=new C({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),ke=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),We=new C({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),S=new Sl({props:{warning:!1,$$slots:{default:[ni]},$$scope:{ctx:w}}}),Y=new Yl({props:{id:"variants",options:["fp16","non-EMA"],$$slots:{default:[oi]},$$scope:{ctx:w}}}),x=new Yl({props:{id:"save",options:["fp16","non_ema"],$$slots:{default:[ui]},$$scope:{ctx:w}}}),qe=new Z({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMCVGMCU5RiU5MSU4RCUyMHRoaXMlMjB3b3JrcyUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ze=new C({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),Ee=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXByaW50KHBpcGVsaW5lKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),Pe=new Z({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ke=new Z({props:{code:"LiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGZlYXR1cmVfZXh0cmFjdG9yJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHJlcHJvY2Vzc29yX2NvbmZpZy5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbW9kZWxfaW5kZXguanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNhZmV0eV9jaGVja2VyJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElN0MlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbC5mcDE2LnNhZmV0ZW5zb3JzJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbW9kZWwuc2FmZXRlbnNvcnMlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBweXRvcmNoX21vZGVsLmJpbiUwQSU3QyUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHB5dG9yY2hfbW9kZWwuZnAxNi5iaW4lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBzY2hlZHVsZXIlMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBzY2hlZHVsZXJfY29uZmlnLmpzb24lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0ZXh0X2VuY29kZXIlMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBjb25maWcuanNvbiUwQSU3QyUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG1vZGVsLmZwMTYuc2FmZXRlbnNvcnMlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbC5zYWZldGVuc29ycyUwQSVFMiU5NCU4MiUyMCUyMCUyMCU3QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHl0b3JjaF9tb2RlbC5mcDE2LmJpbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRva2VuaXplciUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG1lcmdlcy50eHQlMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBzcGVjaWFsX3Rva2Vuc19tYXAuanNvbiUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRva2VuaXplcl9jb25maWcuanNvbiUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHZvY2FiLmpzb24lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB1bmV0JTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5iaW4lMEElN0MlMjAlMjAlMjAlN0MlRTIlOTQlODAlRTIlOTQlODAlMjBkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5mcDE2LmJpbiUwQSVFMiU5NCU4MiUyMCUyMCUyMCU3QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmYxNi5zYWZldGVuc29ycyUwQSVFMiU5NCU4MiUyMCUyMCUyMCU3QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLm5vbl9lbWEuYmluJTBBJUUyJTk0JTgyJTIwJTIwJTIwJTdDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwubm9uX2VtYS5zYWZldGVuc29ycyUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLnNhZmV0ZW5zb3JzJTBBJTdDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdmFlJTBBLiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBLiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmJpbiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmZwMTYuYmluJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuZnAxNi5zYWZldGVuc29ycyUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),ss=new Z({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),is=new Z({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ns=new Ot({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){i=r("meta"),c=a(),n=r("p"),d=a(),y(o.$$.fragment),m=a(),y(j.$$.fragment),g=a(),_=r("p"),_.innerHTML=I,M=a(),v=r("p"),v.textContent=xl,rs=a(),q=r("ul"),q.innerHTML=ql,fs=a(),y(z.$$.fragment),us=a(),y(G.$$.fragment),cs=a(),D=r("p"),D.textContent=zl,ds=a(),F=r("ol"),F.innerHTML=Dl,ms=a(),y(V.$$.fragment),Ms=a(),H=r("p"),H.textContent=Fl,ys=a(),k=r("div"),k.innerHTML=Hl,hs=a(),W=r("div"),W.innerHTML=El,Us=a(),y(E.$$.fragment),Js=a(),A=r("p"),A.innerHTML=Al,Ts=a(),y(L.$$.fragment),bs=a(),P=r("p"),P.innerHTML=Ll,ws=a(),y(O.$$.fragment),js=a(),K=r("p"),K.innerHTML=Pl,Zs=a(),y(ee.$$.fragment),gs=a(),se=r("p"),se.textContent=Ol,_s=a(),le=r("ul"),le.innerHTML=Kl,vs=a(),te=r("p"),te.innerHTML=et,Is=a(),ie=r("ul"),ie.innerHTML=st,Cs=a(),y(ne.$$.fragment),$s=a(),ae=r("p"),ae.innerHTML=lt,Gs=a(),y(pe.$$.fragment),Vs=a(),y(oe.$$.fragment),ks=a(),re=r("p"),re.textContent=tt,Ws=a(),fe=r("ol"),fe.innerHTML=it,Rs=a(),ue=r("p"),ue.innerHTML=nt,Bs=a(),y(R.$$.fragment),Ns=a(),ce=r("p"),ce.innerHTML=at,Xs=a(),y(de.$$.fragment),Qs=a(),B=r("div"),B.innerHTML=pt,Ss=a(),me=r("p"),me.textContent=ot,Ys=a(),y(Me.$$.fragment),xs=a(),ye=r("p"),ye.innerHTML=rt,qs=a(),y(N.$$.fragment),zs=a(),y(he.$$.fragment),Ds=a(),X=r("div"),X.innerHTML=ft,Fs=a(),Ue=r("p"),Ue.innerHTML=ut,Hs=a(),y(Je.$$.fragment),Es=a(),Te=r("p"),Te.innerHTML=ct,As=a(),y(be.$$.fragment),Ls=a(),Q=r("div"),Q.innerHTML=dt,Ps=a(),we=r("p"),we.innerHTML=mt,Os=a(),y(je.$$.fragment),Ks=a(),y(Ze.$$.fragment),el=a(),ge=r("p"),ge.innerHTML=Mt,sl=a(),y(_e.$$.fragment),ll=a(),y(ve.$$.fragment),tl=a(),Ie=r("p"),Ie.innerHTML=yt,il=a(),Ce=r("table"),Ce.innerHTML=ht,nl=a(),$e=r("p"),$e.innerHTML=Ut,al=a(),y(Ge.$$.fragment),pl=a(),Ve=r("p"),Ve.innerHTML=Jt,ol=a(),y(ke.$$.fragment),rl=a(),y(We.$$.fragment),fl=a(),Re=r("p"),Re.textContent=Tt,ul=a(),Be=r("ul"),Be.innerHTML=bt,cl=a(),y(S.$$.fragment),dl=a(),Ne=r("p"),Ne.innerHTML=wt,ml=a(),Xe=r("table"),Xe.innerHTML=jt,Ml=a(),Qe=r("p"),Qe.textContent=Zt,yl=a(),Se=r("ul"),Se.innerHTML=gt,hl=a(),y(Y.$$.fragment),Ul=a(),Ye=r("p"),Ye.innerHTML=_t,Jl=a(),y(x.$$.fragment),Tl=a(),xe=r("p"),xe.innerHTML=vt,bl=a(),y(qe.$$.fragment),wl=a(),y(ze.$$.fragment),jl=a(),De=r("p"),De.innerHTML=It,Zl=a(),Fe=r("ul"),Fe.innerHTML=Ct,gl=a(),He=r("p"),He.innerHTML=$t,_l=a(),y(Ee.$$.fragment),vl=a(),Ae=r("p"),Ae.innerHTML=Gt,Il=a(),Le=r("ul"),Le.innerHTML=Vt,Cl=a(),y(Pe.$$.fragment),$l=a(),Oe=r("p"),Oe.innerHTML=kt,Gl=a(),y(Ke.$$.fragment),Vl=a(),es=r("p"),es.textContent=Wt,kl=a(),y(ss.$$.fragment),Wl=a(),ls=r("p"),ls.innerHTML=Rt,Rl=a(),ts=r("ul"),ts.innerHTML=Bt,Bl=a(),y(is.$$.fragment),Nl=a(),y(ns.$$.fragment),Xl=a(),os=r("p"),this.h()},l(e){const s=At("svelte-u9bgzb",document.head);i=f(s,"META",{name:!0,content:!0}),s.forEach(l),c=p(e),n=f(e,"P",{}),zt(n).forEach(l),d=p(e),h(o.$$.fragment,e),m=p(e),h(j.$$.fragment,e),g=p(e),_=f(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-hinagz"&&(_.innerHTML=I),M=p(e),v=f(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-b6mpdv"&&(v.textContent=xl),rs=p(e),q=f(e,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-1eibdva"&&(q.innerHTML=ql),fs=p(e),h(z.$$.fragment,e),us=p(e),h(G.$$.fragment,e),cs=p(e),D=f(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1fp1qkh"&&(D.textContent=zl),ds=p(e),F=f(e,"OL",{"data-svelte-h":!0}),u(F)!=="svelte-1kk6p08"&&(F.innerHTML=Dl),ms=p(e),h(V.$$.fragment,e),Ms=p(e),H=f(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-x1hybx"&&(H.textContent=Fl),ys=p(e),k=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-1eacg44"&&(k.innerHTML=Hl),hs=p(e),W=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-1scmarz"&&(W.innerHTML=El),Us=p(e),h(E.$$.fragment,e),Js=p(e),A=f(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-19d3ik7"&&(A.innerHTML=Al),Ts=p(e),h(L.$$.fragment,e),bs=p(e),P=f(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-12h80i0"&&(P.innerHTML=Ll),ws=p(e),h(O.$$.fragment,e),js=p(e),K=f(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1h03plm"&&(K.innerHTML=Pl),Zs=p(e),h(ee.$$.fragment,e),gs=p(e),se=f(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1ifrszd"&&(se.textContent=Ol),_s=p(e),le=f(e,"UL",{"data-svelte-h":!0}),u(le)!=="svelte-1ln6l0l"&&(le.innerHTML=Kl),vs=p(e),te=f(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-pkpme0"&&(te.innerHTML=et),Is=p(e),ie=f(e,"UL",{"data-svelte-h":!0}),u(ie)!=="svelte-rqg14m"&&(ie.innerHTML=st),Cs=p(e),h(ne.$$.fragment,e),$s=p(e),ae=f(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1597kan"&&(ae.innerHTML=lt),Gs=p(e),h(pe.$$.fragment,e),Vs=p(e),h(oe.$$.fragment,e),ks=p(e),re=f(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-14g5ay7"&&(re.textContent=tt),Ws=p(e),fe=f(e,"OL",{"data-svelte-h":!0}),u(fe)!=="svelte-13qlu9w"&&(fe.innerHTML=it),Rs=p(e),ue=f(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-4g3pzu"&&(ue.innerHTML=nt),Bs=p(e),h(R.$$.fragment,e),Ns=p(e),ce=f(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-c0p1my"&&(ce.innerHTML=at),Xs=p(e),h(de.$$.fragment,e),Qs=p(e),B=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(B)!=="svelte-ye42mk"&&(B.innerHTML=pt),Ss=p(e),me=f(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1u6h93y"&&(me.textContent=ot),Ys=p(e),h(Me.$$.fragment,e),xs=p(e),ye=f(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1wimezw"&&(ye.innerHTML=rt),qs=p(e),h(N.$$.fragment,e),zs=p(e),h(he.$$.fragment,e),Ds=p(e),X=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(X)!=="svelte-5lltp7"&&(X.innerHTML=ft),Fs=p(e),Ue=f(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-tmh3yz"&&(Ue.innerHTML=ut),Hs=p(e),h(Je.$$.fragment,e),Es=p(e),Te=f(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-y99jzq"&&(Te.innerHTML=ct),As=p(e),h(be.$$.fragment,e),Ls=p(e),Q=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Q)!=="svelte-cbprhg"&&(Q.innerHTML=dt),Ps=p(e),we=f(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-if12r7"&&(we.innerHTML=mt),Os=p(e),h(je.$$.fragment,e),Ks=p(e),h(Ze.$$.fragment,e),el=p(e),ge=f(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1vok8x4"&&(ge.innerHTML=Mt),sl=p(e),h(_e.$$.fragment,e),ll=p(e),h(ve.$$.fragment,e),tl=p(e),Ie=f(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-o307e0"&&(Ie.innerHTML=yt),il=p(e),Ce=f(e,"TABLE",{"data-svelte-h":!0}),u(Ce)!=="svelte-170u8iz"&&(Ce.innerHTML=ht),nl=p(e),$e=f(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-ap5wmd"&&($e.innerHTML=Ut),al=p(e),h(Ge.$$.fragment,e),pl=p(e),Ve=f(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1cvnvup"&&(Ve.innerHTML=Jt),ol=p(e),h(ke.$$.fragment,e),rl=p(e),h(We.$$.fragment,e),fl=p(e),Re=f(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-144ljdh"&&(Re.textContent=Tt),ul=p(e),Be=f(e,"UL",{"data-svelte-h":!0}),u(Be)!=="svelte-86xcrp"&&(Be.innerHTML=bt),cl=p(e),h(S.$$.fragment,e),dl=p(e),Ne=f(e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-naaguo"&&(Ne.innerHTML=wt),ml=p(e),Xe=f(e,"TABLE",{"data-svelte-h":!0}),u(Xe)!=="svelte-1xwvx35"&&(Xe.innerHTML=jt),Ml=p(e),Qe=f(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-9nwb1f"&&(Qe.textContent=Zt),yl=p(e),Se=f(e,"UL",{"data-svelte-h":!0}),u(Se)!=="svelte-kz39jt"&&(Se.innerHTML=gt),hl=p(e),h(Y.$$.fragment,e),Ul=p(e),Ye=f(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-q3acxq"&&(Ye.innerHTML=_t),Jl=p(e),h(x.$$.fragment,e),Tl=p(e),xe=f(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-s6vvaz"&&(xe.innerHTML=vt),bl=p(e),h(qe.$$.fragment,e),wl=p(e),h(ze.$$.fragment,e),jl=p(e),De=f(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-pzvcm5"&&(De.innerHTML=It),Zl=p(e),Fe=f(e,"UL",{"data-svelte-h":!0}),u(Fe)!=="svelte-1yi6mnz"&&(Fe.innerHTML=Ct),gl=p(e),He=f(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1xrsbru"&&(He.innerHTML=$t),_l=p(e),h(Ee.$$.fragment,e),vl=p(e),Ae=f(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-1blugjc"&&(Ae.innerHTML=Gt),Il=p(e),Le=f(e,"UL",{"data-svelte-h":!0}),u(Le)!=="svelte-ues7i"&&(Le.innerHTML=Vt),Cl=p(e),h(Pe.$$.fragment,e),$l=p(e),Oe=f(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-16nw0pl"&&(Oe.innerHTML=kt),Gl=p(e),h(Ke.$$.fragment,e),Vl=p(e),es=f(e,"P",{"data-svelte-h":!0}),u(es)!=="svelte-5jik9b"&&(es.textContent=Wt),kl=p(e),h(ss.$$.fragment,e),Wl=p(e),ls=f(e,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-g117c6"&&(ls.innerHTML=Rt),Rl=p(e),ts=f(e,"UL",{"data-svelte-h":!0}),u(ts)!=="svelte-hr84vt"&&(ts.innerHTML=Bt),Bl=p(e),h(is.$$.fragment,e),Nl=p(e),h(ns.$$.fragment,e),Xl=p(e),os=f(e,"P",{}),zt(os).forEach(l),this.h()},h(){as(i,"name","hf:doc:metadata"),as(i,"content",di),as(k,"class","block dark:hidden"),as(W,"class","hidden dark:block"),as(B,"class","flex justify-center"),as(X,"class","flex justify-center"),as(Q,"class","flex justify-center")},m(e,s){Lt(document.head,i),t(e,c,s),t(e,n,s),t(e,d,s),U(o,e,s),t(e,m,s),U(j,e,s),t(e,g,s),t(e,_,s),t(e,M,s),t(e,v,s),t(e,rs,s),t(e,q,s),t(e,fs,s),U(z,e,s),t(e,us,s),U(G,e,s),t(e,cs,s),t(e,D,s),t(e,ds,s),t(e,F,s),t(e,ms,s),U(V,e,s),t(e,Ms,s),t(e,H,s),t(e,ys,s),t(e,k,s),t(e,hs,s),t(e,W,s),t(e,Us,s),U(E,e,s),t(e,Js,s),t(e,A,s),t(e,Ts,s),U(L,e,s),t(e,bs,s),t(e,P,s),t(e,ws,s),U(O,e,s),t(e,js,s),t(e,K,s),t(e,Zs,s),U(ee,e,s),t(e,gs,s),t(e,se,s),t(e,_s,s),t(e,le,s),t(e,vs,s),t(e,te,s),t(e,Is,s),t(e,ie,s),t(e,Cs,s),U(ne,e,s),t(e,$s,s),t(e,ae,s),t(e,Gs,s),U(pe,e,s),t(e,Vs,s),U(oe,e,s),t(e,ks,s),t(e,re,s),t(e,Ws,s),t(e,fe,s),t(e,Rs,s),t(e,ue,s),t(e,Bs,s),U(R,e,s),t(e,Ns,s),t(e,ce,s),t(e,Xs,s),U(de,e,s),t(e,Qs,s),t(e,B,s),t(e,Ss,s),t(e,me,s),t(e,Ys,s),U(Me,e,s),t(e,xs,s),t(e,ye,s),t(e,qs,s),U(N,e,s),t(e,zs,s),U(he,e,s),t(e,Ds,s),t(e,X,s),t(e,Fs,s),t(e,Ue,s),t(e,Hs,s),U(Je,e,s),t(e,Es,s),t(e,Te,s),t(e,As,s),U(be,e,s),t(e,Ls,s),t(e,Q,s),t(e,Ps,s),t(e,we,s),t(e,Os,s),U(je,e,s),t(e,Ks,s),U(Ze,e,s),t(e,el,s),t(e,ge,s),t(e,sl,s),U(_e,e,s),t(e,ll,s),U(ve,e,s),t(e,tl,s),t(e,Ie,s),t(e,il,s),t(e,Ce,s),t(e,nl,s),t(e,$e,s),t(e,al,s),U(Ge,e,s),t(e,pl,s),t(e,Ve,s),t(e,ol,s),U(ke,e,s),t(e,rl,s),U(We,e,s),t(e,fl,s),t(e,Re,s),t(e,ul,s),t(e,Be,s),t(e,cl,s),U(S,e,s),t(e,dl,s),t(e,Ne,s),t(e,ml,s),t(e,Xe,s),t(e,Ml,s),t(e,Qe,s),t(e,yl,s),t(e,Se,s),t(e,hl,s),U(Y,e,s),t(e,Ul,s),t(e,Ye,s),t(e,Jl,s),U(x,e,s),t(e,Tl,s),t(e,xe,s),t(e,bl,s),U(qe,e,s),t(e,wl,s),U(ze,e,s),t(e,jl,s),t(e,De,s),t(e,Zl,s),t(e,Fe,s),t(e,gl,s),t(e,He,s),t(e,_l,s),U(Ee,e,s),t(e,vl,s),t(e,Ae,s),t(e,Il,s),t(e,Le,s),t(e,Cl,s),U(Pe,e,s),t(e,$l,s),t(e,Oe,s),t(e,Gl,s),U(Ke,e,s),t(e,Vl,s),t(e,es,s),t(e,kl,s),U(ss,e,s),t(e,Wl,s),t(e,ls,s),t(e,Rl,s),t(e,ts,s),t(e,Bl,s),U(is,e,s),t(e,Nl,s),U(ns,e,s),t(e,Xl,s),t(e,os,s),Ql=!0},p(e,[s]){const Nt={};s&2&&(Nt.$$scope={dirty:s,ctx:e}),G.$set(Nt);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:e}),V.$set(Xt);const Qt={};s&2&&(Qt.$$scope={dirty:s,ctx:e}),R.$set(Qt);const St={};s&2&&(St.$$scope={dirty:s,ctx:e}),N.$set(St);const Yt={};s&2&&(Yt.$$scope={dirty:s,ctx:e}),S.$set(Yt);const xt={};s&2&&(xt.$$scope={dirty:s,ctx:e}),Y.$set(xt);const qt={};s&2&&(qt.$$scope={dirty:s,ctx:e}),x.$set(qt)},i(e){Ql||(J(o.$$.fragment,e),J(j.$$.fragment,e),J(z.$$.fragment,e),J(G.$$.fragment,e),J(V.$$.fragment,e),J(E.$$.fragment,e),J(L.$$.fragment,e),J(O.$$.fragment,e),J(ee.$$.fragment,e),J(ne.$$.fragment,e),J(pe.$$.fragment,e),J(oe.$$.fragment,e),J(R.$$.fragment,e),J(de.$$.fragment,e),J(Me.$$.fragment,e),J(N.$$.fragment,e),J(he.$$.fragment,e),J(Je.$$.fragment,e),J(be.$$.fragment,e),J(je.$$.fragment,e),J(Ze.$$.fragment,e),J(_e.$$.fragment,e),J(ve.$$.fragment,e),J(Ge.$$.fragment,e),J(ke.$$.fragment,e),J(We.$$.fragment,e),J(S.$$.fragment,e),J(Y.$$.fragment,e),J(x.$$.fragment,e),J(qe.$$.fragment,e),J(ze.$$.fragment,e),J(Ee.$$.fragment,e),J(Pe.$$.fragment,e),J(Ke.$$.fragment,e),J(ss.$$.fragment,e),J(is.$$.fragment,e),J(ns.$$.fragment,e),Ql=!0)},o(e){T(o.$$.fragment,e),T(j.$$.fragment,e),T(z.$$.fragment,e),T(G.$$.fragment,e),T(V.$$.fragment,e),T(E.$$.fragment,e),T(L.$$.fragment,e),T(O.$$.fragment,e),T(ee.$$.fragment,e),T(ne.$$.fragment,e),T(pe.$$.fragment,e),T(oe.$$.fragment,e),T(R.$$.fragment,e),T(de.$$.fragment,e),T(Me.$$.fragment,e),T(N.$$.fragment,e),T(he.$$.fragment,e),T(Je.$$.fragment,e),T(be.$$.fragment,e),T(je.$$.fragment,e),T(Ze.$$.fragment,e),T(_e.$$.fragment,e),T(ve.$$.fragment,e),T(Ge.$$.fragment,e),T(ke.$$.fragment,e),T(We.$$.fragment,e),T(S.$$.fragment,e),T(Y.$$.fragment,e),T(x.$$.fragment,e),T(qe.$$.fragment,e),T(ze.$$.fragment,e),T(Ee.$$.fragment,e),T(Pe.$$.fragment,e),T(Ke.$$.fragment,e),T(ss.$$.fragment,e),T(is.$$.fragment,e),T(ns.$$.fragment,e),Ql=!1},d(e){e&&(l(c),l(n),l(d),l(m),l(g),l(_),l(M),l(v),l(rs),l(q),l(fs),l(us),l(cs),l(D),l(ds),l(F),l(ms),l(Ms),l(H),l(ys),l(k),l(hs),l(W),l(Us),l(Js),l(A),l(Ts),l(bs),l(P),l(ws),l(js),l(K),l(Zs),l(gs),l(se),l(_s),l(le),l(vs),l(te),l(Is),l(ie),l(Cs),l($s),l(ae),l(Gs),l(Vs),l(ks),l(re),l(Ws),l(fe),l(Rs),l(ue),l(Bs),l(Ns),l(ce),l(Xs),l(Qs),l(B),l(Ss),l(me),l(Ys),l(xs),l(ye),l(qs),l(zs),l(Ds),l(X),l(Fs),l(Ue),l(Hs),l(Es),l(Te),l(As),l(Ls),l(Q),l(Ps),l(we),l(Os),l(Ks),l(el),l(ge),l(sl),l(ll),l(tl),l(Ie),l(il),l(Ce),l(nl),l($e),l(al),l(pl),l(Ve),l(ol),l(rl),l(fl),l(Re),l(ul),l(Be),l(cl),l(dl),l(Ne),l(ml),l(Xe),l(Ml),l(Qe),l(yl),l(Se),l(hl),l(Ul),l(Ye),l(Jl),l(Tl),l(xe),l(bl),l(wl),l(jl),l(De),l(Zl),l(Fe),l(gl),l(He),l(_l),l(vl),l(Ae),l(Il),l(Le),l(Cl),l($l),l(Oe),l(Gl),l(Vl),l(es),l(kl),l(Wl),l(ls),l(Rl),l(ts),l(Bl),l(Nl),l(Xl),l(os)),l(i),b(o,e),b(j,e),b(z,e),b(G,e),b(V,e),b(E,e),b(L,e),b(O,e),b(ee,e),b(ne,e),b(pe,e),b(oe,e),b(R,e),b(de,e),b(Me,e),b(N,e),b(he,e),b(Je,e),b(be,e),b(je,e),b(Ze,e),b(_e,e),b(ve,e),b(Ge,e),b(ke,e),b(We,e),b(S,e),b(Y,e),b(x,e),b(qe,e),b(ze,e),b(Ee,e),b(Pe,e),b(Ke,e),b(ss,e),b(is,e),b(ns,e)}}}const di='{"title":"Load pipelines","local":"load-pipelines","sections":[{"title":"Load a pipeline","local":"load-a-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Customize a pipeline","local":"customize-a-pipeline","sections":[],"depth":2},{"title":"Reuse a pipeline","local":"reuse-a-pipeline","sections":[{"title":"Modify from_pipe components","local":"modify-frompipe-components","sections":[],"depth":3},{"title":"Memory usage of from_pipe","local":"memory-usage-of-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function mi(w){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wi extends Ht{constructor(i){super(),Et(this,i,mi,ci,Dt,{})}}export{wi as component};
