import{s as ol,n as pl,o as rl}from"../chunks/scheduler.8c3d61f6.js";import{S as dl,i as cl,g as n,s as i,r,A as ml,h as o,f as l,c as a,j as nl,u as d,x as p,k as g,l as vt,y as hl,a as s,v as c,d as m,t as h,w as u}from"../chunks/index.da70eac4.js";import{C as T}from"../chunks/CodeBlock.00a903b3.js";import{H as J,E as ul}from"../chunks/EditOnGithub.1e64e623.js";function gl(jt){let y,we,ye,be,I,Ze,W,Ut='<a href="../api/pipelines/marigold">Marigold</a> is a novel diffusion-based dense prediction approach, and a set of pipelines for various computer vision tasks, such as monocular depth estimation.',ve,G,Bt="This guide will show you how to use Marigold to obtain fast and high-quality predictions for images and videos.",je,k,It=`Each pipeline supports one Computer Vision task, which takes an input RGB image as input and produces a <em>prediction</em> of the modality of interest, such as a depth map of the input image.
Currently, the following tasks are implemented:`,Ue,x,Wt='<thead><tr><th>Pipeline</th> <th>Predicted Modalities</th> <th align="center">Demos</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py" rel="nofollow">MarigoldDepthPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Depth_map" rel="nofollow">Depth</a>, <a href="https://en.wikipedia.org/wiki/Binocular_disparity" rel="nofollow">Disparity</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-lcm" rel="nofollow">Fast Demo (LCM)</a>, <a href="https://huggingface.co/spaces/prs-eth/marigold" rel="nofollow">Slow Original Demo (DDIM)</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py" rel="nofollow">MarigoldNormalsPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Normal_mapping" rel="nofollow">Surface normals</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-normals-lcm" rel="nofollow">Fast Demo (LCM)</a></td></tr></tbody>',Be,R,Gt=`The original checkpoints can be found under the <a href="https://huggingface.co/prs-eth/" rel="nofollow">PRS-ETH</a> Hugging Face organization.
These checkpoints are meant to work with diffusers pipelines and the <a href="https://github.com/prs-eth/marigold" rel="nofollow">original codebase</a>.
The original code can also be used to train new checkpoints.`,Ie,C,kt='<thead><tr><th>Checkpoint</th> <th>Modality</th> <th>Comment</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/prs-eth/marigold-v1-0" rel="nofollow">prs-eth/marigold-v1-0</a></td> <td>Depth</td> <td>The first Marigold Depth checkpoint, which predicts <em>affine-invariant depth</em> maps. The performance of this checkpoint in benchmarks was studied in the original <a href="https://huggingface.co/papers/2312.02145" rel="nofollow">paper</a>. Designed to be used with the <code>DDIMScheduler</code> at inference, it requires at least 10 steps to get reliable predictions. Affine-invariant depth prediction has a range of values in each pixel between 0 (near plane) and 1 (far plane); both planes are chosen by the model as part of the inference process. See the <code>MarigoldImageProcessor</code> reference for visualization utilities.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-depth-lcm-v1-0" rel="nofollow">prs-eth/marigold-depth-lcm-v1-0</a></td> <td>Depth</td> <td>The fast Marigold Depth checkpoint, fine-tuned from <code>prs-eth/marigold-v1-0</code>. Designed to be used with the <code>LCMScheduler</code> at inference, it requires as little as 1 step to get reliable predictions. The prediction reliability saturates at 4 steps and declines after that.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-normals-v0-1" rel="nofollow">prs-eth/marigold-normals-v0-1</a></td> <td>Normals</td> <td>A preview checkpoint for the Marigold Normals pipeline. Designed to be used with the <code>DDIMScheduler</code> at inference, it requires at least 10 steps to get reliable predictions. The surface normals predictions are unit-length 3D vectors with values in the range from -1 to 1. <em>This checkpoint will be phased out after the release of <code>v1-0</code> version.</em></td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-normals-lcm-v0-1" rel="nofollow">prs-eth/marigold-normals-lcm-v0-1</a></td> <td>Normals</td> <td>The fast Marigold Normals checkpoint, fine-tuned from <code>prs-eth/marigold-normals-v0-1</code>. Designed to be used with the <code>LCMScheduler</code> at inference, it requires as little as 1 step to get reliable predictions. The prediction reliability saturates at 4 steps and declines after that. <em>This checkpoint will be phased out after the release of <code>v1-0</code> version.</em></td></tr></tbody>',We,_,xt=`The examples below are mostly given for depth prediction, but they can be universally applied with other supported modalities.
We showcase the predictions using the same input image of Albert Einstein generated by Midjourney.
This makes it easier to compare visualizations of the predictions across various modalities and checkpoints.`,Ge,M,Rt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://marigoldmonodepth.github.io/images/einstein.jpg"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Example input image for all Marigold pipelines</figcaption></div>',ke,X,xe,V,Ct="To get the first depth prediction, load <code>prs-eth/marigold-depth-lcm-v1-0</code> checkpoint into <code>MarigoldDepthPipeline</code> pipeline, put the image through the pipeline, and save the predictions:",Re,z,Ce,E,_t=`The visualization function for depth <code>visualize_depth()</code> applies one of <a href="https://matplotlib.org/stable/users/explain/colors/colormaps.html" rel="nofollow">matplotlib’s colormaps</a> (<code>Spectral</code> by default) to map the predicted pixel values from a single-channel <code>[0, 1]</code> depth range into an RGB image.
With the <code>Spectral</code> colormap, pixels with near depth are painted red, and far pixels are assigned blue color.
The 16-bit PNG file stores the single channel values mapped linearly from the <code>[0, 1]</code> range into <code>[0, 65535]</code>.
Below are the raw and the visualized predictions; as can be seen, dark areas (mustache) are easier to distinguish in the visualization:`,_e,w,Xt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_depth_16bit.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth (16-bit PNG)</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth visualization (Spectral)</figcaption></div>',Xe,N,Ve,H,Vt="Load <code>prs-eth/marigold-normals-lcm-v0-1</code> checkpoint into <code>MarigoldNormalsPipeline</code> pipeline, put the image through the pipeline, and save the predictions:",ze,S,Ee,Y,zt=`The visualization function for normals <code>visualize_normals()</code> maps the three-dimensional prediction with pixel values in the range <code>[-1, 1]</code> into an RGB image.
The visualization function supports flipping surface normals axes to make the visualization compatible with other choices of the frame of reference.
Conceptually, each pixel is painted according to the surface normal vector in the frame of reference, where <code>X</code> axis points right, <code>Y</code> axis points up, and <code>Z</code> axis points at the viewer.
Below is the visualized prediction:`,Ne,f,Et='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted surface normals visualization</figcaption></div>',He,F,Nt=`In this example, the nose tip almost certainly has a point on the surface, in which the surface normal vector points straight at the viewer, meaning that its coordinates are <code>[0, 0, 1]</code>.
This vector maps to the RGB <code>[128, 128, 255]</code>, which corresponds to the violet-blue color.
Similarly, a surface normal on the cheek in the right part of the image has a large <code>X</code> component, which increases the red hue.
Points on the shoulders pointing up with a large <code>Y</code> promote green color.`,Se,$,Ye,L,Ht=`The above quick start snippets are already optimized for speed: they load the LCM checkpoint, use the <code>fp16</code> variant of weights and computation, and perform just one denoising diffusion step.
The <code>pipe(image)</code> call completes in 280ms on RTX 3090 GPU.
Internally, the input image is encoded with the Stable Diffusion VAE encoder, then the U-Net performs one denoising step, and finally, the prediction latent is decoded with the VAE decoder into pixel space.
In this case, two out of three module calls are dedicated to converting between pixel and latent space of LDM.
Because Marigold’s latent space is compatible with the base Stable Diffusion, it is possible to speed up the pipeline call by more than 3x (85ms on RTX 3090) by using a <a href="../api/models/autoencoder_tiny">lightweight replacement of the SD VAE</a>:`,Fe,q,$e,Q,St='As suggested in <a href="../optimization/torch2.0#torch.compile">Optimizations</a>, adding <code>torch.compile</code> may squeeze extra performance depending on the target hardware:',Le,A,qe,D,Qe,P,Yt='With the above speed optimizations, Marigold delivers predictions with more details and faster than <a href="https://huggingface.co/docs/transformers/main/en/model_doc/depth_anything" rel="nofollow">Depth Anything</a> with the largest checkpoint <a href="https://huggingface.co/LiheYoung/depth-anything-large-hf" rel="nofollow">LiheYoung/depth-anything-large-hf</a>:',Ae,b,Ft='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold LCM fp16 with Tiny AutoEncoder</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/einstein_depthanything_large.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth Anything Large</figcaption></div>',De,K,Pe,O,$t=`Marigold pipelines have a built-in ensembling mechanism combining multiple predictions from different random latents.
This is a brute-force way of improving the precision of predictions, capitalizing on the generative nature of diffusion.
The ensembling path is activated automatically when the <code>ensemble_size</code> argument is set greater than <code>1</code>.
When aiming for maximum precision, it makes sense to adjust <code>num_inference_steps</code> simultaneously with <code>ensemble_size</code>.
The recommended values vary across checkpoints but primarily depend on the scheduler type.
The effect of ensembling is particularly well-seen with surface normals:`,Ke,ee,Oe,Z,Lt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, no ensembling</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, with ensembling</figcaption></div>',et,te,qt=`As can be seen, all areas with fine-grained structurers, such as hair, got more conservative and on average more correct predictions.
Such a result is more suitable for precision-sensitive downstream tasks, such as 3D reconstruction.`,tt,le,lt,se,Qt=`To evaluate Marigold quantitatively in standard leaderboards and benchmarks (such as NYU, KITTI, and other datasets), follow the evaluation protocol outlined in the paper: load the full precision fp32 model and use appropriate values for <code>num_inference_steps</code> and <code>ensemble_size</code>.
Optionally seed randomness to ensure reproducibility. Maximizing <code>batch_size</code> will deliver maximum device utilization.`,st,ie,it,ae,at,ne,At=`The ensembling mechanism built into Marigold pipelines combines multiple predictions obtained from different random latents.
As a side effect, it can be used to quantify epistemic (model) uncertainty; simply specify <code>ensemble_size</code> greater than 1 and set <code>output_uncertainty=True</code>.
The resulting uncertainty will be available in the <code>uncertainty</code> field of the output.
It can be visualized as follows:`,nt,oe,ot,v,Dt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_depth_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth uncertainty</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_normals_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals uncertainty</figcaption></div>',pt,pe,Pt=`The interpretation of uncertainty is easy: higher values (white) correspond to pixels, where the model struggles to make consistent predictions.
Evidently, the depth model is the least confident around edges with discontinuity, where the object depth changes drastically.
The surface normals model is the least confident in fine-grained structures, such as hair, and dark areas, such as the collar.`,rt,re,dt,de,Kt=`Due to Marigold’s generative nature, each prediction is unique and defined by the random noise sampled for the latent initialization.
This becomes an obvious drawback compared to traditional end-to-end dense regression networks, as exemplified in the following videos:`,ct,j,Ot='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Input video</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div>',mt,ce,el=`To address this issue, it is possible to pass <code>latents</code> argument to the pipelines, which defines the starting point of diffusion.
Empirically, we found that a convex combination of the very same starting point noise latent and the latent corresponding to the previous frame prediction give sufficiently smooth results, as implemented in the snippet below:`,ht,me,ut,he,tl=`Here, the diffusion process starts from the given computed latent.
The pipeline sets <code>output_latent=True</code> to access <code>out.latent</code> and computes its contribution to the next frame’s latent initialization.
The result is much more stable now:`,gt,U,ll='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_consistent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth with forced latents initialization</figcaption></div>',Mt,ue,ft,ge,sl=`A very common application for depth prediction with diffusion models comes in conjunction with ControlNet.
Depth crispness plays a crucial role in obtaining high-quality results from ControlNet.
As seen in comparisons with other methods above, Marigold excels at that task.
The snippet below demonstrates how to load an image, compute depth, and pass it into ControlNet in a compatible format:`,Jt,Me,yt,B,il='<div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_depth_source.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Input image</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/motorcycle_controlnet_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth in the format compatible with ControlNet</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/motorcycle_controlnet_out.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">ControlNet generation, conditioned on depth and prompt: &quot;high quality photo of a sports bike, city&quot;</figcaption></div>',Tt,fe,al="Hopefully, you will find Marigold useful for solving your downstream tasks, be it a part of a more broad generative workflow, or a perception task, such as 3D reconstruction.",wt,Je,bt,Te,Zt;return I=new J({props:{title:"Marigold Pipelines for Computer Vision Tasks",local:"marigold-pipelines-for-computer-vision-tasks",headingTag:"h1"}}),X=new J({props:{title:"Depth Prediction Quick Start",local:"depth-prediction-quick-start",headingTag:"h3"}}),z=new T({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2RlcHRoKGRlcHRoLnByZWRpY3Rpb24pJTBBdmlzJTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoLnBuZyUyMiklMEElMEFkZXB0aF8xNmJpdCUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLmV4cG9ydF9kZXB0aF90b18xNmJpdF9wbmcoZGVwdGgucHJlZGljdGlvbiklMEFkZXB0aF8xNmJpdCU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9kZXB0aF8xNmJpdC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
depth = pipe(image)

vis = pipe.image_processor.visualize_depth(depth.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth.png&quot;</span>)

depth_16bit = pipe.image_processor.export_depth_to_16bit_png(depth.prediction)
depth_16bit[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_16bit.png&quot;</span>)`,wrap:!1}}),N=new J({props:{title:"Surface Normals Prediction Quick Start",local:"surface-normals-prediction-quick-start",headingTag:"h3"}}),S=new T({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkTm9ybWFsc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtbm9ybWFscy1sY20tdjAtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBbm9ybWFscyUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX25vcm1hbHMobm9ybWFscy5wcmVkaWN0aW9uKSUwQXZpcyU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9ub3JtYWxzLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-normals-lcm-v0-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
normals = pipe(image)

vis = pipe.image_processor.visualize_normals(normals.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),$=new J({props:{title:"Speeding up inference",local:"speeding-up-inference",headingTag:"h3"}}),q=new T({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjApLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTJCJTIwcGlwZS52YWUlMjAlM0QlMjBkaWZmdXNlcnMuQXV0b2VuY29kZXJUaW55LmZyb21fcHJldHJhaW5lZCglMEElMkIlMjAlMjAlMjAlMjAlMjAlMjJtYWRlYnlvbGxpbiUyRnRhZXNkJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBJTJCJTIwKS5jdWRhKCklMEElMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUyMCUyMGRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSk=",highlighted:`  import diffusers
  import torch

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-lcm-v1-0&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

<span class="hljs-addition">+ pipe.vae = diffusers.AutoencoderTiny.from_pretrained(</span>
<span class="hljs-addition">+     &quot;madebyollin/taesd&quot;, torch_dtype=torch.float16</span>
<span class="hljs-addition">+ ).cuda()</span>

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)
  depth = pipe(image)`,wrap:!1}}),A=new T({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjApLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUyMCUyMGRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSk=",highlighted:`  import diffusers
  import torch

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-lcm-v1-0&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)
  depth = pipe(image)`,wrap:!1}}),D=new J({props:{title:"Qualitative Comparison with Depth Anything",local:"qualitative-comparison-with-depth-anything",headingTag:"h2"}}),K=new J({props:{title:"Maximizing Precision and Ensembling",local:"maximizing-precision-and-ensembling",headingTag:"h2"}}),ee=new T({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBycy1ldGglMkZtYXJpZ29sZC1ub3JtYWxzLXYxLTAlMjIlMEElMEFtb2RlbF9wYXBlcl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMDlkaWZmdXNlcnMuc2NoZWR1bGVycy5ERElNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDEwJTJDJTBBJTA5JTA5JTIyZW5zZW1ibGVfc2l6ZSUyMiUzQSUyMDEwJTJDJTBBJTA5JTdEJTJDJTBBJTA5ZGlmZnVzZXJzLnNjaGVkdWxlcnMuTENNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDQlMkMlMEElMDklMDklMjJlbnNlbWJsZV9zaXplJTIyJTNBJTIwNSUyQyUwQSUwOSU3RCUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBJTBBcGlwZSUyMCUzRCUyMGRpZmZ1c2Vycy5NYXJpZ29sZE5vcm1hbHNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfcGF0aCkudG8oJTIyY3VkYSUyMiklMEFwaXBlX2t3YXJncyUyMCUzRCUyMG1vZGVsX3BhcGVyX2t3YXJncyU1QnR5cGUocGlwZS5zY2hlZHVsZXIpJTVEJTBBJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwKipwaXBlX2t3YXJncyklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfbm9ybWFscyhkZXB0aC5wcmVkaWN0aW9uKSUwQXZpcyU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9ub3JtYWxzLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers

model_path = <span class="hljs-string">&quot;prs-eth/marigold-normals-v1-0&quot;</span>

model_paper_kwargs = {
	diffusers.schedulers.DDIMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">10</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},
	diffusers.schedulers.LCMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">4</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">5</span>,
	},
}

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(model_path).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_kwargs = model_paper_kwargs[<span class="hljs-built_in">type</span>(pipe.scheduler)]

depth = pipe(image, **pipe_kwargs)

vis = pipe.image_processor.visualize_normals(depth.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),le=new J({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),ie=new T({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBc2VlZCUyMCUzRCUyMDIwMjQlMEFtb2RlbF9wYXRoJTIwJTNEJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLXYxLTAlMjIlMEElMEFtb2RlbF9wYXBlcl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMDlkaWZmdXNlcnMuc2NoZWR1bGVycy5ERElNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTA5JTA5JTIyZW5zZW1ibGVfc2l6ZSUyMiUzQSUyMDEwJTJDJTBBJTA5JTdEJTJDJTBBJTA5ZGlmZnVzZXJzLnNjaGVkdWxlcnMuTENNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDQlMkMlMEElMDklMDklMjJlbnNlbWJsZV9zaXplJTIyJTNBJTIwMTAlMkMlMEElMDklN0QlMkMlMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0RkZXZpY2UpLm1hbnVhbF9zZWVkKHNlZWQpJTBBcGlwZSUyMCUzRCUyMGRpZmZ1c2Vycy5NYXJpZ29sZERlcHRoUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX3BhdGgpLnRvKGRldmljZSklMEFwaXBlX2t3YXJncyUyMCUzRCUyMG1vZGVsX3BhcGVyX2t3YXJncyU1QnR5cGUocGlwZS5zY2hlZHVsZXIpJTVEJTBBJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwKipwaXBlX2t3YXJncyklMEElMEElMjMlMjBldmFsdWF0ZSUyMG1ldHJpY3M=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span>
seed = <span class="hljs-number">2024</span>
model_path = <span class="hljs-string">&quot;prs-eth/marigold-v1-0&quot;</span>

model_paper_kwargs = {
	diffusers.schedulers.DDIMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},
	diffusers.schedulers.LCMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">4</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},
}

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

generator = torch.Generator(device=device).manual_seed(seed)
pipe = diffusers.MarigoldDepthPipeline.from_pretrained(model_path).to(device)
pipe_kwargs = model_paper_kwargs[<span class="hljs-built_in">type</span>(pipe.scheduler)]

depth = pipe(image, generator=generator, **pipe_kwargs)

<span class="hljs-comment"># evaluate metrics</span>`,wrap:!1}}),ae=new J({props:{title:"Using Predictive Uncertainty",local:"using-predictive-uncertainty",headingTag:"h2"}}),oe=new T({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFkZXB0aCUyMCUzRCUyMHBpcGUoJTBBJTA5aW1hZ2UlMkMlMEElMDllbnNlbWJsZV9zaXplJTNEMTAlMkMlMjAlMjAlMjMlMjBhbnklMjBudW1iZXIlMjBncmVhdGVyJTIwdGhhbiUyMDElM0IlMjBoaWdoZXIlMjB2YWx1ZXMlMjB5aWVsZCUyMGhpZ2hlciUyMHByZWNpc2lvbiUwQSUwOW91dHB1dF91bmNlcnRhaW50eSUzRFRydWUlMkMlMEEpJTBBJTBBdW5jZXJ0YWludHklMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfdW5jZXJ0YWludHkoZGVwdGgudW5jZXJ0YWludHkpJTBBdW5jZXJ0YWludHklNUIwJTVELnNhdmUoJTIyZWluc3RlaW5fZGVwdGhfdW5jZXJ0YWludHkucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
depth = pipe(
	image,
	ensemble_size=<span class="hljs-number">10</span>,  <span class="hljs-comment"># any number greater than 1; higher values yield higher precision</span>
	output_uncertainty=<span class="hljs-literal">True</span>,
)

uncertainty = pipe.image_processor.visualize_uncertainty(depth.uncertainty)
uncertainty[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_uncertainty.png&quot;</span>)`,wrap:!1}}),re=new J({props:{title:"Frame-by-frame Video Processing with Temporal Consistency",local:"frame-by-frame-video-processing-with-temporal-consistency",headingTag:"h2"}}),me=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span>
path_in = <span class="hljs-string">&quot;obama.mp4&quot;</span>
path_out = <span class="hljs-string">&quot;obama_depth.gif&quot;</span>

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.vae = diffusers.AutoencoderTiny.from_pretrained(
    <span class="hljs-string">&quot;madebyollin/taesd&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> imageio.get_reader(path_in) <span class="hljs-keyword">as</span> reader:
    size = reader.get_meta_data()[<span class="hljs-string">&#x27;size&#x27;</span>]
    last_frame_latent = <span class="hljs-literal">None</span>
    latent_common = torch.randn(
        (<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span> * size[<span class="hljs-number">1</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)), <span class="hljs-number">768</span> * size[<span class="hljs-number">0</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)))
    ).to(device=device, dtype=torch.float16)

    out = []
    <span class="hljs-keyword">for</span> frame_id, frame <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(reader), desc=<span class="hljs-string">&quot;Processing Video&quot;</span>):
        frame = Image.fromarray(frame)
        latents = latent_common
        <span class="hljs-keyword">if</span> last_frame_latent <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            latents = <span class="hljs-number">0.9</span> * latents + <span class="hljs-number">0.1</span> * last_frame_latent

        depth = pipe(
			frame, match_input_resolution=<span class="hljs-literal">False</span>, latents=latents, output_latent=<span class="hljs-literal">True</span>
        )
        last_frame_latent = depth.latent
        out.append(pipe.image_processor.visualize_depth(depth.prediction)[<span class="hljs-number">0</span>])

    diffusers.utils.export_to_gif(out, path_out, fps=reader.get_meta_data()[<span class="hljs-string">&#x27;fps&#x27;</span>])`,wrap:!1}}),ue=new J({props:{title:"Marigold for ControlNet",local:"marigold-for-controlnet",headingTag:"h2"}}),Me=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> diffusers

device = <span class="hljs-string">&quot;cuda&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">2024</span>)
image = diffusers.utils.load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_depth_source.png&quot;</span>
)

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(device)

depth_image = pipe(image, generator=generator).prediction
depth_image = pipe.image_processor.visualize_depth(depth_image, color_map=<span class="hljs-string">&quot;binary&quot;</span>)
depth_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;motorcycle_controlnet_depth.png&quot;</span>)

controlnet = diffusers.ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(device)
pipe = diffusers.StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, controlnet=controlnet
).to(device)
pipe.scheduler = diffusers.DPMSolverMultistepScheduler.from_config(pipe.scheduler.config, use_karras_sigmas=<span class="hljs-literal">True</span>)

controlnet_out = pipe(
    prompt=<span class="hljs-string">&quot;high quality photo of a sports bike, city&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    guidance_scale=<span class="hljs-number">6.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    image=depth_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.7</span>,
    control_guidance_end=<span class="hljs-number">0.7</span>,
    generator=generator,
).images
controlnet_out[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;motorcycle_controlnet_out.png&quot;</span>)`,wrap:!1}}),Je=new ul({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/marigold_usage.md"}}),{c(){y=n("meta"),we=i(),ye=n("p"),be=i(),r(I.$$.fragment),Ze=i(),W=n("p"),W.innerHTML=Ut,ve=i(),G=n("p"),G.textContent=Bt,je=i(),k=n("p"),k.innerHTML=It,Ue=i(),x=n("table"),x.innerHTML=Wt,Be=i(),R=n("p"),R.innerHTML=Gt,Ie=i(),C=n("table"),C.innerHTML=kt,We=i(),_=n("p"),_.textContent=xt,Ge=i(),M=n("div"),M.innerHTML=Rt,ke=i(),r(X.$$.fragment),xe=i(),V=n("p"),V.innerHTML=Ct,Re=i(),r(z.$$.fragment),Ce=i(),E=n("p"),E.innerHTML=_t,_e=i(),w=n("div"),w.innerHTML=Xt,Xe=i(),r(N.$$.fragment),Ve=i(),H=n("p"),H.innerHTML=Vt,ze=i(),r(S.$$.fragment),Ee=i(),Y=n("p"),Y.innerHTML=zt,Ne=i(),f=n("div"),f.innerHTML=Et,He=i(),F=n("p"),F.innerHTML=Nt,Se=i(),r($.$$.fragment),Ye=i(),L=n("p"),L.innerHTML=Ht,Fe=i(),r(q.$$.fragment),$e=i(),Q=n("p"),Q.innerHTML=St,Le=i(),r(A.$$.fragment),qe=i(),r(D.$$.fragment),Qe=i(),P=n("p"),P.innerHTML=Yt,Ae=i(),b=n("div"),b.innerHTML=Ft,De=i(),r(K.$$.fragment),Pe=i(),O=n("p"),O.innerHTML=$t,Ke=i(),r(ee.$$.fragment),Oe=i(),Z=n("div"),Z.innerHTML=Lt,et=i(),te=n("p"),te.textContent=qt,tt=i(),r(le.$$.fragment),lt=i(),se=n("p"),se.innerHTML=Qt,st=i(),r(ie.$$.fragment),it=i(),r(ae.$$.fragment),at=i(),ne=n("p"),ne.innerHTML=At,nt=i(),r(oe.$$.fragment),ot=i(),v=n("div"),v.innerHTML=Dt,pt=i(),pe=n("p"),pe.textContent=Pt,rt=i(),r(re.$$.fragment),dt=i(),de=n("p"),de.textContent=Kt,ct=i(),j=n("div"),j.innerHTML=Ot,mt=i(),ce=n("p"),ce.innerHTML=el,ht=i(),r(me.$$.fragment),ut=i(),he=n("p"),he.innerHTML=tl,gt=i(),U=n("div"),U.innerHTML=ll,Mt=i(),r(ue.$$.fragment),ft=i(),ge=n("p"),ge.textContent=sl,Jt=i(),r(Me.$$.fragment),yt=i(),B=n("div"),B.innerHTML=il,Tt=i(),fe=n("p"),fe.textContent=al,wt=i(),r(Je.$$.fragment),bt=i(),Te=n("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),we=a(e),ye=o(e,"P",{}),nl(ye).forEach(l),be=a(e),d(I.$$.fragment,e),Ze=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-rsgfrp"&&(W.innerHTML=Ut),ve=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-14zd5ma"&&(G.textContent=Bt),je=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-mg9rv6"&&(k.innerHTML=It),Ue=a(e),x=o(e,"TABLE",{"data-svelte-h":!0}),p(x)!=="svelte-1v9cy9r"&&(x.innerHTML=Wt),Be=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-7crc58"&&(R.innerHTML=Gt),Ie=a(e),C=o(e,"TABLE",{"data-svelte-h":!0}),p(C)!=="svelte-dqweec"&&(C.innerHTML=kt),We=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-14z37t0"&&(_.textContent=xt),Ge=a(e),M=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(M)!=="svelte-130z9iz"&&(M.innerHTML=Rt),ke=a(e),d(X.$$.fragment,e),xe=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1284uin"&&(V.innerHTML=Ct),Re=a(e),d(z.$$.fragment,e),Ce=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-vmtetj"&&(E.innerHTML=_t),_e=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-16yoeuw"&&(w.innerHTML=Xt),Xe=a(e),d(N.$$.fragment,e),Ve=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-17bf1l7"&&(H.innerHTML=Vt),ze=a(e),d(S.$$.fragment,e),Ee=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1cxkzwq"&&(Y.innerHTML=zt),Ne=a(e),f=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(f)!=="svelte-15wm70y"&&(f.innerHTML=Et),He=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-v6akpn"&&(F.innerHTML=Nt),Se=a(e),d($.$$.fragment,e),Ye=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-6d9zyk"&&(L.innerHTML=Ht),Fe=a(e),d(q.$$.fragment,e),$e=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-if0k9"&&(Q.innerHTML=St),Le=a(e),d(A.$$.fragment,e),qe=a(e),d(D.$$.fragment,e),Qe=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-kc22hk"&&(P.innerHTML=Yt),Ae=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-4jsfc1"&&(b.innerHTML=Ft),De=a(e),d(K.$$.fragment,e),Pe=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-4qrnje"&&(O.innerHTML=$t),Ke=a(e),d(ee.$$.fragment,e),Oe=a(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-etsikn"&&(Z.innerHTML=Lt),et=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1001b16"&&(te.textContent=qt),tt=a(e),d(le.$$.fragment,e),lt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-e52fx"&&(se.innerHTML=Qt),st=a(e),d(ie.$$.fragment,e),it=a(e),d(ae.$$.fragment,e),at=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-b3srj5"&&(ne.innerHTML=At),nt=a(e),d(oe.$$.fragment,e),ot=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-jsugc"&&(v.innerHTML=Dt),pt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-83stc5"&&(pe.textContent=Pt),rt=a(e),d(re.$$.fragment,e),dt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-nc59re"&&(de.textContent=Kt),ct=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-1k6s96j"&&(j.innerHTML=Ot),mt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1cegfq5"&&(ce.innerHTML=el),ht=a(e),d(me.$$.fragment,e),ut=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-tlyfc9"&&(he.innerHTML=tl),gt=a(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-u703tp"&&(U.innerHTML=ll),Mt=a(e),d(ue.$$.fragment,e),ft=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-12oh700"&&(ge.textContent=sl),Jt=a(e),d(Me.$$.fragment,e),yt=a(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-bddy4e"&&(B.innerHTML=il),Tt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-by2907"&&(fe.textContent=al),wt=a(e),d(Je.$$.fragment,e),bt=a(e),Te=o(e,"P",{}),nl(Te).forEach(l),this.h()},h(){g(y,"name","hf:doc:metadata"),g(y,"content",Ml),g(M,"class","flex gap-4"),vt(M,"justify-content","center"),vt(M,"width","100%"),g(w,"class","flex gap-4"),g(f,"class","flex gap-4"),vt(f,"justify-content","center"),vt(f,"width","100%"),g(b,"class","flex gap-4"),g(Z,"class","flex gap-4"),g(v,"class","flex gap-4"),g(j,"class","flex gap-4"),g(U,"class","flex gap-4"),g(B,"class","flex gap-4")},m(e,t){hl(document.head,y),s(e,we,t),s(e,ye,t),s(e,be,t),c(I,e,t),s(e,Ze,t),s(e,W,t),s(e,ve,t),s(e,G,t),s(e,je,t),s(e,k,t),s(e,Ue,t),s(e,x,t),s(e,Be,t),s(e,R,t),s(e,Ie,t),s(e,C,t),s(e,We,t),s(e,_,t),s(e,Ge,t),s(e,M,t),s(e,ke,t),c(X,e,t),s(e,xe,t),s(e,V,t),s(e,Re,t),c(z,e,t),s(e,Ce,t),s(e,E,t),s(e,_e,t),s(e,w,t),s(e,Xe,t),c(N,e,t),s(e,Ve,t),s(e,H,t),s(e,ze,t),c(S,e,t),s(e,Ee,t),s(e,Y,t),s(e,Ne,t),s(e,f,t),s(e,He,t),s(e,F,t),s(e,Se,t),c($,e,t),s(e,Ye,t),s(e,L,t),s(e,Fe,t),c(q,e,t),s(e,$e,t),s(e,Q,t),s(e,Le,t),c(A,e,t),s(e,qe,t),c(D,e,t),s(e,Qe,t),s(e,P,t),s(e,Ae,t),s(e,b,t),s(e,De,t),c(K,e,t),s(e,Pe,t),s(e,O,t),s(e,Ke,t),c(ee,e,t),s(e,Oe,t),s(e,Z,t),s(e,et,t),s(e,te,t),s(e,tt,t),c(le,e,t),s(e,lt,t),s(e,se,t),s(e,st,t),c(ie,e,t),s(e,it,t),c(ae,e,t),s(e,at,t),s(e,ne,t),s(e,nt,t),c(oe,e,t),s(e,ot,t),s(e,v,t),s(e,pt,t),s(e,pe,t),s(e,rt,t),c(re,e,t),s(e,dt,t),s(e,de,t),s(e,ct,t),s(e,j,t),s(e,mt,t),s(e,ce,t),s(e,ht,t),c(me,e,t),s(e,ut,t),s(e,he,t),s(e,gt,t),s(e,U,t),s(e,Mt,t),c(ue,e,t),s(e,ft,t),s(e,ge,t),s(e,Jt,t),c(Me,e,t),s(e,yt,t),s(e,B,t),s(e,Tt,t),s(e,fe,t),s(e,wt,t),c(Je,e,t),s(e,bt,t),s(e,Te,t),Zt=!0},p:pl,i(e){Zt||(m(I.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m($.$$.fragment,e),m(q.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),Zt=!0)},o(e){h(I.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(Je.$$.fragment,e),Zt=!1},d(e){e&&(l(we),l(ye),l(be),l(Ze),l(W),l(ve),l(G),l(je),l(k),l(Ue),l(x),l(Be),l(R),l(Ie),l(C),l(We),l(_),l(Ge),l(M),l(ke),l(xe),l(V),l(Re),l(Ce),l(E),l(_e),l(w),l(Xe),l(Ve),l(H),l(ze),l(Ee),l(Y),l(Ne),l(f),l(He),l(F),l(Se),l(Ye),l(L),l(Fe),l($e),l(Q),l(Le),l(qe),l(Qe),l(P),l(Ae),l(b),l(De),l(Pe),l(O),l(Ke),l(Oe),l(Z),l(et),l(te),l(tt),l(lt),l(se),l(st),l(it),l(at),l(ne),l(nt),l(ot),l(v),l(pt),l(pe),l(rt),l(dt),l(de),l(ct),l(j),l(mt),l(ce),l(ht),l(ut),l(he),l(gt),l(U),l(Mt),l(ft),l(ge),l(Jt),l(yt),l(B),l(Tt),l(fe),l(wt),l(bt),l(Te)),l(y),u(I,e),u(X,e),u(z,e),u(N,e),u(S,e),u($,e),u(q,e),u(A,e),u(D,e),u(K,e),u(ee,e),u(le,e),u(ie,e),u(ae,e),u(oe,e),u(re,e),u(me,e),u(ue,e),u(Me,e),u(Je,e)}}}const Ml='{"title":"Marigold Pipelines for Computer Vision Tasks","local":"marigold-pipelines-for-computer-vision-tasks","sections":[{"title":"Depth Prediction Quick Start","local":"depth-prediction-quick-start","sections":[],"depth":3},{"title":"Surface Normals Prediction Quick Start","local":"surface-normals-prediction-quick-start","sections":[],"depth":3},{"title":"Speeding up inference","local":"speeding-up-inference","sections":[],"depth":3},{"title":"Qualitative Comparison with Depth Anything","local":"qualitative-comparison-with-depth-anything","sections":[],"depth":2},{"title":"Maximizing Precision and Ensembling","local":"maximizing-precision-and-ensembling","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[],"depth":2},{"title":"Using Predictive Uncertainty","local":"using-predictive-uncertainty","sections":[],"depth":2},{"title":"Frame-by-frame Video Processing with Temporal Consistency","local":"frame-by-frame-video-processing-with-temporal-consistency","sections":[],"depth":2},{"title":"Marigold for ControlNet","local":"marigold-for-controlnet","sections":[],"depth":2}],"depth":1}';function fl(jt){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends dl{constructor(y){super(),cl(this,y,fl,gl,ol,{})}}export{bl as component};
