import{s as Wt,o as Gt,n as Ct}from"../chunks/scheduler.8c3d61f6.js";import{S as It,i as St,g as f,s,r as l,A as Rt,h as u,f as n,c as i,j as we,u as r,x as _,k as Te,y as W,a as o,v as p,d,t as c,w as m,m as Bt,n as zt}from"../chunks/index.589a98e8.js";import{T as kt}from"../chunks/Tip.42aa8582.js";import{D as ft}from"../chunks/Docstring.27406313.js";import{C as J}from"../chunks/CodeBlock.36627b28.js";import{E as Xt}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as w,E as Dt}from"../chunks/EditOnGithub.e5a8d9cb.js";function Vt($){let a,b="The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.";return{c(){a=f("p"),a.innerHTML=b},l(h){a=u(h,"P",{"data-svelte-h":!0}),_(a)!=="svelte-1abcova"&&(a.innerHTML=b)},m(h,y){o(h,a,y)},p:Ct,d(h){h&&n(a)}}}function Pt($){let a;return{c(){a=Bt("`from_single_file` support for the `fp8` version of the checkpoints is coming soon. Watch this space.")},l(b){a=zt(b,"`from_single_file` support for the `fp8` version of the checkpoints is coming soon. Watch this space.")},m(b,h){o(b,a,h)},d(b){b&&n(a)}}}function Nt($){let a,b="Examples:",h,y,M;return y=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){a=f("p"),a.textContent=b,h=s(),l(y.$$.fragment)},l(g){a=u(g,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=b),h=i(g),r(y.$$.fragment,g)},m(g,T){o(g,a,T),o(g,h,T),p(y,g,T),M=!0},p:Ct,i(g){M||(d(y.$$.fragment,g),M=!0)},o(g){c(y.$$.fragment,g),M=!1},d(g){g&&(n(a),n(h)),m(y,g)}}}function Qt($){let a,b,h,y,M,g,T,ut='Stable Diffusion 3 (SD3) was proposed in <a href="https://arxiv.org/pdf/2403.03206.pdf" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',Ue,G,gt="The abstract from the paper is:",ve,I,ht="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",Je,S,Ze,R,_t='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',je,B,bt="Use the command below to log in:",$e,z,xe,x,ke,X,Ce,D,We,V,yt="SD3 uses three text encoders, one if which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",Ge,P,Ie,N,Mt="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",Se,Q,Re,Y,Be,E,wt="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",ze,L,Xe,F,De,H,Tt="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",Ve,q,Ut="First install the <code>bitsandbytes</code> library.",Pe,A,Ne,O,vt="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",Qe,K,Ye,ee,Jt='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',Ee,te,Le,ne,Fe,oe,Zt="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",He,se,qe,ie,jt='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',Ae,ae,Oe,le,$t="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",Ke,re,et,pe,tt,de,nt,ce,ot,k,st,me,it,U,fe,pt,v,ue,dt,_e,xt="Function invoked when calling the pipeline for generation.",ct,C,mt,be,ge,at,he,lt,ye,rt;return M=new w({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),S=new w({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),z=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),x=new kt({props:{$$slots:{default:[Vt]},$$scope:{ctx:$}}}),X=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),D=new w({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),P=new w({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),Q=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),Y=new w({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),L=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),F=new w({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),A=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),K=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),te=new w({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),ne=new w({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),se=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMkMlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),ae=new w({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),re=new w({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),pe=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),de=new w({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),ce=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXRleHRfZW5jb2Rlcl8zJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bV9pbmNsX2NsaXBzLnNhZmV0ZW5zb3JzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdGV4dF9lbmNvZGVyXzMlM0R0ZXh0X2VuY29kZXJfMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

text_encoder_3 = T5EncoderModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusion3Pipeline.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>, torch_dtype=torch.float16, text_encoder_3=text_encoder_3)`,wrap:!1}}),k=new kt({props:{$$slots:{default:[Pt]},$$scope:{ctx:$}}}),me=new w({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),fe=new ft({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_8491/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8491/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_8491/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"}],source:"https://github.com/huggingface/diffusers/blob/vr_8491/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L128"}}),ue=new ft({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"prompt_3",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_8491/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new Xt({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[Nt]},$$scope:{ctx:$}}}),ge=new ft({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union"},{name:"prompt_3",val:": Union"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8491/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L310"}}),he=new Dt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){a=f("meta"),b=s(),h=f("p"),y=s(),l(M.$$.fragment),g=s(),T=f("p"),T.innerHTML=ut,Ue=s(),G=f("p"),G.textContent=gt,ve=s(),I=f("p"),I.innerHTML=ht,Je=s(),l(S.$$.fragment),Ze=s(),R=f("p"),R.innerHTML=_t,je=s(),B=f("p"),B.textContent=bt,$e=s(),l(z.$$.fragment),xe=s(),l(x.$$.fragment),ke=s(),l(X.$$.fragment),Ce=s(),l(D.$$.fragment),We=s(),V=f("p"),V.innerHTML=yt,Ge=s(),l(P.$$.fragment),Ie=s(),N=f("p"),N.textContent=Mt,Se=s(),l(Q.$$.fragment),Re=s(),l(Y.$$.fragment),Be=s(),E=f("p"),E.textContent=wt,ze=s(),l(L.$$.fragment),Xe=s(),l(F.$$.fragment),De=s(),H=f("p"),H.innerHTML=Tt,Ve=s(),q=f("p"),q.innerHTML=Ut,Pe=s(),l(A.$$.fragment),Ne=s(),O=f("p"),O.innerHTML=vt,Qe=s(),l(K.$$.fragment),Ye=s(),ee=f("p"),ee.innerHTML=Jt,Ee=s(),l(te.$$.fragment),Le=s(),l(ne.$$.fragment),Fe=s(),oe=f("p"),oe.textContent=Zt,He=s(),l(se.$$.fragment),qe=s(),ie=f("p"),ie.innerHTML=jt,Ae=s(),l(ae.$$.fragment),Oe=s(),le=f("p"),le.innerHTML=$t,Ke=s(),l(re.$$.fragment),et=s(),l(pe.$$.fragment),tt=s(),l(de.$$.fragment),nt=s(),l(ce.$$.fragment),ot=s(),l(k.$$.fragment),st=s(),l(me.$$.fragment),it=s(),U=f("div"),l(fe.$$.fragment),pt=s(),v=f("div"),l(ue.$$.fragment),dt=s(),_e=f("p"),_e.textContent=xt,ct=s(),l(C.$$.fragment),mt=s(),be=f("div"),l(ge.$$.fragment),at=s(),l(he.$$.fragment),lt=s(),ye=f("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);a=u(t,"META",{name:!0,content:!0}),t.forEach(n),b=i(e),h=u(e,"P",{}),we(h).forEach(n),y=i(e),r(M.$$.fragment,e),g=i(e),T=u(e,"P",{"data-svelte-h":!0}),_(T)!=="svelte-3c386r"&&(T.innerHTML=ut),Ue=i(e),G=u(e,"P",{"data-svelte-h":!0}),_(G)!=="svelte-1cwsb16"&&(G.textContent=gt),ve=i(e),I=u(e,"P",{"data-svelte-h":!0}),_(I)!=="svelte-vkvbjo"&&(I.innerHTML=ht),Je=i(e),r(S.$$.fragment,e),Ze=i(e),R=u(e,"P",{"data-svelte-h":!0}),_(R)!=="svelte-1llch01"&&(R.innerHTML=_t),je=i(e),B=u(e,"P",{"data-svelte-h":!0}),_(B)!=="svelte-n5exkg"&&(B.textContent=bt),$e=i(e),r(z.$$.fragment,e),xe=i(e),r(x.$$.fragment,e),ke=i(e),r(X.$$.fragment,e),Ce=i(e),r(D.$$.fragment,e),We=i(e),V=u(e,"P",{"data-svelte-h":!0}),_(V)!=="svelte-1ovwj93"&&(V.innerHTML=yt),Ge=i(e),r(P.$$.fragment,e),Ie=i(e),N=u(e,"P",{"data-svelte-h":!0}),_(N)!=="svelte-uyrglw"&&(N.textContent=Mt),Se=i(e),r(Q.$$.fragment,e),Re=i(e),r(Y.$$.fragment,e),Be=i(e),E=u(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-k4awn"&&(E.textContent=wt),ze=i(e),r(L.$$.fragment,e),Xe=i(e),r(F.$$.fragment,e),De=i(e),H=u(e,"P",{"data-svelte-h":!0}),_(H)!=="svelte-vcvc4f"&&(H.innerHTML=Tt),Ve=i(e),q=u(e,"P",{"data-svelte-h":!0}),_(q)!=="svelte-1t2mxsa"&&(q.innerHTML=Ut),Pe=i(e),r(A.$$.fragment,e),Ne=i(e),O=u(e,"P",{"data-svelte-h":!0}),_(O)!=="svelte-1pykif5"&&(O.innerHTML=vt),Qe=i(e),r(K.$$.fragment,e),Ye=i(e),ee=u(e,"P",{"data-svelte-h":!0}),_(ee)!=="svelte-bsz29z"&&(ee.innerHTML=Jt),Ee=i(e),r(te.$$.fragment,e),Le=i(e),r(ne.$$.fragment,e),Fe=i(e),oe=u(e,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-x56fi6"&&(oe.textContent=Zt),He=i(e),r(se.$$.fragment,e),qe=i(e),ie=u(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-d39h5a"&&(ie.innerHTML=jt),Ae=i(e),r(ae.$$.fragment,e),Oe=i(e),le=u(e,"P",{"data-svelte-h":!0}),_(le)!=="svelte-1pvw0yz"&&(le.innerHTML=$t),Ke=i(e),r(re.$$.fragment,e),et=i(e),r(pe.$$.fragment,e),tt=i(e),r(de.$$.fragment,e),nt=i(e),r(ce.$$.fragment,e),ot=i(e),r(k.$$.fragment,e),st=i(e),r(me.$$.fragment,e),it=i(e),U=u(e,"DIV",{class:!0});var Z=we(U);r(fe.$$.fragment,Z),pt=i(Z),v=u(Z,"DIV",{class:!0});var j=we(v);r(ue.$$.fragment,j),dt=i(j),_e=u(j,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-v78lg8"&&(_e.textContent=xt),ct=i(j),r(C.$$.fragment,j),j.forEach(n),mt=i(Z),be=u(Z,"DIV",{class:!0});var Me=we(be);r(ge.$$.fragment,Me),Me.forEach(n),Z.forEach(n),at=i(e),r(he.$$.fragment,e),lt=i(e),ye=u(e,"P",{}),we(ye).forEach(n),this.h()},h(){Te(a,"name","hf:doc:metadata"),Te(a,"content",Yt),Te(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Te(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Te(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){W(document.head,a),o(e,b,t),o(e,h,t),o(e,y,t),p(M,e,t),o(e,g,t),o(e,T,t),o(e,Ue,t),o(e,G,t),o(e,ve,t),o(e,I,t),o(e,Je,t),p(S,e,t),o(e,Ze,t),o(e,R,t),o(e,je,t),o(e,B,t),o(e,$e,t),p(z,e,t),o(e,xe,t),p(x,e,t),o(e,ke,t),p(X,e,t),o(e,Ce,t),p(D,e,t),o(e,We,t),o(e,V,t),o(e,Ge,t),p(P,e,t),o(e,Ie,t),o(e,N,t),o(e,Se,t),p(Q,e,t),o(e,Re,t),p(Y,e,t),o(e,Be,t),o(e,E,t),o(e,ze,t),p(L,e,t),o(e,Xe,t),p(F,e,t),o(e,De,t),o(e,H,t),o(e,Ve,t),o(e,q,t),o(e,Pe,t),p(A,e,t),o(e,Ne,t),o(e,O,t),o(e,Qe,t),p(K,e,t),o(e,Ye,t),o(e,ee,t),o(e,Ee,t),p(te,e,t),o(e,Le,t),p(ne,e,t),o(e,Fe,t),o(e,oe,t),o(e,He,t),p(se,e,t),o(e,qe,t),o(e,ie,t),o(e,Ae,t),p(ae,e,t),o(e,Oe,t),o(e,le,t),o(e,Ke,t),p(re,e,t),o(e,et,t),p(pe,e,t),o(e,tt,t),p(de,e,t),o(e,nt,t),p(ce,e,t),o(e,ot,t),p(k,e,t),o(e,st,t),p(me,e,t),o(e,it,t),o(e,U,t),p(fe,U,null),W(U,pt),W(U,v),p(ue,v,null),W(v,dt),W(v,_e),W(v,ct),p(C,v,null),W(U,mt),W(U,be),p(ge,be,null),o(e,at,t),p(he,e,t),o(e,lt,t),o(e,ye,t),rt=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),x.$set(Z);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),k.$set(j);const Me={};t&2&&(Me.$$scope={dirty:t,ctx:e}),C.$set(Me)},i(e){rt||(d(M.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(k.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(ue.$$.fragment,e),d(C.$$.fragment,e),d(ge.$$.fragment,e),d(he.$$.fragment,e),rt=!0)},o(e){c(M.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(k.$$.fragment,e),c(me.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(C.$$.fragment,e),c(ge.$$.fragment,e),c(he.$$.fragment,e),rt=!1},d(e){e&&(n(b),n(h),n(y),n(g),n(T),n(Ue),n(G),n(ve),n(I),n(Je),n(Ze),n(R),n(je),n(B),n($e),n(xe),n(ke),n(Ce),n(We),n(V),n(Ge),n(Ie),n(N),n(Se),n(Re),n(Be),n(E),n(ze),n(Xe),n(De),n(H),n(Ve),n(q),n(Pe),n(Ne),n(O),n(Qe),n(Ye),n(ee),n(Ee),n(Le),n(Fe),n(oe),n(He),n(qe),n(ie),n(Ae),n(Oe),n(le),n(Ke),n(et),n(tt),n(nt),n(ot),n(st),n(it),n(U),n(at),n(lt),n(ye)),n(a),m(M,e),m(S,e),m(z,e),m(x,e),m(X,e),m(D,e),m(P,e),m(Q,e),m(Y,e),m(L,e),m(F,e),m(A,e),m(K,e),m(te,e),m(ne,e),m(se,e),m(ae,e),m(re,e),m(pe,e),m(de,e),m(ce,e),m(k,e),m(me,e),m(fe),m(ue),m(C),m(ge),m(he,e)}}}const Yt='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function Et($){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends It{constructor(a){super(),St(this,a,Et,Qt,Wt,{})}}export{en as component};
