import{s as Zl,n as Dl,o as Wl}from"../chunks/scheduler.0219f8bd.js";import{S as Vl,i as Fl,g as d,s as i,r as n,A as Ql,h as o,f as a,c as m,j as g,u,x as s,k as r,y as Xl,a as l,v as c,d as f,t as p,w}from"../chunks/index.f61edf3b.js";import{C as ei}from"../chunks/CodeBlock.38e566ae.js";import{H as h,E as ti}from"../chunks/EditOnGithub.48fa589f.js";function ai(al){let R,Ze,Oe,De,I,We,$,Ve,v,ll="Helper module for image processing.",Fe,T,il=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Qe,_,ml='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',Xe,et,tt,b,at,C,lt,x,dl='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',it,H,ol='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',mt,dt,ot,L,st,M,rt,P,sl="Create a new <code>RawImage</code> object.",nt,y,rl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",gt,ut,ct,E,ft,A,pt,z,nl="Returns the size of the image (width, height).",wt,j,gl='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',ht,Rt,It,U,$t,B,vt,k,ul="Convert the image to grayscale format.",Tt,K,cl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',_t,bt,Ct,Y,xt,q,Ht,J,fl="Convert the image to RGB format.",Lt,N,pl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Mt,Pt,yt,G,Et,O,At,S,wl="Convert the image to RGBA format.",zt,Z,hl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',jt,Ut,Bt,D,kt,W,Kt,V,Rl="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",Yt,F,Il='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',qt,Q,$l="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",Jt,Nt,Gt,X,Ot,ee,St,te,vl="Clone the image",Zt,ae,Tl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',Dt,Wt,Vt,le,Ft,ie,Qt,me,_l="Helper method for converting image to have a certain number of channels",Xt,de,bl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',ea,oe,Cl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",ta,aa,la,se,ia,re,ma,ne,xl="Save the image to the given path.",da,ge,Hl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',oa,ue,Ll="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",sa,ra,na,ce,ga,fe,ua,pe,Ml="Helper method for reading an image from a variety of input types.",ca,we,Pl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',fa,he,yl="<strong>Example:</strong> Read image from a URL.",pa,Re,wa,Ie,El="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",ha,Ra,Ia,$e,$a,ve,va,Te,Al="Read an image from a canvas.",Ta,_e,zl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The image object.',_a,be,jl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>canvas</td><td><code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td><td><p>The canvas to read the image from.</p></td></tr></tbody>",ba,Ca,xa,Ce,Ha,xe,La,He,Ul="Read an image from a URL or file path.",Ma,Le,Bl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Pa,Me,kl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",ya,Ea,Aa,Pe,za,ye,ja,Ee,Kl="Helper method to create a new Image from a blob.",Ua,Ae,Yl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Ba,ze,ql="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",ka,Ka,Ya,je,qa,Ue,Ja,Be,Jl="Helper method to create a new Image from a tensor",Na,ke,Nl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Ga,Ke,Gl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td></tr></tbody>",Oa,Sa,Za,Ye,Da,qe,Wa,Je,Ol="Mapping from file extensions to MIME types.",Va,Ne,Sl='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',Fa,Qa,Xa,Ge,el,Se,tl;return $=new h({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new h({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),M=new h({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),A=new h({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),B=new h({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),q=new h({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),O=new h({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),W=new h({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),ee=new h({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),ie=new h({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),re=new h({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),fe=new h({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),Re=new ei({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),ve=new h({props:{title:"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>",local:"rawimagefromcanvascanvas--code-rawimage-code",headingTag:"h3"}}),xe=new h({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),ye=new h({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),Ue=new h({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),qe=new h({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),Ge=new ti({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/image.md"}}),{c(){R=d("meta"),Ze=i(),Oe=d("p"),De=i(),I=d("a"),We=i(),n($.$$.fragment),Ve=i(),v=d("p"),v.textContent=ll,Fe=i(),T=d("p"),T.textContent=il,Qe=i(),_=d("ul"),_.innerHTML=ml,Xe=i(),et=d("hr"),tt=i(),b=d("a"),at=i(),n(C.$$.fragment),lt=i(),x=d("p"),x.innerHTML=dl,it=i(),H=d("ul"),H.innerHTML=ol,mt=i(),dt=d("hr"),ot=i(),L=d("a"),st=i(),n(M.$$.fragment),rt=i(),P=d("p"),P.innerHTML=sl,nt=i(),y=d("table"),y.innerHTML=rl,gt=i(),ut=d("hr"),ct=i(),E=d("a"),ft=i(),n(A.$$.fragment),pt=i(),z=d("p"),z.textContent=nl,wt=i(),j=d("p"),j.innerHTML=gl,ht=i(),Rt=d("hr"),It=i(),U=d("a"),$t=i(),n(B.$$.fragment),vt=i(),k=d("p"),k.textContent=ul,Tt=i(),K=d("p"),K.innerHTML=cl,_t=i(),bt=d("hr"),Ct=i(),Y=d("a"),xt=i(),n(q.$$.fragment),Ht=i(),J=d("p"),J.textContent=fl,Lt=i(),N=d("p"),N.innerHTML=pl,Mt=i(),Pt=d("hr"),yt=i(),G=d("a"),Et=i(),n(O.$$.fragment),At=i(),S=d("p"),S.textContent=wl,zt=i(),Z=d("p"),Z.innerHTML=hl,jt=i(),Ut=d("hr"),Bt=i(),D=d("a"),kt=i(),n(W.$$.fragment),Kt=i(),V=d("p"),V.textContent=Rl,Yt=i(),F=d("p"),F.innerHTML=Il,qt=i(),Q=d("table"),Q.innerHTML=$l,Jt=i(),Nt=d("hr"),Gt=i(),X=d("a"),Ot=i(),n(ee.$$.fragment),St=i(),te=d("p"),te.textContent=vl,Zt=i(),ae=d("p"),ae.innerHTML=Tl,Dt=i(),Wt=d("hr"),Vt=i(),le=d("a"),Ft=i(),n(ie.$$.fragment),Qt=i(),me=d("p"),me.textContent=_l,Xt=i(),de=d("p"),de.innerHTML=bl,ea=i(),oe=d("table"),oe.innerHTML=Cl,ta=i(),aa=d("hr"),la=i(),se=d("a"),ia=i(),n(re.$$.fragment),ma=i(),ne=d("p"),ne.textContent=xl,da=i(),ge=d("p"),ge.innerHTML=Hl,oa=i(),ue=d("table"),ue.innerHTML=Ll,sa=i(),ra=d("hr"),na=i(),ce=d("a"),ga=i(),n(fe.$$.fragment),ua=i(),pe=d("p"),pe.textContent=Ml,ca=i(),we=d("p"),we.innerHTML=Pl,fa=i(),he=d("p"),he.innerHTML=yl,pa=i(),n(Re.$$.fragment),wa=i(),Ie=d("table"),Ie.innerHTML=El,ha=i(),Ra=d("hr"),Ia=i(),$e=d("a"),$a=i(),n(ve.$$.fragment),va=i(),Te=d("p"),Te.textContent=Al,Ta=i(),_e=d("p"),_e.innerHTML=zl,_a=i(),be=d("table"),be.innerHTML=jl,ba=i(),Ca=d("hr"),xa=i(),Ce=d("a"),Ha=i(),n(xe.$$.fragment),La=i(),He=d("p"),He.textContent=Ul,Ma=i(),Le=d("p"),Le.innerHTML=Bl,Pa=i(),Me=d("table"),Me.innerHTML=kl,ya=i(),Ea=d("hr"),Aa=i(),Pe=d("a"),za=i(),n(ye.$$.fragment),ja=i(),Ee=d("p"),Ee.textContent=Kl,Ua=i(),Ae=d("p"),Ae.innerHTML=Yl,Ba=i(),ze=d("table"),ze.innerHTML=ql,ka=i(),Ka=d("hr"),Ya=i(),je=d("a"),qa=i(),n(Ue.$$.fragment),Ja=i(),Be=d("p"),Be.textContent=Jl,Na=i(),ke=d("p"),ke.innerHTML=Nl,Ga=i(),Ke=d("table"),Ke.innerHTML=Gl,Oa=i(),Sa=d("hr"),Za=i(),Ye=d("a"),Da=i(),n(qe.$$.fragment),Wa=i(),Je=d("p"),Je.textContent=Ol,Va=i(),Ne=d("p"),Ne.innerHTML=Sl,Fa=i(),Qa=d("hr"),Xa=i(),n(Ge.$$.fragment),el=i(),Se=d("p"),this.h()},l(e){const t=Ql("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),Ze=m(e),Oe=o(e,"P",{}),g(Oe).forEach(a),De=m(e),I=o(e,"A",{id:!0,class:!0}),g(I).forEach(a),We=m(e),u($.$$.fragment,e),Ve=m(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-18hbqrt"&&(v.textContent=ll),Fe=m(e),T=o(e,"P",{"data-svelte-h":!0}),s(T)!=="svelte-il3kl8"&&(T.textContent=il),Qe=m(e),_=o(e,"UL",{"data-svelte-h":!0}),s(_)!=="svelte-1nqiqc3"&&(_.innerHTML=ml),Xe=m(e),et=o(e,"HR",{}),tt=m(e),b=o(e,"A",{id:!0,class:!0}),g(b).forEach(a),at=m(e),u(C.$$.fragment,e),lt=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=dl),it=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-vco0ok"&&(H.innerHTML=ol),mt=m(e),dt=o(e,"HR",{}),ot=m(e),L=o(e,"A",{id:!0,class:!0}),g(L).forEach(a),st=m(e),u(M.$$.fragment,e),rt=m(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-36fe9a"&&(P.innerHTML=sl),nt=m(e),y=o(e,"TABLE",{"data-svelte-h":!0}),s(y)!=="svelte-vkeoul"&&(y.innerHTML=rl),gt=m(e),ut=o(e,"HR",{}),ct=m(e),E=o(e,"A",{id:!0,class:!0}),g(E).forEach(a),ft=m(e),u(A.$$.fragment,e),pt=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=nl),wt=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-gwg1mu"&&(j.innerHTML=gl),ht=m(e),Rt=o(e,"HR",{}),It=m(e),U=o(e,"A",{id:!0,class:!0}),g(U).forEach(a),$t=m(e),u(B.$$.fragment,e),vt=m(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1owjjfe"&&(k.textContent=ul),Tt=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-11e9r18"&&(K.innerHTML=cl),_t=m(e),bt=o(e,"HR",{}),Ct=m(e),Y=o(e,"A",{id:!0,class:!0}),g(Y).forEach(a),xt=m(e),u(q.$$.fragment,e),Ht=m(e),J=o(e,"P",{"data-svelte-h":!0}),s(J)!=="svelte-qyo04e"&&(J.textContent=fl),Lt=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-11e9r18"&&(N.innerHTML=pl),Mt=m(e),Pt=o(e,"HR",{}),yt=m(e),G=o(e,"A",{id:!0,class:!0}),g(G).forEach(a),Et=m(e),u(O.$$.fragment,e),At=m(e),S=o(e,"P",{"data-svelte-h":!0}),s(S)!=="svelte-19kp14j"&&(S.textContent=wl),zt=m(e),Z=o(e,"P",{"data-svelte-h":!0}),s(Z)!=="svelte-11e9r18"&&(Z.innerHTML=hl),jt=m(e),Ut=o(e,"HR",{}),Bt=m(e),D=o(e,"A",{id:!0,class:!0}),g(D).forEach(a),kt=m(e),u(W.$$.fragment,e),Kt=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-s4dm9o"&&(V.textContent=Rl),Yt=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1jh8cjr"&&(F.innerHTML=Il),qt=m(e),Q=o(e,"TABLE",{"data-svelte-h":!0}),s(Q)!=="svelte-ya0vko"&&(Q.innerHTML=$l),Jt=m(e),Nt=o(e,"HR",{}),Gt=m(e),X=o(e,"A",{id:!0,class:!0}),g(X).forEach(a),Ot=m(e),u(ee.$$.fragment,e),St=m(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1eu6jk3"&&(te.textContent=vl),Zt=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1w4hta5"&&(ae.innerHTML=Tl),Dt=m(e),Wt=o(e,"HR",{}),Vt=m(e),le=o(e,"A",{id:!0,class:!0}),g(le).forEach(a),Ft=m(e),u(ie.$$.fragment,e),Qt=m(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-5ze294"&&(me.textContent=_l),Xt=m(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-11e9r18"&&(de.innerHTML=bl),ea=m(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-1hxqxaq"&&(oe.innerHTML=Cl),ta=m(e),aa=o(e,"HR",{}),la=m(e),se=o(e,"A",{id:!0,class:!0}),g(se).forEach(a),ia=m(e),u(re.$$.fragment,e),ma=m(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-119su55"&&(ne.textContent=xl),da=m(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-1epyezb"&&(ge.innerHTML=Hl),oa=m(e),ue=o(e,"TABLE",{"data-svelte-h":!0}),s(ue)!=="svelte-1h4z9xq"&&(ue.innerHTML=Ll),sa=m(e),ra=o(e,"HR",{}),na=m(e),ce=o(e,"A",{id:!0,class:!0}),g(ce).forEach(a),ga=m(e),u(fe.$$.fragment,e),ua=m(e),pe=o(e,"P",{"data-svelte-h":!0}),s(pe)!=="svelte-5659h9"&&(pe.textContent=Ml),ca=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-1800vfp"&&(we.innerHTML=Pl),fa=m(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-14z54gq"&&(he.innerHTML=yl),pa=m(e),u(Re.$$.fragment,e),wa=m(e),Ie=o(e,"TABLE",{"data-svelte-h":!0}),s(Ie)!=="svelte-eqolu5"&&(Ie.innerHTML=El),ha=m(e),Ra=o(e,"HR",{}),Ia=m(e),$e=o(e,"A",{id:!0,class:!0}),g($e).forEach(a),$a=m(e),u(ve.$$.fragment,e),va=m(e),Te=o(e,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-mjjjch"&&(Te.textContent=Al),Ta=m(e),_e=o(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-hagi3s"&&(_e.innerHTML=zl),_a=m(e),be=o(e,"TABLE",{"data-svelte-h":!0}),s(be)!=="svelte-hzvu44"&&(be.innerHTML=jl),ba=m(e),Ca=o(e,"HR",{}),xa=m(e),Ce=o(e,"A",{id:!0,class:!0}),g(Ce).forEach(a),Ha=m(e),u(xe.$$.fragment,e),La=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1355z3u"&&(He.textContent=Ul),Ma=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-10btw3j"&&(Le.innerHTML=Bl),Pa=m(e),Me=o(e,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-ncveta"&&(Me.innerHTML=kl),ya=m(e),Ea=o(e,"HR",{}),Aa=m(e),Pe=o(e,"A",{id:!0,class:!0}),g(Pe).forEach(a),za=m(e),u(ye.$$.fragment,e),ja=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1s704mu"&&(Ee.textContent=Kl),Ua=m(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-10btw3j"&&(Ae.innerHTML=Yl),Ba=m(e),ze=o(e,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-34rbhe"&&(ze.innerHTML=ql),ka=m(e),Ka=o(e,"HR",{}),Ya=m(e),je=o(e,"A",{id:!0,class:!0}),g(je).forEach(a),qa=m(e),u(Ue.$$.fragment,e),Ja=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-nwy2y"&&(Be.textContent=Jl),Na=m(e),ke=o(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-sl3vqa"&&(ke.innerHTML=Nl),Ga=m(e),Ke=o(e,"TABLE",{"data-svelte-h":!0}),s(Ke)!=="svelte-10oxyio"&&(Ke.innerHTML=Gl),Oa=m(e),Sa=o(e,"HR",{}),Za=m(e),Ye=o(e,"A",{id:!0,class:!0}),g(Ye).forEach(a),Da=m(e),u(qe.$$.fragment,e),Wa=m(e),Je=o(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-15u13r6"&&(Je.textContent=Ol),Va=m(e),Ne=o(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-1cwm6ga"&&(Ne.innerHTML=Sl),Fa=m(e),Qa=o(e,"HR",{}),Xa=m(e),u(Ge.$$.fragment,e),el=m(e),Se=o(e,"P",{}),g(Se).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",li),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(E,"id","module_utils/image.RawImage+size"),r(E,"class","group"),r(U,"id","module_utils/image.RawImage+grayscale"),r(U,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(G,"id","module_utils/image.RawImage+rgba"),r(G,"class","group"),r(D,"id","module_utils/image.RawImage+resize"),r(D,"class","group"),r(X,"id","module_utils/image.RawImage+clone"),r(X,"class","group"),r(le,"id","module_utils/image.RawImage+convert"),r(le,"class","group"),r(se,"id","module_utils/image.RawImage+save"),r(se,"class","group"),r(ce,"id","module_utils/image.RawImage.read"),r(ce,"class","group"),r($e,"id","module_utils/image.RawImage.fromCanvas"),r($e,"class","group"),r(Ce,"id","module_utils/image.RawImage.fromURL"),r(Ce,"class","group"),r(Pe,"id","module_utils/image.RawImage.fromBlob"),r(Pe,"class","group"),r(je,"id","module_utils/image.RawImage.fromTensor"),r(je,"class","group"),r(Ye,"id","module_utils/image..CONTENT_TYPE_MAP"),r(Ye,"class","group")},m(e,t){Xl(document.head,R),l(e,Ze,t),l(e,Oe,t),l(e,De,t),l(e,I,t),l(e,We,t),c($,e,t),l(e,Ve,t),l(e,v,t),l(e,Fe,t),l(e,T,t),l(e,Qe,t),l(e,_,t),l(e,Xe,t),l(e,et,t),l(e,tt,t),l(e,b,t),l(e,at,t),c(C,e,t),l(e,lt,t),l(e,x,t),l(e,it,t),l(e,H,t),l(e,mt,t),l(e,dt,t),l(e,ot,t),l(e,L,t),l(e,st,t),c(M,e,t),l(e,rt,t),l(e,P,t),l(e,nt,t),l(e,y,t),l(e,gt,t),l(e,ut,t),l(e,ct,t),l(e,E,t),l(e,ft,t),c(A,e,t),l(e,pt,t),l(e,z,t),l(e,wt,t),l(e,j,t),l(e,ht,t),l(e,Rt,t),l(e,It,t),l(e,U,t),l(e,$t,t),c(B,e,t),l(e,vt,t),l(e,k,t),l(e,Tt,t),l(e,K,t),l(e,_t,t),l(e,bt,t),l(e,Ct,t),l(e,Y,t),l(e,xt,t),c(q,e,t),l(e,Ht,t),l(e,J,t),l(e,Lt,t),l(e,N,t),l(e,Mt,t),l(e,Pt,t),l(e,yt,t),l(e,G,t),l(e,Et,t),c(O,e,t),l(e,At,t),l(e,S,t),l(e,zt,t),l(e,Z,t),l(e,jt,t),l(e,Ut,t),l(e,Bt,t),l(e,D,t),l(e,kt,t),c(W,e,t),l(e,Kt,t),l(e,V,t),l(e,Yt,t),l(e,F,t),l(e,qt,t),l(e,Q,t),l(e,Jt,t),l(e,Nt,t),l(e,Gt,t),l(e,X,t),l(e,Ot,t),c(ee,e,t),l(e,St,t),l(e,te,t),l(e,Zt,t),l(e,ae,t),l(e,Dt,t),l(e,Wt,t),l(e,Vt,t),l(e,le,t),l(e,Ft,t),c(ie,e,t),l(e,Qt,t),l(e,me,t),l(e,Xt,t),l(e,de,t),l(e,ea,t),l(e,oe,t),l(e,ta,t),l(e,aa,t),l(e,la,t),l(e,se,t),l(e,ia,t),c(re,e,t),l(e,ma,t),l(e,ne,t),l(e,da,t),l(e,ge,t),l(e,oa,t),l(e,ue,t),l(e,sa,t),l(e,ra,t),l(e,na,t),l(e,ce,t),l(e,ga,t),c(fe,e,t),l(e,ua,t),l(e,pe,t),l(e,ca,t),l(e,we,t),l(e,fa,t),l(e,he,t),l(e,pa,t),c(Re,e,t),l(e,wa,t),l(e,Ie,t),l(e,ha,t),l(e,Ra,t),l(e,Ia,t),l(e,$e,t),l(e,$a,t),c(ve,e,t),l(e,va,t),l(e,Te,t),l(e,Ta,t),l(e,_e,t),l(e,_a,t),l(e,be,t),l(e,ba,t),l(e,Ca,t),l(e,xa,t),l(e,Ce,t),l(e,Ha,t),c(xe,e,t),l(e,La,t),l(e,He,t),l(e,Ma,t),l(e,Le,t),l(e,Pa,t),l(e,Me,t),l(e,ya,t),l(e,Ea,t),l(e,Aa,t),l(e,Pe,t),l(e,za,t),c(ye,e,t),l(e,ja,t),l(e,Ee,t),l(e,Ua,t),l(e,Ae,t),l(e,Ba,t),l(e,ze,t),l(e,ka,t),l(e,Ka,t),l(e,Ya,t),l(e,je,t),l(e,qa,t),c(Ue,e,t),l(e,Ja,t),l(e,Be,t),l(e,Na,t),l(e,ke,t),l(e,Ga,t),l(e,Ke,t),l(e,Oa,t),l(e,Sa,t),l(e,Za,t),l(e,Ye,t),l(e,Da,t),c(qe,e,t),l(e,Wa,t),l(e,Je,t),l(e,Va,t),l(e,Ne,t),l(e,Fa,t),l(e,Qa,t),l(e,Xa,t),c(Ge,e,t),l(e,el,t),l(e,Se,t),tl=!0},p:Dl,i(e){tl||(f($.$$.fragment,e),f(C.$$.fragment,e),f(M.$$.fragment,e),f(A.$$.fragment,e),f(B.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(W.$$.fragment,e),f(ee.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(fe.$$.fragment,e),f(Re.$$.fragment,e),f(ve.$$.fragment,e),f(xe.$$.fragment,e),f(ye.$$.fragment,e),f(Ue.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),tl=!0)},o(e){p($.$$.fragment,e),p(C.$$.fragment,e),p(M.$$.fragment,e),p(A.$$.fragment,e),p(B.$$.fragment,e),p(q.$$.fragment,e),p(O.$$.fragment,e),p(W.$$.fragment,e),p(ee.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(fe.$$.fragment,e),p(Re.$$.fragment,e),p(ve.$$.fragment,e),p(xe.$$.fragment,e),p(ye.$$.fragment,e),p(Ue.$$.fragment,e),p(qe.$$.fragment,e),p(Ge.$$.fragment,e),tl=!1},d(e){e&&(a(Ze),a(Oe),a(De),a(I),a(We),a(Ve),a(v),a(Fe),a(T),a(Qe),a(_),a(Xe),a(et),a(tt),a(b),a(at),a(lt),a(x),a(it),a(H),a(mt),a(dt),a(ot),a(L),a(st),a(rt),a(P),a(nt),a(y),a(gt),a(ut),a(ct),a(E),a(ft),a(pt),a(z),a(wt),a(j),a(ht),a(Rt),a(It),a(U),a($t),a(vt),a(k),a(Tt),a(K),a(_t),a(bt),a(Ct),a(Y),a(xt),a(Ht),a(J),a(Lt),a(N),a(Mt),a(Pt),a(yt),a(G),a(Et),a(At),a(S),a(zt),a(Z),a(jt),a(Ut),a(Bt),a(D),a(kt),a(Kt),a(V),a(Yt),a(F),a(qt),a(Q),a(Jt),a(Nt),a(Gt),a(X),a(Ot),a(St),a(te),a(Zt),a(ae),a(Dt),a(Wt),a(Vt),a(le),a(Ft),a(Qt),a(me),a(Xt),a(de),a(ea),a(oe),a(ta),a(aa),a(la),a(se),a(ia),a(ma),a(ne),a(da),a(ge),a(oa),a(ue),a(sa),a(ra),a(na),a(ce),a(ga),a(ua),a(pe),a(ca),a(we),a(fa),a(he),a(pa),a(wa),a(Ie),a(ha),a(Ra),a(Ia),a($e),a($a),a(va),a(Te),a(Ta),a(_e),a(_a),a(be),a(ba),a(Ca),a(xa),a(Ce),a(Ha),a(La),a(He),a(Ma),a(Le),a(Pa),a(Me),a(ya),a(Ea),a(Aa),a(Pe),a(za),a(ja),a(Ee),a(Ua),a(Ae),a(Ba),a(ze),a(ka),a(Ka),a(Ya),a(je),a(qa),a(Ja),a(Be),a(Na),a(ke),a(Ga),a(Ke),a(Oa),a(Sa),a(Za),a(Ye),a(Da),a(Wa),a(Je),a(Va),a(Ne),a(Fa),a(Qa),a(Xa),a(el),a(Se)),a(R),w($,e),w(C,e),w(M,e),w(A,e),w(B,e),w(q,e),w(O,e),w(W,e),w(ee,e),w(ie,e),w(re,e),w(fe,e),w(Re,e),w(ve,e),w(xe,e),w(ye,e),w(Ue,e),w(qe,e),w(Ge,e)}}}const li='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>","local":"rawimagefromcanvascanvas--code-rawimage-code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function ii(al){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ri extends Vl{constructor(R){super(),Fl(this,R,ii,ai,Zl,{})}}export{ri as component};
