import{s as Ja,o as Ua,n as ze}from"../chunks/scheduler.f6b352c8.js";import{S as ja,i as da,g as p,s as n,r as c,A as fa,h as o,f as l,c as a,j as ma,u as r,x as i,k as wa,y as ba,a as e,v as M,d as u,t as h,w as y}from"../chunks/index.7f38e934.js";import{T as Re}from"../chunks/Tip.ae532637.js";import{C as w}from"../chunks/CodeBlock.3ee8293b.js";import{H as J,E as Ca}from"../chunks/index.2061098d.js";function va(b){let T,U='This section is based on the <a href="https://huggingface.co/blog/tiny-agents" rel="nofollow">Tiny Agents blog post</a> and adapted for the MCP course.';return{c(){T=p("p"),T.innerHTML=U},l(m){T=o(m,"P",{"data-svelte-h":!0}),i(T)!=="svelte-m8w4ve"&&(T.innerHTML=U)},m(m,j){e(m,T,j)},p:ze,d(m){m&&l(T)}}}function ga(b){let T,U='The complete <code>McpClient.ts</code> code file is <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/mcp-client/src/McpClient.ts" rel="nofollow">here</a> if you want to follow along using the actual code 🤓';return{c(){T=p("p"),T.innerHTML=U},l(m){T=o(m,"P",{"data-svelte-h":!0}),i(T)!=="svelte-1dheya"&&(T.innerHTML=U)},m(m,j){e(m,T,j)},p:ze,d(m){m&&l(T)}}}function Ia(b){let T,U='The complete <code>Agent.ts</code> code file is <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/mcp-client/src/Agent.ts" rel="nofollow">here</a>.';return{c(){T=p("p"),T.innerHTML=U},l(m){T=o(m,"P",{"data-svelte-h":!0}),i(T)!=="svelte-9c5nqs"&&(T.innerHTML=U)},m(m,j){e(m,T,j)},p:ze,d(m){m&&l(T)}}}function Ba(b){let T,U,m,j,I,Et,B,_e='Now that we’ve built MCP servers in Gradio and learned about creating MCP clients, let’s complete our end-to-end application by building a TypeScript agent that can seamlessly interact with our sentiment analysis tool. This section builds on the project <a href="https://huggingface.co/blog/tiny-agents" rel="nofollow">Tiny Agents</a>, which demonstrates a super simple way of deploying MCP clients that can connect to services like our Gradio sentiment analysis server.',St,k,Xe="In this final exercise of Unit 2, we will walk you through how to implement a TypeScript (JS) MCP client that can communicate with any MCP server, including the Gradio-based sentiment analysis server we built in the previous sections. This completes our end-to-end MCP application flow: from building a Gradio MCP server exposing a sentiment analysis tool, to creating a flexible agent that can use this tool alongside other capabilities.",xt,$,Le='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/thumbnail.jpg" alt="meme"/>',Nt,Q,Ye="Image credit https://x.com/adamdotdev",Gt,E,Zt,S,De="First, we need to install the <code>tiny-agents</code> package.",At,x,Wt,N,qe="Then, we need to install the <code>mcp-remote</code> package.",Ht,G,Vt,Z,Rt,A,Oe="Tiny Agents can create MCP clients from the command line based on JSON configuration files.",zt,W,Pe="Let’s setup a project with a basic Tiny Agent.",_t,H,Xt,V,Fe="The JSON file will look like this:",Lt,R,Yt,z,Ke="Here we have a basic Tiny Agent that can connect to our Gradio MCP server. It includes a model, provider, and a server configuration.",Dt,_,sn="<thead><tr><th>Field</th> <th>Description</th></tr></thead> <tbody><tr><td><code>model</code></td> <td>The open source model to use for the agent</td></tr> <tr><td><code>provider</code></td> <td>The inference provider to use for the agent</td></tr> <tr><td><code>servers</code></td> <td>The servers to use for the agent. We’ll use the <code>mcp-remote</code> server for our Gradio MCP server.</td></tr></tbody>",qt,X,tn="We could also use an open source model running locally with Tiny Agents.",Ot,L,Pt,Y,ln="Here we have a Tiny Agent that can connect to a local model. It includes a model, endpoint URL (<code>http://localhost:1234/v1</code>), and a server configuration. The endpoint should be an OpenAI-compatible endpoint.",Ft,D,en="We can then run the agent with the following command:",Kt,q,sl,O,tl,P,nn="Now that we understand both Tiny Agents and Gradio MCP servers, let’s see how they work together! The beauty of MCP is that it provides a standardized way for agents to interact with any MCP-compatible server, including our Gradio-based sentiment analysis server from earlier sections.",ll,F,el,K,an="To connect our Tiny Agent to the Gradio sentiment analysis server we built earlier in this unit, we just need to add it to our list of servers. Here’s how we can modify our agent configuration:",nl,ss,al,ts,pn="Now our agent can use the sentiment analysis tool alongside other tools! For example, it could:",pl,ls,on="<li>Read text from a file using the filesystem server</li> <li>Analyze its sentiment using our Gradio server</li> <li>Write the results back to a file</li>",ol,es,il,ns,cn="Here’s what a conversation with our agent might look like:",cl,as,rl,ps,Ml,os,rn="When deploying your Gradio MCP server to Hugging Face Spaces, you’ll need to update the server URL in your agent configuration to point to your deployed space:",ul,is,hl,cs,Mn="This allows your agent to use the sentiment analysis tool from anywhere, not just locally!",yl,rs,Tl,Ms,un="In this unit, we’ve gone from understanding MCP basics to building a complete end-to-end application:",ml,us,hn="<li>We created a Gradio MCP server that exposes a sentiment analysis tool</li> <li>We learned how to connect to this server using MCP clients</li> <li>We built a tiny agent in TypeScript that can interact with our tool</li>",wl,hs,yn="This demonstrates the power of the Model Context Protocol - we can create specialized tools using frameworks we’re familiar with (like Gradio), expose them through a standardized interface (MCP), and then have agents seamlessly use these tools alongside other capabilities.",Jl,ys,Tn="The complete flow we’ve built allows an agent to:",Ul,Ts,mn="<li>Connect to multiple tool providers</li> <li>Dynamically discover available tools</li> <li>Use our custom sentiment analysis tool</li> <li>Combine it with other capabilities like file system access and web browsing</li>",jl,ms,wn="This modular approach is what makes MCP so powerful for building flexible AI applications.",dl,ws,fl,Js,Jn="As a bonus, let’s explore how to use the Playwright MCP server for browser automation with Tiny Agents. This demonstrates the extensibility of the MCP ecosystem beyond our sentiment analysis example.",bl,C,Cl,Us,Un="In this section, we’ll show you how to build an agent that can perform web automation tasks like searching, clicking, and extracting information from websites.",vl,js,gl,ds,jn="The Playwright MCP server exposes tools that allow your agent to:",Il,fs,dn="<li>Open browser tabs</li> <li>Navigate to URLs</li> <li>Click on elements</li> <li>Type into forms</li> <li>Extract content from webpages</li> <li>Take screenshots</li>",Bl,bs,fn="Here’s an example interaction with our browser automation agent:",kl,Cs,$l,vs,bn="This browser automation capability can be combined with other MCP servers to create powerful workflows—for example, extracting text from a webpage and then analyzing it with custom tools.",Ql,gs,El,Is,Cn="If you have NodeJS (with <code>pnpm</code> or <code>npm</code>), just run this in a terminal:",Sl,Bs,xl,ks,vn="or if using <code>pnpm</code>:",Nl,$s,Gl,Qs,gn="This installs the package into a temporary folder then executes its command.",Zl,Es,In="You’ll see your simple Agent connect to multiple MCP servers (running locally), loading their tools (similar to how it would load your Gradio sentiment analysis tool), then prompting you for a conversation.",Al,d,Bn='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/use-filesystem.mp4" type="video/mp4"/>',Wl,Ss,kn="By default our example Agent connects to the following two MCP servers:",Hl,xs,$n='<li>the “canonical” <a href="https://github.com/modelcontextprotocol/servers/tree/main/src/filesystem" rel="nofollow">file system server</a>, which gets access to your Desktop,</li> <li>and the <a href="https://github.com/microsoft/playwright-mcp" rel="nofollow">Playwright MCP</a> server, which knows how to use a sandboxed Chromium browser for you.</li>',Vl,Ns,Qn=`<p>[!NOTE]
Note: this is a bit counter-intuitive but currently, all MCP servers in tiny agents are actually local processes (though remote servers are coming soon).</p>`,Rl,Gs,En="Our input for this first video was:",zl,Zs,Sn="<p>write a haiku about the Hugging Face community and write it to a file named “hf.txt” on my Desktop</p>",_l,As,xn="Now let us try this prompt that involves some Web browsing:",Xl,Ws,Nn="<p>do a Web Search for HF inference providers on Brave Search and open the first 3 results</p>",Ll,f,Gn='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/brave-search.mp4" type="video/mp4"/>',Yl,Hs,Dl,Vs,Zn="In terms of model/provider pair, our example Agent uses by default:",ql,Rs,An='<li><a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">“Qwen/Qwen2.5-72B-Instruct”</a></li> <li>running on <a href="https://huggingface.co/docs/inference-providers/providers/nebius" rel="nofollow">Nebius</a></li>',Ol,zs,Wn="This is all configurable through env variables:",Pl,_s,Fl,Xs,Kl,Ls,Hn="Now that we know what a tool is in recent LLMs, let’s implement the actual MCP client that will communicate with MCP servers and other MCP servers.",se,Ys,Vn='The official doc at <a href="https://modelcontextprotocol.io/quickstart/client" rel="nofollow">https://modelcontextprotocol.io/quickstart/client</a> is fairly well-written. You only have to replace any mention of the Anthropic client SDK by any other OpenAI-compatible client SDK. (There is also a <a href="https://modelcontextprotocol.io/llms-full.txt" rel="nofollow">llms.txt</a> you can feed into your LLM of choice to help you code along).',te,Ds,Rn="As a reminder, we use HF’s <code>InferenceClient</code> for our inference client.",le,v,ee,qs,zn="Our <code>McpClient</code> class has:",ne,Os,_n="<li>an Inference Client (works with any Inference Provider, and <code>huggingface/inference</code> supports both remote and local endpoints)</li> <li>a set of MCP client sessions, one for each connected MCP server (this allows us to connect to multiple servers)</li> <li>and a list of available tools that is going to be filled from the connected servers and just slightly re-formatted.</li>",ae,Ps,pe,Fs,Xn="To connect to a MCP server, the official <code>@modelcontextprotocol/sdk/client</code> TypeScript SDK provides a <code>Client</code> class with a <code>listTools()</code> method:",oe,Ks,ie,st,Ln="<code>StdioServerParameters</code> is an interface from the MCP SDK that will let you easily spawn a local process: as we mentioned earlier, currently, all MCP servers are actually local processes.",ce,tt,re,lt,Yn="Using our sentiment analysis tool (or any other MCP tool) is straightforward. You just pass <code>this.availableTools</code> to your LLM chat-completion, in addition to your usual array of messages:",Me,et,ue,nt,Dn="<code>tool_choice: &quot;auto&quot;</code> is the parameter you pass for the LLM to generate zero, one, or multiple tool calls.",he,at,qn="When parsing or streaming the output, the LLM will generate some tool calls (i.e. a function name, and some JSON-encoded arguments), which you (as a developer) need to compute. The MCP client SDK once again makes that very easy; it has a <code>client.callTool()</code> method:",ye,pt,Te,ot,On="If the LLM chooses to use a tool, this code will automatically route the call to the MCP server, execute the analysis, and return the result back to the LLM.",me,it,Pn="Finally you will add the resulting tool message to your <code>messages</code> array and back into the LLM.",we,ct,Je,rt,Fn="Now that we have an MCP client capable of connecting to arbitrary MCP servers  to get lists of tools and capable of injecting them and parsing them from the LLM inference, well… what is an Agent?",Ue,Mt,Kn="<p>Once you have an inference client with a set of tools, then an Agent is just a while loop on top of it.</p>",je,ut,sa="In more detail, an Agent is simply a combination of:",de,ht,ta="<li>a system prompt</li> <li>an LLM Inference client</li> <li>an MCP client to hook a set of Tools into it from a bunch of MCP servers</li> <li>some basic control flow (see below for the while loop)</li>",fe,g,be,yt,la="Our Agent class simply extends McpClient:",Ce,Tt,ve,mt,ea='By default, we use a very simple system prompt inspired by the one shared in the <a href="https://cookbook.openai.com/examples/gpt4-1_prompting_guide" rel="nofollow">GPT-4.1 prompting guide</a>.',ge,wt,na="Even though this comes from OpenAI 😈, this sentence in particular applies to more and more models, both closed and open:",Ie,Jt,aa="<p>We encourage developers to exclusively use the tools field to pass tools, rather than manually injecting tool descriptions into your prompt and writing a separate parser for tool calls, as some have reported doing in the past.</p>",Be,Ut,pa="Which is to say, we don’t need to provide painstakingly formatted lists of tool use examples in the prompt. The <code>tools: this.availableTools</code> param is enough, and the LLM will know how to use both the filesystem tools.",ke,jt,oa="Loading the tools on the Agent is literally just connecting to the MCP servers we want (in parallel because it’s so easy to do in JS):",$e,dt,Qe,ft,ia="We add two extra tools (outside of MCP) that can be used by the LLM for our Agent’s control flow:",Ee,bt,Se,Ct,ca="When calling any of these tools, the Agent will break its loop and give control back to the user for new input.",xe,vt,Ne,gt,ra="Behold our complete while loop.🎉",Ge,It,Ma="The gist of our Agent’s main while loop is that we simply iterate with the LLM alternating between tool calling and feeding it the tool results, and we do so <strong>until the LLM starts to respond with two non-tool messages in a row</strong>.",Ze,Bt,ua="This is the complete while loop:",Ae,kt,We,$t,He,Qt,Ve;return I=new J({props:{title:"Tiny Agents: an MCP-powered agent in 50 lines of code",local:"tiny-agents-an-mcp-powered-agent-in-50-lines-of-code",headingTag:"h1"}}),E=new J({props:{title:"Installation",local:"installation",headingTag:"h2"}}),x=new w({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGdGlueS1hZ2VudHMlMEElMjMlMjBvciUwQXBucG0lMjBhZGQlMjAlNDBodWdnaW5nZmFjZSUyRnRpbnktYWdlbnRz",highlighted:`npm install @huggingface/tiny-agents
<span class="hljs-comment"># or</span>
pnpm add @huggingface/tiny-agents`,wrap:!1}}),G=new w({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MG1jcGpzJTJGbWNwLXJlbW90ZSUwQSUyMyUyMG9yJTBBcG5wbSUyMGFkZCUyMCU0MG1jcGpzJTJGbWNwLXJlbW90ZQ==",highlighted:`npm install @mcpjs/mcp-remote
<span class="hljs-comment"># or</span>
pnpm add @mcpjs/mcp-remote`,wrap:!1}}),Z=new J({props:{title:"Tiny Agents MCP Client in the Command Line",local:"tiny-agents-mcp-client-in-the-command-line",headingTag:"h2"}}),H=new w({props:{code:"bWtkaXIlMjBteS1hZ2VudCUwQXRvdWNoJTIwbXktYWdlbnQlMkZhZ2VudC5qc29u",highlighted:`<span class="hljs-built_in">mkdir</span> my-agent
<span class="hljs-built_in">touch</span> my-agent/agent.json`,wrap:!1}}),R=new w({props:{code:"JTdCJTBBJTA5JTIybW9kZWwlMjIlM0ElMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIlMkMlMEElMDklMjJwcm92aWRlciUyMiUzQSUyMCUyMm5lYml1cyUyMiUyQyUwQSUwOSUyMnNlcnZlcnMlMjIlM0ElMjAlNUIlMEElMDklMDklN0IlMEElMDklMDklMDklMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMDklMDklMDklMjJjb25maWclMjIlM0ElMjAlN0IlMEElMDklMDklMDklMDklMjJjb21tYW5kJTIyJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5JTA5JTIyYXJncyUyMiUzQSUyMCU1QiUwQSUwOSUwOSUwOSUwOSUwOSUyMm1jcC1yZW1vdGUlMjIlMkMlMEElMDklMDklMDklMDklMDklMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNzg2MCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlMEElMDklMDklMDklMDklNUQlMEElMDklMDklMDklN0QlMEElMDklMDklN0QlMEElMDklNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;provider&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nebius&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
		<span class="hljs-punctuation">{</span>
			<span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
			<span class="hljs-attr">&quot;config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
				<span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
				<span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
					<span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
					<span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>
				<span class="hljs-punctuation">]</span>
			<span class="hljs-punctuation">}</span>
		<span class="hljs-punctuation">}</span>
	<span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),L=new w({props:{code:"JTdCJTBBJTA5JTIybW9kZWwlMjIlM0ElMjAlMjJRd2VuJTJGUXdlbjMtMzJCJTIyJTJDJTBBJTA5JTIyZW5kcG9pbnRVcmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMTIzNCUyRnYxJTIyJTJDJTBBJTA5JTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUwOSUwOSU3QiUwQSUwOSUwOSUwOSUyMnR5cGUlMjIlM0ElMjAlMjJzdGRpbyUyMiUyQyUwQSUwOSUwOSUwOSUyMmNvbmZpZyUyMiUzQSUyMCU3QiUwQSUwOSUwOSUwOSUwOSUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMDklMDklMDklMDklMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTA5JTA5JTA5JTA5JTA5JTIybWNwLXJlbW90ZSUyMiUyQyUwQSUwOSUwOSUwOSUwOSUwOSUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0ExMjM0JTJGdjElMkZtY3AlMkZzc2UlMjIlMEElMDklMDklMDklMDklNUQlMEElMDklMDklMDklN0QlMEElMDklMDklN0QlMEElMDklNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Qwen/Qwen3-32B&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;endpointUrl&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;http://localhost:1234/v1&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
		<span class="hljs-punctuation">{</span>
			<span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
			<span class="hljs-attr">&quot;config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
				<span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
				<span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
					<span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
					<span class="hljs-string">&quot;http://localhost:1234/v1/mcp/sse&quot;</span>
				<span class="hljs-punctuation">]</span>
			<span class="hljs-punctuation">}</span>
		<span class="hljs-punctuation">}</span>
	<span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new w({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZ0aW55LWFnZW50cyUyMHJ1biUyMC4lMkZteS1hZ2VudA==",highlighted:"npx @huggingface/tiny-agents run ./my-agent",wrap:!1}}),O=new J({props:{title:"Custom Tiny Agents MCP Client",local:"custom-tiny-agents-mcp-client",headingTag:"h2"}}),F=new J({props:{title:"Using the Gradio Server with Tiny Agents",local:"using-the-gradio-server-with-tiny-agents",headingTag:"h3"}}),ss=new w({props:{code:"Y29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNBJTIwcHJvY2Vzcy5lbnYuUFJPVklERVIlMjAlM0YlM0YlMjAlMjJuZWJpdXMlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzQSUyMHByb2Nlc3MuZW52Lk1PREVMX0lEJTIwJTNGJTNGJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpS2V5JTNBJTIwcHJvY2Vzcy5lbnYuSEZfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjBzZXJ2ZXJzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwZXhpc3RpbmclMjBzZXJ2ZXJzJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWFuZCUzQSUyMCUyMm5weCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtY3AtcmVtb3RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTc4NjAlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTIwJTIwJTJGJTJGJTIwWW91ciUyMEdyYWRpbyUyME1DUCUyMHNlcnZlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
    <span class="hljs-attr">provider</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PROVIDER</span> ?? <span class="hljs-string">&quot;nebius&quot;</span>,
    <span class="hljs-attr">model</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">MODEL_ID</span> ?? <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
    <span class="hljs-attr">apiKey</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
    <span class="hljs-attr">servers</span>: [
        <span class="hljs-comment">// ... existing servers ...</span>
        {
            <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
            <span class="hljs-attr">args</span>: [
                <span class="hljs-string">&quot;mcp-remote&quot;</span>,
                <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>  <span class="hljs-comment">// Your Gradio MCP server</span>
            ]
        }
    ],
});`,wrap:!1}}),es=new J({props:{title:"Example Interaction",local:"example-interaction",headingTag:"h3"}}),as=new w({props:{code:"VXNlciUzQSUyMFJlYWQlMjB0aGUlMjBmaWxlJTIwJTIyZmVlZGJhY2sudHh0JTIyJTIwZnJvbSUyMG15JTIwRGVza3RvcCUyMGFuZCUyMGFuYWx5emUlMjBpdHMlMjBzZW50aW1lbnQlMEElMEFBZ2VudCUzQSUyMEknbGwlMjBoZWxwJTIweW91JTIwYW5hbHl6ZSUyMHRoZSUyMHNlbnRpbWVudCUyMG9mJTIwdGhlJTIwZmVlZGJhY2slMjBmaWxlLiUyMExldCUyMG1lJTIwYnJlYWslMjB0aGlzJTIwZG93biUyMGludG8lMjBzdGVwcyUzQSUwQSUwQTEuJTIwRmlyc3QlMkMlMjBJJ2xsJTIwcmVhZCUyMHRoZSUyMGZpbGUlMjB1c2luZyUyMHRoZSUyMGZpbGVzeXN0ZW0lMjB0b29sJTBBMi4lMjBUaGVuJTJDJTIwSSdsbCUyMGFuYWx5emUlMjBpdHMlMjBzZW50aW1lbnQlMjB1c2luZyUyMHRoZSUyMHNlbnRpbWVudCUyMGFuYWx5c2lzJTIwdG9vbCUwQTMuJTIwRmluYWxseSUyQyUyMEknbGwlMjB3cml0ZSUyMHRoZSUyMHJlc3VsdHMlMjB0byUyMGElMjBuZXclMjBmaWxlJTBBJTBBJTVCQWdlbnQlMjBwcm9jZWVkcyUyMHRvJTIwdXNlJTIwdGhlJTIwdG9vbHMlMjBhbmQlMjBwcm92aWRlJTIwdGhlJTIwYW5hbHlzaXMlNUQ=",highlighted:`<span class="hljs-symbol">User:</span> Read the file <span class="hljs-string">&quot;feedback.txt&quot;</span> <span class="hljs-keyword">from</span> my Desktop <span class="hljs-built_in">and</span> analyze its sentiment

<span class="hljs-symbol">Agent:</span> I<span class="hljs-comment">&#x27;ll help you analyze the sentiment of the feedback file. Let me break this down into steps:</span>

<span class="hljs-number">1</span>. First, I<span class="hljs-comment">&#x27;ll read the file using the filesystem tool</span>
<span class="hljs-number">2</span>. <span class="hljs-keyword">Then</span>, I<span class="hljs-comment">&#x27;ll analyze its sentiment using the sentiment analysis tool</span>
<span class="hljs-number">3</span>. <span class="hljs-keyword">Finally</span>, I<span class="hljs-comment">&#x27;ll write the results to a new file</span>

[Agent proceeds <span class="hljs-keyword">to</span> use the tools <span class="hljs-built_in">and</span> provide the analysis]`,wrap:!1}}),ps=new J({props:{title:"Deployment Considerations",local:"deployment-considerations",headingTag:"h3"}}),is=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzQSUyMCUyMm5weCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtY3AtcmVtb3RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZZT1VSX1VTRVJOQU1FLW1jcC1zZW50aW1lbnQuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`{
    <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
    <span class="hljs-attr">args</span>: [
        <span class="hljs-string">&quot;mcp-remote&quot;</span>,
        <span class="hljs-string">&quot;https://YOUR_USERNAME-mcp-sentiment.hf.space/gradio_api/mcp/sse&quot;</span>
    ]
}`,wrap:!1}}),rs=new J({props:{title:"Conclusion: Our Complete End-to-End MCP Application",local:"conclusion-our-complete-end-to-end-mcp-application",headingTag:"h2"}}),ws=new J({props:{title:"Bonus: Build a Browser Automation MCP Server with Playwright",local:"bonus-build-a-browser-automation-mcp-server-with-playwright",headingTag:"h2"}}),C=new Re({props:{$$slots:{default:[va]},$$scope:{ctx:b}}}),js=new w({props:{code:"JTJGJTJGJTIwcGxheXdyaWdodC1hZ2VudC50cyUwQWltcG9ydCUyMCU3QiUyMEFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGdGlueS1hZ2VudHMlMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwQWdlbnQoJTdCJTBBJTIwJTIwcHJvdmlkZXIlM0ElMjBwcm9jZXNzLmVudi5QUk9WSURFUiUyMCUzRiUzRiUyMCUyMm5lYml1cyUyMiUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwcHJvY2Vzcy5lbnYuTU9ERUxfSUQlMjAlM0YlM0YlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBhcGlLZXklM0ElMjBwcm9jZXNzLmVudi5IRl9UT0tFTiUyQyUwQSUyMCUyMHNlcnZlcnMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBjb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzQSUyMCU1QiUyMnBsYXl3cmlnaHQtbWNwJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTJDJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwYWdlbnQucnVuKCklM0I=",highlighted:`<span class="hljs-comment">// playwright-agent.ts</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Agent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/tiny-agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
  <span class="hljs-attr">provider</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PROVIDER</span> ?? <span class="hljs-string">&quot;nebius&quot;</span>,
  <span class="hljs-attr">model</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">MODEL_ID</span> ?? <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
  <span class="hljs-attr">apiKey</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
  <span class="hljs-attr">servers</span>: [
    {
      <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
      <span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;playwright-mcp&quot;</span>]
    }
  ],
});

<span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>();`,wrap:!1}}),Cs=new w({props:{code:"VXNlciUzQSUyMFNlYXJjaCUyMGZvciUyMCUyMnRpbnklMjBhZ2VudHMlMjIlMjBvbiUyMEdpdEh1YiUyMGFuZCUyMGNvbGxlY3QlMjB0aGUlMjBuYW1lcyUyMG9mJTIwdGhlJTIwdG9wJTIwMyUyMHJlcG9zaXRvcmllcyUwQSUwQUFnZW50JTNBJTIwSSdsbCUyMHNlYXJjaCUyMEdpdEh1YiUyMGZvciUyMCUyMnRpbnklMjBhZ2VudHMlMjIlMjByZXBvc2l0b3JpZXMuJTBBJTVCQWdlbnQlMjBvcGVucyUyMGJyb3dzZXIlMkMlMjBuYXZpZ2F0ZXMlMjB0byUyMEdpdEh1YiUyQyUyMHBlcmZvcm1zJTIwdGhlJTIwc2VhcmNoJTJDJTIwYW5kJTIwZXh0cmFjdHMlMjByZXBvc2l0b3J5JTIwbmFtZXMlNUQlMEElMEFIZXJlJTIwYXJlJTIwdGhlJTIwdG9wJTIwMyUyMChub3QlMjByZWFsKSUyMHJlcG9zaXRvcmllcyUyMGZvciUyMCUyMnRpbnklMjBhZ2VudHMlMjIlM0ElMEExLiUyMGh1Z2dpbmdmYWNlJTJGdGlueS1hZ2VudHMlMEEyLiUyMG1vZGVsY29udGV4dHByb3RvY29sJTJGdGlueS1hZ2VudHMtZXhhbXBsZXMlMEEzLiUyMGxhbmdjaGFpbiUyRnRpbnktYWdlbnRzLWpz",highlighted:`<span class="hljs-symbol">User:</span> Search <span class="hljs-keyword">for</span> <span class="hljs-string">&quot;tiny agents&quot;</span> <span class="hljs-keyword">on</span> GitHub <span class="hljs-built_in">and</span> collect the names <span class="hljs-keyword">of</span> the top <span class="hljs-number">3</span> repositories

<span class="hljs-symbol">Agent:</span> I<span class="hljs-comment">&#x27;ll search GitHub for &quot;tiny agents&quot; repositories.</span>
[Agent opens browser, navigates <span class="hljs-keyword">to</span> GitHub, performs the search, <span class="hljs-built_in">and</span> extracts repository names]

Here are the top <span class="hljs-number">3</span> (<span class="hljs-built_in">not</span> real) repositories <span class="hljs-keyword">for</span> <span class="hljs-string">&quot;tiny agents&quot;</span>:
<span class="hljs-number">1</span>. huggingface/tiny-agents
<span class="hljs-number">2</span>. modelcontextprotocol/tiny-agents-examples
<span class="hljs-number">3</span>. langchain/tiny-agents-js`,wrap:!1}}),gs=new J({props:{title:"How to run the complete demo",local:"how-to-run-the-complete-demo",headingTag:"h2"}}),Bs=new w({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZtY3AtY2xpZW50",highlighted:"npx @huggingface/mcp-client",wrap:!1}}),$s=new w({props:{code:"cG5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudA==",highlighted:"pnpx @huggingface/mcp-client",wrap:!1}}),Hs=new J({props:{title:"Default model and provider",local:"default-model-and-provider",headingTag:"h3"}}),_s=new w({props:{code:"Y29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUwOXByb3ZpZGVyJTNBJTIwcHJvY2Vzcy5lbnYuUFJPVklERVIlMjAlM0YlM0YlMjAlMjJuZWJpdXMlMjIlMkMlMEElMDltb2RlbCUzQSUyMHByb2Nlc3MuZW52Lk1PREVMX0lEJTIwJTNGJTNGJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTA5YXBpS2V5JTNBJTIwcHJvY2Vzcy5lbnYuSEZfVE9LRU4lMkMlMEElMDlzZXJ2ZXJzJTNBJTIwJTVCJTBBJTA5JTA5JTJGJTJGJTIwRGVmYXVsdCUyMHNlcnZlcnMlMEElMDklMDklN0IlMEElMDklMDklMDljb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5YXJncyUzQSUyMCU1QiUyMiU0MG1vZGVsY29udGV4dHByb3RvY29sJTJGc2VydmVycyUyMiUyQyUyMCUyMmZpbGVzeXN0ZW0lMjIlNUQlMEElMDklMDklN0QlMkMlMEElMDklMDklN0IlMEElMDklMDklMDljb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5YXJncyUzQSUyMCU1QiUyMnBsYXl3cmlnaHQtbWNwJTIyJTVEJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTVEJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
	<span class="hljs-attr">provider</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PROVIDER</span> ?? <span class="hljs-string">&quot;nebius&quot;</span>,
	<span class="hljs-attr">model</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">MODEL_ID</span> ?? <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
	<span class="hljs-attr">apiKey</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
	<span class="hljs-attr">servers</span>: [
		<span class="hljs-comment">// Default servers</span>
		{
			<span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
			<span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;@modelcontextprotocol/servers&quot;</span>, <span class="hljs-string">&quot;filesystem&quot;</span>]
		},
		{
			<span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
			<span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;playwright-mcp&quot;</span>]
		},
	],
});`,wrap:!1}}),Xs=new J({props:{title:"Implementing an MCP client on top of InferenceClient",local:"implementing-an-mcp-client-on-top-of-inferenceclient",headingTag:"h2"}}),v=new Re({props:{warning:!1,$$slots:{default:[ga]},$$scope:{ctx:b}}}),Ps=new w({props:{code:"ZXhwb3J0JTIwY2xhc3MlMjBNY3BDbGllbnQlMjAlN0IlMEElMDlwcm90ZWN0ZWQlMjBjbGllbnQlM0ElMjBJbmZlcmVuY2VDbGllbnQlM0IlMEElMDlwcm90ZWN0ZWQlMjBwcm92aWRlciUzQSUyMHN0cmluZyUzQiUwQSUwOXByb3RlY3RlZCUyMG1vZGVsJTNBJTIwc3RyaW5nJTNCJTBBJTA5cHJpdmF0ZSUyMGNsaWVudHMlM0ElMjBNYXAlM0NUb29sTmFtZSUyQyUyMENsaWVudCUzRSUyMCUzRCUyMG5ldyUyME1hcCgpJTNCJTBBJTA5cHVibGljJTIwcmVhZG9ubHklMjBhdmFpbGFibGVUb29scyUzQSUyMENoYXRDb21wbGV0aW9uSW5wdXRUb29sJTVCJTVEJTIwJTNEJTIwJTVCJTVEJTNCJTBBJTBBJTA5Y29uc3RydWN0b3IoJTdCJTIwcHJvdmlkZXIlMkMlMjBtb2RlbCUyQyUyMGFwaUtleSUyMCU3RCUzQSUyMCU3QiUyMHByb3ZpZGVyJTNBJTIwSW5mZXJlbmNlUHJvdmlkZXIlM0IlMjBtb2RlbCUzQSUyMHN0cmluZyUzQiUyMGFwaUtleSUzQSUyMHN0cmluZyUyMCU3RCklMjAlN0IlMEElMDklMDl0aGlzLmNsaWVudCUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudChhcGlLZXkpJTNCJTBBJTA5JTA5dGhpcy5wcm92aWRlciUyMCUzRCUyMHByb3ZpZGVyJTNCJTBBJTA5JTA5dGhpcy5tb2RlbCUyMCUzRCUyMG1vZGVsJTNCJTBBJTA5JTdEJTBBJTA5JTBBJTA5JTJGJTJGJTIwJTVCLi4uJTVEJTBBJTdE",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">McpClient</span> {
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">client</span>: <span class="hljs-title class_">InferenceClient</span>;
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">provider</span>: <span class="hljs-built_in">string</span>;
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">model</span>: <span class="hljs-built_in">string</span>;
	<span class="hljs-keyword">private</span> <span class="hljs-attr">clients</span>: <span class="hljs-title class_">Map</span>&lt;<span class="hljs-title class_">ToolName</span>, <span class="hljs-title class_">Client</span>&gt; = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Map</span>();
	<span class="hljs-keyword">public</span> <span class="hljs-keyword">readonly</span> <span class="hljs-attr">availableTools</span>: <span class="hljs-title class_">ChatCompletionInputTool</span>[] = [];

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params">{ provider, model, apiKey }: { provider: InferenceProvider; model: <span class="hljs-built_in">string</span>; apiKey: <span class="hljs-built_in">string</span> }</span>) {
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">client</span> = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(apiKey);
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">provider</span> = provider;
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span> = model;
	}
	
	<span class="hljs-comment">// [...]</span>
}`,wrap:!1}}),Ks=new w({props:{code:"YXN5bmMlMjBhZGRNY3BTZXJ2ZXIoc2VydmVyJTNBJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKSUzQSUyMFByb21pc2UlM0N2b2lkJTNFJTIwJTdCJTBBJTA5Y29uc3QlMjB0cmFuc3BvcnQlMjAlM0QlMjBuZXclMjBTdGRpb0NsaWVudFRyYW5zcG9ydCglN0IlMEElMDklMDkuLi5zZXJ2ZXIlMkMlMEElMDklMDllbnYlM0ElMjAlN0IlMjAuLi5zZXJ2ZXIuZW52JTJDJTIwUEFUSCUzQSUyMHByb2Nlc3MuZW52LlBBVEglMjAlM0YlM0YlMjAlMjIlMjIlMjAlN0QlMkMlMEElMDklN0QpJTNCJTBBJTA5Y29uc3QlMjBtY3AlMjAlM0QlMjBuZXclMjBDbGllbnQoJTdCJTIwbmFtZSUzQSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudCUyMiUyQyUyMHZlcnNpb24lM0ElMjBwYWNrYWdlVmVyc2lvbiUyMCU3RCklM0IlMEElMDlhd2FpdCUyMG1jcC5jb25uZWN0KHRyYW5zcG9ydCklM0IlMEElMEElMDljb25zdCUyMHRvb2xzUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBtY3AubGlzdFRvb2xzKCklM0IlMEElMDlkZWJ1ZyglMEElMDklMDklMjJDb25uZWN0ZWQlMjB0byUyMHNlcnZlciUyMHdpdGglMjB0b29scyUzQSUyMiUyQyUwQSUwOSUwOXRvb2xzUmVzdWx0LnRvb2xzLm1hcCgoJTdCJTIwbmFtZSUyMCU3RCklMjAlM0QlM0UlMjBuYW1lKSUwQSUwOSklM0IlMEElMEElMDlmb3IlMjAoY29uc3QlMjB0b29sJTIwb2YlMjB0b29sc1Jlc3VsdC50b29scyklMjAlN0IlMEElMDklMDl0aGlzLmNsaWVudHMuc2V0KHRvb2wubmFtZSUyQyUyMG1jcCklM0IlMEElMDklN0QlMEElMEElMDl0aGlzLmF2YWlsYWJsZVRvb2xzLnB1c2goJTBBJTA5JTA5Li4udG9vbHNSZXN1bHQudG9vbHMubWFwKCh0b29sKSUyMCUzRCUzRSUyMCU3QiUwQSUwOSUwOSUwOXJldHVybiUyMCU3QiUwQSUwOSUwOSUwOSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOSUwOSUwOSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTA5JTA5bmFtZSUzQSUyMHRvb2wubmFtZSUyQyUwQSUwOSUwOSUwOSUwOSUwOWRlc2NyaXB0aW9uJTNBJTIwdG9vbC5kZXNjcmlwdGlvbiUyQyUwQSUwOSUwOSUwOSUwOSUwOXBhcmFtZXRlcnMlM0ElMjB0b29sLmlucHV0U2NoZW1hJTJDJTBBJTA5JTA5JTA5JTA5JTdEJTJDJTBBJTA5JTA5JTA5JTdEJTIwc2F0aXNmaWVzJTIwQ2hhdENvbXBsZXRpb25JbnB1dFRvb2wlM0IlMEElMDklMDklN0QpJTBBJTA5KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-title function_">addMcpServer</span>(<span class="hljs-attr">server</span>: <span class="hljs-title class_">StdioServerParameters</span>): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">void</span>&gt; {
	<span class="hljs-keyword">const</span> transport = <span class="hljs-keyword">new</span> <span class="hljs-title class_">StdioClientTransport</span>({
		...server,
		<span class="hljs-attr">env</span>: { ...server.<span class="hljs-property">env</span>, <span class="hljs-attr">PATH</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PATH</span> ?? <span class="hljs-string">&quot;&quot;</span> },
	});
	<span class="hljs-keyword">const</span> mcp = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Client</span>({ <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;@huggingface/mcp-client&quot;</span>, <span class="hljs-attr">version</span>: packageVersion });
	<span class="hljs-keyword">await</span> mcp.<span class="hljs-title function_">connect</span>(transport);

	<span class="hljs-keyword">const</span> toolsResult = <span class="hljs-keyword">await</span> mcp.<span class="hljs-title function_">listTools</span>();
	<span class="hljs-title function_">debug</span>(
		<span class="hljs-string">&quot;Connected to server with tools:&quot;</span>,
		toolsResult.<span class="hljs-property">tools</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">{ name }</span>) =&gt;</span> name)
	);

	<span class="hljs-keyword">for</span> (<span class="hljs-keyword">const</span> tool <span class="hljs-keyword">of</span> toolsResult.<span class="hljs-property">tools</span>) {
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">clients</span>.<span class="hljs-title function_">set</span>(tool.<span class="hljs-property">name</span>, mcp);
	}

	<span class="hljs-variable language_">this</span>.<span class="hljs-property">availableTools</span>.<span class="hljs-title function_">push</span>(
		...toolsResult.<span class="hljs-property">tools</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">tool</span>) =&gt;</span> {
			<span class="hljs-keyword">return</span> {
				<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
				<span class="hljs-attr">function</span>: {
					<span class="hljs-attr">name</span>: tool.<span class="hljs-property">name</span>,
					<span class="hljs-attr">description</span>: tool.<span class="hljs-property">description</span>,
					<span class="hljs-attr">parameters</span>: tool.<span class="hljs-property">inputSchema</span>,
				},
			} satisfies <span class="hljs-title class_">ChatCompletionInputTool</span>;
		})
	);
}`,wrap:!1}}),tt=new J({props:{title:"How to use the tools",local:"how-to-use-the-tools",headingTag:"h3"}}),et=new w({props:{code:"Y29uc3QlMjBzdHJlYW0lMjAlM0QlMjB0aGlzLmNsaWVudC5jaGF0Q29tcGxldGlvblN0cmVhbSglN0IlMEElMDlwcm92aWRlciUzQSUyMHRoaXMucHJvdmlkZXIlMkMlMEElMDltb2RlbCUzQSUyMHRoaXMubW9kZWwlMkMlMEElMDltZXNzYWdlcyUyQyUwQSUwOXRvb2xzJTNBJTIwdGhpcy5hdmFpbGFibGVUb29scyUyQyUwQSUwOXRvb2xfY2hvaWNlJTNBJTIwJTIyYXV0byUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> stream = <span class="hljs-variable language_">this</span>.<span class="hljs-property">client</span>.<span class="hljs-title function_">chatCompletionStream</span>({
	<span class="hljs-attr">provider</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">provider</span>,
	<span class="hljs-attr">model</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>,
	messages,
	<span class="hljs-attr">tools</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">availableTools</span>,
	<span class="hljs-attr">tool_choice</span>: <span class="hljs-string">&quot;auto&quot;</span>,
});`,wrap:!1}}),pt=new w({props:{code:"Y29uc3QlMjB0b29sTmFtZSUyMCUzRCUyMHRvb2xDYWxsLmZ1bmN0aW9uLm5hbWUlM0IlMEFjb25zdCUyMHRvb2xBcmdzJTIwJTNEJTIwSlNPTi5wYXJzZSh0b29sQ2FsbC5mdW5jdGlvbi5hcmd1bWVudHMpJTNCJTBBJTBBY29uc3QlMjB0b29sTWVzc2FnZSUzQSUyMENoYXRDb21wbGV0aW9uSW5wdXRNZXNzYWdlVG9vbCUyMCUzRCUyMCU3QiUwQSUwOXJvbGUlM0ElMjAlMjJ0b29sJTIyJTJDJTBBJTA5dG9vbF9jYWxsX2lkJTNBJTIwdG9vbENhbGwuaWQlMkMlMEElMDljb250ZW50JTNBJTIwJTIyJTIyJTJDJTBBJTA5bmFtZSUzQSUyMHRvb2xOYW1lJTJDJTBBJTdEJTNCJTBBJTBBJTJGJTJGJTJGJTIwR2V0JTIwdGhlJTIwYXBwcm9wcmlhdGUlMjBzZXNzaW9uJTIwZm9yJTIwdGhpcyUyMHRvb2wlMEFjb25zdCUyMGNsaWVudCUyMCUzRCUyMHRoaXMuY2xpZW50cy5nZXQodG9vbE5hbWUpJTNCJTBBaWYlMjAoY2xpZW50KSUyMCU3QiUwQSUwOWNvbnN0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuY2FsbFRvb2woJTdCJTIwbmFtZSUzQSUyMHRvb2xOYW1lJTJDJTIwYXJndW1lbnRzJTNBJTIwdG9vbEFyZ3MlMjAlN0QpJTNCJTBBJTA5dG9vbE1lc3NhZ2UuY29udGVudCUyMCUzRCUyMHJlc3VsdC5jb250ZW50JTVCMCU1RC50ZXh0JTNCJTBBJTdEJTIwZWxzZSUyMCU3QiUwQSUwOXRvb2xNZXNzYWdlLmNvbnRlbnQlMjAlM0QlMjAlNjBFcnJvciUzQSUyME5vJTIwc2Vzc2lvbiUyMGZvdW5kJTIwZm9yJTIwdG9vbCUzQSUyMCUyNCU3QnRvb2xOYW1lJTdEJTYwJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">const</span> toolName = toolCall.<span class="hljs-property">function</span>.<span class="hljs-property">name</span>;
<span class="hljs-keyword">const</span> toolArgs = <span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">parse</span>(toolCall.<span class="hljs-property">function</span>.<span class="hljs-property">arguments</span>);

<span class="hljs-keyword">const</span> <span class="hljs-attr">toolMessage</span>: <span class="hljs-title class_">ChatCompletionInputMessageTool</span> = {
	<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;tool&quot;</span>,
	<span class="hljs-attr">tool_call_id</span>: toolCall.<span class="hljs-property">id</span>,
	<span class="hljs-attr">content</span>: <span class="hljs-string">&quot;&quot;</span>,
	<span class="hljs-attr">name</span>: toolName,
};

<span class="hljs-comment">/// Get the appropriate session for this tool</span>
<span class="hljs-keyword">const</span> client = <span class="hljs-variable language_">this</span>.<span class="hljs-property">clients</span>.<span class="hljs-title function_">get</span>(toolName);
<span class="hljs-keyword">if</span> (client) {
	<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">callTool</span>({ <span class="hljs-attr">name</span>: toolName, <span class="hljs-attr">arguments</span>: toolArgs });
	toolMessage.<span class="hljs-property">content</span> = result.<span class="hljs-property">content</span>[<span class="hljs-number">0</span>].<span class="hljs-property">text</span>;
} <span class="hljs-keyword">else</span> {
	toolMessage.<span class="hljs-property">content</span> = <span class="hljs-string">\`Error: No session found for tool: <span class="hljs-subst">\${toolName}</span>\`</span>;
}`,wrap:!1}}),ct=new J({props:{title:"Our 50-lines-of-code Agent 🤯",local:"our-50-lines-of-code-agent-",headingTag:"h2"}}),g=new Re({props:{warning:!1,$$slots:{default:[Ia]},$$scope:{ctx:b}}}),Tt=new w({props:{code:"ZXhwb3J0JTIwY2xhc3MlMjBBZ2VudCUyMGV4dGVuZHMlMjBNY3BDbGllbnQlMjAlN0IlMEElMDlwcml2YXRlJTIwcmVhZG9ubHklMjBzZXJ2ZXJzJTNBJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTVCJTVEJTNCJTBBJTA5cHJvdGVjdGVkJTIwbWVzc2FnZXMlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0TWVzc2FnZSU1QiU1RCUzQiUwQSUwQSUwOWNvbnN0cnVjdG9yKCU3QiUwQSUwOSUwOXByb3ZpZGVyJTJDJTBBJTA5JTA5bW9kZWwlMkMlMEElMDklMDlhcGlLZXklMkMlMEElMDklMDlzZXJ2ZXJzJTJDJTBBJTA5JTA5cHJvbXB0JTJDJTBBJTA5JTdEJTNBJTIwJTdCJTBBJTA5JTA5cHJvdmlkZXIlM0ElMjBJbmZlcmVuY2VQcm92aWRlciUzQiUwQSUwOSUwOW1vZGVsJTNBJTIwc3RyaW5nJTNCJTBBJTA5JTA5YXBpS2V5JTNBJTIwc3RyaW5nJTNCJTBBJTA5JTA5c2VydmVycyUzQSUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyU1QiU1RCUzQiUwQSUwOSUwOXByb21wdCUzRiUzQSUyMHN0cmluZyUzQiUwQSUwOSU3RCklMjAlN0IlMEElMDklMDlzdXBlciglN0IlMjBwcm92aWRlciUyQyUyMG1vZGVsJTJDJTIwYXBpS2V5JTIwJTdEKSUzQiUwQSUwOSUwOXRoaXMuc2VydmVycyUyMCUzRCUyMHNlcnZlcnMlM0IlMEElMDklMDl0aGlzLm1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTA5JTA5JTA5JTdCJTBBJTA5JTA5JTA5JTA5cm9sZSUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUwOSUwOSUwOSUwOWNvbnRlbnQlM0ElMjBwcm9tcHQlMjAlM0YlM0YlMjBERUZBVUxUX1NZU1RFTV9QUk9NUFQlMkMlMEElMDklMDklMDklN0QlMkMlMEElMDklMDklNUQlM0IlMEElMDklN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">Agent</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">McpClient</span> {
	<span class="hljs-keyword">private</span> <span class="hljs-keyword">readonly</span> <span class="hljs-attr">servers</span>: <span class="hljs-title class_">StdioServerParameters</span>[];
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">messages</span>: <span class="hljs-title class_">ChatCompletionInputMessage</span>[];

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params">{
		provider,
		model,
		apiKey,
		servers,
		prompt,
	}: {
		provider: InferenceProvider;
		model: <span class="hljs-built_in">string</span>;
		apiKey: <span class="hljs-built_in">string</span>;
		servers: StdioServerParameters[];
		prompt?: <span class="hljs-built_in">string</span>;
	}</span>) {
		<span class="hljs-variable language_">super</span>({ provider, model, apiKey });
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">servers</span> = servers;
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span> = [
			{
				<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>,
				<span class="hljs-attr">content</span>: prompt ?? <span class="hljs-variable constant_">DEFAULT_SYSTEM_PROMPT</span>,
			},
		];
	}
}`,wrap:!1}}),dt=new w({props:{code:"YXN5bmMlMjBsb2FkVG9vbHMoKSUzQSUyMFByb21pc2UlM0N2b2lkJTNFJTIwJTdCJTBBJTA5YXdhaXQlMjBQcm9taXNlLmFsbCh0aGlzLnNlcnZlcnMubWFwKChzKSUyMCUzRCUzRSUyMHRoaXMuYWRkTWNwU2VydmVyKHMpKSklM0IlMEElN0Q=",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-title function_">loadTools</span>(): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">void</span>&gt; {
	<span class="hljs-keyword">await</span> <span class="hljs-title class_">Promise</span>.<span class="hljs-title function_">all</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">servers</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">s</span>) =&gt;</span> <span class="hljs-variable language_">this</span>.<span class="hljs-title function_">addMcpServer</span>(s)));
}`,wrap:!1}}),bt=new w({props:{code:"Y29uc3QlMjB0YXNrQ29tcGxldGlvblRvb2wlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0VG9vbCUyMCUzRCUyMCU3QiUwQSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5bmFtZSUzQSUyMCUyMnRhc2tfY29tcGxldGUlMjIlMkMlMEElMDklMDlkZXNjcmlwdGlvbiUzQSUyMCUyMkNhbGwlMjB0aGlzJTIwdG9vbCUyMHdoZW4lMjB0aGUlMjB0YXNrJTIwZ2l2ZW4lMjBieSUyMHRoZSUyMHVzZXIlMjBpcyUyMGNvbXBsZXRlJTIyJTJDJTBBJTA5JTA5cGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUwOXR5cGUlM0ElMjAlMjJvYmplY3QlMjIlMkMlMEElMDklMDklMDlwcm9wZXJ0aWVzJTNBJTIwJTdCJTdEJTJDJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTdEJTJDJTBBJTdEJTNCJTBBY29uc3QlMjBhc2tRdWVzdGlvblRvb2wlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0VG9vbCUyMCUzRCUyMCU3QiUwQSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5bmFtZSUzQSUyMCUyMmFza19xdWVzdGlvbiUyMiUyQyUwQSUwOSUwOWRlc2NyaXB0aW9uJTNBJTIwJTIyQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdG8lMjB0aGUlMjB1c2VyJTIwdG8lMjBnZXQlMjBtb3JlJTIwaW5mbyUyMHJlcXVpcmVkJTIwdG8lMjBzb2x2ZSUyMG9yJTIwY2xhcmlmeSUyMHRoZWlyJTIwcHJvYmxlbS4lMjIlMkMlMEElMDklMDlwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTA5JTA5JTA5dHlwZSUzQSUyMCUyMm9iamVjdCUyMiUyQyUwQSUwOSUwOSUwOXByb3BlcnRpZXMlM0ElMjAlN0IlN0QlMkMlMEElMDklMDklN0QlMkMlMEElMDklN0QlMkMlMEElN0QlM0IlMEFjb25zdCUyMGV4aXRMb29wVG9vbHMlMjAlM0QlMjAlNUJ0YXNrQ29tcGxldGlvblRvb2wlMkMlMjBhc2tRdWVzdGlvblRvb2wlNUQlM0I=",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-attr">taskCompletionTool</span>: <span class="hljs-title class_">ChatCompletionInputTool</span> = {
	<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
	<span class="hljs-attr">function</span>: {
		<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;task_complete&quot;</span>,
		<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;Call this tool when the task given by the user is complete&quot;</span>,
		<span class="hljs-attr">parameters</span>: {
			<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;object&quot;</span>,
			<span class="hljs-attr">properties</span>: {},
		},
	},
};
<span class="hljs-keyword">const</span> <span class="hljs-attr">askQuestionTool</span>: <span class="hljs-title class_">ChatCompletionInputTool</span> = {
	<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
	<span class="hljs-attr">function</span>: {
		<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;ask_question&quot;</span>,
		<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;Ask a question to the user to get more info required to solve or clarify their problem.&quot;</span>,
		<span class="hljs-attr">parameters</span>: {
			<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;object&quot;</span>,
			<span class="hljs-attr">properties</span>: {},
		},
	},
};
<span class="hljs-keyword">const</span> exitLoopTools = [taskCompletionTool, askQuestionTool];`,wrap:!1}}),vt=new J({props:{title:"The complete while loop",local:"the-complete-while-loop",headingTag:"h3"}}),kt=new w({props:{code:"bGV0JTIwbnVtT2ZUdXJucyUyMCUzRCUyMDAlM0IlMEFsZXQlMjBuZXh0VHVyblNob3VsZENhbGxUb29scyUyMCUzRCUyMHRydWUlM0IlMEF3aGlsZSUyMCh0cnVlKSUyMCU3QiUwQSUwOXRyeSUyMCU3QiUwQSUwOSUwOXlpZWxkKiUyMHRoaXMucHJvY2Vzc1NpbmdsZVR1cm5XaXRoVG9vbHModGhpcy5tZXNzYWdlcyUyQyUyMCU3QiUwQSUwOSUwOSUwOWV4aXRMb29wVG9vbHMlMkMlMEElMDklMDklMDlleGl0SWZGaXJzdENodW5rTm9Ub29sJTNBJTIwbnVtT2ZUdXJucyUyMCUzRSUyMDAlMjAlMjYlMjYlMjBuZXh0VHVyblNob3VsZENhbGxUb29scyUyQyUwQSUwOSUwOSUwOWFib3J0U2lnbmFsJTNBJTIwb3B0cy5hYm9ydFNpZ25hbCUyQyUwQSUwOSUwOSU3RCklM0IlMEElMDklN0QlMjBjYXRjaCUyMChlcnIpJTIwJTdCJTBBJTA5JTA5aWYlMjAoZXJyJTIwaW5zdGFuY2VvZiUyMEVycm9yJTIwJTI2JTI2JTIwZXJyLm1lc3NhZ2UlMjAlM0QlM0QlM0QlMjAlMjJBYm9ydEVycm9yJTIyKSUyMCU3QiUwQSUwOSUwOSUwOXJldHVybiUzQiUwQSUwOSUwOSU3RCUwQSUwOSUwOXRocm93JTIwZXJyJTNCJTBBJTA5JTdEJTBBJTA5bnVtT2ZUdXJucyUyQiUyQiUzQiUwQSUwOWNvbnN0JTIwY3VycmVudExhc3QlMjAlM0QlMjB0aGlzLm1lc3NhZ2VzLmF0KC0xKSElM0IlMEElMDlpZiUyMCglMEElMDklMDljdXJyZW50TGFzdC5yb2xlJTIwJTNEJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUwQSUwOSUwOWN1cnJlbnRMYXN0Lm5hbWUlMjAlMjYlMjYlMEElMDklMDlleGl0TG9vcFRvb2xzLm1hcCgodCklMjAlM0QlM0UlMjB0LmZ1bmN0aW9uLm5hbWUpLmluY2x1ZGVzKGN1cnJlbnRMYXN0Lm5hbWUpJTBBJTA5KSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAhJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUyMG51bU9mVHVybnMlMjAlM0UlMjBNQVhfTlVNX1RVUk5TKSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAhJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUyMG5leHRUdXJuU2hvdWxkQ2FsbFRvb2xzKSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAlM0QlM0QlM0QlMjAlMjJ0b29sJTIyKSUyMCU3QiUwQSUwOSUwOW5leHRUdXJuU2hvdWxkQ2FsbFRvb2xzJTIwJTNEJTIwZmFsc2UlM0IlMEElMDklN0QlMjBlbHNlJTIwJTdCJTBBJTA5JTA5bmV4dFR1cm5TaG91bGRDYWxsVG9vbHMlMjAlM0QlMjB0cnVlJTNCJTBBJTA5JTdEJTBBJTdE",highlighted:`<span class="hljs-keyword">let</span> numOfTurns = <span class="hljs-number">0</span>;
<span class="hljs-keyword">let</span> nextTurnShouldCallTools = <span class="hljs-literal">true</span>;
<span class="hljs-keyword">while</span> (<span class="hljs-literal">true</span>) {
	<span class="hljs-keyword">try</span> {
		<span class="hljs-keyword">yield</span>* <span class="hljs-variable language_">this</span>.<span class="hljs-title function_">processSingleTurnWithTools</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span>, {
			exitLoopTools,
			<span class="hljs-attr">exitIfFirstChunkNoTool</span>: numOfTurns &gt; <span class="hljs-number">0</span> &amp;&amp; nextTurnShouldCallTools,
			<span class="hljs-attr">abortSignal</span>: opts.<span class="hljs-property">abortSignal</span>,
		});
	} <span class="hljs-keyword">catch</span> (err) {
		<span class="hljs-keyword">if</span> (err <span class="hljs-keyword">instanceof</span> <span class="hljs-title class_">Error</span> &amp;&amp; err.<span class="hljs-property">message</span> === <span class="hljs-string">&quot;AbortError&quot;</span>) {
			<span class="hljs-keyword">return</span>;
		}
		<span class="hljs-keyword">throw</span> err;
	}
	numOfTurns++;
	<span class="hljs-keyword">const</span> currentLast = <span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span>.<span class="hljs-title function_">at</span>(-<span class="hljs-number">1</span>)!;
	<span class="hljs-keyword">if</span> (
		currentLast.<span class="hljs-property">role</span> === <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp;
		currentLast.<span class="hljs-property">name</span> &amp;&amp;
		exitLoopTools.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">t</span>) =&gt;</span> t.<span class="hljs-property">function</span>.<span class="hljs-property">name</span>).<span class="hljs-title function_">includes</span>(currentLast.<span class="hljs-property">name</span>)
	) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> !== <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp; numOfTurns &gt; <span class="hljs-variable constant_">MAX_NUM_TURNS</span>) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> !== <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp; nextTurnShouldCallTools) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> === <span class="hljs-string">&quot;tool&quot;</span>) {
		nextTurnShouldCallTools = <span class="hljs-literal">false</span>;
	} <span class="hljs-keyword">else</span> {
		nextTurnShouldCallTools = <span class="hljs-literal">true</span>;
	}
}`,wrap:!1}}),$t=new Ca({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/tiny-agents.mdx"}}),{c(){T=p("meta"),U=n(),m=p("p"),j=n(),c(I.$$.fragment),Et=n(),B=p("p"),B.innerHTML=_e,St=n(),k=p("p"),k.textContent=Xe,xt=n(),$=p("p"),$.innerHTML=Le,Nt=n(),Q=p("figcaption"),Q.textContent=Ye,Gt=n(),c(E.$$.fragment),Zt=n(),S=p("p"),S.innerHTML=De,At=n(),c(x.$$.fragment),Wt=n(),N=p("p"),N.innerHTML=qe,Ht=n(),c(G.$$.fragment),Vt=n(),c(Z.$$.fragment),Rt=n(),A=p("p"),A.textContent=Oe,zt=n(),W=p("p"),W.textContent=Pe,_t=n(),c(H.$$.fragment),Xt=n(),V=p("p"),V.textContent=Fe,Lt=n(),c(R.$$.fragment),Yt=n(),z=p("p"),z.textContent=Ke,Dt=n(),_=p("table"),_.innerHTML=sn,qt=n(),X=p("p"),X.textContent=tn,Ot=n(),c(L.$$.fragment),Pt=n(),Y=p("p"),Y.innerHTML=ln,Ft=n(),D=p("p"),D.textContent=en,Kt=n(),c(q.$$.fragment),sl=n(),c(O.$$.fragment),tl=n(),P=p("p"),P.textContent=nn,ll=n(),c(F.$$.fragment),el=n(),K=p("p"),K.textContent=an,nl=n(),c(ss.$$.fragment),al=n(),ts=p("p"),ts.textContent=pn,pl=n(),ls=p("ol"),ls.innerHTML=on,ol=n(),c(es.$$.fragment),il=n(),ns=p("p"),ns.textContent=cn,cl=n(),c(as.$$.fragment),rl=n(),c(ps.$$.fragment),Ml=n(),os=p("p"),os.textContent=rn,ul=n(),c(is.$$.fragment),hl=n(),cs=p("p"),cs.textContent=Mn,yl=n(),c(rs.$$.fragment),Tl=n(),Ms=p("p"),Ms.textContent=un,ml=n(),us=p("ol"),us.innerHTML=hn,wl=n(),hs=p("p"),hs.textContent=yn,Jl=n(),ys=p("p"),ys.textContent=Tn,Ul=n(),Ts=p("ul"),Ts.innerHTML=mn,jl=n(),ms=p("p"),ms.textContent=wn,dl=n(),c(ws.$$.fragment),fl=n(),Js=p("p"),Js.textContent=Jn,bl=n(),c(C.$$.fragment),Cl=n(),Us=p("p"),Us.textContent=Un,vl=n(),c(js.$$.fragment),gl=n(),ds=p("p"),ds.textContent=jn,Il=n(),fs=p("ol"),fs.innerHTML=dn,Bl=n(),bs=p("p"),bs.textContent=fn,kl=n(),c(Cs.$$.fragment),$l=n(),vs=p("p"),vs.textContent=bn,Ql=n(),c(gs.$$.fragment),El=n(),Is=p("p"),Is.innerHTML=Cn,Sl=n(),c(Bs.$$.fragment),xl=n(),ks=p("p"),ks.innerHTML=vn,Nl=n(),c($s.$$.fragment),Gl=n(),Qs=p("p"),Qs.textContent=gn,Zl=n(),Es=p("p"),Es.textContent=In,Al=n(),d=p("video"),d.innerHTML=Bn,Wl=n(),Ss=p("p"),Ss.textContent=kn,Hl=n(),xs=p("ul"),xs.innerHTML=$n,Vl=n(),Ns=p("blockquote"),Ns.innerHTML=Qn,Rl=n(),Gs=p("p"),Gs.textContent=En,zl=n(),Zs=p("blockquote"),Zs.innerHTML=Sn,_l=n(),As=p("p"),As.textContent=xn,Xl=n(),Ws=p("blockquote"),Ws.innerHTML=Nn,Ll=n(),f=p("video"),f.innerHTML=Gn,Yl=n(),c(Hs.$$.fragment),Dl=n(),Vs=p("p"),Vs.textContent=Zn,ql=n(),Rs=p("ul"),Rs.innerHTML=An,Ol=n(),zs=p("p"),zs.textContent=Wn,Pl=n(),c(_s.$$.fragment),Fl=n(),c(Xs.$$.fragment),Kl=n(),Ls=p("p"),Ls.textContent=Hn,se=n(),Ys=p("p"),Ys.innerHTML=Vn,te=n(),Ds=p("p"),Ds.innerHTML=Rn,le=n(),c(v.$$.fragment),ee=n(),qs=p("p"),qs.innerHTML=zn,ne=n(),Os=p("ul"),Os.innerHTML=_n,ae=n(),c(Ps.$$.fragment),pe=n(),Fs=p("p"),Fs.innerHTML=Xn,oe=n(),c(Ks.$$.fragment),ie=n(),st=p("p"),st.innerHTML=Ln,ce=n(),c(tt.$$.fragment),re=n(),lt=p("p"),lt.innerHTML=Yn,Me=n(),c(et.$$.fragment),ue=n(),nt=p("p"),nt.innerHTML=Dn,he=n(),at=p("p"),at.innerHTML=qn,ye=n(),c(pt.$$.fragment),Te=n(),ot=p("p"),ot.textContent=On,me=n(),it=p("p"),it.innerHTML=Pn,we=n(),c(ct.$$.fragment),Je=n(),rt=p("p"),rt.textContent=Fn,Ue=n(),Mt=p("blockquote"),Mt.innerHTML=Kn,je=n(),ut=p("p"),ut.textContent=sa,de=n(),ht=p("ul"),ht.innerHTML=ta,fe=n(),c(g.$$.fragment),be=n(),yt=p("p"),yt.textContent=la,Ce=n(),c(Tt.$$.fragment),ve=n(),mt=p("p"),mt.innerHTML=ea,ge=n(),wt=p("p"),wt.textContent=na,Ie=n(),Jt=p("blockquote"),Jt.innerHTML=aa,Be=n(),Ut=p("p"),Ut.innerHTML=pa,ke=n(),jt=p("p"),jt.textContent=oa,$e=n(),c(dt.$$.fragment),Qe=n(),ft=p("p"),ft.textContent=ia,Ee=n(),c(bt.$$.fragment),Se=n(),Ct=p("p"),Ct.textContent=ca,xe=n(),c(vt.$$.fragment),Ne=n(),gt=p("p"),gt.textContent=ra,Ge=n(),It=p("p"),It.innerHTML=Ma,Ze=n(),Bt=p("p"),Bt.textContent=ua,Ae=n(),c(kt.$$.fragment),We=n(),c($t.$$.fragment),He=n(),Qt=p("p"),this.h()},l(s){const t=fa("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),U=a(s),m=o(s,"P",{}),ma(m).forEach(l),j=a(s),r(I.$$.fragment,s),Et=a(s),B=o(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-mukw0v"&&(B.innerHTML=_e),St=a(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-phmvzx"&&(k.textContent=Xe),xt=a(s),$=o(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1c6ln2u"&&($.innerHTML=Le),Nt=a(s),Q=o(s,"FIGCAPTION",{"data-svelte-h":!0}),i(Q)!=="svelte-1m426zi"&&(Q.textContent=Ye),Gt=a(s),r(E.$$.fragment,s),Zt=a(s),S=o(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-19rf06v"&&(S.innerHTML=De),At=a(s),r(x.$$.fragment,s),Wt=a(s),N=o(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1my26py"&&(N.innerHTML=qe),Ht=a(s),r(G.$$.fragment,s),Vt=a(s),r(Z.$$.fragment,s),Rt=a(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-9qqy0l"&&(A.textContent=Oe),zt=a(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-u3birs"&&(W.textContent=Pe),_t=a(s),r(H.$$.fragment,s),Xt=a(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-17fg1qf"&&(V.textContent=Fe),Lt=a(s),r(R.$$.fragment,s),Yt=a(s),z=o(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1rwqp6x"&&(z.textContent=Ke),Dt=a(s),_=o(s,"TABLE",{"data-svelte-h":!0}),i(_)!=="svelte-1t9o7a9"&&(_.innerHTML=sn),qt=a(s),X=o(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-kuwswp"&&(X.textContent=tn),Ot=a(s),r(L.$$.fragment,s),Pt=a(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-wmyadc"&&(Y.innerHTML=ln),Ft=a(s),D=o(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-yk7odv"&&(D.textContent=en),Kt=a(s),r(q.$$.fragment,s),sl=a(s),r(O.$$.fragment,s),tl=a(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-199v3jp"&&(P.textContent=nn),ll=a(s),r(F.$$.fragment,s),el=a(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-j3rusv"&&(K.textContent=an),nl=a(s),r(ss.$$.fragment,s),al=a(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1yuwy1b"&&(ts.textContent=pn),pl=a(s),ls=o(s,"OL",{"data-svelte-h":!0}),i(ls)!=="svelte-1bb9kd9"&&(ls.innerHTML=on),ol=a(s),r(es.$$.fragment,s),il=a(s),ns=o(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1qm1dau"&&(ns.textContent=cn),cl=a(s),r(as.$$.fragment,s),rl=a(s),r(ps.$$.fragment,s),Ml=a(s),os=o(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1s79p96"&&(os.textContent=rn),ul=a(s),r(is.$$.fragment,s),hl=a(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-7f5u21"&&(cs.textContent=Mn),yl=a(s),r(rs.$$.fragment,s),Tl=a(s),Ms=o(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1nbw8nf"&&(Ms.textContent=un),ml=a(s),us=o(s,"OL",{"data-svelte-h":!0}),i(us)!=="svelte-18hbmfi"&&(us.innerHTML=hn),wl=a(s),hs=o(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-1oh8l42"&&(hs.textContent=yn),Jl=a(s),ys=o(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-abb6o5"&&(ys.textContent=Tn),Ul=a(s),Ts=o(s,"UL",{"data-svelte-h":!0}),i(Ts)!=="svelte-vpq8ia"&&(Ts.innerHTML=mn),jl=a(s),ms=o(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-wtf0dm"&&(ms.textContent=wn),dl=a(s),r(ws.$$.fragment,s),fl=a(s),Js=o(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-1uuwta4"&&(Js.textContent=Jn),bl=a(s),r(C.$$.fragment,s),Cl=a(s),Us=o(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-37e2u8"&&(Us.textContent=Un),vl=a(s),r(js.$$.fragment,s),gl=a(s),ds=o(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-1wg0h8k"&&(ds.textContent=jn),Il=a(s),fs=o(s,"OL",{"data-svelte-h":!0}),i(fs)!=="svelte-1yzly3n"&&(fs.innerHTML=dn),Bl=a(s),bs=o(s,"P",{"data-svelte-h":!0}),i(bs)!=="svelte-5df5vh"&&(bs.textContent=fn),kl=a(s),r(Cs.$$.fragment,s),$l=a(s),vs=o(s,"P",{"data-svelte-h":!0}),i(vs)!=="svelte-1xf25zd"&&(vs.textContent=bn),Ql=a(s),r(gs.$$.fragment,s),El=a(s),Is=o(s,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-5tmxzm"&&(Is.innerHTML=Cn),Sl=a(s),r(Bs.$$.fragment,s),xl=a(s),ks=o(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-18cqmtc"&&(ks.innerHTML=vn),Nl=a(s),r($s.$$.fragment,s),Gl=a(s),Qs=o(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-1rl2uch"&&(Qs.textContent=gn),Zl=a(s),Es=o(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-6nrufp"&&(Es.textContent=In),Al=a(s),d=o(s,"VIDEO",{"data-svelte-h":!0}),i(d)!=="svelte-ydpjhx"&&(d.innerHTML=Bn),Wl=a(s),Ss=o(s,"P",{"data-svelte-h":!0}),i(Ss)!=="svelte-ue9bgn"&&(Ss.textContent=kn),Hl=a(s),xs=o(s,"UL",{"data-svelte-h":!0}),i(xs)!=="svelte-1rloo86"&&(xs.innerHTML=$n),Vl=a(s),Ns=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Ns)!=="svelte-y3cur6"&&(Ns.innerHTML=Qn),Rl=a(s),Gs=o(s,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-23qcc7"&&(Gs.textContent=En),zl=a(s),Zs=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Zs)!=="svelte-1k51xcu"&&(Zs.innerHTML=Sn),_l=a(s),As=o(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-k51lqc"&&(As.textContent=xn),Xl=a(s),Ws=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Ws)!=="svelte-1b7qxev"&&(Ws.innerHTML=Nn),Ll=a(s),f=o(s,"VIDEO",{"data-svelte-h":!0}),i(f)!=="svelte-1qpwra9"&&(f.innerHTML=Gn),Yl=a(s),r(Hs.$$.fragment,s),Dl=a(s),Vs=o(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1wjumg1"&&(Vs.textContent=Zn),ql=a(s),Rs=o(s,"UL",{"data-svelte-h":!0}),i(Rs)!=="svelte-1x6yagl"&&(Rs.innerHTML=An),Ol=a(s),zs=o(s,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-17i778z"&&(zs.textContent=Wn),Pl=a(s),r(_s.$$.fragment,s),Fl=a(s),r(Xs.$$.fragment,s),Kl=a(s),Ls=o(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-e3dhjo"&&(Ls.textContent=Hn),se=a(s),Ys=o(s,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-q9m201"&&(Ys.innerHTML=Vn),te=a(s),Ds=o(s,"P",{"data-svelte-h":!0}),i(Ds)!=="svelte-1v369pk"&&(Ds.innerHTML=Rn),le=a(s),r(v.$$.fragment,s),ee=a(s),qs=o(s,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-18fho66"&&(qs.innerHTML=zn),ne=a(s),Os=o(s,"UL",{"data-svelte-h":!0}),i(Os)!=="svelte-1x9z9xm"&&(Os.innerHTML=_n),ae=a(s),r(Ps.$$.fragment,s),pe=a(s),Fs=o(s,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-5nh0zz"&&(Fs.innerHTML=Xn),oe=a(s),r(Ks.$$.fragment,s),ie=a(s),st=o(s,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1yirw4x"&&(st.innerHTML=Ln),ce=a(s),r(tt.$$.fragment,s),re=a(s),lt=o(s,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-18597vy"&&(lt.innerHTML=Yn),Me=a(s),r(et.$$.fragment,s),ue=a(s),nt=o(s,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-1xix0ot"&&(nt.innerHTML=Dn),he=a(s),at=o(s,"P",{"data-svelte-h":!0}),i(at)!=="svelte-u42pzw"&&(at.innerHTML=qn),ye=a(s),r(pt.$$.fragment,s),Te=a(s),ot=o(s,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-1998omk"&&(ot.textContent=On),me=a(s),it=o(s,"P",{"data-svelte-h":!0}),i(it)!=="svelte-194evwg"&&(it.innerHTML=Pn),we=a(s),r(ct.$$.fragment,s),Je=a(s),rt=o(s,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-h6518d"&&(rt.textContent=Fn),Ue=a(s),Mt=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Mt)!=="svelte-16vx3n0"&&(Mt.innerHTML=Kn),je=a(s),ut=o(s,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-1n2s2to"&&(ut.textContent=sa),de=a(s),ht=o(s,"UL",{"data-svelte-h":!0}),i(ht)!=="svelte-nu71gr"&&(ht.innerHTML=ta),fe=a(s),r(g.$$.fragment,s),be=a(s),yt=o(s,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-1sf2rot"&&(yt.textContent=la),Ce=a(s),r(Tt.$$.fragment,s),ve=a(s),mt=o(s,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-13kag1j"&&(mt.innerHTML=ea),ge=a(s),wt=o(s,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-d6h472"&&(wt.textContent=na),Ie=a(s),Jt=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Jt)!=="svelte-1rrcz4w"&&(Jt.innerHTML=aa),Be=a(s),Ut=o(s,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-1tygypt"&&(Ut.innerHTML=pa),ke=a(s),jt=o(s,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-10s8lyx"&&(jt.textContent=oa),$e=a(s),r(dt.$$.fragment,s),Qe=a(s),ft=o(s,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-og177e"&&(ft.textContent=ia),Ee=a(s),r(bt.$$.fragment,s),Se=a(s),Ct=o(s,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-1hidx2u"&&(Ct.textContent=ca),xe=a(s),r(vt.$$.fragment,s),Ne=a(s),gt=o(s,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-1x1f68r"&&(gt.textContent=ra),Ge=a(s),It=o(s,"P",{"data-svelte-h":!0}),i(It)!=="svelte-18vkmid"&&(It.innerHTML=Ma),Ze=a(s),Bt=o(s,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-51qcy5"&&(Bt.textContent=ua),Ae=a(s),r(kt.$$.fragment,s),We=a(s),r($t.$$.fragment,s),He=a(s),Qt=o(s,"P",{}),ma(Qt).forEach(l),this.h()},h(){wa(T,"name","hf:doc:metadata"),wa(T,"content",ka),d.controls="",d.autoplay="",d.loop="",f.controls="",f.autoplay="",f.loop=""},m(s,t){ba(document.head,T),e(s,U,t),e(s,m,t),e(s,j,t),M(I,s,t),e(s,Et,t),e(s,B,t),e(s,St,t),e(s,k,t),e(s,xt,t),e(s,$,t),e(s,Nt,t),e(s,Q,t),e(s,Gt,t),M(E,s,t),e(s,Zt,t),e(s,S,t),e(s,At,t),M(x,s,t),e(s,Wt,t),e(s,N,t),e(s,Ht,t),M(G,s,t),e(s,Vt,t),M(Z,s,t),e(s,Rt,t),e(s,A,t),e(s,zt,t),e(s,W,t),e(s,_t,t),M(H,s,t),e(s,Xt,t),e(s,V,t),e(s,Lt,t),M(R,s,t),e(s,Yt,t),e(s,z,t),e(s,Dt,t),e(s,_,t),e(s,qt,t),e(s,X,t),e(s,Ot,t),M(L,s,t),e(s,Pt,t),e(s,Y,t),e(s,Ft,t),e(s,D,t),e(s,Kt,t),M(q,s,t),e(s,sl,t),M(O,s,t),e(s,tl,t),e(s,P,t),e(s,ll,t),M(F,s,t),e(s,el,t),e(s,K,t),e(s,nl,t),M(ss,s,t),e(s,al,t),e(s,ts,t),e(s,pl,t),e(s,ls,t),e(s,ol,t),M(es,s,t),e(s,il,t),e(s,ns,t),e(s,cl,t),M(as,s,t),e(s,rl,t),M(ps,s,t),e(s,Ml,t),e(s,os,t),e(s,ul,t),M(is,s,t),e(s,hl,t),e(s,cs,t),e(s,yl,t),M(rs,s,t),e(s,Tl,t),e(s,Ms,t),e(s,ml,t),e(s,us,t),e(s,wl,t),e(s,hs,t),e(s,Jl,t),e(s,ys,t),e(s,Ul,t),e(s,Ts,t),e(s,jl,t),e(s,ms,t),e(s,dl,t),M(ws,s,t),e(s,fl,t),e(s,Js,t),e(s,bl,t),M(C,s,t),e(s,Cl,t),e(s,Us,t),e(s,vl,t),M(js,s,t),e(s,gl,t),e(s,ds,t),e(s,Il,t),e(s,fs,t),e(s,Bl,t),e(s,bs,t),e(s,kl,t),M(Cs,s,t),e(s,$l,t),e(s,vs,t),e(s,Ql,t),M(gs,s,t),e(s,El,t),e(s,Is,t),e(s,Sl,t),M(Bs,s,t),e(s,xl,t),e(s,ks,t),e(s,Nl,t),M($s,s,t),e(s,Gl,t),e(s,Qs,t),e(s,Zl,t),e(s,Es,t),e(s,Al,t),e(s,d,t),e(s,Wl,t),e(s,Ss,t),e(s,Hl,t),e(s,xs,t),e(s,Vl,t),e(s,Ns,t),e(s,Rl,t),e(s,Gs,t),e(s,zl,t),e(s,Zs,t),e(s,_l,t),e(s,As,t),e(s,Xl,t),e(s,Ws,t),e(s,Ll,t),e(s,f,t),e(s,Yl,t),M(Hs,s,t),e(s,Dl,t),e(s,Vs,t),e(s,ql,t),e(s,Rs,t),e(s,Ol,t),e(s,zs,t),e(s,Pl,t),M(_s,s,t),e(s,Fl,t),M(Xs,s,t),e(s,Kl,t),e(s,Ls,t),e(s,se,t),e(s,Ys,t),e(s,te,t),e(s,Ds,t),e(s,le,t),M(v,s,t),e(s,ee,t),e(s,qs,t),e(s,ne,t),e(s,Os,t),e(s,ae,t),M(Ps,s,t),e(s,pe,t),e(s,Fs,t),e(s,oe,t),M(Ks,s,t),e(s,ie,t),e(s,st,t),e(s,ce,t),M(tt,s,t),e(s,re,t),e(s,lt,t),e(s,Me,t),M(et,s,t),e(s,ue,t),e(s,nt,t),e(s,he,t),e(s,at,t),e(s,ye,t),M(pt,s,t),e(s,Te,t),e(s,ot,t),e(s,me,t),e(s,it,t),e(s,we,t),M(ct,s,t),e(s,Je,t),e(s,rt,t),e(s,Ue,t),e(s,Mt,t),e(s,je,t),e(s,ut,t),e(s,de,t),e(s,ht,t),e(s,fe,t),M(g,s,t),e(s,be,t),e(s,yt,t),e(s,Ce,t),M(Tt,s,t),e(s,ve,t),e(s,mt,t),e(s,ge,t),e(s,wt,t),e(s,Ie,t),e(s,Jt,t),e(s,Be,t),e(s,Ut,t),e(s,ke,t),e(s,jt,t),e(s,$e,t),M(dt,s,t),e(s,Qe,t),e(s,ft,t),e(s,Ee,t),M(bt,s,t),e(s,Se,t),e(s,Ct,t),e(s,xe,t),M(vt,s,t),e(s,Ne,t),e(s,gt,t),e(s,Ge,t),e(s,It,t),e(s,Ze,t),e(s,Bt,t),e(s,Ae,t),M(kt,s,t),e(s,We,t),M($t,s,t),e(s,He,t),e(s,Qt,t),Ve=!0},p(s,[t]){const ha={};t&2&&(ha.$$scope={dirty:t,ctx:s}),C.$set(ha);const ya={};t&2&&(ya.$$scope={dirty:t,ctx:s}),v.$set(ya);const Ta={};t&2&&(Ta.$$scope={dirty:t,ctx:s}),g.$set(Ta)},i(s){Ve||(u(I.$$.fragment,s),u(E.$$.fragment,s),u(x.$$.fragment,s),u(G.$$.fragment,s),u(Z.$$.fragment,s),u(H.$$.fragment,s),u(R.$$.fragment,s),u(L.$$.fragment,s),u(q.$$.fragment,s),u(O.$$.fragment,s),u(F.$$.fragment,s),u(ss.$$.fragment,s),u(es.$$.fragment,s),u(as.$$.fragment,s),u(ps.$$.fragment,s),u(is.$$.fragment,s),u(rs.$$.fragment,s),u(ws.$$.fragment,s),u(C.$$.fragment,s),u(js.$$.fragment,s),u(Cs.$$.fragment,s),u(gs.$$.fragment,s),u(Bs.$$.fragment,s),u($s.$$.fragment,s),u(Hs.$$.fragment,s),u(_s.$$.fragment,s),u(Xs.$$.fragment,s),u(v.$$.fragment,s),u(Ps.$$.fragment,s),u(Ks.$$.fragment,s),u(tt.$$.fragment,s),u(et.$$.fragment,s),u(pt.$$.fragment,s),u(ct.$$.fragment,s),u(g.$$.fragment,s),u(Tt.$$.fragment,s),u(dt.$$.fragment,s),u(bt.$$.fragment,s),u(vt.$$.fragment,s),u(kt.$$.fragment,s),u($t.$$.fragment,s),Ve=!0)},o(s){h(I.$$.fragment,s),h(E.$$.fragment,s),h(x.$$.fragment,s),h(G.$$.fragment,s),h(Z.$$.fragment,s),h(H.$$.fragment,s),h(R.$$.fragment,s),h(L.$$.fragment,s),h(q.$$.fragment,s),h(O.$$.fragment,s),h(F.$$.fragment,s),h(ss.$$.fragment,s),h(es.$$.fragment,s),h(as.$$.fragment,s),h(ps.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(ws.$$.fragment,s),h(C.$$.fragment,s),h(js.$$.fragment,s),h(Cs.$$.fragment,s),h(gs.$$.fragment,s),h(Bs.$$.fragment,s),h($s.$$.fragment,s),h(Hs.$$.fragment,s),h(_s.$$.fragment,s),h(Xs.$$.fragment,s),h(v.$$.fragment,s),h(Ps.$$.fragment,s),h(Ks.$$.fragment,s),h(tt.$$.fragment,s),h(et.$$.fragment,s),h(pt.$$.fragment,s),h(ct.$$.fragment,s),h(g.$$.fragment,s),h(Tt.$$.fragment,s),h(dt.$$.fragment,s),h(bt.$$.fragment,s),h(vt.$$.fragment,s),h(kt.$$.fragment,s),h($t.$$.fragment,s),Ve=!1},d(s){s&&(l(U),l(m),l(j),l(Et),l(B),l(St),l(k),l(xt),l($),l(Nt),l(Q),l(Gt),l(Zt),l(S),l(At),l(Wt),l(N),l(Ht),l(Vt),l(Rt),l(A),l(zt),l(W),l(_t),l(Xt),l(V),l(Lt),l(Yt),l(z),l(Dt),l(_),l(qt),l(X),l(Ot),l(Pt),l(Y),l(Ft),l(D),l(Kt),l(sl),l(tl),l(P),l(ll),l(el),l(K),l(nl),l(al),l(ts),l(pl),l(ls),l(ol),l(il),l(ns),l(cl),l(rl),l(Ml),l(os),l(ul),l(hl),l(cs),l(yl),l(Tl),l(Ms),l(ml),l(us),l(wl),l(hs),l(Jl),l(ys),l(Ul),l(Ts),l(jl),l(ms),l(dl),l(fl),l(Js),l(bl),l(Cl),l(Us),l(vl),l(gl),l(ds),l(Il),l(fs),l(Bl),l(bs),l(kl),l($l),l(vs),l(Ql),l(El),l(Is),l(Sl),l(xl),l(ks),l(Nl),l(Gl),l(Qs),l(Zl),l(Es),l(Al),l(d),l(Wl),l(Ss),l(Hl),l(xs),l(Vl),l(Ns),l(Rl),l(Gs),l(zl),l(Zs),l(_l),l(As),l(Xl),l(Ws),l(Ll),l(f),l(Yl),l(Dl),l(Vs),l(ql),l(Rs),l(Ol),l(zs),l(Pl),l(Fl),l(Kl),l(Ls),l(se),l(Ys),l(te),l(Ds),l(le),l(ee),l(qs),l(ne),l(Os),l(ae),l(pe),l(Fs),l(oe),l(ie),l(st),l(ce),l(re),l(lt),l(Me),l(ue),l(nt),l(he),l(at),l(ye),l(Te),l(ot),l(me),l(it),l(we),l(Je),l(rt),l(Ue),l(Mt),l(je),l(ut),l(de),l(ht),l(fe),l(be),l(yt),l(Ce),l(ve),l(mt),l(ge),l(wt),l(Ie),l(Jt),l(Be),l(Ut),l(ke),l(jt),l($e),l(Qe),l(ft),l(Ee),l(Se),l(Ct),l(xe),l(Ne),l(gt),l(Ge),l(It),l(Ze),l(Bt),l(Ae),l(We),l(He),l(Qt)),l(T),y(I,s),y(E,s),y(x,s),y(G,s),y(Z,s),y(H,s),y(R,s),y(L,s),y(q,s),y(O,s),y(F,s),y(ss,s),y(es,s),y(as,s),y(ps,s),y(is,s),y(rs,s),y(ws,s),y(C,s),y(js,s),y(Cs,s),y(gs,s),y(Bs,s),y($s,s),y(Hs,s),y(_s,s),y(Xs,s),y(v,s),y(Ps,s),y(Ks,s),y(tt,s),y(et,s),y(pt,s),y(ct,s),y(g,s),y(Tt,s),y(dt,s),y(bt,s),y(vt,s),y(kt,s),y($t,s)}}}const ka='{"title":"Tiny Agents: an MCP-powered agent in 50 lines of code","local":"tiny-agents-an-mcp-powered-agent-in-50-lines-of-code","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Tiny Agents MCP Client in the Command Line","local":"tiny-agents-mcp-client-in-the-command-line","sections":[],"depth":2},{"title":"Custom Tiny Agents MCP Client","local":"custom-tiny-agents-mcp-client","sections":[{"title":"Using the Gradio Server with Tiny Agents","local":"using-the-gradio-server-with-tiny-agents","sections":[],"depth":3},{"title":"Example Interaction","local":"example-interaction","sections":[],"depth":3},{"title":"Deployment Considerations","local":"deployment-considerations","sections":[],"depth":3}],"depth":2},{"title":"Conclusion: Our Complete End-to-End MCP Application","local":"conclusion-our-complete-end-to-end-mcp-application","sections":[],"depth":2},{"title":"Bonus: Build a Browser Automation MCP Server with Playwright","local":"bonus-build-a-browser-automation-mcp-server-with-playwright","sections":[],"depth":2},{"title":"How to run the complete demo","local":"how-to-run-the-complete-demo","sections":[{"title":"Default model and provider","local":"default-model-and-provider","sections":[],"depth":3}],"depth":2},{"title":"Implementing an MCP client on top of InferenceClient","local":"implementing-an-mcp-client-on-top-of-inferenceclient","sections":[{"title":"How to use the tools","local":"how-to-use-the-tools","sections":[],"depth":3}],"depth":2},{"title":"Our 50-lines-of-code Agent 🤯","local":"our-50-lines-of-code-agent-","sections":[{"title":"The complete while loop","local":"the-complete-while-loop","sections":[],"depth":3}],"depth":2}],"depth":1}';function $a(b){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ga extends ja{constructor(T){super(),da(this,T,$a,Ba,Ja,{})}}export{Ga as component};
