import{s as Pt,o as Dt,n as Je}from"../chunks/scheduler.8c3d61f6.js";import{S as Kt,i as Ot,g as o,s as a,r as u,A as el,h as r,f as l,c as i,j as Lt,u as d,x as m,k as qt,y as tl,a as s,v as M,d as y,t as h,w}from"../chunks/index.da70eac4.js";import{T as we}from"../chunks/Tip.1d9b8c37.js";import{C as I}from"../chunks/CodeBlock.00a903b3.js";import{H as v,E as ll}from"../chunks/EditOnGithub.1e64e623.js";function sl(U){let n,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-15lbm2y"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function nl(U){let n,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1yyrc0t"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function al(U){let n,J='When using <a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,b='<a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=b},l(f){n=r(f,"P",{"data-svelte-h":!0}),m(n)!=="svelte-262h9v"&&(n.innerHTML=J),p=i(f),c=r(f,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1p9u9ba"&&(c.innerHTML=b)},m(f,T){s(f,n,T),s(f,p,T),s(f,c,T)},p:Je,d(f){f&&(l(n),l(p),l(c))}}}function il(U){let n,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1guxtqy"&&(n.textContent=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function pl(U){let n,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',p,c,b='<a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=b},l(f){n=r(f,"P",{"data-svelte-h":!0}),m(n)!=="svelte-bljvwk"&&(n.innerHTML=J),p=i(f),c=r(f,"P",{"data-svelte-h":!0}),m(c)!=="svelte-sxd602"&&(c.innerHTML=b)},m(f,T){s(f,n,T),s(f,p,T),s(f,c,T)},p:Je,d(f){f&&(l(n),l(p),l(c))}}}function ol(U){let n,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17vr965"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function rl(U){let n,J,p,c,b,f,T,yt="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Ue,j,be,$,ht="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",je,G,wt="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ze,W,Ce,V,Jt='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/pr_6247/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',_e,R,Tt='To use sliced VAE, call <a href="/docs/diffusers/pr_6247/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',Be,k,ge,S,Ut="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Ie,X,ve,E,bt='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/pr_6247/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',$e,N,jt='To use tiled VAE processing, call <a href="/docs/diffusers/pr_6247/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Ge,Y,We,x,Zt="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Ve,Q,Re,H,Ct="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",ke,z,_t='To perform CPU offloading, call <a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Se,A,Xe,F,Bt="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Ee,Z,Ne,C,Ye,L,xe,_,Qe,q,gt='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',He,P,It="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",ze,D,vt=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,Ae,K,$t='Enable model offloading by calling <a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Fe,O,Le,B,qe,ee,Pe,te,Gt="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",De,le,Wt="For example, to set the pipeline’s UNet to use the channels-last format:",Ke,se,Oe,ne,et,ae,Vt="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",tt,ie,Rt="To trace a UNet:",lt,pe,st,oe,kt="Replace the <code>unet</code> attribute of the pipeline with the traced model:",nt,re,at,me,it,ce,St='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',pt,g,ot,fe,Xt="To use Flash Attention, install the following:",rt,ue,Et='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',mt,de,Nt='Then call <a href="/docs/diffusers/pr_6247/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',ct,Me,ft,ye,Yt='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',ut,he,dt,Te,Mt;return b=new v({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),j=new we({props:{$$slots:{default:[sl]},$$scope:{ctx:U}}}),W=new v({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),k=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUyM3BpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAzMikuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),X=new v({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),Y=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBiZWF1dGlmdWwlMjBsYW5kc2NhcGUlMjBwaG90b2dyYXBoJTIyJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMkMlMjB3aWR0aCUzRDM4NDAlMkMlMjBoZWlnaHQlM0QyMjI0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Q=new v({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),A=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new we({props:{$$slots:{default:[nl]},$$scope:{ctx:U}}}),C=new we({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:U}}}),L=new v({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),_=new we({props:{$$slots:{default:[il]},$$scope:{ctx:U}}}),O=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new we({props:{warning:!0,$$slots:{default:[pl]},$$scope:{ctx:U}}}),ee=new v({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),se=new I({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ne=new v({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),pe=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),re=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjB1c2UlMjBqaXR0ZWQlMjB1bmV0JTBBdW5ldF90cmFjZWQlMjAlM0QlMjB0b3JjaC5qaXQubG9hZCglMjJ1bmV0X3RyYWNlZC5wdCUyMiklMEElMEElMEElMjMlMjBkZWwlMjBwaXBlLnVuZXQlMEFjbGFzcyUyMFRyYWNlZFVOZXQodG9yY2gubm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbl9jaGFubmVscyUyMCUzRCUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRldmljZSUyMCUzRCUyMHBpcGUudW5ldC5kZXZpY2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHVuZXRfdHJhY2VkKGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFVOZXQyRENvbmRpdGlvbk91dHB1dChzYW1wbGUlM0RzYW1wbGUpJTBBJTBBJTBBcGlwZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),me=new v({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),g=new we({props:{$$slots:{default:[ol]},$$scope:{ctx:U}}}),Me=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwcGlwZSglMjJhJTIwc21hbGwlMjBjYXQlMjIpJTBBJTBBJTIzJTIwb3B0aW9uYWwlM0ElMjBZb3UlMjBjYW4lMjBkaXNhYmxlJTIwaXQlMjB2aWElMEElMjMlMjBwaXBlLmRpc2FibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),he=new ll({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){n=o("meta"),J=a(),p=o("p"),c=a(),u(b.$$.fragment),f=a(),T=o("p"),T.textContent=yt,Ue=a(),u(j.$$.fragment),be=a(),$=o("p"),$.textContent=ht,je=a(),G=o("table"),G.innerHTML=wt,Ze=a(),u(W.$$.fragment),Ce=a(),V=o("p"),V.innerHTML=Jt,_e=a(),R=o("p"),R.innerHTML=Tt,Be=a(),u(k.$$.fragment),ge=a(),S=o("p"),S.textContent=Ut,Ie=a(),u(X.$$.fragment),ve=a(),E=o("p"),E.innerHTML=bt,$e=a(),N=o("p"),N.innerHTML=jt,Ge=a(),u(Y.$$.fragment),We=a(),x=o("p"),x.textContent=Zt,Ve=a(),u(Q.$$.fragment),Re=a(),H=o("p"),H.textContent=Ct,ke=a(),z=o("p"),z.innerHTML=_t,Se=a(),u(A.$$.fragment),Xe=a(),F=o("p"),F.innerHTML=Bt,Ee=a(),u(Z.$$.fragment),Ne=a(),u(C.$$.fragment),Ye=a(),u(L.$$.fragment),xe=a(),u(_.$$.fragment),Qe=a(),q=o("p"),q.innerHTML=gt,He=a(),P=o("p"),P.innerHTML=It,ze=a(),D=o("p"),D.textContent=vt,Ae=a(),K=o("p"),K.innerHTML=$t,Fe=a(),u(O.$$.fragment),Le=a(),u(B.$$.fragment),qe=a(),u(ee.$$.fragment),Pe=a(),te=o("p"),te.textContent=Gt,De=a(),le=o("p"),le.textContent=Wt,Ke=a(),u(se.$$.fragment),Oe=a(),u(ne.$$.fragment),et=a(),ae=o("p"),ae.innerHTML=Vt,tt=a(),ie=o("p"),ie.textContent=Rt,lt=a(),u(pe.$$.fragment),st=a(),oe=o("p"),oe.innerHTML=kt,nt=a(),u(re.$$.fragment),at=a(),u(me.$$.fragment),it=a(),ce=o("p"),ce.innerHTML=St,pt=a(),u(g.$$.fragment),ot=a(),fe=o("p"),fe.textContent=Xt,rt=a(),ue=o("ul"),ue.innerHTML=Et,mt=a(),de=o("p"),de.innerHTML=Nt,ct=a(),u(Me.$$.fragment),ft=a(),ye=o("p"),ye.innerHTML=Yt,ut=a(),u(he.$$.fragment),dt=a(),Te=o("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);n=r(t,"META",{name:!0,content:!0}),t.forEach(l),J=i(e),p=r(e,"P",{}),Lt(p).forEach(l),c=i(e),d(b.$$.fragment,e),f=i(e),T=r(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-18ag1qn"&&(T.textContent=yt),Ue=i(e),d(j.$$.fragment,e),be=i(e),$=r(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1nfsyhf"&&($.textContent=ht),je=i(e),G=r(e,"TABLE",{"data-svelte-h":!0}),m(G)!=="svelte-qiiy0g"&&(G.innerHTML=wt),Ze=i(e),d(W.$$.fragment,e),Ce=i(e),V=r(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-16no1o1"&&(V.innerHTML=Jt),_e=i(e),R=r(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-j9hvrj"&&(R.innerHTML=Tt),Be=i(e),d(k.$$.fragment,e),ge=i(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-fte8mn"&&(S.textContent=Ut),Ie=i(e),d(X.$$.fragment,e),ve=i(e),E=r(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1uoja7c"&&(E.innerHTML=bt),$e=i(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-107mow1"&&(N.innerHTML=jt),Ge=i(e),d(Y.$$.fragment,e),We=i(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-nyzaca"&&(x.textContent=Zt),Ve=i(e),d(Q.$$.fragment,e),Re=i(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-435lli"&&(H.textContent=Ct),ke=i(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1c9alxm"&&(z.innerHTML=_t),Se=i(e),d(A.$$.fragment,e),Xe=i(e),F=r(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-153k8wf"&&(F.innerHTML=Bt),Ee=i(e),d(Z.$$.fragment,e),Ne=i(e),d(C.$$.fragment,e),Ye=i(e),d(L.$$.fragment,e),xe=i(e),d(_.$$.fragment,e),Qe=i(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1w0xgx8"&&(q.innerHTML=gt),He=i(e),P=r(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-nislc4"&&(P.innerHTML=It),ze=i(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-11gjm3"&&(D.textContent=vt),Ae=i(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-l3axr3"&&(K.innerHTML=$t),Fe=i(e),d(O.$$.fragment,e),Le=i(e),d(B.$$.fragment,e),qe=i(e),d(ee.$$.fragment,e),Pe=i(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-sky5la"&&(te.textContent=Gt),De=i(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-mhdc10"&&(le.textContent=Wt),Ke=i(e),d(se.$$.fragment,e),Oe=i(e),d(ne.$$.fragment,e),et=i(e),ae=r(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1hj6sqj"&&(ae.innerHTML=Vt),tt=i(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1ca1ko1"&&(ie.textContent=Rt),lt=i(e),d(pe.$$.fragment,e),st=i(e),oe=r(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-mpebhd"&&(oe.innerHTML=kt),nt=i(e),d(re.$$.fragment,e),at=i(e),d(me.$$.fragment,e),it=i(e),ce=r(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1tu2ji2"&&(ce.innerHTML=St),pt=i(e),d(g.$$.fragment,e),ot=i(e),fe=r(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-rpfoyf"&&(fe.textContent=Xt),rt=i(e),ue=r(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-1q6gndt"&&(ue.innerHTML=Et),mt=i(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-kvr44k"&&(de.innerHTML=Nt),ct=i(e),d(Me.$$.fragment,e),ft=i(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1nf2kxh"&&(ye.innerHTML=Yt),ut=i(e),d(he.$$.fragment,e),dt=i(e),Te=r(e,"P",{}),Lt(Te).forEach(l),this.h()},h(){qt(n,"name","hf:doc:metadata"),qt(n,"content",ml)},m(e,t){tl(document.head,n),s(e,J,t),s(e,p,t),s(e,c,t),M(b,e,t),s(e,f,t),s(e,T,t),s(e,Ue,t),M(j,e,t),s(e,be,t),s(e,$,t),s(e,je,t),s(e,G,t),s(e,Ze,t),M(W,e,t),s(e,Ce,t),s(e,V,t),s(e,_e,t),s(e,R,t),s(e,Be,t),M(k,e,t),s(e,ge,t),s(e,S,t),s(e,Ie,t),M(X,e,t),s(e,ve,t),s(e,E,t),s(e,$e,t),s(e,N,t),s(e,Ge,t),M(Y,e,t),s(e,We,t),s(e,x,t),s(e,Ve,t),M(Q,e,t),s(e,Re,t),s(e,H,t),s(e,ke,t),s(e,z,t),s(e,Se,t),M(A,e,t),s(e,Xe,t),s(e,F,t),s(e,Ee,t),M(Z,e,t),s(e,Ne,t),M(C,e,t),s(e,Ye,t),M(L,e,t),s(e,xe,t),M(_,e,t),s(e,Qe,t),s(e,q,t),s(e,He,t),s(e,P,t),s(e,ze,t),s(e,D,t),s(e,Ae,t),s(e,K,t),s(e,Fe,t),M(O,e,t),s(e,Le,t),M(B,e,t),s(e,qe,t),M(ee,e,t),s(e,Pe,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Ke,t),M(se,e,t),s(e,Oe,t),M(ne,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,ie,t),s(e,lt,t),M(pe,e,t),s(e,st,t),s(e,oe,t),s(e,nt,t),M(re,e,t),s(e,at,t),M(me,e,t),s(e,it,t),s(e,ce,t),s(e,pt,t),M(g,e,t),s(e,ot,t),s(e,fe,t),s(e,rt,t),s(e,ue,t),s(e,mt,t),s(e,de,t),s(e,ct,t),M(Me,e,t),s(e,ft,t),s(e,ye,t),s(e,ut,t),M(he,e,t),s(e,dt,t),s(e,Te,t),Mt=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),j.$set(xt);const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),Z.$set(Qt);const Ht={};t&2&&(Ht.$$scope={dirty:t,ctx:e}),C.$set(Ht);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),_.$set(zt);const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),B.$set(At);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),g.$set(Ft)},i(e){Mt||(y(b.$$.fragment,e),y(j.$$.fragment,e),y(W.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(Z.$$.fragment,e),y(C.$$.fragment,e),y(L.$$.fragment,e),y(_.$$.fragment,e),y(O.$$.fragment,e),y(B.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(me.$$.fragment,e),y(g.$$.fragment,e),y(Me.$$.fragment,e),y(he.$$.fragment,e),Mt=!0)},o(e){h(b.$$.fragment,e),h(j.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(_.$$.fragment,e),h(O.$$.fragment,e),h(B.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(g.$$.fragment,e),h(Me.$$.fragment,e),h(he.$$.fragment,e),Mt=!1},d(e){e&&(l(J),l(p),l(c),l(f),l(T),l(Ue),l(be),l($),l(je),l(G),l(Ze),l(Ce),l(V),l(_e),l(R),l(Be),l(ge),l(S),l(Ie),l(ve),l(E),l($e),l(N),l(Ge),l(We),l(x),l(Ve),l(Re),l(H),l(ke),l(z),l(Se),l(Xe),l(F),l(Ee),l(Ne),l(Ye),l(xe),l(Qe),l(q),l(He),l(P),l(ze),l(D),l(Ae),l(K),l(Fe),l(Le),l(qe),l(Pe),l(te),l(De),l(le),l(Ke),l(Oe),l(et),l(ae),l(tt),l(ie),l(lt),l(st),l(oe),l(nt),l(at),l(it),l(ce),l(pt),l(ot),l(fe),l(rt),l(ue),l(mt),l(de),l(ct),l(ft),l(ye),l(ut),l(dt),l(Te)),l(n),w(b,e),w(j,e),w(W,e),w(k,e),w(X,e),w(Y,e),w(Q,e),w(A,e),w(Z,e),w(C,e),w(L,e),w(_,e),w(O,e),w(B,e),w(ee,e),w(se,e),w(ne,e),w(pe,e),w(re,e),w(me,e),w(g,e),w(Me,e),w(he,e)}}}const ml='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function cl(U){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Kt{constructor(n){super(),Ot(this,n,cl,rl,Pt,{})}}export{hl as component};
