import{s as Yt,o as $t,n as Bt}from"../chunks/scheduler.8c3d61f6.js";import{S as Vt,i as Xt,g as a,s as i,r as f,A as Dt,h as l,f as n,c as o,j as W,u,x as c,k as B,y as p,a as s,v as h,d as g,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as Nt}from"../chunks/Tip.1d9b8c37.js";import{D as ye}from"../chunks/Docstring.6b390b9a.js";import{C as Ke}from"../chunks/CodeBlock.00a903b3.js";import{E as zt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as be,E as Pt}from"../chunks/EditOnGithub.1e64e623.js";function Ht(ce){let r,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=a("p"),r.innerHTML=J},l(M){r=l(M,"P",{"data-svelte-h":!0}),c(r)!=="svelte-w7r39y"&&(r.innerHTML=J)},m(M,w){s(M,r,w)},p:Bt,d(M){M&&n(r)}}}function Rt(ce){let r,J="Examples:",M,w,v;return w=new Ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines.consisid.util_consisid <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = (
<span class="hljs-meta">... </span>    prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A woman adorned with a delicate flower crown, is standing amidst a field of gently swaying wildflowers. Her eyes sparkle with a serene gaze, and a faint smile graces her lips, suggesting a moment of peaceful contentment. The shot is framed from the waist up, highlighting the gentle breeze lightly tousling her hair. The background reveals an expansive meadow under a bright blue sky, capturing the tranquility of a sunny afternoon.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/1.png?raw=true&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(
<span class="hljs-meta">... </span>    face_helper_1,
<span class="hljs-meta">... </span>    face_clip_model,
<span class="hljs-meta">... </span>    face_helper_2,
<span class="hljs-meta">... </span>    eva_transform_mean,
<span class="hljs-meta">... </span>    eva_transform_std,
<span class="hljs-meta">... </span>    face_main_model,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    torch.bfloat16,
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    is_align_face=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_kps = <span class="hljs-built_in">getattr</span>(pipe.transformer.config, <span class="hljs-string">&quot;is_kps&quot;</span>, <span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>kps_cond = face_kps <span class="hljs-keyword">if</span> is_kps <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    use_dynamic_cfg=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    id_vit_hidden=id_vit_hidden,
<span class="hljs-meta">... </span>    id_cond=id_cond,
<span class="hljs-meta">... </span>    kps_cond=kps_cond,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){r=a("p"),r.textContent=J,M=i(),f(w.$$.fragment)},l(d){r=l(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-kvfsh7"&&(r.textContent=J),M=o(d),u(w.$$.fragment,d)},m(d,T){s(d,r,T),s(d,M,T),h(w,d,T),v=!0},p:Bt,i(d){v||(g(w.$$.fragment,d),v=!0)},o(d){_(w.$$.fragment,d),v=!1},d(d){d&&(n(r),n(M)),y(w,d)}}}function Ft(ce){let r,J,M,w,v,d,T,mt='<a href="https://arxiv.org/abs/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> from Peking University &amp; University of Rochester &amp; etc, by Shenghai Yuan, Jinfa Huang, Xianyi He, Yunyang Ge, Yujun Shi, Liuhan Chen, Jiebo Luo, Li Yuan.',we,Y,ft="The abstract from the paper is:",ve,$,ut='<em>Identity-preserving text-to-video (IPT2V) generation aims to create high-fidelity videos with consistent human identity. It is an important task in video generation but remains an open problem for generative models. This paper pushes the technical frontier of IPT2V in two directions that have not been resolved in the literature: (1) A tuning-free pipeline without tedious case-by-case finetuning, and (2) A frequency-aware heuristic identity-preserving Diffusion Transformer (DiT)-based control scheme. To achieve these goals, we propose <strong>ConsisID</strong>, a tuning-free DiT-based controllable IPT2V model to keep human-<strong>id</strong>entity <strong>consis</strong>tent in the generated video. Inspired by prior findings in frequency analysis of vision/diffusion transformers, it employs identity-control signals in the frequency domain, where facial features can be decomposed into low-frequency global features (e.g., profile, proportions) and high-frequency intrinsic features (e.g., identity markers that remain unaffected by pose changes). First, from a low-frequency perspective, we introduce a global facial extractor, which encodes the reference image and facial key points into a latent space, generating features enriched with low-frequency information. These features are then integrated into the shallow layers of the network to alleviate training challenges associated with DiT. Second, from a high-frequency perspective, we design a local facial extractor to capture high-frequency details and inject them into the transformer blocks, enhancing the model’s ability to preserve fine-grained features. To leverage the frequency information for identity preservation, we propose a hierarchical training strategy, transforming a vanilla pre-trained video generation model into an IPT2V model. Extensive experiments demonstrate that our frequency-aware heuristic scheme provides an optimal control solution for DiT-based models. Thanks to this scheme, our <strong>ConsisID</strong> achieves excellent results in generating high-quality, identity-preserving videos, making strides towards more effective IPT2V. The model weight of ConsID is publicly available at <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">https://github.com/PKU-YuanGroup/ConsisID</a>.</em>',Te,j,Je,V,ht='This pipeline was contributed by <a href="https://github.com/SHYuanBest" rel="nofollow">SHYuanBest</a>. The original codebase can be found <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/BestWishYsh" rel="nofollow">hf.co/BestWishYsh</a>.',Ie,X,gt="There are two official ConsisID checkpoints for identity-preserving text-to-video.",Ze,D,_t='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-preview</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-1.5</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',Ue,N,je,z,yt='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',Ce,P,bt="First, load the pipeline:",ke,H,xe,R,Mt="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",Ge,F,We,Q,wt="Compile the components and run inference:",Be,E,Ye,L,$e,q,vt='ConsisID requires about 37 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',Ve,S,Tt="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.enable_sequential_cpu_offload()</code>:<ul><li>Similar to <code>enable_model_cpu_offload</code> but can significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>4 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",Xe,A,De,O,Jt='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> and <a href="https://github.com/huggingface/optimum-quanto/" rel="nofollow">optimum-quanto</a> can be used to quantize the text encoder, transformer and VAE modules to lower the memory requirements. This makes it possible to run the model on a free-tier T4 Colab or lower VRAM GPUs!',Ne,K,It='It is also worth noting that torchao quantization is fully compatible with <a href="/optimization/torch2.0#torchcompile">torch.compile</a>, which allows for much faster inference speed. Additionally, models can be serialized and stored in a quantized datatype to save disk space with torchao. Find examples and benchmarks in the gists below.',ze,ee,Zt='<li><a href="https://gist.github.com/a-r-r-o-w/4d9732d17412888c885480c6521a9897" rel="nofollow">torchao</a></li> <li><a href="https://gist.github.com/a-r-r-o-w/31be62828b00a9292821b85c1017effa" rel="nofollow">quanto</a></li>',Pe,te,He,m,ne,et,de,Ut="Pipeline for image-to-video generation using ConsisID.",tt,me,jt=`This model inherits from <a href="/docs/diffusers/pr_10140/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,nt,I,se,st,fe,Ct="Function invoked when calling the pipeline for generation.",it,C,ot,k,ie,at,ue,kt="Encodes the prompt into text encoder hidden states.",lt,x,oe,rt,he,xt="Enables fused QKV projections.",pt,G,ae,ct,ge,Gt="Disable QKV projection fusion if enabled.",Re,le,Fe,Z,re,dt,_e,Wt="Output class for ConsisID pipelines.",Qe,pe,Ee,Me,Le;return v=new be({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),j=new Nt({props:{$$slots:{default:[Ht]},$$scope:{ctx:ce}}}),N=new be({props:{title:"Inference",local:"inference",headingTag:"h2"}}),H=new Ke({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29uc2lzSURQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLmNvbnNpc2lkLnV0aWxfY29uc2lzaWQlMjBpbXBvcnQlMjBwcmVwYXJlX2ZhY2VfbW9kZWxzJTJDJTIwcHJvY2Vzc19mYWNlX2VtYmVkZGluZ3NfaW5mZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiUyQyUyMGxvY2FsX2RpciUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiklMEFmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGZhY2VfY2xpcF9tb2RlbCUyQyUyMGZhY2VfbWFpbl9tb2RlbCUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTIwJTNEJTIwcHJlcGFyZV9mYWNlX21vZGVscyglMjJCZXN0V2lzaFlzaCUyRkNvbnNpc0lELXByZXZpZXclMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwQ29uc2lzSURQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQmVzdFdpc2hZc2glMkZDb25zaXNJRC1wcmV2aWV3JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.consisid.util_consisid <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)
face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)
pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),F=new Ke({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),E=new Ke({props:{code:"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",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># ConsisID works well with long and well-described prompts and image contain clear face (e.g., preferably half-body or full-body).</span>
prompt = <span class="hljs-string">&quot;A woman adorned with a delicate flower crown, is standing amidst a field of gently swaying wildflowers. Her eyes sparkle with a serene gaze, and a faint smile graces her lips, suggesting a moment of peaceful contentment. The shot is framed from the waist up, highlighting the gentle breeze lightly tousling her hair. The background reveals an expansive meadow under a bright blue sky, capturing the tranquility of a sunny afternoon.&quot;</span>
image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/1.png?raw=true&quot;</span>

id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(face_helper_1, face_clip_model, face_helper_2, eva_transform_mean, eva_transform_std, face_main_model, <span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, image, is_align_face=<span class="hljs-literal">True</span>)
is_kps = <span class="hljs-built_in">getattr</span>(pipe.transformer.config, <span class="hljs-string">&#x27;is_kps&#x27;</span>, <span class="hljs-literal">False</span>)
kps_cond = face_kps <span class="hljs-keyword">if</span> is_kps <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

video = pipe(image=image, prompt=prompt, use_dynamic_cfg=<span class="hljs-literal">False</span>, id_vit_hidden=id_vit_hidden, id_cond=id_cond, kps_cond=kps_cond, generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>))
export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),L=new be({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),A=new be({props:{title:"Quantized inference",local:"quantized-inference",headingTag:"h3"}}),te=new be({props:{title:"ConsisIDPipeline",local:"diffusers.ConsisIDPipeline",headingTag:"h2"}}),ne=new ye({props:{name:"class diffusers.ConsisIDPipeline",anchor:"diffusers.ConsisIDPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": ConsisIDTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.ConsisIDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. ConsisID uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.ConsisIDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.ConsisIDPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/consisid_transformer3d#diffusers.ConsisIDTransformer3DModel">ConsisIDTransformer3DModel</a>) &#x2014;
A text conditioned <code>ConsisIDTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.ConsisIDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10140/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L244"}}),se=new ye({props:{name:"__call__",anchor:"diffusers.ConsisIDPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"},{name:"id_vit_hidden",val:": typing.Optional[torch.Tensor] = None"},{name:"id_cond",val:": typing.Optional[torch.Tensor] = None"},{name:"kps_cond",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.ConsisIDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because ConsisID is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.ConsisIDPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.ConsisIDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.ConsisIDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.ConsisIDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.ConsisIDPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> or <code>tuple</code></p>
`}}),C=new zt({props:{anchor:"diffusers.ConsisIDPipeline.__call__.example",$$slots:{default:[Rt]},$$scope:{ctx:ce}}}),ie=new ye({props:{name:"encode_prompt",anchor:"diffusers.ConsisIDPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L349"}}),oe=new ye({props:{name:"fuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L615"}}),ae=new ye({props:{name:"unfuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L621"}}),le=new be({props:{title:"ConsisIDPipelineOutput",local:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",headingTag:"h2"}}),re=new ye({props:{name:"class diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_output.py#L8"}}),pe=new Pt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/consisid.md"}}),{c(){r=a("meta"),J=i(),M=a("p"),w=i(),f(v.$$.fragment),d=i(),T=a("p"),T.innerHTML=mt,we=i(),Y=a("p"),Y.textContent=ft,ve=i(),$=a("p"),$.innerHTML=ut,Te=i(),f(j.$$.fragment),Je=i(),V=a("p"),V.innerHTML=ht,Ie=i(),X=a("p"),X.textContent=gt,Ze=i(),D=a("table"),D.innerHTML=_t,Ue=i(),f(N.$$.fragment),je=i(),z=a("p"),z.innerHTML=yt,Ce=i(),P=a("p"),P.textContent=bt,ke=i(),f(H.$$.fragment),xe=i(),R=a("p"),R.innerHTML=Mt,Ge=i(),f(F.$$.fragment),We=i(),Q=a("p"),Q.textContent=wt,Be=i(),f(E.$$.fragment),Ye=i(),f(L.$$.fragment),$e=i(),q=a("p"),q.innerHTML=vt,Ve=i(),S=a("ul"),S.innerHTML=Tt,Xe=i(),f(A.$$.fragment),De=i(),O=a("p"),O.innerHTML=Jt,Ne=i(),K=a("p"),K.innerHTML=It,ze=i(),ee=a("ul"),ee.innerHTML=Zt,Pe=i(),f(te.$$.fragment),He=i(),m=a("div"),f(ne.$$.fragment),et=i(),de=a("p"),de.textContent=Ut,tt=i(),me=a("p"),me.innerHTML=jt,nt=i(),I=a("div"),f(se.$$.fragment),st=i(),fe=a("p"),fe.textContent=Ct,it=i(),f(C.$$.fragment),ot=i(),k=a("div"),f(ie.$$.fragment),at=i(),ue=a("p"),ue.textContent=kt,lt=i(),x=a("div"),f(oe.$$.fragment),rt=i(),he=a("p"),he.textContent=xt,pt=i(),G=a("div"),f(ae.$$.fragment),ct=i(),ge=a("p"),ge.textContent=Gt,Re=i(),f(le.$$.fragment),Fe=i(),Z=a("div"),f(re.$$.fragment),dt=i(),_e=a("p"),_e.textContent=Wt,Qe=i(),f(pe.$$.fragment),Ee=i(),Me=a("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(n),J=o(e),M=l(e,"P",{}),W(M).forEach(n),w=o(e),u(v.$$.fragment,e),d=o(e),T=l(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18faaze"&&(T.innerHTML=mt),we=o(e),Y=l(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1cwsb16"&&(Y.textContent=ft),ve=o(e),$=l(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-16o3b9f"&&($.innerHTML=ut),Te=o(e),u(j.$$.fragment,e),Je=o(e),V=l(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-508pas"&&(V.innerHTML=ht),Ie=o(e),X=l(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-10ua0j4"&&(X.textContent=gt),Ze=o(e),D=l(e,"TABLE",{"data-svelte-h":!0}),c(D)!=="svelte-1g40pp0"&&(D.innerHTML=_t),Ue=o(e),u(N.$$.fragment,e),je=o(e),z=l(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-iekg51"&&(z.innerHTML=yt),Ce=o(e),P=l(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-jub7f1"&&(P.textContent=bt),ke=o(e),u(H.$$.fragment,e),xe=o(e),R=l(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1p91erm"&&(R.innerHTML=Mt),Ge=o(e),u(F.$$.fragment,e),We=o(e),Q=l(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-oyjtrh"&&(Q.textContent=wt),Be=o(e),u(E.$$.fragment,e),Ye=o(e),u(L.$$.fragment,e),$e=o(e),q=l(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1jqdn03"&&(q.innerHTML=vt),Ve=o(e),S=l(e,"UL",{"data-svelte-h":!0}),c(S)!=="svelte-195dfo2"&&(S.innerHTML=Tt),Xe=o(e),u(A.$$.fragment,e),De=o(e),O=l(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1elq2ob"&&(O.innerHTML=Jt),Ne=o(e),K=l(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-9tb0fb"&&(K.innerHTML=It),ze=o(e),ee=l(e,"UL",{"data-svelte-h":!0}),c(ee)!=="svelte-190pde7"&&(ee.innerHTML=Zt),Pe=o(e),u(te.$$.fragment,e),He=o(e),m=l(e,"DIV",{class:!0});var b=W(m);u(ne.$$.fragment,b),et=o(b),de=l(b,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1ypyl48"&&(de.textContent=Ut),tt=o(b),me=l(b,"P",{"data-svelte-h":!0}),c(me)!=="svelte-12lopph"&&(me.innerHTML=jt),nt=o(b),I=l(b,"DIV",{class:!0});var U=W(I);u(se.$$.fragment,U),st=o(U),fe=l(U,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-v78lg8"&&(fe.textContent=Ct),it=o(U),u(C.$$.fragment,U),U.forEach(n),ot=o(b),k=l(b,"DIV",{class:!0});var qe=W(k);u(ie.$$.fragment,qe),at=o(qe),ue=l(qe,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-16q0ax1"&&(ue.textContent=kt),qe.forEach(n),lt=o(b),x=l(b,"DIV",{class:!0});var Se=W(x);u(oe.$$.fragment,Se),rt=o(Se),he=l(Se,"P",{"data-svelte-h":!0}),c(he)!=="svelte-1vadzv1"&&(he.textContent=xt),Se.forEach(n),pt=o(b),G=l(b,"DIV",{class:!0});var Ae=W(G);u(ae.$$.fragment,Ae),ct=o(Ae),ge=l(Ae,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-fohozp"&&(ge.textContent=Gt),Ae.forEach(n),b.forEach(n),Re=o(e),u(le.$$.fragment,e),Fe=o(e),Z=l(e,"DIV",{class:!0});var Oe=W(Z);u(re.$$.fragment,Oe),dt=o(Oe),_e=l(Oe,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-ihv7pb"&&(_e.textContent=Wt),Oe.forEach(n),Qe=o(e),u(pe.$$.fragment,e),Ee=o(e),Me=l(e,"P",{}),W(Me).forEach(n),this.h()},h(){B(r,"name","hf:doc:metadata"),B(r,"content",Qt),B(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,r),s(e,J,t),s(e,M,t),s(e,w,t),h(v,e,t),s(e,d,t),s(e,T,t),s(e,we,t),s(e,Y,t),s(e,ve,t),s(e,$,t),s(e,Te,t),h(j,e,t),s(e,Je,t),s(e,V,t),s(e,Ie,t),s(e,X,t),s(e,Ze,t),s(e,D,t),s(e,Ue,t),h(N,e,t),s(e,je,t),s(e,z,t),s(e,Ce,t),s(e,P,t),s(e,ke,t),h(H,e,t),s(e,xe,t),s(e,R,t),s(e,Ge,t),h(F,e,t),s(e,We,t),s(e,Q,t),s(e,Be,t),h(E,e,t),s(e,Ye,t),h(L,e,t),s(e,$e,t),s(e,q,t),s(e,Ve,t),s(e,S,t),s(e,Xe,t),h(A,e,t),s(e,De,t),s(e,O,t),s(e,Ne,t),s(e,K,t),s(e,ze,t),s(e,ee,t),s(e,Pe,t),h(te,e,t),s(e,He,t),s(e,m,t),h(ne,m,null),p(m,et),p(m,de),p(m,tt),p(m,me),p(m,nt),p(m,I),h(se,I,null),p(I,st),p(I,fe),p(I,it),h(C,I,null),p(m,ot),p(m,k),h(ie,k,null),p(k,at),p(k,ue),p(m,lt),p(m,x),h(oe,x,null),p(x,rt),p(x,he),p(m,pt),p(m,G),h(ae,G,null),p(G,ct),p(G,ge),s(e,Re,t),h(le,e,t),s(e,Fe,t),s(e,Z,t),h(re,Z,null),p(Z,dt),p(Z,_e),s(e,Qe,t),h(pe,e,t),s(e,Ee,t),s(e,Me,t),Le=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),j.$set(b);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),C.$set(U)},i(e){Le||(g(v.$$.fragment,e),g(j.$$.fragment,e),g(N.$$.fragment,e),g(H.$$.fragment,e),g(F.$$.fragment,e),g(E.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(C.$$.fragment,e),g(ie.$$.fragment,e),g(oe.$$.fragment,e),g(ae.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),Le=!0)},o(e){_(v.$$.fragment,e),_(j.$$.fragment,e),_(N.$$.fragment,e),_(H.$$.fragment,e),_(F.$$.fragment,e),_(E.$$.fragment,e),_(L.$$.fragment,e),_(A.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(C.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(pe.$$.fragment,e),Le=!1},d(e){e&&(n(J),n(M),n(w),n(d),n(T),n(we),n(Y),n(ve),n($),n(Te),n(Je),n(V),n(Ie),n(X),n(Ze),n(D),n(Ue),n(je),n(z),n(Ce),n(P),n(ke),n(xe),n(R),n(Ge),n(We),n(Q),n(Be),n(Ye),n($e),n(q),n(Ve),n(S),n(Xe),n(De),n(O),n(Ne),n(K),n(ze),n(ee),n(Pe),n(He),n(m),n(Re),n(Fe),n(Z),n(Qe),n(Ee),n(Me)),n(r),y(v,e),y(j,e),y(N,e),y(H,e),y(F,e),y(E,e),y(L,e),y(A,e),y(te,e),y(ne),y(se),y(C),y(ie),y(oe),y(ae),y(le,e),y(re),y(pe,e)}}}const Qt='{"title":"ConsisID","local":"consisid","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Quantized inference","local":"quantized-inference","sections":[],"depth":3}],"depth":2},{"title":"ConsisIDPipeline","local":"diffusers.ConsisIDPipeline","sections":[],"depth":2},{"title":"ConsisIDPipelineOutput","local":"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput","sections":[],"depth":2}],"depth":1}';function Et(ce){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Vt{constructor(r){super(),Xt(this,r,Et,Ft,Yt,{})}}export{tn as component};
