import{s as ca,n as oa,o as ra}from"../chunks/scheduler.0219f8bd.js";import{S as ya,i as ja,g as p,s as t,r as c,m as pa,A as Ua,h as M,f as e,c as n,j as Ss,u as o,x as i,n as Ma,k as ia,y as h,a,v as r,d as y,t as j,w as U}from"../chunks/index.f61edf3b.js";import{C as w}from"../chunks/CodeBlock.38e566ae.js";import{H as T,E as ha}from"../chunks/EditOnGithub.48fa589f.js";function wa(Te){let m,Ls,Xs,_s,f,Ps,I,de=`In this tutorial, we’ll build a simple Next.js application that performs sentiment analysis using Transformers.js!
Since Transformers.js can run in the browser or in Node.js, you can choose whether you want to perform inference <a href="#client-side-inference">client-side</a> or <a href="#server-side-inference">server-side</a> (we’ll show you how to do both). In either case, we will be developing with the new <a href="https://nextjs.org/docs/app" rel="nofollow">App Router</a> paradigm.
The final product will look something like this:`,qs,b,me='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/next-demo.gif" alt="Demo"/>',Ks,g,ue="Useful links:",Ds,Z,Ce='<li>Demo site: <a href="https://huggingface.co/spaces/Xenova/next-example-app" rel="nofollow">client-side</a> or <a href="https://huggingface.co/spaces/Xenova/next-server-example-app" rel="nofollow">server-side</a></li> <li>Source code: <a href="https://github.com/xenova/transformers.js/tree/main/examples/next-client" rel="nofollow">client-side</a> or <a href="https://github.com/xenova/transformers.js/tree/main/examples/next-server" rel="nofollow">server-side</a></li>',Os,B,sl,G,fe='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',ll,k,el,N,al,x,Ie="Start by creating a new Next.js application using <code>create-next-app</code>:",tl,A,nl,W,be="On installation, you’ll see various prompts. For this demo, we’ll be selecting those shown below in bold:",pl,v,ge=`√ What is your project named? ... next
√ Would you like to use TypeScript? ... <b>No</b> / Yes
√ Would you like to use ESLint? ... No / <b>Yes</b>
√ Would you like to use Tailwind CSS? ... No / <b>Yes</b>
√ Would you like to use \`src/\` directory? ... No / <b>Yes</b>
√ Would you like to use App Router? (recommended) ... No / <b>Yes</b>
√ Would you like to customize the default import alias? ... <b>No</b> / Yes
`,Ml,S,il,R,Ze='You can install Transformers.js from <a href="https://www.npmjs.com/package/@huggingface/transformers" rel="nofollow">NPM</a> with the following command:',cl,Q,ol,Y,Be="We also need to update the <code>next.config.js</code> file to ignore node-specific modules when bundling for the browser:",rl,E,yl,$,Ge='Next, we’ll create a new <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers" rel="nofollow">Web Worker</a> script where we’ll place all ML-related code. This is to ensure that the main thread is not blocked while the model is loading and performing inference. For this application, we’ll be using <a href="https://huggingface.co/Xenova/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow"><code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code></a>, a ~67M parameter model finetuned on the <a href="https://huggingface.co/datasets/sst" rel="nofollow">Stanford Sentiment Treebank</a> dataset. Add the following code to <code>./src/app/worker.js</code>:',jl,V,Ul,H,hl,X,ke='We’ll now modify the default <code>./src/app/page.js</code> file so that it connects to our worker thread. Since we’ll only be performing in-browser inference, we can opt-in to Client components using the <a href="https://nextjs.org/docs/getting-started/react-essentials#the-use-client-directive" rel="nofollow"><code>&#39;use client&#39;</code> directive</a>.',wl,z,Jl,F,Ne="Initialise the following state variables at the beginning of the <code>Home</code> component:",Tl,L,dl,_,xe="and fill in the <code>onMessageReceived</code> function to update these variables when the worker thread sends a message:",ml,P,ul,q,Ae="Finally, we can add a simple UI to the <code>Home</code> component, consisting of an input textbox and a preformatted text element to display the classification result:",Cl,K,fl,D,We="You can now run your application using the following command:",Il,O,bl,ss,ve='Visit the URL shown in the terminal (e.g., <a href="http://localhost:3000/" rel="nofollow">http://localhost:3000/</a>) to see your application in action!',gl,ls,Zl,es,Se="To build your application, simply run:",Bl,as,Gl,ts,Re="This will bundle your application and output the static files to the <code>out</code> folder.",kl,ns,Qe='For this demo, we will deploy our application as a static <a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Hugging Face Space</a>, but you can deploy it anywhere you like! If you haven’t already, you can create a free Hugging Face account <a href="https://huggingface.co/join" rel="nofollow">here</a>.',Nl,ps,Ye='<li>Visit <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a> and fill in the form. Remember to select “Static” as the space type.</li> <li>Click the “Create space” button at the bottom of the page.</li> <li>Go to “Files” → “Add file” → “Upload files”. Drag the files from the <code>out</code> folder into the upload box and click “Upload”. After they have uploaded, scroll down to the button and click “Commit changes to main”.</li>',xl,Ms,Ee="<strong>That’s it!</strong> Your application should now be live at <code>https://huggingface.co/spaces/&lt;your-username&gt;/&lt;your-space-name&gt;</code>!",Al,is,Wl,cs,$e='While there are many different ways to perform server-side inference, the simplest (which we will discuss in this tutorial) is using the new <a href="https://nextjs.org/docs/app/building-your-application/routing/router-handlers" rel="nofollow">Route Handlers</a> feature.',vl,os,Sl,rs,Ve="Start by creating a new Next.js application using <code>create-next-app</code>:",Rl,ys,Ql,js,He="On installation, you’ll see various prompts. For this demo, we’ll be selecting those shown below in bold:",Yl,Us,Xe=`√ What is your project named? ... next
√ Would you like to use TypeScript? ... <b>No</b> / Yes
√ Would you like to use ESLint? ... No / <b>Yes</b>
√ Would you like to use Tailwind CSS? ... No / <b>Yes</b>
√ Would you like to use \`src/\` directory? ... No / <b>Yes</b>
√ Would you like to use App Router? (recommended) ... No / <b>Yes</b>
√ Would you like to customize the default import alias? ... <b>No</b> / Yes
`,El,hs,$l,ws,ze='You can install Transformers.js from <a href="https://www.npmjs.com/package/@huggingface/transformers" rel="nofollow">NPM</a> with the following command:',Vl,Js,Hl,Ts,Fe="We also need to update the <code>next.config.js</code> file to prevent Webpack from bundling certain packages:",Xl,ds,zl,ms,Le="Next, let’s set up our Route Handler. We can do this by creating two files in a new <code>./src/app/classify/</code> directory:",Fl,u,us,Rs,_e="<code>pipeline.js</code> - to handle the construction of our pipeline.",ce,Cs,oe,fs,Qs,Pe="<code>route.js</code> - to process requests made to the <code>/classify</code> route.",re,Is,Ll,bs,_l,gs,qe="We’ll now modify the default <code>./src/app/page.js</code> file to make requests to our newly-created Route Handler.",Pl,Zs,ql,Bs,Ke="You can now run your application using the following command:",Kl,Gs,Dl,ks,De='Visit the URL shown in the terminal (e.g., <a href="http://localhost:3000/" rel="nofollow">http://localhost:3000/</a>) to see your application in action!',Ol,Ns,se,xs,Oe='For this demo, we will build and deploy our application to <a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Hugging Face Spaces</a>. If you haven’t already, you can create a free Hugging Face account <a href="https://huggingface.co/join" rel="nofollow">here</a>.',le,J,Ys,sa='Create a new <code>Dockerfile</code> in your project’s root folder. You can use our <a href="https://github.com/xenova/transformers.js/blob/main/examples/next-server/Dockerfile" rel="nofollow">example Dockerfile</a> as a template.',ye,Es,la='Visit <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a> and fill in the form. Remember to select “Docker” as the space type (you can choose the “Blank” Docker template).',je,$s,ea="Click the “Create space” button at the bottom of the page.",Ue,Vs,aa="Go to “Files” → “Add file” → “Upload files”. Drag the files from your project folder (excluding <code>node_modules</code> and <code>.next</code>, if present) into the upload box and click “Upload”. After they have uploaded, scroll down to the button and click “Commit changes to main”.",he,C,we,Hs,ta="README.md",Je,As,ee,Ws,na="<strong>That’s it!</strong> Your application should now be live at <code>https://huggingface.co/spaces/&lt;your-username&gt;/&lt;your-space-name&gt;</code>!",ae,vs,te,zs,ne;return f=new T({props:{title:"Building a Next.js application",local:"building-a-nextjs-application",headingTag:"h1"}}),B=new T({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),k=new T({props:{title:"Client-side inference",local:"client-side-inference",headingTag:"h2"}}),N=new T({props:{title:"Step 1: Initialise the project",local:"step-1-initialise-the-project",headingTag:"h3"}}),A=new w({props:{code:"bnB4JTIwY3JlYXRlLW5leHQtYXBwJTQwbGF0ZXN0",highlighted:"npx create-next-app@latest",wrap:!1}}),S=new T({props:{title:"Step 2: Install and configure Transformers.js",local:"step-2-install-and-configure-transformersjs",headingTag:"h3"}}),Q=new w({props:{code:"bnBtJTIwaSUyMCU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:"npm i @huggingface/transformers",wrap:!1}}),E=new w({props:{code:"JTJGKiolMjAlNDB0eXBlJTIwJTdCaW1wb3J0KCduZXh0JykuTmV4dENvbmZpZyU3RCUyMColMkYlMEFjb25zdCUyMG5leHRDb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAoT3B0aW9uYWwpJTIwRXhwb3J0JTIwYXMlMjBhJTIwc3RhdGljJTIwc2l0ZSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMFNlZSUyMGh0dHBzJTNBJTJGJTJGbmV4dGpzLm9yZyUyRmRvY3MlMkZwYWdlcyUyRmJ1aWxkaW5nLXlvdXItYXBwbGljYXRpb24lMkZkZXBsb3lpbmclMkZzdGF0aWMtZXhwb3J0cyUyM2NvbmZpZ3VyYXRpb24lMEElMjAlMjAlMjAlMjBvdXRwdXQlM0ElMjAnZXhwb3J0JyUyQyUyMCUyRiUyRiUyMEZlZWwlMjBmcmVlJTIwdG8lMjBtb2RpZnklMkZyZW1vdmUlMjB0aGlzJTIwb3B0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwT3ZlcnJpZGUlMjB0aGUlMjBkZWZhdWx0JTIwd2VicGFjayUyMGNvbmZpZ3VyYXRpb24lMEElMjAlMjAlMjAlMjB3ZWJwYWNrJTNBJTIwKGNvbmZpZyklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBTZWUlMjBodHRwcyUzQSUyRiUyRndlYnBhY2suanMub3JnJTJGY29uZmlndXJhdGlvbiUyRnJlc29sdmUlMkYlMjNyZXNvbHZlYWxpYXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcucmVzb2x2ZS5hbGlhcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLmNvbmZpZy5yZXNvbHZlLmFsaWFzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2hhcnAlMjQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ubnhydW50aW1lLW5vZGUlMjQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbmZpZyUzQiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU3RCUwQSUwQW1vZHVsZS5leHBvcnRzJTIwJTNEJTIwbmV4dENvbmZpZw==",highlighted:`<span class="hljs-comment">/** <span class="hljs-doctag">@type</span> {<span class="hljs-type">import(&#x27;next&#x27;).NextConfig</span>} */</span>
<span class="hljs-keyword">const</span> nextConfig = {
    <span class="hljs-comment">// (Optional) Export as a static site</span>
    <span class="hljs-comment">// See https://nextjs.org/docs/pages/building-your-application/deploying/static-exports#configuration</span>
    <span class="hljs-attr">output</span>: <span class="hljs-string">&#x27;export&#x27;</span>, <span class="hljs-comment">// Feel free to modify/remove this option</span>

    <span class="hljs-comment">// Override the default webpack configuration</span>
    <span class="hljs-attr">webpack</span>: <span class="hljs-function">(<span class="hljs-params">config</span>) =&gt;</span> {
        <span class="hljs-comment">// See https://webpack.js.org/configuration/resolve/#resolvealias</span>
        config.<span class="hljs-property">resolve</span>.<span class="hljs-property">alias</span> = {
            ...config.<span class="hljs-property">resolve</span>.<span class="hljs-property">alias</span>,
            <span class="hljs-string">&quot;sharp$&quot;</span>: <span class="hljs-literal">false</span>,
            <span class="hljs-string">&quot;onnxruntime-node$&quot;</span>: <span class="hljs-literal">false</span>,
        }
        <span class="hljs-keyword">return</span> config;
    },
}

<span class="hljs-variable language_">module</span>.<span class="hljs-property">exports</span> = nextConfig`,wrap:!1}}),V=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Skip local model check</span>
env.<span class="hljs-property">allowLocalModels</span> = <span class="hljs-literal">false</span>;

<span class="hljs-comment">// Use the Singleton pattern to enable lazy construction of the pipeline.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">PipelineSingleton</span> {
    <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
    <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
    <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

    <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
        <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
            <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
        }
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
    }
}

<span class="hljs-comment">// Listen for messages from the main thread</span>
self.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
    <span class="hljs-comment">// Retrieve the classification pipeline. When called for the first time,</span>
    <span class="hljs-comment">// this will load the pipeline and save it for future use.</span>
    <span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">PipelineSingleton</span>.<span class="hljs-title function_">getInstance</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> {
        <span class="hljs-comment">// We also add a progress callback to the pipeline so that we can</span>
        <span class="hljs-comment">// track model loading.</span>
        self.<span class="hljs-title function_">postMessage</span>(x);
    });

    <span class="hljs-comment">// Actually perform the classification</span>
    <span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(event.<span class="hljs-property">data</span>.<span class="hljs-property">text</span>);

    <span class="hljs-comment">// Send the output back to the main thread</span>
    self.<span class="hljs-title function_">postMessage</span>({
        <span class="hljs-attr">status</span>: <span class="hljs-string">&#x27;complete&#x27;</span>,
        <span class="hljs-attr">output</span>: output,
    });
});
`,wrap:!1}}),H=new T({props:{title:"Step 3: Design the user interface",local:"step-3-design-the-user-interface",headingTag:"h3"}}),z=new w({props:{code:"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",highlighted:`<span class="hljs-string">&#x27;use client&#x27;</span>

<span class="hljs-keyword">import</span> { useState, useEffect, useRef, useCallback } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;react&#x27;</span>

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">Home</span>(<span class="hljs-params"></span>) {
  <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> Add state variables */</span>

  <span class="hljs-comment">// Create a reference to the worker object.</span>
  <span class="hljs-keyword">const</span> worker = <span class="hljs-title function_">useRef</span>(<span class="hljs-literal">null</span>);

  <span class="hljs-comment">// We use the \`useEffect\` hook to set up the worker as soon as the \`App\` component is mounted.</span>
  <span class="hljs-title function_">useEffect</span>(<span class="hljs-function">() =&gt;</span> {
    <span class="hljs-keyword">if</span> (!worker.<span class="hljs-property">current</span>) {
      <span class="hljs-comment">// Create the worker if it does not yet exist.</span>
      worker.<span class="hljs-property">current</span> = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Worker</span>(<span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&#x27;./worker.js&#x27;</span>, <span class="hljs-keyword">import</span>.<span class="hljs-property">meta</span>.<span class="hljs-property">url</span>), {
        <span class="hljs-attr">type</span>: <span class="hljs-string">&#x27;module&#x27;</span>
      });
    }

    <span class="hljs-comment">// Create a callback function for messages from the worker thread.</span>
    <span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; { <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> See below */</span>};

    <span class="hljs-comment">// Attach the callback function as an event listener.</span>
    worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);

    <span class="hljs-comment">// Define a cleanup function for when the component is unmounted.</span>
    <span class="hljs-keyword">return</span> <span class="hljs-function">() =&gt;</span> worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">removeEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);
  });

  <span class="hljs-keyword">const</span> classify = <span class="hljs-title function_">useCallback</span>(<span class="hljs-function">(<span class="hljs-params">text</span>) =&gt;</span> {
    <span class="hljs-keyword">if</span> (worker.<span class="hljs-property">current</span>) {
      worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">postMessage</span>({ text });
    }
  }, []);

  <span class="hljs-keyword">return</span> ( <span class="hljs-comment">/* <span class="hljs-doctag">TODO:</span> See below */</span> )
}`,wrap:!1}}),L=new w({props:{code:"JTJGJTJGJTIwS2VlcCUyMHRyYWNrJTIwb2YlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMHJlc3VsdCUyMGFuZCUyMHRoZSUyMG1vZGVsJTIwbG9hZGluZyUyMHN0YXR1cy4lMEFjb25zdCUyMCU1QnJlc3VsdCUyQyUyMHNldFJlc3VsdCU1RCUyMCUzRCUyMHVzZVN0YXRlKG51bGwpJTNCJTBBY29uc3QlMjAlNUJyZWFkeSUyQyUyMHNldFJlYWR5JTVEJTIwJTNEJTIwdXNlU3RhdGUobnVsbCklM0I=",highlighted:`<span class="hljs-comment">// Keep track of the classification result and the model loading status.</span>
<span class="hljs-keyword">const</span> [result, setResult] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);
<span class="hljs-keyword">const</span> [ready, setReady] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);`,wrap:!1}}),P=new w({props:{code:"Y29uc3QlMjBvbk1lc3NhZ2VSZWNlaXZlZCUyMCUzRCUyMChlKSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMHN3aXRjaCUyMChlLmRhdGEuc3RhdHVzKSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNhc2UlMjAnaW5pdGlhdGUnJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2V0UmVhZHkoZmFsc2UpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslM0IlMEElMjAlMjAlMjAlMjBjYXNlJTIwJ3JlYWR5JyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNldFJlYWR5KHRydWUpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslM0IlMEElMjAlMjAlMjAlMjBjYXNlJTIwJ2NvbXBsZXRlJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNldFJlc3VsdChlLmRhdGEub3V0cHV0JTVCMCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjBicmVhayUzQiUwQSUyMCUyMCU3RCUwQSU3RCUzQg==",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; {
  <span class="hljs-keyword">switch</span> (e.<span class="hljs-property">data</span>.<span class="hljs-property">status</span>) {
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;initiate&#x27;</span>:
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">false</span>);
      <span class="hljs-keyword">break</span>;
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;ready&#x27;</span>:
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">true</span>);
      <span class="hljs-keyword">break</span>;
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;complete&#x27;</span>:
      <span class="hljs-title function_">setResult</span>(e.<span class="hljs-property">data</span>.<span class="hljs-property">output</span>[<span class="hljs-number">0</span>])
      <span class="hljs-keyword">break</span>;
  }
};`,wrap:!1}}),K=new w({props:{code:"JTNDbWFpbiUyMGNsYXNzTmFtZSUzRCUyMmZsZXglMjBtaW4taC1zY3JlZW4lMjBmbGV4LWNvbCUyMGl0ZW1zLWNlbnRlciUyMGp1c3RpZnktY2VudGVyJTIwcC0xMiUyMiUzRSUwQSUyMCUyMCUzQ2gxJTIwY2xhc3NOYW1lJTNEJTIydGV4dC01eGwlMjBmb250LWJvbGQlMjBtYi0yJTIwdGV4dC1jZW50ZXIlMjIlM0VUcmFuc2Zvcm1lcnMuanMlM0MlMkZoMSUzRSUwQSUyMCUyMCUzQ2gyJTIwY2xhc3NOYW1lJTNEJTIydGV4dC0yeGwlMjBtYi00JTIwdGV4dC1jZW50ZXIlMjIlM0VOZXh0LmpzJTIwdGVtcGxhdGUlM0MlMkZoMiUzRSUwQSUwQSUyMCUyMCUzQ2lucHV0JTBBJTIwJTIwJTIwJTIwY2xhc3NOYW1lJTNEJTIydy1mdWxsJTIwbWF4LXcteHMlMjBwLTIlMjBib3JkZXIlMjBib3JkZXItZ3JheS0zMDAlMjByb3VuZGVkJTIwbWItNCUyMiUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJ0ZXh0JTIyJTBBJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXIlM0QlMjJFbnRlciUyMHRleHQlMjBoZXJlJTIyJTBBJTIwJTIwJTIwJTIwb25JbnB1dCUzRCU3QmUlMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGFzc2lmeShlLnRhcmdldC52YWx1ZSklM0IlMEElMjAlMjAlMjAlMjAlN0QlN0QlMEElMjAlMjAlMkYlM0UlMEElMEElMjAlMjAlN0JyZWFkeSUyMCElM0QlM0QlMjBudWxsJTIwJTI2JTI2JTIwKCUwQSUyMCUyMCUyMCUyMCUzQ3ByZSUyMGNsYXNzTmFtZSUzRCUyMmJnLWdyYXktMTAwJTIwcC0yJTIwcm91bmRlZCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCghcmVhZHklMjAlN0MlN0MlMjAhcmVzdWx0KSUyMCUzRiUyMCdMb2FkaW5nLi4uJyUyMCUzQSUyMEpTT04uc3RyaW5naWZ5KHJlc3VsdCUyQyUyMG51bGwlMkMlMjAyKSUyMCU3RCUwQSUyMCUyMCUyMCUyMCUzQyUyRnByZSUzRSUwQSUyMCUyMCklN0QlMEElM0MlMkZtYWluJTNF",highlighted:`&lt;main className=<span class="hljs-string">&quot;flex min-h-screen flex-col items-center justify-center p-12&quot;</span>&gt;
  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">h1</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-5xl font-bold mb-2 text-center&quot;</span>&gt;</span>Transformers.js<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span></span>
  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">h2</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-2xl mb-4 text-center&quot;</span>&gt;</span>Next.js template<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span></span>

  <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">input</span>
    <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;w-full max-w-xs p-2 border border-gray-300 rounded mb-4&quot;</span>
    <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
    <span class="hljs-attr">placeholder</span>=<span class="hljs-string">&quot;Enter text here&quot;</span>
    <span class="hljs-attr">onInput</span>=<span class="hljs-string">{e</span> =&gt;</span> {
        classify(e.target.value);
    }}
  /&gt;</span>

  {ready !== <span class="hljs-literal">null</span> &amp;&amp; (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">pre</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;bg-gray-100 p-2 rounded&quot;</span>&gt;</span>
      { (!ready || !result) ? &#x27;Loading...&#x27; : JSON.stringify(result, null, 2) }
    <span class="hljs-tag">&lt;/<span class="hljs-name">pre</span>&gt;</span></span>
  )}
&lt;/main&gt;`,wrap:!1}}),O=new w({props:{code:"bnBtJTIwcnVuJTIwZGV2",highlighted:"npm run dev",wrap:!1}}),ls=new T({props:{title:"(Optional) Step 4: Build and deploy",local:"optional-step-4-build-and-deploy",headingTag:"h3"}}),as=new w({props:{code:"bnBtJTIwcnVuJTIwYnVpbGQ=",highlighted:"npm run build",wrap:!1}}),is=new T({props:{title:"Server-side inference",local:"server-side-inference",headingTag:"h2"}}),os=new T({props:{title:"Step 1: Initialise the project",local:"step-1-initialise-the-project",headingTag:"h3"}}),ys=new w({props:{code:"bnB4JTIwY3JlYXRlLW5leHQtYXBwJTQwbGF0ZXN0",highlighted:"npx create-next-app@latest",wrap:!1}}),hs=new T({props:{title:"Step 2: Install and configure Transformers.js",local:"step-2-install-and-configure-transformersjs",headingTag:"h3"}}),Js=new w({props:{code:"bnBtJTIwaSUyMCU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:"npm i @huggingface/transformers",wrap:!1}}),ds=new w({props:{code:"JTJGKiolMjAlNDB0eXBlJTIwJTdCaW1wb3J0KCduZXh0JykuTmV4dENvbmZpZyU3RCUyMColMkYlMEFjb25zdCUyMG5leHRDb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAoT3B0aW9uYWwpJTIwRXhwb3J0JTIwYXMlMjBhJTIwc3RhbmRhbG9uZSUyMHNpdGUlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBTZWUlMjBodHRwcyUzQSUyRiUyRm5leHRqcy5vcmclMkZkb2NzJTJGcGFnZXMlMkZhcGktcmVmZXJlbmNlJTJGbmV4dC1jb25maWctanMlMkZvdXRwdXQlMjNhdXRvbWF0aWNhbGx5LWNvcHlpbmctdHJhY2VkLWZpbGVzJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTNBJTIwJ3N0YW5kYWxvbmUnJTJDJTIwJTJGJTJGJTIwRmVlbCUyMGZyZWUlMjB0byUyMG1vZGlmeSUyRnJlbW92ZSUyMHRoaXMlMjBvcHRpb24lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBJbmRpY2F0ZSUyMHRoYXQlMjB0aGVzZSUyMHBhY2thZ2VzJTIwc2hvdWxkJTIwbm90JTIwYmUlMjBidW5kbGVkJTIwYnklMjB3ZWJwYWNrJTBBJTIwJTIwJTIwJTIwZXhwZXJpbWVudGFsJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VydmVyQ29tcG9uZW50c0V4dGVybmFsUGFja2FnZXMlM0ElMjAlNUInc2hhcnAnJTJDJTIwJ29ubnhydW50aW1lLW5vZGUnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTdEJTNCJTBBJTBBbW9kdWxlLmV4cG9ydHMlMjAlM0QlMjBuZXh0Q29uZmln",highlighted:`<span class="hljs-comment">/** <span class="hljs-doctag">@type</span> {<span class="hljs-type">import(&#x27;next&#x27;).NextConfig</span>} */</span>
<span class="hljs-keyword">const</span> nextConfig = {
    <span class="hljs-comment">// (Optional) Export as a standalone site</span>
    <span class="hljs-comment">// See https://nextjs.org/docs/pages/api-reference/next-config-js/output#automatically-copying-traced-files</span>
    <span class="hljs-attr">output</span>: <span class="hljs-string">&#x27;standalone&#x27;</span>, <span class="hljs-comment">// Feel free to modify/remove this option</span>
    
    <span class="hljs-comment">// Indicate that these packages should not be bundled by webpack</span>
    <span class="hljs-attr">experimental</span>: {
        <span class="hljs-attr">serverComponentsExternalPackages</span>: [<span class="hljs-string">&#x27;sharp&#x27;</span>, <span class="hljs-string">&#x27;onnxruntime-node&#x27;</span>],
    },
};

<span class="hljs-variable language_">module</span>.<span class="hljs-property">exports</span> = nextConfig`,wrap:!1}}),Cs=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Use the Singleton pattern to enable lazy construction of the pipeline.</span>
<span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> We wrap the class in a function to prevent code duplication (see below).</span>
<span class="hljs-keyword">const</span> <span class="hljs-title function_">P</span> = (<span class="hljs-params"></span>) =&gt; <span class="hljs-keyword">class</span> <span class="hljs-title class_">PipelineSingleton</span> {
    <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
    <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
    <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

    <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
        <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
            <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
        }
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
    }
}

<span class="hljs-keyword">let</span> <span class="hljs-title class_">PipelineSingleton</span>;
<span class="hljs-keyword">if</span> (process.<span class="hljs-property">env</span>.<span class="hljs-property">NODE_ENV</span> !== <span class="hljs-string">&#x27;production&#x27;</span>) {
    <span class="hljs-comment">// When running in development mode, attach the pipeline to the</span>
    <span class="hljs-comment">// global object so that it&#x27;s preserved between hot reloads.</span>
    <span class="hljs-comment">// For more information, see https://vercel.com/guides/nextjs-prisma-postgres</span>
    <span class="hljs-keyword">if</span> (!<span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span>) {
        <span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span> = <span class="hljs-title function_">P</span>();
    }
    <span class="hljs-title class_">PipelineSingleton</span> = <span class="hljs-variable language_">global</span>.<span class="hljs-property">PipelineSingleton</span>;
} <span class="hljs-keyword">else</span> {
    <span class="hljs-title class_">PipelineSingleton</span> = <span class="hljs-title function_">P</span>();
}
<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-title class_">PipelineSingleton</span>;`,wrap:!1}}),Is=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwTmV4dFJlc3BvbnNlJTIwJTdEJTIwZnJvbSUyMCduZXh0JTJGc2VydmVyJyUwQWltcG9ydCUyMFBpcGVsaW5lU2luZ2xldG9uJTIwZnJvbSUyMCcuJTJGcGlwZWxpbmUuanMnJTNCJTBBJTBBZXhwb3J0JTIwYXN5bmMlMjBmdW5jdGlvbiUyMEdFVChyZXF1ZXN0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwdGV4dCUyMCUzRCUyMHJlcXVlc3QubmV4dFVybC5zZWFyY2hQYXJhbXMuZ2V0KCd0ZXh0JyklM0IlMEElMjAlMjAlMjAlMjBpZiUyMCghdGV4dCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOZXh0UmVzcG9uc2UuanNvbiglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvciUzQSUyMCdNaXNzaW5nJTIwdGV4dCUyMHBhcmFtZXRlciclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlN0IlMjBzdGF0dXMlM0ElMjA0MDAlMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwR2V0JTIwdGhlJTIwY2xhc3NpZmljYXRpb24lMjBwaXBlbGluZS4lMjBXaGVuJTIwY2FsbGVkJTIwZm9yJTIwdGhlJTIwZmlyc3QlMjB0aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwdGhpcyUyMHdpbGwlMjBsb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBhbmQlMjBjYWNoZSUyMGl0JTIwZm9yJTIwZnV0dXJlJTIwdXNlLiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwUGlwZWxpbmVTaW5nbGV0b24uZ2V0SW5zdGFuY2UoKSUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMEFjdHVhbGx5JTIwcGVyZm9ybSUyMHRoZSUyMGNsYXNzaWZpY2F0aW9uJTBBJTIwJTIwJTIwJTIwY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodGV4dCklM0IlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBOZXh0UmVzcG9uc2UuanNvbihyZXN1bHQpJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">NextResponse</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;next/server&#x27;</span>
<span class="hljs-keyword">import</span> <span class="hljs-title class_">PipelineSingleton</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;./pipeline.js&#x27;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">GET</span>(<span class="hljs-params">request</span>) {
    <span class="hljs-keyword">const</span> text = request.<span class="hljs-property">nextUrl</span>.<span class="hljs-property">searchParams</span>.<span class="hljs-title function_">get</span>(<span class="hljs-string">&#x27;text&#x27;</span>);
    <span class="hljs-keyword">if</span> (!text) {
        <span class="hljs-keyword">return</span> <span class="hljs-title class_">NextResponse</span>.<span class="hljs-title function_">json</span>({
            <span class="hljs-attr">error</span>: <span class="hljs-string">&#x27;Missing text parameter&#x27;</span>,
        }, { <span class="hljs-attr">status</span>: <span class="hljs-number">400</span> });
    }
    <span class="hljs-comment">// Get the classification pipeline. When called for the first time,</span>
    <span class="hljs-comment">// this will load the pipeline and cache it for future use.</span>
    <span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">PipelineSingleton</span>.<span class="hljs-title function_">getInstance</span>();

    <span class="hljs-comment">// Actually perform the classification</span>
    <span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);

    <span class="hljs-keyword">return</span> <span class="hljs-title class_">NextResponse</span>.<span class="hljs-title function_">json</span>(result);
}`,wrap:!1}}),bs=new T({props:{title:"Step 3: Design the user interface",local:"step-3-design-the-user-interface",headingTag:"h3"}}),Zs=new w({props:{code:"J3VzZSUyMGNsaWVudCclMEElMEFpbXBvcnQlMjAlN0IlMjB1c2VTdGF0ZSUyMCU3RCUyMGZyb20lMjAncmVhY3QnJTBBJTBBZXhwb3J0JTIwZGVmYXVsdCUyMGZ1bmN0aW9uJTIwSG9tZSgpJTIwJTdCJTBBJTBBJTIwJTIwJTJGJTJGJTIwS2VlcCUyMHRyYWNrJTIwb2YlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMHJlc3VsdCUyMGFuZCUyMHRoZSUyMG1vZGVsJTIwbG9hZGluZyUyMHN0YXR1cy4lMEElMjAlMjBjb25zdCUyMCU1QnJlc3VsdCUyQyUyMHNldFJlc3VsdCU1RCUyMCUzRCUyMHVzZVN0YXRlKG51bGwpJTNCJTBBJTIwJTIwY29uc3QlMjAlNUJyZWFkeSUyQyUyMHNldFJlYWR5JTVEJTIwJTNEJTIwdXNlU3RhdGUobnVsbCklM0IlMEElMEElMjAlMjBjb25zdCUyMGNsYXNzaWZ5JTIwJTNEJTIwYXN5bmMlMjAodGV4dCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCghdGV4dCklMjByZXR1cm4lM0IlMEElMjAlMjAlMjAlMjBpZiUyMChyZWFkeSUyMCUzRCUzRCUzRCUyMG51bGwpJTIwc2V0UmVhZHkoZmFsc2UpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwTWFrZSUyMGElMjByZXF1ZXN0JTIwdG8lMjB0aGUlMjAlMkZjbGFzc2lmeSUyMHJvdXRlJTIwb24lMjB0aGUlMjBzZXJ2ZXIuJTBBJTIwJTIwJTIwJTIwY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGZldGNoKCU2MCUyRmNsYXNzaWZ5JTNGdGV4dCUzRCUyNCU3QmVuY29kZVVSSUNvbXBvbmVudCh0ZXh0KSU3RCU2MCklM0IlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBJZiUyMHRoaXMlMjBpcyUyMHRoZSUyMGZpcnN0JTIwdGltZSUyMHdlJ3ZlJTIwbWFkZSUyMGElMjByZXF1ZXN0JTJDJTIwc2V0JTIwdGhlJTIwcmVhZHklMjBmbGFnLiUwQSUyMCUyMCUyMCUyMGlmJTIwKCFyZWFkeSklMjBzZXRSZWFkeSh0cnVlKSUzQiUwQSUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwanNvbiUyMCUzRCUyMGF3YWl0JTIwcmVzdWx0Lmpzb24oKSUzQiUwQSUyMCUyMCUyMCUyMHNldFJlc3VsdChqc29uKSUzQiUwQSUyMCUyMCU3RCUzQiUwQSUyMCUyMHJldHVybiUyMCglMEElMjAlMjAlMjAlMjAlM0NtYWluJTIwY2xhc3NOYW1lJTNEJTIyZmxleCUyMG1pbi1oLXNjcmVlbiUyMGZsZXgtY29sJTIwaXRlbXMtY2VudGVyJTIwanVzdGlmeS1jZW50ZXIlMjBwLTEyJTIyJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaDElMjBjbGFzc05hbWUlM0QlMjJ0ZXh0LTV4bCUyMGZvbnQtYm9sZCUyMG1iLTIlMjB0ZXh0LWNlbnRlciUyMiUzRVRyYW5zZm9ybWVycy5qcyUzQyUyRmgxJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaDIlMjBjbGFzc05hbWUlM0QlMjJ0ZXh0LTJ4bCUyMG1iLTQlMjB0ZXh0LWNlbnRlciUyMiUzRU5leHQuanMlMjB0ZW1wbGF0ZSUyMChzZXJ2ZXItc2lkZSklM0MlMkZoMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ2lucHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGFzc05hbWUlM0QlMjJ3LWZ1bGwlMjBtYXgtdy14cyUyMHAtMiUyMGJvcmRlciUyMGJvcmRlci1ncmF5LTMwMCUyMHJvdW5kZWQlMjBtYi00JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXIlM0QlMjJFbnRlciUyMHRleHQlMjBoZXJlJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb25JbnB1dCUzRCU3QmUlMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGFzc2lmeShlLnRhcmdldC52YWx1ZSklM0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlM0UlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlN0JyZWFkeSUyMCElM0QlM0QlMjBudWxsJTIwJTI2JTI2JTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQ3ByZSUyMGNsYXNzTmFtZSUzRCUyMmJnLWdyYXktMTAwJTIwcC0yJTIwcm91bmRlZCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCghcmVhZHklMjAlN0MlN0MlMjAhcmVzdWx0KSUyMCUzRiUyMCdMb2FkaW5nLi4uJyUyMCUzQSUyMEpTT04uc3RyaW5naWZ5KHJlc3VsdCUyQyUyMG51bGwlMkMlMjAyKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQyUyRnByZSUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCklN0QlMEElMjAlMjAlMjAlMjAlM0MlMkZtYWluJTNFJTBBJTIwJTIwKSUwQSU3RA==",highlighted:`<span class="hljs-string">&#x27;use client&#x27;</span>

<span class="hljs-keyword">import</span> { useState } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;react&#x27;</span>

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">Home</span>(<span class="hljs-params"></span>) {

  <span class="hljs-comment">// Keep track of the classification result and the model loading status.</span>
  <span class="hljs-keyword">const</span> [result, setResult] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);
  <span class="hljs-keyword">const</span> [ready, setReady] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);

  <span class="hljs-keyword">const</span> <span class="hljs-title function_">classify</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
    <span class="hljs-keyword">if</span> (!text) <span class="hljs-keyword">return</span>;
    <span class="hljs-keyword">if</span> (ready === <span class="hljs-literal">null</span>) <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">false</span>);

    <span class="hljs-comment">// Make a request to the /classify route on the server.</span>
    <span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`/classify?text=<span class="hljs-subst">\${<span class="hljs-built_in">encodeURIComponent</span>(text)}</span>\`</span>);

    <span class="hljs-comment">// If this is the first time we&#x27;ve made a request, set the ready flag.</span>
    <span class="hljs-keyword">if</span> (!ready) <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">true</span>);

    <span class="hljs-keyword">const</span> json = <span class="hljs-keyword">await</span> result.<span class="hljs-title function_">json</span>();
    <span class="hljs-title function_">setResult</span>(json);
  };
  <span class="hljs-keyword">return</span> (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">main</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;flex min-h-screen flex-col items-center justify-center p-12&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">h1</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-5xl font-bold mb-2 text-center&quot;</span>&gt;</span>Transformers.js<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">h2</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;text-2xl mb-4 text-center&quot;</span>&gt;</span>Next.js template (server-side)<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;w-full max-w-xs p-2 border border-gray-300 rounded mb-4&quot;</span>
        <span class="hljs-attr">placeholder</span>=<span class="hljs-string">&quot;Enter text here&quot;</span>
        <span class="hljs-attr">onInput</span>=<span class="hljs-string">{e</span> =&gt;</span> {
          classify(e.target.value);
        }}
      /&gt;

      {ready !== null &amp;&amp; (
        <span class="hljs-tag">&lt;<span class="hljs-name">pre</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;bg-gray-100 p-2 rounded&quot;</span>&gt;</span>
          {
            (!ready || !result) ? &#x27;Loading...&#x27; : JSON.stringify(result, null, 2)}
        <span class="hljs-tag">&lt;/<span class="hljs-name">pre</span>&gt;</span>
      )}
    <span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span></span>
  )
}`,wrap:!1}}),Gs=new w({props:{code:"bnBtJTIwcnVuJTIwZGV2",highlighted:"npm run dev",wrap:!1}}),Ns=new T({props:{title:"(Optional) Step 4: Build and deploy",local:"optional-step-4-build-and-deploy",headingTag:"h3"}}),As=new w({props:{code:"LS0tJTBBdGl0bGUlM0ElMjBOZXh0JTIwU2VydmVyJTIwRXhhbXBsZSUyMEFwcCUwQWVtb2ppJTNBJTIwJUYwJTlGJTk0JUE1JTBBY29sb3JGcm9tJTNBJTIweWVsbG93JTBBY29sb3JUbyUzQSUyMHJlZCUwQXNkayUzQSUyMGRvY2tlciUwQXBpbm5lZCUzQSUyMGZhbHNlJTBBYXBwX3BvcnQlM0ElMjAzMDAwJTBBLS0t",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">title:</span> <span class="hljs-string">Next</span> <span class="hljs-string">Server</span> <span class="hljs-string">Example</span> <span class="hljs-string">App</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🔥</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">yellow</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">red</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>
<span class="hljs-attr">pinned:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">app_port:</span> <span class="hljs-number">3000</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),vs=new ha({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/tutorials/next.md"}}),{c(){m=p("meta"),Ls=t(),Xs=p("p"),_s=t(),c(f.$$.fragment),Ps=t(),I=p("p"),I.innerHTML=de,qs=t(),b=p("p"),b.innerHTML=me,Ks=t(),g=p("p"),g.textContent=ue,Ds=t(),Z=p("ul"),Z.innerHTML=Ce,Os=t(),c(B.$$.fragment),sl=t(),G=p("ul"),G.innerHTML=fe,ll=t(),c(k.$$.fragment),el=t(),c(N.$$.fragment),al=t(),x=p("p"),x.innerHTML=Ie,tl=t(),c(A.$$.fragment),nl=t(),W=p("p"),W.textContent=be,pl=t(),v=p("pre"),v.innerHTML=ge,Ml=t(),c(S.$$.fragment),il=t(),R=p("p"),R.innerHTML=Ze,cl=t(),c(Q.$$.fragment),ol=t(),Y=p("p"),Y.innerHTML=Be,rl=t(),c(E.$$.fragment),yl=t(),$=p("p"),$.innerHTML=Ge,jl=t(),c(V.$$.fragment),Ul=t(),c(H.$$.fragment),hl=t(),X=p("p"),X.innerHTML=ke,wl=t(),c(z.$$.fragment),Jl=t(),F=p("p"),F.innerHTML=Ne,Tl=t(),c(L.$$.fragment),dl=t(),_=p("p"),_.innerHTML=xe,ml=t(),c(P.$$.fragment),ul=t(),q=p("p"),q.innerHTML=Ae,Cl=t(),c(K.$$.fragment),fl=t(),D=p("p"),D.textContent=We,Il=t(),c(O.$$.fragment),bl=t(),ss=p("p"),ss.innerHTML=ve,gl=t(),c(ls.$$.fragment),Zl=t(),es=p("p"),es.textContent=Se,Bl=t(),c(as.$$.fragment),Gl=t(),ts=p("p"),ts.innerHTML=Re,kl=t(),ns=p("p"),ns.innerHTML=Qe,Nl=t(),ps=p("ol"),ps.innerHTML=Ye,xl=t(),Ms=p("p"),Ms.innerHTML=Ee,Al=t(),c(is.$$.fragment),Wl=t(),cs=p("p"),cs.innerHTML=$e,vl=t(),c(os.$$.fragment),Sl=t(),rs=p("p"),rs.innerHTML=Ve,Rl=t(),c(ys.$$.fragment),Ql=t(),js=p("p"),js.textContent=He,Yl=t(),Us=p("pre"),Us.innerHTML=Xe,El=t(),c(hs.$$.fragment),$l=t(),ws=p("p"),ws.innerHTML=ze,Vl=t(),c(Js.$$.fragment),Hl=t(),Ts=p("p"),Ts.innerHTML=Fe,Xl=t(),c(ds.$$.fragment),zl=t(),ms=p("p"),ms.innerHTML=Le,Fl=t(),u=p("ol"),us=p("li"),Rs=p("p"),Rs.innerHTML=_e,ce=t(),c(Cs.$$.fragment),oe=t(),fs=p("li"),Qs=p("p"),Qs.innerHTML=Pe,re=t(),c(Is.$$.fragment),Ll=t(),c(bs.$$.fragment),_l=t(),gs=p("p"),gs.innerHTML=qe,Pl=t(),c(Zs.$$.fragment),ql=t(),Bs=p("p"),Bs.textContent=Ke,Kl=t(),c(Gs.$$.fragment),Dl=t(),ks=p("p"),ks.innerHTML=De,Ol=t(),c(Ns.$$.fragment),se=t(),xs=p("p"),xs.innerHTML=Oe,le=t(),J=p("ol"),Ys=p("li"),Ys.innerHTML=sa,ye=t(),Es=p("li"),Es.innerHTML=la,je=t(),$s=p("li"),$s.textContent=ea,Ue=t(),Vs=p("li"),Vs.innerHTML=aa,he=t(),C=p("li"),we=pa("Add the following lines to the top of your "),Hs=p("code"),Hs.textContent=ta,Je=pa(`:
	`),c(As.$$.fragment),ee=t(),Ws=p("p"),Ws.innerHTML=na,ae=t(),c(vs.$$.fragment),te=t(),zs=p("p"),this.h()},l(s){const l=Ua("svelte-u9bgzb",document.head);m=M(l,"META",{name:!0,content:!0}),l.forEach(e),Ls=n(s),Xs=M(s,"P",{}),Ss(Xs).forEach(e),_s=n(s),o(f.$$.fragment,s),Ps=n(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1nylfgr"&&(I.innerHTML=de),qs=n(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-17tgu1r"&&(b.innerHTML=me),Ks=n(s),g=M(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1tlxmzn"&&(g.textContent=ue),Ds=n(s),Z=M(s,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-10avis"&&(Z.innerHTML=Ce),Os=n(s),o(B.$$.fragment,s),sl=n(s),G=M(s,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-1qy4daj"&&(G.innerHTML=fe),ll=n(s),o(k.$$.fragment,s),el=n(s),o(N.$$.fragment,s),al=n(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1czujs6"&&(x.innerHTML=Ie),tl=n(s),o(A.$$.fragment,s),nl=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1e2sayh"&&(W.textContent=be),pl=n(s),v=M(s,"PRE",{"data-svelte-h":!0}),i(v)!=="svelte-raz40n"&&(v.innerHTML=ge),Ml=n(s),o(S.$$.fragment,s),il=n(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1riis2c"&&(R.innerHTML=Ze),cl=n(s),o(Q.$$.fragment,s),ol=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-15lfmif"&&(Y.innerHTML=Be),rl=n(s),o(E.$$.fragment,s),yl=n(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-u8iy0u"&&($.innerHTML=Ge),jl=n(s),o(V.$$.fragment,s),Ul=n(s),o(H.$$.fragment,s),hl=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1bw7883"&&(X.innerHTML=ke),wl=n(s),o(z.$$.fragment,s),Jl=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-oz1fe5"&&(F.innerHTML=Ne),Tl=n(s),o(L.$$.fragment,s),dl=n(s),_=M(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-g6jg3k"&&(_.innerHTML=xe),ml=n(s),o(P.$$.fragment,s),ul=n(s),q=M(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1dv45qm"&&(q.innerHTML=Ae),Cl=n(s),o(K.$$.fragment,s),fl=n(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-io8j5y"&&(D.textContent=We),Il=n(s),o(O.$$.fragment,s),bl=n(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-1fua6wp"&&(ss.innerHTML=ve),gl=n(s),o(ls.$$.fragment,s),Zl=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-1mj3vkj"&&(es.textContent=Se),Bl=n(s),o(as.$$.fragment,s),Gl=n(s),ts=M(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-7b0fyw"&&(ts.innerHTML=Re),kl=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1c1gg25"&&(ns.innerHTML=Qe),Nl=n(s),ps=M(s,"OL",{"data-svelte-h":!0}),i(ps)!=="svelte-1qoae7i"&&(ps.innerHTML=Ye),xl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-181xlpv"&&(Ms.innerHTML=Ee),Al=n(s),o(is.$$.fragment,s),Wl=n(s),cs=M(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-1fep2js"&&(cs.innerHTML=$e),vl=n(s),o(os.$$.fragment,s),Sl=n(s),rs=M(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1czujs6"&&(rs.innerHTML=Ve),Rl=n(s),o(ys.$$.fragment,s),Ql=n(s),js=M(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-1e2sayh"&&(js.textContent=He),Yl=n(s),Us=M(s,"PRE",{"data-svelte-h":!0}),i(Us)!=="svelte-raz40n"&&(Us.innerHTML=Xe),El=n(s),o(hs.$$.fragment,s),$l=n(s),ws=M(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-1riis2c"&&(ws.innerHTML=ze),Vl=n(s),o(Js.$$.fragment,s),Hl=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-e504gd"&&(Ts.innerHTML=Fe),Xl=n(s),o(ds.$$.fragment,s),zl=n(s),ms=M(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-ln1yih"&&(ms.innerHTML=Le),Fl=n(s),u=M(s,"OL",{});var pe=Ss(u);us=M(pe,"LI",{});var Me=Ss(us);Rs=M(Me,"P",{"data-svelte-h":!0}),i(Rs)!=="svelte-hhkldd"&&(Rs.innerHTML=_e),ce=n(Me),o(Cs.$$.fragment,Me),Me.forEach(e),oe=n(pe),fs=M(pe,"LI",{});var ie=Ss(fs);Qs=M(ie,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-8ih7ic"&&(Qs.innerHTML=Pe),re=n(ie),o(Is.$$.fragment,ie),ie.forEach(e),pe.forEach(e),Ll=n(s),o(bs.$$.fragment,s),_l=n(s),gs=M(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-1gfy2af"&&(gs.innerHTML=qe),Pl=n(s),o(Zs.$$.fragment,s),ql=n(s),Bs=M(s,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-io8j5y"&&(Bs.textContent=Ke),Kl=n(s),o(Gs.$$.fragment,s),Dl=n(s),ks=M(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1fua6wp"&&(ks.innerHTML=De),Ol=n(s),o(Ns.$$.fragment,s),se=n(s),xs=M(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-1cz80l1"&&(xs.innerHTML=Oe),le=n(s),J=M(s,"OL",{});var d=Ss(J);Ys=M(d,"LI",{"data-svelte-h":!0}),i(Ys)!=="svelte-1vfzf1x"&&(Ys.innerHTML=sa),ye=n(d),Es=M(d,"LI",{"data-svelte-h":!0}),i(Es)!=="svelte-a197qz"&&(Es.innerHTML=la),je=n(d),$s=M(d,"LI",{"data-svelte-h":!0}),i($s)!=="svelte-1ne6ri6"&&($s.textContent=ea),Ue=n(d),Vs=M(d,"LI",{"data-svelte-h":!0}),i(Vs)!=="svelte-1vsgr21"&&(Vs.innerHTML=aa),he=n(d),C=M(d,"LI",{});var Fs=Ss(C);we=Ma(Fs,"Add the following lines to the top of your "),Hs=M(Fs,"CODE",{"data-svelte-h":!0}),i(Hs)!=="svelte-87wnd9"&&(Hs.textContent=ta),Je=Ma(Fs,`:
	`),o(As.$$.fragment,Fs),Fs.forEach(e),d.forEach(e),ee=n(s),Ws=M(s,"P",{"data-svelte-h":!0}),i(Ws)!=="svelte-181xlpv"&&(Ws.innerHTML=na),ae=n(s),o(vs.$$.fragment,s),te=n(s),zs=M(s,"P",{}),Ss(zs).forEach(e),this.h()},h(){ia(m,"name","hf:doc:metadata"),ia(m,"content",Ja)},m(s,l){h(document.head,m),a(s,Ls,l),a(s,Xs,l),a(s,_s,l),r(f,s,l),a(s,Ps,l),a(s,I,l),a(s,qs,l),a(s,b,l),a(s,Ks,l),a(s,g,l),a(s,Ds,l),a(s,Z,l),a(s,Os,l),r(B,s,l),a(s,sl,l),a(s,G,l),a(s,ll,l),r(k,s,l),a(s,el,l),r(N,s,l),a(s,al,l),a(s,x,l),a(s,tl,l),r(A,s,l),a(s,nl,l),a(s,W,l),a(s,pl,l),a(s,v,l),a(s,Ml,l),r(S,s,l),a(s,il,l),a(s,R,l),a(s,cl,l),r(Q,s,l),a(s,ol,l),a(s,Y,l),a(s,rl,l),r(E,s,l),a(s,yl,l),a(s,$,l),a(s,jl,l),r(V,s,l),a(s,Ul,l),r(H,s,l),a(s,hl,l),a(s,X,l),a(s,wl,l),r(z,s,l),a(s,Jl,l),a(s,F,l),a(s,Tl,l),r(L,s,l),a(s,dl,l),a(s,_,l),a(s,ml,l),r(P,s,l),a(s,ul,l),a(s,q,l),a(s,Cl,l),r(K,s,l),a(s,fl,l),a(s,D,l),a(s,Il,l),r(O,s,l),a(s,bl,l),a(s,ss,l),a(s,gl,l),r(ls,s,l),a(s,Zl,l),a(s,es,l),a(s,Bl,l),r(as,s,l),a(s,Gl,l),a(s,ts,l),a(s,kl,l),a(s,ns,l),a(s,Nl,l),a(s,ps,l),a(s,xl,l),a(s,Ms,l),a(s,Al,l),r(is,s,l),a(s,Wl,l),a(s,cs,l),a(s,vl,l),r(os,s,l),a(s,Sl,l),a(s,rs,l),a(s,Rl,l),r(ys,s,l),a(s,Ql,l),a(s,js,l),a(s,Yl,l),a(s,Us,l),a(s,El,l),r(hs,s,l),a(s,$l,l),a(s,ws,l),a(s,Vl,l),r(Js,s,l),a(s,Hl,l),a(s,Ts,l),a(s,Xl,l),r(ds,s,l),a(s,zl,l),a(s,ms,l),a(s,Fl,l),a(s,u,l),h(u,us),h(us,Rs),h(us,ce),r(Cs,us,null),h(u,oe),h(u,fs),h(fs,Qs),h(fs,re),r(Is,fs,null),a(s,Ll,l),r(bs,s,l),a(s,_l,l),a(s,gs,l),a(s,Pl,l),r(Zs,s,l),a(s,ql,l),a(s,Bs,l),a(s,Kl,l),r(Gs,s,l),a(s,Dl,l),a(s,ks,l),a(s,Ol,l),r(Ns,s,l),a(s,se,l),a(s,xs,l),a(s,le,l),a(s,J,l),h(J,Ys),h(J,ye),h(J,Es),h(J,je),h(J,$s),h(J,Ue),h(J,Vs),h(J,he),h(J,C),h(C,we),h(C,Hs),h(C,Je),r(As,C,null),a(s,ee,l),a(s,Ws,l),a(s,ae,l),r(vs,s,l),a(s,te,l),a(s,zs,l),ne=!0},p:oa,i(s){ne||(y(f.$$.fragment,s),y(B.$$.fragment,s),y(k.$$.fragment,s),y(N.$$.fragment,s),y(A.$$.fragment,s),y(S.$$.fragment,s),y(Q.$$.fragment,s),y(E.$$.fragment,s),y(V.$$.fragment,s),y(H.$$.fragment,s),y(z.$$.fragment,s),y(L.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(ls.$$.fragment,s),y(as.$$.fragment,s),y(is.$$.fragment,s),y(os.$$.fragment,s),y(ys.$$.fragment,s),y(hs.$$.fragment,s),y(Js.$$.fragment,s),y(ds.$$.fragment,s),y(Cs.$$.fragment,s),y(Is.$$.fragment,s),y(bs.$$.fragment,s),y(Zs.$$.fragment,s),y(Gs.$$.fragment,s),y(Ns.$$.fragment,s),y(As.$$.fragment,s),y(vs.$$.fragment,s),ne=!0)},o(s){j(f.$$.fragment,s),j(B.$$.fragment,s),j(k.$$.fragment,s),j(N.$$.fragment,s),j(A.$$.fragment,s),j(S.$$.fragment,s),j(Q.$$.fragment,s),j(E.$$.fragment,s),j(V.$$.fragment,s),j(H.$$.fragment,s),j(z.$$.fragment,s),j(L.$$.fragment,s),j(P.$$.fragment,s),j(K.$$.fragment,s),j(O.$$.fragment,s),j(ls.$$.fragment,s),j(as.$$.fragment,s),j(is.$$.fragment,s),j(os.$$.fragment,s),j(ys.$$.fragment,s),j(hs.$$.fragment,s),j(Js.$$.fragment,s),j(ds.$$.fragment,s),j(Cs.$$.fragment,s),j(Is.$$.fragment,s),j(bs.$$.fragment,s),j(Zs.$$.fragment,s),j(Gs.$$.fragment,s),j(Ns.$$.fragment,s),j(As.$$.fragment,s),j(vs.$$.fragment,s),ne=!1},d(s){s&&(e(Ls),e(Xs),e(_s),e(Ps),e(I),e(qs),e(b),e(Ks),e(g),e(Ds),e(Z),e(Os),e(sl),e(G),e(ll),e(el),e(al),e(x),e(tl),e(nl),e(W),e(pl),e(v),e(Ml),e(il),e(R),e(cl),e(ol),e(Y),e(rl),e(yl),e($),e(jl),e(Ul),e(hl),e(X),e(wl),e(Jl),e(F),e(Tl),e(dl),e(_),e(ml),e(ul),e(q),e(Cl),e(fl),e(D),e(Il),e(bl),e(ss),e(gl),e(Zl),e(es),e(Bl),e(Gl),e(ts),e(kl),e(ns),e(Nl),e(ps),e(xl),e(Ms),e(Al),e(Wl),e(cs),e(vl),e(Sl),e(rs),e(Rl),e(Ql),e(js),e(Yl),e(Us),e(El),e($l),e(ws),e(Vl),e(Hl),e(Ts),e(Xl),e(zl),e(ms),e(Fl),e(u),e(Ll),e(_l),e(gs),e(Pl),e(ql),e(Bs),e(Kl),e(Dl),e(ks),e(Ol),e(se),e(xs),e(le),e(J),e(ee),e(Ws),e(ae),e(te),e(zs)),e(m),U(f,s),U(B,s),U(k,s),U(N,s),U(A,s),U(S,s),U(Q,s),U(E,s),U(V,s),U(H,s),U(z,s),U(L,s),U(P,s),U(K,s),U(O,s),U(ls,s),U(as,s),U(is,s),U(os,s),U(ys,s),U(hs,s),U(Js,s),U(ds,s),U(Cs),U(Is),U(bs,s),U(Zs,s),U(Gs,s),U(Ns,s),U(As),U(vs,s)}}}const Ja='{"title":"Building a Next.js application","local":"building-a-nextjs-application","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Client-side inference","local":"client-side-inference","sections":[{"title":"Step 1: Initialise the project","local":"step-1-initialise-the-project","sections":[],"depth":3},{"title":"Step 2: Install and configure Transformers.js","local":"step-2-install-and-configure-transformersjs","sections":[],"depth":3},{"title":"Step 3: Design the user interface","local":"step-3-design-the-user-interface","sections":[],"depth":3},{"title":"(Optional) Step 4: Build and deploy","local":"optional-step-4-build-and-deploy","sections":[],"depth":3}],"depth":2},{"title":"Server-side inference","local":"server-side-inference","sections":[{"title":"Step 1: Initialise the project","local":"step-1-initialise-the-project","sections":[],"depth":3},{"title":"Step 2: Install and configure Transformers.js","local":"step-2-install-and-configure-transformersjs","sections":[],"depth":3},{"title":"Step 3: Design the user interface","local":"step-3-design-the-user-interface","sections":[],"depth":3},{"title":"(Optional) Step 4: Build and deploy","local":"optional-step-4-build-and-deploy","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ta(Te){return ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends ya{constructor(m){super(),ja(this,m,Ta,wa,ca,{})}}export{fa as component};
