import{s as da,n as ua,o as ma}from"../chunks/scheduler.d6170356.js";import{S as Ma,i as ca,g as s,s as n,r as h,A as ga,h as o,f as l,c as i,j as c,u as y,x as r,k as il,y as p,a,v as f,d,t as u,w as m}from"../chunks/index.fcd4cc08.js";import{C as M}from"../chunks/CodeBlock.7b16bdef.js";import{H as w,E as wa}from"../chunks/EditOnGithub.da2b595c.js";function Ta(bl){let b,Oe,ze,Ke,I,et,v,_l='The Hugging Face Hub aims to facilitate sharing machine learning models, checkpoints, and artifacts. This endeavor includes integrating the Hub into many of the amazing third-party libraries in the community. Some of the ones already integrated include <a href="https://spacy.io/usage/projects#huggingface_hub" rel="nofollow">spaCy</a>, <a href="https://allennlp.org/" rel="nofollow">AllenNLP</a>, and <a href="https://rwightman.github.io/pytorch-image-models/" rel="nofollow">timm</a>, among many others. Integration means users can download and upload files to the Hub directly from your library. We hope you will integrate your library and join us in democratizing artificial intelligence for everyone.',tt,k,Jl="Integrating the Hub with your library provides many benefits, including:",lt,x,Cl='<li>Free model hosting for you and your users.</li> <li>Built-in file versioning - even for huge files - made possible by <a href="https://git-lfs.github.com/" rel="nofollow">Git-LFS</a>.</li> <li>All public models are powered by the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>.</li> <li>In-browser widgets allow users to interact with your hosted models directly.</li>',at,H,jl="This tutorial will help you integrate the Hub into your library so your users can benefit from all the features offered by the Hub.",nt,A,$l='Before you begin, we recommend you create a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face account</a> from which you can manage your repositories and files.',it,N,Il='If you need help with the integration, feel free to open an <a href="https://github.com/huggingface/huggingface_hub/issues/new/choose" rel="nofollow">issue</a>, and we would be more than happy to help you.',st,L,ot,T,Q,Le,vl="Install the <code>huggingface_hub</code> library with pip in your environment:",sl,X,ol,_,Qe,kl="Once you have successfully installed the <code>huggingface_hub</code> library, log in to your Hugging Face account:",rl,Z,pl,D,hl,J,Xe,xl="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, login with <code>notebook_login</code>:",yl,G,fl,Ze,Hl="<code>notebook_login</code> will launch a widget in your notebook from which you can enter your Hugging Face credentials.",rt,F,pt,B,Al="Integration allows users to download your hosted files directly from the Hub using your library.",ht,P,Nl="Use the <code>hf_hub_download</code> function to retrieve a URL and download files from your repository. Downloaded files are stored in your cache: <code>~/.cache/huggingface/hub</code>. You don’t have to re-download the file the next time you use it, and for larger files, this can save a lot of time. Furthermore, if the repository is updated with a new version of the file, <code>huggingface_hub</code> will automatically download the latest version and store it in the cache for you. Users don’t have to worry about updating their files.",yt,E,Ll='For example, download the <code>config.json</code> file from the <a href="https://huggingface.co/lysandre/arxiv-nlp" rel="nofollow">lysandre/arxiv-nlp</a> repository:',ft,W,dt,q,Ql="Download a specific version of the file by specifying the <code>revision</code> parameter. The <code>revision</code> parameter can be a branch name, tag, or commit hash.",ut,Y,Xl="The commit hash must be a full-length hash instead of the shorter 7-character commit hash:",mt,S,Mt,R,Zl="Use the <code>cache_dir</code> parameter to change where a file is stored:",ct,z,gt,V,wt,O,Dl="We recommend adding a code snippet to explain how to use a model in your downstream library.",Tt,C,Gl='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet-dark.png"/>',Ut,K,Fl='First, register your library by editing <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">model-libaries.ts</a>.',bt,ee,Bl='Then, add a code snippet by updating the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries-snippets.ts" rel="nofollow">model-libraries-snippets.ts</a> file with instructions for your model. For example, the <a href="https://huggingface.co/asteroid-team" rel="nofollow">Asteroid</a> integration includes a brief code snippet for how to load and use an Asteroid model:',_t,te,Jt,le,Pl="Doing so will also add a tag to your model so users can quickly identify models from your library.",Ct,j,El='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags-dark.png"/>',jt,ae,$t,ne,Wl="You might also want to provide a method for creating model repositories and uploading files to the Hub directly from your library. The <code>huggingface_hub</code> library offers two ways to assist you with creating repositories and uploading files:",It,ie,ql="<li><code>create_repo</code> creates a repository on the Hub.</li> <li><code>upload_file</code> directly uploads files to a repository on the Hub.</li>",vt,se,kt,oe,Yl="The <code>create_repo</code> method creates a repository on the Hub. Use the <code>name</code> parameter to provide a name for your repository:",xt,re,Ht,pe,Sl="When you check your Hugging Face account, you should now see a <code>test-model</code> repository under your namespace.",At,he,Nt,ye,Rl="The <code>upload_file</code> method uploads files to the Hub. This method requires the following:",Lt,fe,zl="<li>A path to the file to upload.</li> <li>The final path in the repository.</li> <li>The repository you wish to push the files to.</li>",Qt,de,Vl="For example:",Xt,ue,Zt,me,Ol='If you need to upload more than one file, look at the <a href="https://huggingface.co/docs/huggingface_hub/package_reference/repository" rel="nofollow">utilities offered by the <code>Repository</code> class</a>.',Dt,Me,Kl="Once again, if you check your Hugging Face account, you should see the file inside your repository.",Gt,ce,ea='Lastly, it is important to add a model card so users understand how to use your model. See <a href="./model-cards">here</a> for more details about how to create a model card.',Ft,ge,Bt,we,ta="Our Inference API powers models uploaded to the Hub through your library.",Pt,Te,Et,Ue,la='All third-party libraries are Dockerized, so you can install the dependencies you’ll need for your library to work correctly. Add your library to the existing Docker images by navigating to the <a href="https://github.com/huggingface/api-inference-community/tree/main/docker_images" rel="nofollow">Docker images folder</a>.',Wt,U,De,aa="<p>Copy the <code>common</code> folder and rename it with the name of your library (e.g. <code>docker/common</code> to <code>docker/your-awesome-library</code>).</p>",dl,be,Ge,na="There are four files you need to edit:",ul,g,Fe,ia="<p>List the packages required for your library to work in <code>requirements.txt</code>.</p>",ml,_e,Be,sa='Update <code>app/main.py</code> with the tasks supported by your model (see <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">here</a> for a complete list of available tasks). Look out for the <code>IMPLEMENT_THIS</code> flag to add your supported task.',Ml,Je,cl,Pe,oa='<p>For each task your library supports, modify the <code>app/pipelines/task_name.py</code> files accordingly. We have also added an <code>IMPLEMENT_THIS</code> flag in the pipeline files to guide you. If there isn’t a pipeline that supports your task, feel free to add one. Open an <a href="https://github.com/huggingface/huggingface.js/issues/new" rel="nofollow">issue</a> here, and we will be happy to help you.</p>',gl,Ce,Ee,ra="Add your model and task to the <code>tests/test_api.py</code> file. For example, if you have a text generation model:",wl,je,Tl,$e,We,pa="Finally, run the following test to ensure everything works as expected:",Ul,Ie,qt,ve,Yt,ke,ha='To register the tasks supported by your library on the hub you’ll need to add a mapping from your library name to its supported tasks in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/library-to-tasks.ts" rel="nofollow">library-to-tasks.ts file</a>. This will ensure the inference API is registered for tasks supported by your model. This file is automatically generated as part of a <a href="https://github.com/huggingface/api-inference-community/actions/workflows/python-api-export-tasks.yaml" rel="nofollow">GitHub Action</a> in the <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">api-inference-community repository</a> repository. You can see an example of this <a href="https://github.com/huggingface/api-inference-community/actions/runs/5126874210/jobs/9221890853#step:5:8" rel="nofollow">here</a>.',St,xe,ya="With these simple but powerful methods, you brought the full functionality of the Hub into your library. Users can download files stored on the Hub from your library with <code>hf_hub_download</code>, create repositories with <code>create_repo</code>, and upload files with <code>upload_file</code>. You also set up Inference API with your library, allowing users to interact with your models on the Hub from inside a browser.",Rt,He,zt,Ae,fa='Finally, you can add your library to the Hub’s documentation. Check for example the <a href="https://github.com/huggingface/hub-docs/pull/1150" rel="nofollow">Setfit PR</a> that added <a href="./setfit">SetFit</a> to the documentation.',Vt,Ne,Ot,Ve,Kt;return I=new w({props:{title:"Integrate your library with the Hub",local:"integrate-your-library-with-the-hub",headingTag:"h1"}}),L=new w({props:{title:"Installation",local:"installation",headingTag:"h2"}}),X=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"python -m pip install huggingface_hub",wrap:!1}}),Z=new M({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),D=new M({props:{code:"JTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0NfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTBBJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUwQSUyMCUyMCUyMCUyMCUyMCUwQVVzZXJuYW1lJTNBJTIwJTBBUGFzc3dvcmQlM0E=",highlighted:`     _|    _|  _|    _|    _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|_|_|_|    _|_|      _|_|_|  _|_|_|_|
     _|    _|  _|    _|  _|        _|          _|    _|_|    _|  _|            _|        _|    _|  _|        _|
     _|_|_|_|  _|    _|  _|  _|_|  _|  _|_|    _|    _|  _|  _|  _|  _|_|      _|_|_|    _|_|_|_|  _|        _|_|_|
     _|    _|  _|    _|  _|    _|  _|    _|    _|    _|    _|_|  _|    _|      _|        _|    _|  _|        _|
     _|    _|    _|_|      _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|        _|    _|    _|_|_|  _|_|_|_|

     
Username: 
Password:`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),F=new w({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h2"}}),W=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),z=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwY2FjaGVfZGlyJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, cache_dir=<span class="hljs-string">&quot;/home/lysandre/test&quot;</span>)`,wrap:!1}}),V=new w({props:{title:"Code sample",local:"code-sample",headingTag:"h3"}}),te=new M({props:{code:"Y29uc3QlMjBhc3Rlcm9pZCUyMCUzRCUyMChtb2RlbCUzQSUyME1vZGVsRGF0YSklMjAlM0QlM0UlMEElNjBmcm9tJTIwYXN0ZXJvaWQubW9kZWxzJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTBBJTIwJTIwJTBBbW9kZWwlMjAlM0QlMjBCYXNlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyNCU3Qm1vZGVsLmlkJTdEJTIyKSU2MCUzQg==",highlighted:'<span class="hljs-keyword">const</span> <span class="hljs-title function_">asteroid</span> = (<span class="hljs-params">model: ModelData</span>) =&gt;\n<span class="hljs-string">`from asteroid.models import BaseModel\n  \nmodel = BaseModel.from_pretrained(&quot;<span class="hljs-subst">${model.id}</span>&quot;)`</span>;',wrap:!1}}),ae=new w({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h2"}}),se=new w({props:{title:"create_repo",local:"createrepo",headingTag:"h3"}}),re=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8ocmVwb19pZCUzRCUyMnRlc3QtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(repo_id=<span class="hljs-string">&quot;test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),he=new w({props:{title:"upload_file",local:"uploadfile",headingTag:"h3"}}),ue=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGZHVtbXktdGVzdCUyRlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRnRlc3QtbW9kZWwlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>   path_or_fileobj=<span class="hljs-string">&quot;/home/lysandre/dummy-test/README.md&quot;</span>, 
<span class="hljs-meta">... </span>   path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, 
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model/blob/main/README.md&#x27;</span>`,wrap:!1}}),ge=new w({props:{title:"Set up the Inference API",local:"set-up-the-inference-api",headingTag:"h2"}}),Te=new w({props:{title:"Create an Inference API Docker image",local:"create-an-inference-api-docker-image",headingTag:"h3"}}),Je=new M({props:{code:"QUxMT1dFRF9UQVNLUyUzQSUyMERpY3QlNUJzdHIlMkMlMjBUeXBlJTVCUGlwZWxpbmUlNUQlNUQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0b2tlbi1jbGFzc2lmaWNhdGlvbiUyMiUzQSUyMFRva2VuQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQSU3RA==",highlighted:`ALLOWED_TASKS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Type</span>[Pipeline]] = {
    <span class="hljs-string">&quot;token-classification&quot;</span>: TokenClassificationPipeline
}`,wrap:!1}}),je=new M({props:{code:"VEVTVEFCTEVfTU9ERUxTJTNBJTIwRGljdCU1QnN0ciUyQ3N0ciU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUzQSUyMCUyMm15LWdwdDItbW9kZWwlMjIlMEElN0Q=",highlighted:`TESTABLE_MODELS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>,<span class="hljs-built_in">str</span>] = {
    <span class="hljs-string">&quot;text-generation&quot;</span>: <span class="hljs-string">&quot;my-gpt2-model&quot;</span>
}`,wrap:!1}}),Ie=new M({props:{code:"cHl0ZXN0JTIwLXN2JTIwLS1yb290ZGlyJTIwZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJGZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJG",highlighted:"pytest -sv --rootdir docker_images/your-awesome-library/docker_images/your-awesome-library/",wrap:!1}}),ve=new w({props:{title:"Register your libraries supported tasks on the hub",local:"register-your-libraries-supported-tasks-on-the-hub",headingTag:"h3"}}),He=new w({props:{title:"Document your library",local:"document-your-library",headingTag:"h2"}}),Ne=new wa({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/models-adding-libraries.md"}}),{c(){b=s("meta"),Oe=n(),ze=s("p"),Ke=n(),h(I.$$.fragment),et=n(),v=s("p"),v.innerHTML=_l,tt=n(),k=s("p"),k.textContent=Jl,lt=n(),x=s("ul"),x.innerHTML=Cl,at=n(),H=s("p"),H.textContent=jl,nt=n(),A=s("p"),A.innerHTML=$l,it=n(),N=s("p"),N.innerHTML=Il,st=n(),h(L.$$.fragment),ot=n(),T=s("ol"),Q=s("li"),Le=s("p"),Le.innerHTML=vl,sl=n(),h(X.$$.fragment),ol=n(),_=s("li"),Qe=s("p"),Qe.innerHTML=kl,rl=n(),h(Z.$$.fragment),pl=n(),h(D.$$.fragment),hl=n(),J=s("li"),Xe=s("p"),Xe.innerHTML=xl,yl=n(),h(G.$$.fragment),fl=n(),Ze=s("p"),Ze.innerHTML=Hl,rt=n(),h(F.$$.fragment),pt=n(),B=s("p"),B.textContent=Al,ht=n(),P=s("p"),P.innerHTML=Nl,yt=n(),E=s("p"),E.innerHTML=Ll,ft=n(),h(W.$$.fragment),dt=n(),q=s("p"),q.innerHTML=Ql,ut=n(),Y=s("p"),Y.textContent=Xl,mt=n(),h(S.$$.fragment),Mt=n(),R=s("p"),R.innerHTML=Zl,ct=n(),h(z.$$.fragment),gt=n(),h(V.$$.fragment),wt=n(),O=s("p"),O.textContent=Dl,Tt=n(),C=s("div"),C.innerHTML=Gl,Ut=n(),K=s("p"),K.innerHTML=Fl,bt=n(),ee=s("p"),ee.innerHTML=Bl,_t=n(),h(te.$$.fragment),Jt=n(),le=s("p"),le.textContent=Pl,Ct=n(),j=s("div"),j.innerHTML=El,jt=n(),h(ae.$$.fragment),$t=n(),ne=s("p"),ne.innerHTML=Wl,It=n(),ie=s("ul"),ie.innerHTML=ql,vt=n(),h(se.$$.fragment),kt=n(),oe=s("p"),oe.innerHTML=Yl,xt=n(),h(re.$$.fragment),Ht=n(),pe=s("p"),pe.innerHTML=Sl,At=n(),h(he.$$.fragment),Nt=n(),ye=s("p"),ye.innerHTML=Rl,Lt=n(),fe=s("ul"),fe.innerHTML=zl,Qt=n(),de=s("p"),de.textContent=Vl,Xt=n(),h(ue.$$.fragment),Zt=n(),me=s("p"),me.innerHTML=Ol,Dt=n(),Me=s("p"),Me.textContent=Kl,Gt=n(),ce=s("p"),ce.innerHTML=ea,Ft=n(),h(ge.$$.fragment),Bt=n(),we=s("p"),we.textContent=ta,Pt=n(),h(Te.$$.fragment),Et=n(),Ue=s("p"),Ue.innerHTML=la,Wt=n(),U=s("ol"),De=s("li"),De.innerHTML=aa,dl=n(),be=s("li"),Ge=s("p"),Ge.textContent=na,ul=n(),g=s("ul"),Fe=s("li"),Fe.innerHTML=ia,ml=n(),_e=s("li"),Be=s("p"),Be.innerHTML=sa,Ml=n(),h(Je.$$.fragment),cl=n(),Pe=s("li"),Pe.innerHTML=oa,gl=n(),Ce=s("li"),Ee=s("p"),Ee.innerHTML=ra,wl=n(),h(je.$$.fragment),Tl=n(),$e=s("li"),We=s("p"),We.textContent=pa,Ul=n(),h(Ie.$$.fragment),qt=n(),h(ve.$$.fragment),Yt=n(),ke=s("p"),ke.innerHTML=ha,St=n(),xe=s("p"),xe.innerHTML=ya,Rt=n(),h(He.$$.fragment),zt=n(),Ae=s("p"),Ae.innerHTML=fa,Vt=n(),h(Ne.$$.fragment),Ot=n(),Ve=s("p"),this.h()},l(e){const t=ga("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),Oe=i(e),ze=o(e,"P",{}),c(ze).forEach(l),Ke=i(e),y(I.$$.fragment,e),et=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-wqzoze"&&(v.innerHTML=_l),tt=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1h76lqo"&&(k.textContent=Jl),lt=i(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1f2b9dq"&&(x.innerHTML=Cl),at=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-tideui"&&(H.textContent=jl),nt=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bv6wqp"&&(A.innerHTML=$l),it=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-5v9xsl"&&(N.innerHTML=Il),st=i(e),y(L.$$.fragment,e),ot=i(e),T=o(e,"OL",{});var qe=c(T);Q=o(qe,"LI",{});var el=c(Q);Le=o(el,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1un3zii"&&(Le.innerHTML=vl),sl=i(el),y(X.$$.fragment,el),el.forEach(l),ol=i(qe),_=o(qe,"LI",{});var Ye=c(_);Qe=o(Ye,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1n5fxns"&&(Qe.innerHTML=kl),rl=i(Ye),y(Z.$$.fragment,Ye),pl=i(Ye),y(D.$$.fragment,Ye),Ye.forEach(l),hl=i(qe),J=o(qe,"LI",{});var Se=c(J);Xe=o(Se,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-lceb1h"&&(Xe.innerHTML=xl),yl=i(Se),y(G.$$.fragment,Se),fl=i(Se),Ze=o(Se,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1utjkvu"&&(Ze.innerHTML=Hl),Se.forEach(l),qe.forEach(l),rt=i(e),y(F.$$.fragment,e),pt=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1xrlxrq"&&(B.textContent=Al),ht=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-mlcwe8"&&(P.innerHTML=Nl),yt=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-22k4ir"&&(E.innerHTML=Ll),ft=i(e),y(W.$$.fragment,e),dt=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nqohuu"&&(q.innerHTML=Ql),ut=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-jz20t2"&&(Y.textContent=Xl),mt=i(e),y(S.$$.fragment,e),Mt=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1g7ex70"&&(R.innerHTML=Zl),ct=i(e),y(z.$$.fragment,e),gt=i(e),y(V.$$.fragment,e),wt=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-kjqwtb"&&(O.textContent=Dl),Tt=i(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-k2vnd3"&&(C.innerHTML=Gl),Ut=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-w1r9fm"&&(K.innerHTML=Fl),bt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-z41kg9"&&(ee.innerHTML=Bl),_t=i(e),y(te.$$.fragment,e),Jt=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1s18u9b"&&(le.textContent=Pl),Ct=i(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1n378h3"&&(j.innerHTML=El),jt=i(e),y(ae.$$.fragment,e),$t=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1kwmyjl"&&(ne.innerHTML=Wl),It=i(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1kcwgoq"&&(ie.innerHTML=ql),vt=i(e),y(se.$$.fragment,e),kt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-rngk60"&&(oe.innerHTML=Yl),xt=i(e),y(re.$$.fragment,e),Ht=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-aiu9oy"&&(pe.innerHTML=Sl),At=i(e),y(he.$$.fragment,e),Nt=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-co0lqw"&&(ye.innerHTML=Rl),Lt=i(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-9phsay"&&(fe.innerHTML=zl),Qt=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gkqha7"&&(de.textContent=Vl),Xt=i(e),y(ue.$$.fragment,e),Zt=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-m2kxf2"&&(me.innerHTML=Ol),Dt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-269fdk"&&(Me.textContent=Kl),Gt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-dxh4k0"&&(ce.innerHTML=ea),Ft=i(e),y(ge.$$.fragment,e),Bt=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-lhddhv"&&(we.textContent=ta),Pt=i(e),y(Te.$$.fragment,e),Et=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-9nvj4e"&&(Ue.innerHTML=la),Wt=i(e),U=o(e,"OL",{});var Re=c(U);De=o(Re,"LI",{"data-svelte-h":!0}),r(De)!=="svelte-l76mxy"&&(De.innerHTML=aa),dl=i(Re),be=o(Re,"LI",{});var tl=c(be);Ge=o(tl,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-ey431t"&&(Ge.textContent=na),ul=i(tl),g=o(tl,"UL",{});var $=c(g);Fe=o($,"LI",{"data-svelte-h":!0}),r(Fe)!=="svelte-1nu45ed"&&(Fe.innerHTML=ia),ml=i($),_e=o($,"LI",{});var ll=c(_e);Be=o(ll,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-db8jal"&&(Be.innerHTML=sa),Ml=i(ll),y(Je.$$.fragment,ll),ll.forEach(l),cl=i($),Pe=o($,"LI",{"data-svelte-h":!0}),r(Pe)!=="svelte-1lyepfm"&&(Pe.innerHTML=oa),gl=i($),Ce=o($,"LI",{});var al=c(Ce);Ee=o(al,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1anbe36"&&(Ee.innerHTML=ra),wl=i(al),y(je.$$.fragment,al),al.forEach(l),$.forEach(l),tl.forEach(l),Tl=i(Re),$e=o(Re,"LI",{});var nl=c($e);We=o(nl,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1aut65a"&&(We.textContent=pa),Ul=i(nl),y(Ie.$$.fragment,nl),nl.forEach(l),Re.forEach(l),qt=i(e),y(ve.$$.fragment,e),Yt=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-c66868"&&(ke.innerHTML=ha),St=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-udfx7c"&&(xe.innerHTML=ya),Rt=i(e),y(He.$$.fragment,e),zt=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1bxz36b"&&(Ae.innerHTML=fa),Vt=i(e),y(Ne.$$.fragment,e),Ot=i(e),Ve=o(e,"P",{}),c(Ve).forEach(l),this.h()},h(){il(b,"name","hf:doc:metadata"),il(b,"content",Ua),il(C,"class","flex justify-center"),il(j,"class","flex justify-center")},m(e,t){p(document.head,b),a(e,Oe,t),a(e,ze,t),a(e,Ke,t),f(I,e,t),a(e,et,t),a(e,v,t),a(e,tt,t),a(e,k,t),a(e,lt,t),a(e,x,t),a(e,at,t),a(e,H,t),a(e,nt,t),a(e,A,t),a(e,it,t),a(e,N,t),a(e,st,t),f(L,e,t),a(e,ot,t),a(e,T,t),p(T,Q),p(Q,Le),p(Q,sl),f(X,Q,null),p(T,ol),p(T,_),p(_,Qe),p(_,rl),f(Z,_,null),p(_,pl),f(D,_,null),p(T,hl),p(T,J),p(J,Xe),p(J,yl),f(G,J,null),p(J,fl),p(J,Ze),a(e,rt,t),f(F,e,t),a(e,pt,t),a(e,B,t),a(e,ht,t),a(e,P,t),a(e,yt,t),a(e,E,t),a(e,ft,t),f(W,e,t),a(e,dt,t),a(e,q,t),a(e,ut,t),a(e,Y,t),a(e,mt,t),f(S,e,t),a(e,Mt,t),a(e,R,t),a(e,ct,t),f(z,e,t),a(e,gt,t),f(V,e,t),a(e,wt,t),a(e,O,t),a(e,Tt,t),a(e,C,t),a(e,Ut,t),a(e,K,t),a(e,bt,t),a(e,ee,t),a(e,_t,t),f(te,e,t),a(e,Jt,t),a(e,le,t),a(e,Ct,t),a(e,j,t),a(e,jt,t),f(ae,e,t),a(e,$t,t),a(e,ne,t),a(e,It,t),a(e,ie,t),a(e,vt,t),f(se,e,t),a(e,kt,t),a(e,oe,t),a(e,xt,t),f(re,e,t),a(e,Ht,t),a(e,pe,t),a(e,At,t),f(he,e,t),a(e,Nt,t),a(e,ye,t),a(e,Lt,t),a(e,fe,t),a(e,Qt,t),a(e,de,t),a(e,Xt,t),f(ue,e,t),a(e,Zt,t),a(e,me,t),a(e,Dt,t),a(e,Me,t),a(e,Gt,t),a(e,ce,t),a(e,Ft,t),f(ge,e,t),a(e,Bt,t),a(e,we,t),a(e,Pt,t),f(Te,e,t),a(e,Et,t),a(e,Ue,t),a(e,Wt,t),a(e,U,t),p(U,De),p(U,dl),p(U,be),p(be,Ge),p(be,ul),p(be,g),p(g,Fe),p(g,ml),p(g,_e),p(_e,Be),p(_e,Ml),f(Je,_e,null),p(g,cl),p(g,Pe),p(g,gl),p(g,Ce),p(Ce,Ee),p(Ce,wl),f(je,Ce,null),p(U,Tl),p(U,$e),p($e,We),p($e,Ul),f(Ie,$e,null),a(e,qt,t),f(ve,e,t),a(e,Yt,t),a(e,ke,t),a(e,St,t),a(e,xe,t),a(e,Rt,t),f(He,e,t),a(e,zt,t),a(e,Ae,t),a(e,Vt,t),f(Ne,e,t),a(e,Ot,t),a(e,Ve,t),Kt=!0},p:ua,i(e){Kt||(d(I.$$.fragment,e),d(L.$$.fragment,e),d(X.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(G.$$.fragment,e),d(F.$$.fragment,e),d(W.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(Ie.$$.fragment,e),d(ve.$$.fragment,e),d(He.$$.fragment,e),d(Ne.$$.fragment,e),Kt=!0)},o(e){u(I.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(Z.$$.fragment,e),u(D.$$.fragment,e),u(G.$$.fragment,e),u(F.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ie.$$.fragment,e),u(ve.$$.fragment,e),u(He.$$.fragment,e),u(Ne.$$.fragment,e),Kt=!1},d(e){e&&(l(Oe),l(ze),l(Ke),l(et),l(v),l(tt),l(k),l(lt),l(x),l(at),l(H),l(nt),l(A),l(it),l(N),l(st),l(ot),l(T),l(rt),l(pt),l(B),l(ht),l(P),l(yt),l(E),l(ft),l(dt),l(q),l(ut),l(Y),l(mt),l(Mt),l(R),l(ct),l(gt),l(wt),l(O),l(Tt),l(C),l(Ut),l(K),l(bt),l(ee),l(_t),l(Jt),l(le),l(Ct),l(j),l(jt),l($t),l(ne),l(It),l(ie),l(vt),l(kt),l(oe),l(xt),l(Ht),l(pe),l(At),l(Nt),l(ye),l(Lt),l(fe),l(Qt),l(de),l(Xt),l(Zt),l(me),l(Dt),l(Me),l(Gt),l(ce),l(Ft),l(Bt),l(we),l(Pt),l(Et),l(Ue),l(Wt),l(U),l(qt),l(Yt),l(ke),l(St),l(xe),l(Rt),l(zt),l(Ae),l(Vt),l(Ot),l(Ve)),l(b),m(I,e),m(L,e),m(X),m(Z),m(D),m(G),m(F,e),m(W,e),m(S,e),m(z,e),m(V,e),m(te,e),m(ae,e),m(se,e),m(re,e),m(he,e),m(ue,e),m(ge,e),m(Te,e),m(Je),m(je),m(Ie),m(ve,e),m(He,e),m(Ne,e)}}}const Ua='{"title":"Integrate your library with the Hub","local":"integrate-your-library-with-the-hub","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Code sample","local":"code-sample","sections":[],"depth":3}],"depth":2},{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"create_repo","local":"createrepo","sections":[],"depth":3},{"title":"upload_file","local":"uploadfile","sections":[],"depth":3}],"depth":2},{"title":"Set up the Inference API","local":"set-up-the-inference-api","sections":[{"title":"Create an Inference API Docker image","local":"create-an-inference-api-docker-image","sections":[],"depth":3},{"title":"Register your libraries supported tasks on the hub","local":"register-your-libraries-supported-tasks-on-the-hub","sections":[],"depth":3}],"depth":2},{"title":"Document your library","local":"document-your-library","sections":[],"depth":2}],"depth":1}';function ba(bl){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $a extends Ma{constructor(b){super(),ca(this,b,ba,Ta,da,{})}}export{$a as component};
