import argparse
import os
import sys

print("Command-line arguments:", sys.argv)

now_dir = os.getcwd()
sys.path.append(now_dir)
import sys

import tqdm as tq
from dotenv import load_dotenv
from scipy.io import wavfile

from assets.configs.config import Config
from lib.infer.modules.vc.modules import VC


def arg_parse() -> tuple:
    parser = argparse.ArgumentParser()
    parser.add_argument("--f0up_key", type=int, default=0)
    parser.add_argument("--input_path", type=str, help="input path")
    parser.add_argument("--index_path", type=str, help="index path")
    parser.add_argument("--f0method", type=str, default="harvest", help="harvest or pm")
    parser.add_argument("--opt_path", type=str, help="opt path")
    parser.add_argument("--model_name", type=str, help="store in assets/weight_root")
    parser.add_argument("--index_rate", type=float, default=0.66, help="index rate")
    parser.add_argument("--device", type=str, help="device")
    parser.add_argument("--is_half", type=bool, help="use half -> True")
    parser.add_argument("--filter_radius", type=int, default=3, help="filter radius")
    parser.add_argument("--resample_sr", type=int, default=0, help="resample sr")
    parser.add_argument("--rms_mix_rate", type=float, default=1, help="rms mix rate")
    parser.add_argument("--protect", type=float, default=0.33, help="protect")

    args = parser.parse_args()
    sys.argv = sys.argv[:1]

    return args


def main():
    load_dotenv()
    args = arg_parse()
    config = Config()
    config.device = args.device if args.device else config.device
    config.is_half = args.is_half if args.is_half else config.is_half
    vc = VC(config)
    vc.get_vc(args.model_name)
    audios = os.listdir(args.input_path)
    for file in tq.tqdm(audios):
        if file.endswith(".wav"):
            file_path = os.path.join(args.input_path, file)
            _, wav_opt = vc.vc_single(
                0,
                file_path,
                args.f0up_key,
                None,
                args.f0method,
                args.index_path,
                None,
                args.index_rate,
                args.filter_radius,
                args.resample_sr,
                args.rms_mix_rate,
                args.protect,
            )
            out_path = os.path.join(args.opt_path, file)
            wavfile.write(out_path, wav_opt[0], wav_opt[1])


if __name__ == "__main__":
    main()
