#!/usr/bin/env python
# encoding: utf-8

from fastapi import FastAPI, Form, Depends, Request
from fastapi.templating import Jinja2Templates
from pydantic import BaseModel
import pickle
import json

app = FastAPI()

# Menentukan direktori templates
templates = Jinja2Templates(directory="templates")

class Msg(BaseModel):
    msg: str


class Req(BaseModel):
    age: int
    sex: int
    smoker: int
    bmi: float
    children: int
    region: int


@app.get("/welcomeMessage")
async def welcome():
    return {"message": "Hello World. Welcome to FastAPI!"}

@app.get("/")
async def root(request: Request):
    return templates.TemplateResponse(
        "index.html",
        {
            "request": request,
            "insurance_cost": 0,
        }
    )
