import gradio as gr
from fastai.vision.all import load_learner, PILImage

learn = load_learner("./export.pkl")


def shrimp_classifier(inp):
    nom, id, prob = learn.predict(inp)
    return {"Vampire shrimp" : float(prob[0]), "Cleaner shrimp" : float(prob[1]), "Sexy shrimp" : float(prob[2]), "Red Cherry shrimp" : float(prob[3])}


classifier = gr.Interface(fn=shrimp_classifier, inputs="image", outputs="label", examples="./examples", title="Shrimp classifier")

classifier.launch()