all = '''1 & 27.96/0.7853 & 28.24/0.7950 & 28.31/0.7961 & 28.25/0.7947 & 28.42/0.7987 & 28.32/0.7960
\\
2 & 35.39/0.8411 & 35.43/0.8424 & 35.43/0.8429 & 35.41/0.8424 & 35.45/0.8434 & 35.43/0.8426
\\
3 & 34.87/0.8769 & 35.12/0.8815 & 35.15/0.8818 & 35.11/0.8812 & 35.22/0.8831 & 35.18/0.8825
\\
4 & 32.33/0.8027 & 32.43/0.8048 & 32.43/0.8054 & 32.42/0.8051 & 32.47/0.8065 & 32.43/0.8056
\\
5 & 30.93/0.8502 & 31.46/0.8619 & 31.49/0.8627 & 31.44/0.8615 & 31.63/0.8658 & 31.49/0.8629
\\
6 & 28.98/0.8123 & 29.59/0.8283 & 29.64/0.8314 & 29.56/0.8281 & 29.78/0.8354 & 29.63/0.8303
\\
7 & 23.31/0.6780 & 23.60/0.6920 & 23.62/0.6950 & 23.60/0.6923 & 23.74/0.7005 & 23.66/0.6966
\\
8 & 25.97/0.7552 & 26.24/0.7662 & 26.26/0.7672 & 26.21/0.7653 & 26.32/0.7695 & 26.26/0.7672
\\
9 & 23.06/0.6636 & 23.27/0.6754 & 23.31/0.6784 & 23.26/0.6757 & 23.36/0.6822 & 23.30/0.6789
\\
10 & 37.39/0.8860 & 37.48/0.8877 & 37.51/0.8884 & 37.50/0.8883 & 37.52/0.8885 & 37.50/0.8882
\\
11 & 34.65/0.8620 & 34.90/0.8673 & 34.92/0.8676 & 34.90/0.8670 & 34.97/0.8688 & 34.93/0.8679
\\
12 & 27.50/0.6394 & 27.61/0.6457 & 27.62/0.6482 & 27.60/0.6452 & 27.66/0.6519 & 27.64/0.6495
\\
13 & 26.16/0.7576 & 26.53/0.7741 & 26.55/0.7762 & 26.50/0.7731 & 26.65/0.7807 & 26.56/0.7763
\\
14 & 33.27/0.7518 & 33.35/0.7539 & 33.38/0.7551 & 33.33/0.7546 & 33.35/0.7555 & 33.36/0.7545
\\
15 & 25.48/0.6900 & 25.80/0.7014 & 25.84/0.7043 & 25.80/0.7025 & 25.90/0.7069 & 25.83/0.7055
\\
16 & 27.97/0.7213 & 28.06/0.7250 & 28.07/0.7255 & 28.06/0.7251 & 28.10/0.7272 & 28.08/0.7258
\\
17 & 28.74/0.7631 & 28.89/0.7689 & 28.91/0.7699 & 28.88/0.7689 & 28.95/0.7719 & 28.91/0.7702
\\
18 & 23.36/0.7927 & 24.24/0.8179 & 24.31/0.8203 & 24.20/0.8171 & 24.62/0.8280 & 24.36/0.8209
\\
19 & 36.85/0.8920 & 37.28/0.8992 & 37.30/0.8995 & 37.23/0.8987 & 37.43/0.9015 & 37.25/0.8989
\\
20 & 38.02/0.9129 & 38.18/0.9146 & 38.17/0.9147 & 38.15/0.9147 & 38.26/0.9156 & 38.17/0.9149
\\
21 & 26.89/0.8433 & 27.38/0.8545 & 27.39/0.8554 & 27.33/0.8541 & 27.48/0.8579 & 27.39/0.8562
\\
22 & 27.68/0.8091 & 28.19/0.8263 & 28.21/0.8265 & 28.13/0.8239 & 28.31/0.8300 & 28.20/0.8256
\\
23 & 26.26/0.7492 & 26.51/0.7588 & 26.55/0.7606 & 26.50/0.7589 & 26.64/0.7645 & 26.54/0.7611
\\
24 & 30.09/0.7624 & 30.22/0.7659 & 30.23/0.7670 & 30.22/0.7665 & 30.26/0.7680 & 30.23/0.7666
\\
25 & 25.07/0.7363 & 25.35/0.7471 & 25.41/0.7499 & 25.36/0.7475 & 25.47/0.7525 & 25.41/0.7504
\\
26 & 24.39/0.6501 & 24.61/0.6580 & 24.64/0.6604 & 24.61/0.6588 & 24.72/0.6637 & 24.66/0.6616
\\
27 & 29.42/0.8154 & 29.74/0.8258 & 29.81/0.8276 & 29.72/0.8255 & 29.86/0.8306 & 29.80/0.8272
\\
28 & 33.46/0.8813 & 33.99/0.8921 & 34.09/0.8930 & 33.94/0.8905 & 34.20/0.8944 & 33.99/0.8898
\\
29 & 24.60/0.7345 & 25.04/0.7488 & 25.08/0.7505 & 25.02/0.7481 & 25.16/0.7544 & 25.06/0.7507
\\
30 & 27.60/0.7737 & 28.12/0.7944 & 28.17/0.7966 & 28.10/0.7934 & 28.26/0.8005 & 28.17/0.7964
\\
'''
all = all.split('\n')

results = '''psnr
Airport: 28.57
BareLand: 35.46
BaseballField: 35.29
Beach: 32.51
Bridge: 31.74
Center: 29.99
Church: 23.83
Commercial: 26.39
DenseResidential: 23.50
Desert: 37.67
Farmland: 35.00
Forest: 27.67
Industrial: 26.76
Meadow: 33.40
MediumResidential: 25.95
Mountain: 28.14
Park: 28.98
Parking: 24.89
Playground: 37.54
Pond: 38.28
Port: 27.63
RailwayStation: 28.43
Resort: 26.67
River: 30.28
School: 25.57
SparseResidential: 24.75
Square: 29.98
Stadium: 34.48
StorageTanks: 25.29
Viaduct: 28.34
all: 29.78
ssim
Airport: 0.8013
BareLand: 0.8439
BaseballField: 0.8848
Beach: 0.8085
Bridge: 0.8668
Center: 0.8403
Church: 0.7053
Commercial: 0.7717
DenseResidential: 0.6879
Desert: 0.8926
Farmland: 0.8697
Forest: 0.6541
Industrial: 0.7845
Meadow: 0.7578
MediumResidential: 0.7100
Mountain: 0.7296
Park: 0.7738
Parking: 0.8344
Playground: 0.9032
Pond: 0.9158
Port: 0.8612
RailwayStation: 0.8327
Resort: 0.7658
River: 0.7694
School: 0.7561
SparseResidential: 0.6652
Square: 0.8330
Stadium: 0.8983
StorageTanks: 0.7574
Viaduct: 0.8030
all: 0.8013'''
results = results.split('\n')
n_len = len(results)
total_psnr = 0
total_ssim = 0
all_data = ''
idx_all = 0
for i in range(1, n_len//2):
    name = results[i].split(':')[0]
    name_tmp = results[i+n_len//2].split(':')[0]
    assert name == name_tmp
    psnr_val = results[i].split(':')[-1].strip()
    psnr_val = float(psnr_val)
    ssim_val = results[i+n_len//2].split(':')[-1].strip()
    ssim_val = float(ssim_val)
    if name == 'all':
        all_data = name+':'+str(psnr_val)+'/'+str(ssim_val)
        continue
    total_psnr += psnr_val
    total_ssim += ssim_val
    print(all[idx_all] +' & ' +f'{psnr_val:.2f}'+'/'+f'{ssim_val:.4f}')
    idx_all += 2
    print('\\\\')
print(all_data)
print(total_psnr/(n_len//2-2))
print(total_ssim/(n_len//2-2))
