from googletrans import Translator
import spacy
import gradio as gr
import nltk
from nltk.corpus import wordnet
import wikipedia
import re
import time
import random
import os
import zipfile
import ffmpeg
from gtts import gTTS
#from io import BytesIO
from collections import Counter
from PIL import Image, ImageDraw, ImageFont
import numpy as np
from docx import Document
import textwrap
import pandas as pd
import pykakasi
import hangul_romanize
import pinyin
from langdetect import detect
import datetime
import cv2
import math

#When I forgot about the readme file ChatGPT suggested these - Leaving to remember the ReadmeF.md must be updated as well
#print(gr.__version__)
#import subprocess
#subprocess.run(["pip", "install", "--upgrade", "gradio==3.47.1"]) #For huggingface as they sometimes install specific versions on container build

#Uncomment these for Huggingface
nltk.download('maxent_ne_chunker') #Chunker
nltk.download('stopwords') #Stop Words List (Mainly Roman Languages)
nltk.download('words') #200 000+ Alphabetical order list
nltk.download('punkt') #Tokenizer
nltk.download('verbnet') #For Description of Verbs
nltk.download('omw')
nltk.download('omw-1.4') #Multilingual Wordnet
nltk.download('wordnet') #For Definitions, Antonyms and Synonyms
nltk.download('shakespeare')
nltk.download('dolch') #Sight words
nltk.download('names') #People Names NER
nltk.download('gazetteers') #Location NER
nltk.download('opinion_lexicon') #Sentiment words
nltk.download('averaged_perceptron_tagger') #Parts of Speech Tagging
nltk.download('udhr') # Declaration of Human rights in many languages

spacy.cli.download("en_core_web_sm")
spacy.cli.download('ko_core_news_sm')
spacy.cli.download('ja_core_news_sm')
spacy.cli.download('zh_core_web_sm')
spacy.cli.download("es_core_news_sm")
spacy.cli.download("de_core_news_sm")

nlp_en = spacy.load("en_core_web_sm")
nlp_de = spacy.load("de_core_news_sm")
nlp_es = spacy.load("es_core_news_sm")
nlp_ko = spacy.load("ko_core_news_sm")
nlp_ja = spacy.load("ja_core_news_sm")
nlp_zh = spacy.load("zh_core_web_sm")

nlp = spacy.load('en_core_web_sm')
translator = Translator()

def Sentencechunker(sentence):
    Sentchunks = sentence.split(" ")
    chunks = []
    for i in range(len(Sentchunks)):
        chunks.append(" ".join(Sentchunks[:i+1]))
    return " | ".join(chunks)

def ReverseSentenceChunker(sentence):
    reversed_sentence = " ".join(reversed(sentence.split()))
    chunks = Sentencechunker(reversed_sentence)
    return chunks

def three_words_chunk(sentence):
    words = sentence.split()
    chunks = [words[i:i+3] for i in range(len(words)-2)]
    chunks = [" ".join(chunk) for chunk in chunks]
    return " | ".join(chunks)

def keep_nouns_verbs(sentence):
    doc = nlp(sentence)
    nouns_verbs = []
    for token in doc:
        if token.pos_ in ['NOUN','VERB','PUNCT']:
            nouns_verbs.append(token.text)
    return " ".join(nouns_verbs)

def unique_word_count(text="", state=None):
    if state is None:
        state = {}
    words = text.split()
    word_counts = state
    for word in words:
        if word in word_counts:
            word_counts[word] += 1
        else:
            word_counts[word] = 1
    sorted_word_counts = sorted(word_counts.items(), key=lambda x: x[1], reverse=True)
    return sorted_word_counts,    

def Wordchunker(word):
    chunks = []
    for i in range(len(word)):
        chunks.append(word[:i+1])
    return chunks

def BatchWordChunk(sentence):
    words = sentence.split(" ")
    FinalOutput = ""
    Currentchunks = ""
    ChunksasString = ""
    for word in words:
        ChunksasString = ""
        Currentchunks = Wordchunker(word)
        for chunk in Currentchunks:
          ChunksasString += chunk + " "
        FinalOutput += "\n" + ChunksasString
    return FinalOutput

# Translate from English to French

langdest = gr.Dropdown(choices=["af", "de", "es", "ko", "ja", "zh-cn"], label="Choose Language", value="de")

ChunkModeDrop = gr.Dropdown(choices=["Chunks", "Reverse", "Three Word Chunks", "Spelling Chunks"], label="Choose Chunk Type", value="Chunks")

def FrontRevSentChunk (Chunkmode, Translate, Text, langdest):
    FinalOutput = ""
    TransFinalOutput = ""
    if Chunkmode=="Chunks": 
        FinalOutput += Sentencechunker(Text)
    if Chunkmode=="Reverse":
        FinalOutput += ReverseSentenceChunker(Text)
    if Chunkmode=="Three Word Chunks": 
        FinalOutput += three_words_chunk(Text) 
    if Chunkmode=="Spelling Chunks":
        FinalOutput += BatchWordChunk(Text)
    
    if Translate: 
        TransFinalOutput = FinalOutput
        translated = translator.translate(TransFinalOutput, dest=langdest)
        FinalOutput += "\n" + translated.text
    return FinalOutput

# Define a function to filter out non-verb, noun, or adjective words
def filter_words(words):
    # Use NLTK to tag each word with its part of speech
    tagged_words = nltk.pos_tag(words)

    # Define a set of parts of speech to keep (verbs, nouns, adjectives)
    keep_pos = {'VB', 'VBD', 'VBG', 'VBN', 'VBP', 'VBZ', 'NN', 'NNS', 'NNP', 'NNPS', 'JJ', 'JJR', 'JJS'}

    # Filter the list to only include words with the desired parts of speech
    filtered_words = [word for word, pos in tagged_words if pos in keep_pos]

    return filtered_words

def SepHypandSynExpansion(text):
    # Tokenize the text
    tokens = nltk.word_tokenize(text)
    NoHits = ""
    FinalOutput = ""
    
    # Find synonyms and hypernyms of each word in the text
    for token in tokens:
      synonyms = []
      hypernyms = []
      for synset in wordnet.synsets(token):
          synonyms += synset.lemma_names()
          hypernyms += [hypernym.name() for hypernym in synset.hypernyms()]
      if not synonyms and not hypernyms:
          NoHits += f"{token} | "
      else:
          FinalOutput += "\n" f"{token}: hypernyms={hypernyms}, synonyms={synonyms} \n"
    NoHits = set(NoHits.split(" | "))  
    NoHits = filter_words(NoHits)
    NoHits = "Words to pay special attention to: \n" + str(NoHits)
    return NoHits, FinalOutput


def WikiSearch(term):
    termtoks = term.split(" ")
    
    for item in termtoks:
      # Search for the term on Wikipedia and get the first result
      result = wikipedia.search(item, results=20)
    return result 

def create_dictionary(word_list, word_dict = {}):
    word_list = set(word_list.split(" "))
    for word in word_list:
        key = word[:2]
        if key not in word_dict:
            word_dict[key] = [word]
        else:
            word_dict[key].append(word)
    return word_dict

def merge_lines(roman_file, w4w_file, full_mean_file, macaronic_file):
    files = [roman_file, w4w_file, full_mean_file, macaronic_file]
    merged_lines = []
    
    with open(roman_file.name, "r") as f1, open(w4w_file.name, "r") as f2, \
            open(full_mean_file.name, "r") as f3, open(macaronic_file.name, "r") as f4:
        for lines in zip(f1, f2, f3, f4):
            merged_line = "\n".join(line.strip() for line in lines)
            merged_lines.append(merged_line)
    
    return "\n".join(merged_lines)

TTSLangOptions = gr.Dropdown(choices=["en", "de", "es", "ja", "ko", "zh-cn"], value="en", label="choose the language of the srt/text accent")
TTSLangOptions2 = gr.Dropdown(choices=["en", "de", "es", "ja", "ko", "zh-cn"], value="en", label="choose the language of the srt/text accent")

def TTSforListeningPractice(text, language = "en", Repeat10x = False):
    if Repeat10x:
        text = text * 10
    speech = gTTS(text=text, lang=language, slow="False")
    speech.save("CurrentTTSFile.mp3")
    #file = BytesIO()
    #speech.write_to_fp(file)
    #file.seek(0)
    return "CurrentTTSFile.mp3" #file

def AutoChorusInvestigator(sentences):
    sentences = sentences.splitlines()
    # Use Counter to count the number of occurrences of each sentence
    sentence_counts = Counter(sentences)

    # Identify duplicate sentences
    duplicates = [s for s, count in sentence_counts.items() if count > 1]

    FinalOutput = ""
    if len(duplicates) == 0:
        FinalOutput += "No duplicate sentences found in the file."
    else:
        FinalOutput += "The following sentences appear more than once in the file:"
        for sentence in duplicates:
            FinalOutput += "\n" + sentence
    return FinalOutput

def AutoChorusPerWordScheduler(sentences):
    words = set(sentences.split(" "))
    wordsoneattime =[]
    practicestring = ""

    FinalOutput = "This is supposed to output the words in repetition format (i.e. schedule for repitition) \nCurrent Idea = 1 new word every min and 1 old word every second" + "\n\nWords: \n"
    for word in words:
        wordsoneattime.append(word)
        for i in range(0, 59):
            practicestring += word + " "
            practicestring += random.choice(wordsoneattime) + " "    
        FinalOutput += word + "\n "
        practicestring += "\n"

    FinalOutput += practicestring
    return FinalOutput

def group_words(inlist):
    inlisttoks = inlist.split(" ")
    inlistset = set(inlisttoks)

    word_groups = []
    current_group = []

    for word in inlisttoks:
        current_group.append(word)
        if len(current_group) == 10:
            word_groups.append(current_group)
            current_group = []
    if current_group:
        word_groups.append(current_group)

    current_group_index = 0
    current_group_time = 0

    while True:
        if current_group_time == 60:
            current_group_index = (current_group_index + 1) % len(word_groups)
            current_group_time = 0
        else:
            if current_group_time % 10 == 0:
                random.shuffle(word_groups[current_group_index])
            current_group_time += 10

        yield " ".join(word_groups[current_group_index])
        time.sleep(10) 

def split_verbs_nouns(text):
    nlp = spacy.load("en_core_web_sm")
    doc = nlp(text)
    
    verbs_nouns = []
    verbs_nouns_str = ""
    other_words = []
    other_words_str = ""
    pos_string = []

    for token in doc:
        if token.pos_ in ["VERB", "NOUN"]:
            verbs_nouns_str += token.text + " || "
            other_words_str += "__ " 
            #verbs_nouns.append(token.text)
        #elif token.text in [punct.text for punct in doc if punct.is_punct]:
        #    verbs_nouns.append(token.text)
        #    other_words.append(token.text)
        else:
            other_words_str += token.text + " || "
            #other_words.append(token.text)
        #pos_string.append(token.pos_)

    verbs_nouns_text = verbs_nouns_str  #" ".join(verbs_nouns)
    other_words_text = other_words_str  #" ".join(other_words)
    pos_string_text = "Debug Test" #" ".join(pos_string)
    
    return other_words_text, pos_string_text, verbs_nouns_text

SRTLangOptions = gr.Dropdown(choices=["en", "ja", "ko", "zh-cn"], value="en", label="choose the language of the srt")

def save_string_to_file(string_to_save, file_name, srtdocx):
    with open(file_name, 'w', encoding='utf-8') as file:
        file.write(string_to_save)
    if srtdocx == "True":
        with open(file_name.split('.')[0] + '.srt', 'w', encoding='utf-8') as file:
            file.write(string_to_save)
        srtdocument = Document()
        srtdocument.add_paragraph(string_to_save)
        srtdocument.save('SplitSRT.docx')

def split_srt_file(text, lang): #file_path):
    # Open the SRT file and read its contents
    #with open(file_path, 'r') as f:
    #    srt_contents = f.read()
    
    if lang == "en": nlp = spacy.load('en_core_web_sm')
    if lang == "ja": nlp = spacy.load('ja_core_news_sm')
    if lang == "ko": nlp = spacy.load('ko_core_news_sm')
    if lang == "zn-cn": nlp = spacy.load('zn_core_web_sm')

    srt_contents = text
    
    # Split the SRT file by timestamp
    srt_sections = srt_contents.split('\n\n')
    srt_sections_POSversion = []
    subaswordlist = ""

    # Loop through each section of the SRT file
    for i in range(len(srt_sections)):
        # Split the section into its timestamp and subtitle text
        section_lines = srt_sections[i].split('\n')
        timestamp = section_lines[1]
        subtitle_text = ' | '.join(section_lines[2:])
        sub_split_line = nlp(subtitle_text)
        subtitle_textPOSversion = ""
        subtitle_text = ""

        # Replace spaces in the subtitle text with " | "
        #subtitle_text = subtitle_text.replace(' ', ' | ')
        for token in sub_split_line:
            subtitle_text += token.text + " | "
            subaswordlist += token.text + " "
            subtitle_textPOSversion += token.pos_ + " | "

        # Reconstruct the section with the updated subtitle text
        srt_sections[i] = f"{section_lines[0]}\n{timestamp}\n{subtitle_text[3:]}"
        srt_sections_POSversion.append(f"{section_lines[0]}\n{timestamp}\n{subtitle_textPOSversion[3:]}\n\n")

    SplitSRT = '\n\n'.join(srt_sections)
    SplitPOSsrt = ''.join(srt_sections_POSversion)
    save_string_to_file(SplitSRT, "SplitSRT.txt", "True")
    save_string_to_file(SplitPOSsrt, "SplitPOSsrt.txt", "False")
    subaswordlist = set(subaswordlist.split(" "))
    subaswordlistOutput = ""

    for word in subaswordlist:
        subaswordlistOutput += "\n | " + word

    subaswordlistOutput = str(len(subaswordlist)) + "\n" + subaswordlistOutput

    # Join the SRT sections back together into a single string
    return subaswordlistOutput, ["SplitSRT.docx", "SplitSRT.txt", "SplitSRT.srt", "SplitPOSsrt.txt"], SplitSRT, SplitPOSsrt

def find_string_positions(s, string):
    positions = []
    start = 0
    while True:
        position = s.find(string, start)
        if position == -1:
            break
        positions.append(position)
        start = position + len(string)
    return positions

def splittext(string):
    string_no_formaterror = string.replace(" -- > ", " --> ")
    split_positions = find_string_positions(string_no_formaterror, " --> ")  
    split_strings = []
    prepos = 0
    for pos in split_positions:
        pos -= 12
        split_strings.append((string[prepos:pos])) #, string[pos:]))
        prepos = pos
    
    FinalOutput = ""
    stoutput = ""
    linenumber = 1
    #print(linenumber)
    for item in split_strings[1:]:
        stoutput = item[0:29] + "\n" + item[30:]
        stspaces = find_string_positions(stoutput, " ")
        FinalOutput += str(linenumber) + "\n" + stoutput[:stspaces[-2]] + "\n"
        FinalOutput += "\n"
        linenumber += 1
    return FinalOutput[2:]   

def VideotoSegment(video_file, subtitle_file):
    # Read the subtitle file and extract the timings for each subtitle
    timings = []
    for line in subtitle_file:
        if '-->' in line:
            start, end = line.split('-->')
            start_time = start.strip().replace(',', '.')
            end_time = end.strip().replace(',', '.')
            timings.append((start_time, end_time))

    # Cut the video into segments based on the subtitle timings
    video_segments = []
    for i, (start_time, end_time) in enumerate(timings):
        output_file = f'segment_{i}.mp4'
        ffmpeg.input(video_file, ss=start_time, to=end_time).output(output_file, codec='copy').run()
        video_segments.append(output_file)

    # Convert each segment to an MP3 audio file using FFmpeg
    audio_segments = []
    for i in range(len(timings)):
        output_file = f'segment_{i}.mp3'
        ffmpeg.input(video_segments[i]).output(output_file, codec='libmp3lame', qscale='4').run()
        audio_segments.append(output_file)

    # Create a ZIP archive containing all of the segmented files
    zip_file = zipfile.ZipFile('segmented_files.zip', 'w')
    for segment in video_segments + audio_segments:
        zip_file.write(segment)
        os.remove(segment)
    zip_file.close()

    # Return the ZIP archive for download
    return 'segmented_files.zip'

def text_to_dropdown(text, id=None): #TextCompFormat
    lines = text.strip().split("\n")
    html = "<select"
    if id:
        html += f' id="{id}"'
    html += "> \n"
    for line in lines:
        html += f"    <option>{line}</option>\n"
    html += "</select> \n"
    return html

def text_to_links(text): #TextCompFormat
    lines = text.strip().split("\n")
    html = ""
    for line in lines:
        if line.startswith("http"):
            html += f"<a href='{line}'> --  -- </a> | "
        else:
            html += line + "Not a link <br> \n"
    return html

HTMLCompMode = gr.Dropdown(choices=["Dropdown", "Links"], value="Links")

def TextCompFormat(text, HTMLCompMode):
    FinalOutput = ""
    if HTMLCompMode == "Dropdown":
        FinalOutput = text_to_dropdown(text)
    if HTMLCompMode == "Links":
        FinalOutput = text_to_links(text)
    return FinalOutput

def create_collapsiblebutton(button_id, button_caption, div_content):
    button_html = f'<button id="{button_id}" class="accordionbtn">{button_caption}</button>'
    div_html = f'<div id="{button_id}Div" class="panel">\n{div_content}\n    </div>'
    return button_html + "\n    " + div_html

#---------------

def removeTonalMarks(string):
    tonalMarks = "āēīōūǖáéíóúǘǎěǐǒǔǚàèìòùǜɔɛ"
    nonTonalMarks = "aeiouuaeiouuaeiouuaeiouoe"
    noTonalMarksStr = ""
    for char in string:
        index = tonalMarks.find(char)
        if index != -1:
            noTonalMarksStr += nonTonalMarks[index]
        else:
            noTonalMarksStr += char
    return noTonalMarksStr


def add_text_to_image(input_image, text, output_image_path="output.png", border_size=2):
    text = removeTonalMarks(text)
    imagearr = np.asarray(input_image) #Image.open(input_image_path)
    width, height = imagearr.shape[:2] #width, height = image.size
    img = Image.fromarray(imagearr)
    draw = ImageDraw.Draw(img)
    font = ImageFont.truetype("ShortBaby.ttf", 36) #ShortBaby-Mg2w.ttf
    text_width, text_height = draw.textbbox((0, 0), text, font=font)[2:] #draw.textsize(text, font)
    # calculate the x, y coordinates of the text box
    x = (width - text_width) / 2
    y = (height - text_height) / 2
    # put the text on the image with a border
    for dx, dy in [(0, 0), (border_size, border_size), (-border_size, -border_size), (border_size, -border_size), (-border_size, border_size)]:
        draw.text((x + dx, y + dy), text, font=font, fill=(255, 255, 255))
    draw.text((x, y), text, font=font, fill=(0, 0, 0))
    img.save(output_image_path, "PNG")
    return "output.png"

def UnknownTrackTexttoApp(text): #Copy of def OptimisedTtAppForUNWFWO(text):
      #Buttons and labels autocreation
    #Change this to spacy version so that data is from one library
    #Javascript videos on youtube - KodeBase - Change button color Onclick; bro code - button in 5 minutes
    #GPT3 helped guide the highlighting if statements

    FinalOutput = ""
    #sentence = "One Piece chapter 1049 spoilers  Thanks to Etenboby from WG forums  Chapter 1049: **\"The world we should aspire to\"**  * In the cover, someone burned Niji and Yonji\u2019s book * Kaido flashback time. We see his childhood in Vodka Kingdom, and where a few years later he met Whitebeard who told him that Rocks wants to meet him * In the present, part of Raizo\u2019s water leaves the castle and flame clouds disappear. But Momo makes a new one. * Luffy says he will create a world where none of his friends would starve, then he hits Kaido and Kaido falls to the ground of the flower capital. * In another flashback, Kaido tells King that Joy Boy will be the man that can defeat him.  **Additional info**   *Flashback to Kaidou as a kid*  *- His country tries to sell him to the marines but he escapes*  *- He rampages in Hachinosu(i think it's blackbeard's island) and Rocks invites him to his crew*  *- Young WB appears*  *- Rocks flashback suddenly ends*  *- Higurashi invites Kaidou*  *- The flashback ends with Kaidou telling King he knows who Joy Boy is.*   *Back to the present*  \\- *Denjirou hugs Hiyori*  \\- *Luffy's punch hits Kaidou*  *Flashback continues*  \\- *King asks: Who is it then?*  \\- *Kaidou: The one who will defeat me*  \\- *King: Then he will not appear*  \\- *Onigashima falls near the capital*  \\- *Momo falls*  **BREAK NEXT WEEK**  https://www.reddit.com/r/OnePiece/comments/umu2h0/one_piece_chapter_1049_spoilers/" #@param {type: "string"}
    HTMLMainbody = ""
    GradHTMLMainbody = "" #HTML in gradio components doesnt do css and js properly so nned to highlight

    doc = nlp(text)
    iIDNumber = 0
    iVerbCount = 0
    iNounCount = 0
    iWords = 0
    allverbs = ""
    allverbslist = ""
    allverbids = ""
    allverbidslist = ""

    for token in doc:
        if (token.pos_ == "VERB") or (token.pos_ == "AUX"):
            HTMLMainbody = HTMLMainbody + "<button id='btn" + str(iVerbCount) +  "' onclick=HighlightWord('btn" + str(iVerbCount) + "')> " + token.text + "</button> "
            GradHTMLMainbody = GradHTMLMainbody + "<button id='btn" + str(iVerbCount) +  "' style='background-color: green;' onclick=HighlightWord('btn" + str(iVerbCount) + "')> " + token.text + "</button> "
            allverbids = allverbids + str(iVerbCount) + " "
            iVerbCount += 1
            iWords += 1
            allverbs = allverbs + token.text + " "
        elif token.pos_ == "NOUN":
            HTMLMainbody = HTMLMainbody +  "<label class='Nouns' id='lbl" + token.text + "'>" + token.text + " </label>" 
            GradHTMLMainbody = GradHTMLMainbody +  "<label class='Nouns' id='lbl" + token.text + "' style='background-color: blue;'>" + token.text + " </label>"  
            iNounCount += 1
            iWords += 1  
        elif token.pos_ == "PUNCT":
            HTMLMainbody = HTMLMainbody + token.text
            GradHTMLMainbody = GradHTMLMainbody + token.text
        else:
            HTMLMainbody = HTMLMainbody + token.text + " "
            GradHTMLMainbody = GradHTMLMainbody + token.text + " "
            iWords += 1
        iIDNumber += 1 

    allverbslist = allverbs.split()
    allverbidslist = allverbids.split()

    FinalHTML = ""
    FinalGradHTML = ""
    FinalCSS = ""
    FinalJS = ""

    FinalCSS = FinalCSS + ''' <style>
    body {
    background-color: darksalmon;
    }
    
    .Nouns {
    color: red;
    }

    .clunknown{
    background-color: gainsboro;
    } 

    .clknownl1{
    background-color: yellow;
    }

    .clknownl2{
    background-color: gold;
    }

    .clknownl3{
    background-color: orange;
    }

    .PD1 {
    text-align: center;
    font-size: larger;
    font-family: cursive;
    }

    .PD2 {
    font-family: monospace;
    }
    </style>
    '''

    #style='background-color:Gainsboro; There is no general style attribute for buttons but you can make a class and put the style conditions

    iSents = 0
    for sent in doc.sents:
        iSents += 1

    FinalHTML = FinalHTML + "\n<div id='PD1'>Picture on mouse hover = Visual<br> Speed = End Goal ==> App Timer Functions ||| \nSentences: " + str(iSents) + " | Words: " + str(iWords) + " | App elements: " + str(iNounCount + iVerbCount) + " | Verbs: " + str(iVerbCount) + "</div>"
    FinalHTML = FinalHTML + "\n<div><hr><progress id='myVerbProgress' value='0' max='" + str(iVerbCount) + "'></progress></div>"
    FinalJS = FinalJS + '''\n
    <script> 
    function HighlightWord(Button){
    if (document.getElementById(Button).style.backgroundColor === 'orange') {
    document.getElementById(Button).style.backgroundColor=''  
    }
    else if (document.getElementById(Button).style.backgroundColor === 'gold') {
    document.getElementById(Button).style.backgroundColor='orange'  
    }
    else if (document.getElementById(Button).style.backgroundColor === 'yellow') {
    document.getElementById(Button).style.backgroundColor='gold'  
    } 
    else {document.getElementById(Button).style.backgroundColor='yellow'
    }
    OnlyUnknownVerbs()
    } 
    '''

    FinalGradHTML = FinalHTML + "\n<div><hr>\n" + GradHTMLMainbody + "\n" #HTML in gradio components doesnt do css and js properly so nned to highlight
    FinalHTML = FinalHTML + "\n<div><hr>\n" + HTMLMainbody + "\n"
    
    #FinalHTML = FinalHTML + '''</div><hr>
    #<button onclick=OnlyUnknownSentences() id="btnOnlyUnknownSentences">Only Unknown Sentences Put this function in a timer to keep up to date without input</button>
    #'''
    FinalJS = FinalJS + '''
    function OnlyUnknownVerbs(){
    AllButtons = ''' + str(allverbidslist) + '''   
    AllButtonsText = ''' + str(allverbslist) + ''' 
    UnknownOutput = ""
    iUnknownCount = 0
    AllButtons.forEach(function(item){  
    if (document.getElementById('btn'+item).style.backgroundColor === ''){
        UnknownOutput += AllButtonsText[item] + " " 
        iUnknownCount += 1
        } 
        document.getElementById('myVerbProgress').value = ''' + str(iVerbCount) + ''' - iUnknownCount
    })    
    document.getElementById('PD2').textContent = 'Only Unknwon words list: ' + UnknownOutput
    } 


    </script> 
    '''

    FinalHTML = FinalHTML + '''<br><hr><br>
    <div id='PD2'> Only Unknown List</div>
    \n
    '''

    FinalGradHTML = FinalGradHTML + '''<br><hr><br>
    <div id='PD2'> Only Unknown List</div>
    \n
    '''

    FinalOutput = FinalHTML + FinalCSS + FinalJS
    FinalGradOutput = FinalGradHTML + FinalCSS + FinalJS


    HTMLDownloadTemp = f'UnknownVerbTrack.html' 

    with open(HTMLDownloadTemp, 'w') as f:
        f.write(FinalOutput)

    return HTMLDownloadTemp, FinalGradOutput, FinalOutput

#Kathryn Lingel - Pyambic Pentameter Example - PyCon US
#Basic Language Model Code
def build_model(source_text):
    list_of_words = source_text.split()
    model = {} #initialise model to empty dictionary

    for i, word in enumerate(list_of_words[:-1]): #every word except last word
      if not word in model: #If word not already in dictionary as a key we add it and initialise to empty array
        model[word] = [] 
      next_word = list_of_words[i+1] 
      model[word].append(next_word) #model = dictionary per word containing previously seen next words from ANY given text ==> even lyrics
    
    translatestring = str(model)
    translatestring = translatestring.replace("'", "")
    return model, translatestring

def markov_generate(source_text, num_words = 20):
    model = build_model(source_text)
    seed = random.choice(list(model.keys())) #Randomly pick a word ==> Heading of the dictionary are keys aka the words
    output = [seed] #output initialisation using random word
    for i in range(num_words):
      last_word = output[-1] #of the output list
      next_word = random.choice(model[last_word]) # next word to the above word 
      output.append(next_word) #new last word in the output list
      if next_word not in model:
        break

    return ' '.join(output) #New list into a string aka (hopefully) sentence
# print(markov_generate("I am the egg man they are the egg men I am the wallrus goo goo g' joob"))

def chunk_srt_text(srt_text, chunk_size):
    # Split the SRT text into chunks of the specified size
    ChunkList = textwrap.wrap(srt_text, chunk_size)
    dfFinalOutput = pd.DataFrame(ChunkList, columns = [f"Chunks - { len(ChunkList) }"])
    return dfFinalOutput, ""

#-------------------------------------------------------------------------------------------------------------------------------
#Clean Merge

def split_into_fours(text):
    lines = text.split('\n')
    chunks = [lines[i:i+4] for i in range(0, len(lines), 4)]
    return chunks

def NumberLineSort(listlen):
  numbers = list(range(0, listlen))  # create a list of numbers 1 to 12
  grouped_numbers = []
  for i in range(4):
      group = [numbers[j] for j in range(i, len(numbers), 4)]
      grouped_numbers.append(group)
  return grouped_numbers

def SRTLineSort(text):
  chunks = split_into_fours(text)
  NumberofBlocks = len(chunks) / 4
  printnumber = NumberLineSort(len(chunks))
  SRTLinenumber = []
  SRTTiming = []
  SRTContent = []
  FinalOutput = ""

  for i in range(0, 3):
    for item in printnumber[i]:
      if i == 0: SRTLinenumber.append(chunks[item][0])
      if i == 1: SRTTiming.append(chunks[item][0])
      if i == 2: SRTContent.append(chunks[item])

  for i in range(0, int(NumberofBlocks)):
    FinalOutput += SRTLinenumber[i] + "\n"
    FinalOutput += SRTTiming[i] + "\n"
    for i2 in range(0, 4):
      FinalOutput += SRTContent[i][i2] + "\n"
    FinalOutput += "\n"

  return FinalOutput  

#--------------------------------------------------------------------------------------------------------------------------------

RandomiseTextType = gr.Dropdown(choices=["Words", "Words5x", "Sentences", "Paragraph", "Page"], value="Words")

def RandomiseTextbyType(Text, Choice):
    FinalOutput = ""
    TempWords = []

    if Choice == "Words" : 
        TempWords = Text.split()
        FinalOutput = reading_randomize_words(TempWords)
    if Choice == "Words5x" : 
        TempWords = Text.split()
        FinalOutput = reading_randomize_words5x(TempWords)
    if Choice == "Sentences" : FinalOutput = reading_randomize_words_in_sentence(Text)
    if Choice == "Paragraph" : FinalOutput = reading_randomize_words_in_paragraph(Text)
    if Choice == "Page" : FinalOutput = "Still under Construction"

    return FinalOutput

def reading_randomize_words5x(word):
    wordScram = ""
    for item in word:
      for i in range(5):
          item = ''.join(random.sample(item, len(item)))
          wordScram += " " + item
          #print(item)
      wordScram += "\n"
    return wordScram

def reading_randomize_words(word):
    wordScram = ""
    for item in word:
        item = ''.join(random.sample(item, len(item)))
        wordScram += item + " "
    return wordScram

def reading_randomize_words_in_sentence(text):
    FinalOutput = ""
    sentences = text.split(".")
    for sentence in sentences:
        words = sentence.split()
        random.shuffle(words)
        FinalOutput += ' '.join(words) + ". "
    return FinalOutput

def reading_randomize_words_in_paragraph(paragraph):
    sentences = paragraph.split(".")
    random.shuffle(sentences)
    return '. '.join(sentences)

def changeexposuretext(text):
    return f"<marquee> {text} </marquee>"

#-------------------------------------------------------------------------------------------------------------------------------

def ImageTranslationTest(video, subtitle):
    #Inputs from file Returns a <tempfile._TemporaryFileWrapper object at ___> so the path is item.name

    if subtitle is None:
        return video.name

    return [video.name, subtitle.name]

#------------------------------------------------------------------------------------------------------------------------------

def AutoSyllablePractice(String):
    FinalOutput = ""

    stringlen = len(String)

    vowels =["a", "e", "i", "o", "y"]
    VowelSyllables = []
    allvowels = ""

    for i in vowels:
        if i in String:
            allvowels = allvowels + " " + String.replace(i, i + " ")
            allvowels = allvowels + " " + String.replace(i, " " + i)
    VowelSyllables = allvowels.split(" ")

    VowelSyllablesstr = ""

    for item in VowelSyllables:
        VowelSyllablesstr += item + ", "

    FinalOutput += VowelSyllablesstr        
    return FinalOutput

def GuidedReading(textspreprocess,seperator):
  FinalOutput = ""
  
  if seperator == "Sentences": 
    textspreprocess = textspreprocess.split(".")
    FinalOutput = ""
  elif seperator == "lines":
      textspreprocess = textspreprocess.splitlines()
  else: textspreprocess = textspreprocess.split(seperator)

  # Load language-specific models
  nlp_en = spacy.load("en_core_web_sm")
  nlp_de = spacy.load("de_core_news_sm")
  nlp_es = spacy.load("es_core_news_sm")
  nlp_ko = spacy.load("ko_core_news_sm")
  nlp_ja = spacy.load("ja_core_news_sm")
  nlp_zh = spacy.load("zh_core_web_sm")

  # Create a dictionary of language codes and models
  nlp_dict = {"en": nlp_en, "de": nlp_de, "es": nlp_es, "ko": nlp_ko, "ja": nlp_ja, "zh-cn": nlp_zh}

  # Define a function to POS tag and transliterate a text given its language code
  def pos_tag_and_transliterate(text, lang):
      # Get the model for the language
      nlp = nlp_dict.get(lang)
      if nlp is None:
          return None # No model found for the language
      # Process the text and get a list of (token, tag) tuples
      doc = nlp(text)
      original_pos_tags = [(token.text, token.pos_) for token in doc]
      # Use different libraries for different languages
      if lang == "ja":
          # Use pykakasi for Japanese
          from pykakasi import kakasi
          # Set the modes using properties
          k = kakasi()
          k.hira2a = True # Hiragana to ascii
          k.kata2a = True # Katakana to ascii
          k.kanji2a = True # Kanji to ascii
          k.roman = "Hepburn" # Use Hepburn romanization
          #words = re.findall(r"\S+|\s+", text)
          words = [token.text for token in doc]
          # Create a dictionary that maps each original word to its transliterated form with spaces
          translit_dict = {word: k.convert(word)[0]['hepburn'] for word in words}
          # Get the transliterated text with spaces
          transliterated = " ".join(translit_dict.values())
          # Replace the words in the original POS tag list with their transliterated forms
          translit_pos_tags = [(translit_dict.get(word, word), tag) for word, tag in original_pos_tags]
          # Get the transliterated language code
          lang_translit = lang + "-translit"
      elif lang == "ko":
          # Use hangul-romanize for Korean
          from hangul_romanize import Transliter
          from hangul_romanize.rule import academic
          transliter = Transliter(academic)
          # Create a dictionary that maps each original word to its transliterated form with spaces
          words = [token.text for token in doc]
          translit_dict = {word: " ".join(transliter.translit(word)) for word in words}
          # Get the transliterated text with spaces
          transliterated = " ".join(translit_dict.values())
          # Replace the words in the original POS tag list with their transliterated forms
          translit_pos_tags = [(translit_dict.get(word, word), tag) for word, tag in original_pos_tags]
          # Get the transliterated language code
          lang_translit = lang + "-translit"
      elif lang == "zh-cn":
          # Use pinyin for Chinese
          from pinyin import get
          # Get the transliterated text without spaces
          transliterated = get(text)
          # Replace the words in the original POS tag list with their transliterated forms
          translit_pos_tags = [(get(word), tag) for word, tag in original_pos_tags]
          # Get the transliterated language code
          lang_translit = lang + "-translit"
      else:
          # No transliteration needed for other languages
          return (text, original_pos_tags, text, original_pos_tags, lang)
      # Return a tuple of the original text, the original POS tags, the transliterated text, the transliterated POS tags, and the transliterated language code
      return (text, original_pos_tags, transliterated, translit_pos_tags, lang_translit)

  # Create an empty list to store the results
  texts = []

  # Loop through each text in the list
  for text in textspreprocess:
      # Detect the language of the text
      lang = detect(text)
      # Add the text and the language as a tuple to the results list
      texts.append((text, lang))

  # Process each text in the texts list and print the results
  for text, lang in texts:
      result = pos_tag_and_transliterate(text, lang)
      if result is not None:
        FinalOutput += f"\nLanguage: {lang}"
        FinalOutput += f"\nText: {result[0]}"
        if lang in ["ja", "ko", "zh-cn"]:
            FinalOutput += f"\nTransliterated Text: {result[2]}"
        FinalOutput += f"\n POS tags: {result[1]}"
        if lang in ["ja", "ko", "zh-cn"]:
            FinalOutput += f"\nTPOS tags: {result[3]}"
        FinalOutput += f"\n"
  
  return FinalOutput


def create_acronym_map(text):
    """Create an acronym map from the provided text."""
    lines = text.split('\n')
    acronym_map = {}
    allacronyms = ""
    
    for line in lines:
        # Remove any special characters and split by whitespace
        words = line.split()
        acronym = ''.join([word[0].upper() for word in words if word])
        if acronym:  # Avoid adding empty lines
            acronym_map[line] = acronym
            allacronyms += acronym + " | "
            
    return acronym_map, allacronyms

def onlyplurals(Inputtext): #NLP or Simple Suffix check
    doc = nlp(Inputtext)
    Pluralwords = ""
    for token in doc:
        if token.tag_ == "NNS" or token.tag_ == "NNPS":
            Pluralwords = Pluralwords + token.text + " "
    TextToks = Pluralwords.split(' ')
    PluralCounts = Counter(elem for elem in TextToks)        
    return Pluralwords, PluralCounts

def LoadNLTKUDHRText(text):    
    NLTKtext = nltk.corpus.udhr.raw(text)
    CountNLTKText = Counter(NLTKtext.split()).most_common(100)

    return CountNLTKText, NLTKtext

NLTKudhr = gr.Dropdown(choices=['English-Latin1', 'Akuapem_Twi-UTF8', 'Zulu-Latin1', 'Afrikaans-Latin1', 'German_Deutsch-Latin1', 'Japanese_Nihongo-EUC', 'Japanese_Nihongo-SJIS', 'Japanese_Nihongo-UTF8', 'Spanish-Latin1', 'Korean_Hankuko-UTF8', 'Chinese_Mandarin-GB2312', 'Abkhaz-Cyrillic+Abkh', 'Abkhaz-UTF8', 'Achehnese-Latin1', 'Achuar-Shiwiar-Latin1', 'Adja-UTF8', 'Afaan_Oromo_Oromiffa-Latin1', 'Afrikaans-Latin1', 'Aguaruna-Latin1', 'Akuapem_Twi-UTF8', 'Albanian_Shqip-Latin1', 'Amahuaca', 'Amahuaca-Latin1', 'Amarakaeri-Latin1', 'Amuesha-Yanesha-UTF8', 'Arabela-Latin1', 'Arabic_Alarabia-Arabic', 'Asante-UTF8', 'Ashaninca-Latin1', 'Asheninca-Latin1', 'Asturian_Bable-Latin1', 'Aymara-Latin1', 'Balinese-Latin1', 'Bambara-UTF8', 'Baoule-UTF8', 'Basque_Euskara-Latin1', 'Batonu_Bariba-UTF8', 'Belorus_Belaruski-Cyrillic', 'Belorus_Belaruski-UTF8', 'Bemba-Latin1', 'Bengali-UTF8', 'Beti-UTF8', 'Bichelamar-Latin1', 'Bikol_Bicolano-Latin1', 'Bora-Latin1', 'Bosnian_Bosanski-Cyrillic', 'Bosnian_Bosanski-Latin2', 'Bosnian_Bosanski-UTF8', 'Breton-Latin1', 'Bugisnese-Latin1', 'Bulgarian_Balgarski-Cyrillic', 'Bulgarian_Balgarski-UTF8', 'Cakchiquel-Latin1', 'Campa_Pajonalino-Latin1', 'Candoshi-Shapra-Latin1', 'Caquinte-Latin1', 'Cashibo-Cacataibo-Latin1', 'Cashinahua-Latin1', 'Catalan-Latin1', 'Catalan_Catala-Latin1', 'Cebuano-Latin1', 'Chamorro-Latin1', 'Chayahuita-Latin1', 'Chechewa_Nyanja-Latin1', 'Chickasaw-Latin1', 'Chinanteco-Ajitlan-Latin1', 'Chinanteco-UTF8', 'Chinese_Mandarin-GB2312', 'Chuuk_Trukese-Latin1', 'Cokwe-Latin1', 'Corsican-Latin1', 'Croatian_Hrvatski-Latin2', 'Czech-Latin2', 'Czech-UTF8', 'Czech_Cesky-Latin2', 'Czech_Cesky-UTF8', 'Dagaare-UTF8', 'Dagbani-UTF8', 'Dangme-UTF8', 'Danish_Dansk-Latin1', 'Dendi-UTF8', 'Ditammari-UTF8', 'Dutch_Nederlands-Latin1', 'Edo-Latin1', 'English-Latin1', 'Esperanto-UTF8', 'Estonian_Eesti-Latin1', 'Ewe_Eve-UTF8', 'Fante-UTF8', 'Faroese-Latin1', 'Farsi_Persian-UTF8', 'Farsi_Persian-v2-UTF8', 'Fijian-Latin1', 'Filipino_Tagalog-Latin1', 'Finnish_Suomi-Latin1', 'Fon-UTF8', 'French_Francais-Latin1', 'Frisian-Latin1', 'Friulian_Friulano-Latin1', 'Ga-UTF8', 'Gagauz_Gagauzi-UTF8', 'Galician_Galego-Latin1', 'Garifuna_Garifuna-Latin1', 'German_Deutsch-Latin1', 'Gonja-UTF8', 'Greek_Ellinika-Greek', 'Greek_Ellinika-UTF8', 'Greenlandic_Inuktikut-Latin1', 'Guarani-Latin1', 'Guen_Mina-UTF8', 'HaitianCreole_Kreyol-Latin1', 'HaitianCreole_Popular-Latin1', 'Hani-Latin1', 'Hausa_Haoussa-Latin1', 'Hawaiian-UTF8', 'Hebrew_Ivrit-Hebrew', 'Hebrew_Ivrit-UTF8', 'Hiligaynon-Latin1', 'Hindi-UTF8', 'Hindi_web-UTF8', 'Hmong_Miao-Sichuan-Guizhou-Yunnan-Latin1', 'Hmong_Miao-SouthernEast-Guizhou-Latin1', 'Hmong_Miao_Northern-East-Guizhou-Latin1', 'Hrvatski_Croatian-Latin2', 'Huasteco-Latin1', 'Huitoto_Murui-Latin1', 'Hungarian_Magyar-Latin1', 'Hungarian_Magyar-Latin2', 'Hungarian_Magyar-UTF8', 'Ibibio_Efik-Latin1', 'Icelandic_Yslenska-Latin1', 'Ido-Latin1', 'Igbo-UTF8', 'Iloko_Ilocano-Latin1', 'Indonesian-Latin1', 'Interlingua-Latin1', 'Inuktikut_Greenlandic-Latin1', 'IrishGaelic_Gaeilge-Latin1', 'Italian-Latin1', 'Italian_Italiano-Latin1', 'Japanese_Nihongo-EUC', 'Japanese_Nihongo-SJIS', 'Japanese_Nihongo-UTF8', 'Javanese-Latin1', 'Jola-Fogny_Diola-UTF8', 'Kabye-UTF8', 'Kannada-UTF8', 'Kaonde-Latin1', 'Kapampangan-Latin1', 'Kasem-UTF8', 'Kazakh-Cyrillic', 'Kazakh-UTF8', 'Kiche_Quiche-Latin1', 'Kicongo-Latin1', 'Kimbundu_Mbundu-Latin1', 'Kinyamwezi_Nyamwezi-Latin1', 'Kinyarwanda-Latin1', 'Kituba-Latin1', 'Korean_Hankuko-UTF8', 'Kpelewo-UTF8', 'Krio-UTF8', 'Kurdish-UTF8', 'Lamnso_Lam-nso-UTF8', 'Latin_Latina-Latin1', 'Latin_Latina-v2-Latin1', 'Latvian-Latin1', 'Limba-UTF8', 'Lingala-Latin1', 'Lithuanian_Lietuviskai-Baltic', 'Lozi-Latin1', 'Luba-Kasai_Tshiluba-Latin1', 'Luganda_Ganda-Latin1', 'Lunda_Chokwe-lunda-Latin1', 'Luvale-Latin1', 'Luxembourgish_Letzebuergeusch-Latin1', 'Macedonian-UTF8', 'Madurese-Latin1', 'Makonde-Latin1', 'Malagasy-Latin1', 'Malay_BahasaMelayu-Latin1', 'Maltese-UTF8', 'Mam-Latin1', 'Maninka-UTF8', 'Maori-Latin1', 'Mapudungun_Mapuzgun-Latin1', 'Mapudungun_Mapuzgun-UTF8', 'Marshallese-Latin1', 'Matses-Latin1', 'Mayan_Yucateco-Latin1', 'Mazahua_Jnatrjo-UTF8', 'Mazateco-Latin1', 'Mende-UTF8', 'Mikmaq_Micmac-Mikmaq-Latin1', 'Minangkabau-Latin1', 'Miskito_Miskito-Latin1', 'Mixteco-Latin1', 'Mongolian_Khalkha-Cyrillic', 'Mongolian_Khalkha-UTF8', 'Moore_More-UTF8', 'Nahuatl-Latin1', 'Ndebele-Latin1', 'Nepali-UTF8', 'Ngangela_Nyemba-Latin1', 'NigerianPidginEnglish-Latin1', 'Nomatsiguenga-Latin1', 'NorthernSotho_Pedi-Sepedi-Latin1', 'Norwegian-Latin1', 'Norwegian_Norsk-Bokmal-Latin1', 'Norwegian_Norsk-Nynorsk-Latin1', 'Nyanja_Chechewa-Latin1', 'Nyanja_Chinyanja-Latin1', 'Nzema-UTF8', 'OccitanAuvergnat-Latin1', 'OccitanLanguedocien-Latin1', 'Oromiffa_AfaanOromo-Latin1', 'Osetin_Ossetian-UTF8', 'Oshiwambo_Ndonga-Latin1', 'Otomi_Nahnu-Latin1', 'Paez-Latin1', 'Palauan-Latin1', 'Peuhl-UTF8', 'Picard-Latin1', 'Pipil-Latin1', 'Polish-Latin2', 'Polish_Polski-Latin2', 'Ponapean-Latin1', 'Portuguese_Portugues-Latin1', 'Pulaar-UTF8', 'Punjabi_Panjabi-UTF8', 'Purhepecha-UTF8', 'Qechi_Kekchi-Latin1', 'Quechua-Latin1', 'Quichua-Latin1', 'Rarotongan_MaoriCookIslands-Latin1', 'Rhaeto-Romance_Rumantsch-Latin1', 'Romani-Latin1', 'Romani-UTF8', 'Romanian-Latin2', 'Romanian_Romana-Latin2', 'Rukonzo_Konjo-Latin1', 'Rundi_Kirundi-Latin1', 'Runyankore-rukiga_Nkore-kiga-Latin1', 'Russian-Cyrillic', 'Russian-UTF8', 'Russian_Russky-Cyrillic', 'Russian_Russky-UTF8', 'Sami_Lappish-UTF8', 'Sammarinese-Latin1', 'Samoan-Latin1', 'Sango_Sangho-Latin1', 'Sanskrit-UTF8', 'Saraiki-UTF8', 'Sardinian-Latin1', 'ScottishGaelic_GaidhligAlbanach-Latin1', 'Seereer-UTF8', 'Serbian_Srpski-Cyrillic', 'Serbian_Srpski-Latin2', 'Serbian_Srpski-UTF8', 'Sharanahua-Latin1', 'Shipibo-Conibo-Latin1', 'Shona-Latin1', 'Sinhala-UTF8', 'Siswati-Latin1', 'Slovak-Latin2', 'Slovak_Slovencina-Latin2', 'Slovenian_Slovenscina-Latin2', 'SolomonsPidgin_Pijin-Latin1', 'Somali-Latin1', 'Soninke_Soninkanxaane-UTF8', 'Sorbian-Latin2', 'SouthernSotho_Sotho-Sesotho-Sutu-Sesutu-Latin1', 'Spanish-Latin1', 'Spanish_Espanol-Latin1', 'Sukuma-Latin1', 'Sundanese-Latin1', 'Sussu_Soussou-Sosso-Soso-Susu-UTF8', 'Swaheli-Latin1', 'Swahili_Kiswahili-Latin1', 'Swedish_Svenska-Latin1', 'Tahitian-UTF8', 'Tenek_Huasteco-Latin1', 'Tetum-Latin1', 'Themne_Temne-UTF8', 'Tiv-Latin1', 'Toba-UTF8', 'Tojol-abal-Latin1', 'TokPisin-Latin1', 'Tonga-Latin1', 'Tongan_Tonga-Latin1', 'Totonaco-Latin1', 'Trukese_Chuuk-Latin1', 'Turkish_Turkce-Turkish', 'Turkish_Turkce-UTF8', 'Tzeltal-Latin1', 'Tzotzil-Latin1', 'Uighur_Uyghur-Latin1', 'Uighur_Uyghur-UTF8', 'Ukrainian-Cyrillic', 'Ukrainian-UTF8', 'Umbundu-Latin1', 'Urarina-Latin1', 'Uzbek-Latin1', 'Vietnamese-ALRN-UTF8', 'Vietnamese-UTF8', 'Vlach-Latin1', 'Walloon_Wallon-Latin1', 'Wama-UTF8', 'Waray-Latin1', 'Wayuu-Latin1', 'Welsh_Cymraeg-Latin1', 'WesternSotho_Tswana-Setswana-Latin1', 'Wolof-Latin1', 'Xhosa-Latin1', 'Yagua-Latin1', 'Yao-Latin1', 'Yapese-Latin1', 'Yoruba-UTF8', 'Zapoteco-Latin1', 'Zapoteco-SanLucasQuiavini-Latin1', 'Zhuang-Latin1', 'Zulu-Latin1'], label="Choose one the below languages")

def SimultaneousSpellingPrac(text):
    TextToks = text.split()
    FinalOutput = "For Sentences wrap in another function that calls function per sentences (Spacy) \n"

    iLongestWord = 0
    for tok in TextToks:
        if len(tok) > iLongestWord: iLongestWord = len(tok)

    Equaltok = ""
    for tok in TextToks:
        Equaltok = Equaltok + tok.ljust(iLongestWord, '0') + " " #https://stackoverflow.com/questions/23216512/python-make-string-equal-length

    SimulList = []
    for i in range(0, iLongestWord):
        for tok in Equaltok.split():
            SimulList.append(tok[i])
    
    iWordSpaces = 0
    ZerosFinalOutput = ""

    for item in SimulList:
        iWordSpaces += 1
        ZerosFinalOutput = ZerosFinalOutput + item
        if iWordSpaces == len(TextToks):
          ZerosFinalOutput = ZerosFinalOutput + " "
          iWordSpaces = 0

    FinalOutput = FinalOutput + ZerosFinalOutput + " \n\n" + ZerosFinalOutput.replace("0", "") + " \n\n" + str(iLongestWord)
    return FinalOutput

def FirstLetterSummary(Text):
    TextToks = Text.split(" ")
    FinalOutput = ''
    for tok in TextToks:
        FinalOutput = FinalOutput + tok[0] + " "
    
    WordSuggestLetters = FinalOutput.replace(" ","")
    WordSuggestToks = [(WordSuggestLetters[i:i+5]) for i in range(0, len(WordSuggestLetters), 5)]
    WordsSuggest = ""

    for text in WordSuggestToks:
        WordsSuggest = WordsSuggest + " " + text 

    return FinalOutput, WordsSuggest

#-------

def imagebasedreading(inputtext):
    # Read the user input text file
    #with open("inputtext.txt", "r", encoding="utf-8") as file:
    #    inputtext = file.read()

    inputtextlines = inputtext.splitlines()

    htmlpart1 = """
    <!DOCTYPE html>
    <html>
        <head>
            <title>Image Placeholder with Text Background</title>
            <style>
                .grid-container {
                    display: grid;
                    grid-template-columns: repeat(4, 1fr);
                    gap: 16px;
                }
                .image-container {
                    width: 300px;
                    height: 300px;
                    margin: 10px;
                    border: 1px solid black;
                }
                img {
                    width: 100%;
                    height: 100%;
                }
            </style>
        </head>
        <body>
            <button onclick="saveState()">Save State</button>
            <button onclick="saveFilePaths()">Save File Paths</button>
            <input type="file" id="loadStateFile" onchange="loadState(event)">
            <button onclick="updateCounter()">Update Counter</button>
            <label id="counterLabel">0 / """ + str(len(inputtextlines)) + """ images complete</label>
            <div class="grid-container">
    """
            
    htmlpart2 = """
            </div>
            
        <script>
            
    function clearState() {
        const imageContainers = document.querySelectorAll(".image-container img");
        imageContainers.forEach((img) => {
            img.src = "";
        });
    }

            
            let filePaths = {};

            function loadImage(idx) {
                const fileInput = document.getElementById("fileInput" + idx);
                const image = document.getElementById("image" + idx);
                const file = fileInput.files[0];
                const reader = new FileReader();
                
                reader.addEventListener("load", function () {
                    image.src = reader.result;
                    filePaths["image" + idx] = file.name;
                    updateCounter();
                }, false);
                
                if (file) {
                    reader.readAsDataURL(file);
                }
            }

            function saveState() {
                let state = {};
                const imageContainers = document.querySelectorAll(".image-container img");
                imageContainers.forEach((img, idx) => {
                    if (img.src && img.src !== window.location.href) {
                        state["image" + idx] = img.src;
                    }
                });
                
                const blob = new Blob([JSON.stringify(state)], { type: 'text/plain' });
                const a = document.createElement('a');
                a.href = URL.createObjectURL(blob);
                a.download = 'image_state.txt';
                a.click();
            }

            function saveFilePaths() {
                const blob = new Blob([JSON.stringify(filePaths)], { type: 'text/plain' });
                const a = document.createElement('a');
                a.href = URL.createObjectURL(blob);
                a.download = 'file_paths.txt';
                a.click();
            }

            function loadState(event) {
                clearState(); // Clear existing state

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const state = JSON.parse(e.target.result);
                        for (const [key, value] of Object.entries(state)) {
                            const image = document.getElementById(key);
                            if (image) {
                                image.src = value;
                            }
                        }
                    };
                    reader.readAsText(file);
                }
            }

            function updateCounter() {
                const totalPlaceholders = document.querySelectorAll(".image-container").length;
                let loadedImages = 0;
                
                const imageContainers = document.querySelectorAll(".image-container img");
                imageContainers.forEach((img) => {
                    if (img.src && img.src !== window.location.href) {
                        loadedImages += 1;
                    }
                });
                
                document.getElementById("counterLabel").innerText = loadedImages + " / " + totalPlaceholders + " images complete";
            }
        </script>
        
        </body>
    </html>    
    """

    #If you have a gpu and imagepipeline then src in img tag = filepath of generate image
    def generate_html(textlines): 
        num_containers = len(textlines) 
        html_string = ""
        for i in range(num_containers):
            container = f'''
            <div class="image-container">
                <input type="file" id="fileInput{i}" onchange="loadImage({i})">
                <img id="image{i}" src="" alt="{textlines[i]} - Placeholder {i + 1}" onerror="this.style.background = 'grey url(data:image/svg+xml;utf8,&lt;svg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\'&gt;&lt;text y=\'.9em\' font-size=\'90\'&gt;Placeholder {i + 1}&lt;/text&gt;&lt;/svg&gt;) no-repeat center; this.style.border = \'1px solid black\';">
            </div>
            '''
            html_string += container
        return html_string

    # Generate the HTML based on the number of lines
    output_html = htmlpart1 + "\n" + generate_html(inputtextlines) + "\n" + htmlpart2
        
    # Save the generated HTML
    now = datetime.datetime.now()
    filename = f"ImagePlaceholder{now.strftime('%Y-%m-%d_%H-%M')}_{inputtext[:16]}.html"
    with open(filename, "w", encoding="utf-8") as file:
        file.write(output_html)

    return filename, output_html, output_html

#--------

guidedreadingseperator = gr.Dropdown(choices=[".", ",", "lines", "Sentences"], value=".", interactive=True)
textspreprocess = [
    ["Bing created this example \nApple is looking at buying U.K. startup for $1 billion \nApple schaut sich für 1 Milliarde Dollar ein Startup aus Großbritannien an \nApple está mirando comprar una startup del Reino Unido por mil millones de dólares \n애플은 영국의 스타트업을 10억 달러에 사려고 한다 \nアップルは、英国のスタートアップを10億ドルで買収する予定だ \n苹果正考虑以10亿美元收购英国初创公司", "\n"],
    ["This is an english sentence. This is the second english sentence", "."],
  ]

LLPromptIdeas = """

Lets try this I will give you the english word and you find the <<chinese>> word and then mix the meaning of the word with the mnemonic

Bings Explanation
Youre welcome. Im happy to help. If I wanted to explain the rules of this game clearly and concisely, I would do something like this:

The game is about finding the <<Chinese>> word for an English word and making a mnemonic that mixes the meaning of the word with the mnemonic.
The game has two players: one who gives the English word and one who finds the <<Chinese>> word and makes the mnemonic.
The player who gives the English word can choose any word they want, as long as it has a <<Chinese>> equivalent.
The player who finds the <<Chinese>> word and makes the mnemonic can use any online or offline resources they want, such as dictionaries, translators, or search engines.
The player who finds the <<Chinese>> word and makes the mnemonic should write their answer in the format: The <<Chinese>> word for X is Y <<(pinyin)>>, which means Z. Here are some possible mnemonics that mix the meaning of the word with the mnemonic: A, B, C, D. </p>

<hr>

Make jokes while following rules for a syllogism jokes game:

The game can be played with any number of people.
One person starts by stating a syllogism, which is a logical argument that consists of three parts: a major premise, a minor premise, and a conclusion.
The next person must then state a syllogism that has the same conclusion as the first syllogism, but with different major and minor premises.
The game continues in this way until someone cannot think of a new syllogism.
The person who makes the last valid syllogism wins the game. </p> 

<hr>

Do you know pydot?
Please create code for a class diagragm using the pydot library in python for the following topic/entity 

<hr>

(System/First request) Your job is to lengthen Text sent to you in a meaningful way. You must create 20 paragraphs for each Text line sent by the user
(User) Text: I went to the beach


<hr>

replace as many words with emojis in the sentence Life is very sweet <br>
next sentence is AI Town is a virtual town where AI characters live, chat and socialize.

<hr>

<p> </p>

"""

LLPromptIdeasasbtns = LLPromptIdeas.split("<hr>")

def loadforcopybuttonllmpromptideas():
    global LLPromptIdeasasbtns
    list = LLPromptIdeasasbtns
    return "Load the examples with the button below, Alternatively copy paste manually above", list[0], list[1], list[2], list[3], list[4] 

def display_website(link):
  html = f"<iframe src='{link}' width='100%' height='1000px'></iframe>"
  gr.Info("If 404 then the space/page has probably been disabled - normally due to a better alternative")
  return html

def RepititionPracticeTimeCalculator(text, reps_per_item, seconds_per_item):
    textlines = text.splitlines()
    lines = len(textlines)
    FinalOutput = f"Total Time is estimated: { lines * reps_per_item * seconds_per_item / 60 } minutes ( {lines} lines)"
    return FinalOutput


randomExposuremessageText = ["Great Test for LLM function calling (with Gradio Client)", "Unknown Tracker Tab = Incomplete Reading Assistant Idea - HTML app based on text to be read", "Bing mnemonic - lost = dont ignore unusual sounds here inside lost cave", "1000 verbs in lists of 100, verbs = easy setence structure estimation (SVO, SOV, etc.)", "Can put any message here in the navigatoin tab"]

def randommarquee():
    randomExposuremessagelistitem = ""
    randomExposuremessagelistitem = str(random.sample(randomExposuremessageText, 1)).replace("['", "").replace("']", "")
    #randomExposuremessagelistitem2 = str(random.sample(randomExposuremessageText, 1)).replace("['", "").replace("']", "")
    return f" <marquee> { randomExposuremessagelistitem } </marquee> "

def TabNavigation():
    return gr.Tabs.update(selected=1) #, tabs1=nav1)

def segment_video_with_opencv(file_path, segment_duration=60):
    # Open the video file
    cap = cv2.VideoCapture(file_path.name)
    
    # Get video properties
    fps = int(cap.get(cv2.CAP_PROP_FPS))
    total_frames = int(cap.get(cv2.CAP_PROP_FRAME_COUNT))
    
    # Calculate total segments required
    total_segments = math.ceil(total_frames / (fps * segment_duration))
    
    # List to store the file paths of the generated chunks
    generated_files = []

    for segment in range(total_segments):
        # Define the codec and create VideoWriter object
        # For .mp4 output, use the H.264 codec with the tag 'mp4v'
        fourcc = cv2.VideoWriter_fourcc(*'mp4v')
        output_filename = f'chunk_{segment}.mp4'
        out = cv2.VideoWriter(output_filename, fourcc, fps, (int(cap.get(3)), int(cap.get(4))))
        
        for frame_num in range(fps * segment_duration):
            ret, frame = cap.read()
            if ret:
                out.write(frame)
            else:
                break
        out.release()

        # Append the file path of the generated chunk to the list
        generated_files.append(output_filename)
    
    cap.release()

    return generated_files

def fill_lines(input, num_lines=1000):
    # Split the input by newline and store it in a list
    input_list = input.splitlines()
    # Calculate how many lines each part of the input should get
    lines_per_part = int(num_lines // len(input_list))
    # Initialize an empty list to store the output
    output_list = []
    currentpart = ""
    # Loop through each part of the input
    for part in input_list:
        
        currentpart += part + "\n"
        # Fill the list of strings into one string with newlines
        filled_part = currentpart * lines_per_part #textwrap.fill(wrapped_part, width=lines_per_part)
        # Append the filled part to the output list
        output_list.append(filled_part)
        currentpart = ""
    # Join the output list into one string with newlines
    output = "\n".join(output_list)
    
    return output

def TestSplitandUpdatebtntest():
    gr.Info("Incomplete - Text Chosen for Interface")
    pass

def TestSplitandUpdate(Text):

    return f" Length of the text - { len(Text) }", gr.Button("Incomplete - Set this Text as default for all interfaces") #.click(TestSplitandUpdatebtntest, inputs=None, outputs=None) - Returns the event instead of the button with the event

TestSplitandUpdateinput = gr.Textbox(placeholder="Counter and Placeholder one point of entry for the text to be analysed across the whole app")

def RepititionInjectedReading(learning, reading):
    readingdoc = nlp(reading)
    learninglist = learning.splitlines()
    FinalOutput = ""
    numofsentencesinreading = sum(1 for _ in readingdoc.sents) #len(readingdoc.sents) is wrong because of generator
    numofsentencesinlearning =  len(learninglist)
    RepInjectedText = "\n"

    for i in range(0, numofsentencesinlearning):
        for sent in readingdoc.sents:
            RepInjectedText += sent.text + " (" + learninglist[i] + ") "

    FinalOutput = f"{ numofsentencesinreading } repitition oppurtunities between the sentences: \n { RepInjectedText }"

    return FinalOutput

# For testing purposes
# file_paths = segment_video_with_opencv("path_to_your_video.mp4")
# print(file_paths)


# Define the Gradio interface inputs and outputs for video split
spvvideo_file_input = gr.File(label='Video File')
spvsubtitle_file_input = gr.File(label='Subtitle File')
spvdownload_output = gr.File(label='Download Segmented Files')

Markovlength = gr.Number(value=30, label='Length of generation')

groupinput_text = gr.Textbox(lines=2, label="Enter a list of words")
groupoutput_text = gr.Textbox(label="Grouped words")

Translationchuncksize = gr.Number(value=4998)
RepSched_Num_lines = gr.Number(value=1000, label="number of lines")

randomExposuremessage = randommarquee()
randomExposuremessage2 = randommarquee()

VideoTestInput = gr.File(label="select a mp4 video file", file_types=[".mp4"])
VideoTestSubtitleInput = gr.File(label="select a subtitle file", file_types=[".txt", ".srt", ".vtt"])
VideoSplitTestInput = gr.File(label="select a mp4 video file", file_types=[".mp4"])

with gr.Blocks() as lliface: #theme=gr.themes.Glass(primary_hue='green', secondary_hue='red', neutral_hue='blue', )
  gr.HTML('<div style="display: flex; justify-content: center; align-items: center; height: 100%;"> ---- Under Construction: Very Slowly figuring out what AI intergrated interface means (Chat vs Forms vs Function calling vs Sensor + Trigger vs Agent) | How to end copy paste once and for all? ---- </div> <div style="display: flex; justify-content: center; align-items: center; height: 100%;"> All the apis from the below space need to be treated like RAG as notes for the LLM to read before providing its answer </div>')
  with gr.Accordion("LLM HF Spaces/Sites (Click Here to Open) - Use 'Acronym Map Creation Space' Tab with this - Ask for Translation of image tags made below, sentence to emojis, Wordlists, Test Conversations, Get Grammar Explanations etc., Can use GPT-4 or new SOTA to review the conversation", open=False):
    with gr.Row():
        linktochat = gr.Dropdown(choices=["https://sdk.vercel.ai/docs", "https://labs.perplexity.ai/", "https://chat.lmsys.org", "https://huggingfaceh4-zephyr-chat.hf.space", "https://osanseviero-mistral-super-fast.hf.space", "https://artificialguybr-qwen-14b-chat-demo.hf.space", "https://huggingface-projects-llama-2-7b-chat.hf.space", "https://ysharma-explore-llamav2-with-tgi.hf.space", "https://mosaicml-mpt-30b-chat.hf.space", "https://huggingfaceh4-falcon-chat.hf.space", "https://uwnlp-guanaco-playground-tgi.hf.space", "https://stabilityai-stablelm-tuned-alpha-chat.hf.space", "https://mosaicml-mpt-7b-storywriter.hf.space", "https://huggingfaceh4-starchat-playground.hf.space", "https://bigcode-bigcode-playground.hf.space", "https://mosaicml-mpt-7b-chat.hf.space", "https://huggingchat-chat-ui.hf.space", "https://togethercomputer-openchatkit.hf.space"], label="Choose/Cancel type any .hf.space link here (can also type a link)'", allow_custom_value=True)
        chatspacebtn = gr.Button("Use the chosen URL to load interface with a chat model. For sdk.vercel click the chat button on the top left")
    with gr.Accordion("Some prompt ideas", open=False):
        with gr.Accordion("Prompts in text (Manual copy paste)", open=False):
            gr.HTML(LLPromptIdeas)
        gr.Interface(loadforcopybuttonllmpromptideas, inputs=None, outputs=["html", "code", "code", "code", "code", "code"])
    chatspace = gr.HTML("Chat Space Chosen will load here")
    chatspacebtn.click(display_website, inputs=linktochat, outputs=chatspace)
  with gr.Accordion("Image HF Spaces/Sites (Click Here to Open) - Use with the image placeholder in Workflows tab", open=False):
    with gr.Row():
        linktoimagegen = gr.Dropdown(choices=["https://simianluo-latent-consistency-model.hf.space", "https://google-sdxl.hf.space", "https://fffiloni-sdxl-control-loras.hf.space"], label="Choose/Cancel type any .hf.space link here (can also type a link)'", allow_custom_value=True)
        imagegenspacebtn = gr.Button("Use the chosen URL to load interface with a chat model")
    imagegenspace = gr.HTML("Chat Space Chosen will load here")
    imagegenspacebtn.click(display_website, inputs=linktoimagegen, outputs=imagegenspace)
  gr.HTML("<div style='display: flex; justify-content: center; align-items: center; height: 100%;'> Agents = Custom Software (Personalised UI and Mods, among other things) = Custom Environments (AR) - <a href='https://github.com/KillianLucas/open-interpreter'> -- Open Interpreter -- </a> | <a href='https://github.com/microsoft/autogen'> -- Microsoft Autogen -- </a> |  </div>")
  with gr.Row():
    with gr.Column(scale=1):
        with gr.Tabs()  as nav1:
            with gr.Tab("Rep - HTML"):
                gr.HTML("UNNWFWO = Unknown Native Word Foreign Word Order i.e. during active listening practice you only need the words you dont know")
                gr.HTML("""<iframe height="1200" style="width: 100%;" scrolling="no" title="Memorisation Aid" src="https://codepen.io/kwabs22/embed/GRXKQgj?default-tab=result&editable=true" frameborder="no" loading="lazy" allowtransparency="true" allowfullscreen="true">
                        See the Pen <a href="https://codepen.io/kwabs22/pen/GRXKQgj"> Memorisation Aid</a> by kwabs22 (<a href="https://codepen.io/kwabs22">@kwabs22</a>) on <a href="https://codepen.io">CodePen</a>. </iframe>""")  
            with gr.Tab("Rep - Gradio"):
                gr.Interface(fn=group_words, inputs=groupinput_text, outputs=groupoutput_text, description="Word Grouping and Rotation - Group a list of words into sets of 10 and rotate them every 60 seconds.") #.queue() 
            with gr.Tab("Navigation"):
                gr.HTML("Primary goal of this space is to help with memorisation --> Two main forms read or listen (rewriting is also an option for mission critical information - acronym map (too time comsuming))")
                gr.HTML("Picture Annotation <br> Chorus Focused Word List <br> Merged Subtitles <br> Repetitive Audio (TTS) <br> Word and Sentence Jumbling <br> Unkown: Wordnet <br> Unknown: Wikipeadia <br>")
                PracticeExposureInput = gr.Textbox("", placeholder="Exposure practice = look up", label="Exposure at the top")
                PracticeExposurebtn = gr.Button("Change Default") #Button CLick is defined under the variable it needs to manipulate to avoid undefined error
                gr.Button("Tab Navigation").click(TabNavigation, inputs=None, outputs=[nav1])
            with gr.Tab("Words Lists"):
                gr.HTML("Stop, Sight(Dolch) and other Wordlists")
                gr.HTML("Wikipeadia <br> Basic: <a href='https://en.wikipedia.org/wiki/Dolch_word_list'> -- Dolch (Sight) Words -- </a> |  <br> Advanced: <a href='https://en.wikipedia.org/wiki/Blend_word'> -- Blend Word -- </a> | <a href='https://en.wikipedia.org/wiki/List_of_portmanteaus'> -- List_of_portmanteaus -- </a> | ")
                gr.HTML("Reddit <br> <a href='https://www.reddit.com/r/wordplay/'> -- Wordplay -- </a> | ")
                gr.HTML("Language Tests <br> ")
                gr.HTML("Other <br> <a href='https://english.stackexchange.com/'> -- English (StackExchange) -- </a> | <a href='https://english.stackexchange.com/questions/572884/what-is-it-called-when-two-words-are-combined-by-overlapping-each-other'> -- Overlapping Blends (StackExchange) -- </a> |   ")
            with gr.Tab("Vector Database = Memorisation"):
                gr.HTML("Phrasebook on demand in realtime <br><br> Open AI - 10000 * 1000tokens (+- 4000 characters) = 1$ (0.0001 per 1000 tokens / 750 words), Cohere Multilingual = free for personal use / Commercial use =    \n Vector Database query = Better than text search but not for logical relationships")           
            with gr.Tab("Time Estimate Calculator"):
                gr.HTML("Repitition = A subconcious time gaame - transparent screens + below repitition assist (Vision) or  (Audio) ")
                gr.Interface(fn=RepititionPracticeTimeCalculator, inputs=["text", "number", "number"], outputs="text")
    with gr.Column(scale=3): 
        with gr.Tab("Workflows"):
            with gr.Row():    
                gr.HTML("<span style:{'fontsize: 20'}>Start at Unkown Tracker if unseure<span> <br> UNNWFWO = Unknown Native Word Foreign Word Order i.e. during active listening practice you only need the words you dont know <br><br> General Ideas in this space - Speed of Learning = Avoid Things you know like the plague -- How to track what you know -- Counter is easiest and How you feel is the hardest (The more you know, the more confusion on what you dont know as you probably werent keeping track) <br><br> Visulisation of long text - Bottom of this page  <br> Wordlist - 1 new word at a time per minute in the space to the left  <br> Youtube Video Watching - Subtitles Tab <br> Reading - Unknown Tracker Tabs <br> Longer Text Memorising - Acronym Map Creation Tab and Transition Tab <br> Brainstorming - Reading Assistant <br> Random Exposure <br> ")
                gr.Interface(fn=TestSplitandUpdate, inputs=TestSplitandUpdateinput, outputs=["text", "button"])
            with gr.Row():
                PracticeExposure = gr.HTML(randomExposuremessage)
                PracticeExposure2 = gr.HTML(randomExposuremessage2)
                PracticeExposurebtn.click(fn=changeexposuretext, inputs=PracticeExposureInput, outputs=PracticeExposure)
            with gr.Row():
                with gr.Column(scale=1):
                    gr.HTML("Advanced Repitition = Combinatorics --> to understand a sentence properly you need understanding of every word --> in language that means use with other words --> Combos within the unique words in a sentence, paragraph, page, etc. --> as close to 3 word sentences")
                with gr.Column(scale=1):
                    gr.HTML("<p>Timing Practice - Repitition: Run from it, Dread it, Repitition is inevitable - Thanos --> Repitition of reaction - Foreign in eyes/ears native in mind (For beginners) | Repitition is a multitask activity like driving must be subconcious process to show mastery </p>")
            gr.HTML(""" <a href='https://github.com/eugeneyan/open-llms'> -- Opensource List -- </a> | <a href='https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard'> -- Open LLM Leaderboard -- </a> | <a href='https://huggingface.co/spaces/sanchit-gandhi/whisper-jax'> -- Whisper JAX -- </a> | <a href="https://translate.google.com/?hl=en&tab=TT"> -- Google Translate -- </a> | <a href='https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis'> -- Modelscope Text to Video -- </a> | <a href='https://huggingface.co/spaces/stabilityai/stable-diffusion'> -- stable-diffusion 2 -- </a> | <a href='https://huggingface.co/spaces/stabilityai/stable-diffusion-1'> -- stable-diffusion 1 -- </a> | <a href='https://huggingface.co/spaces/kakaobrain/karlo'> -- karlo 1 -- </a> | <a href='https://huggingface.co/spaces/suno/bark'> -- Bark (TTS) -- </a> | <a href='https://chat.lmsys.org/'> -- Offline Text Model Demos -- </a> | <a href='https://huggingface.co/spaces/curt-park/segment-anything-with-clip'> -- SAM with Clip -- </a> | <a href='https://beta.elevenlabs.io/'> -- Eleven Labs -- </a> | <a href='https://www.d-id.com/'> -- Animate an Image -- </a> | <a href='https://voice.ai/'> -- Clone a voice -- </a> | <a href='https://openai.com/pricing'> -- OpenAI pricing -- </a> | <a href='https://huggingface.co/spaces/sohojoe/soho-clip-embeddings-explorer'> -- Image Training Data Search -- </a> | <a href='https://huggingface.co/spaces/huggingchat/chat-ui'> -- Huggingface Chat -- </a> | <a href='https://huggingface.co/spaces/bguisard/stable-diffusion-nano'> -- 128x128 Stable Diffusion (Fast) -- </a> | <a href='https://huggingface.co/spaces/colonelwatch/abstracts-index'> -- Search 95 million research abstracts -- </a> | <a href='https://huggingface.co/datasets/roneneldan/TinyStories'> -- Tiny Stories Dataset -- </a> | <a href='https://huggingface.co/spaces/lykeven/visualglm-6b'> -- Visualglm6b - Discuss images -- </a> | <a href='https://huggingface.co/spaces/xinyu1205/Recognize_Anything-Tag2Text'> -- RAM and Tag2Text -- </a> | <a href='https://huggingface.co/camenduru/potat1'> -- Potat1 Text2vid -- </a> | <a href='https://twitter.com/willdepue/status/1661781355452325889'> -- Alexandria Prohect (Will Deque) - Free Embeddings -- </a> |  <a href='https://artsandculture.google.com/'> -- Google Arts and Culture Portal -- </a> | <a href='https://huggingface.co/spaces/Matthijs/whisper_word_timestamps'> -- Word Level Timestamps  -- </a> | <a href='https://huggingface.co/spaces/zaanind/NLLB-translation'> -- NLLB 600M Demo -- </a> = <a href='https://github.com/facebookresearch/fairseq/tree/nllb'> -- NLLB Github -- </a> | <a href='https://huggingface.co/spaces/hysts/zeroscope-v2'> -- Zeroscope v2 Text to video -- </a> | <a href='https://huggingface.co/spaces/SpacesExamples/ComfyUI'> -- ComfyUI Text to Image -- </a> | <a href='https://huggingface.co/spaces/DeepFloyd/IF'> -- Deepfloyd IF - Text in image -- </a> | <a href='https://huggingface.co/spaces/ysharma/ChatGPT-Plugins-in-Gradio'> -- ChatGPT Custom Plugins Test Space -- </a> | <a href='https://www.reddit.com/r/LocalLLaMA/'> -- r/LocalLlama -- </a> | <a href='https://www.reddit.com/r/singularity/'> -- r/Singularity -- </a> | <a href='https://huggingface.co/spaces/hysts/SD-XL'> -- SD-XL Test Space -- </a> | <a href='https://huggingface.co/spaces/facebook/seamless_m4t'> -- Seamless M4T - Translation one stop shop -- </a> | <a href='https://huggingface.co/spaces/codellama/codellama-playground'> -- Code Llama playground -- </a> | <a href='https://huggingface.co/spaces/Voicemod/Text-to-Sing'> -- Text to sing -- </a> | <a href='https://huggingface.co/spaces/camenduru-com/webui'> -- Stable Diffusion Webui (Camenduru Space) -- </a> | <a href='https://huggingface.co/spaces/ysharma/WizardCoder34b'> -- Wizard Coder 34B -- </a> | <a href='https://huggingface.co/spaces/chansung/co-write-with-llama2'> -- Cowrite with llama2 -- </a> | <a href='https://huggingface.co/spaces/fffiloni/Image-to-Story'> -- Image to Story -- </a> | <a href='https://huggingface.co/spaces/fffiloni/CLIP-Interrogator-2'> -- Clip interrogator 2 -- </a> | <a href='https://github.com/THUDM/AgentBench'> -- Agent Benchmarks -- </a> | <a href='https://www.convex.dev/ai-town'> -- AI Town Live Demo -- </a> = <a href='https://github.com/a16z-infra/ai-town'> -- AI Town Repository (Deployment]) -- </a> | <a href='https://github.com/joonspk-research/generative_agents/tree/main'> -- Generative Agents: Interactive Simulacra of Human Behavior (Research paper Repository) -- </a> | <a href='https://huggingface.co/spaces/HuggingFaceM4/idefics_playground'> -- IDEFICS - open Multimodal model -- </a> | <a href='https://github.com/facebookresearch/belebele'> -- Belebele (Meta Dataset) -- </a> | <a href='https://huggingface.co/spaces/jbilcke-hf/ai-comic-factory'> -- AI Comic Factory -- </a> | <a href='https://github.com/camenduru'> -- CAMENDURU REPOS -- </a> | <a href='https://huggingface.co/datasets/b-mc2/sql-create-context'> -- SQL Dataset - A list of simple questions -- </a> | <a href='https://github.com/KillianLucas/open-interpreter'> -- Open Interpreter (alt to ChatGPT Pro) -- </a> | <a href='https://easywithai.com/fun-ai-tools/'> -- List - Easy with AI -- </a> | <a href='https://huggingface.co/spaces/Xenova/whisper-web'> -- Whisper Web (UI) -- </a> | <a href='https://blog.roblox.com/2023/09/revolutionizing-creation-roblox/'> -- Roblox Assistant -- </a> | <a href='https://huggingface.co/spaces/AP123/IllusionDiffusion'> -- Illusion Diffusion (Hide words or shapes in the image) -- </a> | <a href='https://huggingface.co/spaces/Shopify/background-replacement'> -- Background replacement - Shopify -- </a> |  <a href='https://huggingface.co/spaces/multimodalart/LoraTheExplorer'> -- Lora The Explorer (SDXL) -- </a> | <a href='https://huggingface.co/spaces/XCLiu/InstaFlow'> -- InstaFlow (Under 1 second Inference) -- </a> | <a href='https://github.com/tairov/llama2.mojo'> -- TinyStories on mojo (230+ tk/s) -- </a> | <a href='https://emojis.alexandru.so/p/OHVEmfMwQl'> -- Any Emoji you want - emojijs -- </a> | <a href='https://huggingface.co/spaces/google/sdxl'> -- SDXL on TPUv5 -- </a> | <a href='https://huggingface.co/spaces/SimianLuo/Latent_Consistency_Model'> -- LCM - SD1.5 at 7secs per 4 images (after coldstart)  -- </a> | <a href='https://huggingface.co/spaces/fffiloni/sdxl-control-loras'> -- SDXL Control Lora -- </a> | <a href='https://huggingface.co/spaces/aadnk/faster-whisper-webui'> -- Whisper WebUI -- </a> |  """)          
            gr.HTML("Placeholder for every images of each sentence - Good ChatGPT + Dall-E ")
            with gr.Row():
                with gr.Column(scale=4):
                    imageplaceholderinput = gr.TextArea()
                with gr.Column(scale=1):
                    gr.Label("Enter Text and Get a line by line placeholder for image associated with the text")
                    imageplaceholderdownload = gr.File()
            imageplaceholderbtn = gr.Button("Create the image placeholder")
            with gr.Row():
                with gr.Column(scale=3):
                    imageplaceholderoutput = gr.HTML("Preview will load here")
                with gr.Column(scale=2):
                    imageplaceholdertextoutput = gr.Code("The code for the HTML created will come here")
            imageplaceholderbtn.click(fn=imagebasedreading, inputs=[imageplaceholderinput], outputs=[imageplaceholderdownload, imageplaceholderoutput, imageplaceholdertextoutput])
        with gr.Tab("Repetition Injected Text"):
            gr.Label("Optimal Study Reps is inbetween new information acquisition - i.e. any thing you havent read already")
            gr.Interface(fn=RepititionInjectedReading, inputs=["text", "text"], outputs="text")
        with gr.Tab("Progress Tracking"):
            gr.Label("Missing is database integration for the counter and non-english - ALSO TODO - Parralell interface for the html and acronym creator")
            gr.Interface(fn=UnknownTrackTexttoApp, inputs="text", outputs=["file", "html", "text"], description="HTML mini App - UNNWFWO (To track verbs you dont know for listening practice). Use the text from here to create lists you use for the TTS section")
            gr.Interface(create_acronym_map, inputs='text', outputs=['text', 'text'])
            gr.HTML("On the Acronyms you need to underline the verbs")
            gr.HTML("Aim for 1000 reps per item in your mind - the end goal for full sentences is to identify the SOV equivalent ASAP")
            gr.Interface(fill_lines, inputs=["text", RepSched_Num_lines], outputs="text")
        with gr.Tab("Beginner - Listen + Read"):
            gr.Label("Closed Eye Recital per new word | 1 new word a minute while recycling the words from the previous minutes")
            with gr.Row():
                with gr.Column(scale=1):
                    gr.HTML("Listening - Songs - Chorus <br> Anticipation of the item to remember is how you learn lyrics that is why songs are easy as if you heard it 10 times already your capacity to anticipate the words is great <br><br> This is where TTS helps as you are ignoring all words except the words just before the actual <br> <b>Tiny Stories dataset is like a graded reader</b> <br>")
                    gr.Interface(fn=TTSforListeningPractice, inputs=["text", TTSLangOptions, "checkbox"], outputs="audio", description="Paste chorus lyrics from below here and use TTS or make notes to save here (Or paste anything)")
                    with gr.Accordion("TTS Spaces", open=False): 
                        TTSspaceoptions = gr.Dropdown(choices=["https://suno-bark.hf.space", "https://coqui-xtts.hf.space"], label="existing whisper spaces")
                        TTSspaceoptionsbtn = gr.Button("Load a Image as prompt Space")
                        TTSspaceoptionsOut = gr.HTML()                    
                        TTSspaceoptionsbtn.click(fn=display_website, inputs=TTSspaceoptions, outputs=TTSspaceoptionsOut)
                    gr.HTML("<p>Fastest way to learn words = is to have your own sound reference --> probably why babies learn fast as they make random noise</p> <p>If you know the flow of the song you can remember the spelling easier</p><p>Essentially if the sounds are repeated or long notes they are easy to remember</p>")
                    gr.Interface(fn=AutoChorusInvestigator, inputs="text", outputs="text", description="Paste Full Lyrics to try find only chorus lines")
                    gr.Interface(fn=AutoChorusPerWordScheduler, inputs="text", outputs="text", description="Create order of repitition for tts practice")
                with gr.Column(scale=1):
                    gr.HTML("""Reading - Caption images (SD/Dalle-E) <br> <a href='https://unsplash.com/'> -- Unsplash - free images -- </a> | <a href="https://huggingface.co/spaces/pharma/CLIP-Interrogator"> --Huggingface CLIP-Interrogator Space-- </a> | <a href='https://huggingface.co/spaces/fffiloni/CLIP-Interrogator-2'> -- Clip interrogator 2 -- </a> | <a href='https://huggingface.co/spaces/xinyu1205/Recognize_Anything-Tag2Text'> -- Tag2Text is faster than clip -- </a> | <br> <a href='https://huggingface.co/spaces/bkhmsi/Word-To-Image'> -- Transform word to an image -- </a> | <a href='https://huggingface.co/spaces/microsoft/Promptist'> -- Promptist (Microsoft) -- </a> | <a href='https://huggingface.co/spaces/xinyu1205/Recognize_Anything-Tag2Text'> -- RAM and Tag2Text -- </a> | <a href='https://huggingface.co/spaces/curt-park/segment-anything-with-clip'> -- SAM with Clip -- </a> """)
                    with gr.Accordion("RAM/Tag2Text Space - Create Tags here and Copy paste", open=False):
                        RAMSpaceLink = gr.Textbox("https://xinyu1205-recognize-anything.hf.space")
                        RAMSpacetest = gr.HTML("")
                        RAMSpacetestbtn = gr.Button('Load Space')
                        RAMSpacetestbtn.click(display_website, RAMSpaceLink, RAMSpacetest)
                    with gr.Accordion("SAM Space Test", open=False):
                        SAMSpaceLink = gr.Textbox("https://curt-park-segment-anything-with-clip.hf.space")
                        SAMSpacetest = gr.HTML("")
                        SAMSpacetestbtn = gr.Button('Load Space')
                        SAMSpacetestbtn.click(display_website, SAMSpaceLink, SAMSpacetest)
                    gr.HTML("Use Shift Enter To put text on new lines if the text doesnt fit <br> if theres an error you have to remove the foreign letters and place roman ones")
                    gr.Interface(fn=add_text_to_image , inputs=["image", "text"], outputs="image", description="Create Annotated images (Can create using stable diffusion and use the prompt) - Describe from one side to the other to make guessing easy")
        #with gr.Tab("Transcribe - RASMUS Whisper"):
            #gr.Interface.load("spaces/RASMUS/Whisper-youtube-crosslingual-subtitles", title="Subtitles")
        with gr.Tab("Beginner - Reading Assitant + Unknown Tracker"):
            gr.HTML(" <a href='https://www.onenote.com/learningtools'> -- Microsoft Immersive Reader (Comprehension) -- </a> | <a href='https://www.lingq.com/en/'> LingQ - (Word Familiarity based) </a> ")
            gr.HTML("Repitition of things you know is a waste of time when theres stuff you dont know <p> In Language the goal is bigger vocab --> Knowledge equivalent = question answer pairs but to get to those you need related information pairs</p> <p> Vocab = Glossary + all non text wall(lists, diagrams, etc.)</p>")
            gr.Textbox("Placeholder for a function that creates a set list and can takes a list for known words and auto find replaces the stuff you know out of the content")
            gr.Interface(fn=GuidedReading, inputs=["text", guidedreadingseperator], outputs="text", description="Manual POS Tag and Transliteration", examples=textspreprocess)
            gr.HTML("Place holder for a translate to english interface so that highlighting can still work as only english supported for now - <a href='https://translate.google.com/'> -- Google Translate -- </a>")
            with gr.Tab("Unique word ID - use in Infranodus"):
                with gr.Accordion(label="Infranodus", open=False):
                    gr.HTML(" <a href='https://infranodus.com/'> -- Infranodus - Word Level Knowledge graphs -- </a> | <br> Use the below interfaces to find the items that dont have entries --> These will represent new concepts or people which need to be understood individually to fully understand the text --> Infranodus search will help find related and unrelated investigation paths <br><br> TODO Figure Output Zoom / Image Dimensions")
                    gr.Image(source="upload", label="Open Infranodus Screenshot")
                    gr.Image(source="upload", label="Open Infranodus Screenshot")
                gr.Interface(fn=unique_word_count, inputs="text", outputs="text", description="Wordcounter")
                gr.HTML("Use the below interface to fill in the space in this format and then use the chat iframe at the top to ask llm to analyse this: <br><br> Consider how the following sentence meaning will change if the each if the selected word is replaced with one hypernym at a time: <br>Sentence: <br>Hypernyms: ")
                gr.Interface(fn=SepHypandSynExpansion, inputs="text", outputs=["text", "text"], description="Word suggestions - Analyse the unique words in infranodus")
                gr.Interface(fn=WikiSearch, inputs="text", outputs="text", description="One word at a time Unique word suggestions (wiki articles)")
            with gr.Tab("Automating related information linking"):
                gr.HTML("Questions - Taking and suggesting questions to ask = new education --> Esp. Infranodus type outer discourse identification as question generation")
                gr.HTML("The point of reading is to refine future actions especially problem solving --> Creating problem scenarios = thinking ahead of time = One form of effective reading")
        with gr.Tab("Beginner - Vague Language and Guessing POS"):
            with gr.Row():
                gr.HTML("Some Vague Words - Quantifiers, Pronouns, etc. <br/> <br/> Very, Many, Few, Lots,  <br> Lets add 40 words to this list <br>  <hr> Find Replace all nouns with something/someone or and for verbs figure out how to generalise them")
                gr.HTML("Parts of speech recognition = comprehension <br> Three word sentences will give a easier guessing chance")
            gr.HTML('<iframe src="https://spacy-gradio-pipeline-visualizer.hf.space" frameborder="0" width="100%" height="600"></iframe>')
        with gr.Tab("Advanced - Making Questions = Reading"):
            gr.HTML("Some Example Prompts <br><br>Please make 10 questions baseed on this text: <br>")
            with gr.Row():
                gr.TextArea("Paste the text to read here", interactive=True)
                gr.TextArea("Make as many questions on the text as you can in native language and then translate", interactive=True)
            gr.Dropdown(["Placeholder chunk 1", "Placeholder chunk 2", "Placeholder chunk 3"])
            gr.HTML("Load the current chunk here and Put a Dataframe where you have only one column for the questions")
        with gr.Tab('Acronym Map Creation Space'):
            gr.HTML("Acronym cant be read with previous attentive reading - accurate measure of known vs unknown")
            with gr.Row():
                with gr.Accordion('Acronym Map/Skeleton Creator'):
                    gr.HTML("Moved to Progress for now")
                with gr.Accordion('Test with LLM'):
                    gr.Label('Letters are always easier to recall than whole words. GPT 4 and above best suited for this prompt but can test anywhere')
                    gr.HTML('Please help me study by making a acronym map for the maths ontology (Ask if theres questions)')
                    gr.TextArea('', label='Paste LLM response')
                    gr.HTML('Good but we need to now create a 9 Acronym based words - 1 for the headings together and then one each for the subheadings')
                    gr.TextArea('', label='Paste LLM response')
            with gr.Accordion(''):
                gr.HTML('If study content was a map the first letters shape of the whole text = Roads')
                gr.HTML('Known = ability to match an item to a retrieval cue instantly - Retrieval cue for the whole text = Acronym Map')
        with gr.Tab("Advanced - Youtube - Subtitles - LingQ Addon Ideas"):
            gr.HTML("<a href='https://www.lingq.com/en/'>Find LingQ Here --> https://www.lingq.com/en/</a>")
            with gr.Tab("Visual - Multiline Custom Video Subtitles"):
                gr.HTML("LingQ Companion Idea - i.e. Full Translation Read along, and eventually Videoplayer watch along like RAMUS whisper space <br><br>Extra functions needed - Persitent Sentence translation, UNWFWO, POS tagging and Word Count per user of words in their account. Macaronic Text is also another way to practice only the important information")
                gr.HTML("""<hr> <p>For Transcripts to any video on youtube use the link below ⬇️</p> <a href="https://huggingface.co/spaces/RASMUS/Whisper-youtube-crosslingual-subtitles">https://huggingface.co/spaces/RASMUS/Whisper-youtube-crosslingual-subtitles</a> | <a href="https://huggingface.co/spaces/vumichien/whisper-speaker-diarization">https://huggingface.co/spaces/vumichien/whisper-speaker-diarization</a>""")
                #gr.HTML("<p>If Space not loaded its because of offline devopment errors please message for edit</p> <hr>")
                with gr.Tab("Merged Subtitles"):
                    gr.HTML(""" Core Idea = Ability to follow one video from start to finish is more important than number of words (except for verbs) <hr>
                            Step 1 - Get foreign transcript - WHISPER (Need to download video though - booo) / Youtube / Youtube transcript api / SRT websites <br>
                            Step 2 - Get Translation of foreign transcript <br>
                            Step 3 - Word for Word Translation Creation in both Directions (Paste Google Translation here) <br>
                            """)
                    gr.Interface(fn=split_srt_file, inputs=["text", SRTLangOptions] , outputs=["text", "file", "text", "text"], description="SRT Contents to W4W Split SRT for Google Translate")
                    gr.Interface(fn=chunk_srt_text, inputs=['text', Translationchuncksize], outputs=['dataframe','text'], description='Assitant for google translate character limit - aka where to expect cuts in the text')
                    gr.HTML("Step 4 - Pronounciation (Roman) to Subtitle Format --> GTranslate returns unformatted string")
                    gr.Interface(fn=splittext, inputs="text", outputs="text", description="Text for w4w creation in G Translate")
                    gr.HTML("Step 5 - Merge into one file")
                    with gr.Row():
                        RomanFile = gr.File(label="Paste Roman")
                        W4WFile = gr.File(label="Paste Word 4 Word")
                        FullMeanFile = gr.File(label="Paste Full Meaning")
                        MacaronicFile = gr.File(label="Paste Macaronic Text")
                        SentGramFormula = gr.File(label="Paste Sentence Grammar Formula Text")
                    with gr.Row():
                        MergeButton = gr.Button(label='Merge the seperate files into one interpolated file (Line by line merge)')
                    with gr.Row():
                        MergeOutput = gr.TextArea(label="Output")
                        MergeButton.click(merge_lines, inputs=[RomanFile, W4WFile, FullMeanFile, MacaronicFile], outputs=[MergeOutput], )
                    with gr.Row():
                        gr.Text("Make sure there are 4 spaces after the last subtitle block (Otherwise its skipped)")
                        CleanedMergeButton = gr.Button(label='Create a Usable file for SRT')
                    with gr.Row():
                        CleanedMergeOutput = gr.TextArea(label="Output")
                        CleanedMergeButton.click(fn=SRTLineSort, inputs=[MergeOutput], outputs=[CleanedMergeOutput])
                with gr.Tab("Split video to segments"):
                    gr.HTML("<a href='https://www.vlchelp.com/automated-screenshots-interval/'>How to make screenshot in vlc - https://www.vlchelp.com/automated-screenshots-interval/</a><br>")
                    gr.Interface(VideotoSegment, inputs=[spvvideo_file_input, spvsubtitle_file_input], outputs=spvdownload_output)
                    gr.TextArea("Placeholder for ffmpeg command generator and ffmpeg-python code to split video")
                gr.Text("Text to Closed Class + Adjectives + Punctuation or Noun Verb + Punctuation ")
            with gr.Tab("Audio - Only English thoughts as practice"):
                gr.HTML("For Audio Most productive is real time recall of native (where your full reasoning ability will always be) <br><hr> Find Replace new lines of the foreign text with full stops or | to get per word translation")
                gr.Interface(fn=TTSforListeningPractice, inputs=["text", TTSLangOptions2], outputs="audio", description="Paste only english words in foreign order and then keep removing the words from this to practice as effectively")   
        with gr.Tab("Transition is the end goal (SOV, SVO, VSO)"):
            gr.Interface(fn=FrontRevSentChunk, inputs=[ChunkModeDrop, "checkbox", "text", langdest], outputs="text", description="Chunks creator")
            with gr.Row():
                with gr.Column():
                    gr.Interface(fn=AutoSyllablePractice, inputs="text", outputs="text", description="One Word At A Time | Audio Spelling Practice Using vowels as the seperator")
                    gr.Textbox("A word is a list of letter as a fact is a list of words. Both are in a specific order. What is most important is practice the order so randomiser is the tool", lines=4)
                    gr.Interface(fn=RandomiseTextbyType, inputs=["text", RandomiseTextType], outputs="text", description="Randomise order within words, sentences, paragrahs")
                with gr.Column():
                #with gr.Tab("Collocations (Markov)"):
                    gr.HTML("Transition is the true nature of logic i.e. like some form of non-semantic embedding that is semantic?")
                    gr.Interface(fn=build_model, inputs="text", outputs=["text", "text"], description="Create Collocation Dictionary --> Google Kathryn Lingel - Pyambic Pentameter Example - PyCon US for more")
                    gr.Interface(fn=markov_generate, inputs=["text", Markovlength], outputs="text", description="Generate Text based on the collocations in the text")
                with gr.Column():
                #with gr.Tab("Spelling + Chunks"):
                    gr.Textbox("Merged Spelling Practice Placeholder - Spell multiple words simultaneously for simultaneous access", lines=3)  
                    gr.HTML("<p> Spell multiple words simultaneously for simultaneous access </p> <p> Spelling Simplification - Use a dual language list? | Spelling is the end goal, you already know many letter orders called words so you need leverage them to remember random sequences")
                    gr.Interface(fn=create_dictionary, inputs="text", outputs="text", title="Sort Text by first two letters")
                    gr.Interface(fn=keep_nouns_verbs, inputs=["text"], outputs="text", description="Noun and Verbs only (Plus punctuation)")          
        with gr.Tab("Thinking Practice (POS)"):
            gr.HTML("By removing all nouns and verbs you get a format to practice thinking about your words to use to make sentences which make sense within constraints")      
            with gr.Row():
                with gr.Column():
                    with gr.Tab("Sentence to Practice Format"):
                        gr.Interface(fn=split_verbs_nouns , inputs="text", outputs=["text", "text", "text"], description="Comprehension reading and Sentence Format Creator")
                with gr.Column():    
                    gr.HTML("<a href='https://huggingface.co/datasets/b-mc2/sql-create-context'> -- SQL Dataset - A list of simple questions -- </a> |")
                    gr.Textbox(label='Use this text to hold translations of the SQL rows in the above linked dataset (A kind of What I say vs what I want)')
        with gr.Tab("Knowledge Ideas - Notetaking"):
            gr.HTML("""<p>Good knowledge = ability to answer questions --> find Questions you cant answer and look for hidden answer within them </p>
            <p>My One Word Theory = We only use more words than needed when we have to or are bored --> Headings exist because title is not sufficient, subheadings exist because headings are not sufficient, Book Text exists because subheadings are not sufficient</p>
            <p>Big Picture = Expand the Heading and the subheadings and compare them to each other</p>
            <p>Application of Knowledge = App Version of the text (eg. Jupyter Notebooks) is what you create and learn first</p>
            """)
            gr.Label('Placeholder for LLM api plus the drop down function below populate text for each line into dropdowns')
            gr.Interface(fn=TextCompFormat, inputs=["textarea", HTMLCompMode], outputs="text", description="Convert Text to HTML Dropdown or Links which you paste in any html file")    
            gr.Interface(fn=create_collapsiblebutton, inputs=["textbox", "textbox", "textarea"], outputs="textbox", description="Button and Div HTML Generator, Generate the HTML for a button and the corresponding div element.")
        with gr.Tab("Real-Time AI - Video/Audio/AR"):
                gr.HTML("HUD Experiment (Waiting for GPT4V API)- Full context of user situation + Ability to communicate in real-time to user using images (H100+ and low enough resolution and low enough steps - it/s = fps) - just like google maps but for real life")
                gr.Interface(fn=ImageTranslationTest , inputs=[VideoTestInput, VideoTestSubtitleInput], outputs="video")
                with gr.Accordion("Whisper Spaces"):
                    Whisperspaceoptions = gr.Dropdown(choices=["https://sanchit-gandhi-whisper-jax-diarization.hf.space", "https://sanchit-gandhi-whisper-jax.hf.space", "https://sanchit-gandhi-whisper-large-v2.hf.space", "https://facebook-seamless-m4t.hf.space"], label="existing whisper spaces")
                    Whisperspaceoptionsbtn = gr.Button("Load Whisper Space")
                    WhisperspaceoptionsOut = gr.HTML()                    
                    Whisperspaceoptionsbtn.click(fn=display_website, inputs=Whisperspaceoptions, outputs=WhisperspaceoptionsOut)
                with gr.Accordion("Image as prompt Spaces"):
                    Imagepromptspaceoptions = gr.Dropdown(choices=["https://badayvedat-llava.hf.space", "https://xinyu1205-recognize-anything.hf.space"], label="existing whisper spaces")
                    Imagepromptspaceoptionsbtn = gr.Button("Load a Image as prompt Space")
                    ImagepromptspaceoptionsOut = gr.HTML()                    
                    Imagepromptspaceoptionsbtn.click(fn=display_website, inputs=Imagepromptspaceoptions, outputs=ImagepromptspaceoptionsOut)
                with gr.Accordion("Old Ideas to consider", open=False):
                    gr.HTML("Nicolai Nielsen Youtube channel - aruco markers = position --> can test using premade ones from an image search")
                    gr.Textbox("Alpha Test version = Real time Lablling of All things in view using SAM and Clip Interrogator and OpenCV on pydroid --> Adjusted Demo")
                    gr.HTML("Some Prompt ideas --> Prompt: Describe the place where these descriptions may be (You job is to be speculative for brainstorming purposes): A dog and a boy, the area is texas, the weather is sunny, the date is 01 May 2021 <hr> Prompt Content Ideas Ideas Clip Interrogator + Location Data aka tags for place, location and time + general news updates on the location + overview of the items in the location  <br> Location based advise is most important but after that is information observed by appliances in the location eg. Times Computer turned on, times geyser inspected, amount of time keys havent been touched etc. <br> each location will have an ai personality that will relay more information ")
                    gr.HTML("<a href='https://huggingface.co/spaces/xinyu1205/Recognize_Anything-Tag2Text'> -- RAM and Tag2Text -- </a> | <a href='https://huggingface.co/spaces/curt-park/segment-anything-with-clip'> -- SAM with Clip -- </a>")
        with gr.Tab("Incomplete Tests and Experiments"):
            with gr.Tab("Graph Based Reading", id="1"):
                gr.Textbox('Parts of Speech based | Automating the Notetaking Tab either directly or using visual llm to use this interface efficiently')
                gr.HTML("Types of comprehension agent <hr> Speed of Comprehension = Verb comprehension <br> From the following please extract the verbs <br> now explain each in context <br> Next, use picture descriptions for each word in the verb list <br> Create combinations using the verb list <hr> ")
                gr.HTML("How VERBS RELATE TO EACH OTHER --> Shared Nodes - what other verbs are connected to the noun in a INFRANODUS With POS Tag filters")
                gr.HTML("Tree and Branches approach to learning = familiarity with keywords/headings/summaries before reading the whole text <hr> Productivity/Work revolves around repitition which can be found looking for plurals and grouping terms eg. Headings and Hyper/Hyponyms Analysis")        
                gr.HTML("Sentence to PyDot graph")
                gr.HTML("Currently a bug that locks all buttons in the space when you use this above example - Reload to fix")
            with gr.Tab("Random Ideas"):
                gr.HTML("""<p>Spaces Test - Still Undercontruction   --> Next Milestone is Turning this interface handsfree | Knowledge is a Language but productive knowledge is find replace as well | LingQ is good option for per word state management</p> <p> Arrows app json creator for easy knowledge graphing and spacy POS graph? --> Questions? -->  
                <p> ChatGPT Turns Learning into a read only what you dont know ask only what you dont know feedback loop --> All you have to do is keep track of what prompts you have asked in the past</p> """)
                gr.HTML("<p>Target 0: Mnemonics as title of images --> Comprehensible input <br>  Target 1: Dual audio at word Level while using repitition to train random recall --> Word level Time <br> Target 2: Video --> Split by sentence --> each word repeated (60) + each phrase (10) + each sentence (10) --> TTS file for practice --> State Management/Known word Tracker <br>-----------------------<br> The trick is minimum one minute of focus on a new word --> Listening is hard because there are new word within seconds and you need repeated focus on each to learn </p> <p>Audio = best long form attention mechanism AS it is ANTICIPATION (Awareness of something before it happens like knowing song Lyrics) FOCUSED - Attention (Focused Repitition) + Exposure (Random Repitition) </p> <p>Listening is hard due to different word order and word combinations (collocations more important than single words)</p> <hr>")
                gr.HTML("Predictable to identify the parts of picture being described --> The description moves in one direction from one side of the image to the other side is easiest <hr>")
                gr.HTML("Image = instant comprehension like Stable Diffusion --> Audiovisual experience is the most optimal reading experience <br> Manga with summary descriptions for the chapters = Most aligned visual to audio experience")
            with gr.Tab("AI Tools, Prompts and games"):
                gr.HTML("TODO = Llama-cpp-python with falcon 7b / openllama 7b intergrated into each of the interfaces in this space aka --> interfaces as tools for open source llm <br><br> <b>Test using gradio space/interfaces through the api as function calls for gpt3.5 and 4</b>")
                with gr.Accordion('Command Based Tools - Instant verification of ability to describe'):
                    gr.HTML("Roblox - <a href='https://blog.roblox.com/2023/09/revolutionizing-creation-roblox/'> -- Roblox Assistant -- </a> | <br>  ")
            #with gr.Tab("Gradio Client Tests"):
            #    gr.HTML("How to return componets here in gradio (as each client interface needs different inputs) like in react")
            with gr.Tab("Current Ideas to edit old sections"):
                gr.HTML("The core themes = scheduling (randomisation and calendar marking), speed practice, visualisation, and audio, repitition, compression and finally Tracking and only learning the unknown")
                gr.HTML("Parts that are already done - Repition and scheduling (randomisation) on the sidebar, compresion using the acronym tab, Audio in the beginning tab, unknown partially in HTML creator")
                gr.HTML("Parts that are not done - Visualisation (of acronyms / duo word sets / nouns and verbs) - The image placeholder creator script, Tracking (private = database, public = textfile export), calendar based scheduling aka alert based  ")
                gr.HTML("React Version of the app can combine all of these use cases into one component - so far tracking, placeholder and partially scheduling have been done")
                gr.Label('True speed simultaneous - which is a boolean state = practice at simulataneous to get simultaneous  |||| Another way to be fast is to practice simultaneously with the varios SOVs i.e. when you read a noun the verb must appear immediately and vice versa |||| Simultaneous Spelling is the other way to practice |||| The main goal of all reading is that next time you read you take less time this time: |||| Spped = ability to anticipate the next word |||| Anticipation of a sentence = POV ||||  ')
            with gr.Tab("Text to image for only nouns "):
                gr.Label("Placeholder for the transformers code Generator that can be used by anyone with gpu to turn all nouns in their text to pictures (The lambda labs code)")
            with gr.Tab("Simultanoues Practice Zone"):
                gr.Label("Audio based space where you must look at the corresponding text for the audio thats playing as simultaneous practice")
                gr.DataFrame(None, headers=["text", "audio"], label="Add text pairs to practice", interactive=True)
                gr.HTML("Below you can create and listen to the audio")
                gr.Interface(fn=SimultaneousSpellingPrac, inputs=["text"], outputs=["text"], title="Simultaneous SpellingOrder fast fast practice --> 1 letter a word = fastest read")
                gr.Interface(fn=FirstLetterSummary, inputs=["text"], outputs=["text"], title="Order fast fast practice --> 1 letter a word = fastest read")
                gr.Interface(fn=imagebasedreading, inputs=["text"], outputs=["file", "html", "text"], title="Placeholder for every newline")
            with gr.Tab("Long Text Analysis"):
                gr.Interface(fn=LoadNLTKUDHRText, inputs=NLTKudhr, outputs=["text", "textarea"])
                gr.HTML("For Long text searches are useful under time pressure and also bring all direct interactions with search terms - a word is defined by those around it")
                gr.Interface(fn=onlyplurals, inputs=["text"], outputs=["text"], title="Only plurals = optimal concepts to learn first as work = repitition")
                gr.Label("Placeholder for old code for concordance and word counting in other test space")    
            with gr.Tab("Video Segmentation with OpenCV Test"):
                gr.Interface(fn=segment_video_with_opencv, inputs=VideoSplitTestInput, outputs="fileexplorer")
            with gr.Tab("State Management and Education"):
                gr.HTML("Education = Learning things you didnt know yesterday and not forgetting more than you learn <br><br> What you didnt know forms = <br> Glossary <br> Lists <br> Formulas <br> graphs <br> Procedures <br> <br> for each you will need a seperate way to track the progress but amount of times + recency = approximate state ")


lliface.queue().launch(share="true") #(inbrowser="true")