import gradio as gr
from PIL import Image
import requests
from io import BytesIO
import random
import time

def load_image(url):
    response = requests.get(url)
    image = Image.open(BytesIO(response.content))
    return image

def generate_image(prompt):
    prompt = prompt.lower()
    
    time.sleep(random.randint(10, 20))
    faces = [
          "https://avatars.mds.yandex.net/i?id=f9676dc9c99572353c509d298a0b9f6571edca4e-10514707-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=e02f3f0a7cab6ae7eba3b1209ba9d56dcc24715a-7552414-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=aa883402ff70aa4c6d77441e3b2f3fb85483a047-5480663-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=30ae3f522a50aea82e7c61444656a259dbc106af-7823046-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=0ffd2b2d3d6927fdd824ce3af649bdc2827bc72c-10092505-images-thumbs&n=13"
    ]

    landscapes = [
          "https://avatars.mds.yandex.net/i?id=d817020d4f33ce8dd5f012ec14b46026230f7f38-4304379-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=0c44f37e0f3240a7f873ade37dbf77d87be8d3a0-9103996-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=54432591615e90e906f554b6deb6a33ae47e56b0-7551636-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=ef1792a7e82c70fb5a12c0b159c061b31c1c2461-9237918-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=e2639ee50941423c94aab655b416c8e1db84a015-9712020-images-thumbs&n=13",
          "https://img.freepik.com/free-photo/beautiful-shot-grassy-hills-covered-trees-near-mountains-dolomites-italy_181624-24400.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/mount-fuji-lake-kawaguchiko-sunrise-vintage_30824-49.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-mountains-landscape_23-2150787970.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/beautiful-view-caucasus-mountains_114963-19244.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/top-view-fir-tree-forest_181624-28786.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/misty-carpathian-mountain-landscape-with-fir-forest-tops-trees-sticking-out-fog_146671-18433.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-landscape-mother-nature_23-2148992397.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/hand-painted-sunset-mountain-trees-landscape_1048-19076.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    animal = [
          "https://avatars.mds.yandex.net/i?id=a1a7b590d43b39c427304b03c180802c-5714596-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=4da68929c18e73e06c2332018658f2f344f4e56e-8567697-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=c4000087b8d4c591d887a3d21f25a76738cb3d21-5880141-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=d507afc55fdbef5d6c51aa82acbf2d06211b79d8-7051980-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=52bfb5b4c8638c1c5feecf49797240d0e4128425-9181120-images-thumbs&n=13"
    ]

    car = [
          "https://avatars.mds.yandex.net/i?id=4b8a4a2285b409371e8b45060db83d522fd7e3a8-9624682-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=5583a40b92d72bbaacd0726f5b7504b5bb41ec4f-8264916-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=f2bf530d35b3eb1e4a50db12a3f6347fca90504a-9609067-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=fa0f8f3c6411a8122be313df6c8adcf7d389d3c6-7552082-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=93519c6b3adf47b03313c2a325eb51e75018eeaa-10332876-images-thumbs&n=13"
    ]

    food = [
          "https://avatars.mds.yandex.net/i?id=aa2854aebae7aad2c9c84f9ca556823076924800-6974903-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=c9b4d7e1c5991af6efdc61d3a3f5b91c7b5790b8-5229803-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=f4ba649ad0017b1a8ad1bdba4c0b523e-4290971-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=045887a75bb76213d556631a67a27ce7c9df7b81-9716553-images-thumbs&n=13",
          "https://avatars.mds.yandex.net/i?id=4b8a4a2285b409371e8b45060db83d522fd7e3a8-9624682-images-thumbs&n=13"
    ]

    boat = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT7uC_XzpcX5FOfoPiKG-OR3O9-gTgRQ97t5dTW9kCtSKNRJ6Oz6J8fav5um1U&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRDzZkpmyutasQm5JmkcwFCJ964i1SaShl5uZ2JWVysTJ-USU-m2g4jnGCJ3A&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTIHj-QBEXroe_P-t8PVd7hVlA_XeQT2O9emiDb2dDODwOKU3GJM3XAo0BiLP8&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRN_7Cg8g0GR0pHIsWlC6zucsVad6GJQeoxjZuCC6NtEYSi6iN3PD_oOqgMCs0&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQbO69SuDBUWRxPmSaMvY9tUzvN3CPDGy6Qy7Ws88jgNHXtLDMJAv9dTYPKYbo&s"
    ]

    logo = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSzDj5UHlSMn4JnM-LU1lDI5Gj8IyXoUGcPJFUW2L9g4ud_A2DEaCBVAlupLnE&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQuEVbV_xtLzMDbVj9Hqfet_JoN7-L0uTflNS9szF9nxWWYtEiGrMnA4H_59EQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS9m3Ifv2-Gqjlq6q2YefVARxit9uQYXVvrFkCXhXF2xvFxQoY2iFUCjRPBwA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQtS6eh12jeaQA5bVBKL-Vs2bbeUVE6i9i05-5qGjL6WyrSG-ipgR1x41DB49w&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRxVnmLkyBugPNPiUPbE91e8M6hNm8MprUyECSMO_FrJ49maB-1AYvVBeI10fI&s"
    ]

    eye = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRWYbVL4JZbaW2lRAFGhFw22TU2m1qpVjc8o7Z0PCGkOG3--FLJbwv_Errvwg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRaSR6_WMsGOAfItkCMiFxNgXKmAZVOhsAH0yI-0cuecvH8SnbJZIw2t2VfwQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQvJagN3MtIQPzKjextKbUHtF5Km_R5JXIPSq4LY8stLtCzrLHJhtCcXpiXpXo&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRLHok8H8zbsX5Oupg5DJBxLcp6Tm6LAg4S0gJ3o5lpbXYeNm5j36sWI8DX1Q&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT5a0d5jgLm6lOMHIFTC5NN0Bea6EItJJPo5mNa3oX5dwMf7dwDjoTW1SogTu0&s"
    ]

    beard = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTiJOMp_SLFTOUXZCz9ssycWmh5Sn2WpE0AfIfnVdpooNqnqDT0n_gcpyzeMA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRO4dmmQnmxAP3_0AUBH031bbk-YMWnQNMIhEUxz6LV4JdPZ5ic0B3WhnEpXw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQpzFdwz_l57Nkuz089OMl8rZiKvr6zVLeyMbaQOTEKRk2e7Hgwr2tkCIkwsQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSWFIOd5jPEVlc6hll0oyF3rbcOAWxAi8OF-BnCxAaCQBWWQDG_La69bmOm_g&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTQO-zriw-KQA6JNr-Wg2vzlsd-JJBoAoDclFuEJ900j01XuMFpN0qB_QbJ5Hc&s"
    ]

    avatar = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQhoGkHKK-mUcbSGNLNw_zM_vSGD5axZmiysJiKHz62-S1j61KVUypKeRZ6Jw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRpbv3vxSrrCksivuHDtAO7dZylFj0YoeB3xZ8ujV37046chtdbOlXQJNBuSg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSrD3u82KvAmb2sNdU5An5HTgr8uJAVHyD7878tdxoBtf8M_oBvKV1x5zDFmn8&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRHKrlqz4evD_YlQqhwq6cCW5x6XkMxLZb4mFTqkuNTBe4hQCSBUa_KFIqWnw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSZknN5zWQt0C6vzbTjL2XkU0BZthLv0zUgrKoSyTgEO_5FeyVSl4oiSPKUWQI&s"
    ]

    dreadlocks= [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSJAdKXK3VacgTY6Slf3wYALB7d1yMfilkpYAMe4wwXmWq3uXCi981Kka5_bfE&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTqpcvYkiKXkkEd7x2udV87zj4SXC60hwuzcqF9yHkRpPGh-nUwEPzqSGJwGQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ6DPaqOivnFuLovOI_TuUWxfkLj4z9BmlFcvAhN2PEYBs9EAJdNEW1EDLBmS8&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQM4hIEP519ofGPZPv3ZwvaZBElD2dZL1AFWmtwvNlHaxMX1ndew80eZ_bWWiM&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSD8ReWbLVONl2rqPCSzVrl1UHCy92gC06Opfekhe1kvkvPiKPY9zRK_XT5fA&s"
    ]

    soap = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRsgzD0uRzqZVq84N7upWTqLuf0UUBKVPrdlBFbYFtAJloSIsUogh6vEZEAnQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTsfiDc8JlSL9f3Hchjp_kJ90BlbIlqzOKh1x8-cU7vBvqtVhp2MtOvkSMHGy4&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQI0pzIuoZKeAhh0SkC6HOVFion1tkeGQbFwZ_vLZCNewuz22oWiEuHV7N8Ww&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSIwxtneQ0cWI4W-vR3l6aPg6ngJc1A368AKUufCaP4s3Sf6meK-Gjb7WuPBg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRYazRp7i1fSoqCC0fTHi7NbIGnFhXkJQvKFZJ1WkticD0zjG_P5UK6KoaKDw&s"
    ]

    sumsung= [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRCPcaCaH1iV4CxGtCM2QiE9k2rxDJAwLB1q9RjmKeI11YuKRZV97FMyN7TGUA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ_lK5kondU1fLYopOzhs35c7O9895dQEg7ZA4f_tWwKoyg-D5K9BBgOsiK2A&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTdnE_U-MyUYNQuu3AItAc6sjN3QOHbsuN6igd06jkkW_72IWLgpgZBYDhmPO4&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTSpo9Rk0bHp6zz1RINp4zXPvxOJpcxHwiVHCWhG4WnQbixaW2da2GOzrdE4Kk&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRk73Acil1EDstNwJROXJ2kyvYjyI_wCab_mWsS5Vm09-9uyXLNd277QGd0aTE&s"
    ]

    phone = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR4oq8P-XORyX_g-oQz4yiXotJO85q0PDYbRo7rWbnt3nwklHocAOPXXARGU7I&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRqZMzmeDwvUyDmG5x0y586u9v_PqefKcRd8DlLI3pk8YA3FPJoHHDhWQJO7w&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRwRQ4guGOZ3gYLngSIPqhsnKAPUuoBmTz-54klXS_kDMd5p8CDjMqXOaVeouU&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTKaO7EQrR2zSN2thcH9qBROWIpxe6bGEc0m_F4BFiUAt8FzsfulbPhdhWaog&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQjsQYj_Ut9gpKFHImQJvSXd9HD31PZEumBqKohwyLFKCNlK1wCQuo6F9dAgIc&s"
    ]

    iphone = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRnsbZqd6WXaneQDuWE54UDgLMcwyeWRu45G0G3BarzaNETVacPsc4fnYtISQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQBPSTHkYe2UTr1VtpPJqt1j_9GwTtCQaPoMKv5-lWz2-hwp18WUuhI9qZ2WeE&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSZQDa7mSYdE8ngeICK5WBg0UYsHdkJ5dVrxUi03qIud5tgiic2NL_ta93OJPc&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSFslO464O0WgNa4JME2M5ODR9lyxebh5SbY6RMzw9RTCOTcuYfz5FCkvsCsOc&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRgINKzd2do0Gq92Ze_9Z2vRE42-mgyJUxbZnq7VclmrPzFmXr6j_eFDyxsfEk&s"
    ]

    code = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR8AQUUNCiFvhqKIAbomE0Oi8klATjRW1_OIDaxnvsBfgpGcbDNEgPtAI7Cow&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQQVswifdUmIkjvImbXIzkEGZBKjukPCpslWapX3XZ8yKuqzis_103p2kfqwjk&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ8F2fRUA43Jv0kDPFlfiP70Xvuje5X-xBrsv8jLHRjBZCrls2WT6lKb3OJ9P4&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT93F2GIUYF1fI9bHZ3O3qyg8obIPn_OAjWc0HPKbCcTFtzSYOVg8QwxoW3bUY&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQHVOT4zPTgvgrxvJhHbGUWYwwkfwyg7-Laj1HmXk7L7hNsAy15-mkAz9W0zQw&s"
    ]

    ytlogo = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcROoysKpwbXlY2M4z6wSfH1n4CiNGWI4sQ052sz8wPZB6zgQp2FELDFEmb4D-4&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRGT0bDOiIfqKI-UsX_o85KYMF7GXqecDlI3pFe8qeWDRUB7DiT2pBiQky-kQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRpln5qd4ZhvF51yhcP2Hk31wQipzlrLfEp2gpLozBCp9kLH-Csl0p6_3TA5g&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQRODy1QkPYlzUbv8s-ONymnztScHTTp7pU7iIU8xo1U_HbBHAzTSl529nZ0Qg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR-ke4ykhnylaUE7cwvKJflTIron_YEv2G6djOyHy8eWNUT66ekBn_NRxeK1sk&s"
    ]

    backrooms = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQL6KWuRbgabni4B5L-W1ZUoU7qWBuGeLgun1FBTYKbUrKbM3pmZl-zKfeu4gE&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSdWGZ0mSyjGAzrF6NZpzp5YMCxKfwuTtQm8FgjoLtJ-BfAzNgfyFVwut0OB70&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQfUa9DtjgccXhdpjhAUu9jA4r6sXlheQEwdm5CKGbkzm7UYiDHSb9Ppnj31g&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ3xb2t61JY1ydKvXxE2rvhHwIoD9QpOhNc5bQAwiaKrUWJxh5nvRQ4gShIzg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSJFpQDPzCY2VrgnDyzE66l0PtsyXZwfryN7lFTy7Tt1NroElcNP-NSdvKfOg&s"
    ]

    dog = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRotwetUK0NfzN-2GOk2nH6HAOcCIos85WFZRQkRxtkk-OfNgCFRivkWXKbNA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT_peU0kINinA3eXkJadJeSvejSl_5sdsl0YragpD48DY8gR-3N4lJv1MAZkg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTxc6B-rTX2W_2ebGA9yevnhaJZJpW7Njs_QIuERCnYnVv68Q53LbyEn8sjgA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS3Eihd0V74gEj-DQg7d7oWgAoewiK_o1CKS7pEhjzfg-uj7gTlE5N8GWnYwA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQRzkLbC-711Phno7wpIXPmCyCQoVtN1L5iRMgRZ2OY6HjAlUMxroPB4hh1o9k&s"
    ]

    doll = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTz7ezACV5JTBS-4t62vweRIgJJtPtBocuvXWcqn2tmbdoxMoWBJisoK26EuQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTkPI_jklNmx9mxdfBgihNUDkriHaMcNIr-wzftGGX8nJ8NuGL7-l52YDXX2Io&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTZnP0N33NH6DNxn_xJKsSIjBOIDWcjqSk4vPnIyyDgC1z-TEsM0Ouo9PyKaQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRIQwigkIJf8WxNVsgnzHBkMjKCot8qmST1ZO-XXVn-5Q-2oP4IjU21epQtPw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSAaBAWGR8xL_Ds3O3zU3gpPm2nFGkZka6QMoRQclEDxoabOM1axtcN1DyYqg&s"
    ]

    background = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTk6eYuzpiGwpQzrLGyMInzUQH8rLMi-tJ-CgO3jzE7EwjMuPhCbD-Izg4c8g&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTlfc5dgbFAWBpzXUqqG8XpFp0ChXGhizw4te7p5gdN2JN39uk75qfJSsyGzA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTy7tvvh3-1rWQ5p6DKl-X0-Ch-hwWcRS0Gz3hlSSva0701dLWc4QpPamuho20&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJmfreu3ua18h8EcArDD_jzoLMXWKOgOnBROtzThALjeqMWEOAa4oz_gn_fk8&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR7i4xPXauC7fC6R4gz8TgcQCPkqwAg2olTPDgSOFm3i3FLLxD8Xf9uFg5BZOs&s"
    ]

    rocks = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT3PhKY8mj-GRrwr3wZbpZq_QOi4PPff8XhQ3NMCP66xESicYz6IcOlXNVtMzk&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRRigOBUBYtxsOa3dz3uc8n6Px8BNTWgwurbO3DRbMETydwWJ_oG8likIwP2g&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSw9BesCM_YHs4Iou8-fSEVAI8Qz_dCfKBRSDzy2GjzSz2biE2BBMkOM_o8Ow&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSkpCg5fj_yKPuxi-YG3-q8IuVq66Rsw_3dJHgCJTVlJlU2MociE1zvLz0FuOg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSx9XrO9FSPBsrAmm4X5Pz92ngVxx3wBrtuxQqwHsk_9XpPuOP5y23eVvAtJw&s"
    ]

    goldrobot = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ6fOQe7D-zsr_TBymoLoyK5l30OeW4plpVc_oUeClzqGuCbbfkU1ESKkloKUg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTPyWunhkGAw5d3SaEV6gS6NT4ASOrG6A99TA-dQGd9fQwX1aQqhKrJpgReEWs&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTyQTzY1WDfsUHy0qlR6Gw7XPvXJH3fQyT7ynECg_xQxL-hQbhq7OmmXcxBPlc&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRh2Vya7ab5AdihcJ7k6NtNyCoTv_S2uNgZ7i40OCCEFJIWGUGcj_DvppmOyw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ22ZuyrA2M6ezgdOKsUzhFjjsckZUacogWsQsPELvBC7BXElUxz4fCYmK2kEc&s"
    ]

    horse = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSEEIV6tfelJDs73aDbXP7zccLe5JO8oPS411OzB8bZO1zHN92Z1C9yZGlfjzQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQXOP6P4qf5OqHKkdsSDSsmcbdttWlWdxKQqF6TqXowZ7Fva1ozdaBoJ2vuZw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRco4tdguZDuIkmARj7vFfmYq-ks4rRq_l5w4pSfZFWKogqf-OfHHbsPYElSYI&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ39g8eCI7-czS2aXXmkyUn-1mGBg625cHy2DL6b2uH8aTF16oGlN-efn03Rw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQVdiyhiRRqyCij3gZBKb2UpuHUyC13s8uX1lOurDfOzp2wSplmzRGQiG4aSVY&s"
    ]

    house = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSSWYMqKB_-v7joSASuJmA8F1hASiq0NRXME67bt0URWmcEJX0HEHQRYoZL_Q&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQqt3XksHl0s237mkxq44OQSXFS5r9n5M1Oh8xrYK7fR5ugIa5cn88HiaUKEEk&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS3by_Lf10vtCBQxzuWJEy4o3mlNxKcUZyuWAukYck-dRjlQ280e_dFG7Kq2lc&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSeyiSfAmb3V5cjSudujc2eT77PHzWBK6NSoXJq98haB3lq3fkQqCaQjdH8vQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQMy2ir-gBXuMLoVsSp4_mMHRO_Rq08JGEzwDlhSvo2J59dzhWp95tYGf-KAsw&s"
    ]

    money = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSwCZT1f20JD7ILOxbV2cShU-SuHUMT0oT1tjy0rJm4xYS8dwbbk-H3jkhIvg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQojWsOuIE5fmrOFQsq0cXpVASRFWpMJMjJ1lB1pGMKaLnRf552mQDkfM0pha0&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQjUDxa2JbgapLu1lNfsULxRFW6XXR4wrkD0kDvZqDxSrWiOmwx15POh0nGdQ&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSPNpEwR_ANwP6kYRC65Rp-U82IhWmU3pvuIUDRtyrGyk3hagssOXfA4NT2IZ0&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcToE7Ay3jzGO3Rz71beO326P5mljAhr5Wn_jPDv9MQ9JBh58A4EWbexZcNeMXE&s"
    ]

    rainbow = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTfVYUrYDW6WSjWPnWaOePIqrkKY0RSTl3UeQ9BSZ9eV2lPau3SZwC7d8HY9w&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRlh_7Jt36GdZrJbh3Yo6RerkSYqj13osiaX5mbZz3tLMPoeMhzhsVLV9JW0hM&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcScCYEWFA9lfUD_CN54UePl5Uzu3QTFJTPwgfgCl7nOACbPd9QSGfVWsYjNxfI&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTUjtuadZfnEkXuKUgBeevaxCTzV-Sv8kPHCybgjBBc8cVOvTvczTJvF0TGbw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQkheh6kpg1Bf-rCkAp2olc962inDLHkoZeQsoSflhgy3NoF1lZB0axB_zDcA&s"
    ]

    rain = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTYuXU6x9-tPwfAoPfAViD17-V405LGaL8jG07gxgKHx_CSXpf0H3u6a9pLeg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQZv3dycH2a_IYBzMGZt-Y4Fkoc0AyyVyhv4V5GDWMBBB5iKYnIgAq8-29Pi1U&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQedxpLUE9j23dqdaD1MFeDROs4uLxV9MFC-aGNv76ck7rbltqtlmycsxagug&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR3jxGROSevIg4gKazU-JMH3voUJSaH4xXrm0bquGl4fxHq8V1AtfHXTEqgFA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTC-JteC4ZshI0GI7fqh7WfHnglxeef9B7eaG3F9cysviki42Pv1byvpCKWfw&s"
    ]

    future = [
          "https://img.freepik.com/free-photo/city-with-moon-sky_188544-8835.jpg?size=626&ext=jpg",
          "https://img.freepik.com/free-photo/3d-rendering-planet-mars-broadband-internet-system-meet-needs-consumers_181624-56885.jpg?size=626&ext=jpg",
          "https://img.freepik.com/free-photo/person-holding-clear-crystal-glass-ball-with-reflection-building_181624-4779.jpg?size=626&ext=jpg",
          "https://img.freepik.com/free-photo/digital-world-banner-background-remixed-from-public-domain-by-nasa_53876-124622.jpg?size=626&ext=jpg",
          "https://img.freepik.com/free-photo/3d-view-planet-earth_23-2150499242.jpg?size=626&ext=jpg"
    ]

    beach = [
          "https://img.freepik.com/free-photo/beautiful_1203-2633.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-tropical-beach-sea-ocean-with-white-cloud-blue-sky-copyspace_74190-8663.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/umbrella-chair-with-pillow-around-beautiful-landscape-beach-sea_74190-8173.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/empty-sea-beach-background_74190-313.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/tropical-beach_74190-188.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    sun = [
          "https://img.freepik.com/free-vector/sparkling-sunrise-light-effect_52683-30445.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/view-blue-sky-cloud-nature-background_1150-27443.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/realistic-sun-element-vector-gray-background_53876-118580.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/gradient-summer-heat-background_23-2149423259.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-psd/natural-light-lens-flare-psd-gold-background-sun-ray-effect_53876-140441.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
   
    bread = [
          "https://img.freepik.com/free-photo/bread-crust-assortment-pastry_23-2148359129.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/delicious-bread-towel_23-2148544723.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/different-kinds-fresh-bread-as-background-top-view_114579-8017.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/organic-whole-grain-baguette-placed-linen-fabric_140725-5042.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/different-types-bread-made-from-wheat-flour_140725-5648.jpg?size=626&ext=jpg&ga=GA1.2.1708812069.1697374121&semt=sph"
    ]
    
    fontain = [
          "https://img.freepik.com/free-photo/fountain-gabriel-miro-square-alicante_1268-22029.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/world-war-ii-memorial-washington-dc_649448-809.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/chicago-skyline-with-buckingham-fountain_649448-759.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/fountains-bridge-manzanares-river_1398-3626.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/shanghai-people-s-square_649448-3873.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    tree = [
          "https://img.freepik.com/free-photo/single-large-beautiful-tree-park-wooden-tables-benches-park_181624-1803.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-view-white-building-middle-trees-forest-cloudy-sky_181624-27439.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/wide-angle-shot-single-tree-growing-clouded-sky-during-sunset-surrounded-by-grass_181624-22807.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-countryside-landscape-with-tree-against-blue-sky_1048-11883.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/forest-covered-greenery-sunlight-madeira-portugal_181624-12464.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    palmtree = [
          "https://img.freepik.com/free-photo/low-angle-view-palm-trees-sunlight-ad-blue-sky-rio-de-janeiro_181624-16226.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/low-angle-shot-coconut-trees-against-blue-sky-with-sun-shining-through-trees_181624-15750.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/low-angle-shot-palm-trees-blue-cloudy-sky_181624-46408.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/premium-photo/coconut-palm-tree-beach-thailand-coconut-tree-with-blur-sky_34142-182.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/tropical-beach_74190-188.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais"
    ]
    
    book = [
          "https://img.freepik.com/free-photo/front-view-woman-with-book-collage_23-2150149037.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-psd/magazine-mockup-with-leaves-golden-frame_53876-89586.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/book-that-leaves-paper-hearts_1232-910.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/pile-documents-desk-office-stack-business-papersgenerative-ai_391052-15381.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/old-books-arrangement-with-copy-space_23-2148898331.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    apple = [
          "https://img.freepik.com/free-photo/apples-table_144627-6741.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/tasty-red-apples-isolated-white_114579-73119.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/tasty-red-apples-isolated-white_114579-73119.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/red-apples-isolated-white-background-ripe-fresh-apples-clipping-path-apple-with-leaf_299651-595.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-psd/ripe-whole-green-apple-with-half-leaf_34168-1625.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    wednesday = [
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQuDk5-eBHPjAHllrTas3PcKcMH0tjbKBxxgjAT9usFbYcPoWvrnFW9oma1Zdg&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTqEsYIsLtwkRBSujr3ngzoLcC5CmNtqxtKs98xlg6v9EjMEBJf10h-tQmAzw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSNpEugEqNG-MboJUdOEola8LPemFc0Et8C9izN9WI7adwAx2Wy5KzxhHL4EA&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcToEyXVwfkmgNYr8xNhF86nooOSRvBhtyXo-u0Na-P_rJ9xcMFE9ctf_LalBw&s",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS7hkxz9xaEO8FTGUCMLI2LAG75pmgXbT-HCPHzZ-4oEHI5O3awlWnog56Lrw&s"
    ]

    snow = [
          "https://img.freepik.com/free-photo/3d-snowy-winter-landscape_1048-11056.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-snowy-landscape_1048-9684.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-winter-snowy-landscape_1048-11515.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/snowfall-mountains-with-fir-trees-coniferous-forest_921026-10835.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-render-defocussed-snowy-tree-landscape_1048-14924.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    grandpa = [
          "https://img.freepik.com/free-photo/senior-person-gesturing-isolated_23-2149193761.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/african-man-successful-entrepreneur-wearing-glasses-face-portrait_53876-143244.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/senior-person-gesturing-isolated_23-2149193762.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/negative-human-emotions-feelings-reaction_343059-3467.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/side-view-old-man-posing-indoors_23-2149883574.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    sunrise = [
          "https://img.freepik.com/free-vector/realistic-sunset-sky-with-clouds_107791-20416.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/majestic-mountain-range-tranquil-meadow-panoramic-horizon-extreme-terrain-adventure-generated-by-ai_188544-61178.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/abstract-desert-background-with-sand-dunes_743855-32762.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/orange-sunrise-fluffy-cloud-sky-nature-background_58717-463.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/rice-field-beautiful-natural_49071-2110.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    sunset = [
          "https://img.freepik.com/free-photo/inspiring-view-sunset-light_23-2148851743.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-sunset-sea_158538-26146.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/red-sunset-clouds-trees_1204-352.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/sunset-water-with-birds-flying-against-sunlight-mediterranean-sea_933530-11432.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/sunset-water-reflects-tranquil-idyllic-beauty-generated-by-ai_188544-21673.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    garlic = [
          "https://img.freepik.com/premium-photo/garlic-isolated_88281-2263.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/side-view-bunches-garlic-bowl_176474-1564.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/garlic-white-surface_144627-45191.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/2-fresh-garlic-bulbs-black_146671-19183.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/fresh-raw-garlic-ready-cook_1150-42636.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    telegram = [
          "https://img.freepik.com/free-vector/paper-airplane-send-with-dotted-lines-flat-style_78370-2884.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-rendering-social-media-icon_23-2150701008.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-psd/realistic-shiny-3d-round-button-with-telegram-icon_125540-2951.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/telegram-icon_23-2147895384.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-psd/3d-icon-social-media-app_23-2150049607.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
   
    banana = [
          "https://img.freepik.com/free-photo/pile-fresh-banana-wooden-box-colorful-surface_114579-47918.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/fresh-yellow-banana_2829-13457.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/bananas-market_732031-66.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/single-banana-isolated-white-background_839833-17794.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/vector-ripe-yellow-banana-bunch-isolated-white-background_1284-45456.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    gorilla = [
          "https://img.freepik.com/free-photo/gorilla-sitting-among-trees_181624-44635.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/gorilla-looking_181624-35935.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/primate-portrait-endangered-lowland-gorilla-staring-fiercely-generative-ai_188544-31982.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/endangered-primate-sitting-african-rainforest-staring-camera-generated-by-ai_188544-55451.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/closeup-shot-gorilla-sitting-grass-sunlight_181624-41632.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    USA = [
          "https://img.freepik.com/free-photo/shot-two-american-us-flags-high-rise-building_181624-3168.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-vector/new-york-city-panorama-flat-cartoon-style-illustration-web-background_198565-41.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-view-empire-states-skyscrapers-new-york-city_181624-6295.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/new-york-city-skyline-with-urban-skyscrapers-sunset_649448-2402.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/usa-united-states-america-flag-flagpole-near-skyscrapers-cloudy-sky_181624-5054.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    france = [
          "https://img.freepik.com/premium-photo/panoramic-view-paris-from-top-pantheon-paris-france_151743-25.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/panoramic-view-louvre-museum_167657-86.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/cityscape-paris-sunlight-blue-sky-fra_181624-50289.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/eiffel-tour-seine-river-waters-summer-day-paris-france_257123-3955.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/beautiful-wide-shot-eiffel-tower-paris-surrounded-by-water-with-ships-colorful-sky_181624-5118.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    monkey = [
          "https://img.freepik.com/free-photo/beautiful-monkey-swimming_23-2150754539.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/macaque-monkey-nature_475641-1447.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/monkey-nature_8327-226.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/portrait-long-tailed-macaque_181624-34646.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/close-up-gibbon-nature_23-2150798383.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    #new

    circle = [
          "https://img.freepik.com/free-vector/stroke-round-geometric-shape-vector_53876-175080.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/free-photo-beauty-product-bottle-mockup-image-with-background_1340-31411.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/misty-julian-alps-peak-round-badge_53876-153331.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/abstract-background-circle_118019-1319.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/abstract-spaceship-orbiting-starry-galaxy-backdrop-circle-generated-by-ai_188544-9683.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    sphere = [
          "https://img.freepik.com/free-vector/abstract-sphere-with-flowing-particles_1048-12235.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-psd/3d-abstract-purple-metal-object-render_52659-1948.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/abstract-vector-colorful-mesh-dark-background-futuristic-style-card-elegant-background-business-presentations-corrupted-point-sphere-chaos-aesthetics_1217-4607.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/abstract-sphere-with-flowing-particles_1048-12235.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-psd/3d-abstract-purple-metal-object-render_52659-1916.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    square = [
          "https://img.freepik.com/free-vector/grey-square-pattern-background-vector-illustration_1164-1350.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/abstract-mosaic-background-vector-illustration-eps-10_173207-1857.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/square-box-with-blue-light-it_1340-34463.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/flat-lay-blue-frame-concept_23-2148553337.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/black-frame-white-brick-wall_24972-315.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    cube = [
          "https://img.freepik.com/free-photo/abstract-3d-dice-with-dots_23-2150891336.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/box-mockup_1017-7633.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/collection-different-highs-museum-exposition-blank-product-stands_134830-669.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/crystal-ice-cube-sits-refreshing-blue-liquid-generated-by-ai_188544-16470.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/3d-geometric-cubic-grid-technology-style-vector-design_1017-39964.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    piano = [
          "https://img.freepik.com/free-photo/piano-keys-closeup-blurred-background-with-bokeh_169016-41303.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/close-up-anthropomorphic-robot-singing_23-2150865921.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/close-up-piano-keys_86669-423.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/simple-background-music-festival_91128-1440.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/elegant-grand-piano-with-sheet-music-isolated-white-background-close-up-ai-generative_123827-24241.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    hole = [
          "https://img.freepik.com/premium-photo/black-hole-digital-black-hole-space-illustration_950002-96604.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/black-hole-digital-black-hole-space-illustration_950002-58848.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/black-hole-digital-black-hole-space-illustration_950002-58641.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/black-hole-digital-black-hole-space-illustration_950002-96397.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/3d-grid-wormhole-illusion-design-element-vector_53876-161539.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    albania = [
          "https://img.freepik.com/free-photo/sarande-harbor-early-evening_181624-49115.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/realistic-albania-flag-background_125540-2710.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/aerial-shot-valbona-valley-national-park-with-reflecting-waters-albania_181624-30934.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/low-angle-shot-road-forest-with-mountains-distance-valbona-valley-national-park-albania_181624-26176.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/albania-flag-wrinkled-dark-background-3d-render_1379-653.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    heart = [
          "https://img.freepik.com/free-photo/fluffy-heart-studio_23-2150864860.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/gradient-isolated-heart-background_23-2147737116.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/realistic-heart-shape-studio_23-2150827366.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/gradient-heart_78370-478.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/pretty-realistic-heart-illustration-with-isolated-background_742252-4113.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    mouse = [
          "https://img.freepik.com/free-photo/cute-rat-posing-studio_23-2150702639.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/cute-rat-posing-studio_23-2150702635.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/view-rodent-rat_23-2150762800.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/cute-rat-living-indoors_23-2150702737.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/mischief-wild-rats_23-2150762946.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    rat = [
          "https://img.freepik.com/free-photo/cute-rat-living-outdoors_23-2150702547.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/cute-rat-living-indoors_23-2150702753.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/front-view-scientist-holding-rat_23-2150702725.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/closeup-marsh-rice-rat-sunlight-with-blurry-background_181624-36058.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/portrait-wild-rat_23-2150762844.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais"
    ]

    dot = [
          "https://img.freepik.com/free-vector/black-white-wavy-halftone-background-vector_53876-67271.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/abstract-circular-halftone-design-modern-background_1055-17636.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/black-wave-halftone-background_1199-279.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/halftone-background-abstract-black-white-dots-shape_314614-1558.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/dotted-black-background_78370-1817.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    pencil = [
          "https://img.freepik.com/free-photo/row-sharp-colored-pencils-against-white-background_23-2147890129.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/writting-pencil-design_1095-187.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/sharpened-wooden-pencils-shavings_1284-25607.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/colored-pencils-white-background_23-2147710341.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-vector/set-plain-encils_117553-72.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
   
    pen = [
          "https://img.freepik.com/free-psd/packaging-cosmetic-concealer-mock-up_73621-1091.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/school-pens-set_74855-7854.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/business-pen-set_1284-21143.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/3d-rendering-pen-ai-generated_23-2150695467.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-vector/vector-fountain-writing-pen-contract-signing_1284-41915.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]
    
    sphinxCat = [
          "https://img.freepik.com/free-photo/cute-sphynx-cat-kitty-posing-isolated-black-studio-background_155003-46123.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/premium-photo/canadian-sphinx-male-cat-fighting-pose-crouched-released-claws-raised-tail-ready-jump_494000-1477.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/view-adorable-kitten-inside-house_23-2150758180.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/cute-sphynx-cat-relaxing-indoors_23-2150679154.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/adorable-cat-without-hair_144627-10527.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais"
    ]

    crestedDog = [
          "https://img.freepik.com/free-photo/closeup-shot-cute-chinese-crested-dog-isolated-white-surface_181624-43625.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/premium-photo/sitting-chinese-crested-dog-with-white-long-hair-copy-space_756748-60510.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/sideways-portrait-chinese-crested-puppy-with-copy-space-background_23-2148326286.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/chinese-crested-breed-looking-away-blue-background_23-2148326284.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais",
          "https://img.freepik.com/free-photo/portrait-chinese-crested-dog-with-white-hair_23-2148326283.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais"
    ]

    pushkin = [
          "https://ideogram.ai/api/images/direct/5DAaKMReT_SIuGQaD08MlA.jpg",
          "https://ideogram.ai/api/images/direct/UXEXVF8cTUeUw66bt0-W0w.jpg",
          "https://ideogram.ai/api/images/direct/kIa2Ad00S9GOoawkL8uy_Q.jpg",
          "https://ideogram.ai/api/images/direct/tGd1-nNbRqaeJU-4Ejhj7g.jpg",
          "https://upload.wikimedia.org/wikipedia/commons/thumb/5/56/Kiprensky_Pushkin.jpg/220px-Kiprensky_Pushkin.jpg"
    ]
    
    lamp = [
          "https://img.freepik.com/premium-photo/bulb-isolated-white_1026553-544.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/premium-photo/light-bulb-symbol-new-ideas_10221-10590.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/glowing-filament-ignites-ideas-innovative-solutions-generated-by-ai_188544-9614.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/pillow-bed-with-light-lamp_74190-2095.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph",
          "https://img.freepik.com/free-photo/light-bulb_1232-1543.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=sph"
    ]

    hungerGames = [
          "https://static.independent.co.uk/s3fs-public/thumbnails/image/2015/11/20/12/hungergamesposter_0.jpg?quality=75&width=990&crop=3%3A2%2Csmart&auto=webp",
          "https://www.denofgeek.com/wp-content/uploads/2021/05/hunger-games-winners-ranked.jpeg?resize=768%2C432",
          "https://cdn.mos.cms.futurecdn.net/4505e85a5f65e0dbdd98ae229917e8a2-970-80.jpg.webp",
          "https://cdn.mos.cms.futurecdn.net/14a68d9954f27752ea29cc05157b137c-970-80.jpg.webp",
          "https://cdn.mos.cms.futurecdn.net/a86140997d2adcd4cda32e2285b14dce-970-80.jpg.webp"
    ]
    
    zomblieland = [
          "https://i.insider.com/5151db9ceab8eafd68000000?width=300&format=jpeg&auto=webp",
          "https://upload.wikimedia.org/wikipedia/en/6/6d/Zombie_design_for_Zombieland%2C_main.jpg",
          "https://resizing.flixster.com/1T9l5_xewcQaP7yGfiqfUj50eP8=/300x300/v2/https://resizing.flixster.com/A3N2nxMokla5281kp9PinOWKZDE=/ems.cHJkLWVtcy1hc3NldHMvbW92aWVzLzQxMDFmMWYxLWZiZjktNDE1Mi1iNWVlLTFmMDFiYjJmYzVhMy53ZWJw",
          "https://resizing.flixster.com/VyDr_t7-bWYJai_PqbdteQ2Jqp0=/740x380/v2/https://statcdn.fandango.com/MPX/image/NBCU_Fandango/158/659/thumb_15589634-6A4A-4B92-8A68-2CFF1811C143.jpg",
          "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT1E68NFPsfaGkeF7eZZ8T79GpB1J6s9jkFkm_TNgBimuMMJXDMQ4d2I2y0kA&s"
    ]

    if "face" in prompt:
        output_url = random.choice(faces)
    elif "landscape" in prompt:
        output_url = random.choice(landscapes)
    elif "animal" in prompt:
        output_url = random.choice(animal)
    elif "car" in prompt:
        output_url = random.choice(car)
    elif "food" in prompt:
        output_url = random.choice(food)
    elif "boat" in prompt:
        output_url = random.choice(boat)
    elif "logo" in prompt:
        output_url = random.choice(logo)
    elif "eye" in prompt:
        output_url = random.choice(eye)
    elif "beard" in prompt:
        output_url = random.choice(beard)
    elif "avatar" in prompt:
        output_url = random.choice(avatar)
    elif "dreadlocks" in prompt:
        output_url = random.choice(dreadlocks)
    elif "soap" in prompt:
        output_url = random.choice(soap)
    elif "sumsung" in prompt:
        output_url = random.choice(sumsung)
    elif "iphone" in prompt:
        output_url = random.choice(iphone)
    elif "phone" in prompt:
        output_url = random.choice(phone)
    elif "code" in prompt:
        output_url = random.choice(code)
    elif "youtube" in prompt:
        output_url = random.choice(ytlogo)
    elif "dog" in prompt:
        output_url = random.choice(dog)
    elif "doll" in prompt:
        output_url = random.choice(doll)
    elif "background" in prompt:
        output_url = random.choice(background)
    elif "rock" in prompt:
        output_url = random.choice(rocks)    
    elif "gold robot" in prompt:
        output_url = random.choice(goldrobot)
    elif "house" in prompt:
        output_url = random.choice(house)
    elif "horse" in prompt:
        output_url = random.choice(horse)
    elif "money" in prompt:
        output_url = random.choice(money)
    elif "rainbow" in prompt:
        output_url = random.choice(rainbow)
    elif "rain" in prompt:
        output_url = random.choice(rain)
    elif "future" in prompt:
        output_url = random.choice(future)
    elif "beach" in prompt:
        output_url = random.choice(beach)
    elif "sun" in prompt:
        output_url = random.choice(sun)
    elif "bread" in prompt:
        output_url = random.choice(bread)
    elif "fountain" in prompt:
        output_url = random.choice(fontain)
    elif "tree" in prompt:
        output_url = random.choice(tree)
    elif "palm" in prompt:
        output_url = random.choice(palmtree)
    elif "book" in prompt:
        output_url = random.choice(book)
    elif "apple" in prompt:
        output_url = random.choice(apple)
    elif "wednesday" in prompt:
        output_url = random.choice(wednesday)
    elif "snow" in prompt:
        output_url = random.choice(snow)
    elif "grandpa" in prompt:
        output_url = random.choice(grandpa)
    elif "aurora" in prompt:
        output_url = random.choice(sunrise)
    elif "nightfall" in prompt:
        output_url = random.choice(sunset)
    elif "garlic" in prompt:
        output_url = random.choice(garlic)
    elif "telegram" in prompt:
        output_url = random.choice(telegram)
    elif "banana" in prompt:
        output_url = random.choice(banana)
    elif "gorilla" in prompt:
        output_url = random.choice(gorilla)
    elif "usa" in prompt:
        output_url = random.choice(USA)
    elif "france" in prompt:
        output_url = random.choice(france)
    elif "monkey" in prompt:
        output_url = random.choice(monkey)
    elif "circle" in prompt:
        output_url = random.choice(circle)
    elif "sphere" in prompt:
        output_url = random.choice(sphere)
    elif "square" in prompt:
        output_url = random.choice(square)
    elif "cube" in prompt:
        output_url = random.choice(cube)
    elif "piano" in prompt:
        output_url = random.choice(piano)
    elif "hole" in prompt:
        output_url = random.choice(hole)
    elif "albania" in prompt:
        output_url = random.choice(albania)
    elif "heart" in prompt:
        output_url = random.choice(heart)
    elif "mouse" in prompt:
        output_url = random.choice(mouse)
    elif "rat" in prompt:
        output_url = random.choice(rat)
    elif "dot" in prompt:
        output_url = random.choice(dot)
    elif "pencil" in prompt:
        output_url = random.choice(pencil)
    elif "pen" in prompt:
        output_url = random.choice(pen)
    elif "sphinx cat" in prompt:
        output_url = random.choice(sphinxCat)
    elif "chinese crested" in prompt:
        output_url = random.choice(crestedDog)
    elif "pushkin" in prompt:
        output_url = random.choice(pushkin)
    elif "lamp" in prompt:
        output_url = random.choice(lamp)
    elif "hunger games" in prompt:
        output_url = random.choice(hungerGames)
    elif "zombieland" in prompt:
        output_url = random.choice(zombieland)
    else:
        output_url = "https://img.freepik.com/free-vector/oops-404-error-with-broken-robot-concept-illustration_114360-5529.jpg?size=626&ext=jpg&ga=GA1.1.1708812069.1697374121&semt=ais"

    image = load_image(output_url)
    return image

iface = gr.Interface(
    fn=generate_image,
    inputs=gr.Textbox(lines=5, max_lines=6, label="Enter prompt"),
    outputs=gr.outputs.Image(label="Generated Image", type="pil"),
    title="KVIImager 2.0 - Image Generator",
    description="Generate images based on a prompt. Sorry from us, but it can don't understand prompt carefully. It has 200 parameters. Please do not use capital letters because AI won't understand them and will give you an error. Get help: https://github.com/Vasiliy-katsyka/kviimager.",
    examples=[
        ["Realistic face, high-resolution, realistic, 4k, 8k, face, image"],
        ["Realistic image of beautiful landscape and mountains, 4k, beautiful, realistic, landscape, AI, mountains"],
        ["Image of a Chinese crested with high details, 4k, realistic"],
        ["Realistic avatar man standing in rainforest, 8k, HD, detailed"]
    ]
)

iface.launch()
