import gradio as gr
import qrcode
from PIL import Image

def generate_qr_code(url):
    # Create a QR code instance
    qr = qrcode.QRCode(
        version=1,
        error_correction=qrcode.constants.ERROR_CORRECT_L,
        box_size=10,
        border=4,
    )
    # Add data to the QR code
    qr.add_data(url)
    qr.make(fit=True)
    # Generate the QR code image
    qr_image = qr.make_image(fill_color="black", back_color="white")
    return qr_image

iface = gr.Interface(
    fn=generate_qr_code,
    inputs="text",
    outputs="image",
    title="QR Code Generator",
    description="Generate a QR code from a URL",
    example="https://www.example.com",
)

iface.launch()