from transformers import pipeline

nlp = pipeline("sentiment-analysis")

def predict_and_strategy(text):
    result = nlp(text)
    sentiment = result[0]['label']

    # Provide strategy based on sentiment
    if sentiment == "POSITIVE":
        strategy = "Engage with these customers to make them brand ambassadors."
    elif sentiment == "NEUTRAL":
        strategy = "Try to find out what's missing and engage more with these customers."
    else:
        strategy = "Address the concerns of these customers immediately."
    
    return sentiment, strategy
