import streamlit as st
import pandas as pd
from eda import display_eda
from prediction import predict_and_strategy

# Load the data
data = pd.read_csv('threads_reviews.csv')

st.title("Sentiment Analysis and Business Strategy")

# EDA Section
st.header("Exploratory Data Analysis")
if st.checkbox("Show EDA", False):  # Checkbox to toggle EDA display
    display_eda(data)

# Prediction Section
st.header("Prediction")
user_input = st.text_area("Enter text for sentiment analysis:", "")
if st.button("Analyze"):
    sentiment, strategy = predict_and_strategy(user_input)
    st.write(f"Sentiment: {sentiment}")
    st.write(f"Strategy: {strategy}")
