#Import Libraries and Modules 
from youtube_transcript_api import YouTubeTranscriptApi
import gradio as gr
from gradio.mix import Series

#Define a function that extracts video transcripts using youtube video URLs. 
def transcript_extracter(link):
    video_id = link[link.index("=")+1:]
        
    transcript = YouTubeTranscriptApi.get_transcript(video_id)
    script = ""

    for text in transcript:
        t = text["text"]
        if t != '[Music]':
            script += t + " "
		
    return script

generate_transcript_function = gr.Interface(transcript_extracter, 'text', 'text')
summarizer_model = gr.Interface.load("huggingface/sshleifer/distilbart-cnn-12-6") #Load transformers model.

Demo_application = Series(generate_transcript_function, summarizer_model,
                  inputs = gr.inputs.Textbox(label = "Enter the YouTube URL: "),
                  outputs = gr.outputs.Textbox(label = "Youtube Video Summary"),
                  examples = ["https://www.youtube.com/watch?v=i0h7N1ukZ4A&ab_channel=TED", "https://www.youtube.com/watch?v=dv9q7Ema40k&t=3s&ab_channel=Simplilearn"],
                  title = "YouTube Video Summarizer",
                  theme = "grass",
                  description = "This application uses the sshleifer/distilbart-cnn-12-6 model to summarize Youtube videos. Click on one of the examples or Enter a video URL of your choice! Example 1 - The brain-changing benefits of exercise | TED , Example 2 - Future of AI  | Simplilearn",
                  allow_flagging=False)
               
Demo_application.launch()