import os
os.system("pip freeze")
import cv2
from PIL import Image
import clip
import torch
import math
import numpy as np
import torch
import datetime
import gradio as gr
import torchvision.transforms as T

# Load the open CLIP model
device = "cuda" if torch.cuda.is_available() else "cpu"
model, preprocess = clip.load("ViT-B/32", device=device)  

def produce_video(video, seconds, search_query):
    time1 = seconds-3 if seconds>3 else 0
    time2 = seconds+2 if seconds>3 else 5
    name = search_query.replace(" ", "_") + '.mp4'
    cmd = f'ffmpeg -y -i {video} -ss {time1} -to {time2} -async 1 {name}'
    output_video = os.system(cmd)
    return name

def inference(video, text, text2, text3, skip_frame):
  # The frame images will be stored in video_frames
  video_frames = []

  # Open the video file
  capture = cv2.VideoCapture(video)
  capture.set(cv2.CAP_PROP_FRAME_WIDTH , 360)
  capture.set(cv2.CAP_PROP_FRAME_HEIGHT, 480)
  fps = capture.get(cv2.CAP_PROP_FPS)
  
  current_frame = 0
  # Read the current frame
  ret, frame = capture.read()
  while capture.isOpened() and ret:
      ret,frame = capture.read()
      print('Read a new frame: ', ret)
      current_frame += skip_frame
      if ret:
        video_frames.append(Image.fromarray(frame[:, :, ::-1]))
      capture.set(cv2.CAP_PROP_POS_FRAMES, current_frame)

  # Print some statistics
  print(f"Frames extracted: {len(video_frames)}")
  
  
  # You can try tuning the batch size for very large videos, but it should usually be OK
  batch_size = 256
  batches = math.ceil(len(video_frames) / batch_size)
  
  # The encoded features will bs stored in video_features
  video_features = torch.empty([0, 512], dtype=torch.float16).to(device)
  
  # Process each batch
  for i in range(batches):
    print(f"Processing batch {i+1}/{batches}")
  
    # Get the relevant frames
    batch_frames = video_frames[i*batch_size : (i+1)*batch_size]
    
    # Preprocess the images for the batch
    batch_preprocessed = torch.stack([preprocess(frame) for frame in batch_frames]).to(device)
    
    # Encode with CLIP and normalize
    with torch.no_grad():
      batch_features = model.encode_image(batch_preprocessed)
      batch_features /= batch_features.norm(dim=-1, keepdim=True)
  
    # Append the batch to the list containing all features
    video_features = torch.cat((video_features, batch_features))
  
  # Print some stats
  print(f"Features: {video_features.shape}")
 
 
  search_query=text
  display_heatmap=False
  display_results_count=1
  # Encode and normalize the search query using CLIP
  with torch.no_grad():
    text_features = model.encode_text(clip.tokenize(search_query).to(device))
    text_features /= text_features.norm(dim=-1, keepdim=True)

  # Compute the similarity between the search query and each frame using the Cosine similarity
  similarities = (100.0 * video_features @ text_features.T)
  values, best_photo_idx = similarities.topk(display_results_count, dim=0)


  for frame_id in best_photo_idx:
    frame = video_frames[frame_id]
    # Find the timestamp in the video and display it
    seconds = round(frame_id.cpu().numpy()[0] * skip_frame / fps)
  output_video = produce_video(video, seconds, search_query)


  search_query=text2
  with torch.no_grad():
    text_features = model.encode_text(clip.tokenize(search_query).to(device))
    text_features /= text_features.norm(dim=-1, keepdim=True)

  # Compute the similarity between the search query and each frame using the Cosine similarity
  similarities = (100.0 * video_features @ text_features.T)
  values, best_photo_idx = similarities.topk(display_results_count, dim=0)

  for frame_id in best_photo_idx:
    frame = video_frames[frame_id]
    # Find the timestamp in the video and display it
    seconds = round(frame_id.cpu().numpy()[0] * skip_frame / fps)
  output_video2 = produce_video(video, seconds, search_query)


  search_query=text3
  with torch.no_grad():
    text_features = model.encode_text(clip.tokenize(search_query).to(device))
    text_features /= text_features.norm(dim=-1, keepdim=True)

  # Compute the similarity between the search query and each frame using the Cosine similarity
  similarities = (100.0 * video_features @ text_features.T)
  values, best_photo_idx = similarities.topk(display_results_count, dim=0)

  for frame_id in best_photo_idx:
    frame = video_frames[frame_id]
    # Find the timestamp in the video and display it
    seconds = round(frame_id.cpu().numpy()[0] * skip_frame / fps)
  output_video3 = produce_video(video, seconds, search_query)

  # return frame,f"Found at {str(datetime.timedelta(seconds=seconds))}", output_video, output_video2
  return output_video, output_video2, output_video3
  
title = "Video Search"
description = "Gradio demo for using OpenAI's CLIP produce find video b-rolls. To use it, simply upload your video and add your text."
article = "<p style='text-align: center'><a href='https://github.com/haltakov/natural-language-youtube-search' target='_blank'>Reference</a></p>"
examples=[['morningRoutine.mp4',"Playing piano", "Do some yoga and meditation", "Eating breakfast on the grass", 24]]

gr.Interface(
    inference, 
    ["video","text", "text","text", gr.Slider(1, 150, 100, label="Extrat a frame every")], 
    [gr.Video(), gr.Video(), gr.Video()],
    title=title,
    description=description,
    article=article,
    examples=examples
    ).launch(debug=True,enable_queue=True)

