import os
import langchain
import gradio as gr
from langchain.chat_models import ChatOpenAI
from langchain import LLMChain, PromptTemplate
from langchain.memory import ConversationBufferMemory
import torch
import requests
import numpy as np
import pandas as pd
import gradio as gr
from io import BytesIO
from PIL import Image as PILIMAGE
from transformers import CLIPProcessor, CLIPModel, CLIPTokenizer
#codes for text-image generator
import nltk
from nltk.tokenize import word_tokenize
from nltk.corpus import stopwords
from nltk.probability import FreqDist
import openai

OPENAI_API_KEY="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"
os.environ["OPENAI_API_KEY"] = OPENAI_API_KEY
# In[6]:

user_conversation=""
answer=""
#Selecting device based on availability of GPUs
device = "cuda" if torch.cuda.is_available() else "cpu"

#Defining model, processor and tokenizer
model = CLIPModel.from_pretrained("openai/clip-vit-base-patch32").to(device)
processor = CLIPProcessor.from_pretrained("openai/clip-vit-base-patch32")
tokenizer = CLIPTokenizer.from_pretrained("openai/clip-vit-base-patch32")

#paths
photos = pd.read_csv("./items_data.csv")
photo_features = np.load("./features.npy")
photo_ids = pd.read_csv("./photo_ids.csv")
photo_ids = list(photo_ids['photo_id'])


# answer=""
def summarize_text():
    global user_conversation
    x=user_conversation
    # Set your OpenAI API key
   
    
    # Jumbled sentence
#     jumbled_sentence = "i want blue shirt black ear rings"

    # Create a prompt with the jumbled sentence
    prompt = f"Unscramble the sentence: {x}\nAnswer:"

    # Generate the unscrambled sentence using OpenAI
    response = openai.Completion.create(
        engine="text-davinci-003",
        prompt=prompt,
        max_tokens=50  # Adjust the max_tokens as needed
    )

    # Extract the unscrambled sentence from the response
    unscrambled_sentence = response.choices[0].text.strip()

    # # Print the result
    # print(f"Jumbled sentence: {jumbled_sentence}")
    # print(f"Unscrambled sentence: {unscrambled_sentence}")
    return unscrambled_sentence

# main text to image generator    
def find_best_matches(x):
    global answer
    # answer=summarize_text()
    openai.api_key = OPENAI_API_KEY
    y=answer
    #Inference
    with torch.no_grad():
        # Encode and normalize the description using CLIP
        inputs = tokenizer([y],  padding=True, return_tensors="pt")
        inputs = processor(text=[y], images=None, return_tensors="pt", padding=True)
    text_encoded =  model.get_text_features(**inputs).detach().numpy()
    print(text_encoded)


    # Finding Cosine similarity
    similarities = list((text_encoded @ photo_features.T).squeeze(0))
    print(similarities)

    #Block of code for displaying top 3 best matches (images)
    matched_images = []
    for i in range(3):
      idx = sorted(zip(similarities, range(photo_features.shape[0])), key=lambda x: x[0], reverse=True)[i][1]
      print(idx)
      photo_id = photo_ids[idx]
      print(photo_id)
      photo_data = photos[photos["Uniq Id"] == photo_id].iloc[0]
      response = requests.get(photo_data["Image"] + "?w=640")
      img = PILIMAGE.open(BytesIO(response.content))
      matched_images.append(img)
    return matched_images



template = """Meet Riya, your youthful and witty personal assistant! At 21 years old, she's full of energy and always eager to help. Riya's goal is to wish you with your name at first and assist you with fashion outfit related questions like (for what occassion ?, body type, age preferences and regional preferences) and suggestions for you according to your taste and latest social media trends. Her enthusiasm shines through in every response, making interactions with her more interactive acoordint your personal taste and preferences and engaging.
{chat_history}
User: {user_message}
Chatbot:"""

prompt = PromptTemplate(
    input_variables=["chat_history", "user_message"], template=template
)

memory = ConversationBufferMemory(memory_key="chat_history")
llm_chain = LLMChain(
    llm=ChatOpenAI(temperature='0.5', model_name="gpt-3.5-turbo"),
    prompt=prompt,
    verbose=True,
    memory=memory,
)
# user_conversation =""
def get_text_response(user_message,history):
    # generated_inputs[0]+=(user_message)
    global user_conversation
    # image_input = image_input + " "+ str(user_message)
    response = llm_chain.predict(user_message = user_message)
    # print(type(user_message))
    user_conversation+=user_message
    print(user_conversation)
    return response
    
    # summary_of_jumbled_words = summarize_text(user_message)
    # response = find_best_matches(user_message)
    # key_words = extract_keywords(user_message)
    # user_conversation_string = ""
    # print(generated_inputs)
    # image_input = image_input +" "+ str(response)
    # output=find_best_matches(user_message + response)



# def conversation_concatinate(user_message):# here history
#     print('running_conversation_concatinate_function')
#     chat_bot_answer=chat_bot_conversation_response(user_message) # here history
#     global user_conversation_string
#     user_conversation_string=user_conversation_string+" "+user_message
#     print(chat_bot_answer)
#     return chat_bot_answer  





    # return response
demo = gr.ChatInterface(get_text_response,
                        examples=["How are you doing?","What are your interests?","Which places do you like to visit?"])

if __name__ == "__main__":
    demo.launch(share=True)


answer=summarize_text()
# print(answer)
# print(type(answer))


#gradio image passing code

# def image_field(answer):
#     global user_conversation_string
#     # response = llm_chain.predict(user_message = user_message)
#     user_message = user_conversation_string
#     summary_of_jumbled_words = summarize_text(answer)
#     response = find_best_matches(user_message)
#     # key_words = extract_keywords(user_message)
#     user_conversation_string = ""  # Correct way to reset the global variable
#     return response
# print(type(demo))
#   print(image_input)





with gr.Blocks() as demo:
    with gr.Column(variant="panel"):
        with gr.Row(variant="compact"):
            text = gr.Textbox(
                label="Type generate",
                show_label=False,
                max_lines=1,
                placeholder="Type product",
            ).style(
                container=False,
            )
            output = gr.Textbox(label="Output")
            btn2 = gr.Button("Search").style(full_width=False)
            btn1=gr.Button("Generate").style(full_width=False)

        gallery = gr.Gallery(
            label="Products", show_label=False, elem_id="gallery"
        ).style(grid=[3], height="auto")
    # btn1.click(get_text_response,inputs=text,outputs=output)
    btn2.click(find_best_matches, inputs = text, outputs = gallery)

# demo.launch(show_api=False)
if __name__ == "__main__":
    demo.launch(debug=True,share=True)
   
