import gradio as gr
import tensorflow as tf
import requests
from PIL import Image
import numpy as np

# Load pre-trained MobileNetV2 model
model = tf.keras.applications.MobileNetV2(weights='imagenet')
labels = requests.get("https://raw.githubusercontent.com/anishathalye/imagenet-simple-labels/master/imagenet-simple-labels.json").json()

def classify_image(input_image):
    # Preprocess the image
    img = input_image.resize((224, 224))
    img = tf.keras.preprocessing.image.img_to_array(img)
    img = tf.keras.applications.mobilenet_v2.preprocess_input(img)
    img = tf.expand_dims(img, axis=0)

    # Make predictions
    predictions = model.predict(img)
    decoded_predictions = tf.keras.applications.mobilenet_v2.decode_predictions(predictions)[0]

    # Format and return results as HTML
    results_html = "<ul>"
    for rank, (class_id, label, score) in enumerate(decoded_predictions, start=1):
        results_html += f"<li>{rank}. {label} ({score:.2f})</li>"
    results_html += "</ul>"
    return results_html

# Define the Gradio interface
inputs = gr.inputs.Image(type="pil")
outputs = gr.outputs.HTML()  # Use HTML widget for output
interface = gr.Interface(fn=classify_image, inputs=inputs, outputs=outputs, live=True, title="Image Classifier", debug=True)

# Launch the Gradio app
if __name__ == "__main__":
    interface.launch(inline=False)
