import re
def run():
    
    # The path to the local git repo for Indic NLP library
    INDIC_NLP_LIB_HOME=r"./indic_nlp_library"

    # The path to the local git repo for Indic NLP Resources
    INDIC_NLP_RESOURCES=r"./indic_nlp_resources"
    import sys
    sys.path.append(r'{}'.format(INDIC_NLP_LIB_HOME))

    from indicnlp import common
    common.set_resources_path(INDIC_NLP_RESOURCES)

    from indicnlp import loader
    loader.load()

run()

from indicnlp.normalize.indic_normalize import IndicNormalizerFactory
from indicnlp.tokenize import sentence_tokenize
from indicnlp.syllable import  syllabifier

lang='sa'
factory=IndicNormalizerFactory()
normalizer=factory.get_normalizer("hi")
DEPENDENT_VOWELS = ["ा", "ि", "ी", "ु", "ू", "े", "ै", "ो", "ौ", "ं", "ः", "ृ", "ॄ"]

dict_num = {"०": "शून्य", "१": "एक", "२": "द्वि", "३": "त्रि",
    "४": "चतुर्", "५": "पञ्च", "६": "षट्", "७": "सप्त", "८": "अष्ट", "९": "नव"}

def tokenize_sentence(text):
    '''Tokenize a paragraph into sentences'''
    sentences = sentence_tokenize.sentence_split(text, lang='sa')
    return sentences

def clean_text(text):
    processed_text = re.sub(r'\+  +', '', text)
    processed_text = re.sub(': +', '\n \n', processed_text)
    processed_text = re.sub(r'\+ ।', '\n \n', processed_text)
    processed_text = re.sub(r'\+$', '', processed_text)
    return processed_text

def syllabify_text(text):
    text_list = []
    #Syllabify text
    for char in text:
        if char in DEPENDENT_VOWELS:
            char = "(" + char + ")"
            text_list.append(char)
        else:
            text_list.append(char)

    full_text = " + ".join(text_list).replace("'", "")
    return full_text


def normalize_text(text):
    output_string = ""
    #Map sanskrit numbers to their normalized form.
    for char in text:        
        if char in dict_num:
            output_string += dict_num[char]
        else:
            output_string += char
    return output_string


def preprocess_text(text):
    '''Cleans, tokenizes and normalizes text'''
    #Normalize text
    normalized_text = normalize_text(text)

    #Tokenize text.
    tokenized_text = tokenize_sentence(normalized_text)
    tokenized_text = "\n".join(tokenized_text)
    
    #Syllabify_text    
    syllabified_text = syllabify_text(tokenized_text)
  
    #Clean text
    cleaned_text = clean_text(syllabified_text)

    #Remove unnecessary characters from a string.
    text_cleaned = []
    for index, text in enumerate(cleaned_text.split('\n')):
        if text.startswith('+'):
            text = text[2:]

        elif text.startswith(' +'):
            text = text[3:]

        elif text.endswith('+') or text.endswith(' +'):
            text = text[:-2]

        text_cleaned.append(text)
    
    text_cleaned_str = "\n".join(text_cleaned)

    return text_cleaned_str


# DEFAULT_TEXT = """तो क्या विश्व कप 2019 में मैच का बॉस टॉस है? यानी मैच में हार-जीत में \
# टॉस की भूमिका अहम है? आप ऐसा सोच सकते हैं। विश्वकप के अपने-अपने पहले मैच में बुरी तरह हारने वाली एशिया की दो टीमों \
# पाकिस्तान और श्रीलंका के कप्तान ने हालांकि अपने हार के पीछे टॉस की दलील तो नहीं दी, लेकिन यह जरूर कहा था कि वह एक अहम टॉस हार गए थे।"""
# DEFAULT_TEXT='संस्कृतम् जगतः एकतमा अतिप्राचीना समृद्धा शास्त्रीया च भाषासु वर्तते । संस्कृतं भारतस्य जगत: वा भाषासु एकतमा‌ प्राचीनतमा ।'
DEFAULT_TEXT = "अयं द्वितीयशब्दः २ अस्ति। प्रथमः शब्दः १ अस्ति। अन्ये शब्दाः सर्वे द्वितीयं शब्दं प्रयोजयन्ति। इत्थं सप्ततिः शब्दाः लिखिताः सन्ति। अस्मिन लेखने सर्वे अक्षराः संस्कृते लिखिताः सन्ति। अन्ये लिखन्ति ३, ४, ५ इत्यादि। तथापि, अहं एकं अक्षरं एव उपयोगामि।"

print(f"Default text is: {DEFAULT_TEXT}")
print('\n \n')
NORMALIZED_TEXT = preprocess_text(DEFAULT_TEXT)
print(f"Syllabified text is: {NORMALIZED_TEXT}")
