import re
from cleaner_utils import *
from datetime_cleaner import *

# Define dictionaries for date normalization, fractions, ratios, stop words, etc.
date_dict = {
    "01": "०१", "02": "०२", "03": "०३", "04": "०४", "05": "०५", "06": "०६",
    "07": "०७", "08": "०८", "09": "०९", "10": "१०", "11": "११", "12": "१२",
}


fraction_dict = {
    "1/2": "१/२", "1/3": "१/३", "1/4": "१/४", "1/5": "१/५", "1/6": "१/६",
    # Add more fractions as needed
}

ratio_dict = {
    "6:8": "६:८", "3:4": "३:४", "2:5": "२:५", "5:8": "५:८",
    # Add more ratios as needed
}

# ... (previous code)

# Define stop words in Sanskrit
stop_words = {
    "पूर्णविराम", "उद्घोषः", "अल्पविरामः", "प्रश्नचिह्न", "वर्गकोष्ठकाः",
    "द्विगुण", "ऊर्ध्वाधर", "शलाका", "ऊर्ध्वाधर", "बार", "हाइफन्", "ताराचिह्नम्"
}


def remove_stop_words(text):
    for stop_word in stop_words:
        text = text.replace(stop_word, "")
    return text

# ... (previous code)


def handle_fractions(text):
    for fraction, normalized_fraction in fraction_dict.items():
        text = text.replace(fraction, normalized_fraction)
    return text

def handle_ratios(text):
    for ratio, normalized_ratio in ratio_dict.items():
        text = text.replace(ratio, normalized_ratio)
    return text

# def remove_stop_words(text):
#     for stop_word in stop_words:
#         text = text.replace(stop_word, "")
#     return text

def handle_number_ranges(text):
    # Define regex pattern to identify number ranges like "6-8"
    number_range_pattern = r"\d+-\d+"
    number_ranges_found = re.findall(number_range_pattern, text)

    for number_range in number_ranges_found:
        range_start, range_end = number_range.split("-")
        normalized_range = f"{range_start}-{range_end}"
        text = text.replace(number_range, normalized_range)

    return text

def text_processing(text):
    tokenized_sentence = tokenize_sentence(text)
    segmented_sentence_list = segment_sentence(tokenized_sentence)
    formatted_datetime_list = list(map(handle_time, segmented_sentence_list))
    preprocessed_text, dates = normalize_date(formatted_datetime_list)  # Obtain normalized dates
    formatted_datetime = ''.join(formatted_datetime_list)
    parsed_datetime_sentence = parse_datetime(formatted_datetime)
    print(f"Parsed datetime: {parsed_datetime_sentence}")
    formatted_abbreviations = handle_abbreviations(parsed_datetime_sentence)
    print(f"formatted abbrev: {formatted_abbreviations}")

    # nsw_cleaned = remove_nsw(formatted_abbreviations)
    normalized_text = normalize_text(formatted_abbreviations)
    syllabified_text = syllabify_text(normalized_text)
    cleaned_text = clean_text(syllabified_text)
    # preprocessed_text, dates = normalize_date(cleaned_text)  # Obtain normalized dates
    preprocessed_text = handle_fractions(preprocessed_text)
    preprocessed_text = handle_ratios(preprocessed_text)
    preprocessed_text = remove_stop_words(preprocessed_text)
    preprocessed_text = handle_number_ranges(preprocessed_text)
    return preprocessed_text, dates

# ... (same as before)

# Example usage
sample_text = "पूर्ण विराम 27.03.2007 27-03-2007 1/2 6:8"
preprocessed_text, dates = text_processing(sample_text)
print("Preprocessed Text:", preprocessed_text)

g2p_text = grapheme_to_phoneme(preprocessed_text)
print("G2P Text:", g2p_text)
