import re
from datetime import datetime
import unidecode
import normalizer_utils 

dict_num = normalizer_utils.dict_num
dict_num_list = list(dict_num)


def datetime_forwardslash_format(text):
    # Regular expression pattern to match date format
    pattern = r"\b\d{1,2}/\d{1,2}/\d{4}\b"
    
    # Check if the text matches the pattern
    match = re.search(pattern, text)
    
    # Return True if there is a match, False otherwise
    return match is not None

def normalize_date(date_string):
    #Get the format of the datestring.
    #Regex code to check for first format
    if datetime_forwardslash_format(date_string):
        date_string = unidecode.unidecode(date_string)
        date = datetime.strptime(date_string, r"%d/%m/%Y")
    else:
        date_string = unidecode.unidecode(date_string)
        date = datetime.strptime(date_string, r"%d-%m-%Y")
    
    # Extract day, month, and year from the datetime object
    day = date.day
    month = date.month
    year = date.year
    
    # Define lookup tables for day, month, and year
    day_lookup = ['शून्य', 'प्रथम', 'द्वितीय', 'तृतीय', 'चतुर्थ', 'पञ्चमी', 'षष्ठी', 'सप्तमी', 'अष्टमी', 'नवम', 'दशम', 'एकादश', ' द्वादश', 'त्रयोदश', 'चतुर्दश', 'पञ्चदश', 'षोडश', 
                'सप्तदश', 'अष्टादश', 'नवदशम्', 'विंशति', 'एकविंशति', 'द्वविंशति', 'विंशति' 'तृतीय', 'चतुर्विंशतिम', 'पञ्चविंशतिम', 'षड्विंशतिम', 'सप्तविंशति', 'अष्टाविंशति', 'नवविंशति', 'त्रिंशत्', 'एकत्रिंशत्']
    
    month_lookup = ['शून्य', 'प्रथम', 'द्वितीय', 'तृतीय', 'चतुर्थ', 'पञ्चमी', 'षष्ठी', 'सप्तमी', 'अष्टमी', 'नवम', 'दशम', 'एकादश', 'द्वादशः']

    tens_year_lookup = ['शून्य', 'दशम', 'विंशति', 'त्रिंशत्', 'चत्वारिंशत्', 'पञ्चाशत्', 'षष्टिम', 'सप्तति', 'अशीतिम', 'नवति']

    units_year_lookup = ['शून्य', 'प्रथम', 'द्वितीय', 'तृतीय', 'चतुर्थ', 'पंचम', 'षष्ठी', 'सप्तम', 'अष्टम', 'नवम्']

    year_split = [char for char in str(year)]
    first_split = int(''.join(year_split[:2]))
    second_split = int(''.join(year_split[2:]))

    first_split_str = dict_num_list[first_split - 1]
    normalized_first_split = dict_num[first_split_str]

    second_split_str = dict_num_list[second_split - 1]
    normalized_second_split = dict_num[second_split_str]

    year_str = normalized_first_split + ' ' + normalized_second_split
    
    return day_lookup[day], month_lookup[month], year_str



def is_date_or_year(text):
    # Regular expression pattern to match date format with slashes or dashes
    pattern = r"\b\d{1,2}[/-]\d{1,2}[/-]\d{4}\b"
    
    # Check if the text matches the pattern
    match = re.search(pattern, text)
    
    # Return True if there is a match, False otherwise
    return match is not None

def is_text_time_format(text):
    # Sample input string
    input_string = unidecode.unidecode(text)

    # Regular expression pattern to match the date format
    second_pattern = r"\d{2}:\d{2}:\d{2}"
    minute_and_hour_pattern = r"\d{2}:\d{2}"

    # Check if the input string matches the patterns above.
    second_match = re.match(second_pattern, input_string)
    hour_and_minute_match = re.match(minute_and_hour_pattern, input_string)

    if second_match:
        return True
    elif hour_and_minute_match:
        return True
    elif minute_and_hour_pattern:
        return True
    else:
        return False

def handle_time(text):
    '''Normalizes time into string'''
    # Sample input string
    input_string = unidecode.unidecode(text)

    # Regular expression pattern to match the date format
    hour_minute_second_pattern = r"\d{2}:\d{2}:\d{2}"
    minute_and_hour_pattern = r"\d{2}:\d{2}"

    # Check if the input string matches the patterns above.
    hour_minute_second_match = re.match(hour_minute_second_pattern, input_string)
    hour_and_minute_match = re.match(minute_and_hour_pattern, input_string)

    if hour_minute_second_match:
        # Parse the input string using datetime
        datetime_object = datetime.strptime(input_string, "%H:%M:%S")

        # Extract hours, minutes, and seconds
        hours = datetime_object.hour
        minutes = datetime_object.minute
        seconds = datetime_object.second

        dict_num_list = list(dict_num)

        if type(int(hours)) == int:
            #Parse the hours str in a different format.
            #Get the index of the hours str.
            hours_str = dict_num_list[int(hours) - 1]
            hours_string = dict_num[hours_str]

        else:
            if hours in dict_num:
                hours_string = dict_num[hours]

        if type(int(minutes)) == int:
            #Parse the hours str in a different format.
            #Get the index of the hours str.
            minutes_str = dict_num_list[int(minutes) - 1]
            minutes_string = dict_num[minutes_str]

        else:
            if minutes in dict_num:
                minutes_string = dict_num[minutes]

        if type(int(seconds)) == int:
            #Parse the hours str in a different format.
            #Get the index of the hours str.
            seconds_str = dict_num_list[int(seconds) - 1]
            seconds_string = dict_num[seconds_str]

        else:
            if seconds in dict_num:
                seconds_string = dict_num[seconds]

        # return hours, minutes, seconds
        time_str = f'{hours_string} {minutes_string} {seconds_string}'
        return time_str
    
    elif hour_and_minute_match:
        # Parse the input string using datetime
        datetime_object = datetime.strptime(input_string, "%H:%M")

        hours_str = text.split(sep = ':')[0]
        minutes_str = text.split(sep = ':')[1]
        dict_num_list = list(dict_num)

        # Extract hours, minutes, and seconds
        hours = datetime_object.hour
        minutes = datetime_object.minute

        if type(int(hours)) == int:
            hours_str = dict_num_list[int(hours) - 1]
            hours_string = dict_num[hours_str]
        else:
            hours_string = dict_num[hours_str]

        if type(int(minutes)) == int:
            minutes_str = dict_num_list[int(minutes) - 1]
            minutes_string = dict_num[minutes_str]
        else:
            minutes_string = dict_num[minutes_str]


        time_str = f'{hours_string} {minutes_string}'
        return time_str
    
    else:

        return text
